/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://code.google.com/p/google-apis-client-generator/
 * (build: 2014-07-22 21:53:01 UTC)
 * on 2014-10-09 at 03:30:26 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.youtube.model;

/**
 * Details about a resource which is being promoted.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the YouTube Data API. For a detailed explanation see:
 * <a href="http://code.google.com/p/google-http-java-client/wiki/JSON">http://code.google.com/p/google-http-java-client/wiki/JSON</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ActivityContentDetailsPromotedItem extends com.google.api.client.json.GenericJson {

  /**
   * The URL the client should fetch to request a promoted item.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String adTag;

  /**
   * The URL the client should ping to indicate that the user clicked through on this promoted item.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String clickTrackingUrl;

  /**
   * The URL the client should ping to indicate that the user was shown this promoted item.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String creativeViewUrl;

  /**
   * The type of call-to-action, a message to the user indicating action that can be taken.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String ctaType;

  /**
   * The custom call-to-action button text. If specified, it will override the default button text
   * for the cta_type.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String customCtaButtonText;

  /**
   * The text description to accompany the promoted item.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String descriptionText;

  /**
   * The URL the client should direct the user to, if the user chooses to visit the advertiser's
   * website.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String destinationUrl;

  /**
   * The list of forecasting URLs. The client should ping all of these URLs when a promoted item is
   * not available, to indicate that a promoted item could have been shown.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> forecastingUrl;

  /**
   * The list of impression URLs. The client should ping all of these URLs to indicate that the user
   * was shown this promoted item.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> impressionUrl;

  /**
   * The ID that YouTube uses to uniquely identify the promoted video.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String videoId;

  /**
   * The URL the client should fetch to request a promoted item.
   * @return value or {@code null} for none
   */
  public java.lang.String getAdTag() {
    return adTag;
  }

  /**
   * The URL the client should fetch to request a promoted item.
   * @param adTag adTag or {@code null} for none
   */
  public ActivityContentDetailsPromotedItem setAdTag(java.lang.String adTag) {
    this.adTag = adTag;
    return this;
  }

  /**
   * The URL the client should ping to indicate that the user clicked through on this promoted item.
   * @return value or {@code null} for none
   */
  public java.lang.String getClickTrackingUrl() {
    return clickTrackingUrl;
  }

  /**
   * The URL the client should ping to indicate that the user clicked through on this promoted item.
   * @param clickTrackingUrl clickTrackingUrl or {@code null} for none
   */
  public ActivityContentDetailsPromotedItem setClickTrackingUrl(java.lang.String clickTrackingUrl) {
    this.clickTrackingUrl = clickTrackingUrl;
    return this;
  }

  /**
   * The URL the client should ping to indicate that the user was shown this promoted item.
   * @return value or {@code null} for none
   */
  public java.lang.String getCreativeViewUrl() {
    return creativeViewUrl;
  }

  /**
   * The URL the client should ping to indicate that the user was shown this promoted item.
   * @param creativeViewUrl creativeViewUrl or {@code null} for none
   */
  public ActivityContentDetailsPromotedItem setCreativeViewUrl(java.lang.String creativeViewUrl) {
    this.creativeViewUrl = creativeViewUrl;
    return this;
  }

  /**
   * The type of call-to-action, a message to the user indicating action that can be taken.
   * @return value or {@code null} for none
   */
  public java.lang.String getCtaType() {
    return ctaType;
  }

  /**
   * The type of call-to-action, a message to the user indicating action that can be taken.
   * @param ctaType ctaType or {@code null} for none
   */
  public ActivityContentDetailsPromotedItem setCtaType(java.lang.String ctaType) {
    this.ctaType = ctaType;
    return this;
  }

  /**
   * The custom call-to-action button text. If specified, it will override the default button text
   * for the cta_type.
   * @return value or {@code null} for none
   */
  public java.lang.String getCustomCtaButtonText() {
    return customCtaButtonText;
  }

  /**
   * The custom call-to-action button text. If specified, it will override the default button text
   * for the cta_type.
   * @param customCtaButtonText customCtaButtonText or {@code null} for none
   */
  public ActivityContentDetailsPromotedItem setCustomCtaButtonText(java.lang.String customCtaButtonText) {
    this.customCtaButtonText = customCtaButtonText;
    return this;
  }

  /**
   * The text description to accompany the promoted item.
   * @return value or {@code null} for none
   */
  public java.lang.String getDescriptionText() {
    return descriptionText;
  }

  /**
   * The text description to accompany the promoted item.
   * @param descriptionText descriptionText or {@code null} for none
   */
  public ActivityContentDetailsPromotedItem setDescriptionText(java.lang.String descriptionText) {
    this.descriptionText = descriptionText;
    return this;
  }

  /**
   * The URL the client should direct the user to, if the user chooses to visit the advertiser's
   * website.
   * @return value or {@code null} for none
   */
  public java.lang.String getDestinationUrl() {
    return destinationUrl;
  }

  /**
   * The URL the client should direct the user to, if the user chooses to visit the advertiser's
   * website.
   * @param destinationUrl destinationUrl or {@code null} for none
   */
  public ActivityContentDetailsPromotedItem setDestinationUrl(java.lang.String destinationUrl) {
    this.destinationUrl = destinationUrl;
    return this;
  }

  /**
   * The list of forecasting URLs. The client should ping all of these URLs when a promoted item is
   * not available, to indicate that a promoted item could have been shown.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getForecastingUrl() {
    return forecastingUrl;
  }

  /**
   * The list of forecasting URLs. The client should ping all of these URLs when a promoted item is
   * not available, to indicate that a promoted item could have been shown.
   * @param forecastingUrl forecastingUrl or {@code null} for none
   */
  public ActivityContentDetailsPromotedItem setForecastingUrl(java.util.List<java.lang.String> forecastingUrl) {
    this.forecastingUrl = forecastingUrl;
    return this;
  }

  /**
   * The list of impression URLs. The client should ping all of these URLs to indicate that the user
   * was shown this promoted item.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getImpressionUrl() {
    return impressionUrl;
  }

  /**
   * The list of impression URLs. The client should ping all of these URLs to indicate that the user
   * was shown this promoted item.
   * @param impressionUrl impressionUrl or {@code null} for none
   */
  public ActivityContentDetailsPromotedItem setImpressionUrl(java.util.List<java.lang.String> impressionUrl) {
    this.impressionUrl = impressionUrl;
    return this;
  }

  /**
   * The ID that YouTube uses to uniquely identify the promoted video.
   * @return value or {@code null} for none
   */
  public java.lang.String getVideoId() {
    return videoId;
  }

  /**
   * The ID that YouTube uses to uniquely identify the promoted video.
   * @param videoId videoId or {@code null} for none
   */
  public ActivityContentDetailsPromotedItem setVideoId(java.lang.String videoId) {
    this.videoId = videoId;
    return this;
  }

  @Override
  public ActivityContentDetailsPromotedItem set(String fieldName, Object value) {
    return (ActivityContentDetailsPromotedItem) super.set(fieldName, value);
  }

  @Override
  public ActivityContentDetailsPromotedItem clone() {
    return (ActivityContentDetailsPromotedItem) super.clone();
  }

}
