/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://code.google.com/p/google-apis-client-generator/
 * (build: 2014-07-22 21:53:01 UTC)
 * on 2014-10-09 at 03:30:26 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.youtube.model;

/**
 * A channel resource contains information about a YouTube channel.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the YouTube Data API. For a detailed explanation see:
 * <a href="http://code.google.com/p/google-http-java-client/wiki/JSON">http://code.google.com/p/google-http-java-client/wiki/JSON</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Channel extends com.google.api.client.json.GenericJson {

  /**
   * The auditionDetails object encapsulates channel data that is relevant for YouTube Partners
   * during the audition process.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ChannelAuditDetails auditDetails;

  /**
   * The brandingSettings object encapsulates information about the branding of the channel.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ChannelBrandingSettings brandingSettings;

  /**
   * The contentDetails object encapsulates information about the channel's content.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ChannelContentDetails contentDetails;

  /**
   * The contentOwnerDetails object encapsulates channel data that is relevant for YouTube Partners
   * linked with the channel.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ChannelContentOwnerDetails contentOwnerDetails;

  /**
   * The conversionPings object encapsulates information about conversion pings that need to be
   * respected by the channel.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ChannelConversionPings conversionPings;

  /**
   * Etag of this resource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String etag;

  /**
   * The ID that YouTube uses to uniquely identify the channel.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String id;

  /**
   * The invideoPromotion object encapsulates information about promotion campaign associated with
   * the channel.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private InvideoPromotion invideoPromotion;

  /**
   * Identifies what kind of resource this is. Value: the fixed string "youtube#channel".
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * The snippet object contains basic details about the channel, such as its title, description,
   * and thumbnail images.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ChannelSnippet snippet;

  /**
   * The statistics object encapsulates statistics for the channel.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ChannelStatistics statistics;

  /**
   * The status object encapsulates information about the privacy status of the channel.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ChannelStatus status;

  /**
   * The topicDetails object encapsulates information about Freebase topics associated with the
   * channel.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ChannelTopicDetails topicDetails;

  /**
   * The auditionDetails object encapsulates channel data that is relevant for YouTube Partners
   * during the audition process.
   * @return value or {@code null} for none
   */
  public ChannelAuditDetails getAuditDetails() {
    return auditDetails;
  }

  /**
   * The auditionDetails object encapsulates channel data that is relevant for YouTube Partners
   * during the audition process.
   * @param auditDetails auditDetails or {@code null} for none
   */
  public Channel setAuditDetails(ChannelAuditDetails auditDetails) {
    this.auditDetails = auditDetails;
    return this;
  }

  /**
   * The brandingSettings object encapsulates information about the branding of the channel.
   * @return value or {@code null} for none
   */
  public ChannelBrandingSettings getBrandingSettings() {
    return brandingSettings;
  }

  /**
   * The brandingSettings object encapsulates information about the branding of the channel.
   * @param brandingSettings brandingSettings or {@code null} for none
   */
  public Channel setBrandingSettings(ChannelBrandingSettings brandingSettings) {
    this.brandingSettings = brandingSettings;
    return this;
  }

  /**
   * The contentDetails object encapsulates information about the channel's content.
   * @return value or {@code null} for none
   */
  public ChannelContentDetails getContentDetails() {
    return contentDetails;
  }

  /**
   * The contentDetails object encapsulates information about the channel's content.
   * @param contentDetails contentDetails or {@code null} for none
   */
  public Channel setContentDetails(ChannelContentDetails contentDetails) {
    this.contentDetails = contentDetails;
    return this;
  }

  /**
   * The contentOwnerDetails object encapsulates channel data that is relevant for YouTube Partners
   * linked with the channel.
   * @return value or {@code null} for none
   */
  public ChannelContentOwnerDetails getContentOwnerDetails() {
    return contentOwnerDetails;
  }

  /**
   * The contentOwnerDetails object encapsulates channel data that is relevant for YouTube Partners
   * linked with the channel.
   * @param contentOwnerDetails contentOwnerDetails or {@code null} for none
   */
  public Channel setContentOwnerDetails(ChannelContentOwnerDetails contentOwnerDetails) {
    this.contentOwnerDetails = contentOwnerDetails;
    return this;
  }

  /**
   * The conversionPings object encapsulates information about conversion pings that need to be
   * respected by the channel.
   * @return value or {@code null} for none
   */
  public ChannelConversionPings getConversionPings() {
    return conversionPings;
  }

  /**
   * The conversionPings object encapsulates information about conversion pings that need to be
   * respected by the channel.
   * @param conversionPings conversionPings or {@code null} for none
   */
  public Channel setConversionPings(ChannelConversionPings conversionPings) {
    this.conversionPings = conversionPings;
    return this;
  }

  /**
   * Etag of this resource.
   * @return value or {@code null} for none
   */
  public java.lang.String getEtag() {
    return etag;
  }

  /**
   * Etag of this resource.
   * @param etag etag or {@code null} for none
   */
  public Channel setEtag(java.lang.String etag) {
    this.etag = etag;
    return this;
  }

  /**
   * The ID that YouTube uses to uniquely identify the channel.
   * @return value or {@code null} for none
   */
  public java.lang.String getId() {
    return id;
  }

  /**
   * The ID that YouTube uses to uniquely identify the channel.
   * @param id id or {@code null} for none
   */
  public Channel setId(java.lang.String id) {
    this.id = id;
    return this;
  }

  /**
   * The invideoPromotion object encapsulates information about promotion campaign associated with
   * the channel.
   * @return value or {@code null} for none
   */
  public InvideoPromotion getInvideoPromotion() {
    return invideoPromotion;
  }

  /**
   * The invideoPromotion object encapsulates information about promotion campaign associated with
   * the channel.
   * @param invideoPromotion invideoPromotion or {@code null} for none
   */
  public Channel setInvideoPromotion(InvideoPromotion invideoPromotion) {
    this.invideoPromotion = invideoPromotion;
    return this;
  }

  /**
   * Identifies what kind of resource this is. Value: the fixed string "youtube#channel".
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * Identifies what kind of resource this is. Value: the fixed string "youtube#channel".
   * @param kind kind or {@code null} for none
   */
  public Channel setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * The snippet object contains basic details about the channel, such as its title, description,
   * and thumbnail images.
   * @return value or {@code null} for none
   */
  public ChannelSnippet getSnippet() {
    return snippet;
  }

  /**
   * The snippet object contains basic details about the channel, such as its title, description,
   * and thumbnail images.
   * @param snippet snippet or {@code null} for none
   */
  public Channel setSnippet(ChannelSnippet snippet) {
    this.snippet = snippet;
    return this;
  }

  /**
   * The statistics object encapsulates statistics for the channel.
   * @return value or {@code null} for none
   */
  public ChannelStatistics getStatistics() {
    return statistics;
  }

  /**
   * The statistics object encapsulates statistics for the channel.
   * @param statistics statistics or {@code null} for none
   */
  public Channel setStatistics(ChannelStatistics statistics) {
    this.statistics = statistics;
    return this;
  }

  /**
   * The status object encapsulates information about the privacy status of the channel.
   * @return value or {@code null} for none
   */
  public ChannelStatus getStatus() {
    return status;
  }

  /**
   * The status object encapsulates information about the privacy status of the channel.
   * @param status status or {@code null} for none
   */
  public Channel setStatus(ChannelStatus status) {
    this.status = status;
    return this;
  }

  /**
   * The topicDetails object encapsulates information about Freebase topics associated with the
   * channel.
   * @return value or {@code null} for none
   */
  public ChannelTopicDetails getTopicDetails() {
    return topicDetails;
  }

  /**
   * The topicDetails object encapsulates information about Freebase topics associated with the
   * channel.
   * @param topicDetails topicDetails or {@code null} for none
   */
  public Channel setTopicDetails(ChannelTopicDetails topicDetails) {
    this.topicDetails = topicDetails;
    return this;
  }

  @Override
  public Channel set(String fieldName, Object value) {
    return (Channel) super.set(fieldName, value);
  }

  @Override
  public Channel clone() {
    return (Channel) super.clone();
  }

}
