/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://code.google.com/p/google-apis-client-generator/
 * (build: 2014-07-22 21:53:01 UTC)
 * on 2014-10-09 at 03:30:26 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.youtube.model;

/**
 * Branding properties of a YouTube channel.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the YouTube Data API. For a detailed explanation see:
 * <a href="http://code.google.com/p/google-http-java-client/wiki/JSON">http://code.google.com/p/google-http-java-client/wiki/JSON</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ChannelBrandingSettings extends com.google.api.client.json.GenericJson {

  /**
   * Branding properties for the channel view.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ChannelSettings channel;

  /**
   * Additional experimental branding properties.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<PropertyValue> hints;

  static {
    // hack to force ProGuard to consider PropertyValue used, since otherwise it would be stripped out
    // see http://code.google.com/p/google-api-java-client/issues/detail?id=528
    com.google.api.client.util.Data.nullOf(PropertyValue.class);
  }

  /**
   * Branding properties for branding images.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ImageSettings image;

  /**
   * Branding properties for the watch page.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private WatchSettings watch;

  /**
   * Branding properties for the channel view.
   * @return value or {@code null} for none
   */
  public ChannelSettings getChannel() {
    return channel;
  }

  /**
   * Branding properties for the channel view.
   * @param channel channel or {@code null} for none
   */
  public ChannelBrandingSettings setChannel(ChannelSettings channel) {
    this.channel = channel;
    return this;
  }

  /**
   * Additional experimental branding properties.
   * @return value or {@code null} for none
   */
  public java.util.List<PropertyValue> getHints() {
    return hints;
  }

  /**
   * Additional experimental branding properties.
   * @param hints hints or {@code null} for none
   */
  public ChannelBrandingSettings setHints(java.util.List<PropertyValue> hints) {
    this.hints = hints;
    return this;
  }

  /**
   * Branding properties for branding images.
   * @return value or {@code null} for none
   */
  public ImageSettings getImage() {
    return image;
  }

  /**
   * Branding properties for branding images.
   * @param image image or {@code null} for none
   */
  public ChannelBrandingSettings setImage(ImageSettings image) {
    this.image = image;
    return this;
  }

  /**
   * Branding properties for the watch page.
   * @return value or {@code null} for none
   */
  public WatchSettings getWatch() {
    return watch;
  }

  /**
   * Branding properties for the watch page.
   * @param watch watch or {@code null} for none
   */
  public ChannelBrandingSettings setWatch(WatchSettings watch) {
    this.watch = watch;
    return this;
  }

  @Override
  public ChannelBrandingSettings set(String fieldName, Object value) {
    return (ChannelBrandingSettings) super.set(fieldName, value);
  }

  @Override
  public ChannelBrandingSettings clone() {
    return (ChannelBrandingSettings) super.clone();
  }

}
