/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://code.google.com/p/google-apis-client-generator/
 * (build: 2014-07-22 21:53:01 UTC)
 * on 2014-10-09 at 03:30:26 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.youtube.model;

/**
 * The conversionPings object encapsulates information about conversion pings that need to be
 * respected by the channel.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the YouTube Data API. For a detailed explanation see:
 * <a href="http://code.google.com/p/google-http-java-client/wiki/JSON">http://code.google.com/p/google-http-java-client/wiki/JSON</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ChannelConversionPings extends com.google.api.client.json.GenericJson {

  /**
   * Pings that the app shall fire (authenticated by biscotti cookie). Each ping has a context, in
   * which the app must fire the ping, and a url identifying the ping.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<ChannelConversionPing> pings;

  static {
    // hack to force ProGuard to consider ChannelConversionPing used, since otherwise it would be stripped out
    // see http://code.google.com/p/google-api-java-client/issues/detail?id=528
    com.google.api.client.util.Data.nullOf(ChannelConversionPing.class);
  }

  /**
   * Pings that the app shall fire (authenticated by biscotti cookie). Each ping has a context, in
   * which the app must fire the ping, and a url identifying the ping.
   * @return value or {@code null} for none
   */
  public java.util.List<ChannelConversionPing> getPings() {
    return pings;
  }

  /**
   * Pings that the app shall fire (authenticated by biscotti cookie). Each ping has a context, in
   * which the app must fire the ping, and a url identifying the ping.
   * @param pings pings or {@code null} for none
   */
  public ChannelConversionPings setPings(java.util.List<ChannelConversionPing> pings) {
    this.pings = pings;
    return this;
  }

  @Override
  public ChannelConversionPings set(String fieldName, Object value) {
    return (ChannelConversionPings) super.set(fieldName, value);
  }

  @Override
  public ChannelConversionPings clone() {
    return (ChannelConversionPings) super.clone();
  }

}
