/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://code.google.com/p/google-apis-client-generator/
 * (build: 2014-07-22 21:53:01 UTC)
 * on 2014-10-09 at 03:30:26 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.youtube.model;

/**
 * Basic details about an i18n language, such as language code and human-readable name.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the YouTube Data API. For a detailed explanation see:
 * <a href="http://code.google.com/p/google-http-java-client/wiki/JSON">http://code.google.com/p/google-http-java-client/wiki/JSON</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class I18nLanguageSnippet extends com.google.api.client.json.GenericJson {

  /**
   * A short BCP-47 code that uniquely identifies a language.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String hl;

  /**
   * The human-readable name of the language in the language itself.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * A short BCP-47 code that uniquely identifies a language.
   * @return value or {@code null} for none
   */
  public java.lang.String getHl() {
    return hl;
  }

  /**
   * A short BCP-47 code that uniquely identifies a language.
   * @param hl hl or {@code null} for none
   */
  public I18nLanguageSnippet setHl(java.lang.String hl) {
    this.hl = hl;
    return this;
  }

  /**
   * The human-readable name of the language in the language itself.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * The human-readable name of the language in the language itself.
   * @param name name or {@code null} for none
   */
  public I18nLanguageSnippet setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  @Override
  public I18nLanguageSnippet set(String fieldName, Object value) {
    return (I18nLanguageSnippet) super.set(fieldName, value);
  }

  @Override
  public I18nLanguageSnippet clone() {
    return (I18nLanguageSnippet) super.clone();
  }

}
