/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://code.google.com/p/google-apis-client-generator/
 * (build: 2014-07-22 21:53:01 UTC)
 * on 2014-10-09 at 03:30:26 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.youtube.model;

/**
 * Describes a single promoted item.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the YouTube Data API. For a detailed explanation see:
 * <a href="http://code.google.com/p/google-http-java-client/wiki/JSON">http://code.google.com/p/google-http-java-client/wiki/JSON</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class PromotedItem extends com.google.api.client.json.GenericJson {

  /**
   * A custom message to display for this promotion. This field is currently ignored unless the
   * promoted item is a website.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String customMessage;

  /**
   * Identifies the promoted item.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private PromotedItemId id;

  /**
   * If true, the content owner's name will be used when displaying the promotion. This field can
   * only be set when the update is made on behalf of the content owner.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean promotedByContentOwner;

  /**
   * The temporal position within the video where the promoted item will be displayed. If present,
   * it overrides the default timing.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private InvideoTiming timing;

  /**
   * A custom message to display for this promotion. This field is currently ignored unless the
   * promoted item is a website.
   * @return value or {@code null} for none
   */
  public java.lang.String getCustomMessage() {
    return customMessage;
  }

  /**
   * A custom message to display for this promotion. This field is currently ignored unless the
   * promoted item is a website.
   * @param customMessage customMessage or {@code null} for none
   */
  public PromotedItem setCustomMessage(java.lang.String customMessage) {
    this.customMessage = customMessage;
    return this;
  }

  /**
   * Identifies the promoted item.
   * @return value or {@code null} for none
   */
  public PromotedItemId getId() {
    return id;
  }

  /**
   * Identifies the promoted item.
   * @param id id or {@code null} for none
   */
  public PromotedItem setId(PromotedItemId id) {
    this.id = id;
    return this;
  }

  /**
   * If true, the content owner's name will be used when displaying the promotion. This field can
   * only be set when the update is made on behalf of the content owner.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getPromotedByContentOwner() {
    return promotedByContentOwner;
  }

  /**
   * If true, the content owner's name will be used when displaying the promotion. This field can
   * only be set when the update is made on behalf of the content owner.
   * @param promotedByContentOwner promotedByContentOwner or {@code null} for none
   */
  public PromotedItem setPromotedByContentOwner(java.lang.Boolean promotedByContentOwner) {
    this.promotedByContentOwner = promotedByContentOwner;
    return this;
  }

  /**
   * The temporal position within the video where the promoted item will be displayed. If present,
   * it overrides the default timing.
   * @return value or {@code null} for none
   */
  public InvideoTiming getTiming() {
    return timing;
  }

  /**
   * The temporal position within the video where the promoted item will be displayed. If present,
   * it overrides the default timing.
   * @param timing timing or {@code null} for none
   */
  public PromotedItem setTiming(InvideoTiming timing) {
    this.timing = timing;
    return this;
  }

  @Override
  public PromotedItem set(String fieldName, Object value) {
    return (PromotedItem) super.set(fieldName, value);
  }

  @Override
  public PromotedItem clone() {
    return (PromotedItem) super.clone();
  }

}
