/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://code.google.com/p/google-apis-client-generator/
 * (build: 2014-07-22 21:53:01 UTC)
 * on 2014-10-09 at 03:30:26 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.youtube.model;

/**
 * Basic details about a subscription, including title, description and thumbnails of the subscribed
 * item.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the YouTube Data API. For a detailed explanation see:
 * <a href="http://code.google.com/p/google-http-java-client/wiki/JSON">http://code.google.com/p/google-http-java-client/wiki/JSON</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class SubscriptionSnippet extends com.google.api.client.json.GenericJson {

  /**
   * The ID that YouTube uses to uniquely identify the subscriber's channel.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String channelId;

  /**
   * Channel title for the channel that the subscription belongs to.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String channelTitle;

  /**
   * The subscription's details.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String description;

  /**
   * The date and time that the subscription was created. The value is specified in ISO 8601 (YYYY-
   * MM-DDThh:mm:ss.sZ) format.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private com.google.api.client.util.DateTime publishedAt;

  /**
   * The id object contains information about the channel that the user subscribed to.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ResourceId resourceId;

  /**
   * A map of thumbnail images associated with the video. For each object in the map, the key is the
   * name of the thumbnail image, and the value is an object that contains other information about
   * the thumbnail.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ThumbnailDetails thumbnails;

  /**
   * The subscription's title.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String title;

  /**
   * The ID that YouTube uses to uniquely identify the subscriber's channel.
   * @return value or {@code null} for none
   */
  public java.lang.String getChannelId() {
    return channelId;
  }

  /**
   * The ID that YouTube uses to uniquely identify the subscriber's channel.
   * @param channelId channelId or {@code null} for none
   */
  public SubscriptionSnippet setChannelId(java.lang.String channelId) {
    this.channelId = channelId;
    return this;
  }

  /**
   * Channel title for the channel that the subscription belongs to.
   * @return value or {@code null} for none
   */
  public java.lang.String getChannelTitle() {
    return channelTitle;
  }

  /**
   * Channel title for the channel that the subscription belongs to.
   * @param channelTitle channelTitle or {@code null} for none
   */
  public SubscriptionSnippet setChannelTitle(java.lang.String channelTitle) {
    this.channelTitle = channelTitle;
    return this;
  }

  /**
   * The subscription's details.
   * @return value or {@code null} for none
   */
  public java.lang.String getDescription() {
    return description;
  }

  /**
   * The subscription's details.
   * @param description description or {@code null} for none
   */
  public SubscriptionSnippet setDescription(java.lang.String description) {
    this.description = description;
    return this;
  }

  /**
   * The date and time that the subscription was created. The value is specified in ISO 8601 (YYYY-
   * MM-DDThh:mm:ss.sZ) format.
   * @return value or {@code null} for none
   */
  public com.google.api.client.util.DateTime getPublishedAt() {
    return publishedAt;
  }

  /**
   * The date and time that the subscription was created. The value is specified in ISO 8601 (YYYY-
   * MM-DDThh:mm:ss.sZ) format.
   * @param publishedAt publishedAt or {@code null} for none
   */
  public SubscriptionSnippet setPublishedAt(com.google.api.client.util.DateTime publishedAt) {
    this.publishedAt = publishedAt;
    return this;
  }

  /**
   * The id object contains information about the channel that the user subscribed to.
   * @return value or {@code null} for none
   */
  public ResourceId getResourceId() {
    return resourceId;
  }

  /**
   * The id object contains information about the channel that the user subscribed to.
   * @param resourceId resourceId or {@code null} for none
   */
  public SubscriptionSnippet setResourceId(ResourceId resourceId) {
    this.resourceId = resourceId;
    return this;
  }

  /**
   * A map of thumbnail images associated with the video. For each object in the map, the key is the
   * name of the thumbnail image, and the value is an object that contains other information about
   * the thumbnail.
   * @return value or {@code null} for none
   */
  public ThumbnailDetails getThumbnails() {
    return thumbnails;
  }

  /**
   * A map of thumbnail images associated with the video. For each object in the map, the key is the
   * name of the thumbnail image, and the value is an object that contains other information about
   * the thumbnail.
   * @param thumbnails thumbnails or {@code null} for none
   */
  public SubscriptionSnippet setThumbnails(ThumbnailDetails thumbnails) {
    this.thumbnails = thumbnails;
    return this;
  }

  /**
   * The subscription's title.
   * @return value or {@code null} for none
   */
  public java.lang.String getTitle() {
    return title;
  }

  /**
   * The subscription's title.
   * @param title title or {@code null} for none
   */
  public SubscriptionSnippet setTitle(java.lang.String title) {
    this.title = title;
    return this;
  }

  @Override
  public SubscriptionSnippet set(String fieldName, Object value) {
    return (SubscriptionSnippet) super.set(fieldName, value);
  }

  @Override
  public SubscriptionSnippet clone() {
    return (SubscriptionSnippet) super.clone();
  }

}
