/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://code.google.com/p/google-apis-client-generator/
 * (build: 2014-07-22 21:53:01 UTC)
 * on 2014-10-09 at 03:30:26 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.youtube.model;

/**
 * Details about the content of a YouTube Video.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the YouTube Data API. For a detailed explanation see:
 * <a href="http://code.google.com/p/google-http-java-client/wiki/JSON">http://code.google.com/p/google-http-java-client/wiki/JSON</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class VideoContentDetails extends com.google.api.client.json.GenericJson {

  /**
   * The value of captions indicates whether the video has captions or not.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String caption;

  /**
   * Specifies the ratings that the video received under various rating schemes.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ContentRating contentRating;

  /**
   * The countryRestriction object contains information about the countries where a video is (or is
   * not) viewable.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private AccessPolicy countryRestriction;

  /**
   * The value of definition indicates whether the video is available in high definition or only in
   * standard definition.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String definition;

  /**
   * The value of dimension indicates whether the video is available in 3D or in 2D.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String dimension;

  /**
   * The length of the video. The tag value is an ISO 8601 duration in the format PT#M#S, in which
   * the letters PT indicate that the value specifies a period of time, and the letters M and S
   * refer to length in minutes and seconds, respectively. The # characters preceding the M and S
   * letters are both integers that specify the number of minutes (or seconds) of the video. For
   * example, a value of PT15M51S indicates that the video is 15 minutes and 51 seconds long.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String duration;

  /**
   * The value of is_license_content indicates whether the video is licensed content.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean licensedContent;

  /**
   * The regionRestriction object contains information about the countries where a video is (or is
   * not) viewable. The object will contain either the contentDetails.regionRestriction.allowed
   * property or the contentDetails.regionRestriction.blocked property.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private VideoContentDetailsRegionRestriction regionRestriction;

  /**
   * The value of captions indicates whether the video has captions or not.
   * @return value or {@code null} for none
   */
  public java.lang.String getCaption() {
    return caption;
  }

  /**
   * The value of captions indicates whether the video has captions or not.
   * @param caption caption or {@code null} for none
   */
  public VideoContentDetails setCaption(java.lang.String caption) {
    this.caption = caption;
    return this;
  }

  /**
   * Specifies the ratings that the video received under various rating schemes.
   * @return value or {@code null} for none
   */
  public ContentRating getContentRating() {
    return contentRating;
  }

  /**
   * Specifies the ratings that the video received under various rating schemes.
   * @param contentRating contentRating or {@code null} for none
   */
  public VideoContentDetails setContentRating(ContentRating contentRating) {
    this.contentRating = contentRating;
    return this;
  }

  /**
   * The countryRestriction object contains information about the countries where a video is (or is
   * not) viewable.
   * @return value or {@code null} for none
   */
  public AccessPolicy getCountryRestriction() {
    return countryRestriction;
  }

  /**
   * The countryRestriction object contains information about the countries where a video is (or is
   * not) viewable.
   * @param countryRestriction countryRestriction or {@code null} for none
   */
  public VideoContentDetails setCountryRestriction(AccessPolicy countryRestriction) {
    this.countryRestriction = countryRestriction;
    return this;
  }

  /**
   * The value of definition indicates whether the video is available in high definition or only in
   * standard definition.
   * @return value or {@code null} for none
   */
  public java.lang.String getDefinition() {
    return definition;
  }

  /**
   * The value of definition indicates whether the video is available in high definition or only in
   * standard definition.
   * @param definition definition or {@code null} for none
   */
  public VideoContentDetails setDefinition(java.lang.String definition) {
    this.definition = definition;
    return this;
  }

  /**
   * The value of dimension indicates whether the video is available in 3D or in 2D.
   * @return value or {@code null} for none
   */
  public java.lang.String getDimension() {
    return dimension;
  }

  /**
   * The value of dimension indicates whether the video is available in 3D or in 2D.
   * @param dimension dimension or {@code null} for none
   */
  public VideoContentDetails setDimension(java.lang.String dimension) {
    this.dimension = dimension;
    return this;
  }

  /**
   * The length of the video. The tag value is an ISO 8601 duration in the format PT#M#S, in which
   * the letters PT indicate that the value specifies a period of time, and the letters M and S
   * refer to length in minutes and seconds, respectively. The # characters preceding the M and S
   * letters are both integers that specify the number of minutes (or seconds) of the video. For
   * example, a value of PT15M51S indicates that the video is 15 minutes and 51 seconds long.
   * @return value or {@code null} for none
   */
  public java.lang.String getDuration() {
    return duration;
  }

  /**
   * The length of the video. The tag value is an ISO 8601 duration in the format PT#M#S, in which
   * the letters PT indicate that the value specifies a period of time, and the letters M and S
   * refer to length in minutes and seconds, respectively. The # characters preceding the M and S
   * letters are both integers that specify the number of minutes (or seconds) of the video. For
   * example, a value of PT15M51S indicates that the video is 15 minutes and 51 seconds long.
   * @param duration duration or {@code null} for none
   */
  public VideoContentDetails setDuration(java.lang.String duration) {
    this.duration = duration;
    return this;
  }

  /**
   * The value of is_license_content indicates whether the video is licensed content.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getLicensedContent() {
    return licensedContent;
  }

  /**
   * The value of is_license_content indicates whether the video is licensed content.
   * @param licensedContent licensedContent or {@code null} for none
   */
  public VideoContentDetails setLicensedContent(java.lang.Boolean licensedContent) {
    this.licensedContent = licensedContent;
    return this;
  }

  /**
   * The regionRestriction object contains information about the countries where a video is (or is
   * not) viewable. The object will contain either the contentDetails.regionRestriction.allowed
   * property or the contentDetails.regionRestriction.blocked property.
   * @return value or {@code null} for none
   */
  public VideoContentDetailsRegionRestriction getRegionRestriction() {
    return regionRestriction;
  }

  /**
   * The regionRestriction object contains information about the countries where a video is (or is
   * not) viewable. The object will contain either the contentDetails.regionRestriction.allowed
   * property or the contentDetails.regionRestriction.blocked property.
   * @param regionRestriction regionRestriction or {@code null} for none
   */
  public VideoContentDetails setRegionRestriction(VideoContentDetailsRegionRestriction regionRestriction) {
    this.regionRestriction = regionRestriction;
    return this;
  }

  @Override
  public VideoContentDetails set(String fieldName, Object value) {
    return (VideoContentDetails) super.set(fieldName, value);
  }

  @Override
  public VideoContentDetails clone() {
    return (VideoContentDetails) super.clone();
  }

}
