/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://code.google.com/p/google-apis-client-generator/
 * (build: 2014-07-22 21:53:01 UTC)
 * on 2014-10-09 at 03:30:26 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.youtube.model;

/**
 * Information about an audio stream.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the YouTube Data API. For a detailed explanation see:
 * <a href="http://code.google.com/p/google-http-java-client/wiki/JSON">http://code.google.com/p/google-http-java-client/wiki/JSON</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class VideoFileDetailsAudioStream extends com.google.api.client.json.GenericJson {

  /**
   * The audio stream's bitrate, in bits per second.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.math.BigInteger bitrateBps;

  /**
   * The number of audio channels that the stream contains.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Long channelCount;

  /**
   * The audio codec that the stream uses.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String codec;

  /**
   * A value that uniquely identifies a video vendor. Typically, the value is a four-letter vendor
   * code.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String vendor;

  /**
   * The audio stream's bitrate, in bits per second.
   * @return value or {@code null} for none
   */
  public java.math.BigInteger getBitrateBps() {
    return bitrateBps;
  }

  /**
   * The audio stream's bitrate, in bits per second.
   * @param bitrateBps bitrateBps or {@code null} for none
   */
  public VideoFileDetailsAudioStream setBitrateBps(java.math.BigInteger bitrateBps) {
    this.bitrateBps = bitrateBps;
    return this;
  }

  /**
   * The number of audio channels that the stream contains.
   * @return value or {@code null} for none
   */
  public java.lang.Long getChannelCount() {
    return channelCount;
  }

  /**
   * The number of audio channels that the stream contains.
   * @param channelCount channelCount or {@code null} for none
   */
  public VideoFileDetailsAudioStream setChannelCount(java.lang.Long channelCount) {
    this.channelCount = channelCount;
    return this;
  }

  /**
   * The audio codec that the stream uses.
   * @return value or {@code null} for none
   */
  public java.lang.String getCodec() {
    return codec;
  }

  /**
   * The audio codec that the stream uses.
   * @param codec codec or {@code null} for none
   */
  public VideoFileDetailsAudioStream setCodec(java.lang.String codec) {
    this.codec = codec;
    return this;
  }

  /**
   * A value that uniquely identifies a video vendor. Typically, the value is a four-letter vendor
   * code.
   * @return value or {@code null} for none
   */
  public java.lang.String getVendor() {
    return vendor;
  }

  /**
   * A value that uniquely identifies a video vendor. Typically, the value is a four-letter vendor
   * code.
   * @param vendor vendor or {@code null} for none
   */
  public VideoFileDetailsAudioStream setVendor(java.lang.String vendor) {
    this.vendor = vendor;
    return this;
  }

  @Override
  public VideoFileDetailsAudioStream set(String fieldName, Object value) {
    return (VideoFileDetailsAudioStream) super.set(fieldName, value);
  }

  @Override
  public VideoFileDetailsAudioStream clone() {
    return (VideoFileDetailsAudioStream) super.clone();
  }

}
