/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://code.google.com/p/google-apis-client-generator/
 * (build: 2014-07-22 21:53:01 UTC)
 * on 2014-10-09 at 03:30:26 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.youtube.model;

/**
 * Basic details about a video, including title, description, uploader, thumbnails and category.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the YouTube Data API. For a detailed explanation see:
 * <a href="http://code.google.com/p/google-http-java-client/wiki/JSON">http://code.google.com/p/google-http-java-client/wiki/JSON</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class VideoSnippet extends com.google.api.client.json.GenericJson {

  /**
   * The YouTube video category associated with the video.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String categoryId;

  /**
   * The ID that YouTube uses to uniquely identify the channel that the video was uploaded to.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String channelId;

  /**
   * Channel title for the channel that the video belongs to.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String channelTitle;

  /**
   * The video's description.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String description;

  /**
   * Indicates if the video is an upcoming/active live broadcast. Or it's "none" if the video is not
   * an upcoming/active live broadcast.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String liveBroadcastContent;

  /**
   * The date and time that the video was uploaded. The value is specified in ISO 8601 (YYYY-MM-
   * DDThh:mm:ss.sZ) format.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private com.google.api.client.util.DateTime publishedAt;

  /**
   * A list of keyword tags associated with the video. Tags may contain spaces. This field is only
   * visible to the video's uploader.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> tags;

  /**
   * A map of thumbnail images associated with the video. For each object in the map, the key is the
   * name of the thumbnail image, and the value is an object that contains other information about
   * the thumbnail.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ThumbnailDetails thumbnails;

  /**
   * The video's title.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String title;

  /**
   * The YouTube video category associated with the video.
   * @return value or {@code null} for none
   */
  public java.lang.String getCategoryId() {
    return categoryId;
  }

  /**
   * The YouTube video category associated with the video.
   * @param categoryId categoryId or {@code null} for none
   */
  public VideoSnippet setCategoryId(java.lang.String categoryId) {
    this.categoryId = categoryId;
    return this;
  }

  /**
   * The ID that YouTube uses to uniquely identify the channel that the video was uploaded to.
   * @return value or {@code null} for none
   */
  public java.lang.String getChannelId() {
    return channelId;
  }

  /**
   * The ID that YouTube uses to uniquely identify the channel that the video was uploaded to.
   * @param channelId channelId or {@code null} for none
   */
  public VideoSnippet setChannelId(java.lang.String channelId) {
    this.channelId = channelId;
    return this;
  }

  /**
   * Channel title for the channel that the video belongs to.
   * @return value or {@code null} for none
   */
  public java.lang.String getChannelTitle() {
    return channelTitle;
  }

  /**
   * Channel title for the channel that the video belongs to.
   * @param channelTitle channelTitle or {@code null} for none
   */
  public VideoSnippet setChannelTitle(java.lang.String channelTitle) {
    this.channelTitle = channelTitle;
    return this;
  }

  /**
   * The video's description.
   * @return value or {@code null} for none
   */
  public java.lang.String getDescription() {
    return description;
  }

  /**
   * The video's description.
   * @param description description or {@code null} for none
   */
  public VideoSnippet setDescription(java.lang.String description) {
    this.description = description;
    return this;
  }

  /**
   * Indicates if the video is an upcoming/active live broadcast. Or it's "none" if the video is not
   * an upcoming/active live broadcast.
   * @return value or {@code null} for none
   */
  public java.lang.String getLiveBroadcastContent() {
    return liveBroadcastContent;
  }

  /**
   * Indicates if the video is an upcoming/active live broadcast. Or it's "none" if the video is not
   * an upcoming/active live broadcast.
   * @param liveBroadcastContent liveBroadcastContent or {@code null} for none
   */
  public VideoSnippet setLiveBroadcastContent(java.lang.String liveBroadcastContent) {
    this.liveBroadcastContent = liveBroadcastContent;
    return this;
  }

  /**
   * The date and time that the video was uploaded. The value is specified in ISO 8601 (YYYY-MM-
   * DDThh:mm:ss.sZ) format.
   * @return value or {@code null} for none
   */
  public com.google.api.client.util.DateTime getPublishedAt() {
    return publishedAt;
  }

  /**
   * The date and time that the video was uploaded. The value is specified in ISO 8601 (YYYY-MM-
   * DDThh:mm:ss.sZ) format.
   * @param publishedAt publishedAt or {@code null} for none
   */
  public VideoSnippet setPublishedAt(com.google.api.client.util.DateTime publishedAt) {
    this.publishedAt = publishedAt;
    return this;
  }

  /**
   * A list of keyword tags associated with the video. Tags may contain spaces. This field is only
   * visible to the video's uploader.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getTags() {
    return tags;
  }

  /**
   * A list of keyword tags associated with the video. Tags may contain spaces. This field is only
   * visible to the video's uploader.
   * @param tags tags or {@code null} for none
   */
  public VideoSnippet setTags(java.util.List<java.lang.String> tags) {
    this.tags = tags;
    return this;
  }

  /**
   * A map of thumbnail images associated with the video. For each object in the map, the key is the
   * name of the thumbnail image, and the value is an object that contains other information about
   * the thumbnail.
   * @return value or {@code null} for none
   */
  public ThumbnailDetails getThumbnails() {
    return thumbnails;
  }

  /**
   * A map of thumbnail images associated with the video. For each object in the map, the key is the
   * name of the thumbnail image, and the value is an object that contains other information about
   * the thumbnail.
   * @param thumbnails thumbnails or {@code null} for none
   */
  public VideoSnippet setThumbnails(ThumbnailDetails thumbnails) {
    this.thumbnails = thumbnails;
    return this;
  }

  /**
   * The video's title.
   * @return value or {@code null} for none
   */
  public java.lang.String getTitle() {
    return title;
  }

  /**
   * The video's title.
   * @param title title or {@code null} for none
   */
  public VideoSnippet setTitle(java.lang.String title) {
    this.title = title;
    return this;
  }

  @Override
  public VideoSnippet set(String fieldName, Object value) {
    return (VideoSnippet) super.set(fieldName, value);
  }

  @Override
  public VideoSnippet clone() {
    return (VideoSnippet) super.clone();
  }

}
