/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://code.google.com/p/google-apis-client-generator/
 * (build: 2014-07-22 21:53:01 UTC)
 * on 2014-10-09 at 03:30:26 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.youtube.model;

/**
 * Statistics about the video, such as the number of times the video was viewed or liked.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the YouTube Data API. For a detailed explanation see:
 * <a href="http://code.google.com/p/google-http-java-client/wiki/JSON">http://code.google.com/p/google-http-java-client/wiki/JSON</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class VideoStatistics extends com.google.api.client.json.GenericJson {

  /**
   * The number of comments for the video.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.math.BigInteger commentCount;

  /**
   * The number of users who have indicated that they disliked the video by giving it a negative
   * rating.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.math.BigInteger dislikeCount;

  /**
   * The number of users who currently have the video marked as a favorite video.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.math.BigInteger favoriteCount;

  /**
   * The number of users who have indicated that they liked the video by giving it a positive
   * rating.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.math.BigInteger likeCount;

  /**
   * The number of times the video has been viewed.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.math.BigInteger viewCount;

  /**
   * The number of comments for the video.
   * @return value or {@code null} for none
   */
  public java.math.BigInteger getCommentCount() {
    return commentCount;
  }

  /**
   * The number of comments for the video.
   * @param commentCount commentCount or {@code null} for none
   */
  public VideoStatistics setCommentCount(java.math.BigInteger commentCount) {
    this.commentCount = commentCount;
    return this;
  }

  /**
   * The number of users who have indicated that they disliked the video by giving it a negative
   * rating.
   * @return value or {@code null} for none
   */
  public java.math.BigInteger getDislikeCount() {
    return dislikeCount;
  }

  /**
   * The number of users who have indicated that they disliked the video by giving it a negative
   * rating.
   * @param dislikeCount dislikeCount or {@code null} for none
   */
  public VideoStatistics setDislikeCount(java.math.BigInteger dislikeCount) {
    this.dislikeCount = dislikeCount;
    return this;
  }

  /**
   * The number of users who currently have the video marked as a favorite video.
   * @return value or {@code null} for none
   */
  public java.math.BigInteger getFavoriteCount() {
    return favoriteCount;
  }

  /**
   * The number of users who currently have the video marked as a favorite video.
   * @param favoriteCount favoriteCount or {@code null} for none
   */
  public VideoStatistics setFavoriteCount(java.math.BigInteger favoriteCount) {
    this.favoriteCount = favoriteCount;
    return this;
  }

  /**
   * The number of users who have indicated that they liked the video by giving it a positive
   * rating.
   * @return value or {@code null} for none
   */
  public java.math.BigInteger getLikeCount() {
    return likeCount;
  }

  /**
   * The number of users who have indicated that they liked the video by giving it a positive
   * rating.
   * @param likeCount likeCount or {@code null} for none
   */
  public VideoStatistics setLikeCount(java.math.BigInteger likeCount) {
    this.likeCount = likeCount;
    return this;
  }

  /**
   * The number of times the video has been viewed.
   * @return value or {@code null} for none
   */
  public java.math.BigInteger getViewCount() {
    return viewCount;
  }

  /**
   * The number of times the video has been viewed.
   * @param viewCount viewCount or {@code null} for none
   */
  public VideoStatistics setViewCount(java.math.BigInteger viewCount) {
    this.viewCount = viewCount;
    return this;
  }

  @Override
  public VideoStatistics set(String fieldName, Object value) {
    return (VideoStatistics) super.set(fieldName, value);
  }

  @Override
  public VideoStatistics clone() {
    return (VideoStatistics) super.clone();
  }

}
