/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.youtube;

/**
 * Service definition for YouTube (v3).
 *
 * <p>
 * The YouTube Data API v3 is an API that provides access to YouTube data, such as videos, playlists, and channels.
 * </p>
 *
 * <p>
 * For more information about this service, see the
 * <a href="https://developers.google.com/youtube/" target="_blank">API Documentation</a>
 * </p>
 *
 * <p>
 * This service uses {@link YouTubeRequestInitializer} to initialize global parameters via its
 * {@link Builder}.
 * </p>
 *
 * @since 1.3
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public class YouTube extends com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient {

  // Note: Leave this static initializer at the top of the file.
  static {
    com.google.api.client.util.Preconditions.checkState(
        com.google.api.client.googleapis.GoogleUtils.MAJOR_VERSION == 1 &&
        (com.google.api.client.googleapis.GoogleUtils.MINOR_VERSION >= 32 ||
        (com.google.api.client.googleapis.GoogleUtils.MINOR_VERSION == 31 &&
        com.google.api.client.googleapis.GoogleUtils.BUGFIX_VERSION >= 1)),
        "You are currently running with version %s of google-api-client. " +
        "You need at least version 1.31.1 of google-api-client to run version " +
        "1.32.1 of the YouTube Data API v3 library.", com.google.api.client.googleapis.GoogleUtils.VERSION);
  }

  /**
   * The default encoded root URL of the service. This is determined when the library is generated
   * and normally should not be changed.
   *
   * @since 1.7
   */
  public static final String DEFAULT_ROOT_URL = "https://youtube.googleapis.com/";

  /**
   * The default encoded mTLS root URL of the service. This is determined when the library is generated
   * and normally should not be changed.
   *
   * @since 1.31
   */
  public static final String DEFAULT_MTLS_ROOT_URL = "https://youtube.mtls.googleapis.com/";

  /**
   * The default encoded service path of the service. This is determined when the library is
   * generated and normally should not be changed.
   *
   * @since 1.7
   */
  public static final String DEFAULT_SERVICE_PATH = "";

  /**
   * The default encoded batch path of the service. This is determined when the library is
   * generated and normally should not be changed.
   *
   * @since 1.23
   */
  public static final String DEFAULT_BATCH_PATH = "batch";

  /**
   * The default encoded base URL of the service. This is determined when the library is generated
   * and normally should not be changed.
   */
  public static final String DEFAULT_BASE_URL = DEFAULT_ROOT_URL + DEFAULT_SERVICE_PATH;

  /**
   * Constructor.
   *
   * <p>
   * Use {@link Builder} if you need to specify any of the optional parameters.
   * </p>
   *
   * @param transport HTTP transport, which should normally be:
   *        <ul>
   *        <li>Google App Engine:
   *        {@code com.google.api.client.extensions.appengine.http.UrlFetchTransport}</li>
   *        <li>Android: {@code newCompatibleTransport} from
   *        {@code com.google.api.client.extensions.android.http.AndroidHttp}</li>
   *        <li>Java: {@link com.google.api.client.googleapis.javanet.GoogleNetHttpTransport#newTrustedTransport()}
   *        </li>
   *        </ul>
   * @param jsonFactory JSON factory, which may be:
   *        <ul>
   *        <li>Jackson: {@code com.google.api.client.json.jackson2.JacksonFactory}</li>
   *        <li>Google GSON: {@code com.google.api.client.json.gson.GsonFactory}</li>
   *        <li>Android Honeycomb or higher:
   *        {@code com.google.api.client.extensions.android.json.AndroidJsonFactory}</li>
   *        </ul>
   * @param httpRequestInitializer HTTP request initializer or {@code null} for none
   * @since 1.7
   */
  public YouTube(com.google.api.client.http.HttpTransport transport, com.google.api.client.json.JsonFactory jsonFactory,
      com.google.api.client.http.HttpRequestInitializer httpRequestInitializer) {
    this(new Builder(transport, jsonFactory, httpRequestInitializer));
  }

  /**
   * @param builder builder
   */
  YouTube(Builder builder) {
    super(builder);
  }

  @Override
  protected void initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest<?> httpClientRequest) throws java.io.IOException {
    super.initialize(httpClientRequest);
  }

  /**
   * An accessor for creating requests from the AbuseReports collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code YouTube youtube = new YouTube(...);}
   *   {@code YouTube.AbuseReports.List request = youtube.abuseReports().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public AbuseReports abuseReports() {
    return new AbuseReports();
  }

  /**
   * The "abuseReports" collection of methods.
   */
  public class AbuseReports {

    /**
     * Inserts a new resource into this collection.
     *
     * Create a request for the method "abuseReports.insert".
     *
     * This request holds the parameters needed by the youtube server.  After setting any optional
     * parameters, call the {@link Insert#execute()} method to invoke the remote operation.
     *
     * @param part The *part* parameter serves two purposes in this operation. It identifies the properties that the
     *        write operation will set as well as the properties that the API response will include.
     * @param content the {@link com.google.api.services.youtube.model.AbuseReport}
     * @return the request
     */
    public Insert insert(java.util.List<java.lang.String> part, com.google.api.services.youtube.model.AbuseReport content) throws java.io.IOException {
      Insert result = new Insert(part, content);
      initialize(result);
      return result;
    }

    public class Insert extends YouTubeRequest<com.google.api.services.youtube.model.AbuseReport> {

      private static final String REST_PATH = "youtube/v3/abuseReports";

      /**
       * Inserts a new resource into this collection.
       *
       * Create a request for the method "abuseReports.insert".
       *
       * This request holds the parameters needed by the the youtube server.  After setting any optional
       * parameters, call the {@link Insert#execute()} method to invoke the remote operation. <p> {@link
       * Insert#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param part The *part* parameter serves two purposes in this operation. It identifies the properties that the
     *        write operation will set as well as the properties that the API response will include.
       * @param content the {@link com.google.api.services.youtube.model.AbuseReport}
       * @since 1.13
       */
      protected Insert(java.util.List<java.lang.String> part, com.google.api.services.youtube.model.AbuseReport content) {
        super(YouTube.this, "POST", REST_PATH, content, com.google.api.services.youtube.model.AbuseReport.class);
        this.part = com.google.api.client.util.Preconditions.checkNotNull(part, "Required parameter part must be specified.");
      }

      @Override
      public Insert set$Xgafv(java.lang.String $Xgafv) {
        return (Insert) super.set$Xgafv($Xgafv);
      }

      @Override
      public Insert setAccessToken(java.lang.String accessToken) {
        return (Insert) super.setAccessToken(accessToken);
      }

      @Override
      public Insert setAlt(java.lang.String alt) {
        return (Insert) super.setAlt(alt);
      }

      @Override
      public Insert setCallback(java.lang.String callback) {
        return (Insert) super.setCallback(callback);
      }

      @Override
      public Insert setFields(java.lang.String fields) {
        return (Insert) super.setFields(fields);
      }

      @Override
      public Insert setKey(java.lang.String key) {
        return (Insert) super.setKey(key);
      }

      @Override
      public Insert setOauthToken(java.lang.String oauthToken) {
        return (Insert) super.setOauthToken(oauthToken);
      }

      @Override
      public Insert setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Insert) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Insert setQuotaUser(java.lang.String quotaUser) {
        return (Insert) super.setQuotaUser(quotaUser);
      }

      @Override
      public Insert setUploadType(java.lang.String uploadType) {
        return (Insert) super.setUploadType(uploadType);
      }

      @Override
      public Insert setUploadProtocol(java.lang.String uploadProtocol) {
        return (Insert) super.setUploadProtocol(uploadProtocol);
      }

      /**
       * The *part* parameter serves two purposes in this operation. It identifies the properties
       * that the write operation will set as well as the properties that the API response will
       * include.
       */
      @com.google.api.client.util.Key
      private java.util.List<java.lang.String> part;

      /** The *part* parameter serves two purposes in this operation. It identifies the properties that the
     write operation will set as well as the properties that the API response will include.
       */
      public java.util.List<java.lang.String> getPart() {
        return part;
      }

      /**
       * The *part* parameter serves two purposes in this operation. It identifies the properties
       * that the write operation will set as well as the properties that the API response will
       * include.
       */
      public Insert setPart(java.util.List<java.lang.String> part) {
        this.part = part;
        return this;
      }

      @Override
      public Insert set(String parameterName, Object value) {
        return (Insert) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the Activities collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code YouTube youtube = new YouTube(...);}
   *   {@code YouTube.Activities.List request = youtube.activities().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Activities activities() {
    return new Activities();
  }

  /**
   * The "activities" collection of methods.
   */
  public class Activities {

    /**
     * Retrieves a list of resources, possibly filtered.
     *
     * Create a request for the method "activities.list".
     *
     * This request holds the parameters needed by the youtube server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param part The *part* parameter specifies a comma-separated list of one or more activity resource properties
     *        that the API response will include. If the parameter identifies a property that contains
     *        child properties, the child properties will be included in the response. For example, in
     *        an activity resource, the snippet property contains other properties that identify the
     *        type of activity, a display title for the activity, and so forth. If you set
     *        *part=snippet*, the API response will also contain all of those nested properties.
     * @return the request
     */
    public List list(java.util.List<java.lang.String> part) throws java.io.IOException {
      List result = new List(part);
      initialize(result);
      return result;
    }

    public class List extends YouTubeRequest<com.google.api.services.youtube.model.ActivityListResponse> {

      private static final String REST_PATH = "youtube/v3/activities";

      /**
       * Retrieves a list of resources, possibly filtered.
       *
       * Create a request for the method "activities.list".
       *
       * This request holds the parameters needed by the the youtube server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param part The *part* parameter specifies a comma-separated list of one or more activity resource properties
     *        that the API response will include. If the parameter identifies a property that contains
     *        child properties, the child properties will be included in the response. For example, in
     *        an activity resource, the snippet property contains other properties that identify the
     *        type of activity, a display title for the activity, and so forth. If you set
     *        *part=snippet*, the API response will also contain all of those nested properties.
       * @since 1.13
       */
      protected List(java.util.List<java.lang.String> part) {
        super(YouTube.this, "GET", REST_PATH, null, com.google.api.services.youtube.model.ActivityListResponse.class);
        this.part = com.google.api.client.util.Preconditions.checkNotNull(part, "Required parameter part must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List set$Xgafv(java.lang.String $Xgafv) {
        return (List) super.set$Xgafv($Xgafv);
      }

      @Override
      public List setAccessToken(java.lang.String accessToken) {
        return (List) super.setAccessToken(accessToken);
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setCallback(java.lang.String callback) {
        return (List) super.setCallback(callback);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUploadType(java.lang.String uploadType) {
        return (List) super.setUploadType(uploadType);
      }

      @Override
      public List setUploadProtocol(java.lang.String uploadProtocol) {
        return (List) super.setUploadProtocol(uploadProtocol);
      }

      /**
       * The *part* parameter specifies a comma-separated list of one or more activity resource
       * properties that the API response will include. If the parameter identifies a property that
       * contains child properties, the child properties will be included in the response. For
       * example, in an activity resource, the snippet property contains other properties that
       * identify the type of activity, a display title for the activity, and so forth. If you set
       * *part=snippet*, the API response will also contain all of those nested properties.
       */
      @com.google.api.client.util.Key
      private java.util.List<java.lang.String> part;

      /** The *part* parameter specifies a comma-separated list of one or more activity resource properties
     that the API response will include. If the parameter identifies a property that contains child
     properties, the child properties will be included in the response. For example, in an activity
     resource, the snippet property contains other properties that identify the type of activity, a
     display title for the activity, and so forth. If you set *part=snippet*, the API response will also
     contain all of those nested properties.
       */
      public java.util.List<java.lang.String> getPart() {
        return part;
      }

      /**
       * The *part* parameter specifies a comma-separated list of one or more activity resource
       * properties that the API response will include. If the parameter identifies a property that
       * contains child properties, the child properties will be included in the response. For
       * example, in an activity resource, the snippet property contains other properties that
       * identify the type of activity, a display title for the activity, and so forth. If you set
       * *part=snippet*, the API response will also contain all of those nested properties.
       */
      public List setPart(java.util.List<java.lang.String> part) {
        this.part = part;
        return this;
      }

      @com.google.api.client.util.Key
      private java.lang.String channelId;

      /**

       */
      public java.lang.String getChannelId() {
        return channelId;
      }

      public List setChannelId(java.lang.String channelId) {
        this.channelId = channelId;
        return this;
      }

      @com.google.api.client.util.Key
      private java.lang.Boolean home;

      /**

       */
      public java.lang.Boolean getHome() {
        return home;
      }

      public List setHome(java.lang.Boolean home) {
        this.home = home;
        return this;
      }

      /**
       * The *maxResults* parameter specifies the maximum number of items that should be returned in
       * the result set.
       */
      @com.google.api.client.util.Key
      private java.lang.Long maxResults;

      /** The *maxResults* parameter specifies the maximum number of items that should be returned in the
     result set. [default: 5] [minimum: 0] [maximum: 50]
       */
      public java.lang.Long getMaxResults() {
        return maxResults;
      }

      /**
       * The *maxResults* parameter specifies the maximum number of items that should be returned in
       * the result set.
       */
      public List setMaxResults(java.lang.Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      @com.google.api.client.util.Key
      private java.lang.Boolean mine;

      /**

       */
      public java.lang.Boolean getMine() {
        return mine;
      }

      public List setMine(java.lang.Boolean mine) {
        this.mine = mine;
        return this;
      }

      /**
       * The *pageToken* parameter identifies a specific page in the result set that should be
       * returned. In an API response, the nextPageToken and prevPageToken properties identify other
       * pages that could be retrieved.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** The *pageToken* parameter identifies a specific page in the result set that should be returned. In
     an API response, the nextPageToken and prevPageToken properties identify other pages that could be
     retrieved.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * The *pageToken* parameter identifies a specific page in the result set that should be
       * returned. In an API response, the nextPageToken and prevPageToken properties identify other
       * pages that could be retrieved.
       */
      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      @com.google.api.client.util.Key
      private String publishedAfter;

      /**

       */
      public String getPublishedAfter() {
        return publishedAfter;
      }

      public List setPublishedAfter(String publishedAfter) {
        this.publishedAfter = publishedAfter;
        return this;
      }

      @com.google.api.client.util.Key
      private String publishedBefore;

      /**

       */
      public String getPublishedBefore() {
        return publishedBefore;
      }

      public List setPublishedBefore(String publishedBefore) {
        this.publishedBefore = publishedBefore;
        return this;
      }

      @com.google.api.client.util.Key
      private java.lang.String regionCode;

      /**

       */
      public java.lang.String getRegionCode() {
        return regionCode;
      }

      public List setRegionCode(java.lang.String regionCode) {
        this.regionCode = regionCode;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the Captions collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code YouTube youtube = new YouTube(...);}
   *   {@code YouTube.Captions.List request = youtube.captions().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Captions captions() {
    return new Captions();
  }

  /**
   * The "captions" collection of methods.
   */
  public class Captions {

    /**
     * Deletes a resource.
     *
     * Create a request for the method "captions.delete".
     *
     * This request holds the parameters needed by the youtube server.  After setting any optional
     * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
     *
     * @param id
     * @return the request
     */
    public Delete delete(java.lang.String id) throws java.io.IOException {
      Delete result = new Delete(id);
      initialize(result);
      return result;
    }

    public class Delete extends YouTubeRequest<Void> {

      private static final String REST_PATH = "youtube/v3/captions";

      /**
       * Deletes a resource.
       *
       * Create a request for the method "captions.delete".
       *
       * This request holds the parameters needed by the the youtube server.  After setting any optional
       * parameters, call the {@link Delete#execute()} method to invoke the remote operation. <p> {@link
       * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param id
       * @since 1.13
       */
      protected Delete(java.lang.String id) {
        super(YouTube.this, "DELETE", REST_PATH, null, Void.class);
        this.id = com.google.api.client.util.Preconditions.checkNotNull(id, "Required parameter id must be specified.");
      }

      @Override
      public Delete set$Xgafv(java.lang.String $Xgafv) {
        return (Delete) super.set$Xgafv($Xgafv);
      }

      @Override
      public Delete setAccessToken(java.lang.String accessToken) {
        return (Delete) super.setAccessToken(accessToken);
      }

      @Override
      public Delete setAlt(java.lang.String alt) {
        return (Delete) super.setAlt(alt);
      }

      @Override
      public Delete setCallback(java.lang.String callback) {
        return (Delete) super.setCallback(callback);
      }

      @Override
      public Delete setFields(java.lang.String fields) {
        return (Delete) super.setFields(fields);
      }

      @Override
      public Delete setKey(java.lang.String key) {
        return (Delete) super.setKey(key);
      }

      @Override
      public Delete setOauthToken(java.lang.String oauthToken) {
        return (Delete) super.setOauthToken(oauthToken);
      }

      @Override
      public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Delete) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Delete setQuotaUser(java.lang.String quotaUser) {
        return (Delete) super.setQuotaUser(quotaUser);
      }

      @Override
      public Delete setUploadType(java.lang.String uploadType) {
        return (Delete) super.setUploadType(uploadType);
      }

      @Override
      public Delete setUploadProtocol(java.lang.String uploadProtocol) {
        return (Delete) super.setUploadProtocol(uploadProtocol);
      }

      @com.google.api.client.util.Key
      private java.lang.String id;

      /**

       */
      public java.lang.String getId() {
        return id;
      }

      public Delete setId(java.lang.String id) {
        this.id = id;
        return this;
      }

      /** ID of the Google+ Page for the channel that the request is be on behalf of */
      @com.google.api.client.util.Key
      private java.lang.String onBehalfOf;

      /** ID of the Google+ Page for the channel that the request is be on behalf of
       */
      public java.lang.String getOnBehalfOf() {
        return onBehalfOf;
      }

      /** ID of the Google+ Page for the channel that the request is be on behalf of */
      public Delete setOnBehalfOf(java.lang.String onBehalfOf) {
        this.onBehalfOf = onBehalfOf;
        return this;
      }

      /**
       * *Note:* This parameter is intended exclusively for YouTube content partners. The
       * *onBehalfOfContentOwner* parameter indicates that the request's authorization credentials
       * identify a YouTube CMS user who is acting on behalf of the content owner specified in the
       * parameter value. This parameter is intended for YouTube content partners that own and
       * manage many different YouTube channels. It allows content owners to authenticate once and
       * get access to all their video and channel data, without having to provide authentication
       * credentials for each individual channel. The actual CMS account that the user authenticates
       * with must be linked to the specified YouTube content owner.
       */
      @com.google.api.client.util.Key
      private java.lang.String onBehalfOfContentOwner;

      /*** Note:* This parameter is intended exclusively for YouTube content partners. The
    * *onBehalfOfContentOwner* parameter indicates that the request's authorization credentials identify
    * a YouTube CMS user who is acting on behalf of the content owner specified in the parameter value.
    * This parameter is intended for YouTube content partners that own and manage many different YouTube
    * channels. It allows content owners to authenticate once and get access to all their video and
    * channel data, without having to provide authentication credentials for each individual channel.
    * The actual CMS account that the user authenticates with must be linked to the specified YouTube
    * content owner.
    *

       */
      public java.lang.String getOnBehalfOfContentOwner() {
        return onBehalfOfContentOwner;
      }

      /**
       * *Note:* This parameter is intended exclusively for YouTube content partners. The
       * *onBehalfOfContentOwner* parameter indicates that the request's authorization credentials
       * identify a YouTube CMS user who is acting on behalf of the content owner specified in the
       * parameter value. This parameter is intended for YouTube content partners that own and
       * manage many different YouTube channels. It allows content owners to authenticate once and
       * get access to all their video and channel data, without having to provide authentication
       * credentials for each individual channel. The actual CMS account that the user authenticates
       * with must be linked to the specified YouTube content owner.
       */
      public Delete setOnBehalfOfContentOwner(java.lang.String onBehalfOfContentOwner) {
        this.onBehalfOfContentOwner = onBehalfOfContentOwner;
        return this;
      }

      @Override
      public Delete set(String parameterName, Object value) {
        return (Delete) super.set(parameterName, value);
      }
    }
    /**
     * Downloads a caption track.
     *
     * Create a request for the method "captions.download".
     *
     * This request holds the parameters needed by the youtube server.  After setting any optional
     * parameters, call the {@link Download#execute()} method to invoke the remote operation.
     *
     * @param id The ID of the caption track to download, required for One Platform.
     * @return the request
     */
    public Download download(java.lang.String id) throws java.io.IOException {
      Download result = new Download(id);
      initialize(result);
      return result;
    }

    public class Download extends YouTubeRequest<Void> {

      private static final String REST_PATH = "youtube/v3/captions/{id}";

      /**
       * Downloads a caption track.
       *
       * Create a request for the method "captions.download".
       *
       * This request holds the parameters needed by the the youtube server.  After setting any optional
       * parameters, call the {@link Download#execute()} method to invoke the remote operation. <p>
       * {@link
       * Download#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param id The ID of the caption track to download, required for One Platform.
       * @since 1.13
       */
      protected Download(java.lang.String id) {
        super(YouTube.this, "GET", REST_PATH, null, Void.class);
        this.id = com.google.api.client.util.Preconditions.checkNotNull(id, "Required parameter id must be specified.");
        initializeMediaDownload();
      }

      @Override
      public void executeMediaAndDownloadTo(java.io.OutputStream outputStream) throws java.io.IOException {
        super.executeMediaAndDownloadTo(outputStream);
      }

      @Override
      public java.io.InputStream executeMediaAsInputStream() throws java.io.IOException {
        return super.executeMediaAsInputStream();
      }

      @Override
      public com.google.api.client.http.HttpResponse executeMedia() throws java.io.IOException {
        return super.executeMedia();
      }

      @Override
      public com.google.api.client.http.GenericUrl buildHttpRequestUrl() {
        java.lang.String baseUrl = ("media".equals(get("alt")) && getMediaHttpUploader() == null)
            ? getRootUrl() + "download/" + getServicePath() : getBaseUrl();
        return new com.google.api.client.http.GenericUrl(
            com.google.api.client.http.UriTemplate.expand(baseUrl, getUriTemplate(), this, true));
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Download set$Xgafv(java.lang.String $Xgafv) {
        return (Download) super.set$Xgafv($Xgafv);
      }

      @Override
      public Download setAccessToken(java.lang.String accessToken) {
        return (Download) super.setAccessToken(accessToken);
      }

      @Override
      public Download setAlt(java.lang.String alt) {
        return (Download) super.setAlt(alt);
      }

      @Override
      public Download setCallback(java.lang.String callback) {
        return (Download) super.setCallback(callback);
      }

      @Override
      public Download setFields(java.lang.String fields) {
        return (Download) super.setFields(fields);
      }

      @Override
      public Download setKey(java.lang.String key) {
        return (Download) super.setKey(key);
      }

      @Override
      public Download setOauthToken(java.lang.String oauthToken) {
        return (Download) super.setOauthToken(oauthToken);
      }

      @Override
      public Download setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Download) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Download setQuotaUser(java.lang.String quotaUser) {
        return (Download) super.setQuotaUser(quotaUser);
      }

      @Override
      public Download setUploadType(java.lang.String uploadType) {
        return (Download) super.setUploadType(uploadType);
      }

      @Override
      public Download setUploadProtocol(java.lang.String uploadProtocol) {
        return (Download) super.setUploadProtocol(uploadProtocol);
      }

      /** The ID of the caption track to download, required for One Platform. */
      @com.google.api.client.util.Key
      private java.lang.String id;

      /** The ID of the caption track to download, required for One Platform.
       */
      public java.lang.String getId() {
        return id;
      }

      /** The ID of the caption track to download, required for One Platform. */
      public Download setId(java.lang.String id) {
        this.id = id;
        return this;
      }

      /** ID of the Google+ Page for the channel that the request is be on behalf of */
      @com.google.api.client.util.Key
      private java.lang.String onBehalfOf;

      /** ID of the Google+ Page for the channel that the request is be on behalf of
       */
      public java.lang.String getOnBehalfOf() {
        return onBehalfOf;
      }

      /** ID of the Google+ Page for the channel that the request is be on behalf of */
      public Download setOnBehalfOf(java.lang.String onBehalfOf) {
        this.onBehalfOf = onBehalfOf;
        return this;
      }

      /**
       * *Note:* This parameter is intended exclusively for YouTube content partners. The
       * *onBehalfOfContentOwner* parameter indicates that the request's authorization credentials
       * identify a YouTube CMS user who is acting on behalf of the content owner specified in the
       * parameter value. This parameter is intended for YouTube content partners that own and
       * manage many different YouTube channels. It allows content owners to authenticate once and
       * get access to all their video and channel data, without having to provide authentication
       * credentials for each individual channel. The actual CMS account that the user authenticates
       * with must be linked to the specified YouTube content owner.
       */
      @com.google.api.client.util.Key
      private java.lang.String onBehalfOfContentOwner;

      /*** Note:* This parameter is intended exclusively for YouTube content partners. The
    * *onBehalfOfContentOwner* parameter indicates that the request's authorization credentials identify
    * a YouTube CMS user who is acting on behalf of the content owner specified in the parameter value.
    * This parameter is intended for YouTube content partners that own and manage many different YouTube
    * channels. It allows content owners to authenticate once and get access to all their video and
    * channel data, without having to provide authentication credentials for each individual channel.
    * The actual CMS account that the user authenticates with must be linked to the specified YouTube
    * content owner.
    *

       */
      public java.lang.String getOnBehalfOfContentOwner() {
        return onBehalfOfContentOwner;
      }

      /**
       * *Note:* This parameter is intended exclusively for YouTube content partners. The
       * *onBehalfOfContentOwner* parameter indicates that the request's authorization credentials
       * identify a YouTube CMS user who is acting on behalf of the content owner specified in the
       * parameter value. This parameter is intended for YouTube content partners that own and
       * manage many different YouTube channels. It allows content owners to authenticate once and
       * get access to all their video and channel data, without having to provide authentication
       * credentials for each individual channel. The actual CMS account that the user authenticates
       * with must be linked to the specified YouTube content owner.
       */
      public Download setOnBehalfOfContentOwner(java.lang.String onBehalfOfContentOwner) {
        this.onBehalfOfContentOwner = onBehalfOfContentOwner;
        return this;
      }

      /** Convert the captions into this format. Supported options are sbv, srt, and vtt. */
      @com.google.api.client.util.Key
      private java.lang.String tfmt;

      /** Convert the captions into this format. Supported options are sbv, srt, and vtt.
       */
      public java.lang.String getTfmt() {
        return tfmt;
      }

      /** Convert the captions into this format. Supported options are sbv, srt, and vtt. */
      public Download setTfmt(java.lang.String tfmt) {
        this.tfmt = tfmt;
        return this;
      }

      /** tlang is the language code; machine translate the captions into this language. */
      @com.google.api.client.util.Key
      private java.lang.String tlang;

      /** tlang is the language code; machine translate the captions into this language.
       */
      public java.lang.String getTlang() {
        return tlang;
      }

      /** tlang is the language code; machine translate the captions into this language. */
      public Download setTlang(java.lang.String tlang) {
        this.tlang = tlang;
        return this;
      }

      @Override
      public Download set(String parameterName, Object value) {
        return (Download) super.set(parameterName, value);
      }
    }
    /**
     * Inserts a new resource into this collection.
     *
     * Create a request for the method "captions.insert".
     *
     * This request holds the parameters needed by the youtube server.  After setting any optional
     * parameters, call the {@link Insert#execute()} method to invoke the remote operation.
     *
     * @param part The *part* parameter specifies the caption resource parts that the API response will include. Set
     *        the parameter value to snippet.
     * @param content the {@link com.google.api.services.youtube.model.Caption}
     * @return the request
     */
    public Insert insert(java.util.List<java.lang.String> part, com.google.api.services.youtube.model.Caption content) throws java.io.IOException {
      Insert result = new Insert(part, content);
      initialize(result);
      return result;
    }

    /**
     * Inserts a new resource into this collection.
     *
     * Create a request for the method "captions.insert".
     *
     * This request holds the parameters needed by the the youtube server.  After setting any optional
     * parameters, call the {@link Insert#execute()} method to invoke the remote operation.
     *
     * <p>
     * This method should be used for uploading media content.
     * </p>
     *
     * @param part The *part* parameter specifies the caption resource parts that the API response will include. Set
     *        the parameter value to snippet.
     * @param content the {@link com.google.api.services.youtube.model.Caption} media metadata or {@code null} if none
     * @param mediaContent The media HTTP content or {@code null} if none.
     * @return the request
     * @throws java.io.IOException if the initialization of the request fails
     */
    public Insert insert(java.util.List<java.lang.String> part, com.google.api.services.youtube.model.Caption content, com.google.api.client.http.AbstractInputStreamContent mediaContent) throws java.io.IOException {
      Insert result = new Insert(part, content, mediaContent);
      initialize(result);
      return result;
    }

    public class Insert extends YouTubeRequest<com.google.api.services.youtube.model.Caption> {

      private static final String REST_PATH = "youtube/v3/captions";

      /**
       * Inserts a new resource into this collection.
       *
       * Create a request for the method "captions.insert".
       *
       * This request holds the parameters needed by the the youtube server.  After setting any optional
       * parameters, call the {@link Insert#execute()} method to invoke the remote operation. <p> {@link
       * Insert#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param part The *part* parameter specifies the caption resource parts that the API response will include. Set
     *        the parameter value to snippet.
       * @param content the {@link com.google.api.services.youtube.model.Caption}
       * @since 1.13
       */
      protected Insert(java.util.List<java.lang.String> part, com.google.api.services.youtube.model.Caption content) {
        super(YouTube.this, "POST", REST_PATH, content, com.google.api.services.youtube.model.Caption.class);
        this.part = com.google.api.client.util.Preconditions.checkNotNull(part, "Required parameter part must be specified.");
      }

      /**
       * Inserts a new resource into this collection.
       *
       * Create a request for the method "captions.insert".
       *
       * This request holds the parameters needed by the the youtube server.  After setting any optional
       * parameters, call the {@link Insert#execute()} method to invoke the remote operation. <p> {@link
       * Insert#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * <p>
       * This constructor should be used for uploading media content.
       * </p>
       *
       * @param part The *part* parameter specifies the caption resource parts that the API response will include. Set
     *        the parameter value to snippet.
       * @param content the {@link com.google.api.services.youtube.model.Caption} media metadata or {@code null} if none
       * @param mediaContent The media HTTP content or {@code null} if none.
       * @since 1.13
       */
      protected Insert(java.util.List<java.lang.String> part, com.google.api.services.youtube.model.Caption content, com.google.api.client.http.AbstractInputStreamContent mediaContent) {
        super(YouTube.this, "POST", "/upload/" + getServicePath() + REST_PATH, content, com.google.api.services.youtube.model.Caption.class);
        this.part = com.google.api.client.util.Preconditions.checkNotNull(part, "Required parameter part must be specified.");
        initializeMediaUpload(mediaContent);
      }

      @Override
      public Insert set$Xgafv(java.lang.String $Xgafv) {
        return (Insert) super.set$Xgafv($Xgafv);
      }

      @Override
      public Insert setAccessToken(java.lang.String accessToken) {
        return (Insert) super.setAccessToken(accessToken);
      }

      @Override
      public Insert setAlt(java.lang.String alt) {
        return (Insert) super.setAlt(alt);
      }

      @Override
      public Insert setCallback(java.lang.String callback) {
        return (Insert) super.setCallback(callback);
      }

      @Override
      public Insert setFields(java.lang.String fields) {
        return (Insert) super.setFields(fields);
      }

      @Override
      public Insert setKey(java.lang.String key) {
        return (Insert) super.setKey(key);
      }

      @Override
      public Insert setOauthToken(java.lang.String oauthToken) {
        return (Insert) super.setOauthToken(oauthToken);
      }

      @Override
      public Insert setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Insert) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Insert setQuotaUser(java.lang.String quotaUser) {
        return (Insert) super.setQuotaUser(quotaUser);
      }

      @Override
      public Insert setUploadType(java.lang.String uploadType) {
        return (Insert) super.setUploadType(uploadType);
      }

      @Override
      public Insert setUploadProtocol(java.lang.String uploadProtocol) {
        return (Insert) super.setUploadProtocol(uploadProtocol);
      }

      /**
       * The *part* parameter specifies the caption resource parts that the API response will
       * include. Set the parameter value to snippet.
       */
      @com.google.api.client.util.Key
      private java.util.List<java.lang.String> part;

      /** The *part* parameter specifies the caption resource parts that the API response will include. Set
     the parameter value to snippet.
       */
      public java.util.List<java.lang.String> getPart() {
        return part;
      }

      /**
       * The *part* parameter specifies the caption resource parts that the API response will
       * include. Set the parameter value to snippet.
       */
      public Insert setPart(java.util.List<java.lang.String> part) {
        this.part = part;
        return this;
      }

      /** ID of the Google+ Page for the channel that the request is be on behalf of */
      @com.google.api.client.util.Key
      private java.lang.String onBehalfOf;

      /** ID of the Google+ Page for the channel that the request is be on behalf of
       */
      public java.lang.String getOnBehalfOf() {
        return onBehalfOf;
      }

      /** ID of the Google+ Page for the channel that the request is be on behalf of */
      public Insert setOnBehalfOf(java.lang.String onBehalfOf) {
        this.onBehalfOf = onBehalfOf;
        return this;
      }

      /**
       * *Note:* This parameter is intended exclusively for YouTube content partners. The
       * *onBehalfOfContentOwner* parameter indicates that the request's authorization credentials
       * identify a YouTube CMS user who is acting on behalf of the content owner specified in the
       * parameter value. This parameter is intended for YouTube content partners that own and
       * manage many different YouTube channels. It allows content owners to authenticate once and
       * get access to all their video and channel data, without having to provide authentication
       * credentials for each individual channel. The actual CMS account that the user authenticates
       * with must be linked to the specified YouTube content owner.
       */
      @com.google.api.client.util.Key
      private java.lang.String onBehalfOfContentOwner;

      /*** Note:* This parameter is intended exclusively for YouTube content partners. The
    * *onBehalfOfContentOwner* parameter indicates that the request's authorization credentials identify
    * a YouTube CMS user who is acting on behalf of the content owner specified in the parameter value.
    * This parameter is intended for YouTube content partners that own and manage many different YouTube
    * channels. It allows content owners to authenticate once and get access to all their video and
    * channel data, without having to provide authentication credentials for each individual channel.
    * The actual CMS account that the user authenticates with must be linked to the specified YouTube
    * content owner.
    *

       */
      public java.lang.String getOnBehalfOfContentOwner() {
        return onBehalfOfContentOwner;
      }

      /**
       * *Note:* This parameter is intended exclusively for YouTube content partners. The
       * *onBehalfOfContentOwner* parameter indicates that the request's authorization credentials
       * identify a YouTube CMS user who is acting on behalf of the content owner specified in the
       * parameter value. This parameter is intended for YouTube content partners that own and
       * manage many different YouTube channels. It allows content owners to authenticate once and
       * get access to all their video and channel data, without having to provide authentication
       * credentials for each individual channel. The actual CMS account that the user authenticates
       * with must be linked to the specified YouTube content owner.
       */
      public Insert setOnBehalfOfContentOwner(java.lang.String onBehalfOfContentOwner) {
        this.onBehalfOfContentOwner = onBehalfOfContentOwner;
        return this;
      }

      /**
       * Extra parameter to allow automatically syncing the uploaded caption/transcript with the
       * audio.
       */
      @com.google.api.client.util.Key
      private java.lang.Boolean sync;

      /** Extra parameter to allow automatically syncing the uploaded caption/transcript with the audio.
       */
      public java.lang.Boolean getSync() {
        return sync;
      }

      /**
       * Extra parameter to allow automatically syncing the uploaded caption/transcript with the
       * audio.
       */
      public Insert setSync(java.lang.Boolean sync) {
        this.sync = sync;
        return this;
      }

      @Override
      public Insert set(String parameterName, Object value) {
        return (Insert) super.set(parameterName, value);
      }
    }
    /**
     * Retrieves a list of resources, possibly filtered.
     *
     * Create a request for the method "captions.list".
     *
     * This request holds the parameters needed by the youtube server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param part The *part* parameter specifies a comma-separated list of one or more caption resource parts that the
     *        API response will include. The part names that you can include in the parameter value are
     *        id and snippet.
     * @param videoId Returns the captions for the specified video.
     * @return the request
     */
    public List list(java.util.List<java.lang.String> part, java.lang.String videoId) throws java.io.IOException {
      List result = new List(part, videoId);
      initialize(result);
      return result;
    }

    public class List extends YouTubeRequest<com.google.api.services.youtube.model.CaptionListResponse> {

      private static final String REST_PATH = "youtube/v3/captions";

      /**
       * Retrieves a list of resources, possibly filtered.
       *
       * Create a request for the method "captions.list".
       *
       * This request holds the parameters needed by the the youtube server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param part The *part* parameter specifies a comma-separated list of one or more caption resource parts that the
     *        API response will include. The part names that you can include in the parameter value are
     *        id and snippet.
       * @param videoId Returns the captions for the specified video.
       * @since 1.13
       */
      protected List(java.util.List<java.lang.String> part, java.lang.String videoId) {
        super(YouTube.this, "GET", REST_PATH, null, com.google.api.services.youtube.model.CaptionListResponse.class);
        this.part = com.google.api.client.util.Preconditions.checkNotNull(part, "Required parameter part must be specified.");
        this.videoId = com.google.api.client.util.Preconditions.checkNotNull(videoId, "Required parameter videoId must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List set$Xgafv(java.lang.String $Xgafv) {
        return (List) super.set$Xgafv($Xgafv);
      }

      @Override
      public List setAccessToken(java.lang.String accessToken) {
        return (List) super.setAccessToken(accessToken);
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setCallback(java.lang.String callback) {
        return (List) super.setCallback(callback);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUploadType(java.lang.String uploadType) {
        return (List) super.setUploadType(uploadType);
      }

      @Override
      public List setUploadProtocol(java.lang.String uploadProtocol) {
        return (List) super.setUploadProtocol(uploadProtocol);
      }

      /**
       * The *part* parameter specifies a comma-separated list of one or more caption resource parts
       * that the API response will include. The part names that you can include in the parameter
       * value are id and snippet.
       */
      @com.google.api.client.util.Key
      private java.util.List<java.lang.String> part;

      /** The *part* parameter specifies a comma-separated list of one or more caption resource parts that
     the API response will include. The part names that you can include in the parameter value are id
     and snippet.
       */
      public java.util.List<java.lang.String> getPart() {
        return part;
      }

      /**
       * The *part* parameter specifies a comma-separated list of one or more caption resource parts
       * that the API response will include. The part names that you can include in the parameter
       * value are id and snippet.
       */
      public List setPart(java.util.List<java.lang.String> part) {
        this.part = part;
        return this;
      }

      /** Returns the captions for the specified video. */
      @com.google.api.client.util.Key
      private java.lang.String videoId;

      /** Returns the captions for the specified video.
       */
      public java.lang.String getVideoId() {
        return videoId;
      }

      /** Returns the captions for the specified video. */
      public List setVideoId(java.lang.String videoId) {
        this.videoId = videoId;
        return this;
      }

      /** Returns the captions with the given IDs for Stubby or Apiary. */
      @com.google.api.client.util.Key
      private java.util.List<java.lang.String> id;

      /** Returns the captions with the given IDs for Stubby or Apiary.
       */
      public java.util.List<java.lang.String> getId() {
        return id;
      }

      /** Returns the captions with the given IDs for Stubby or Apiary. */
      public List setId(java.util.List<java.lang.String> id) {
        this.id = id;
        return this;
      }

      /** ID of the Google+ Page for the channel that the request is on behalf of. */
      @com.google.api.client.util.Key
      private java.lang.String onBehalfOf;

      /** ID of the Google+ Page for the channel that the request is on behalf of.
       */
      public java.lang.String getOnBehalfOf() {
        return onBehalfOf;
      }

      /** ID of the Google+ Page for the channel that the request is on behalf of. */
      public List setOnBehalfOf(java.lang.String onBehalfOf) {
        this.onBehalfOf = onBehalfOf;
        return this;
      }

      /**
       * *Note:* This parameter is intended exclusively for YouTube content partners. The
       * *onBehalfOfContentOwner* parameter indicates that the request's authorization credentials
       * identify a YouTube CMS user who is acting on behalf of the content owner specified in the
       * parameter value. This parameter is intended for YouTube content partners that own and
       * manage many different YouTube channels. It allows content owners to authenticate once and
       * get access to all their video and channel data, without having to provide authentication
       * credentials for each individual channel. The actual CMS account that the user authenticates
       * with must be linked to the specified YouTube content owner.
       */
      @com.google.api.client.util.Key
      private java.lang.String onBehalfOfContentOwner;

      /*** Note:* This parameter is intended exclusively for YouTube content partners. The
    * *onBehalfOfContentOwner* parameter indicates that the request's authorization credentials identify
    * a YouTube CMS user who is acting on behalf of the content owner specified in the parameter value.
    * This parameter is intended for YouTube content partners that own and manage many different YouTube
    * channels. It allows content owners to authenticate once and get access to all their video and
    * channel data, without having to provide authentication credentials for each individual channel.
    * The actual CMS account that the user authenticates with must be linked to the specified YouTube
    * content owner.
    *

       */
      public java.lang.String getOnBehalfOfContentOwner() {
        return onBehalfOfContentOwner;
      }

      /**
       * *Note:* This parameter is intended exclusively for YouTube content partners. The
       * *onBehalfOfContentOwner* parameter indicates that the request's authorization credentials
       * identify a YouTube CMS user who is acting on behalf of the content owner specified in the
       * parameter value. This parameter is intended for YouTube content partners that own and
       * manage many different YouTube channels. It allows content owners to authenticate once and
       * get access to all their video and channel data, without having to provide authentication
       * credentials for each individual channel. The actual CMS account that the user authenticates
       * with must be linked to the specified YouTube content owner.
       */
      public List setOnBehalfOfContentOwner(java.lang.String onBehalfOfContentOwner) {
        this.onBehalfOfContentOwner = onBehalfOfContentOwner;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }
    /**
     * Updates an existing resource.
     *
     * Create a request for the method "captions.update".
     *
     * This request holds the parameters needed by the youtube server.  After setting any optional
     * parameters, call the {@link Update#execute()} method to invoke the remote operation.
     *
     * @param part The *part* parameter specifies a comma-separated list of one or more caption resource parts that the
     *        API response will include. The part names that you can include in the parameter value are
     *        id and snippet.
     * @param content the {@link com.google.api.services.youtube.model.Caption}
     * @return the request
     */
    public Update update(java.util.List<java.lang.String> part, com.google.api.services.youtube.model.Caption content) throws java.io.IOException {
      Update result = new Update(part, content);
      initialize(result);
      return result;
    }

    /**
     * Updates an existing resource.
     *
     * Create a request for the method "captions.update".
     *
     * This request holds the parameters needed by the the youtube server.  After setting any optional
     * parameters, call the {@link Update#execute()} method to invoke the remote operation.
     *
     * <p>
     * This method should be used for uploading media content.
     * </p>
     *
     * @param part The *part* parameter specifies a comma-separated list of one or more caption resource parts that the
     *        API response will include. The part names that you can include in the parameter value are
     *        id and snippet.
     * @param content the {@link com.google.api.services.youtube.model.Caption} media metadata or {@code null} if none
     * @param mediaContent The media HTTP content or {@code null} if none.
     * @return the request
     * @throws java.io.IOException if the initialization of the request fails
     */
    public Update update(java.util.List<java.lang.String> part, com.google.api.services.youtube.model.Caption content, com.google.api.client.http.AbstractInputStreamContent mediaContent) throws java.io.IOException {
      Update result = new Update(part, content, mediaContent);
      initialize(result);
      return result;
    }

    public class Update extends YouTubeRequest<com.google.api.services.youtube.model.Caption> {

      private static final String REST_PATH = "youtube/v3/captions";

      /**
       * Updates an existing resource.
       *
       * Create a request for the method "captions.update".
       *
       * This request holds the parameters needed by the the youtube server.  After setting any optional
       * parameters, call the {@link Update#execute()} method to invoke the remote operation. <p> {@link
       * Update#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param part The *part* parameter specifies a comma-separated list of one or more caption resource parts that the
     *        API response will include. The part names that you can include in the parameter value are
     *        id and snippet.
       * @param content the {@link com.google.api.services.youtube.model.Caption}
       * @since 1.13
       */
      protected Update(java.util.List<java.lang.String> part, com.google.api.services.youtube.model.Caption content) {
        super(YouTube.this, "PUT", REST_PATH, content, com.google.api.services.youtube.model.Caption.class);
        this.part = com.google.api.client.util.Preconditions.checkNotNull(part, "Required parameter part must be specified.");
        checkRequiredParameter(content, "content");
        checkRequiredParameter(content.getId(), "Caption.getId()");
      }

      /**
       * Updates an existing resource.
       *
       * Create a request for the method "captions.update".
       *
       * This request holds the parameters needed by the the youtube server.  After setting any optional
       * parameters, call the {@link Update#execute()} method to invoke the remote operation. <p> {@link
       * Update#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * <p>
       * This constructor should be used for uploading media content.
       * </p>
       *
       * @param part The *part* parameter specifies a comma-separated list of one or more caption resource parts that the
     *        API response will include. The part names that you can include in the parameter value are
     *        id and snippet.
       * @param content the {@link com.google.api.services.youtube.model.Caption} media metadata or {@code null} if none
       * @param mediaContent The media HTTP content or {@code null} if none.
       * @since 1.13
       */
      protected Update(java.util.List<java.lang.String> part, com.google.api.services.youtube.model.Caption content, com.google.api.client.http.AbstractInputStreamContent mediaContent) {
        super(YouTube.this, "PUT", "/upload/" + getServicePath() + REST_PATH, content, com.google.api.services.youtube.model.Caption.class);
        this.part = com.google.api.client.util.Preconditions.checkNotNull(part, "Required parameter part must be specified.");
        initializeMediaUpload(mediaContent);
      }

      @Override
      public Update set$Xgafv(java.lang.String $Xgafv) {
        return (Update) super.set$Xgafv($Xgafv);
      }

      @Override
      public Update setAccessToken(java.lang.String accessToken) {
        return (Update) super.setAccessToken(accessToken);
      }

      @Override
      public Update setAlt(java.lang.String alt) {
        return (Update) super.setAlt(alt);
      }

      @Override
      public Update setCallback(java.lang.String callback) {
        return (Update) super.setCallback(callback);
      }

      @Override
      public Update setFields(java.lang.String fields) {
        return (Update) super.setFields(fields);
      }

      @Override
      public Update setKey(java.lang.String key) {
        return (Update) super.setKey(key);
      }

      @Override
      public Update setOauthToken(java.lang.String oauthToken) {
        return (Update) super.setOauthToken(oauthToken);
      }

      @Override
      public Update setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Update) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Update setQuotaUser(java.lang.String quotaUser) {
        return (Update) super.setQuotaUser(quotaUser);
      }

      @Override
      public Update setUploadType(java.lang.String uploadType) {
        return (Update) super.setUploadType(uploadType);
      }

      @Override
      public Update setUploadProtocol(java.lang.String uploadProtocol) {
        return (Update) super.setUploadProtocol(uploadProtocol);
      }

      /**
       * The *part* parameter specifies a comma-separated list of one or more caption resource parts
       * that the API response will include. The part names that you can include in the parameter
       * value are id and snippet.
       */
      @com.google.api.client.util.Key
      private java.util.List<java.lang.String> part;

      /** The *part* parameter specifies a comma-separated list of one or more caption resource parts that
     the API response will include. The part names that you can include in the parameter value are id
     and snippet.
       */
      public java.util.List<java.lang.String> getPart() {
        return part;
      }

      /**
       * The *part* parameter specifies a comma-separated list of one or more caption resource parts
       * that the API response will include. The part names that you can include in the parameter
       * value are id and snippet.
       */
      public Update setPart(java.util.List<java.lang.String> part) {
        this.part = part;
        return this;
      }

      /** ID of the Google+ Page for the channel that the request is on behalf of. */
      @com.google.api.client.util.Key
      private java.lang.String onBehalfOf;

      /** ID of the Google+ Page for the channel that the request is on behalf of.
       */
      public java.lang.String getOnBehalfOf() {
        return onBehalfOf;
      }

      /** ID of the Google+ Page for the channel that the request is on behalf of. */
      public Update setOnBehalfOf(java.lang.String onBehalfOf) {
        this.onBehalfOf = onBehalfOf;
        return this;
      }

      /**
       * *Note:* This parameter is intended exclusively for YouTube content partners. The
       * *onBehalfOfContentOwner* parameter indicates that the request's authorization credentials
       * identify a YouTube CMS user who is acting on behalf of the content owner specified in the
       * parameter value. This parameter is intended for YouTube content partners that own and
       * manage many different YouTube channels. It allows content owners to authenticate once and
       * get access to all their video and channel data, without having to provide authentication
       * credentials for each individual channel. The actual CMS account that the user authenticates
       * with must be linked to the specified YouTube content owner.
       */
      @com.google.api.client.util.Key
      private java.lang.String onBehalfOfContentOwner;

      /*** Note:* This parameter is intended exclusively for YouTube content partners. The
    * *onBehalfOfContentOwner* parameter indicates that the request's authorization credentials identify
    * a YouTube CMS user who is acting on behalf of the content owner specified in the parameter value.
    * This parameter is intended for YouTube content partners that own and manage many different YouTube
    * channels. It allows content owners to authenticate once and get access to all their video and
    * channel data, without having to provide authentication credentials for each individual channel.
    * The actual CMS account that the user authenticates with must be linked to the specified YouTube
    * content owner.
    *

       */
      public java.lang.String getOnBehalfOfContentOwner() {
        return onBehalfOfContentOwner;
      }

      /**
       * *Note:* This parameter is intended exclusively for YouTube content partners. The
       * *onBehalfOfContentOwner* parameter indicates that the request's authorization credentials
       * identify a YouTube CMS user who is acting on behalf of the content owner specified in the
       * parameter value. This parameter is intended for YouTube content partners that own and
       * manage many different YouTube channels. It allows content owners to authenticate once and
       * get access to all their video and channel data, without having to provide authentication
       * credentials for each individual channel. The actual CMS account that the user authenticates
       * with must be linked to the specified YouTube content owner.
       */
      public Update setOnBehalfOfContentOwner(java.lang.String onBehalfOfContentOwner) {
        this.onBehalfOfContentOwner = onBehalfOfContentOwner;
        return this;
      }

      /**
       * Extra parameter to allow automatically syncing the uploaded caption/transcript with the
       * audio.
       */
      @com.google.api.client.util.Key
      private java.lang.Boolean sync;

      /** Extra parameter to allow automatically syncing the uploaded caption/transcript with the audio.
       */
      public java.lang.Boolean getSync() {
        return sync;
      }

      /**
       * Extra parameter to allow automatically syncing the uploaded caption/transcript with the
       * audio.
       */
      public Update setSync(java.lang.Boolean sync) {
        this.sync = sync;
        return this;
      }

      @Override
      public Update set(String parameterName, Object value) {
        return (Update) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the ChannelBanners collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code YouTube youtube = new YouTube(...);}
   *   {@code YouTube.ChannelBanners.List request = youtube.channelBanners().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public ChannelBanners channelBanners() {
    return new ChannelBanners();
  }

  /**
   * The "channelBanners" collection of methods.
   */
  public class ChannelBanners {

    /**
     * Inserts a new resource into this collection.
     *
     * Create a request for the method "channelBanners.insert".
     *
     * This request holds the parameters needed by the youtube server.  After setting any optional
     * parameters, call the {@link Insert#execute()} method to invoke the remote operation.
     *
     * @param content the {@link com.google.api.services.youtube.model.ChannelBannerResource}
     * @return the request
     */
    public Insert insert(com.google.api.services.youtube.model.ChannelBannerResource content) throws java.io.IOException {
      Insert result = new Insert(content);
      initialize(result);
      return result;
    }

    /**
     * Inserts a new resource into this collection.
     *
     * Create a request for the method "channelBanners.insert".
     *
     * This request holds the parameters needed by the the youtube server.  After setting any optional
     * parameters, call the {@link Insert#execute()} method to invoke the remote operation.
     *
     * <p>
     * This method should be used for uploading media content.
     * </p>
     *
     *
     * @param content the {@link com.google.api.services.youtube.model.ChannelBannerResource} media metadata or {@code null} if none
     * @param mediaContent The media HTTP content or {@code null} if none.
     * @return the request
     * @throws java.io.IOException if the initialization of the request fails
     */
    public Insert insert(com.google.api.services.youtube.model.ChannelBannerResource content, com.google.api.client.http.AbstractInputStreamContent mediaContent) throws java.io.IOException {
      Insert result = new Insert(content, mediaContent);
      initialize(result);
      return result;
    }

    public class Insert extends YouTubeRequest<com.google.api.services.youtube.model.ChannelBannerResource> {

      private static final String REST_PATH = "youtube/v3/channelBanners/insert";

      /**
       * Inserts a new resource into this collection.
       *
       * Create a request for the method "channelBanners.insert".
       *
       * This request holds the parameters needed by the the youtube server.  After setting any optional
       * parameters, call the {@link Insert#execute()} method to invoke the remote operation. <p> {@link
       * Insert#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param content the {@link com.google.api.services.youtube.model.ChannelBannerResource}
       * @since 1.13
       */
      protected Insert(com.google.api.services.youtube.model.ChannelBannerResource content) {
        super(YouTube.this, "POST", REST_PATH, content, com.google.api.services.youtube.model.ChannelBannerResource.class);
      }

      /**
       * Inserts a new resource into this collection.
       *
       * Create a request for the method "channelBanners.insert".
       *
       * This request holds the parameters needed by the the youtube server.  After setting any optional
       * parameters, call the {@link Insert#execute()} method to invoke the remote operation. <p> {@link
       * Insert#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * <p>
       * This constructor should be used for uploading media content.
       * </p>
       *
       *
       * @param content the {@link com.google.api.services.youtube.model.ChannelBannerResource} media metadata or {@code null} if none
       * @param mediaContent The media HTTP content or {@code null} if none.
       * @since 1.13
       */
      protected Insert(com.google.api.services.youtube.model.ChannelBannerResource content, com.google.api.client.http.AbstractInputStreamContent mediaContent) {
        super(YouTube.this, "POST", "/upload/" + getServicePath() + REST_PATH, content, com.google.api.services.youtube.model.ChannelBannerResource.class);
        initializeMediaUpload(mediaContent);
      }

      @Override
      public Insert set$Xgafv(java.lang.String $Xgafv) {
        return (Insert) super.set$Xgafv($Xgafv);
      }

      @Override
      public Insert setAccessToken(java.lang.String accessToken) {
        return (Insert) super.setAccessToken(accessToken);
      }

      @Override
      public Insert setAlt(java.lang.String alt) {
        return (Insert) super.setAlt(alt);
      }

      @Override
      public Insert setCallback(java.lang.String callback) {
        return (Insert) super.setCallback(callback);
      }

      @Override
      public Insert setFields(java.lang.String fields) {
        return (Insert) super.setFields(fields);
      }

      @Override
      public Insert setKey(java.lang.String key) {
        return (Insert) super.setKey(key);
      }

      @Override
      public Insert setOauthToken(java.lang.String oauthToken) {
        return (Insert) super.setOauthToken(oauthToken);
      }

      @Override
      public Insert setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Insert) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Insert setQuotaUser(java.lang.String quotaUser) {
        return (Insert) super.setQuotaUser(quotaUser);
      }

      @Override
      public Insert setUploadType(java.lang.String uploadType) {
        return (Insert) super.setUploadType(uploadType);
      }

      @Override
      public Insert setUploadProtocol(java.lang.String uploadProtocol) {
        return (Insert) super.setUploadProtocol(uploadProtocol);
      }

      /** Unused, channel_id is currently derived from the security context of the requestor. */
      @com.google.api.client.util.Key
      private java.lang.String channelId;

      /** Unused, channel_id is currently derived from the security context of the requestor.
       */
      public java.lang.String getChannelId() {
        return channelId;
      }

      /** Unused, channel_id is currently derived from the security context of the requestor. */
      public Insert setChannelId(java.lang.String channelId) {
        this.channelId = channelId;
        return this;
      }

      /**
       * *Note:* This parameter is intended exclusively for YouTube content partners. The
       * *onBehalfOfContentOwner* parameter indicates that the request's authorization credentials
       * identify a YouTube CMS user who is acting on behalf of the content owner specified in the
       * parameter value. This parameter is intended for YouTube content partners that own and
       * manage many different YouTube channels. It allows content owners to authenticate once and
       * get access to all their video and channel data, without having to provide authentication
       * credentials for each individual channel. The actual CMS account that the user authenticates
       * with must be linked to the specified YouTube content owner.
       */
      @com.google.api.client.util.Key
      private java.lang.String onBehalfOfContentOwner;

      /*** Note:* This parameter is intended exclusively for YouTube content partners. The
    * *onBehalfOfContentOwner* parameter indicates that the request's authorization credentials identify
    * a YouTube CMS user who is acting on behalf of the content owner specified in the parameter value.
    * This parameter is intended for YouTube content partners that own and manage many different YouTube
    * channels. It allows content owners to authenticate once and get access to all their video and
    * channel data, without having to provide authentication credentials for each individual channel.
    * The actual CMS account that the user authenticates with must be linked to the specified YouTube
    * content owner.
    *

       */
      public java.lang.String getOnBehalfOfContentOwner() {
        return onBehalfOfContentOwner;
      }

      /**
       * *Note:* This parameter is intended exclusively for YouTube content partners. The
       * *onBehalfOfContentOwner* parameter indicates that the request's authorization credentials
       * identify a YouTube CMS user who is acting on behalf of the content owner specified in the
       * parameter value. This parameter is intended for YouTube content partners that own and
       * manage many different YouTube channels. It allows content owners to authenticate once and
       * get access to all their video and channel data, without having to provide authentication
       * credentials for each individual channel. The actual CMS account that the user authenticates
       * with must be linked to the specified YouTube content owner.
       */
      public Insert setOnBehalfOfContentOwner(java.lang.String onBehalfOfContentOwner) {
        this.onBehalfOfContentOwner = onBehalfOfContentOwner;
        return this;
      }

      /**
       * This parameter can only be used in a properly authorized request. *Note:* This parameter is
       * intended exclusively for YouTube content partners. The *onBehalfOfContentOwnerChannel*
       * parameter specifies the YouTube channel ID of the channel to which a video is being added.
       * This parameter is required when a request specifies a value for the onBehalfOfContentOwner
       * parameter, and it can only be used in conjunction with that parameter. In addition, the
       * request must be authorized using a CMS account that is linked to the content owner that the
       * onBehalfOfContentOwner parameter specifies. Finally, the channel that the
       * onBehalfOfContentOwnerChannel parameter value specifies must be linked to the content owner
       * that the onBehalfOfContentOwner parameter specifies. This parameter is intended for YouTube
       * content partners that own and manage many different YouTube channels. It allows content
       * owners to authenticate once and perform actions on behalf of the channel specified in the
       * parameter value, without having to provide authentication credentials for each separate
       * channel.
       */
      @com.google.api.client.util.Key
      private java.lang.String onBehalfOfContentOwnerChannel;

      /** This parameter can only be used in a properly authorized request. *Note:* This parameter is
     intended exclusively for YouTube content partners. The *onBehalfOfContentOwnerChannel* parameter
     specifies the YouTube channel ID of the channel to which a video is being added. This parameter is
     required when a request specifies a value for the onBehalfOfContentOwner parameter, and it can only
     be used in conjunction with that parameter. In addition, the request must be authorized using a CMS
     account that is linked to the content owner that the onBehalfOfContentOwner parameter specifies.
     Finally, the channel that the onBehalfOfContentOwnerChannel parameter value specifies must be
     linked to the content owner that the onBehalfOfContentOwner parameter specifies. This parameter is
     intended for YouTube content partners that own and manage many different YouTube channels. It
     allows content owners to authenticate once and perform actions on behalf of the channel specified
     in the parameter value, without having to provide authentication credentials for each separate
     channel.
       */
      public java.lang.String getOnBehalfOfContentOwnerChannel() {
        return onBehalfOfContentOwnerChannel;
      }

      /**
       * This parameter can only be used in a properly authorized request. *Note:* This parameter is
       * intended exclusively for YouTube content partners. The *onBehalfOfContentOwnerChannel*
       * parameter specifies the YouTube channel ID of the channel to which a video is being added.
       * This parameter is required when a request specifies a value for the onBehalfOfContentOwner
       * parameter, and it can only be used in conjunction with that parameter. In addition, the
       * request must be authorized using a CMS account that is linked to the content owner that the
       * onBehalfOfContentOwner parameter specifies. Finally, the channel that the
       * onBehalfOfContentOwnerChannel parameter value specifies must be linked to the content owner
       * that the onBehalfOfContentOwner parameter specifies. This parameter is intended for YouTube
       * content partners that own and manage many different YouTube channels. It allows content
       * owners to authenticate once and perform actions on behalf of the channel specified in the
       * parameter value, without having to provide authentication credentials for each separate
       * channel.
       */
      public Insert setOnBehalfOfContentOwnerChannel(java.lang.String onBehalfOfContentOwnerChannel) {
        this.onBehalfOfContentOwnerChannel = onBehalfOfContentOwnerChannel;
        return this;
      }

      @Override
      public Insert set(String parameterName, Object value) {
        return (Insert) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the ChannelSections collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code YouTube youtube = new YouTube(...);}
   *   {@code YouTube.ChannelSections.List request = youtube.channelSections().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public ChannelSections channelSections() {
    return new ChannelSections();
  }

  /**
   * The "channelSections" collection of methods.
   */
  public class ChannelSections {

    /**
     * Deletes a resource.
     *
     * Create a request for the method "channelSections.delete".
     *
     * This request holds the parameters needed by the youtube server.  After setting any optional
     * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
     *
     * @param id
     * @return the request
     */
    public Delete delete(java.lang.String id) throws java.io.IOException {
      Delete result = new Delete(id);
      initialize(result);
      return result;
    }

    public class Delete extends YouTubeRequest<Void> {

      private static final String REST_PATH = "youtube/v3/channelSections";

      /**
       * Deletes a resource.
       *
       * Create a request for the method "channelSections.delete".
       *
       * This request holds the parameters needed by the the youtube server.  After setting any optional
       * parameters, call the {@link Delete#execute()} method to invoke the remote operation. <p> {@link
       * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param id
       * @since 1.13
       */
      protected Delete(java.lang.String id) {
        super(YouTube.this, "DELETE", REST_PATH, null, Void.class);
        this.id = com.google.api.client.util.Preconditions.checkNotNull(id, "Required parameter id must be specified.");
      }

      @Override
      public Delete set$Xgafv(java.lang.String $Xgafv) {
        return (Delete) super.set$Xgafv($Xgafv);
      }

      @Override
      public Delete setAccessToken(java.lang.String accessToken) {
        return (Delete) super.setAccessToken(accessToken);
      }

      @Override
      public Delete setAlt(java.lang.String alt) {
        return (Delete) super.setAlt(alt);
      }

      @Override
      public Delete setCallback(java.lang.String callback) {
        return (Delete) super.setCallback(callback);
      }

      @Override
      public Delete setFields(java.lang.String fields) {
        return (Delete) super.setFields(fields);
      }

      @Override
      public Delete setKey(java.lang.String key) {
        return (Delete) super.setKey(key);
      }

      @Override
      public Delete setOauthToken(java.lang.String oauthToken) {
        return (Delete) super.setOauthToken(oauthToken);
      }

      @Override
      public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Delete) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Delete setQuotaUser(java.lang.String quotaUser) {
        return (Delete) super.setQuotaUser(quotaUser);
      }

      @Override
      public Delete setUploadType(java.lang.String uploadType) {
        return (Delete) super.setUploadType(uploadType);
      }

      @Override
      public Delete setUploadProtocol(java.lang.String uploadProtocol) {
        return (Delete) super.setUploadProtocol(uploadProtocol);
      }

      @com.google.api.client.util.Key
      private java.lang.String id;

      /**

       */
      public java.lang.String getId() {
        return id;
      }

      public Delete setId(java.lang.String id) {
        this.id = id;
        return this;
      }

      /**
       * *Note:* This parameter is intended exclusively for YouTube content partners. The
       * *onBehalfOfContentOwner* parameter indicates that the request's authorization credentials
       * identify a YouTube CMS user who is acting on behalf of the content owner specified in the
       * parameter value. This parameter is intended for YouTube content partners that own and
       * manage many different YouTube channels. It allows content owners to authenticate once and
       * get access to all their video and channel data, without having to provide authentication
       * credentials for each individual channel. The CMS account that the user authenticates with
       * must be linked to the specified YouTube content owner.
       */
      @com.google.api.client.util.Key
      private java.lang.String onBehalfOfContentOwner;

      /*** Note:* This parameter is intended exclusively for YouTube content partners. The
    * *onBehalfOfContentOwner* parameter indicates that the request's authorization credentials identify
    * a YouTube CMS user who is acting on behalf of the content owner specified in the parameter value.
    * This parameter is intended for YouTube content partners that own and manage many different YouTube
    * channels. It allows content owners to authenticate once and get access to all their video and
    * channel data, without having to provide authentication credentials for each individual channel.
    * The CMS account that the user authenticates with must be linked to the specified YouTube content
    * owner.
    *

       */
      public java.lang.String getOnBehalfOfContentOwner() {
        return onBehalfOfContentOwner;
      }

      /**
       * *Note:* This parameter is intended exclusively for YouTube content partners. The
       * *onBehalfOfContentOwner* parameter indicates that the request's authorization credentials
       * identify a YouTube CMS user who is acting on behalf of the content owner specified in the
       * parameter value. This parameter is intended for YouTube content partners that own and
       * manage many different YouTube channels. It allows content owners to authenticate once and
       * get access to all their video and channel data, without having to provide authentication
       * credentials for each individual channel. The CMS account that the user authenticates with
       * must be linked to the specified YouTube content owner.
       */
      public Delete setOnBehalfOfContentOwner(java.lang.String onBehalfOfContentOwner) {
        this.onBehalfOfContentOwner = onBehalfOfContentOwner;
        return this;
      }

      @Override
      public Delete set(String parameterName, Object value) {
        return (Delete) super.set(parameterName, value);
      }
    }
    /**
     * Inserts a new resource into this collection.
     *
     * Create a request for the method "channelSections.insert".
     *
     * This request holds the parameters needed by the youtube server.  After setting any optional
     * parameters, call the {@link Insert#execute()} method to invoke the remote operation.
     *
     * @param part The *part* parameter serves two purposes in this operation. It identifies the properties that the
     *        write operation will set as well as the properties that the API response will include. The
     *        part names that you can include in the parameter value are snippet and contentDetails.
     * @param content the {@link com.google.api.services.youtube.model.ChannelSection}
     * @return the request
     */
    public Insert insert(java.util.List<java.lang.String> part, com.google.api.services.youtube.model.ChannelSection content) throws java.io.IOException {
      Insert result = new Insert(part, content);
      initialize(result);
      return result;
    }

    public class Insert extends YouTubeRequest<com.google.api.services.youtube.model.ChannelSection> {

      private static final String REST_PATH = "youtube/v3/channelSections";

      /**
       * Inserts a new resource into this collection.
       *
       * Create a request for the method "channelSections.insert".
       *
       * This request holds the parameters needed by the the youtube server.  After setting any optional
       * parameters, call the {@link Insert#execute()} method to invoke the remote operation. <p> {@link
       * Insert#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param part The *part* parameter serves two purposes in this operation. It identifies the properties that the
     *        write operation will set as well as the properties that the API response will include. The
     *        part names that you can include in the parameter value are snippet and contentDetails.
       * @param content the {@link com.google.api.services.youtube.model.ChannelSection}
       * @since 1.13
       */
      protected Insert(java.util.List<java.lang.String> part, com.google.api.services.youtube.model.ChannelSection content) {
        super(YouTube.this, "POST", REST_PATH, content, com.google.api.services.youtube.model.ChannelSection.class);
        this.part = com.google.api.client.util.Preconditions.checkNotNull(part, "Required parameter part must be specified.");
      }

      @Override
      public Insert set$Xgafv(java.lang.String $Xgafv) {
        return (Insert) super.set$Xgafv($Xgafv);
      }

      @Override
      public Insert setAccessToken(java.lang.String accessToken) {
        return (Insert) super.setAccessToken(accessToken);
      }

      @Override
      public Insert setAlt(java.lang.String alt) {
        return (Insert) super.setAlt(alt);
      }

      @Override
      public Insert setCallback(java.lang.String callback) {
        return (Insert) super.setCallback(callback);
      }

      @Override
      public Insert setFields(java.lang.String fields) {
        return (Insert) super.setFields(fields);
      }

      @Override
      public Insert setKey(java.lang.String key) {
        return (Insert) super.setKey(key);
      }

      @Override
      public Insert setOauthToken(java.lang.String oauthToken) {
        return (Insert) super.setOauthToken(oauthToken);
      }

      @Override
      public Insert setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Insert) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Insert setQuotaUser(java.lang.String quotaUser) {
        return (Insert) super.setQuotaUser(quotaUser);
      }

      @Override
      public Insert setUploadType(java.lang.String uploadType) {
        return (Insert) super.setUploadType(uploadType);
      }

      @Override
      public Insert setUploadProtocol(java.lang.String uploadProtocol) {
        return (Insert) super.setUploadProtocol(uploadProtocol);
      }

      /**
       * The *part* parameter serves two purposes in this operation. It identifies the properties
       * that the write operation will set as well as the properties that the API response will
       * include. The part names that you can include in the parameter value are snippet and
       * contentDetails.
       */
      @com.google.api.client.util.Key
      private java.util.List<java.lang.String> part;

      /** The *part* parameter serves two purposes in this operation. It identifies the properties that the
     write operation will set as well as the properties that the API response will include. The part
     names that you can include in the parameter value are snippet and contentDetails.
       */
      public java.util.List<java.lang.String> getPart() {
        return part;
      }

      /**
       * The *part* parameter serves two purposes in this operation. It identifies the properties
       * that the write operation will set as well as the properties that the API response will
       * include. The part names that you can include in the parameter value are snippet and
       * contentDetails.
       */
      public Insert setPart(java.util.List<java.lang.String> part) {
        this.part = part;
        return this;
      }

      /**
       * *Note:* This parameter is intended exclusively for YouTube content partners. The
       * *onBehalfOfContentOwner* parameter indicates that the request's authorization credentials
       * identify a YouTube CMS user who is acting on behalf of the content owner specified in the
       * parameter value. This parameter is intended for YouTube content partners that own and
       * manage many different YouTube channels. It allows content owners to authenticate once and
       * get access to all their video and channel data, without having to provide authentication
       * credentials for each individual channel. The CMS account that the user authenticates with
       * must be linked to the specified YouTube content owner.
       */
      @com.google.api.client.util.Key
      private java.lang.String onBehalfOfContentOwner;

      /*** Note:* This parameter is intended exclusively for YouTube content partners. The
    * *onBehalfOfContentOwner* parameter indicates that the request's authorization credentials identify
    * a YouTube CMS user who is acting on behalf of the content owner specified in the parameter value.
    * This parameter is intended for YouTube content partners that own and manage many different YouTube
    * channels. It allows content owners to authenticate once and get access to all their video and
    * channel data, without having to provide authentication credentials for each individual channel.
    * The CMS account that the user authenticates with must be linked to the specified YouTube content
    * owner.
    *

       */
      public java.lang.String getOnBehalfOfContentOwner() {
        return onBehalfOfContentOwner;
      }

      /**
       * *Note:* This parameter is intended exclusively for YouTube content partners. The
       * *onBehalfOfContentOwner* parameter indicates that the request's authorization credentials
       * identify a YouTube CMS user who is acting on behalf of the content owner specified in the
       * parameter value. This parameter is intended for YouTube content partners that own and
       * manage many different YouTube channels. It allows content owners to authenticate once and
       * get access to all their video and channel data, without having to provide authentication
       * credentials for each individual channel. The CMS account that the user authenticates with
       * must be linked to the specified YouTube content owner.
       */
      public Insert setOnBehalfOfContentOwner(java.lang.String onBehalfOfContentOwner) {
        this.onBehalfOfContentOwner = onBehalfOfContentOwner;
        return this;
      }

      /**
       * This parameter can only be used in a properly authorized request. *Note:* This parameter is
       * intended exclusively for YouTube content partners. The *onBehalfOfContentOwnerChannel*
       * parameter specifies the YouTube channel ID of the channel to which a video is being added.
       * This parameter is required when a request specifies a value for the onBehalfOfContentOwner
       * parameter, and it can only be used in conjunction with that parameter. In addition, the
       * request must be authorized using a CMS account that is linked to the content owner that the
       * onBehalfOfContentOwner parameter specifies. Finally, the channel that the
       * onBehalfOfContentOwnerChannel parameter value specifies must be linked to the content owner
       * that the onBehalfOfContentOwner parameter specifies. This parameter is intended for YouTube
       * content partners that own and manage many different YouTube channels. It allows content
       * owners to authenticate once and perform actions on behalf of the channel specified in the
       * parameter value, without having to provide authentication credentials for each separate
       * channel.
       */
      @com.google.api.client.util.Key
      private java.lang.String onBehalfOfContentOwnerChannel;

      /** This parameter can only be used in a properly authorized request. *Note:* This parameter is
     intended exclusively for YouTube content partners. The *onBehalfOfContentOwnerChannel* parameter
     specifies the YouTube channel ID of the channel to which a video is being added. This parameter is
     required when a request specifies a value for the onBehalfOfContentOwner parameter, and it can only
     be used in conjunction with that parameter. In addition, the request must be authorized using a CMS
     account that is linked to the content owner that the onBehalfOfContentOwner parameter specifies.
     Finally, the channel that the onBehalfOfContentOwnerChannel parameter value specifies must be
     linked to the content owner that the onBehalfOfContentOwner parameter specifies. This parameter is
     intended for YouTube content partners that own and manage many different YouTube channels. It
     allows content owners to authenticate once and perform actions on behalf of the channel specified
     in the parameter value, without having to provide authentication credentials for each separate
     channel.
       */
      public java.lang.String getOnBehalfOfContentOwnerChannel() {
        return onBehalfOfContentOwnerChannel;
      }

      /**
       * This parameter can only be used in a properly authorized request. *Note:* This parameter is
       * intended exclusively for YouTube content partners. The *onBehalfOfContentOwnerChannel*
       * parameter specifies the YouTube channel ID of the channel to which a video is being added.
       * This parameter is required when a request specifies a value for the onBehalfOfContentOwner
       * parameter, and it can only be used in conjunction with that parameter. In addition, the
       * request must be authorized using a CMS account that is linked to the content owner that the
       * onBehalfOfContentOwner parameter specifies. Finally, the channel that the
       * onBehalfOfContentOwnerChannel parameter value specifies must be linked to the content owner
       * that the onBehalfOfContentOwner parameter specifies. This parameter is intended for YouTube
       * content partners that own and manage many different YouTube channels. It allows content
       * owners to authenticate once and perform actions on behalf of the channel specified in the
       * parameter value, without having to provide authentication credentials for each separate
       * channel.
       */
      public Insert setOnBehalfOfContentOwnerChannel(java.lang.String onBehalfOfContentOwnerChannel) {
        this.onBehalfOfContentOwnerChannel = onBehalfOfContentOwnerChannel;
        return this;
      }

      @Override
      public Insert set(String parameterName, Object value) {
        return (Insert) super.set(parameterName, value);
      }
    }
    /**
     * Retrieves a list of resources, possibly filtered.
     *
     * Create a request for the method "channelSections.list".
     *
     * This request holds the parameters needed by the youtube server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param part The *part* parameter specifies a comma-separated list of one or more channelSection resource
     *        properties that the API response will include. The part names that you can include in the
     *        parameter value are id, snippet, and contentDetails. If the parameter identifies a
     *        property that contains child properties, the child properties will be included in the
     *        response. For example, in a channelSection resource, the snippet property contains other
     *        properties, such as a display title for the channelSection. If you set *part=snippet*, the
     *        API response will also contain all of those nested properties.
     * @return the request
     */
    public List list(java.util.List<java.lang.String> part) throws java.io.IOException {
      List result = new List(part);
      initialize(result);
      return result;
    }

    public class List extends YouTubeRequest<com.google.api.services.youtube.model.ChannelSectionListResponse> {

      private static final String REST_PATH = "youtube/v3/channelSections";

      /**
       * Retrieves a list of resources, possibly filtered.
       *
       * Create a request for the method "channelSections.list".
       *
       * This request holds the parameters needed by the the youtube server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param part The *part* parameter specifies a comma-separated list of one or more channelSection resource
     *        properties that the API response will include. The part names that you can include in the
     *        parameter value are id, snippet, and contentDetails. If the parameter identifies a
     *        property that contains child properties, the child properties will be included in the
     *        response. For example, in a channelSection resource, the snippet property contains other
     *        properties, such as a display title for the channelSection. If you set *part=snippet*, the
     *        API response will also contain all of those nested properties.
       * @since 1.13
       */
      protected List(java.util.List<java.lang.String> part) {
        super(YouTube.this, "GET", REST_PATH, null, com.google.api.services.youtube.model.ChannelSectionListResponse.class);
        this.part = com.google.api.client.util.Preconditions.checkNotNull(part, "Required parameter part must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List set$Xgafv(java.lang.String $Xgafv) {
        return (List) super.set$Xgafv($Xgafv);
      }

      @Override
      public List setAccessToken(java.lang.String accessToken) {
        return (List) super.setAccessToken(accessToken);
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setCallback(java.lang.String callback) {
        return (List) super.setCallback(callback);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUploadType(java.lang.String uploadType) {
        return (List) super.setUploadType(uploadType);
      }

      @Override
      public List setUploadProtocol(java.lang.String uploadProtocol) {
        return (List) super.setUploadProtocol(uploadProtocol);
      }

      /**
       * The *part* parameter specifies a comma-separated list of one or more channelSection
       * resource properties that the API response will include. The part names that you can include
       * in the parameter value are id, snippet, and contentDetails. If the parameter identifies a
       * property that contains child properties, the child properties will be included in the
       * response. For example, in a channelSection resource, the snippet property contains other
       * properties, such as a display title for the channelSection. If you set *part=snippet*, the
       * API response will also contain all of those nested properties.
       */
      @com.google.api.client.util.Key
      private java.util.List<java.lang.String> part;

      /** The *part* parameter specifies a comma-separated list of one or more channelSection resource
     properties that the API response will include. The part names that you can include in the parameter
     value are id, snippet, and contentDetails. If the parameter identifies a property that contains
     child properties, the child properties will be included in the response. For example, in a
     channelSection resource, the snippet property contains other properties, such as a display title
     for the channelSection. If you set *part=snippet*, the API response will also contain all of those
     nested properties.
       */
      public java.util.List<java.lang.String> getPart() {
        return part;
      }

      /**
       * The *part* parameter specifies a comma-separated list of one or more channelSection
       * resource properties that the API response will include. The part names that you can include
       * in the parameter value are id, snippet, and contentDetails. If the parameter identifies a
       * property that contains child properties, the child properties will be included in the
       * response. For example, in a channelSection resource, the snippet property contains other
       * properties, such as a display title for the channelSection. If you set *part=snippet*, the
       * API response will also contain all of those nested properties.
       */
      public List setPart(java.util.List<java.lang.String> part) {
        this.part = part;
        return this;
      }

      /** Return the ChannelSections owned by the specified channel ID. */
      @com.google.api.client.util.Key
      private java.lang.String channelId;

      /** Return the ChannelSections owned by the specified channel ID.
       */
      public java.lang.String getChannelId() {
        return channelId;
      }

      /** Return the ChannelSections owned by the specified channel ID. */
      public List setChannelId(java.lang.String channelId) {
        this.channelId = channelId;
        return this;
      }

      /** Return content in specified language */
      @com.google.api.client.util.Key
      private java.lang.String hl;

      /** Return content in specified language
       */
      public java.lang.String getHl() {
        return hl;
      }

      /** Return content in specified language */
      public List setHl(java.lang.String hl) {
        this.hl = hl;
        return this;
      }

      /** Return the ChannelSections with the given IDs for Stubby or Apiary. */
      @com.google.api.client.util.Key
      private java.util.List<java.lang.String> id;

      /** Return the ChannelSections with the given IDs for Stubby or Apiary.
       */
      public java.util.List<java.lang.String> getId() {
        return id;
      }

      /** Return the ChannelSections with the given IDs for Stubby or Apiary. */
      public List setId(java.util.List<java.lang.String> id) {
        this.id = id;
        return this;
      }

      /** Return the ChannelSections owned by the authenticated user. */
      @com.google.api.client.util.Key
      private java.lang.Boolean mine;

      /** Return the ChannelSections owned by the authenticated user.
       */
      public java.lang.Boolean getMine() {
        return mine;
      }

      /** Return the ChannelSections owned by the authenticated user. */
      public List setMine(java.lang.Boolean mine) {
        this.mine = mine;
        return this;
      }

      /**
       * *Note:* This parameter is intended exclusively for YouTube content partners. The
       * *onBehalfOfContentOwner* parameter indicates that the request's authorization credentials
       * identify a YouTube CMS user who is acting on behalf of the content owner specified in the
       * parameter value. This parameter is intended for YouTube content partners that own and
       * manage many different YouTube channels. It allows content owners to authenticate once and
       * get access to all their video and channel data, without having to provide authentication
       * credentials for each individual channel. The CMS account that the user authenticates with
       * must be linked to the specified YouTube content owner.
       */
      @com.google.api.client.util.Key
      private java.lang.String onBehalfOfContentOwner;

      /*** Note:* This parameter is intended exclusively for YouTube content partners. The
    * *onBehalfOfContentOwner* parameter indicates that the request's authorization credentials identify
    * a YouTube CMS user who is acting on behalf of the content owner specified in the parameter value.
    * This parameter is intended for YouTube content partners that own and manage many different YouTube
    * channels. It allows content owners to authenticate once and get access to all their video and
    * channel data, without having to provide authentication credentials for each individual channel.
    * The CMS account that the user authenticates with must be linked to the specified YouTube content
    * owner.
    *

       */
      public java.lang.String getOnBehalfOfContentOwner() {
        return onBehalfOfContentOwner;
      }

      /**
       * *Note:* This parameter is intended exclusively for YouTube content partners. The
       * *onBehalfOfContentOwner* parameter indicates that the request's authorization credentials
       * identify a YouTube CMS user who is acting on behalf of the content owner specified in the
       * parameter value. This parameter is intended for YouTube content partners that own and
       * manage many different YouTube channels. It allows content owners to authenticate once and
       * get access to all their video and channel data, without having to provide authentication
       * credentials for each individual channel. The CMS account that the user authenticates with
       * must be linked to the specified YouTube content owner.
       */
      public List setOnBehalfOfContentOwner(java.lang.String onBehalfOfContentOwner) {
        this.onBehalfOfContentOwner = onBehalfOfContentOwner;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }
    /**
     * Updates an existing resource.
     *
     * Create a request for the method "channelSections.update".
     *
     * This request holds the parameters needed by the youtube server.  After setting any optional
     * parameters, call the {@link Update#execute()} method to invoke the remote operation.
     *
     * @param part The *part* parameter serves two purposes in this operation. It identifies the properties that the
     *        write operation will set as well as the properties that the API response will include. The
     *        part names that you can include in the parameter value are snippet and contentDetails.
     * @param content the {@link com.google.api.services.youtube.model.ChannelSection}
     * @return the request
     */
    public Update update(java.util.List<java.lang.String> part, com.google.api.services.youtube.model.ChannelSection content) throws java.io.IOException {
      Update result = new Update(part, content);
      initialize(result);
      return result;
    }

    public class Update extends YouTubeRequest<com.google.api.services.youtube.model.ChannelSection> {

      private static final String REST_PATH = "youtube/v3/channelSections";

      /**
       * Updates an existing resource.
       *
       * Create a request for the method "channelSections.update".
       *
       * This request holds the parameters needed by the the youtube server.  After setting any optional
       * parameters, call the {@link Update#execute()} method to invoke the remote operation. <p> {@link
       * Update#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param part The *part* parameter serves two purposes in this operation. It identifies the properties that the
     *        write operation will set as well as the properties that the API response will include. The
     *        part names that you can include in the parameter value are snippet and contentDetails.
       * @param content the {@link com.google.api.services.youtube.model.ChannelSection}
       * @since 1.13
       */
      protected Update(java.util.List<java.lang.String> part, com.google.api.services.youtube.model.ChannelSection content) {
        super(YouTube.this, "PUT", REST_PATH, content, com.google.api.services.youtube.model.ChannelSection.class);
        this.part = com.google.api.client.util.Preconditions.checkNotNull(part, "Required parameter part must be specified.");
      }

      @Override
      public Update set$Xgafv(java.lang.String $Xgafv) {
        return (Update) super.set$Xgafv($Xgafv);
      }

      @Override
      public Update setAccessToken(java.lang.String accessToken) {
        return (Update) super.setAccessToken(accessToken);
      }

      @Override
      public Update setAlt(java.lang.String alt) {
        return (Update) super.setAlt(alt);
      }

      @Override
      public Update setCallback(java.lang.String callback) {
        return (Update) super.setCallback(callback);
      }

      @Override
      public Update setFields(java.lang.String fields) {
        return (Update) super.setFields(fields);
      }

      @Override
      public Update setKey(java.lang.String key) {
        return (Update) super.setKey(key);
      }

      @Override
      public Update setOauthToken(java.lang.String oauthToken) {
        return (Update) super.setOauthToken(oauthToken);
      }

      @Override
      public Update setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Update) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Update setQuotaUser(java.lang.String quotaUser) {
        return (Update) super.setQuotaUser(quotaUser);
      }

      @Override
      public Update setUploadType(java.lang.String uploadType) {
        return (Update) super.setUploadType(uploadType);
      }

      @Override
      public Update setUploadProtocol(java.lang.String uploadProtocol) {
        return (Update) super.setUploadProtocol(uploadProtocol);
      }

      /**
       * The *part* parameter serves two purposes in this operation. It identifies the properties
       * that the write operation will set as well as the properties that the API response will
       * include. The part names that you can include in the parameter value are snippet and
       * contentDetails.
       */
      @com.google.api.client.util.Key
      private java.util.List<java.lang.String> part;

      /** The *part* parameter serves two purposes in this operation. It identifies the properties that the
     write operation will set as well as the properties that the API response will include. The part
     names that you can include in the parameter value are snippet and contentDetails.
       */
      public java.util.List<java.lang.String> getPart() {
        return part;
      }

      /**
       * The *part* parameter serves two purposes in this operation. It identifies the properties
       * that the write operation will set as well as the properties that the API response will
       * include. The part names that you can include in the parameter value are snippet and
       * contentDetails.
       */
      public Update setPart(java.util.List<java.lang.String> part) {
        this.part = part;
        return this;
      }

      /**
       * *Note:* This parameter is intended exclusively for YouTube content partners. The
       * *onBehalfOfContentOwner* parameter indicates that the request's authorization credentials
       * identify a YouTube CMS user who is acting on behalf of the content owner specified in the
       * parameter value. This parameter is intended for YouTube content partners that own and
       * manage many different YouTube channels. It allows content owners to authenticate once and
       * get access to all their video and channel data, without having to provide authentication
       * credentials for each individual channel. The CMS account that the user authenticates with
       * must be linked to the specified YouTube content owner.
       */
      @com.google.api.client.util.Key
      private java.lang.String onBehalfOfContentOwner;

      /*** Note:* This parameter is intended exclusively for YouTube content partners. The
    * *onBehalfOfContentOwner* parameter indicates that the request's authorization credentials identify
    * a YouTube CMS user who is acting on behalf of the content owner specified in the parameter value.
    * This parameter is intended for YouTube content partners that own and manage many different YouTube
    * channels. It allows content owners to authenticate once and get access to all their video and
    * channel data, without having to provide authentication credentials for each individual channel.
    * The CMS account that the user authenticates with must be linked to the specified YouTube content
    * owner.
    *

       */
      public java.lang.String getOnBehalfOfContentOwner() {
        return onBehalfOfContentOwner;
      }

      /**
       * *Note:* This parameter is intended exclusively for YouTube content partners. The
       * *onBehalfOfContentOwner* parameter indicates that the request's authorization credentials
       * identify a YouTube CMS user who is acting on behalf of the content owner specified in the
       * parameter value. This parameter is intended for YouTube content partners that own and
       * manage many different YouTube channels. It allows content owners to authenticate once and
       * get access to all their video and channel data, without having to provide authentication
       * credentials for each individual channel. The CMS account that the user authenticates with
       * must be linked to the specified YouTube content owner.
       */
      public Update setOnBehalfOfContentOwner(java.lang.String onBehalfOfContentOwner) {
        this.onBehalfOfContentOwner = onBehalfOfContentOwner;
        return this;
      }

      @Override
      public Update set(String parameterName, Object value) {
        return (Update) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the Channels collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code YouTube youtube = new YouTube(...);}
   *   {@code YouTube.Channels.List request = youtube.channels().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Channels channels() {
    return new Channels();
  }

  /**
   * The "channels" collection of methods.
   */
  public class Channels {

    /**
     * Retrieves a list of resources, possibly filtered.
     *
     * Create a request for the method "channels.list".
     *
     * This request holds the parameters needed by the youtube server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param part The *part* parameter specifies a comma-separated list of one or more channel resource properties
     *        that the API response will include. If the parameter identifies a property that contains
     *        child properties, the child properties will be included in the response. For example, in a
     *        channel resource, the contentDetails property contains other properties, such as the
     *        uploads properties. As such, if you set *part=contentDetails*, the API response will also
     *        contain all of those nested properties.
     * @return the request
     */
    public List list(java.util.List<java.lang.String> part) throws java.io.IOException {
      List result = new List(part);
      initialize(result);
      return result;
    }

    public class List extends YouTubeRequest<com.google.api.services.youtube.model.ChannelListResponse> {

      private static final String REST_PATH = "youtube/v3/channels";

      /**
       * Retrieves a list of resources, possibly filtered.
       *
       * Create a request for the method "channels.list".
       *
       * This request holds the parameters needed by the the youtube server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param part The *part* parameter specifies a comma-separated list of one or more channel resource properties
     *        that the API response will include. If the parameter identifies a property that contains
     *        child properties, the child properties will be included in the response. For example, in a
     *        channel resource, the contentDetails property contains other properties, such as the
     *        uploads properties. As such, if you set *part=contentDetails*, the API response will also
     *        contain all of those nested properties.
       * @since 1.13
       */
      protected List(java.util.List<java.lang.String> part) {
        super(YouTube.this, "GET", REST_PATH, null, com.google.api.services.youtube.model.ChannelListResponse.class);
        this.part = com.google.api.client.util.Preconditions.checkNotNull(part, "Required parameter part must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List set$Xgafv(java.lang.String $Xgafv) {
        return (List) super.set$Xgafv($Xgafv);
      }

      @Override
      public List setAccessToken(java.lang.String accessToken) {
        return (List) super.setAccessToken(accessToken);
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setCallback(java.lang.String callback) {
        return (List) super.setCallback(callback);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUploadType(java.lang.String uploadType) {
        return (List) super.setUploadType(uploadType);
      }

      @Override
      public List setUploadProtocol(java.lang.String uploadProtocol) {
        return (List) super.setUploadProtocol(uploadProtocol);
      }

      /**
       * The *part* parameter specifies a comma-separated list of one or more channel resource
       * properties that the API response will include. If the parameter identifies a property that
       * contains child properties, the child properties will be included in the response. For
       * example, in a channel resource, the contentDetails property contains other properties, such
       * as the uploads properties. As such, if you set *part=contentDetails*, the API response will
       * also contain all of those nested properties.
       */
      @com.google.api.client.util.Key
      private java.util.List<java.lang.String> part;

      /** The *part* parameter specifies a comma-separated list of one or more channel resource properties
     that the API response will include. If the parameter identifies a property that contains child
     properties, the child properties will be included in the response. For example, in a channel
     resource, the contentDetails property contains other properties, such as the uploads properties. As
     such, if you set *part=contentDetails*, the API response will also contain all of those nested
     properties.
       */
      public java.util.List<java.lang.String> getPart() {
        return part;
      }

      /**
       * The *part* parameter specifies a comma-separated list of one or more channel resource
       * properties that the API response will include. If the parameter identifies a property that
       * contains child properties, the child properties will be included in the response. For
       * example, in a channel resource, the contentDetails property contains other properties, such
       * as the uploads properties. As such, if you set *part=contentDetails*, the API response will
       * also contain all of those nested properties.
       */
      public List setPart(java.util.List<java.lang.String> part) {
        this.part = part;
        return this;
      }

      /** Return the channels within the specified guide category ID. */
      @com.google.api.client.util.Key
      private java.lang.String categoryId;

      /** Return the channels within the specified guide category ID.
       */
      public java.lang.String getCategoryId() {
        return categoryId;
      }

      /** Return the channels within the specified guide category ID. */
      public List setCategoryId(java.lang.String categoryId) {
        this.categoryId = categoryId;
        return this;
      }

      /** Return the channel associated with a YouTube username. */
      @com.google.api.client.util.Key
      private java.lang.String forUsername;

      /** Return the channel associated with a YouTube username.
       */
      public java.lang.String getForUsername() {
        return forUsername;
      }

      /** Return the channel associated with a YouTube username. */
      public List setForUsername(java.lang.String forUsername) {
        this.forUsername = forUsername;
        return this;
      }

      /**
       * Stands for "host language". Specifies the localization language of the metadata to be
       * filled into snippet.localized. The field is filled with the default metadata if there is no
       * localization in the specified language. The parameter value must be a language code
       * included in the list returned by the i18nLanguages.list method (e.g. en_US, es_MX).
       */
      @com.google.api.client.util.Key
      private java.lang.String hl;

      /** Stands for "host language". Specifies the localization language of the metadata to be filled into
     snippet.localized. The field is filled with the default metadata if there is no localization in the
     specified language. The parameter value must be a language code included in the list returned by
     the i18nLanguages.list method (e.g. en_US, es_MX).
       */
      public java.lang.String getHl() {
        return hl;
      }

      /**
       * Stands for "host language". Specifies the localization language of the metadata to be
       * filled into snippet.localized. The field is filled with the default metadata if there is no
       * localization in the specified language. The parameter value must be a language code
       * included in the list returned by the i18nLanguages.list method (e.g. en_US, es_MX).
       */
      public List setHl(java.lang.String hl) {
        this.hl = hl;
        return this;
      }

      /** Return the channels with the specified IDs. */
      @com.google.api.client.util.Key
      private java.util.List<java.lang.String> id;

      /** Return the channels with the specified IDs.
       */
      public java.util.List<java.lang.String> getId() {
        return id;
      }

      /** Return the channels with the specified IDs. */
      public List setId(java.util.List<java.lang.String> id) {
        this.id = id;
        return this;
      }

      /** Return the channels managed by the authenticated user. */
      @com.google.api.client.util.Key
      private java.lang.Boolean managedByMe;

      /** Return the channels managed by the authenticated user.
       */
      public java.lang.Boolean getManagedByMe() {
        return managedByMe;
      }

      /** Return the channels managed by the authenticated user. */
      public List setManagedByMe(java.lang.Boolean managedByMe) {
        this.managedByMe = managedByMe;
        return this;
      }

      /**
       * The *maxResults* parameter specifies the maximum number of items that should be returned in
       * the result set.
       */
      @com.google.api.client.util.Key
      private java.lang.Long maxResults;

      /** The *maxResults* parameter specifies the maximum number of items that should be returned in the
     result set. [default: 5] [minimum: 0] [maximum: 50]
       */
      public java.lang.Long getMaxResults() {
        return maxResults;
      }

      /**
       * The *maxResults* parameter specifies the maximum number of items that should be returned in
       * the result set.
       */
      public List setMaxResults(java.lang.Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      /** Return the ids of channels owned by the authenticated user. */
      @com.google.api.client.util.Key
      private java.lang.Boolean mine;

      /** Return the ids of channels owned by the authenticated user.
       */
      public java.lang.Boolean getMine() {
        return mine;
      }

      /** Return the ids of channels owned by the authenticated user. */
      public List setMine(java.lang.Boolean mine) {
        this.mine = mine;
        return this;
      }

      /** Return the channels subscribed to the authenticated user */
      @com.google.api.client.util.Key
      private java.lang.Boolean mySubscribers;

      /** Return the channels subscribed to the authenticated user
       */
      public java.lang.Boolean getMySubscribers() {
        return mySubscribers;
      }

      /** Return the channels subscribed to the authenticated user */
      public List setMySubscribers(java.lang.Boolean mySubscribers) {
        this.mySubscribers = mySubscribers;
        return this;
      }

      /**
       * *Note:* This parameter is intended exclusively for YouTube content partners. The
       * *onBehalfOfContentOwner* parameter indicates that the request's authorization credentials
       * identify a YouTube CMS user who is acting on behalf of the content owner specified in the
       * parameter value. This parameter is intended for YouTube content partners that own and
       * manage many different YouTube channels. It allows content owners to authenticate once and
       * get access to all their video and channel data, without having to provide authentication
       * credentials for each individual channel. The CMS account that the user authenticates with
       * must be linked to the specified YouTube content owner.
       */
      @com.google.api.client.util.Key
      private java.lang.String onBehalfOfContentOwner;

      /*** Note:* This parameter is intended exclusively for YouTube content partners. The
    * *onBehalfOfContentOwner* parameter indicates that the request's authorization credentials identify
    * a YouTube CMS user who is acting on behalf of the content owner specified in the parameter value.
    * This parameter is intended for YouTube content partners that own and manage many different YouTube
    * channels. It allows content owners to authenticate once and get access to all their video and
    * channel data, without having to provide authentication credentials for each individual channel.
    * The CMS account that the user authenticates with must be linked to the specified YouTube content
    * owner.
    *

       */
      public java.lang.String getOnBehalfOfContentOwner() {
        return onBehalfOfContentOwner;
      }

      /**
       * *Note:* This parameter is intended exclusively for YouTube content partners. The
       * *onBehalfOfContentOwner* parameter indicates that the request's authorization credentials
       * identify a YouTube CMS user who is acting on behalf of the content owner specified in the
       * parameter value. This parameter is intended for YouTube content partners that own and
       * manage many different YouTube channels. It allows content owners to authenticate once and
       * get access to all their video and channel data, without having to provide authentication
       * credentials for each individual channel. The CMS account that the user authenticates with
       * must be linked to the specified YouTube content owner.
       */
      public List setOnBehalfOfContentOwner(java.lang.String onBehalfOfContentOwner) {
        this.onBehalfOfContentOwner = onBehalfOfContentOwner;
        return this;
      }

      /**
       * The *pageToken* parameter identifies a specific page in the result set that should be
       * returned. In an API response, the nextPageToken and prevPageToken properties identify other
       * pages that could be retrieved.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** The *pageToken* parameter identifies a specific page in the result set that should be returned. In
     an API response, the nextPageToken and prevPageToken properties identify other pages that could be
     retrieved.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * The *pageToken* parameter identifies a specific page in the result set that should be
       * returned. In an API response, the nextPageToken and prevPageToken properties identify other
       * pages that could be retrieved.
       */
      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }
    /**
     * Updates an existing resource.
     *
     * Create a request for the method "channels.update".
     *
     * This request holds the parameters needed by the youtube server.  After setting any optional
     * parameters, call the {@link Update#execute()} method to invoke the remote operation.
     *
     * @param part The *part* parameter serves two purposes in this operation. It identifies the properties that the
     *        write operation will set as well as the properties that the API response will include. The
     *        API currently only allows the parameter value to be set to either brandingSettings or
     *        invideoPromotion. (You cannot update both of those parts with a single request.) Note that
     *        this method overrides the existing values for all of the mutable properties that are
     *        contained in any parts that the parameter value specifies.
     * @param content the {@link com.google.api.services.youtube.model.Channel}
     * @return the request
     */
    public Update update(java.util.List<java.lang.String> part, com.google.api.services.youtube.model.Channel content) throws java.io.IOException {
      Update result = new Update(part, content);
      initialize(result);
      return result;
    }

    public class Update extends YouTubeRequest<com.google.api.services.youtube.model.Channel> {

      private static final String REST_PATH = "youtube/v3/channels";

      /**
       * Updates an existing resource.
       *
       * Create a request for the method "channels.update".
       *
       * This request holds the parameters needed by the the youtube server.  After setting any optional
       * parameters, call the {@link Update#execute()} method to invoke the remote operation. <p> {@link
       * Update#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param part The *part* parameter serves two purposes in this operation. It identifies the properties that the
     *        write operation will set as well as the properties that the API response will include. The
     *        API currently only allows the parameter value to be set to either brandingSettings or
     *        invideoPromotion. (You cannot update both of those parts with a single request.) Note that
     *        this method overrides the existing values for all of the mutable properties that are
     *        contained in any parts that the parameter value specifies.
       * @param content the {@link com.google.api.services.youtube.model.Channel}
       * @since 1.13
       */
      protected Update(java.util.List<java.lang.String> part, com.google.api.services.youtube.model.Channel content) {
        super(YouTube.this, "PUT", REST_PATH, content, com.google.api.services.youtube.model.Channel.class);
        this.part = com.google.api.client.util.Preconditions.checkNotNull(part, "Required parameter part must be specified.");
      }

      @Override
      public Update set$Xgafv(java.lang.String $Xgafv) {
        return (Update) super.set$Xgafv($Xgafv);
      }

      @Override
      public Update setAccessToken(java.lang.String accessToken) {
        return (Update) super.setAccessToken(accessToken);
      }

      @Override
      public Update setAlt(java.lang.String alt) {
        return (Update) super.setAlt(alt);
      }

      @Override
      public Update setCallback(java.lang.String callback) {
        return (Update) super.setCallback(callback);
      }

      @Override
      public Update setFields(java.lang.String fields) {
        return (Update) super.setFields(fields);
      }

      @Override
      public Update setKey(java.lang.String key) {
        return (Update) super.setKey(key);
      }

      @Override
      public Update setOauthToken(java.lang.String oauthToken) {
        return (Update) super.setOauthToken(oauthToken);
      }

      @Override
      public Update setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Update) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Update setQuotaUser(java.lang.String quotaUser) {
        return (Update) super.setQuotaUser(quotaUser);
      }

      @Override
      public Update setUploadType(java.lang.String uploadType) {
        return (Update) super.setUploadType(uploadType);
      }

      @Override
      public Update setUploadProtocol(java.lang.String uploadProtocol) {
        return (Update) super.setUploadProtocol(uploadProtocol);
      }

      /**
       * The *part* parameter serves two purposes in this operation. It identifies the properties
       * that the write operation will set as well as the properties that the API response will
       * include. The API currently only allows the parameter value to be set to either
       * brandingSettings or invideoPromotion. (You cannot update both of those parts with a single
       * request.) Note that this method overrides the existing values for all of the mutable
       * properties that are contained in any parts that the parameter value specifies.
       */
      @com.google.api.client.util.Key
      private java.util.List<java.lang.String> part;

      /** The *part* parameter serves two purposes in this operation. It identifies the properties that the
     write operation will set as well as the properties that the API response will include. The API
     currently only allows the parameter value to be set to either brandingSettings or invideoPromotion.
     (You cannot update both of those parts with a single request.) Note that this method overrides the
     existing values for all of the mutable properties that are contained in any parts that the
     parameter value specifies.
       */
      public java.util.List<java.lang.String> getPart() {
        return part;
      }

      /**
       * The *part* parameter serves two purposes in this operation. It identifies the properties
       * that the write operation will set as well as the properties that the API response will
       * include. The API currently only allows the parameter value to be set to either
       * brandingSettings or invideoPromotion. (You cannot update both of those parts with a single
       * request.) Note that this method overrides the existing values for all of the mutable
       * properties that are contained in any parts that the parameter value specifies.
       */
      public Update setPart(java.util.List<java.lang.String> part) {
        this.part = part;
        return this;
      }

      /**
       * The *onBehalfOfContentOwner* parameter indicates that the authenticated user is acting on
       * behalf of the content owner specified in the parameter value. This parameter is intended
       * for YouTube content partners that own and manage many different YouTube channels. It allows
       * content owners to authenticate once and get access to all their video and channel data,
       * without having to provide authentication credentials for each individual channel. The
       * actual CMS account that the user authenticates with needs to be linked to the specified
       * YouTube content owner.
       */
      @com.google.api.client.util.Key
      private java.lang.String onBehalfOfContentOwner;

      /** The *onBehalfOfContentOwner* parameter indicates that the authenticated user is acting on behalf of
     the content owner specified in the parameter value. This parameter is intended for YouTube content
     partners that own and manage many different YouTube channels. It allows content owners to
     authenticate once and get access to all their video and channel data, without having to provide
     authentication credentials for each individual channel. The actual CMS account that the user
     authenticates with needs to be linked to the specified YouTube content owner.
       */
      public java.lang.String getOnBehalfOfContentOwner() {
        return onBehalfOfContentOwner;
      }

      /**
       * The *onBehalfOfContentOwner* parameter indicates that the authenticated user is acting on
       * behalf of the content owner specified in the parameter value. This parameter is intended
       * for YouTube content partners that own and manage many different YouTube channels. It allows
       * content owners to authenticate once and get access to all their video and channel data,
       * without having to provide authentication credentials for each individual channel. The
       * actual CMS account that the user authenticates with needs to be linked to the specified
       * YouTube content owner.
       */
      public Update setOnBehalfOfContentOwner(java.lang.String onBehalfOfContentOwner) {
        this.onBehalfOfContentOwner = onBehalfOfContentOwner;
        return this;
      }

      @Override
      public Update set(String parameterName, Object value) {
        return (Update) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the CommentThreads collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code YouTube youtube = new YouTube(...);}
   *   {@code YouTube.CommentThreads.List request = youtube.commentThreads().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public CommentThreads commentThreads() {
    return new CommentThreads();
  }

  /**
   * The "commentThreads" collection of methods.
   */
  public class CommentThreads {

    /**
     * Inserts a new resource into this collection.
     *
     * Create a request for the method "commentThreads.insert".
     *
     * This request holds the parameters needed by the youtube server.  After setting any optional
     * parameters, call the {@link Insert#execute()} method to invoke the remote operation.
     *
     * @param part The *part* parameter identifies the properties that the API response will include. Set the parameter
     *        value to snippet. The snippet part has a quota cost of 2 units.
     * @param content the {@link com.google.api.services.youtube.model.CommentThread}
     * @return the request
     */
    public Insert insert(java.util.List<java.lang.String> part, com.google.api.services.youtube.model.CommentThread content) throws java.io.IOException {
      Insert result = new Insert(part, content);
      initialize(result);
      return result;
    }

    public class Insert extends YouTubeRequest<com.google.api.services.youtube.model.CommentThread> {

      private static final String REST_PATH = "youtube/v3/commentThreads";

      /**
       * Inserts a new resource into this collection.
       *
       * Create a request for the method "commentThreads.insert".
       *
       * This request holds the parameters needed by the the youtube server.  After setting any optional
       * parameters, call the {@link Insert#execute()} method to invoke the remote operation. <p> {@link
       * Insert#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param part The *part* parameter identifies the properties that the API response will include. Set the parameter
     *        value to snippet. The snippet part has a quota cost of 2 units.
       * @param content the {@link com.google.api.services.youtube.model.CommentThread}
       * @since 1.13
       */
      protected Insert(java.util.List<java.lang.String> part, com.google.api.services.youtube.model.CommentThread content) {
        super(YouTube.this, "POST", REST_PATH, content, com.google.api.services.youtube.model.CommentThread.class);
        this.part = com.google.api.client.util.Preconditions.checkNotNull(part, "Required parameter part must be specified.");
      }

      @Override
      public Insert set$Xgafv(java.lang.String $Xgafv) {
        return (Insert) super.set$Xgafv($Xgafv);
      }

      @Override
      public Insert setAccessToken(java.lang.String accessToken) {
        return (Insert) super.setAccessToken(accessToken);
      }

      @Override
      public Insert setAlt(java.lang.String alt) {
        return (Insert) super.setAlt(alt);
      }

      @Override
      public Insert setCallback(java.lang.String callback) {
        return (Insert) super.setCallback(callback);
      }

      @Override
      public Insert setFields(java.lang.String fields) {
        return (Insert) super.setFields(fields);
      }

      @Override
      public Insert setKey(java.lang.String key) {
        return (Insert) super.setKey(key);
      }

      @Override
      public Insert setOauthToken(java.lang.String oauthToken) {
        return (Insert) super.setOauthToken(oauthToken);
      }

      @Override
      public Insert setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Insert) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Insert setQuotaUser(java.lang.String quotaUser) {
        return (Insert) super.setQuotaUser(quotaUser);
      }

      @Override
      public Insert setUploadType(java.lang.String uploadType) {
        return (Insert) super.setUploadType(uploadType);
      }

      @Override
      public Insert setUploadProtocol(java.lang.String uploadProtocol) {
        return (Insert) super.setUploadProtocol(uploadProtocol);
      }

      /**
       * The *part* parameter identifies the properties that the API response will include. Set the
       * parameter value to snippet. The snippet part has a quota cost of 2 units.
       */
      @com.google.api.client.util.Key
      private java.util.List<java.lang.String> part;

      /** The *part* parameter identifies the properties that the API response will include. Set the
     parameter value to snippet. The snippet part has a quota cost of 2 units.
       */
      public java.util.List<java.lang.String> getPart() {
        return part;
      }

      /**
       * The *part* parameter identifies the properties that the API response will include. Set the
       * parameter value to snippet. The snippet part has a quota cost of 2 units.
       */
      public Insert setPart(java.util.List<java.lang.String> part) {
        this.part = part;
        return this;
      }

      @Override
      public Insert set(String parameterName, Object value) {
        return (Insert) super.set(parameterName, value);
      }
    }
    /**
     * Retrieves a list of resources, possibly filtered.
     *
     * Create a request for the method "commentThreads.list".
     *
     * This request holds the parameters needed by the youtube server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param part The *part* parameter specifies a comma-separated list of one or more commentThread resource
     *        properties that the API response will include.
     * @return the request
     */
    public List list(java.util.List<java.lang.String> part) throws java.io.IOException {
      List result = new List(part);
      initialize(result);
      return result;
    }

    public class List extends YouTubeRequest<com.google.api.services.youtube.model.CommentThreadListResponse> {

      private static final String REST_PATH = "youtube/v3/commentThreads";

      /**
       * Retrieves a list of resources, possibly filtered.
       *
       * Create a request for the method "commentThreads.list".
       *
       * This request holds the parameters needed by the the youtube server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param part The *part* parameter specifies a comma-separated list of one or more commentThread resource
     *        properties that the API response will include.
       * @since 1.13
       */
      protected List(java.util.List<java.lang.String> part) {
        super(YouTube.this, "GET", REST_PATH, null, com.google.api.services.youtube.model.CommentThreadListResponse.class);
        this.part = com.google.api.client.util.Preconditions.checkNotNull(part, "Required parameter part must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List set$Xgafv(java.lang.String $Xgafv) {
        return (List) super.set$Xgafv($Xgafv);
      }

      @Override
      public List setAccessToken(java.lang.String accessToken) {
        return (List) super.setAccessToken(accessToken);
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setCallback(java.lang.String callback) {
        return (List) super.setCallback(callback);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUploadType(java.lang.String uploadType) {
        return (List) super.setUploadType(uploadType);
      }

      @Override
      public List setUploadProtocol(java.lang.String uploadProtocol) {
        return (List) super.setUploadProtocol(uploadProtocol);
      }

      /**
       * The *part* parameter specifies a comma-separated list of one or more commentThread resource
       * properties that the API response will include.
       */
      @com.google.api.client.util.Key
      private java.util.List<java.lang.String> part;

      /** The *part* parameter specifies a comma-separated list of one or more commentThread resource
     properties that the API response will include.
       */
      public java.util.List<java.lang.String> getPart() {
        return part;
      }

      /**
       * The *part* parameter specifies a comma-separated list of one or more commentThread resource
       * properties that the API response will include.
       */
      public List setPart(java.util.List<java.lang.String> part) {
        this.part = part;
        return this;
      }

      /**
       * Returns the comment threads of all videos of the channel and the channel comments as well.
       */
      @com.google.api.client.util.Key
      private java.lang.String allThreadsRelatedToChannelId;

      /** Returns the comment threads of all videos of the channel and the channel comments as well.
       */
      public java.lang.String getAllThreadsRelatedToChannelId() {
        return allThreadsRelatedToChannelId;
      }

      /**
       * Returns the comment threads of all videos of the channel and the channel comments as well.
       */
      public List setAllThreadsRelatedToChannelId(java.lang.String allThreadsRelatedToChannelId) {
        this.allThreadsRelatedToChannelId = allThreadsRelatedToChannelId;
        return this;
      }

      /**
       * Returns the comment threads for all the channel comments (ie does not include comments left
       * on videos).
       */
      @com.google.api.client.util.Key
      private java.lang.String channelId;

      /** Returns the comment threads for all the channel comments (ie does not include comments left on
     videos).
       */
      public java.lang.String getChannelId() {
        return channelId;
      }

      /**
       * Returns the comment threads for all the channel comments (ie does not include comments left
       * on videos).
       */
      public List setChannelId(java.lang.String channelId) {
        this.channelId = channelId;
        return this;
      }

      /** Returns the comment threads with the given IDs for Stubby or Apiary. */
      @com.google.api.client.util.Key
      private java.util.List<java.lang.String> id;

      /** Returns the comment threads with the given IDs for Stubby or Apiary.
       */
      public java.util.List<java.lang.String> getId() {
        return id;
      }

      /** Returns the comment threads with the given IDs for Stubby or Apiary. */
      public List setId(java.util.List<java.lang.String> id) {
        this.id = id;
        return this;
      }

      /**
       * The *maxResults* parameter specifies the maximum number of items that should be returned in
       * the result set.
       */
      @com.google.api.client.util.Key
      private java.lang.Long maxResults;

      /** The *maxResults* parameter specifies the maximum number of items that should be returned in the
     result set. [default: 20] [minimum: 1] [maximum: 100]
       */
      public java.lang.Long getMaxResults() {
        return maxResults;
      }

      /**
       * The *maxResults* parameter specifies the maximum number of items that should be returned in
       * the result set.
       */
      public List setMaxResults(java.lang.Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      /**
       * Limits the returned comment threads to those with the specified moderation status. Not
       * compatible with the 'id' filter. Valid values: published, heldForReview, likelySpam.
       */
      @com.google.api.client.util.Key
      private java.lang.String moderationStatus;

      /** Limits the returned comment threads to those with the specified moderation status. Not compatible
     with the 'id' filter. Valid values: published, heldForReview, likelySpam. [default: published]
       */
      public java.lang.String getModerationStatus() {
        return moderationStatus;
      }

      /**
       * Limits the returned comment threads to those with the specified moderation status. Not
       * compatible with the 'id' filter. Valid values: published, heldForReview, likelySpam.
       */
      public List setModerationStatus(java.lang.String moderationStatus) {
        this.moderationStatus = moderationStatus;
        return this;
      }

      @com.google.api.client.util.Key
      private java.lang.String order;

      /**
     [ default: time]
     [

       */
      public java.lang.String getOrder() {
        return order;
      }

      public List setOrder(java.lang.String order) {
        this.order = order;
        return this;
      }

      /**
       * The *pageToken* parameter identifies a specific page in the result set that should be
       * returned. In an API response, the nextPageToken and prevPageToken properties identify other
       * pages that could be retrieved.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** The *pageToken* parameter identifies a specific page in the result set that should be returned. In
     an API response, the nextPageToken and prevPageToken properties identify other pages that could be
     retrieved.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * The *pageToken* parameter identifies a specific page in the result set that should be
       * returned. In an API response, the nextPageToken and prevPageToken properties identify other
       * pages that could be retrieved.
       */
      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      /**
       * Limits the returned comment threads to those matching the specified key words. Not
       * compatible with the 'id' filter.
       */
      @com.google.api.client.util.Key
      private java.lang.String searchTerms;

      /** Limits the returned comment threads to those matching the specified key words. Not compatible with
     the 'id' filter.
       */
      public java.lang.String getSearchTerms() {
        return searchTerms;
      }

      /**
       * Limits the returned comment threads to those matching the specified key words. Not
       * compatible with the 'id' filter.
       */
      public List setSearchTerms(java.lang.String searchTerms) {
        this.searchTerms = searchTerms;
        return this;
      }

      /** The requested text format for the returned comments. */
      @com.google.api.client.util.Key
      private java.lang.String textFormat;

      /** The requested text format for the returned comments. [default: html]
       */
      public java.lang.String getTextFormat() {
        return textFormat;
      }

      /** The requested text format for the returned comments. */
      public List setTextFormat(java.lang.String textFormat) {
        this.textFormat = textFormat;
        return this;
      }

      /** Returns the comment threads of the specified video. */
      @com.google.api.client.util.Key
      private java.lang.String videoId;

      /** Returns the comment threads of the specified video.
       */
      public java.lang.String getVideoId() {
        return videoId;
      }

      /** Returns the comment threads of the specified video. */
      public List setVideoId(java.lang.String videoId) {
        this.videoId = videoId;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the Comments collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code YouTube youtube = new YouTube(...);}
   *   {@code YouTube.Comments.List request = youtube.comments().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Comments comments() {
    return new Comments();
  }

  /**
   * The "comments" collection of methods.
   */
  public class Comments {

    /**
     * Deletes a resource.
     *
     * Create a request for the method "comments.delete".
     *
     * This request holds the parameters needed by the youtube server.  After setting any optional
     * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
     *
     * @param id
     * @return the request
     */
    public Delete delete(java.lang.String id) throws java.io.IOException {
      Delete result = new Delete(id);
      initialize(result);
      return result;
    }

    public class Delete extends YouTubeRequest<Void> {

      private static final String REST_PATH = "youtube/v3/comments";

      /**
       * Deletes a resource.
       *
       * Create a request for the method "comments.delete".
       *
       * This request holds the parameters needed by the the youtube server.  After setting any optional
       * parameters, call the {@link Delete#execute()} method to invoke the remote operation. <p> {@link
       * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param id
       * @since 1.13
       */
      protected Delete(java.lang.String id) {
        super(YouTube.this, "DELETE", REST_PATH, null, Void.class);
        this.id = com.google.api.client.util.Preconditions.checkNotNull(id, "Required parameter id must be specified.");
      }

      @Override
      public Delete set$Xgafv(java.lang.String $Xgafv) {
        return (Delete) super.set$Xgafv($Xgafv);
      }

      @Override
      public Delete setAccessToken(java.lang.String accessToken) {
        return (Delete) super.setAccessToken(accessToken);
      }

      @Override
      public Delete setAlt(java.lang.String alt) {
        return (Delete) super.setAlt(alt);
      }

      @Override
      public Delete setCallback(java.lang.String callback) {
        return (Delete) super.setCallback(callback);
      }

      @Override
      public Delete setFields(java.lang.String fields) {
        return (Delete) super.setFields(fields);
      }

      @Override
      public Delete setKey(java.lang.String key) {
        return (Delete) super.setKey(key);
      }

      @Override
      public Delete setOauthToken(java.lang.String oauthToken) {
        return (Delete) super.setOauthToken(oauthToken);
      }

      @Override
      public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Delete) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Delete setQuotaUser(java.lang.String quotaUser) {
        return (Delete) super.setQuotaUser(quotaUser);
      }

      @Override
      public Delete setUploadType(java.lang.String uploadType) {
        return (Delete) super.setUploadType(uploadType);
      }

      @Override
      public Delete setUploadProtocol(java.lang.String uploadProtocol) {
        return (Delete) super.setUploadProtocol(uploadProtocol);
      }

      @com.google.api.client.util.Key
      private java.lang.String id;

      /**

       */
      public java.lang.String getId() {
        return id;
      }

      public Delete setId(java.lang.String id) {
        this.id = id;
        return this;
      }

      @Override
      public Delete set(String parameterName, Object value) {
        return (Delete) super.set(parameterName, value);
      }
    }
    /**
     * Inserts a new resource into this collection.
     *
     * Create a request for the method "comments.insert".
     *
     * This request holds the parameters needed by the youtube server.  After setting any optional
     * parameters, call the {@link Insert#execute()} method to invoke the remote operation.
     *
     * @param part The *part* parameter identifies the properties that the API response will include. Set the parameter
     *        value to snippet. The snippet part has a quota cost of 2 units.
     * @param content the {@link com.google.api.services.youtube.model.Comment}
     * @return the request
     */
    public Insert insert(java.util.List<java.lang.String> part, com.google.api.services.youtube.model.Comment content) throws java.io.IOException {
      Insert result = new Insert(part, content);
      initialize(result);
      return result;
    }

    public class Insert extends YouTubeRequest<com.google.api.services.youtube.model.Comment> {

      private static final String REST_PATH = "youtube/v3/comments";

      /**
       * Inserts a new resource into this collection.
       *
       * Create a request for the method "comments.insert".
       *
       * This request holds the parameters needed by the the youtube server.  After setting any optional
       * parameters, call the {@link Insert#execute()} method to invoke the remote operation. <p> {@link
       * Insert#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param part The *part* parameter identifies the properties that the API response will include. Set the parameter
     *        value to snippet. The snippet part has a quota cost of 2 units.
       * @param content the {@link com.google.api.services.youtube.model.Comment}
       * @since 1.13
       */
      protected Insert(java.util.List<java.lang.String> part, com.google.api.services.youtube.model.Comment content) {
        super(YouTube.this, "POST", REST_PATH, content, com.google.api.services.youtube.model.Comment.class);
        this.part = com.google.api.client.util.Preconditions.checkNotNull(part, "Required parameter part must be specified.");
      }

      @Override
      public Insert set$Xgafv(java.lang.String $Xgafv) {
        return (Insert) super.set$Xgafv($Xgafv);
      }

      @Override
      public Insert setAccessToken(java.lang.String accessToken) {
        return (Insert) super.setAccessToken(accessToken);
      }

      @Override
      public Insert setAlt(java.lang.String alt) {
        return (Insert) super.setAlt(alt);
      }

      @Override
      public Insert setCallback(java.lang.String callback) {
        return (Insert) super.setCallback(callback);
      }

      @Override
      public Insert setFields(java.lang.String fields) {
        return (Insert) super.setFields(fields);
      }

      @Override
      public Insert setKey(java.lang.String key) {
        return (Insert) super.setKey(key);
      }

      @Override
      public Insert setOauthToken(java.lang.String oauthToken) {
        return (Insert) super.setOauthToken(oauthToken);
      }

      @Override
      public Insert setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Insert) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Insert setQuotaUser(java.lang.String quotaUser) {
        return (Insert) super.setQuotaUser(quotaUser);
      }

      @Override
      public Insert setUploadType(java.lang.String uploadType) {
        return (Insert) super.setUploadType(uploadType);
      }

      @Override
      public Insert setUploadProtocol(java.lang.String uploadProtocol) {
        return (Insert) super.setUploadProtocol(uploadProtocol);
      }

      /**
       * The *part* parameter identifies the properties that the API response will include. Set the
       * parameter value to snippet. The snippet part has a quota cost of 2 units.
       */
      @com.google.api.client.util.Key
      private java.util.List<java.lang.String> part;

      /** The *part* parameter identifies the properties that the API response will include. Set the
     parameter value to snippet. The snippet part has a quota cost of 2 units.
       */
      public java.util.List<java.lang.String> getPart() {
        return part;
      }

      /**
       * The *part* parameter identifies the properties that the API response will include. Set the
       * parameter value to snippet. The snippet part has a quota cost of 2 units.
       */
      public Insert setPart(java.util.List<java.lang.String> part) {
        this.part = part;
        return this;
      }

      @Override
      public Insert set(String parameterName, Object value) {
        return (Insert) super.set(parameterName, value);
      }
    }
    /**
     * Retrieves a list of resources, possibly filtered.
     *
     * Create a request for the method "comments.list".
     *
     * This request holds the parameters needed by the youtube server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param part The *part* parameter specifies a comma-separated list of one or more comment resource properties
     *        that the API response will include.
     * @return the request
     */
    public List list(java.util.List<java.lang.String> part) throws java.io.IOException {
      List result = new List(part);
      initialize(result);
      return result;
    }

    public class List extends YouTubeRequest<com.google.api.services.youtube.model.CommentListResponse> {

      private static final String REST_PATH = "youtube/v3/comments";

      /**
       * Retrieves a list of resources, possibly filtered.
       *
       * Create a request for the method "comments.list".
       *
       * This request holds the parameters needed by the the youtube server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param part The *part* parameter specifies a comma-separated list of one or more comment resource properties
     *        that the API response will include.
       * @since 1.13
       */
      protected List(java.util.List<java.lang.String> part) {
        super(YouTube.this, "GET", REST_PATH, null, com.google.api.services.youtube.model.CommentListResponse.class);
        this.part = com.google.api.client.util.Preconditions.checkNotNull(part, "Required parameter part must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List set$Xgafv(java.lang.String $Xgafv) {
        return (List) super.set$Xgafv($Xgafv);
      }

      @Override
      public List setAccessToken(java.lang.String accessToken) {
        return (List) super.setAccessToken(accessToken);
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setCallback(java.lang.String callback) {
        return (List) super.setCallback(callback);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUploadType(java.lang.String uploadType) {
        return (List) super.setUploadType(uploadType);
      }

      @Override
      public List setUploadProtocol(java.lang.String uploadProtocol) {
        return (List) super.setUploadProtocol(uploadProtocol);
      }

      /**
       * The *part* parameter specifies a comma-separated list of one or more comment resource
       * properties that the API response will include.
       */
      @com.google.api.client.util.Key
      private java.util.List<java.lang.String> part;

      /** The *part* parameter specifies a comma-separated list of one or more comment resource properties
     that the API response will include.
       */
      public java.util.List<java.lang.String> getPart() {
        return part;
      }

      /**
       * The *part* parameter specifies a comma-separated list of one or more comment resource
       * properties that the API response will include.
       */
      public List setPart(java.util.List<java.lang.String> part) {
        this.part = part;
        return this;
      }

      /** Returns the comments with the given IDs for One Platform. */
      @com.google.api.client.util.Key
      private java.util.List<java.lang.String> id;

      /** Returns the comments with the given IDs for One Platform.
       */
      public java.util.List<java.lang.String> getId() {
        return id;
      }

      /** Returns the comments with the given IDs for One Platform. */
      public List setId(java.util.List<java.lang.String> id) {
        this.id = id;
        return this;
      }

      /**
       * The *maxResults* parameter specifies the maximum number of items that should be returned in
       * the result set.
       */
      @com.google.api.client.util.Key
      private java.lang.Long maxResults;

      /** The *maxResults* parameter specifies the maximum number of items that should be returned in the
     result set. [default: 20] [minimum: 1] [maximum: 100]
       */
      public java.lang.Long getMaxResults() {
        return maxResults;
      }

      /**
       * The *maxResults* parameter specifies the maximum number of items that should be returned in
       * the result set.
       */
      public List setMaxResults(java.lang.Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      /**
       * The *pageToken* parameter identifies a specific page in the result set that should be
       * returned. In an API response, the nextPageToken and prevPageToken properties identify other
       * pages that could be retrieved.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** The *pageToken* parameter identifies a specific page in the result set that should be returned. In
     an API response, the nextPageToken and prevPageToken properties identify other pages that could be
     retrieved.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * The *pageToken* parameter identifies a specific page in the result set that should be
       * returned. In an API response, the nextPageToken and prevPageToken properties identify other
       * pages that could be retrieved.
       */
      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      /**
       * Returns replies to the specified comment. Note, currently YouTube features only one level
       * of replies (ie replies to top level comments). However replies to replies may be supported
       * in the future.
       */
      @com.google.api.client.util.Key
      private java.lang.String parentId;

      /** Returns replies to the specified comment. Note, currently YouTube features only one level of
     replies (ie replies to top level comments). However replies to replies may be supported in the
     future.
       */
      public java.lang.String getParentId() {
        return parentId;
      }

      /**
       * Returns replies to the specified comment. Note, currently YouTube features only one level
       * of replies (ie replies to top level comments). However replies to replies may be supported
       * in the future.
       */
      public List setParentId(java.lang.String parentId) {
        this.parentId = parentId;
        return this;
      }

      /** The requested text format for the returned comments. */
      @com.google.api.client.util.Key
      private java.lang.String textFormat;

      /** The requested text format for the returned comments. [default: html]
       */
      public java.lang.String getTextFormat() {
        return textFormat;
      }

      /** The requested text format for the returned comments. */
      public List setTextFormat(java.lang.String textFormat) {
        this.textFormat = textFormat;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }
    /**
     * Expresses the caller's opinion that one or more comments should be flagged as spam.
     *
     * Create a request for the method "comments.markAsSpam".
     *
     * This request holds the parameters needed by the youtube server.  After setting any optional
     * parameters, call the {@link MarkAsSpam#execute()} method to invoke the remote operation.
     *
     * @param id Flags the comments with the given IDs as spam in the caller's opinion.
     * @return the request
     */
    public MarkAsSpam markAsSpam(java.util.List<java.lang.String> id) throws java.io.IOException {
      MarkAsSpam result = new MarkAsSpam(id);
      initialize(result);
      return result;
    }

    public class MarkAsSpam extends YouTubeRequest<Void> {

      private static final String REST_PATH = "youtube/v3/comments/markAsSpam";

      /**
       * Expresses the caller's opinion that one or more comments should be flagged as spam.
       *
       * Create a request for the method "comments.markAsSpam".
       *
       * This request holds the parameters needed by the the youtube server.  After setting any optional
       * parameters, call the {@link MarkAsSpam#execute()} method to invoke the remote operation. <p>
       * {@link
       * MarkAsSpam#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param id Flags the comments with the given IDs as spam in the caller's opinion.
       * @since 1.13
       */
      protected MarkAsSpam(java.util.List<java.lang.String> id) {
        super(YouTube.this, "POST", REST_PATH, null, Void.class);
        this.id = com.google.api.client.util.Preconditions.checkNotNull(id, "Required parameter id must be specified.");
      }

      @Override
      public MarkAsSpam set$Xgafv(java.lang.String $Xgafv) {
        return (MarkAsSpam) super.set$Xgafv($Xgafv);
      }

      @Override
      public MarkAsSpam setAccessToken(java.lang.String accessToken) {
        return (MarkAsSpam) super.setAccessToken(accessToken);
      }

      @Override
      public MarkAsSpam setAlt(java.lang.String alt) {
        return (MarkAsSpam) super.setAlt(alt);
      }

      @Override
      public MarkAsSpam setCallback(java.lang.String callback) {
        return (MarkAsSpam) super.setCallback(callback);
      }

      @Override
      public MarkAsSpam setFields(java.lang.String fields) {
        return (MarkAsSpam) super.setFields(fields);
      }

      @Override
      public MarkAsSpam setKey(java.lang.String key) {
        return (MarkAsSpam) super.setKey(key);
      }

      @Override
      public MarkAsSpam setOauthToken(java.lang.String oauthToken) {
        return (MarkAsSpam) super.setOauthToken(oauthToken);
      }

      @Override
      public MarkAsSpam setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (MarkAsSpam) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public MarkAsSpam setQuotaUser(java.lang.String quotaUser) {
        return (MarkAsSpam) super.setQuotaUser(quotaUser);
      }

      @Override
      public MarkAsSpam setUploadType(java.lang.String uploadType) {
        return (MarkAsSpam) super.setUploadType(uploadType);
      }

      @Override
      public MarkAsSpam setUploadProtocol(java.lang.String uploadProtocol) {
        return (MarkAsSpam) super.setUploadProtocol(uploadProtocol);
      }

      /** Flags the comments with the given IDs as spam in the caller's opinion. */
      @com.google.api.client.util.Key
      private java.util.List<java.lang.String> id;

      /** Flags the comments with the given IDs as spam in the caller's opinion.
       */
      public java.util.List<java.lang.String> getId() {
        return id;
      }

      /** Flags the comments with the given IDs as spam in the caller's opinion. */
      public MarkAsSpam setId(java.util.List<java.lang.String> id) {
        this.id = id;
        return this;
      }

      @Override
      public MarkAsSpam set(String parameterName, Object value) {
        return (MarkAsSpam) super.set(parameterName, value);
      }
    }
    /**
     * Sets the moderation status of one or more comments.
     *
     * Create a request for the method "comments.setModerationStatus".
     *
     * This request holds the parameters needed by the youtube server.  After setting any optional
     * parameters, call the {@link SetModerationStatus#execute()} method to invoke the remote operation.
     *
     * @param id Modifies the moderation status of the comments with the given IDs
     * @param moderationStatus Specifies the requested moderation status. Note, comments can be in statuses, which are not
     *        available through this call. For example, this call does not allow to mark a comment as
     *        'likely spam'. Valid values: MODERATION_STATUS_PUBLISHED,
     *        MODERATION_STATUS_HELD_FOR_REVIEW, MODERATION_STATUS_REJECTED.
     * @return the request
     */
    public SetModerationStatus setModerationStatus(java.util.List<java.lang.String> id, java.lang.String moderationStatus) throws java.io.IOException {
      SetModerationStatus result = new SetModerationStatus(id, moderationStatus);
      initialize(result);
      return result;
    }

    public class SetModerationStatus extends YouTubeRequest<Void> {

      private static final String REST_PATH = "youtube/v3/comments/setModerationStatus";

      /**
       * Sets the moderation status of one or more comments.
       *
       * Create a request for the method "comments.setModerationStatus".
       *
       * This request holds the parameters needed by the the youtube server.  After setting any optional
       * parameters, call the {@link SetModerationStatus#execute()} method to invoke the remote
       * operation. <p> {@link SetModerationStatus#initialize(com.google.api.client.googleapis.services.
       * AbstractGoogleClientRequest)} must be called to initialize this instance immediately after
       * invoking the constructor. </p>
       *
       * @param id Modifies the moderation status of the comments with the given IDs
       * @param moderationStatus Specifies the requested moderation status. Note, comments can be in statuses, which are not
     *        available through this call. For example, this call does not allow to mark a comment as
     *        'likely spam'. Valid values: MODERATION_STATUS_PUBLISHED,
     *        MODERATION_STATUS_HELD_FOR_REVIEW, MODERATION_STATUS_REJECTED.
       * @since 1.13
       */
      protected SetModerationStatus(java.util.List<java.lang.String> id, java.lang.String moderationStatus) {
        super(YouTube.this, "POST", REST_PATH, null, Void.class);
        this.id = com.google.api.client.util.Preconditions.checkNotNull(id, "Required parameter id must be specified.");
        this.moderationStatus = com.google.api.client.util.Preconditions.checkNotNull(moderationStatus, "Required parameter moderationStatus must be specified.");
      }

      @Override
      public SetModerationStatus set$Xgafv(java.lang.String $Xgafv) {
        return (SetModerationStatus) super.set$Xgafv($Xgafv);
      }

      @Override
      public SetModerationStatus setAccessToken(java.lang.String accessToken) {
        return (SetModerationStatus) super.setAccessToken(accessToken);
      }

      @Override
      public SetModerationStatus setAlt(java.lang.String alt) {
        return (SetModerationStatus) super.setAlt(alt);
      }

      @Override
      public SetModerationStatus setCallback(java.lang.String callback) {
        return (SetModerationStatus) super.setCallback(callback);
      }

      @Override
      public SetModerationStatus setFields(java.lang.String fields) {
        return (SetModerationStatus) super.setFields(fields);
      }

      @Override
      public SetModerationStatus setKey(java.lang.String key) {
        return (SetModerationStatus) super.setKey(key);
      }

      @Override
      public SetModerationStatus setOauthToken(java.lang.String oauthToken) {
        return (SetModerationStatus) super.setOauthToken(oauthToken);
      }

      @Override
      public SetModerationStatus setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (SetModerationStatus) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public SetModerationStatus setQuotaUser(java.lang.String quotaUser) {
        return (SetModerationStatus) super.setQuotaUser(quotaUser);
      }

      @Override
      public SetModerationStatus setUploadType(java.lang.String uploadType) {
        return (SetModerationStatus) super.setUploadType(uploadType);
      }

      @Override
      public SetModerationStatus setUploadProtocol(java.lang.String uploadProtocol) {
        return (SetModerationStatus) super.setUploadProtocol(uploadProtocol);
      }

      /** Modifies the moderation status of the comments with the given IDs */
      @com.google.api.client.util.Key
      private java.util.List<java.lang.String> id;

      /** Modifies the moderation status of the comments with the given IDs
       */
      public java.util.List<java.lang.String> getId() {
        return id;
      }

      /** Modifies the moderation status of the comments with the given IDs */
      public SetModerationStatus setId(java.util.List<java.lang.String> id) {
        this.id = id;
        return this;
      }

      /**
       * Specifies the requested moderation status. Note, comments can be in statuses, which are not
       * available through this call. For example, this call does not allow to mark a comment as
       * 'likely spam'. Valid values: MODERATION_STATUS_PUBLISHED,
       * MODERATION_STATUS_HELD_FOR_REVIEW, MODERATION_STATUS_REJECTED.
       */
      @com.google.api.client.util.Key
      private java.lang.String moderationStatus;

      /** Specifies the requested moderation status. Note, comments can be in statuses, which are not
     available through this call. For example, this call does not allow to mark a comment as 'likely
     spam'. Valid values: MODERATION_STATUS_PUBLISHED, MODERATION_STATUS_HELD_FOR_REVIEW,
     MODERATION_STATUS_REJECTED.
       */
      public java.lang.String getModerationStatus() {
        return moderationStatus;
      }

      /**
       * Specifies the requested moderation status. Note, comments can be in statuses, which are not
       * available through this call. For example, this call does not allow to mark a comment as
       * 'likely spam'. Valid values: MODERATION_STATUS_PUBLISHED,
       * MODERATION_STATUS_HELD_FOR_REVIEW, MODERATION_STATUS_REJECTED.
       */
      public SetModerationStatus setModerationStatus(java.lang.String moderationStatus) {
        this.moderationStatus = moderationStatus;
        return this;
      }

      /**
       * If set to true the author of the comment gets added to the ban list. This means all future
       * comments of the author will autmomatically be rejected. Only valid in combination with
       * STATUS_REJECTED.
       */
      @com.google.api.client.util.Key
      private java.lang.Boolean banAuthor;

      /** If set to true the author of the comment gets added to the ban list. This means all future comments
     of the author will autmomatically be rejected. Only valid in combination with STATUS_REJECTED.
     [default: false]
       */
      public java.lang.Boolean getBanAuthor() {
        return banAuthor;
      }

      /**
       * If set to true the author of the comment gets added to the ban list. This means all future
       * comments of the author will autmomatically be rejected. Only valid in combination with
       * STATUS_REJECTED.
       */
      public SetModerationStatus setBanAuthor(java.lang.Boolean banAuthor) {
        this.banAuthor = banAuthor;
        return this;
      }

      /**
       * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
       *
       * <p>
       * Boolean properties can have four possible values:
       * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
       * or {@link Boolean#FALSE}.
       * </p>
       *
       * <p>
       * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
       * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
       * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * </p>
       *
       * <p>
       * If set to true the author of the comment gets added to the ban list. This means all future comments
     of the author will autmomatically be rejected. Only valid in combination with STATUS_REJECTED.
       * </p>
       */
      public boolean isBanAuthor() {
        if (banAuthor == null || banAuthor == com.google.api.client.util.Data.NULL_BOOLEAN) {
          return false;
        }
        return banAuthor;
      }

      @Override
      public SetModerationStatus set(String parameterName, Object value) {
        return (SetModerationStatus) super.set(parameterName, value);
      }
    }
    /**
     * Updates an existing resource.
     *
     * Create a request for the method "comments.update".
     *
     * This request holds the parameters needed by the youtube server.  After setting any optional
     * parameters, call the {@link Update#execute()} method to invoke the remote operation.
     *
     * @param part The *part* parameter identifies the properties that the API response will include. You must at least
     *        include the snippet part in the parameter value since that part contains all of the
     *        properties that the API request can update.
     * @param content the {@link com.google.api.services.youtube.model.Comment}
     * @return the request
     */
    public Update update(java.util.List<java.lang.String> part, com.google.api.services.youtube.model.Comment content) throws java.io.IOException {
      Update result = new Update(part, content);
      initialize(result);
      return result;
    }

    public class Update extends YouTubeRequest<com.google.api.services.youtube.model.Comment> {

      private static final String REST_PATH = "youtube/v3/comments";

      /**
       * Updates an existing resource.
       *
       * Create a request for the method "comments.update".
       *
       * This request holds the parameters needed by the the youtube server.  After setting any optional
       * parameters, call the {@link Update#execute()} method to invoke the remote operation. <p> {@link
       * Update#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param part The *part* parameter identifies the properties that the API response will include. You must at least
     *        include the snippet part in the parameter value since that part contains all of the
     *        properties that the API request can update.
       * @param content the {@link com.google.api.services.youtube.model.Comment}
       * @since 1.13
       */
      protected Update(java.util.List<java.lang.String> part, com.google.api.services.youtube.model.Comment content) {
        super(YouTube.this, "PUT", REST_PATH, content, com.google.api.services.youtube.model.Comment.class);
        this.part = com.google.api.client.util.Preconditions.checkNotNull(part, "Required parameter part must be specified.");
      }

      @Override
      public Update set$Xgafv(java.lang.String $Xgafv) {
        return (Update) super.set$Xgafv($Xgafv);
      }

      @Override
      public Update setAccessToken(java.lang.String accessToken) {
        return (Update) super.setAccessToken(accessToken);
      }

      @Override
      public Update setAlt(java.lang.String alt) {
        return (Update) super.setAlt(alt);
      }

      @Override
      public Update setCallback(java.lang.String callback) {
        return (Update) super.setCallback(callback);
      }

      @Override
      public Update setFields(java.lang.String fields) {
        return (Update) super.setFields(fields);
      }

      @Override
      public Update setKey(java.lang.String key) {
        return (Update) super.setKey(key);
      }

      @Override
      public Update setOauthToken(java.lang.String oauthToken) {
        return (Update) super.setOauthToken(oauthToken);
      }

      @Override
      public Update setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Update) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Update setQuotaUser(java.lang.String quotaUser) {
        return (Update) super.setQuotaUser(quotaUser);
      }

      @Override
      public Update setUploadType(java.lang.String uploadType) {
        return (Update) super.setUploadType(uploadType);
      }

      @Override
      public Update setUploadProtocol(java.lang.String uploadProtocol) {
        return (Update) super.setUploadProtocol(uploadProtocol);
      }

      /**
       * The *part* parameter identifies the properties that the API response will include. You must
       * at least include the snippet part in the parameter value since that part contains all of
       * the properties that the API request can update.
       */
      @com.google.api.client.util.Key
      private java.util.List<java.lang.String> part;

      /** The *part* parameter identifies the properties that the API response will include. You must at
     least include the snippet part in the parameter value since that part contains all of the
     properties that the API request can update.
       */
      public java.util.List<java.lang.String> getPart() {
        return part;
      }

      /**
       * The *part* parameter identifies the properties that the API response will include. You must
       * at least include the snippet part in the parameter value since that part contains all of
       * the properties that the API request can update.
       */
      public Update setPart(java.util.List<java.lang.String> part) {
        this.part = part;
        return this;
      }

      @Override
      public Update set(String parameterName, Object value) {
        return (Update) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the I18nLanguages collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code YouTube youtube = new YouTube(...);}
   *   {@code YouTube.I18nLanguages.List request = youtube.i18nLanguages().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public I18nLanguages i18nLanguages() {
    return new I18nLanguages();
  }

  /**
   * The "i18nLanguages" collection of methods.
   */
  public class I18nLanguages {

    /**
     * Retrieves a list of resources, possibly filtered.
     *
     * Create a request for the method "i18nLanguages.list".
     *
     * This request holds the parameters needed by the youtube server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param part The *part* parameter specifies the i18nLanguage resource properties that the API response will
     *        include. Set the parameter value to snippet.
     * @return the request
     */
    public List list(java.util.List<java.lang.String> part) throws java.io.IOException {
      List result = new List(part);
      initialize(result);
      return result;
    }

    public class List extends YouTubeRequest<com.google.api.services.youtube.model.I18nLanguageListResponse> {

      private static final String REST_PATH = "youtube/v3/i18nLanguages";

      /**
       * Retrieves a list of resources, possibly filtered.
       *
       * Create a request for the method "i18nLanguages.list".
       *
       * This request holds the parameters needed by the the youtube server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param part The *part* parameter specifies the i18nLanguage resource properties that the API response will
     *        include. Set the parameter value to snippet.
       * @since 1.13
       */
      protected List(java.util.List<java.lang.String> part) {
        super(YouTube.this, "GET", REST_PATH, null, com.google.api.services.youtube.model.I18nLanguageListResponse.class);
        this.part = com.google.api.client.util.Preconditions.checkNotNull(part, "Required parameter part must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List set$Xgafv(java.lang.String $Xgafv) {
        return (List) super.set$Xgafv($Xgafv);
      }

      @Override
      public List setAccessToken(java.lang.String accessToken) {
        return (List) super.setAccessToken(accessToken);
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setCallback(java.lang.String callback) {
        return (List) super.setCallback(callback);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUploadType(java.lang.String uploadType) {
        return (List) super.setUploadType(uploadType);
      }

      @Override
      public List setUploadProtocol(java.lang.String uploadProtocol) {
        return (List) super.setUploadProtocol(uploadProtocol);
      }

      /**
       * The *part* parameter specifies the i18nLanguage resource properties that the API response
       * will include. Set the parameter value to snippet.
       */
      @com.google.api.client.util.Key
      private java.util.List<java.lang.String> part;

      /** The *part* parameter specifies the i18nLanguage resource properties that the API response will
     include. Set the parameter value to snippet.
       */
      public java.util.List<java.lang.String> getPart() {
        return part;
      }

      /**
       * The *part* parameter specifies the i18nLanguage resource properties that the API response
       * will include. Set the parameter value to snippet.
       */
      public List setPart(java.util.List<java.lang.String> part) {
        this.part = part;
        return this;
      }

      @com.google.api.client.util.Key
      private java.lang.String hl;

      /**
     [ default: en_US]
     [

       */
      public java.lang.String getHl() {
        return hl;
      }

      public List setHl(java.lang.String hl) {
        this.hl = hl;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the I18nRegions collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code YouTube youtube = new YouTube(...);}
   *   {@code YouTube.I18nRegions.List request = youtube.i18nRegions().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public I18nRegions i18nRegions() {
    return new I18nRegions();
  }

  /**
   * The "i18nRegions" collection of methods.
   */
  public class I18nRegions {

    /**
     * Retrieves a list of resources, possibly filtered.
     *
     * Create a request for the method "i18nRegions.list".
     *
     * This request holds the parameters needed by the youtube server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param part The *part* parameter specifies the i18nRegion resource properties that the API response will
     *        include. Set the parameter value to snippet.
     * @return the request
     */
    public List list(java.util.List<java.lang.String> part) throws java.io.IOException {
      List result = new List(part);
      initialize(result);
      return result;
    }

    public class List extends YouTubeRequest<com.google.api.services.youtube.model.I18nRegionListResponse> {

      private static final String REST_PATH = "youtube/v3/i18nRegions";

      /**
       * Retrieves a list of resources, possibly filtered.
       *
       * Create a request for the method "i18nRegions.list".
       *
       * This request holds the parameters needed by the the youtube server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param part The *part* parameter specifies the i18nRegion resource properties that the API response will
     *        include. Set the parameter value to snippet.
       * @since 1.13
       */
      protected List(java.util.List<java.lang.String> part) {
        super(YouTube.this, "GET", REST_PATH, null, com.google.api.services.youtube.model.I18nRegionListResponse.class);
        this.part = com.google.api.client.util.Preconditions.checkNotNull(part, "Required parameter part must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List set$Xgafv(java.lang.String $Xgafv) {
        return (List) super.set$Xgafv($Xgafv);
      }

      @Override
      public List setAccessToken(java.lang.String accessToken) {
        return (List) super.setAccessToken(accessToken);
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setCallback(java.lang.String callback) {
        return (List) super.setCallback(callback);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUploadType(java.lang.String uploadType) {
        return (List) super.setUploadType(uploadType);
      }

      @Override
      public List setUploadProtocol(java.lang.String uploadProtocol) {
        return (List) super.setUploadProtocol(uploadProtocol);
      }

      /**
       * The *part* parameter specifies the i18nRegion resource properties that the API response
       * will include. Set the parameter value to snippet.
       */
      @com.google.api.client.util.Key
      private java.util.List<java.lang.String> part;

      /** The *part* parameter specifies the i18nRegion resource properties that the API response will
     include. Set the parameter value to snippet.
       */
      public java.util.List<java.lang.String> getPart() {
        return part;
      }

      /**
       * The *part* parameter specifies the i18nRegion resource properties that the API response
       * will include. Set the parameter value to snippet.
       */
      public List setPart(java.util.List<java.lang.String> part) {
        this.part = part;
        return this;
      }

      @com.google.api.client.util.Key
      private java.lang.String hl;

      /**
     [ default: en_US]
     [

       */
      public java.lang.String getHl() {
        return hl;
      }

      public List setHl(java.lang.String hl) {
        this.hl = hl;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the LiveBroadcasts collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code YouTube youtube = new YouTube(...);}
   *   {@code YouTube.LiveBroadcasts.List request = youtube.liveBroadcasts().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public LiveBroadcasts liveBroadcasts() {
    return new LiveBroadcasts();
  }

  /**
   * The "liveBroadcasts" collection of methods.
   */
  public class LiveBroadcasts {

    /**
     * Bind a broadcast to a stream.
     *
     * Create a request for the method "liveBroadcasts.bind".
     *
     * This request holds the parameters needed by the youtube server.  After setting any optional
     * parameters, call the {@link Bind#execute()} method to invoke the remote operation.
     *
     * @param id Broadcast to bind to the stream
     * @param part The *part* parameter specifies a comma-separated list of one or more liveBroadcast resource
     *        properties that the API response will include. The part names that you can include in the
     *        parameter value are id, snippet, contentDetails, and status.
     * @return the request
     */
    public Bind bind(java.lang.String id, java.util.List<java.lang.String> part) throws java.io.IOException {
      Bind result = new Bind(id, part);
      initialize(result);
      return result;
    }

    public class Bind extends YouTubeRequest<com.google.api.services.youtube.model.LiveBroadcast> {

      private static final String REST_PATH = "youtube/v3/liveBroadcasts/bind";

      /**
       * Bind a broadcast to a stream.
       *
       * Create a request for the method "liveBroadcasts.bind".
       *
       * This request holds the parameters needed by the the youtube server.  After setting any optional
       * parameters, call the {@link Bind#execute()} method to invoke the remote operation. <p> {@link
       * Bind#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param id Broadcast to bind to the stream
       * @param part The *part* parameter specifies a comma-separated list of one or more liveBroadcast resource
     *        properties that the API response will include. The part names that you can include in the
     *        parameter value are id, snippet, contentDetails, and status.
       * @since 1.13
       */
      protected Bind(java.lang.String id, java.util.List<java.lang.String> part) {
        super(YouTube.this, "POST", REST_PATH, null, com.google.api.services.youtube.model.LiveBroadcast.class);
        this.id = com.google.api.client.util.Preconditions.checkNotNull(id, "Required parameter id must be specified.");
        this.part = com.google.api.client.util.Preconditions.checkNotNull(part, "Required parameter part must be specified.");
      }

      @Override
      public Bind set$Xgafv(java.lang.String $Xgafv) {
        return (Bind) super.set$Xgafv($Xgafv);
      }

      @Override
      public Bind setAccessToken(java.lang.String accessToken) {
        return (Bind) super.setAccessToken(accessToken);
      }

      @Override
      public Bind setAlt(java.lang.String alt) {
        return (Bind) super.setAlt(alt);
      }

      @Override
      public Bind setCallback(java.lang.String callback) {
        return (Bind) super.setCallback(callback);
      }

      @Override
      public Bind setFields(java.lang.String fields) {
        return (Bind) super.setFields(fields);
      }

      @Override
      public Bind setKey(java.lang.String key) {
        return (Bind) super.setKey(key);
      }

      @Override
      public Bind setOauthToken(java.lang.String oauthToken) {
        return (Bind) super.setOauthToken(oauthToken);
      }

      @Override
      public Bind setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Bind) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Bind setQuotaUser(java.lang.String quotaUser) {
        return (Bind) super.setQuotaUser(quotaUser);
      }

      @Override
      public Bind setUploadType(java.lang.String uploadType) {
        return (Bind) super.setUploadType(uploadType);
      }

      @Override
      public Bind setUploadProtocol(java.lang.String uploadProtocol) {
        return (Bind) super.setUploadProtocol(uploadProtocol);
      }

      /** Broadcast to bind to the stream */
      @com.google.api.client.util.Key
      private java.lang.String id;

      /** Broadcast to bind to the stream
       */
      public java.lang.String getId() {
        return id;
      }

      /** Broadcast to bind to the stream */
      public Bind setId(java.lang.String id) {
        this.id = id;
        return this;
      }

      /**
       * The *part* parameter specifies a comma-separated list of one or more liveBroadcast resource
       * properties that the API response will include. The part names that you can include in the
       * parameter value are id, snippet, contentDetails, and status.
       */
      @com.google.api.client.util.Key
      private java.util.List<java.lang.String> part;

      /** The *part* parameter specifies a comma-separated list of one or more liveBroadcast resource
     properties that the API response will include. The part names that you can include in the parameter
     value are id, snippet, contentDetails, and status.
       */
      public java.util.List<java.lang.String> getPart() {
        return part;
      }

      /**
       * The *part* parameter specifies a comma-separated list of one or more liveBroadcast resource
       * properties that the API response will include. The part names that you can include in the
       * parameter value are id, snippet, contentDetails, and status.
       */
      public Bind setPart(java.util.List<java.lang.String> part) {
        this.part = part;
        return this;
      }

      /**
       * *Note:* This parameter is intended exclusively for YouTube content partners. The
       * *onBehalfOfContentOwner* parameter indicates that the request's authorization credentials
       * identify a YouTube CMS user who is acting on behalf of the content owner specified in the
       * parameter value. This parameter is intended for YouTube content partners that own and
       * manage many different YouTube channels. It allows content owners to authenticate once and
       * get access to all their video and channel data, without having to provide authentication
       * credentials for each individual channel. The CMS account that the user authenticates with
       * must be linked to the specified YouTube content owner.
       */
      @com.google.api.client.util.Key
      private java.lang.String onBehalfOfContentOwner;

      /*** Note:* This parameter is intended exclusively for YouTube content partners. The
    * *onBehalfOfContentOwner* parameter indicates that the request's authorization credentials identify
    * a YouTube CMS user who is acting on behalf of the content owner specified in the parameter value.
    * This parameter is intended for YouTube content partners that own and manage many different YouTube
    * channels. It allows content owners to authenticate once and get access to all their video and
    * channel data, without having to provide authentication credentials for each individual channel.
    * The CMS account that the user authenticates with must be linked to the specified YouTube content
    * owner.
    *

       */
      public java.lang.String getOnBehalfOfContentOwner() {
        return onBehalfOfContentOwner;
      }

      /**
       * *Note:* This parameter is intended exclusively for YouTube content partners. The
       * *onBehalfOfContentOwner* parameter indicates that the request's authorization credentials
       * identify a YouTube CMS user who is acting on behalf of the content owner specified in the
       * parameter value. This parameter is intended for YouTube content partners that own and
       * manage many different YouTube channels. It allows content owners to authenticate once and
       * get access to all their video and channel data, without having to provide authentication
       * credentials for each individual channel. The CMS account that the user authenticates with
       * must be linked to the specified YouTube content owner.
       */
      public Bind setOnBehalfOfContentOwner(java.lang.String onBehalfOfContentOwner) {
        this.onBehalfOfContentOwner = onBehalfOfContentOwner;
        return this;
      }

      /**
       * This parameter can only be used in a properly authorized request. *Note:* This parameter is
       * intended exclusively for YouTube content partners. The *onBehalfOfContentOwnerChannel*
       * parameter specifies the YouTube channel ID of the channel to which a video is being added.
       * This parameter is required when a request specifies a value for the onBehalfOfContentOwner
       * parameter, and it can only be used in conjunction with that parameter. In addition, the
       * request must be authorized using a CMS account that is linked to the content owner that the
       * onBehalfOfContentOwner parameter specifies. Finally, the channel that the
       * onBehalfOfContentOwnerChannel parameter value specifies must be linked to the content owner
       * that the onBehalfOfContentOwner parameter specifies. This parameter is intended for YouTube
       * content partners that own and manage many different YouTube channels. It allows content
       * owners to authenticate once and perform actions on behalf of the channel specified in the
       * parameter value, without having to provide authentication credentials for each separate
       * channel.
       */
      @com.google.api.client.util.Key
      private java.lang.String onBehalfOfContentOwnerChannel;

      /** This parameter can only be used in a properly authorized request. *Note:* This parameter is
     intended exclusively for YouTube content partners. The *onBehalfOfContentOwnerChannel* parameter
     specifies the YouTube channel ID of the channel to which a video is being added. This parameter is
     required when a request specifies a value for the onBehalfOfContentOwner parameter, and it can only
     be used in conjunction with that parameter. In addition, the request must be authorized using a CMS
     account that is linked to the content owner that the onBehalfOfContentOwner parameter specifies.
     Finally, the channel that the onBehalfOfContentOwnerChannel parameter value specifies must be
     linked to the content owner that the onBehalfOfContentOwner parameter specifies. This parameter is
     intended for YouTube content partners that own and manage many different YouTube channels. It
     allows content owners to authenticate once and perform actions on behalf of the channel specified
     in the parameter value, without having to provide authentication credentials for each separate
     channel.
       */
      public java.lang.String getOnBehalfOfContentOwnerChannel() {
        return onBehalfOfContentOwnerChannel;
      }

      /**
       * This parameter can only be used in a properly authorized request. *Note:* This parameter is
       * intended exclusively for YouTube content partners. The *onBehalfOfContentOwnerChannel*
       * parameter specifies the YouTube channel ID of the channel to which a video is being added.
       * This parameter is required when a request specifies a value for the onBehalfOfContentOwner
       * parameter, and it can only be used in conjunction with that parameter. In addition, the
       * request must be authorized using a CMS account that is linked to the content owner that the
       * onBehalfOfContentOwner parameter specifies. Finally, the channel that the
       * onBehalfOfContentOwnerChannel parameter value specifies must be linked to the content owner
       * that the onBehalfOfContentOwner parameter specifies. This parameter is intended for YouTube
       * content partners that own and manage many different YouTube channels. It allows content
       * owners to authenticate once and perform actions on behalf of the channel specified in the
       * parameter value, without having to provide authentication credentials for each separate
       * channel.
       */
      public Bind setOnBehalfOfContentOwnerChannel(java.lang.String onBehalfOfContentOwnerChannel) {
        this.onBehalfOfContentOwnerChannel = onBehalfOfContentOwnerChannel;
        return this;
      }

      /** Stream to bind, if not set unbind the current one. */
      @com.google.api.client.util.Key
      private java.lang.String streamId;

      /** Stream to bind, if not set unbind the current one.
       */
      public java.lang.String getStreamId() {
        return streamId;
      }

      /** Stream to bind, if not set unbind the current one. */
      public Bind setStreamId(java.lang.String streamId) {
        this.streamId = streamId;
        return this;
      }

      @Override
      public Bind set(String parameterName, Object value) {
        return (Bind) super.set(parameterName, value);
      }
    }
    /**
     * Delete a given broadcast.
     *
     * Create a request for the method "liveBroadcasts.delete".
     *
     * This request holds the parameters needed by the youtube server.  After setting any optional
     * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
     *
     * @param id Broadcast to delete.
     * @return the request
     */
    public Delete delete(java.lang.String id) throws java.io.IOException {
      Delete result = new Delete(id);
      initialize(result);
      return result;
    }

    public class Delete extends YouTubeRequest<Void> {

      private static final String REST_PATH = "youtube/v3/liveBroadcasts";

      /**
       * Delete a given broadcast.
       *
       * Create a request for the method "liveBroadcasts.delete".
       *
       * This request holds the parameters needed by the the youtube server.  After setting any optional
       * parameters, call the {@link Delete#execute()} method to invoke the remote operation. <p> {@link
       * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param id Broadcast to delete.
       * @since 1.13
       */
      protected Delete(java.lang.String id) {
        super(YouTube.this, "DELETE", REST_PATH, null, Void.class);
        this.id = com.google.api.client.util.Preconditions.checkNotNull(id, "Required parameter id must be specified.");
      }

      @Override
      public Delete set$Xgafv(java.lang.String $Xgafv) {
        return (Delete) super.set$Xgafv($Xgafv);
      }

      @Override
      public Delete setAccessToken(java.lang.String accessToken) {
        return (Delete) super.setAccessToken(accessToken);
      }

      @Override
      public Delete setAlt(java.lang.String alt) {
        return (Delete) super.setAlt(alt);
      }

      @Override
      public Delete setCallback(java.lang.String callback) {
        return (Delete) super.setCallback(callback);
      }

      @Override
      public Delete setFields(java.lang.String fields) {
        return (Delete) super.setFields(fields);
      }

      @Override
      public Delete setKey(java.lang.String key) {
        return (Delete) super.setKey(key);
      }

      @Override
      public Delete setOauthToken(java.lang.String oauthToken) {
        return (Delete) super.setOauthToken(oauthToken);
      }

      @Override
      public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Delete) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Delete setQuotaUser(java.lang.String quotaUser) {
        return (Delete) super.setQuotaUser(quotaUser);
      }

      @Override
      public Delete setUploadType(java.lang.String uploadType) {
        return (Delete) super.setUploadType(uploadType);
      }

      @Override
      public Delete setUploadProtocol(java.lang.String uploadProtocol) {
        return (Delete) super.setUploadProtocol(uploadProtocol);
      }

      /** Broadcast to delete. */
      @com.google.api.client.util.Key
      private java.lang.String id;

      /** Broadcast to delete.
       */
      public java.lang.String getId() {
        return id;
      }

      /** Broadcast to delete. */
      public Delete setId(java.lang.String id) {
        this.id = id;
        return this;
      }

      /**
       * *Note:* This parameter is intended exclusively for YouTube content partners. The
       * *onBehalfOfContentOwner* parameter indicates that the request's authorization credentials
       * identify a YouTube CMS user who is acting on behalf of the content owner specified in the
       * parameter value. This parameter is intended for YouTube content partners that own and
       * manage many different YouTube channels. It allows content owners to authenticate once and
       * get access to all their video and channel data, without having to provide authentication
       * credentials for each individual channel. The CMS account that the user authenticates with
       * must be linked to the specified YouTube content owner.
       */
      @com.google.api.client.util.Key
      private java.lang.String onBehalfOfContentOwner;

      /*** Note:* This parameter is intended exclusively for YouTube content partners. The
    * *onBehalfOfContentOwner* parameter indicates that the request's authorization credentials identify
    * a YouTube CMS user who is acting on behalf of the content owner specified in the parameter value.
    * This parameter is intended for YouTube content partners that own and manage many different YouTube
    * channels. It allows content owners to authenticate once and get access to all their video and
    * channel data, without having to provide authentication credentials for each individual channel.
    * The CMS account that the user authenticates with must be linked to the specified YouTube content
    * owner.
    *

       */
      public java.lang.String getOnBehalfOfContentOwner() {
        return onBehalfOfContentOwner;
      }

      /**
       * *Note:* This parameter is intended exclusively for YouTube content partners. The
       * *onBehalfOfContentOwner* parameter indicates that the request's authorization credentials
       * identify a YouTube CMS user who is acting on behalf of the content owner specified in the
       * parameter value. This parameter is intended for YouTube content partners that own and
       * manage many different YouTube channels. It allows content owners to authenticate once and
       * get access to all their video and channel data, without having to provide authentication
       * credentials for each individual channel. The CMS account that the user authenticates with
       * must be linked to the specified YouTube content owner.
       */
      public Delete setOnBehalfOfContentOwner(java.lang.String onBehalfOfContentOwner) {
        this.onBehalfOfContentOwner = onBehalfOfContentOwner;
        return this;
      }

      /**
       * This parameter can only be used in a properly authorized request. *Note:* This parameter is
       * intended exclusively for YouTube content partners. The *onBehalfOfContentOwnerChannel*
       * parameter specifies the YouTube channel ID of the channel to which a video is being added.
       * This parameter is required when a request specifies a value for the onBehalfOfContentOwner
       * parameter, and it can only be used in conjunction with that parameter. In addition, the
       * request must be authorized using a CMS account that is linked to the content owner that the
       * onBehalfOfContentOwner parameter specifies. Finally, the channel that the
       * onBehalfOfContentOwnerChannel parameter value specifies must be linked to the content owner
       * that the onBehalfOfContentOwner parameter specifies. This parameter is intended for YouTube
       * content partners that own and manage many different YouTube channels. It allows content
       * owners to authenticate once and perform actions on behalf of the channel specified in the
       * parameter value, without having to provide authentication credentials for each separate
       * channel.
       */
      @com.google.api.client.util.Key
      private java.lang.String onBehalfOfContentOwnerChannel;

      /** This parameter can only be used in a properly authorized request. *Note:* This parameter is
     intended exclusively for YouTube content partners. The *onBehalfOfContentOwnerChannel* parameter
     specifies the YouTube channel ID of the channel to which a video is being added. This parameter is
     required when a request specifies a value for the onBehalfOfContentOwner parameter, and it can only
     be used in conjunction with that parameter. In addition, the request must be authorized using a CMS
     account that is linked to the content owner that the onBehalfOfContentOwner parameter specifies.
     Finally, the channel that the onBehalfOfContentOwnerChannel parameter value specifies must be
     linked to the content owner that the onBehalfOfContentOwner parameter specifies. This parameter is
     intended for YouTube content partners that own and manage many different YouTube channels. It
     allows content owners to authenticate once and perform actions on behalf of the channel specified
     in the parameter value, without having to provide authentication credentials for each separate
     channel.
       */
      public java.lang.String getOnBehalfOfContentOwnerChannel() {
        return onBehalfOfContentOwnerChannel;
      }

      /**
       * This parameter can only be used in a properly authorized request. *Note:* This parameter is
       * intended exclusively for YouTube content partners. The *onBehalfOfContentOwnerChannel*
       * parameter specifies the YouTube channel ID of the channel to which a video is being added.
       * This parameter is required when a request specifies a value for the onBehalfOfContentOwner
       * parameter, and it can only be used in conjunction with that parameter. In addition, the
       * request must be authorized using a CMS account that is linked to the content owner that the
       * onBehalfOfContentOwner parameter specifies. Finally, the channel that the
       * onBehalfOfContentOwnerChannel parameter value specifies must be linked to the content owner
       * that the onBehalfOfContentOwner parameter specifies. This parameter is intended for YouTube
       * content partners that own and manage many different YouTube channels. It allows content
       * owners to authenticate once and perform actions on behalf of the channel specified in the
       * parameter value, without having to provide authentication credentials for each separate
       * channel.
       */
      public Delete setOnBehalfOfContentOwnerChannel(java.lang.String onBehalfOfContentOwnerChannel) {
        this.onBehalfOfContentOwnerChannel = onBehalfOfContentOwnerChannel;
        return this;
      }

      @Override
      public Delete set(String parameterName, Object value) {
        return (Delete) super.set(parameterName, value);
      }
    }
    /**
     * Inserts a new stream for the authenticated user.
     *
     * Create a request for the method "liveBroadcasts.insert".
     *
     * This request holds the parameters needed by the youtube server.  After setting any optional
     * parameters, call the {@link Insert#execute()} method to invoke the remote operation.
     *
     * @param part The *part* parameter serves two purposes in this operation. It identifies the properties that the
     *        write operation will set as well as the properties that the API response will include. The
     *        part properties that you can include in the parameter value are id, snippet,
     *        contentDetails, and status.
     * @param content the {@link com.google.api.services.youtube.model.LiveBroadcast}
     * @return the request
     */
    public Insert insert(java.util.List<java.lang.String> part, com.google.api.services.youtube.model.LiveBroadcast content) throws java.io.IOException {
      Insert result = new Insert(part, content);
      initialize(result);
      return result;
    }

    public class Insert extends YouTubeRequest<com.google.api.services.youtube.model.LiveBroadcast> {

      private static final String REST_PATH = "youtube/v3/liveBroadcasts";

      /**
       * Inserts a new stream for the authenticated user.
       *
       * Create a request for the method "liveBroadcasts.insert".
       *
       * This request holds the parameters needed by the the youtube server.  After setting any optional
       * parameters, call the {@link Insert#execute()} method to invoke the remote operation. <p> {@link
       * Insert#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param part The *part* parameter serves two purposes in this operation. It identifies the properties that the
     *        write operation will set as well as the properties that the API response will include. The
     *        part properties that you can include in the parameter value are id, snippet,
     *        contentDetails, and status.
       * @param content the {@link com.google.api.services.youtube.model.LiveBroadcast}
       * @since 1.13
       */
      protected Insert(java.util.List<java.lang.String> part, com.google.api.services.youtube.model.LiveBroadcast content) {
        super(YouTube.this, "POST", REST_PATH, content, com.google.api.services.youtube.model.LiveBroadcast.class);
        this.part = com.google.api.client.util.Preconditions.checkNotNull(part, "Required parameter part must be specified.");
      }

      @Override
      public Insert set$Xgafv(java.lang.String $Xgafv) {
        return (Insert) super.set$Xgafv($Xgafv);
      }

      @Override
      public Insert setAccessToken(java.lang.String accessToken) {
        return (Insert) super.setAccessToken(accessToken);
      }

      @Override
      public Insert setAlt(java.lang.String alt) {
        return (Insert) super.setAlt(alt);
      }

      @Override
      public Insert setCallback(java.lang.String callback) {
        return (Insert) super.setCallback(callback);
      }

      @Override
      public Insert setFields(java.lang.String fields) {
        return (Insert) super.setFields(fields);
      }

      @Override
      public Insert setKey(java.lang.String key) {
        return (Insert) super.setKey(key);
      }

      @Override
      public Insert setOauthToken(java.lang.String oauthToken) {
        return (Insert) super.setOauthToken(oauthToken);
      }

      @Override
      public Insert setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Insert) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Insert setQuotaUser(java.lang.String quotaUser) {
        return (Insert) super.setQuotaUser(quotaUser);
      }

      @Override
      public Insert setUploadType(java.lang.String uploadType) {
        return (Insert) super.setUploadType(uploadType);
      }

      @Override
      public Insert setUploadProtocol(java.lang.String uploadProtocol) {
        return (Insert) super.setUploadProtocol(uploadProtocol);
      }

      /**
       * The *part* parameter serves two purposes in this operation. It identifies the properties
       * that the write operation will set as well as the properties that the API response will
       * include. The part properties that you can include in the parameter value are id, snippet,
       * contentDetails, and status.
       */
      @com.google.api.client.util.Key
      private java.util.List<java.lang.String> part;

      /** The *part* parameter serves two purposes in this operation. It identifies the properties that the
     write operation will set as well as the properties that the API response will include. The part
     properties that you can include in the parameter value are id, snippet, contentDetails, and status.
       */
      public java.util.List<java.lang.String> getPart() {
        return part;
      }

      /**
       * The *part* parameter serves two purposes in this operation. It identifies the properties
       * that the write operation will set as well as the properties that the API response will
       * include. The part properties that you can include in the parameter value are id, snippet,
       * contentDetails, and status.
       */
      public Insert setPart(java.util.List<java.lang.String> part) {
        this.part = part;
        return this;
      }

      /**
       * *Note:* This parameter is intended exclusively for YouTube content partners. The
       * *onBehalfOfContentOwner* parameter indicates that the request's authorization credentials
       * identify a YouTube CMS user who is acting on behalf of the content owner specified in the
       * parameter value. This parameter is intended for YouTube content partners that own and
       * manage many different YouTube channels. It allows content owners to authenticate once and
       * get access to all their video and channel data, without having to provide authentication
       * credentials for each individual channel. The CMS account that the user authenticates with
       * must be linked to the specified YouTube content owner.
       */
      @com.google.api.client.util.Key
      private java.lang.String onBehalfOfContentOwner;

      /*** Note:* This parameter is intended exclusively for YouTube content partners. The
    * *onBehalfOfContentOwner* parameter indicates that the request's authorization credentials identify
    * a YouTube CMS user who is acting on behalf of the content owner specified in the parameter value.
    * This parameter is intended for YouTube content partners that own and manage many different YouTube
    * channels. It allows content owners to authenticate once and get access to all their video and
    * channel data, without having to provide authentication credentials for each individual channel.
    * The CMS account that the user authenticates with must be linked to the specified YouTube content
    * owner.
    *

       */
      public java.lang.String getOnBehalfOfContentOwner() {
        return onBehalfOfContentOwner;
      }

      /**
       * *Note:* This parameter is intended exclusively for YouTube content partners. The
       * *onBehalfOfContentOwner* parameter indicates that the request's authorization credentials
       * identify a YouTube CMS user who is acting on behalf of the content owner specified in the
       * parameter value. This parameter is intended for YouTube content partners that own and
       * manage many different YouTube channels. It allows content owners to authenticate once and
       * get access to all their video and channel data, without having to provide authentication
       * credentials for each individual channel. The CMS account that the user authenticates with
       * must be linked to the specified YouTube content owner.
       */
      public Insert setOnBehalfOfContentOwner(java.lang.String onBehalfOfContentOwner) {
        this.onBehalfOfContentOwner = onBehalfOfContentOwner;
        return this;
      }

      /**
       * This parameter can only be used in a properly authorized request. *Note:* This parameter is
       * intended exclusively for YouTube content partners. The *onBehalfOfContentOwnerChannel*
       * parameter specifies the YouTube channel ID of the channel to which a video is being added.
       * This parameter is required when a request specifies a value for the onBehalfOfContentOwner
       * parameter, and it can only be used in conjunction with that parameter. In addition, the
       * request must be authorized using a CMS account that is linked to the content owner that the
       * onBehalfOfContentOwner parameter specifies. Finally, the channel that the
       * onBehalfOfContentOwnerChannel parameter value specifies must be linked to the content owner
       * that the onBehalfOfContentOwner parameter specifies. This parameter is intended for YouTube
       * content partners that own and manage many different YouTube channels. It allows content
       * owners to authenticate once and perform actions on behalf of the channel specified in the
       * parameter value, without having to provide authentication credentials for each separate
       * channel.
       */
      @com.google.api.client.util.Key
      private java.lang.String onBehalfOfContentOwnerChannel;

      /** This parameter can only be used in a properly authorized request. *Note:* This parameter is
     intended exclusively for YouTube content partners. The *onBehalfOfContentOwnerChannel* parameter
     specifies the YouTube channel ID of the channel to which a video is being added. This parameter is
     required when a request specifies a value for the onBehalfOfContentOwner parameter, and it can only
     be used in conjunction with that parameter. In addition, the request must be authorized using a CMS
     account that is linked to the content owner that the onBehalfOfContentOwner parameter specifies.
     Finally, the channel that the onBehalfOfContentOwnerChannel parameter value specifies must be
     linked to the content owner that the onBehalfOfContentOwner parameter specifies. This parameter is
     intended for YouTube content partners that own and manage many different YouTube channels. It
     allows content owners to authenticate once and perform actions on behalf of the channel specified
     in the parameter value, without having to provide authentication credentials for each separate
     channel.
       */
      public java.lang.String getOnBehalfOfContentOwnerChannel() {
        return onBehalfOfContentOwnerChannel;
      }

      /**
       * This parameter can only be used in a properly authorized request. *Note:* This parameter is
       * intended exclusively for YouTube content partners. The *onBehalfOfContentOwnerChannel*
       * parameter specifies the YouTube channel ID of the channel to which a video is being added.
       * This parameter is required when a request specifies a value for the onBehalfOfContentOwner
       * parameter, and it can only be used in conjunction with that parameter. In addition, the
       * request must be authorized using a CMS account that is linked to the content owner that the
       * onBehalfOfContentOwner parameter specifies. Finally, the channel that the
       * onBehalfOfContentOwnerChannel parameter value specifies must be linked to the content owner
       * that the onBehalfOfContentOwner parameter specifies. This parameter is intended for YouTube
       * content partners that own and manage many different YouTube channels. It allows content
       * owners to authenticate once and perform actions on behalf of the channel specified in the
       * parameter value, without having to provide authentication credentials for each separate
       * channel.
       */
      public Insert setOnBehalfOfContentOwnerChannel(java.lang.String onBehalfOfContentOwnerChannel) {
        this.onBehalfOfContentOwnerChannel = onBehalfOfContentOwnerChannel;
        return this;
      }

      @Override
      public Insert set(String parameterName, Object value) {
        return (Insert) super.set(parameterName, value);
      }
    }
    /**
     * Insert cuepoints in a broadcast
     *
     * Create a request for the method "liveBroadcasts.insertCuepoint".
     *
     * This request holds the parameters needed by the youtube server.  After setting any optional
     * parameters, call the {@link InsertCuepoint#execute()} method to invoke the remote operation.
     *
     * @param content the {@link com.google.api.services.youtube.model.Cuepoint}
     * @return the request
     */
    public InsertCuepoint insertCuepoint(com.google.api.services.youtube.model.Cuepoint content) throws java.io.IOException {
      InsertCuepoint result = new InsertCuepoint(content);
      initialize(result);
      return result;
    }

    public class InsertCuepoint extends YouTubeRequest<com.google.api.services.youtube.model.Cuepoint> {

      private static final String REST_PATH = "youtube/v3/liveBroadcasts/cuepoint";

      /**
       * Insert cuepoints in a broadcast
       *
       * Create a request for the method "liveBroadcasts.insertCuepoint".
       *
       * This request holds the parameters needed by the the youtube server.  After setting any optional
       * parameters, call the {@link InsertCuepoint#execute()} method to invoke the remote operation.
       * <p> {@link InsertCuepoint#initialize(com.google.api.client.googleapis.services.AbstractGoogleCl
       * ientRequest)} must be called to initialize this instance immediately after invoking the
       * constructor. </p>
       *
       * @param content the {@link com.google.api.services.youtube.model.Cuepoint}
       * @since 1.13
       */
      protected InsertCuepoint(com.google.api.services.youtube.model.Cuepoint content) {
        super(YouTube.this, "POST", REST_PATH, content, com.google.api.services.youtube.model.Cuepoint.class);
      }

      @Override
      public InsertCuepoint set$Xgafv(java.lang.String $Xgafv) {
        return (InsertCuepoint) super.set$Xgafv($Xgafv);
      }

      @Override
      public InsertCuepoint setAccessToken(java.lang.String accessToken) {
        return (InsertCuepoint) super.setAccessToken(accessToken);
      }

      @Override
      public InsertCuepoint setAlt(java.lang.String alt) {
        return (InsertCuepoint) super.setAlt(alt);
      }

      @Override
      public InsertCuepoint setCallback(java.lang.String callback) {
        return (InsertCuepoint) super.setCallback(callback);
      }

      @Override
      public InsertCuepoint setFields(java.lang.String fields) {
        return (InsertCuepoint) super.setFields(fields);
      }

      @Override
      public InsertCuepoint setKey(java.lang.String key) {
        return (InsertCuepoint) super.setKey(key);
      }

      @Override
      public InsertCuepoint setOauthToken(java.lang.String oauthToken) {
        return (InsertCuepoint) super.setOauthToken(oauthToken);
      }

      @Override
      public InsertCuepoint setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (InsertCuepoint) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public InsertCuepoint setQuotaUser(java.lang.String quotaUser) {
        return (InsertCuepoint) super.setQuotaUser(quotaUser);
      }

      @Override
      public InsertCuepoint setUploadType(java.lang.String uploadType) {
        return (InsertCuepoint) super.setUploadType(uploadType);
      }

      @Override
      public InsertCuepoint setUploadProtocol(java.lang.String uploadProtocol) {
        return (InsertCuepoint) super.setUploadProtocol(uploadProtocol);
      }

      /** Broadcast to insert ads to, or equivalently `external_video_id` for internal use. */
      @com.google.api.client.util.Key
      private java.lang.String id;

      /** Broadcast to insert ads to, or equivalently `external_video_id` for internal use.
       */
      public java.lang.String getId() {
        return id;
      }

      /** Broadcast to insert ads to, or equivalently `external_video_id` for internal use. */
      public InsertCuepoint setId(java.lang.String id) {
        this.id = id;
        return this;
      }

      /**
       * *Note:* This parameter is intended exclusively for YouTube content partners. The
       * *onBehalfOfContentOwner* parameter indicates that the request's authorization credentials
       * identify a YouTube CMS user who is acting on behalf of the content owner specified in the
       * parameter value. This parameter is intended for YouTube content partners that own and
       * manage many different YouTube channels. It allows content owners to authenticate once and
       * get access to all their video and channel data, without having to provide authentication
       * credentials for each individual channel. The CMS account that the user authenticates with
       * must be linked to the specified YouTube content owner.
       */
      @com.google.api.client.util.Key
      private java.lang.String onBehalfOfContentOwner;

      /*** Note:* This parameter is intended exclusively for YouTube content partners. The
    * *onBehalfOfContentOwner* parameter indicates that the request's authorization credentials identify
    * a YouTube CMS user who is acting on behalf of the content owner specified in the parameter value.
    * This parameter is intended for YouTube content partners that own and manage many different YouTube
    * channels. It allows content owners to authenticate once and get access to all their video and
    * channel data, without having to provide authentication credentials for each individual channel.
    * The CMS account that the user authenticates with must be linked to the specified YouTube content
    * owner.
    *

       */
      public java.lang.String getOnBehalfOfContentOwner() {
        return onBehalfOfContentOwner;
      }

      /**
       * *Note:* This parameter is intended exclusively for YouTube content partners. The
       * *onBehalfOfContentOwner* parameter indicates that the request's authorization credentials
       * identify a YouTube CMS user who is acting on behalf of the content owner specified in the
       * parameter value. This parameter is intended for YouTube content partners that own and
       * manage many different YouTube channels. It allows content owners to authenticate once and
       * get access to all their video and channel data, without having to provide authentication
       * credentials for each individual channel. The CMS account that the user authenticates with
       * must be linked to the specified YouTube content owner.
       */
      public InsertCuepoint setOnBehalfOfContentOwner(java.lang.String onBehalfOfContentOwner) {
        this.onBehalfOfContentOwner = onBehalfOfContentOwner;
        return this;
      }

      /**
       * This parameter can only be used in a properly authorized request. *Note:* This parameter is
       * intended exclusively for YouTube content partners. The *onBehalfOfContentOwnerChannel*
       * parameter specifies the YouTube channel ID of the channel to which a video is being added.
       * This parameter is required when a request specifies a value for the onBehalfOfContentOwner
       * parameter, and it can only be used in conjunction with that parameter. In addition, the
       * request must be authorized using a CMS account that is linked to the content owner that the
       * onBehalfOfContentOwner parameter specifies. Finally, the channel that the
       * onBehalfOfContentOwnerChannel parameter value specifies must be linked to the content owner
       * that the onBehalfOfContentOwner parameter specifies. This parameter is intended for YouTube
       * content partners that own and manage many different YouTube channels. It allows content
       * owners to authenticate once and perform actions on behalf of the channel specified in the
       * parameter value, without having to provide authentication credentials for each separate
       * channel.
       */
      @com.google.api.client.util.Key
      private java.lang.String onBehalfOfContentOwnerChannel;

      /** This parameter can only be used in a properly authorized request. *Note:* This parameter is
     intended exclusively for YouTube content partners. The *onBehalfOfContentOwnerChannel* parameter
     specifies the YouTube channel ID of the channel to which a video is being added. This parameter is
     required when a request specifies a value for the onBehalfOfContentOwner parameter, and it can only
     be used in conjunction with that parameter. In addition, the request must be authorized using a CMS
     account that is linked to the content owner that the onBehalfOfContentOwner parameter specifies.
     Finally, the channel that the onBehalfOfContentOwnerChannel parameter value specifies must be
     linked to the content owner that the onBehalfOfContentOwner parameter specifies. This parameter is
     intended for YouTube content partners that own and manage many different YouTube channels. It
     allows content owners to authenticate once and perform actions on behalf of the channel specified
     in the parameter value, without having to provide authentication credentials for each separate
     channel.
       */
      public java.lang.String getOnBehalfOfContentOwnerChannel() {
        return onBehalfOfContentOwnerChannel;
      }

      /**
       * This parameter can only be used in a properly authorized request. *Note:* This parameter is
       * intended exclusively for YouTube content partners. The *onBehalfOfContentOwnerChannel*
       * parameter specifies the YouTube channel ID of the channel to which a video is being added.
       * This parameter is required when a request specifies a value for the onBehalfOfContentOwner
       * parameter, and it can only be used in conjunction with that parameter. In addition, the
       * request must be authorized using a CMS account that is linked to the content owner that the
       * onBehalfOfContentOwner parameter specifies. Finally, the channel that the
       * onBehalfOfContentOwnerChannel parameter value specifies must be linked to the content owner
       * that the onBehalfOfContentOwner parameter specifies. This parameter is intended for YouTube
       * content partners that own and manage many different YouTube channels. It allows content
       * owners to authenticate once and perform actions on behalf of the channel specified in the
       * parameter value, without having to provide authentication credentials for each separate
       * channel.
       */
      public InsertCuepoint setOnBehalfOfContentOwnerChannel(java.lang.String onBehalfOfContentOwnerChannel) {
        this.onBehalfOfContentOwnerChannel = onBehalfOfContentOwnerChannel;
        return this;
      }

      /**
       * The *part* parameter specifies a comma-separated list of one or more liveBroadcast resource
       * properties that the API response will include. The part names that you can include in the
       * parameter value are id, snippet, contentDetails, and status.
       */
      @com.google.api.client.util.Key
      private java.util.List<java.lang.String> part;

      /** The *part* parameter specifies a comma-separated list of one or more liveBroadcast resource
     properties that the API response will include. The part names that you can include in the parameter
     value are id, snippet, contentDetails, and status.
       */
      public java.util.List<java.lang.String> getPart() {
        return part;
      }

      /**
       * The *part* parameter specifies a comma-separated list of one or more liveBroadcast resource
       * properties that the API response will include. The part names that you can include in the
       * parameter value are id, snippet, contentDetails, and status.
       */
      public InsertCuepoint setPart(java.util.List<java.lang.String> part) {
        this.part = part;
        return this;
      }

      @Override
      public InsertCuepoint set(String parameterName, Object value) {
        return (InsertCuepoint) super.set(parameterName, value);
      }
    }
    /**
     * Retrieve the list of broadcasts associated with the given channel.
     *
     * Create a request for the method "liveBroadcasts.list".
     *
     * This request holds the parameters needed by the youtube server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param part The *part* parameter specifies a comma-separated list of one or more liveBroadcast resource
     *        properties that the API response will include. The part names that you can include in the
     *        parameter value are id, snippet, contentDetails, status and statistics.
     * @return the request
     */
    public List list(java.util.List<java.lang.String> part) throws java.io.IOException {
      List result = new List(part);
      initialize(result);
      return result;
    }

    public class List extends YouTubeRequest<com.google.api.services.youtube.model.LiveBroadcastListResponse> {

      private static final String REST_PATH = "youtube/v3/liveBroadcasts";

      /**
       * Retrieve the list of broadcasts associated with the given channel.
       *
       * Create a request for the method "liveBroadcasts.list".
       *
       * This request holds the parameters needed by the the youtube server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param part The *part* parameter specifies a comma-separated list of one or more liveBroadcast resource
     *        properties that the API response will include. The part names that you can include in the
     *        parameter value are id, snippet, contentDetails, status and statistics.
       * @since 1.13
       */
      protected List(java.util.List<java.lang.String> part) {
        super(YouTube.this, "GET", REST_PATH, null, com.google.api.services.youtube.model.LiveBroadcastListResponse.class);
        this.part = com.google.api.client.util.Preconditions.checkNotNull(part, "Required parameter part must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List set$Xgafv(java.lang.String $Xgafv) {
        return (List) super.set$Xgafv($Xgafv);
      }

      @Override
      public List setAccessToken(java.lang.String accessToken) {
        return (List) super.setAccessToken(accessToken);
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setCallback(java.lang.String callback) {
        return (List) super.setCallback(callback);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUploadType(java.lang.String uploadType) {
        return (List) super.setUploadType(uploadType);
      }

      @Override
      public List setUploadProtocol(java.lang.String uploadProtocol) {
        return (List) super.setUploadProtocol(uploadProtocol);
      }

      /**
       * The *part* parameter specifies a comma-separated list of one or more liveBroadcast resource
       * properties that the API response will include. The part names that you can include in the
       * parameter value are id, snippet, contentDetails, status and statistics.
       */
      @com.google.api.client.util.Key
      private java.util.List<java.lang.String> part;

      /** The *part* parameter specifies a comma-separated list of one or more liveBroadcast resource
     properties that the API response will include. The part names that you can include in the parameter
     value are id, snippet, contentDetails, status and statistics.
       */
      public java.util.List<java.lang.String> getPart() {
        return part;
      }

      /**
       * The *part* parameter specifies a comma-separated list of one or more liveBroadcast resource
       * properties that the API response will include. The part names that you can include in the
       * parameter value are id, snippet, contentDetails, status and statistics.
       */
      public List setPart(java.util.List<java.lang.String> part) {
        this.part = part;
        return this;
      }

      /** Return broadcasts with a certain status, e.g. active broadcasts. */
      @com.google.api.client.util.Key
      private java.lang.String broadcastStatus;

      /** Return broadcasts with a certain status, e.g. active broadcasts.
       */
      public java.lang.String getBroadcastStatus() {
        return broadcastStatus;
      }

      /** Return broadcasts with a certain status, e.g. active broadcasts. */
      public List setBroadcastStatus(java.lang.String broadcastStatus) {
        this.broadcastStatus = broadcastStatus;
        return this;
      }

      /** Return only broadcasts with the selected type. */
      @com.google.api.client.util.Key
      private java.lang.String broadcastType;

      /** Return only broadcasts with the selected type. [default: event]
       */
      public java.lang.String getBroadcastType() {
        return broadcastType;
      }

      /** Return only broadcasts with the selected type. */
      public List setBroadcastType(java.lang.String broadcastType) {
        this.broadcastType = broadcastType;
        return this;
      }

      /** Return broadcasts with the given ids from Stubby or Apiary. */
      @com.google.api.client.util.Key
      private java.util.List<java.lang.String> id;

      /** Return broadcasts with the given ids from Stubby or Apiary.
       */
      public java.util.List<java.lang.String> getId() {
        return id;
      }

      /** Return broadcasts with the given ids from Stubby or Apiary. */
      public List setId(java.util.List<java.lang.String> id) {
        this.id = id;
        return this;
      }

      /**
       * The *maxResults* parameter specifies the maximum number of items that should be returned in
       * the result set.
       */
      @com.google.api.client.util.Key
      private java.lang.Long maxResults;

      /** The *maxResults* parameter specifies the maximum number of items that should be returned in the
     result set. [default: 5] [minimum: 0] [maximum: 50]
       */
      public java.lang.Long getMaxResults() {
        return maxResults;
      }

      /**
       * The *maxResults* parameter specifies the maximum number of items that should be returned in
       * the result set.
       */
      public List setMaxResults(java.lang.Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      @com.google.api.client.util.Key
      private java.lang.Boolean mine;

      /**

       */
      public java.lang.Boolean getMine() {
        return mine;
      }

      public List setMine(java.lang.Boolean mine) {
        this.mine = mine;
        return this;
      }

      /**
       * *Note:* This parameter is intended exclusively for YouTube content partners. The
       * *onBehalfOfContentOwner* parameter indicates that the request's authorization credentials
       * identify a YouTube CMS user who is acting on behalf of the content owner specified in the
       * parameter value. This parameter is intended for YouTube content partners that own and
       * manage many different YouTube channels. It allows content owners to authenticate once and
       * get access to all their video and channel data, without having to provide authentication
       * credentials for each individual channel. The CMS account that the user authenticates with
       * must be linked to the specified YouTube content owner.
       */
      @com.google.api.client.util.Key
      private java.lang.String onBehalfOfContentOwner;

      /*** Note:* This parameter is intended exclusively for YouTube content partners. The
    * *onBehalfOfContentOwner* parameter indicates that the request's authorization credentials identify
    * a YouTube CMS user who is acting on behalf of the content owner specified in the parameter value.
    * This parameter is intended for YouTube content partners that own and manage many different YouTube
    * channels. It allows content owners to authenticate once and get access to all their video and
    * channel data, without having to provide authentication credentials for each individual channel.
    * The CMS account that the user authenticates with must be linked to the specified YouTube content
    * owner.
    *

       */
      public java.lang.String getOnBehalfOfContentOwner() {
        return onBehalfOfContentOwner;
      }

      /**
       * *Note:* This parameter is intended exclusively for YouTube content partners. The
       * *onBehalfOfContentOwner* parameter indicates that the request's authorization credentials
       * identify a YouTube CMS user who is acting on behalf of the content owner specified in the
       * parameter value. This parameter is intended for YouTube content partners that own and
       * manage many different YouTube channels. It allows content owners to authenticate once and
       * get access to all their video and channel data, without having to provide authentication
       * credentials for each individual channel. The CMS account that the user authenticates with
       * must be linked to the specified YouTube content owner.
       */
      public List setOnBehalfOfContentOwner(java.lang.String onBehalfOfContentOwner) {
        this.onBehalfOfContentOwner = onBehalfOfContentOwner;
        return this;
      }

      /**
       * This parameter can only be used in a properly authorized request. *Note:* This parameter is
       * intended exclusively for YouTube content partners. The *onBehalfOfContentOwnerChannel*
       * parameter specifies the YouTube channel ID of the channel to which a video is being added.
       * This parameter is required when a request specifies a value for the onBehalfOfContentOwner
       * parameter, and it can only be used in conjunction with that parameter. In addition, the
       * request must be authorized using a CMS account that is linked to the content owner that the
       * onBehalfOfContentOwner parameter specifies. Finally, the channel that the
       * onBehalfOfContentOwnerChannel parameter value specifies must be linked to the content owner
       * that the onBehalfOfContentOwner parameter specifies. This parameter is intended for YouTube
       * content partners that own and manage many different YouTube channels. It allows content
       * owners to authenticate once and perform actions on behalf of the channel specified in the
       * parameter value, without having to provide authentication credentials for each separate
       * channel.
       */
      @com.google.api.client.util.Key
      private java.lang.String onBehalfOfContentOwnerChannel;

      /** This parameter can only be used in a properly authorized request. *Note:* This parameter is
     intended exclusively for YouTube content partners. The *onBehalfOfContentOwnerChannel* parameter
     specifies the YouTube channel ID of the channel to which a video is being added. This parameter is
     required when a request specifies a value for the onBehalfOfContentOwner parameter, and it can only
     be used in conjunction with that parameter. In addition, the request must be authorized using a CMS
     account that is linked to the content owner that the onBehalfOfContentOwner parameter specifies.
     Finally, the channel that the onBehalfOfContentOwnerChannel parameter value specifies must be
     linked to the content owner that the onBehalfOfContentOwner parameter specifies. This parameter is
     intended for YouTube content partners that own and manage many different YouTube channels. It
     allows content owners to authenticate once and perform actions on behalf of the channel specified
     in the parameter value, without having to provide authentication credentials for each separate
     channel.
       */
      public java.lang.String getOnBehalfOfContentOwnerChannel() {
        return onBehalfOfContentOwnerChannel;
      }

      /**
       * This parameter can only be used in a properly authorized request. *Note:* This parameter is
       * intended exclusively for YouTube content partners. The *onBehalfOfContentOwnerChannel*
       * parameter specifies the YouTube channel ID of the channel to which a video is being added.
       * This parameter is required when a request specifies a value for the onBehalfOfContentOwner
       * parameter, and it can only be used in conjunction with that parameter. In addition, the
       * request must be authorized using a CMS account that is linked to the content owner that the
       * onBehalfOfContentOwner parameter specifies. Finally, the channel that the
       * onBehalfOfContentOwnerChannel parameter value specifies must be linked to the content owner
       * that the onBehalfOfContentOwner parameter specifies. This parameter is intended for YouTube
       * content partners that own and manage many different YouTube channels. It allows content
       * owners to authenticate once and perform actions on behalf of the channel specified in the
       * parameter value, without having to provide authentication credentials for each separate
       * channel.
       */
      public List setOnBehalfOfContentOwnerChannel(java.lang.String onBehalfOfContentOwnerChannel) {
        this.onBehalfOfContentOwnerChannel = onBehalfOfContentOwnerChannel;
        return this;
      }

      /**
       * The *pageToken* parameter identifies a specific page in the result set that should be
       * returned. In an API response, the nextPageToken and prevPageToken properties identify other
       * pages that could be retrieved.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** The *pageToken* parameter identifies a specific page in the result set that should be returned. In
     an API response, the nextPageToken and prevPageToken properties identify other pages that could be
     retrieved.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * The *pageToken* parameter identifies a specific page in the result set that should be
       * returned. In an API response, the nextPageToken and prevPageToken properties identify other
       * pages that could be retrieved.
       */
      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }
    /**
     * Transition a broadcast to a given status.
     *
     * Create a request for the method "liveBroadcasts.transition".
     *
     * This request holds the parameters needed by the youtube server.  After setting any optional
     * parameters, call the {@link Transition#execute()} method to invoke the remote operation.
     *
     * @param broadcastStatus The status to which the broadcast is going to transition.
     * @param id Broadcast to transition.
     * @param part The *part* parameter specifies a comma-separated list of one or more liveBroadcast resource
     *        properties that the API response will include. The part names that you can include in the
     *        parameter value are id, snippet, contentDetails, and status.
     * @return the request
     */
    public Transition transition(java.lang.String broadcastStatus, java.lang.String id, java.util.List<java.lang.String> part) throws java.io.IOException {
      Transition result = new Transition(broadcastStatus, id, part);
      initialize(result);
      return result;
    }

    public class Transition extends YouTubeRequest<com.google.api.services.youtube.model.LiveBroadcast> {

      private static final String REST_PATH = "youtube/v3/liveBroadcasts/transition";

      /**
       * Transition a broadcast to a given status.
       *
       * Create a request for the method "liveBroadcasts.transition".
       *
       * This request holds the parameters needed by the the youtube server.  After setting any optional
       * parameters, call the {@link Transition#execute()} method to invoke the remote operation. <p>
       * {@link
       * Transition#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param broadcastStatus The status to which the broadcast is going to transition.
       * @param id Broadcast to transition.
       * @param part The *part* parameter specifies a comma-separated list of one or more liveBroadcast resource
     *        properties that the API response will include. The part names that you can include in the
     *        parameter value are id, snippet, contentDetails, and status.
       * @since 1.13
       */
      protected Transition(java.lang.String broadcastStatus, java.lang.String id, java.util.List<java.lang.String> part) {
        super(YouTube.this, "POST", REST_PATH, null, com.google.api.services.youtube.model.LiveBroadcast.class);
        this.broadcastStatus = com.google.api.client.util.Preconditions.checkNotNull(broadcastStatus, "Required parameter broadcastStatus must be specified.");
        this.id = com.google.api.client.util.Preconditions.checkNotNull(id, "Required parameter id must be specified.");
        this.part = com.google.api.client.util.Preconditions.checkNotNull(part, "Required parameter part must be specified.");
      }

      @Override
      public Transition set$Xgafv(java.lang.String $Xgafv) {
        return (Transition) super.set$Xgafv($Xgafv);
      }

      @Override
      public Transition setAccessToken(java.lang.String accessToken) {
        return (Transition) super.setAccessToken(accessToken);
      }

      @Override
      public Transition setAlt(java.lang.String alt) {
        return (Transition) super.setAlt(alt);
      }

      @Override
      public Transition setCallback(java.lang.String callback) {
        return (Transition) super.setCallback(callback);
      }

      @Override
      public Transition setFields(java.lang.String fields) {
        return (Transition) super.setFields(fields);
      }

      @Override
      public Transition setKey(java.lang.String key) {
        return (Transition) super.setKey(key);
      }

      @Override
      public Transition setOauthToken(java.lang.String oauthToken) {
        return (Transition) super.setOauthToken(oauthToken);
      }

      @Override
      public Transition setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Transition) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Transition setQuotaUser(java.lang.String quotaUser) {
        return (Transition) super.setQuotaUser(quotaUser);
      }

      @Override
      public Transition setUploadType(java.lang.String uploadType) {
        return (Transition) super.setUploadType(uploadType);
      }

      @Override
      public Transition setUploadProtocol(java.lang.String uploadProtocol) {
        return (Transition) super.setUploadProtocol(uploadProtocol);
      }

      /** The status to which the broadcast is going to transition. */
      @com.google.api.client.util.Key
      private java.lang.String broadcastStatus;

      /** The status to which the broadcast is going to transition.
       */
      public java.lang.String getBroadcastStatus() {
        return broadcastStatus;
      }

      /** The status to which the broadcast is going to transition. */
      public Transition setBroadcastStatus(java.lang.String broadcastStatus) {
        this.broadcastStatus = broadcastStatus;
        return this;
      }

      /** Broadcast to transition. */
      @com.google.api.client.util.Key
      private java.lang.String id;

      /** Broadcast to transition.
       */
      public java.lang.String getId() {
        return id;
      }

      /** Broadcast to transition. */
      public Transition setId(java.lang.String id) {
        this.id = id;
        return this;
      }

      /**
       * The *part* parameter specifies a comma-separated list of one or more liveBroadcast resource
       * properties that the API response will include. The part names that you can include in the
       * parameter value are id, snippet, contentDetails, and status.
       */
      @com.google.api.client.util.Key
      private java.util.List<java.lang.String> part;

      /** The *part* parameter specifies a comma-separated list of one or more liveBroadcast resource
     properties that the API response will include. The part names that you can include in the parameter
     value are id, snippet, contentDetails, and status.
       */
      public java.util.List<java.lang.String> getPart() {
        return part;
      }

      /**
       * The *part* parameter specifies a comma-separated list of one or more liveBroadcast resource
       * properties that the API response will include. The part names that you can include in the
       * parameter value are id, snippet, contentDetails, and status.
       */
      public Transition setPart(java.util.List<java.lang.String> part) {
        this.part = part;
        return this;
      }

      /**
       * *Note:* This parameter is intended exclusively for YouTube content partners. The
       * *onBehalfOfContentOwner* parameter indicates that the request's authorization credentials
       * identify a YouTube CMS user who is acting on behalf of the content owner specified in the
       * parameter value. This parameter is intended for YouTube content partners that own and
       * manage many different YouTube channels. It allows content owners to authenticate once and
       * get access to all their video and channel data, without having to provide authentication
       * credentials for each individual channel. The CMS account that the user authenticates with
       * must be linked to the specified YouTube content owner.
       */
      @com.google.api.client.util.Key
      private java.lang.String onBehalfOfContentOwner;

      /*** Note:* This parameter is intended exclusively for YouTube content partners. The
    * *onBehalfOfContentOwner* parameter indicates that the request's authorization credentials identify
    * a YouTube CMS user who is acting on behalf of the content owner specified in the parameter value.
    * This parameter is intended for YouTube content partners that own and manage many different YouTube
    * channels. It allows content owners to authenticate once and get access to all their video and
    * channel data, without having to provide authentication credentials for each individual channel.
    * The CMS account that the user authenticates with must be linked to the specified YouTube content
    * owner.
    *

       */
      public java.lang.String getOnBehalfOfContentOwner() {
        return onBehalfOfContentOwner;
      }

      /**
       * *Note:* This parameter is intended exclusively for YouTube content partners. The
       * *onBehalfOfContentOwner* parameter indicates that the request's authorization credentials
       * identify a YouTube CMS user who is acting on behalf of the content owner specified in the
       * parameter value. This parameter is intended for YouTube content partners that own and
       * manage many different YouTube channels. It allows content owners to authenticate once and
       * get access to all their video and channel data, without having to provide authentication
       * credentials for each individual channel. The CMS account that the user authenticates with
       * must be linked to the specified YouTube content owner.
       */
      public Transition setOnBehalfOfContentOwner(java.lang.String onBehalfOfContentOwner) {
        this.onBehalfOfContentOwner = onBehalfOfContentOwner;
        return this;
      }

      /**
       * This parameter can only be used in a properly authorized request. *Note:* This parameter is
       * intended exclusively for YouTube content partners. The *onBehalfOfContentOwnerChannel*
       * parameter specifies the YouTube channel ID of the channel to which a video is being added.
       * This parameter is required when a request specifies a value for the onBehalfOfContentOwner
       * parameter, and it can only be used in conjunction with that parameter. In addition, the
       * request must be authorized using a CMS account that is linked to the content owner that the
       * onBehalfOfContentOwner parameter specifies. Finally, the channel that the
       * onBehalfOfContentOwnerChannel parameter value specifies must be linked to the content owner
       * that the onBehalfOfContentOwner parameter specifies. This parameter is intended for YouTube
       * content partners that own and manage many different YouTube channels. It allows content
       * owners to authenticate once and perform actions on behalf of the channel specified in the
       * parameter value, without having to provide authentication credentials for each separate
       * channel.
       */
      @com.google.api.client.util.Key
      private java.lang.String onBehalfOfContentOwnerChannel;

      /** This parameter can only be used in a properly authorized request. *Note:* This parameter is
     intended exclusively for YouTube content partners. The *onBehalfOfContentOwnerChannel* parameter
     specifies the YouTube channel ID of the channel to which a video is being added. This parameter is
     required when a request specifies a value for the onBehalfOfContentOwner parameter, and it can only
     be used in conjunction with that parameter. In addition, the request must be authorized using a CMS
     account that is linked to the content owner that the onBehalfOfContentOwner parameter specifies.
     Finally, the channel that the onBehalfOfContentOwnerChannel parameter value specifies must be
     linked to the content owner that the onBehalfOfContentOwner parameter specifies. This parameter is
     intended for YouTube content partners that own and manage many different YouTube channels. It
     allows content owners to authenticate once and perform actions on behalf of the channel specified
     in the parameter value, without having to provide authentication credentials for each separate
     channel.
       */
      public java.lang.String getOnBehalfOfContentOwnerChannel() {
        return onBehalfOfContentOwnerChannel;
      }

      /**
       * This parameter can only be used in a properly authorized request. *Note:* This parameter is
       * intended exclusively for YouTube content partners. The *onBehalfOfContentOwnerChannel*
       * parameter specifies the YouTube channel ID of the channel to which a video is being added.
       * This parameter is required when a request specifies a value for the onBehalfOfContentOwner
       * parameter, and it can only be used in conjunction with that parameter. In addition, the
       * request must be authorized using a CMS account that is linked to the content owner that the
       * onBehalfOfContentOwner parameter specifies. Finally, the channel that the
       * onBehalfOfContentOwnerChannel parameter value specifies must be linked to the content owner
       * that the onBehalfOfContentOwner parameter specifies. This parameter is intended for YouTube
       * content partners that own and manage many different YouTube channels. It allows content
       * owners to authenticate once and perform actions on behalf of the channel specified in the
       * parameter value, without having to provide authentication credentials for each separate
       * channel.
       */
      public Transition setOnBehalfOfContentOwnerChannel(java.lang.String onBehalfOfContentOwnerChannel) {
        this.onBehalfOfContentOwnerChannel = onBehalfOfContentOwnerChannel;
        return this;
      }

      @Override
      public Transition set(String parameterName, Object value) {
        return (Transition) super.set(parameterName, value);
      }
    }
    /**
     * Updates an existing broadcast for the authenticated user.
     *
     * Create a request for the method "liveBroadcasts.update".
     *
     * This request holds the parameters needed by the youtube server.  After setting any optional
     * parameters, call the {@link Update#execute()} method to invoke the remote operation.
     *
     * @param part The *part* parameter serves two purposes in this operation. It identifies the properties that the
     *        write operation will set as well as the properties that the API response will include. The
     *        part properties that you can include in the parameter value are id, snippet,
     *        contentDetails, and status. Note that this method will override the existing values for
     *        all of the mutable properties that are contained in any parts that the parameter value
     *        specifies. For example, a broadcast's privacy status is defined in the status part. As
     *        such, if your request is updating a private or unlisted broadcast, and the request's part
     *        parameter value includes the status part, the broadcast's privacy setting will be updated
     *        to whatever value the request body specifies. If the request body does not specify a
     *        value, the existing privacy setting will be removed and the broadcast will revert to the
     *        default privacy setting.
     * @param content the {@link com.google.api.services.youtube.model.LiveBroadcast}
     * @return the request
     */
    public Update update(java.util.List<java.lang.String> part, com.google.api.services.youtube.model.LiveBroadcast content) throws java.io.IOException {
      Update result = new Update(part, content);
      initialize(result);
      return result;
    }

    public class Update extends YouTubeRequest<com.google.api.services.youtube.model.LiveBroadcast> {

      private static final String REST_PATH = "youtube/v3/liveBroadcasts";

      /**
       * Updates an existing broadcast for the authenticated user.
       *
       * Create a request for the method "liveBroadcasts.update".
       *
       * This request holds the parameters needed by the the youtube server.  After setting any optional
       * parameters, call the {@link Update#execute()} method to invoke the remote operation. <p> {@link
       * Update#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param part The *part* parameter serves two purposes in this operation. It identifies the properties that the
     *        write operation will set as well as the properties that the API response will include. The
     *        part properties that you can include in the parameter value are id, snippet,
     *        contentDetails, and status. Note that this method will override the existing values for
     *        all of the mutable properties that are contained in any parts that the parameter value
     *        specifies. For example, a broadcast's privacy status is defined in the status part. As
     *        such, if your request is updating a private or unlisted broadcast, and the request's part
     *        parameter value includes the status part, the broadcast's privacy setting will be updated
     *        to whatever value the request body specifies. If the request body does not specify a
     *        value, the existing privacy setting will be removed and the broadcast will revert to the
     *        default privacy setting.
       * @param content the {@link com.google.api.services.youtube.model.LiveBroadcast}
       * @since 1.13
       */
      protected Update(java.util.List<java.lang.String> part, com.google.api.services.youtube.model.LiveBroadcast content) {
        super(YouTube.this, "PUT", REST_PATH, content, com.google.api.services.youtube.model.LiveBroadcast.class);
        this.part = com.google.api.client.util.Preconditions.checkNotNull(part, "Required parameter part must be specified.");
        checkRequiredParameter(content, "content");
        checkRequiredParameter(content.getId(), "LiveBroadcast.getId()");
      }

      @Override
      public Update set$Xgafv(java.lang.String $Xgafv) {
        return (Update) super.set$Xgafv($Xgafv);
      }

      @Override
      public Update setAccessToken(java.lang.String accessToken) {
        return (Update) super.setAccessToken(accessToken);
      }

      @Override
      public Update setAlt(java.lang.String alt) {
        return (Update) super.setAlt(alt);
      }

      @Override
      public Update setCallback(java.lang.String callback) {
        return (Update) super.setCallback(callback);
      }

      @Override
      public Update setFields(java.lang.String fields) {
        return (Update) super.setFields(fields);
      }

      @Override
      public Update setKey(java.lang.String key) {
        return (Update) super.setKey(key);
      }

      @Override
      public Update setOauthToken(java.lang.String oauthToken) {
        return (Update) super.setOauthToken(oauthToken);
      }

      @Override
      public Update setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Update) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Update setQuotaUser(java.lang.String quotaUser) {
        return (Update) super.setQuotaUser(quotaUser);
      }

      @Override
      public Update setUploadType(java.lang.String uploadType) {
        return (Update) super.setUploadType(uploadType);
      }

      @Override
      public Update setUploadProtocol(java.lang.String uploadProtocol) {
        return (Update) super.setUploadProtocol(uploadProtocol);
      }

      /**
       * The *part* parameter serves two purposes in this operation. It identifies the properties
       * that the write operation will set as well as the properties that the API response will
       * include. The part properties that you can include in the parameter value are id, snippet,
       * contentDetails, and status. Note that this method will override the existing values for all
       * of the mutable properties that are contained in any parts that the parameter value
       * specifies. For example, a broadcast's privacy status is defined in the status part. As
       * such, if your request is updating a private or unlisted broadcast, and the request's part
       * parameter value includes the status part, the broadcast's privacy setting will be updated
       * to whatever value the request body specifies. If the request body does not specify a value,
       * the existing privacy setting will be removed and the broadcast will revert to the default
       * privacy setting.
       */
      @com.google.api.client.util.Key
      private java.util.List<java.lang.String> part;

      /** The *part* parameter serves two purposes in this operation. It identifies the properties that the
     write operation will set as well as the properties that the API response will include. The part
     properties that you can include in the parameter value are id, snippet, contentDetails, and status.
     Note that this method will override the existing values for all of the mutable properties that are
     contained in any parts that the parameter value specifies. For example, a broadcast's privacy
     status is defined in the status part. As such, if your request is updating a private or unlisted
     broadcast, and the request's part parameter value includes the status part, the broadcast's privacy
     setting will be updated to whatever value the request body specifies. If the request body does not
     specify a value, the existing privacy setting will be removed and the broadcast will revert to the
     default privacy setting.
       */
      public java.util.List<java.lang.String> getPart() {
        return part;
      }

      /**
       * The *part* parameter serves two purposes in this operation. It identifies the properties
       * that the write operation will set as well as the properties that the API response will
       * include. The part properties that you can include in the parameter value are id, snippet,
       * contentDetails, and status. Note that this method will override the existing values for all
       * of the mutable properties that are contained in any parts that the parameter value
       * specifies. For example, a broadcast's privacy status is defined in the status part. As
       * such, if your request is updating a private or unlisted broadcast, and the request's part
       * parameter value includes the status part, the broadcast's privacy setting will be updated
       * to whatever value the request body specifies. If the request body does not specify a value,
       * the existing privacy setting will be removed and the broadcast will revert to the default
       * privacy setting.
       */
      public Update setPart(java.util.List<java.lang.String> part) {
        this.part = part;
        return this;
      }

      /**
       * *Note:* This parameter is intended exclusively for YouTube content partners. The
       * *onBehalfOfContentOwner* parameter indicates that the request's authorization credentials
       * identify a YouTube CMS user who is acting on behalf of the content owner specified in the
       * parameter value. This parameter is intended for YouTube content partners that own and
       * manage many different YouTube channels. It allows content owners to authenticate once and
       * get access to all their video and channel data, without having to provide authentication
       * credentials for each individual channel. The CMS account that the user authenticates with
       * must be linked to the specified YouTube content owner.
       */
      @com.google.api.client.util.Key
      private java.lang.String onBehalfOfContentOwner;

      /*** Note:* This parameter is intended exclusively for YouTube content partners. The
    * *onBehalfOfContentOwner* parameter indicates that the request's authorization credentials identify
    * a YouTube CMS user who is acting on behalf of the content owner specified in the parameter value.
    * This parameter is intended for YouTube content partners that own and manage many different YouTube
    * channels. It allows content owners to authenticate once and get access to all their video and
    * channel data, without having to provide authentication credentials for each individual channel.
    * The CMS account that the user authenticates with must be linked to the specified YouTube content
    * owner.
    *

       */
      public java.lang.String getOnBehalfOfContentOwner() {
        return onBehalfOfContentOwner;
      }

      /**
       * *Note:* This parameter is intended exclusively for YouTube content partners. The
       * *onBehalfOfContentOwner* parameter indicates that the request's authorization credentials
       * identify a YouTube CMS user who is acting on behalf of the content owner specified in the
       * parameter value. This parameter is intended for YouTube content partners that own and
       * manage many different YouTube channels. It allows content owners to authenticate once and
       * get access to all their video and channel data, without having to provide authentication
       * credentials for each individual channel. The CMS account that the user authenticates with
       * must be linked to the specified YouTube content owner.
       */
      public Update setOnBehalfOfContentOwner(java.lang.String onBehalfOfContentOwner) {
        this.onBehalfOfContentOwner = onBehalfOfContentOwner;
        return this;
      }

      /**
       * This parameter can only be used in a properly authorized request. *Note:* This parameter is
       * intended exclusively for YouTube content partners. The *onBehalfOfContentOwnerChannel*
       * parameter specifies the YouTube channel ID of the channel to which a video is being added.
       * This parameter is required when a request specifies a value for the onBehalfOfContentOwner
       * parameter, and it can only be used in conjunction with that parameter. In addition, the
       * request must be authorized using a CMS account that is linked to the content owner that the
       * onBehalfOfContentOwner parameter specifies. Finally, the channel that the
       * onBehalfOfContentOwnerChannel parameter value specifies must be linked to the content owner
       * that the onBehalfOfContentOwner parameter specifies. This parameter is intended for YouTube
       * content partners that own and manage many different YouTube channels. It allows content
       * owners to authenticate once and perform actions on behalf of the channel specified in the
       * parameter value, without having to provide authentication credentials for each separate
       * channel.
       */
      @com.google.api.client.util.Key
      private java.lang.String onBehalfOfContentOwnerChannel;

      /** This parameter can only be used in a properly authorized request. *Note:* This parameter is
     intended exclusively for YouTube content partners. The *onBehalfOfContentOwnerChannel* parameter
     specifies the YouTube channel ID of the channel to which a video is being added. This parameter is
     required when a request specifies a value for the onBehalfOfContentOwner parameter, and it can only
     be used in conjunction with that parameter. In addition, the request must be authorized using a CMS
     account that is linked to the content owner that the onBehalfOfContentOwner parameter specifies.
     Finally, the channel that the onBehalfOfContentOwnerChannel parameter value specifies must be
     linked to the content owner that the onBehalfOfContentOwner parameter specifies. This parameter is
     intended for YouTube content partners that own and manage many different YouTube channels. It
     allows content owners to authenticate once and perform actions on behalf of the channel specified
     in the parameter value, without having to provide authentication credentials for each separate
     channel.
       */
      public java.lang.String getOnBehalfOfContentOwnerChannel() {
        return onBehalfOfContentOwnerChannel;
      }

      /**
       * This parameter can only be used in a properly authorized request. *Note:* This parameter is
       * intended exclusively for YouTube content partners. The *onBehalfOfContentOwnerChannel*
       * parameter specifies the YouTube channel ID of the channel to which a video is being added.
       * This parameter is required when a request specifies a value for the onBehalfOfContentOwner
       * parameter, and it can only be used in conjunction with that parameter. In addition, the
       * request must be authorized using a CMS account that is linked to the content owner that the
       * onBehalfOfContentOwner parameter specifies. Finally, the channel that the
       * onBehalfOfContentOwnerChannel parameter value specifies must be linked to the content owner
       * that the onBehalfOfContentOwner parameter specifies. This parameter is intended for YouTube
       * content partners that own and manage many different YouTube channels. It allows content
       * owners to authenticate once and perform actions on behalf of the channel specified in the
       * parameter value, without having to provide authentication credentials for each separate
       * channel.
       */
      public Update setOnBehalfOfContentOwnerChannel(java.lang.String onBehalfOfContentOwnerChannel) {
        this.onBehalfOfContentOwnerChannel = onBehalfOfContentOwnerChannel;
        return this;
      }

      @Override
      public Update set(String parameterName, Object value) {
        return (Update) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the LiveChatBans collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code YouTube youtube = new YouTube(...);}
   *   {@code YouTube.LiveChatBans.List request = youtube.liveChatBans().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public LiveChatBans liveChatBans() {
    return new LiveChatBans();
  }

  /**
   * The "liveChatBans" collection of methods.
   */
  public class LiveChatBans {

    /**
     * Deletes a chat ban.
     *
     * Create a request for the method "liveChatBans.delete".
     *
     * This request holds the parameters needed by the youtube server.  After setting any optional
     * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
     *
     * @param id
     * @return the request
     */
    public Delete delete(java.lang.String id) throws java.io.IOException {
      Delete result = new Delete(id);
      initialize(result);
      return result;
    }

    public class Delete extends YouTubeRequest<Void> {

      private static final String REST_PATH = "youtube/v3/liveChat/bans";

      /**
       * Deletes a chat ban.
       *
       * Create a request for the method "liveChatBans.delete".
       *
       * This request holds the parameters needed by the the youtube server.  After setting any optional
       * parameters, call the {@link Delete#execute()} method to invoke the remote operation. <p> {@link
       * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param id
       * @since 1.13
       */
      protected Delete(java.lang.String id) {
        super(YouTube.this, "DELETE", REST_PATH, null, Void.class);
        this.id = com.google.api.client.util.Preconditions.checkNotNull(id, "Required parameter id must be specified.");
      }

      @Override
      public Delete set$Xgafv(java.lang.String $Xgafv) {
        return (Delete) super.set$Xgafv($Xgafv);
      }

      @Override
      public Delete setAccessToken(java.lang.String accessToken) {
        return (Delete) super.setAccessToken(accessToken);
      }

      @Override
      public Delete setAlt(java.lang.String alt) {
        return (Delete) super.setAlt(alt);
      }

      @Override
      public Delete setCallback(java.lang.String callback) {
        return (Delete) super.setCallback(callback);
      }

      @Override
      public Delete setFields(java.lang.String fields) {
        return (Delete) super.setFields(fields);
      }

      @Override
      public Delete setKey(java.lang.String key) {
        return (Delete) super.setKey(key);
      }

      @Override
      public Delete setOauthToken(java.lang.String oauthToken) {
        return (Delete) super.setOauthToken(oauthToken);
      }

      @Override
      public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Delete) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Delete setQuotaUser(java.lang.String quotaUser) {
        return (Delete) super.setQuotaUser(quotaUser);
      }

      @Override
      public Delete setUploadType(java.lang.String uploadType) {
        return (Delete) super.setUploadType(uploadType);
      }

      @Override
      public Delete setUploadProtocol(java.lang.String uploadProtocol) {
        return (Delete) super.setUploadProtocol(uploadProtocol);
      }

      @com.google.api.client.util.Key
      private java.lang.String id;

      /**

       */
      public java.lang.String getId() {
        return id;
      }

      public Delete setId(java.lang.String id) {
        this.id = id;
        return this;
      }

      @Override
      public Delete set(String parameterName, Object value) {
        return (Delete) super.set(parameterName, value);
      }
    }
    /**
     * Inserts a new resource into this collection.
     *
     * Create a request for the method "liveChatBans.insert".
     *
     * This request holds the parameters needed by the youtube server.  After setting any optional
     * parameters, call the {@link Insert#execute()} method to invoke the remote operation.
     *
     * @param part The *part* parameter serves two purposes in this operation. It identifies the properties that the
     *        write operation will set as well as the properties that the API response returns. Set the
     *        parameter value to snippet.
     * @param content the {@link com.google.api.services.youtube.model.LiveChatBan}
     * @return the request
     */
    public Insert insert(java.util.List<java.lang.String> part, com.google.api.services.youtube.model.LiveChatBan content) throws java.io.IOException {
      Insert result = new Insert(part, content);
      initialize(result);
      return result;
    }

    public class Insert extends YouTubeRequest<com.google.api.services.youtube.model.LiveChatBan> {

      private static final String REST_PATH = "youtube/v3/liveChat/bans";

      /**
       * Inserts a new resource into this collection.
       *
       * Create a request for the method "liveChatBans.insert".
       *
       * This request holds the parameters needed by the the youtube server.  After setting any optional
       * parameters, call the {@link Insert#execute()} method to invoke the remote operation. <p> {@link
       * Insert#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param part The *part* parameter serves two purposes in this operation. It identifies the properties that the
     *        write operation will set as well as the properties that the API response returns. Set the
     *        parameter value to snippet.
       * @param content the {@link com.google.api.services.youtube.model.LiveChatBan}
       * @since 1.13
       */
      protected Insert(java.util.List<java.lang.String> part, com.google.api.services.youtube.model.LiveChatBan content) {
        super(YouTube.this, "POST", REST_PATH, content, com.google.api.services.youtube.model.LiveChatBan.class);
        this.part = com.google.api.client.util.Preconditions.checkNotNull(part, "Required parameter part must be specified.");
      }

      @Override
      public Insert set$Xgafv(java.lang.String $Xgafv) {
        return (Insert) super.set$Xgafv($Xgafv);
      }

      @Override
      public Insert setAccessToken(java.lang.String accessToken) {
        return (Insert) super.setAccessToken(accessToken);
      }

      @Override
      public Insert setAlt(java.lang.String alt) {
        return (Insert) super.setAlt(alt);
      }

      @Override
      public Insert setCallback(java.lang.String callback) {
        return (Insert) super.setCallback(callback);
      }

      @Override
      public Insert setFields(java.lang.String fields) {
        return (Insert) super.setFields(fields);
      }

      @Override
      public Insert setKey(java.lang.String key) {
        return (Insert) super.setKey(key);
      }

      @Override
      public Insert setOauthToken(java.lang.String oauthToken) {
        return (Insert) super.setOauthToken(oauthToken);
      }

      @Override
      public Insert setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Insert) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Insert setQuotaUser(java.lang.String quotaUser) {
        return (Insert) super.setQuotaUser(quotaUser);
      }

      @Override
      public Insert setUploadType(java.lang.String uploadType) {
        return (Insert) super.setUploadType(uploadType);
      }

      @Override
      public Insert setUploadProtocol(java.lang.String uploadProtocol) {
        return (Insert) super.setUploadProtocol(uploadProtocol);
      }

      /**
       * The *part* parameter serves two purposes in this operation. It identifies the properties
       * that the write operation will set as well as the properties that the API response returns.
       * Set the parameter value to snippet.
       */
      @com.google.api.client.util.Key
      private java.util.List<java.lang.String> part;

      /** The *part* parameter serves two purposes in this operation. It identifies the properties that the
     write operation will set as well as the properties that the API response returns. Set the parameter
     value to snippet.
       */
      public java.util.List<java.lang.String> getPart() {
        return part;
      }

      /**
       * The *part* parameter serves two purposes in this operation. It identifies the properties
       * that the write operation will set as well as the properties that the API response returns.
       * Set the parameter value to snippet.
       */
      public Insert setPart(java.util.List<java.lang.String> part) {
        this.part = part;
        return this;
      }

      @Override
      public Insert set(String parameterName, Object value) {
        return (Insert) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the LiveChatMessages collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code YouTube youtube = new YouTube(...);}
   *   {@code YouTube.LiveChatMessages.List request = youtube.liveChatMessages().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public LiveChatMessages liveChatMessages() {
    return new LiveChatMessages();
  }

  /**
   * The "liveChatMessages" collection of methods.
   */
  public class LiveChatMessages {

    /**
     * Deletes a chat message.
     *
     * Create a request for the method "liveChatMessages.delete".
     *
     * This request holds the parameters needed by the youtube server.  After setting any optional
     * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
     *
     * @param id
     * @return the request
     */
    public Delete delete(java.lang.String id) throws java.io.IOException {
      Delete result = new Delete(id);
      initialize(result);
      return result;
    }

    public class Delete extends YouTubeRequest<Void> {

      private static final String REST_PATH = "youtube/v3/liveChat/messages";

      /**
       * Deletes a chat message.
       *
       * Create a request for the method "liveChatMessages.delete".
       *
       * This request holds the parameters needed by the the youtube server.  After setting any optional
       * parameters, call the {@link Delete#execute()} method to invoke the remote operation. <p> {@link
       * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param id
       * @since 1.13
       */
      protected Delete(java.lang.String id) {
        super(YouTube.this, "DELETE", REST_PATH, null, Void.class);
        this.id = com.google.api.client.util.Preconditions.checkNotNull(id, "Required parameter id must be specified.");
      }

      @Override
      public Delete set$Xgafv(java.lang.String $Xgafv) {
        return (Delete) super.set$Xgafv($Xgafv);
      }

      @Override
      public Delete setAccessToken(java.lang.String accessToken) {
        return (Delete) super.setAccessToken(accessToken);
      }

      @Override
      public Delete setAlt(java.lang.String alt) {
        return (Delete) super.setAlt(alt);
      }

      @Override
      public Delete setCallback(java.lang.String callback) {
        return (Delete) super.setCallback(callback);
      }

      @Override
      public Delete setFields(java.lang.String fields) {
        return (Delete) super.setFields(fields);
      }

      @Override
      public Delete setKey(java.lang.String key) {
        return (Delete) super.setKey(key);
      }

      @Override
      public Delete setOauthToken(java.lang.String oauthToken) {
        return (Delete) super.setOauthToken(oauthToken);
      }

      @Override
      public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Delete) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Delete setQuotaUser(java.lang.String quotaUser) {
        return (Delete) super.setQuotaUser(quotaUser);
      }

      @Override
      public Delete setUploadType(java.lang.String uploadType) {
        return (Delete) super.setUploadType(uploadType);
      }

      @Override
      public Delete setUploadProtocol(java.lang.String uploadProtocol) {
        return (Delete) super.setUploadProtocol(uploadProtocol);
      }

      @com.google.api.client.util.Key
      private java.lang.String id;

      /**

       */
      public java.lang.String getId() {
        return id;
      }

      public Delete setId(java.lang.String id) {
        this.id = id;
        return this;
      }

      @Override
      public Delete set(String parameterName, Object value) {
        return (Delete) super.set(parameterName, value);
      }
    }
    /**
     * Inserts a new resource into this collection.
     *
     * Create a request for the method "liveChatMessages.insert".
     *
     * This request holds the parameters needed by the youtube server.  After setting any optional
     * parameters, call the {@link Insert#execute()} method to invoke the remote operation.
     *
     * @param part The *part* parameter serves two purposes. It identifies the properties that the write operation will
     *        set as well as the properties that the API response will include. Set the parameter value
     *        to snippet.
     * @param content the {@link com.google.api.services.youtube.model.LiveChatMessage}
     * @return the request
     */
    public Insert insert(java.util.List<java.lang.String> part, com.google.api.services.youtube.model.LiveChatMessage content) throws java.io.IOException {
      Insert result = new Insert(part, content);
      initialize(result);
      return result;
    }

    public class Insert extends YouTubeRequest<com.google.api.services.youtube.model.LiveChatMessage> {

      private static final String REST_PATH = "youtube/v3/liveChat/messages";

      /**
       * Inserts a new resource into this collection.
       *
       * Create a request for the method "liveChatMessages.insert".
       *
       * This request holds the parameters needed by the the youtube server.  After setting any optional
       * parameters, call the {@link Insert#execute()} method to invoke the remote operation. <p> {@link
       * Insert#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param part The *part* parameter serves two purposes. It identifies the properties that the write operation will
     *        set as well as the properties that the API response will include. Set the parameter value
     *        to snippet.
       * @param content the {@link com.google.api.services.youtube.model.LiveChatMessage}
       * @since 1.13
       */
      protected Insert(java.util.List<java.lang.String> part, com.google.api.services.youtube.model.LiveChatMessage content) {
        super(YouTube.this, "POST", REST_PATH, content, com.google.api.services.youtube.model.LiveChatMessage.class);
        this.part = com.google.api.client.util.Preconditions.checkNotNull(part, "Required parameter part must be specified.");
      }

      @Override
      public Insert set$Xgafv(java.lang.String $Xgafv) {
        return (Insert) super.set$Xgafv($Xgafv);
      }

      @Override
      public Insert setAccessToken(java.lang.String accessToken) {
        return (Insert) super.setAccessToken(accessToken);
      }

      @Override
      public Insert setAlt(java.lang.String alt) {
        return (Insert) super.setAlt(alt);
      }

      @Override
      public Insert setCallback(java.lang.String callback) {
        return (Insert) super.setCallback(callback);
      }

      @Override
      public Insert setFields(java.lang.String fields) {
        return (Insert) super.setFields(fields);
      }

      @Override
      public Insert setKey(java.lang.String key) {
        return (Insert) super.setKey(key);
      }

      @Override
      public Insert setOauthToken(java.lang.String oauthToken) {
        return (Insert) super.setOauthToken(oauthToken);
      }

      @Override
      public Insert setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Insert) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Insert setQuotaUser(java.lang.String quotaUser) {
        return (Insert) super.setQuotaUser(quotaUser);
      }

      @Override
      public Insert setUploadType(java.lang.String uploadType) {
        return (Insert) super.setUploadType(uploadType);
      }

      @Override
      public Insert setUploadProtocol(java.lang.String uploadProtocol) {
        return (Insert) super.setUploadProtocol(uploadProtocol);
      }

      /**
       * The *part* parameter serves two purposes. It identifies the properties that the write
       * operation will set as well as the properties that the API response will include. Set the
       * parameter value to snippet.
       */
      @com.google.api.client.util.Key
      private java.util.List<java.lang.String> part;

      /** The *part* parameter serves two purposes. It identifies the properties that the write operation
     will set as well as the properties that the API response will include. Set the parameter value to
     snippet.
       */
      public java.util.List<java.lang.String> getPart() {
        return part;
      }

      /**
       * The *part* parameter serves two purposes. It identifies the properties that the write
       * operation will set as well as the properties that the API response will include. Set the
       * parameter value to snippet.
       */
      public Insert setPart(java.util.List<java.lang.String> part) {
        this.part = part;
        return this;
      }

      @Override
      public Insert set(String parameterName, Object value) {
        return (Insert) super.set(parameterName, value);
      }
    }
    /**
     * Retrieves a list of resources, possibly filtered.
     *
     * Create a request for the method "liveChatMessages.list".
     *
     * This request holds the parameters needed by the youtube server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param liveChatId The id of the live chat for which comments should be returned.
     * @param part The *part* parameter specifies the liveChatComment resource parts that the API response will
     *        include. Supported values are id and snippet.
     * @return the request
     */
    public List list(java.lang.String liveChatId, java.util.List<java.lang.String> part) throws java.io.IOException {
      List result = new List(liveChatId, part);
      initialize(result);
      return result;
    }

    public class List extends YouTubeRequest<com.google.api.services.youtube.model.LiveChatMessageListResponse> {

      private static final String REST_PATH = "youtube/v3/liveChat/messages";

      /**
       * Retrieves a list of resources, possibly filtered.
       *
       * Create a request for the method "liveChatMessages.list".
       *
       * This request holds the parameters needed by the the youtube server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param liveChatId The id of the live chat for which comments should be returned.
       * @param part The *part* parameter specifies the liveChatComment resource parts that the API response will
     *        include. Supported values are id and snippet.
       * @since 1.13
       */
      protected List(java.lang.String liveChatId, java.util.List<java.lang.String> part) {
        super(YouTube.this, "GET", REST_PATH, null, com.google.api.services.youtube.model.LiveChatMessageListResponse.class);
        this.liveChatId = com.google.api.client.util.Preconditions.checkNotNull(liveChatId, "Required parameter liveChatId must be specified.");
        this.part = com.google.api.client.util.Preconditions.checkNotNull(part, "Required parameter part must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List set$Xgafv(java.lang.String $Xgafv) {
        return (List) super.set$Xgafv($Xgafv);
      }

      @Override
      public List setAccessToken(java.lang.String accessToken) {
        return (List) super.setAccessToken(accessToken);
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setCallback(java.lang.String callback) {
        return (List) super.setCallback(callback);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUploadType(java.lang.String uploadType) {
        return (List) super.setUploadType(uploadType);
      }

      @Override
      public List setUploadProtocol(java.lang.String uploadProtocol) {
        return (List) super.setUploadProtocol(uploadProtocol);
      }

      /** The id of the live chat for which comments should be returned. */
      @com.google.api.client.util.Key
      private java.lang.String liveChatId;

      /** The id of the live chat for which comments should be returned.
       */
      public java.lang.String getLiveChatId() {
        return liveChatId;
      }

      /** The id of the live chat for which comments should be returned. */
      public List setLiveChatId(java.lang.String liveChatId) {
        this.liveChatId = liveChatId;
        return this;
      }

      /**
       * The *part* parameter specifies the liveChatComment resource parts that the API response
       * will include. Supported values are id and snippet.
       */
      @com.google.api.client.util.Key
      private java.util.List<java.lang.String> part;

      /** The *part* parameter specifies the liveChatComment resource parts that the API response will
     include. Supported values are id and snippet.
       */
      public java.util.List<java.lang.String> getPart() {
        return part;
      }

      /**
       * The *part* parameter specifies the liveChatComment resource parts that the API response
       * will include. Supported values are id and snippet.
       */
      public List setPart(java.util.List<java.lang.String> part) {
        this.part = part;
        return this;
      }

      /** Specifies the localization language in which the system messages should be returned. */
      @com.google.api.client.util.Key
      private java.lang.String hl;

      /** Specifies the localization language in which the system messages should be returned.
       */
      public java.lang.String getHl() {
        return hl;
      }

      /** Specifies the localization language in which the system messages should be returned. */
      public List setHl(java.lang.String hl) {
        this.hl = hl;
        return this;
      }

      /**
       * The *maxResults* parameter specifies the maximum number of items that should be returned in
       * the result set.
       */
      @com.google.api.client.util.Key
      private java.lang.Long maxResults;

      /** The *maxResults* parameter specifies the maximum number of items that should be returned in the
     result set. [default: 500] [minimum: 200] [maximum: 2000]
       */
      public java.lang.Long getMaxResults() {
        return maxResults;
      }

      /**
       * The *maxResults* parameter specifies the maximum number of items that should be returned in
       * the result set.
       */
      public List setMaxResults(java.lang.Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      /**
       * The *pageToken* parameter identifies a specific page in the result set that should be
       * returned. In an API response, the nextPageToken property identify other pages that could be
       * retrieved.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** The *pageToken* parameter identifies a specific page in the result set that should be returned. In
     an API response, the nextPageToken property identify other pages that could be retrieved.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * The *pageToken* parameter identifies a specific page in the result set that should be
       * returned. In an API response, the nextPageToken property identify other pages that could be
       * retrieved.
       */
      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      /** Specifies the size of the profile image that should be returned for each user. */
      @com.google.api.client.util.Key
      private java.lang.Long profileImageSize;

      /** Specifies the size of the profile image that should be returned for each user.

     [minimum: 16] [maximum: 720]
       */
      public java.lang.Long getProfileImageSize() {
        return profileImageSize;
      }

      /** Specifies the size of the profile image that should be returned for each user. */
      public List setProfileImageSize(java.lang.Long profileImageSize) {
        this.profileImageSize = profileImageSize;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the LiveChatModerators collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code YouTube youtube = new YouTube(...);}
   *   {@code YouTube.LiveChatModerators.List request = youtube.liveChatModerators().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public LiveChatModerators liveChatModerators() {
    return new LiveChatModerators();
  }

  /**
   * The "liveChatModerators" collection of methods.
   */
  public class LiveChatModerators {

    /**
     * Deletes a chat moderator.
     *
     * Create a request for the method "liveChatModerators.delete".
     *
     * This request holds the parameters needed by the youtube server.  After setting any optional
     * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
     *
     * @param id
     * @return the request
     */
    public Delete delete(java.lang.String id) throws java.io.IOException {
      Delete result = new Delete(id);
      initialize(result);
      return result;
    }

    public class Delete extends YouTubeRequest<Void> {

      private static final String REST_PATH = "youtube/v3/liveChat/moderators";

      /**
       * Deletes a chat moderator.
       *
       * Create a request for the method "liveChatModerators.delete".
       *
       * This request holds the parameters needed by the the youtube server.  After setting any optional
       * parameters, call the {@link Delete#execute()} method to invoke the remote operation. <p> {@link
       * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param id
       * @since 1.13
       */
      protected Delete(java.lang.String id) {
        super(YouTube.this, "DELETE", REST_PATH, null, Void.class);
        this.id = com.google.api.client.util.Preconditions.checkNotNull(id, "Required parameter id must be specified.");
      }

      @Override
      public Delete set$Xgafv(java.lang.String $Xgafv) {
        return (Delete) super.set$Xgafv($Xgafv);
      }

      @Override
      public Delete setAccessToken(java.lang.String accessToken) {
        return (Delete) super.setAccessToken(accessToken);
      }

      @Override
      public Delete setAlt(java.lang.String alt) {
        return (Delete) super.setAlt(alt);
      }

      @Override
      public Delete setCallback(java.lang.String callback) {
        return (Delete) super.setCallback(callback);
      }

      @Override
      public Delete setFields(java.lang.String fields) {
        return (Delete) super.setFields(fields);
      }

      @Override
      public Delete setKey(java.lang.String key) {
        return (Delete) super.setKey(key);
      }

      @Override
      public Delete setOauthToken(java.lang.String oauthToken) {
        return (Delete) super.setOauthToken(oauthToken);
      }

      @Override
      public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Delete) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Delete setQuotaUser(java.lang.String quotaUser) {
        return (Delete) super.setQuotaUser(quotaUser);
      }

      @Override
      public Delete setUploadType(java.lang.String uploadType) {
        return (Delete) super.setUploadType(uploadType);
      }

      @Override
      public Delete setUploadProtocol(java.lang.String uploadProtocol) {
        return (Delete) super.setUploadProtocol(uploadProtocol);
      }

      @com.google.api.client.util.Key
      private java.lang.String id;

      /**

       */
      public java.lang.String getId() {
        return id;
      }

      public Delete setId(java.lang.String id) {
        this.id = id;
        return this;
      }

      @Override
      public Delete set(String parameterName, Object value) {
        return (Delete) super.set(parameterName, value);
      }
    }
    /**
     * Inserts a new resource into this collection.
     *
     * Create a request for the method "liveChatModerators.insert".
     *
     * This request holds the parameters needed by the youtube server.  After setting any optional
     * parameters, call the {@link Insert#execute()} method to invoke the remote operation.
     *
     * @param part The *part* parameter serves two purposes in this operation. It identifies the properties that the
     *        write operation will set as well as the properties that the API response returns. Set the
     *        parameter value to snippet.
     * @param content the {@link com.google.api.services.youtube.model.LiveChatModerator}
     * @return the request
     */
    public Insert insert(java.util.List<java.lang.String> part, com.google.api.services.youtube.model.LiveChatModerator content) throws java.io.IOException {
      Insert result = new Insert(part, content);
      initialize(result);
      return result;
    }

    public class Insert extends YouTubeRequest<com.google.api.services.youtube.model.LiveChatModerator> {

      private static final String REST_PATH = "youtube/v3/liveChat/moderators";

      /**
       * Inserts a new resource into this collection.
       *
       * Create a request for the method "liveChatModerators.insert".
       *
       * This request holds the parameters needed by the the youtube server.  After setting any optional
       * parameters, call the {@link Insert#execute()} method to invoke the remote operation. <p> {@link
       * Insert#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param part The *part* parameter serves two purposes in this operation. It identifies the properties that the
     *        write operation will set as well as the properties that the API response returns. Set the
     *        parameter value to snippet.
       * @param content the {@link com.google.api.services.youtube.model.LiveChatModerator}
       * @since 1.13
       */
      protected Insert(java.util.List<java.lang.String> part, com.google.api.services.youtube.model.LiveChatModerator content) {
        super(YouTube.this, "POST", REST_PATH, content, com.google.api.services.youtube.model.LiveChatModerator.class);
        this.part = com.google.api.client.util.Preconditions.checkNotNull(part, "Required parameter part must be specified.");
      }

      @Override
      public Insert set$Xgafv(java.lang.String $Xgafv) {
        return (Insert) super.set$Xgafv($Xgafv);
      }

      @Override
      public Insert setAccessToken(java.lang.String accessToken) {
        return (Insert) super.setAccessToken(accessToken);
      }

      @Override
      public Insert setAlt(java.lang.String alt) {
        return (Insert) super.setAlt(alt);
      }

      @Override
      public Insert setCallback(java.lang.String callback) {
        return (Insert) super.setCallback(callback);
      }

      @Override
      public Insert setFields(java.lang.String fields) {
        return (Insert) super.setFields(fields);
      }

      @Override
      public Insert setKey(java.lang.String key) {
        return (Insert) super.setKey(key);
      }

      @Override
      public Insert setOauthToken(java.lang.String oauthToken) {
        return (Insert) super.setOauthToken(oauthToken);
      }

      @Override
      public Insert setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Insert) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Insert setQuotaUser(java.lang.String quotaUser) {
        return (Insert) super.setQuotaUser(quotaUser);
      }

      @Override
      public Insert setUploadType(java.lang.String uploadType) {
        return (Insert) super.setUploadType(uploadType);
      }

      @Override
      public Insert setUploadProtocol(java.lang.String uploadProtocol) {
        return (Insert) super.setUploadProtocol(uploadProtocol);
      }

      /**
       * The *part* parameter serves two purposes in this operation. It identifies the properties
       * that the write operation will set as well as the properties that the API response returns.
       * Set the parameter value to snippet.
       */
      @com.google.api.client.util.Key
      private java.util.List<java.lang.String> part;

      /** The *part* parameter serves two purposes in this operation. It identifies the properties that the
     write operation will set as well as the properties that the API response returns. Set the parameter
     value to snippet.
       */
      public java.util.List<java.lang.String> getPart() {
        return part;
      }

      /**
       * The *part* parameter serves two purposes in this operation. It identifies the properties
       * that the write operation will set as well as the properties that the API response returns.
       * Set the parameter value to snippet.
       */
      public Insert setPart(java.util.List<java.lang.String> part) {
        this.part = part;
        return this;
      }

      @Override
      public Insert set(String parameterName, Object value) {
        return (Insert) super.set(parameterName, value);
      }
    }
    /**
     * Retrieves a list of resources, possibly filtered.
     *
     * Create a request for the method "liveChatModerators.list".
     *
     * This request holds the parameters needed by the youtube server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param liveChatId The id of the live chat for which moderators should be returned.
     * @param part The *part* parameter specifies the liveChatModerator resource parts that the API response will
     *        include. Supported values are id and snippet.
     * @return the request
     */
    public List list(java.lang.String liveChatId, java.util.List<java.lang.String> part) throws java.io.IOException {
      List result = new List(liveChatId, part);
      initialize(result);
      return result;
    }

    public class List extends YouTubeRequest<com.google.api.services.youtube.model.LiveChatModeratorListResponse> {

      private static final String REST_PATH = "youtube/v3/liveChat/moderators";

      /**
       * Retrieves a list of resources, possibly filtered.
       *
       * Create a request for the method "liveChatModerators.list".
       *
       * This request holds the parameters needed by the the youtube server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param liveChatId The id of the live chat for which moderators should be returned.
       * @param part The *part* parameter specifies the liveChatModerator resource parts that the API response will
     *        include. Supported values are id and snippet.
       * @since 1.13
       */
      protected List(java.lang.String liveChatId, java.util.List<java.lang.String> part) {
        super(YouTube.this, "GET", REST_PATH, null, com.google.api.services.youtube.model.LiveChatModeratorListResponse.class);
        this.liveChatId = com.google.api.client.util.Preconditions.checkNotNull(liveChatId, "Required parameter liveChatId must be specified.");
        this.part = com.google.api.client.util.Preconditions.checkNotNull(part, "Required parameter part must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List set$Xgafv(java.lang.String $Xgafv) {
        return (List) super.set$Xgafv($Xgafv);
      }

      @Override
      public List setAccessToken(java.lang.String accessToken) {
        return (List) super.setAccessToken(accessToken);
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setCallback(java.lang.String callback) {
        return (List) super.setCallback(callback);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUploadType(java.lang.String uploadType) {
        return (List) super.setUploadType(uploadType);
      }

      @Override
      public List setUploadProtocol(java.lang.String uploadProtocol) {
        return (List) super.setUploadProtocol(uploadProtocol);
      }

      /** The id of the live chat for which moderators should be returned. */
      @com.google.api.client.util.Key
      private java.lang.String liveChatId;

      /** The id of the live chat for which moderators should be returned.
       */
      public java.lang.String getLiveChatId() {
        return liveChatId;
      }

      /** The id of the live chat for which moderators should be returned. */
      public List setLiveChatId(java.lang.String liveChatId) {
        this.liveChatId = liveChatId;
        return this;
      }

      /**
       * The *part* parameter specifies the liveChatModerator resource parts that the API response
       * will include. Supported values are id and snippet.
       */
      @com.google.api.client.util.Key
      private java.util.List<java.lang.String> part;

      /** The *part* parameter specifies the liveChatModerator resource parts that the API response will
     include. Supported values are id and snippet.
       */
      public java.util.List<java.lang.String> getPart() {
        return part;
      }

      /**
       * The *part* parameter specifies the liveChatModerator resource parts that the API response
       * will include. Supported values are id and snippet.
       */
      public List setPart(java.util.List<java.lang.String> part) {
        this.part = part;
        return this;
      }

      /**
       * The *maxResults* parameter specifies the maximum number of items that should be returned in
       * the result set.
       */
      @com.google.api.client.util.Key
      private java.lang.Long maxResults;

      /** The *maxResults* parameter specifies the maximum number of items that should be returned in the
     result set. [default: 5] [minimum: 0] [maximum: 50]
       */
      public java.lang.Long getMaxResults() {
        return maxResults;
      }

      /**
       * The *maxResults* parameter specifies the maximum number of items that should be returned in
       * the result set.
       */
      public List setMaxResults(java.lang.Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      /**
       * The *pageToken* parameter identifies a specific page in the result set that should be
       * returned. In an API response, the nextPageToken and prevPageToken properties identify other
       * pages that could be retrieved.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** The *pageToken* parameter identifies a specific page in the result set that should be returned. In
     an API response, the nextPageToken and prevPageToken properties identify other pages that could be
     retrieved.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * The *pageToken* parameter identifies a specific page in the result set that should be
       * returned. In an API response, the nextPageToken and prevPageToken properties identify other
       * pages that could be retrieved.
       */
      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the LiveStreams collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code YouTube youtube = new YouTube(...);}
   *   {@code YouTube.LiveStreams.List request = youtube.liveStreams().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public LiveStreams liveStreams() {
    return new LiveStreams();
  }

  /**
   * The "liveStreams" collection of methods.
   */
  public class LiveStreams {

    /**
     * Deletes an existing stream for the authenticated user.
     *
     * Create a request for the method "liveStreams.delete".
     *
     * This request holds the parameters needed by the youtube server.  After setting any optional
     * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
     *
     * @param id
     * @return the request
     */
    public Delete delete(java.lang.String id) throws java.io.IOException {
      Delete result = new Delete(id);
      initialize(result);
      return result;
    }

    public class Delete extends YouTubeRequest<Void> {

      private static final String REST_PATH = "youtube/v3/liveStreams";

      /**
       * Deletes an existing stream for the authenticated user.
       *
       * Create a request for the method "liveStreams.delete".
       *
       * This request holds the parameters needed by the the youtube server.  After setting any optional
       * parameters, call the {@link Delete#execute()} method to invoke the remote operation. <p> {@link
       * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param id
       * @since 1.13
       */
      protected Delete(java.lang.String id) {
        super(YouTube.this, "DELETE", REST_PATH, null, Void.class);
        this.id = com.google.api.client.util.Preconditions.checkNotNull(id, "Required parameter id must be specified.");
      }

      @Override
      public Delete set$Xgafv(java.lang.String $Xgafv) {
        return (Delete) super.set$Xgafv($Xgafv);
      }

      @Override
      public Delete setAccessToken(java.lang.String accessToken) {
        return (Delete) super.setAccessToken(accessToken);
      }

      @Override
      public Delete setAlt(java.lang.String alt) {
        return (Delete) super.setAlt(alt);
      }

      @Override
      public Delete setCallback(java.lang.String callback) {
        return (Delete) super.setCallback(callback);
      }

      @Override
      public Delete setFields(java.lang.String fields) {
        return (Delete) super.setFields(fields);
      }

      @Override
      public Delete setKey(java.lang.String key) {
        return (Delete) super.setKey(key);
      }

      @Override
      public Delete setOauthToken(java.lang.String oauthToken) {
        return (Delete) super.setOauthToken(oauthToken);
      }

      @Override
      public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Delete) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Delete setQuotaUser(java.lang.String quotaUser) {
        return (Delete) super.setQuotaUser(quotaUser);
      }

      @Override
      public Delete setUploadType(java.lang.String uploadType) {
        return (Delete) super.setUploadType(uploadType);
      }

      @Override
      public Delete setUploadProtocol(java.lang.String uploadProtocol) {
        return (Delete) super.setUploadProtocol(uploadProtocol);
      }

      @com.google.api.client.util.Key
      private java.lang.String id;

      /**

       */
      public java.lang.String getId() {
        return id;
      }

      public Delete setId(java.lang.String id) {
        this.id = id;
        return this;
      }

      /**
       * *Note:* This parameter is intended exclusively for YouTube content partners. The
       * *onBehalfOfContentOwner* parameter indicates that the request's authorization credentials
       * identify a YouTube CMS user who is acting on behalf of the content owner specified in the
       * parameter value. This parameter is intended for YouTube content partners that own and
       * manage many different YouTube channels. It allows content owners to authenticate once and
       * get access to all their video and channel data, without having to provide authentication
       * credentials for each individual channel. The CMS account that the user authenticates with
       * must be linked to the specified YouTube content owner.
       */
      @com.google.api.client.util.Key
      private java.lang.String onBehalfOfContentOwner;

      /*** Note:* This parameter is intended exclusively for YouTube content partners. The
    * *onBehalfOfContentOwner* parameter indicates that the request's authorization credentials identify
    * a YouTube CMS user who is acting on behalf of the content owner specified in the parameter value.
    * This parameter is intended for YouTube content partners that own and manage many different YouTube
    * channels. It allows content owners to authenticate once and get access to all their video and
    * channel data, without having to provide authentication credentials for each individual channel.
    * The CMS account that the user authenticates with must be linked to the specified YouTube content
    * owner.
    *

       */
      public java.lang.String getOnBehalfOfContentOwner() {
        return onBehalfOfContentOwner;
      }

      /**
       * *Note:* This parameter is intended exclusively for YouTube content partners. The
       * *onBehalfOfContentOwner* parameter indicates that the request's authorization credentials
       * identify a YouTube CMS user who is acting on behalf of the content owner specified in the
       * parameter value. This parameter is intended for YouTube content partners that own and
       * manage many different YouTube channels. It allows content owners to authenticate once and
       * get access to all their video and channel data, without having to provide authentication
       * credentials for each individual channel. The CMS account that the user authenticates with
       * must be linked to the specified YouTube content owner.
       */
      public Delete setOnBehalfOfContentOwner(java.lang.String onBehalfOfContentOwner) {
        this.onBehalfOfContentOwner = onBehalfOfContentOwner;
        return this;
      }

      /**
       * This parameter can only be used in a properly authorized request. *Note:* This parameter is
       * intended exclusively for YouTube content partners. The *onBehalfOfContentOwnerChannel*
       * parameter specifies the YouTube channel ID of the channel to which a video is being added.
       * This parameter is required when a request specifies a value for the onBehalfOfContentOwner
       * parameter, and it can only be used in conjunction with that parameter. In addition, the
       * request must be authorized using a CMS account that is linked to the content owner that the
       * onBehalfOfContentOwner parameter specifies. Finally, the channel that the
       * onBehalfOfContentOwnerChannel parameter value specifies must be linked to the content owner
       * that the onBehalfOfContentOwner parameter specifies. This parameter is intended for YouTube
       * content partners that own and manage many different YouTube channels. It allows content
       * owners to authenticate once and perform actions on behalf of the channel specified in the
       * parameter value, without having to provide authentication credentials for each separate
       * channel.
       */
      @com.google.api.client.util.Key
      private java.lang.String onBehalfOfContentOwnerChannel;

      /** This parameter can only be used in a properly authorized request. *Note:* This parameter is
     intended exclusively for YouTube content partners. The *onBehalfOfContentOwnerChannel* parameter
     specifies the YouTube channel ID of the channel to which a video is being added. This parameter is
     required when a request specifies a value for the onBehalfOfContentOwner parameter, and it can only
     be used in conjunction with that parameter. In addition, the request must be authorized using a CMS
     account that is linked to the content owner that the onBehalfOfContentOwner parameter specifies.
     Finally, the channel that the onBehalfOfContentOwnerChannel parameter value specifies must be
     linked to the content owner that the onBehalfOfContentOwner parameter specifies. This parameter is
     intended for YouTube content partners that own and manage many different YouTube channels. It
     allows content owners to authenticate once and perform actions on behalf of the channel specified
     in the parameter value, without having to provide authentication credentials for each separate
     channel.
       */
      public java.lang.String getOnBehalfOfContentOwnerChannel() {
        return onBehalfOfContentOwnerChannel;
      }

      /**
       * This parameter can only be used in a properly authorized request. *Note:* This parameter is
       * intended exclusively for YouTube content partners. The *onBehalfOfContentOwnerChannel*
       * parameter specifies the YouTube channel ID of the channel to which a video is being added.
       * This parameter is required when a request specifies a value for the onBehalfOfContentOwner
       * parameter, and it can only be used in conjunction with that parameter. In addition, the
       * request must be authorized using a CMS account that is linked to the content owner that the
       * onBehalfOfContentOwner parameter specifies. Finally, the channel that the
       * onBehalfOfContentOwnerChannel parameter value specifies must be linked to the content owner
       * that the onBehalfOfContentOwner parameter specifies. This parameter is intended for YouTube
       * content partners that own and manage many different YouTube channels. It allows content
       * owners to authenticate once and perform actions on behalf of the channel specified in the
       * parameter value, without having to provide authentication credentials for each separate
       * channel.
       */
      public Delete setOnBehalfOfContentOwnerChannel(java.lang.String onBehalfOfContentOwnerChannel) {
        this.onBehalfOfContentOwnerChannel = onBehalfOfContentOwnerChannel;
        return this;
      }

      @Override
      public Delete set(String parameterName, Object value) {
        return (Delete) super.set(parameterName, value);
      }
    }
    /**
     * Inserts a new stream for the authenticated user.
     *
     * Create a request for the method "liveStreams.insert".
     *
     * This request holds the parameters needed by the youtube server.  After setting any optional
     * parameters, call the {@link Insert#execute()} method to invoke the remote operation.
     *
     * @param part The *part* parameter serves two purposes in this operation. It identifies the properties that the
     *        write operation will set as well as the properties that the API response will include. The
     *        part properties that you can include in the parameter value are id, snippet, cdn,
     *        content_details, and status.
     * @param content the {@link com.google.api.services.youtube.model.LiveStream}
     * @return the request
     */
    public Insert insert(java.util.List<java.lang.String> part, com.google.api.services.youtube.model.LiveStream content) throws java.io.IOException {
      Insert result = new Insert(part, content);
      initialize(result);
      return result;
    }

    public class Insert extends YouTubeRequest<com.google.api.services.youtube.model.LiveStream> {

      private static final String REST_PATH = "youtube/v3/liveStreams";

      /**
       * Inserts a new stream for the authenticated user.
       *
       * Create a request for the method "liveStreams.insert".
       *
       * This request holds the parameters needed by the the youtube server.  After setting any optional
       * parameters, call the {@link Insert#execute()} method to invoke the remote operation. <p> {@link
       * Insert#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param part The *part* parameter serves two purposes in this operation. It identifies the properties that the
     *        write operation will set as well as the properties that the API response will include. The
     *        part properties that you can include in the parameter value are id, snippet, cdn,
     *        content_details, and status.
       * @param content the {@link com.google.api.services.youtube.model.LiveStream}
       * @since 1.13
       */
      protected Insert(java.util.List<java.lang.String> part, com.google.api.services.youtube.model.LiveStream content) {
        super(YouTube.this, "POST", REST_PATH, content, com.google.api.services.youtube.model.LiveStream.class);
        this.part = com.google.api.client.util.Preconditions.checkNotNull(part, "Required parameter part must be specified.");
      }

      @Override
      public Insert set$Xgafv(java.lang.String $Xgafv) {
        return (Insert) super.set$Xgafv($Xgafv);
      }

      @Override
      public Insert setAccessToken(java.lang.String accessToken) {
        return (Insert) super.setAccessToken(accessToken);
      }

      @Override
      public Insert setAlt(java.lang.String alt) {
        return (Insert) super.setAlt(alt);
      }

      @Override
      public Insert setCallback(java.lang.String callback) {
        return (Insert) super.setCallback(callback);
      }

      @Override
      public Insert setFields(java.lang.String fields) {
        return (Insert) super.setFields(fields);
      }

      @Override
      public Insert setKey(java.lang.String key) {
        return (Insert) super.setKey(key);
      }

      @Override
      public Insert setOauthToken(java.lang.String oauthToken) {
        return (Insert) super.setOauthToken(oauthToken);
      }

      @Override
      public Insert setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Insert) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Insert setQuotaUser(java.lang.String quotaUser) {
        return (Insert) super.setQuotaUser(quotaUser);
      }

      @Override
      public Insert setUploadType(java.lang.String uploadType) {
        return (Insert) super.setUploadType(uploadType);
      }

      @Override
      public Insert setUploadProtocol(java.lang.String uploadProtocol) {
        return (Insert) super.setUploadProtocol(uploadProtocol);
      }

      /**
       * The *part* parameter serves two purposes in this operation. It identifies the properties
       * that the write operation will set as well as the properties that the API response will
       * include. The part properties that you can include in the parameter value are id, snippet,
       * cdn, content_details, and status.
       */
      @com.google.api.client.util.Key
      private java.util.List<java.lang.String> part;

      /** The *part* parameter serves two purposes in this operation. It identifies the properties that the
     write operation will set as well as the properties that the API response will include. The part
     properties that you can include in the parameter value are id, snippet, cdn, content_details, and
     status.
       */
      public java.util.List<java.lang.String> getPart() {
        return part;
      }

      /**
       * The *part* parameter serves two purposes in this operation. It identifies the properties
       * that the write operation will set as well as the properties that the API response will
       * include. The part properties that you can include in the parameter value are id, snippet,
       * cdn, content_details, and status.
       */
      public Insert setPart(java.util.List<java.lang.String> part) {
        this.part = part;
        return this;
      }

      /**
       * *Note:* This parameter is intended exclusively for YouTube content partners. The
       * *onBehalfOfContentOwner* parameter indicates that the request's authorization credentials
       * identify a YouTube CMS user who is acting on behalf of the content owner specified in the
       * parameter value. This parameter is intended for YouTube content partners that own and
       * manage many different YouTube channels. It allows content owners to authenticate once and
       * get access to all their video and channel data, without having to provide authentication
       * credentials for each individual channel. The CMS account that the user authenticates with
       * must be linked to the specified YouTube content owner.
       */
      @com.google.api.client.util.Key
      private java.lang.String onBehalfOfContentOwner;

      /*** Note:* This parameter is intended exclusively for YouTube content partners. The
    * *onBehalfOfContentOwner* parameter indicates that the request's authorization credentials identify
    * a YouTube CMS user who is acting on behalf of the content owner specified in the parameter value.
    * This parameter is intended for YouTube content partners that own and manage many different YouTube
    * channels. It allows content owners to authenticate once and get access to all their video and
    * channel data, without having to provide authentication credentials for each individual channel.
    * The CMS account that the user authenticates with must be linked to the specified YouTube content
    * owner.
    *

       */
      public java.lang.String getOnBehalfOfContentOwner() {
        return onBehalfOfContentOwner;
      }

      /**
       * *Note:* This parameter is intended exclusively for YouTube content partners. The
       * *onBehalfOfContentOwner* parameter indicates that the request's authorization credentials
       * identify a YouTube CMS user who is acting on behalf of the content owner specified in the
       * parameter value. This parameter is intended for YouTube content partners that own and
       * manage many different YouTube channels. It allows content owners to authenticate once and
       * get access to all their video and channel data, without having to provide authentication
       * credentials for each individual channel. The CMS account that the user authenticates with
       * must be linked to the specified YouTube content owner.
       */
      public Insert setOnBehalfOfContentOwner(java.lang.String onBehalfOfContentOwner) {
        this.onBehalfOfContentOwner = onBehalfOfContentOwner;
        return this;
      }

      /**
       * This parameter can only be used in a properly authorized request. *Note:* This parameter is
       * intended exclusively for YouTube content partners. The *onBehalfOfContentOwnerChannel*
       * parameter specifies the YouTube channel ID of the channel to which a video is being added.
       * This parameter is required when a request specifies a value for the onBehalfOfContentOwner
       * parameter, and it can only be used in conjunction with that parameter. In addition, the
       * request must be authorized using a CMS account that is linked to the content owner that the
       * onBehalfOfContentOwner parameter specifies. Finally, the channel that the
       * onBehalfOfContentOwnerChannel parameter value specifies must be linked to the content owner
       * that the onBehalfOfContentOwner parameter specifies. This parameter is intended for YouTube
       * content partners that own and manage many different YouTube channels. It allows content
       * owners to authenticate once and perform actions on behalf of the channel specified in the
       * parameter value, without having to provide authentication credentials for each separate
       * channel.
       */
      @com.google.api.client.util.Key
      private java.lang.String onBehalfOfContentOwnerChannel;

      /** This parameter can only be used in a properly authorized request. *Note:* This parameter is
     intended exclusively for YouTube content partners. The *onBehalfOfContentOwnerChannel* parameter
     specifies the YouTube channel ID of the channel to which a video is being added. This parameter is
     required when a request specifies a value for the onBehalfOfContentOwner parameter, and it can only
     be used in conjunction with that parameter. In addition, the request must be authorized using a CMS
     account that is linked to the content owner that the onBehalfOfContentOwner parameter specifies.
     Finally, the channel that the onBehalfOfContentOwnerChannel parameter value specifies must be
     linked to the content owner that the onBehalfOfContentOwner parameter specifies. This parameter is
     intended for YouTube content partners that own and manage many different YouTube channels. It
     allows content owners to authenticate once and perform actions on behalf of the channel specified
     in the parameter value, without having to provide authentication credentials for each separate
     channel.
       */
      public java.lang.String getOnBehalfOfContentOwnerChannel() {
        return onBehalfOfContentOwnerChannel;
      }

      /**
       * This parameter can only be used in a properly authorized request. *Note:* This parameter is
       * intended exclusively for YouTube content partners. The *onBehalfOfContentOwnerChannel*
       * parameter specifies the YouTube channel ID of the channel to which a video is being added.
       * This parameter is required when a request specifies a value for the onBehalfOfContentOwner
       * parameter, and it can only be used in conjunction with that parameter. In addition, the
       * request must be authorized using a CMS account that is linked to the content owner that the
       * onBehalfOfContentOwner parameter specifies. Finally, the channel that the
       * onBehalfOfContentOwnerChannel parameter value specifies must be linked to the content owner
       * that the onBehalfOfContentOwner parameter specifies. This parameter is intended for YouTube
       * content partners that own and manage many different YouTube channels. It allows content
       * owners to authenticate once and perform actions on behalf of the channel specified in the
       * parameter value, without having to provide authentication credentials for each separate
       * channel.
       */
      public Insert setOnBehalfOfContentOwnerChannel(java.lang.String onBehalfOfContentOwnerChannel) {
        this.onBehalfOfContentOwnerChannel = onBehalfOfContentOwnerChannel;
        return this;
      }

      @Override
      public Insert set(String parameterName, Object value) {
        return (Insert) super.set(parameterName, value);
      }
    }
    /**
     * Retrieve the list of streams associated with the given channel. --
     *
     * Create a request for the method "liveStreams.list".
     *
     * This request holds the parameters needed by the youtube server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param part The *part* parameter specifies a comma-separated list of one or more liveStream resource properties
     *        that the API response will include. The part names that you can include in the parameter
     *        value are id, snippet, cdn, and status.
     * @return the request
     */
    public List list(java.util.List<java.lang.String> part) throws java.io.IOException {
      List result = new List(part);
      initialize(result);
      return result;
    }

    public class List extends YouTubeRequest<com.google.api.services.youtube.model.LiveStreamListResponse> {

      private static final String REST_PATH = "youtube/v3/liveStreams";

      /**
       * Retrieve the list of streams associated with the given channel. --
       *
       * Create a request for the method "liveStreams.list".
       *
       * This request holds the parameters needed by the the youtube server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param part The *part* parameter specifies a comma-separated list of one or more liveStream resource properties
     *        that the API response will include. The part names that you can include in the parameter
     *        value are id, snippet, cdn, and status.
       * @since 1.13
       */
      protected List(java.util.List<java.lang.String> part) {
        super(YouTube.this, "GET", REST_PATH, null, com.google.api.services.youtube.model.LiveStreamListResponse.class);
        this.part = com.google.api.client.util.Preconditions.checkNotNull(part, "Required parameter part must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List set$Xgafv(java.lang.String $Xgafv) {
        return (List) super.set$Xgafv($Xgafv);
      }

      @Override
      public List setAccessToken(java.lang.String accessToken) {
        return (List) super.setAccessToken(accessToken);
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setCallback(java.lang.String callback) {
        return (List) super.setCallback(callback);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUploadType(java.lang.String uploadType) {
        return (List) super.setUploadType(uploadType);
      }

      @Override
      public List setUploadProtocol(java.lang.String uploadProtocol) {
        return (List) super.setUploadProtocol(uploadProtocol);
      }

      /**
       * The *part* parameter specifies a comma-separated list of one or more liveStream resource
       * properties that the API response will include. The part names that you can include in the
       * parameter value are id, snippet, cdn, and status.
       */
      @com.google.api.client.util.Key
      private java.util.List<java.lang.String> part;

      /** The *part* parameter specifies a comma-separated list of one or more liveStream resource properties
     that the API response will include. The part names that you can include in the parameter value are
     id, snippet, cdn, and status.
       */
      public java.util.List<java.lang.String> getPart() {
        return part;
      }

      /**
       * The *part* parameter specifies a comma-separated list of one or more liveStream resource
       * properties that the API response will include. The part names that you can include in the
       * parameter value are id, snippet, cdn, and status.
       */
      public List setPart(java.util.List<java.lang.String> part) {
        this.part = part;
        return this;
      }

      /** Return LiveStreams with the given ids from Stubby or Apiary. */
      @com.google.api.client.util.Key
      private java.util.List<java.lang.String> id;

      /** Return LiveStreams with the given ids from Stubby or Apiary.
       */
      public java.util.List<java.lang.String> getId() {
        return id;
      }

      /** Return LiveStreams with the given ids from Stubby or Apiary. */
      public List setId(java.util.List<java.lang.String> id) {
        this.id = id;
        return this;
      }

      /**
       * The *maxResults* parameter specifies the maximum number of items that should be returned in
       * the result set.
       */
      @com.google.api.client.util.Key
      private java.lang.Long maxResults;

      /** The *maxResults* parameter specifies the maximum number of items that should be returned in the
     result set. [default: 5] [minimum: 0] [maximum: 50]
       */
      public java.lang.Long getMaxResults() {
        return maxResults;
      }

      /**
       * The *maxResults* parameter specifies the maximum number of items that should be returned in
       * the result set.
       */
      public List setMaxResults(java.lang.Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      @com.google.api.client.util.Key
      private java.lang.Boolean mine;

      /**

       */
      public java.lang.Boolean getMine() {
        return mine;
      }

      public List setMine(java.lang.Boolean mine) {
        this.mine = mine;
        return this;
      }

      /**
       * *Note:* This parameter is intended exclusively for YouTube content partners. The
       * *onBehalfOfContentOwner* parameter indicates that the request's authorization credentials
       * identify a YouTube CMS user who is acting on behalf of the content owner specified in the
       * parameter value. This parameter is intended for YouTube content partners that own and
       * manage many different YouTube channels. It allows content owners to authenticate once and
       * get access to all their video and channel data, without having to provide authentication
       * credentials for each individual channel. The CMS account that the user authenticates with
       * must be linked to the specified YouTube content owner.
       */
      @com.google.api.client.util.Key
      private java.lang.String onBehalfOfContentOwner;

      /*** Note:* This parameter is intended exclusively for YouTube content partners. The
    * *onBehalfOfContentOwner* parameter indicates that the request's authorization credentials identify
    * a YouTube CMS user who is acting on behalf of the content owner specified in the parameter value.
    * This parameter is intended for YouTube content partners that own and manage many different YouTube
    * channels. It allows content owners to authenticate once and get access to all their video and
    * channel data, without having to provide authentication credentials for each individual channel.
    * The CMS account that the user authenticates with must be linked to the specified YouTube content
    * owner.
    *

       */
      public java.lang.String getOnBehalfOfContentOwner() {
        return onBehalfOfContentOwner;
      }

      /**
       * *Note:* This parameter is intended exclusively for YouTube content partners. The
       * *onBehalfOfContentOwner* parameter indicates that the request's authorization credentials
       * identify a YouTube CMS user who is acting on behalf of the content owner specified in the
       * parameter value. This parameter is intended for YouTube content partners that own and
       * manage many different YouTube channels. It allows content owners to authenticate once and
       * get access to all their video and channel data, without having to provide authentication
       * credentials for each individual channel. The CMS account that the user authenticates with
       * must be linked to the specified YouTube content owner.
       */
      public List setOnBehalfOfContentOwner(java.lang.String onBehalfOfContentOwner) {
        this.onBehalfOfContentOwner = onBehalfOfContentOwner;
        return this;
      }

      /**
       * This parameter can only be used in a properly authorized request. *Note:* This parameter is
       * intended exclusively for YouTube content partners. The *onBehalfOfContentOwnerChannel*
       * parameter specifies the YouTube channel ID of the channel to which a video is being added.
       * This parameter is required when a request specifies a value for the onBehalfOfContentOwner
       * parameter, and it can only be used in conjunction with that parameter. In addition, the
       * request must be authorized using a CMS account that is linked to the content owner that the
       * onBehalfOfContentOwner parameter specifies. Finally, the channel that the
       * onBehalfOfContentOwnerChannel parameter value specifies must be linked to the content owner
       * that the onBehalfOfContentOwner parameter specifies. This parameter is intended for YouTube
       * content partners that own and manage many different YouTube channels. It allows content
       * owners to authenticate once and perform actions on behalf of the channel specified in the
       * parameter value, without having to provide authentication credentials for each separate
       * channel.
       */
      @com.google.api.client.util.Key
      private java.lang.String onBehalfOfContentOwnerChannel;

      /** This parameter can only be used in a properly authorized request. *Note:* This parameter is
     intended exclusively for YouTube content partners. The *onBehalfOfContentOwnerChannel* parameter
     specifies the YouTube channel ID of the channel to which a video is being added. This parameter is
     required when a request specifies a value for the onBehalfOfContentOwner parameter, and it can only
     be used in conjunction with that parameter. In addition, the request must be authorized using a CMS
     account that is linked to the content owner that the onBehalfOfContentOwner parameter specifies.
     Finally, the channel that the onBehalfOfContentOwnerChannel parameter value specifies must be
     linked to the content owner that the onBehalfOfContentOwner parameter specifies. This parameter is
     intended for YouTube content partners that own and manage many different YouTube channels. It
     allows content owners to authenticate once and perform actions on behalf of the channel specified
     in the parameter value, without having to provide authentication credentials for each separate
     channel.
       */
      public java.lang.String getOnBehalfOfContentOwnerChannel() {
        return onBehalfOfContentOwnerChannel;
      }

      /**
       * This parameter can only be used in a properly authorized request. *Note:* This parameter is
       * intended exclusively for YouTube content partners. The *onBehalfOfContentOwnerChannel*
       * parameter specifies the YouTube channel ID of the channel to which a video is being added.
       * This parameter is required when a request specifies a value for the onBehalfOfContentOwner
       * parameter, and it can only be used in conjunction with that parameter. In addition, the
       * request must be authorized using a CMS account that is linked to the content owner that the
       * onBehalfOfContentOwner parameter specifies. Finally, the channel that the
       * onBehalfOfContentOwnerChannel parameter value specifies must be linked to the content owner
       * that the onBehalfOfContentOwner parameter specifies. This parameter is intended for YouTube
       * content partners that own and manage many different YouTube channels. It allows content
       * owners to authenticate once and perform actions on behalf of the channel specified in the
       * parameter value, without having to provide authentication credentials for each separate
       * channel.
       */
      public List setOnBehalfOfContentOwnerChannel(java.lang.String onBehalfOfContentOwnerChannel) {
        this.onBehalfOfContentOwnerChannel = onBehalfOfContentOwnerChannel;
        return this;
      }

      /**
       * The *pageToken* parameter identifies a specific page in the result set that should be
       * returned. In an API response, the nextPageToken and prevPageToken properties identify other
       * pages that could be retrieved.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** The *pageToken* parameter identifies a specific page in the result set that should be returned. In
     an API response, the nextPageToken and prevPageToken properties identify other pages that could be
     retrieved.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * The *pageToken* parameter identifies a specific page in the result set that should be
       * returned. In an API response, the nextPageToken and prevPageToken properties identify other
       * pages that could be retrieved.
       */
      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }
    /**
     * Updates an existing stream for the authenticated user.
     *
     * Create a request for the method "liveStreams.update".
     *
     * This request holds the parameters needed by the youtube server.  After setting any optional
     * parameters, call the {@link Update#execute()} method to invoke the remote operation.
     *
     * @param part The *part* parameter serves two purposes in this operation. It identifies the properties that the
     *        write operation will set as well as the properties that the API response will include. The
     *        part properties that you can include in the parameter value are id, snippet, cdn, and
     *        status. Note that this method will override the existing values for all of the mutable
     *        properties that are contained in any parts that the parameter value specifies. If the
     *        request body does not specify a value for a mutable property, the existing value for that
     *        property will be removed.
     * @param content the {@link com.google.api.services.youtube.model.LiveStream}
     * @return the request
     */
    public Update update(java.util.List<java.lang.String> part, com.google.api.services.youtube.model.LiveStream content) throws java.io.IOException {
      Update result = new Update(part, content);
      initialize(result);
      return result;
    }

    public class Update extends YouTubeRequest<com.google.api.services.youtube.model.LiveStream> {

      private static final String REST_PATH = "youtube/v3/liveStreams";

      /**
       * Updates an existing stream for the authenticated user.
       *
       * Create a request for the method "liveStreams.update".
       *
       * This request holds the parameters needed by the the youtube server.  After setting any optional
       * parameters, call the {@link Update#execute()} method to invoke the remote operation. <p> {@link
       * Update#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param part The *part* parameter serves two purposes in this operation. It identifies the properties that the
     *        write operation will set as well as the properties that the API response will include. The
     *        part properties that you can include in the parameter value are id, snippet, cdn, and
     *        status. Note that this method will override the existing values for all of the mutable
     *        properties that are contained in any parts that the parameter value specifies. If the
     *        request body does not specify a value for a mutable property, the existing value for that
     *        property will be removed.
       * @param content the {@link com.google.api.services.youtube.model.LiveStream}
       * @since 1.13
       */
      protected Update(java.util.List<java.lang.String> part, com.google.api.services.youtube.model.LiveStream content) {
        super(YouTube.this, "PUT", REST_PATH, content, com.google.api.services.youtube.model.LiveStream.class);
        this.part = com.google.api.client.util.Preconditions.checkNotNull(part, "Required parameter part must be specified.");
        checkRequiredParameter(content, "content");
        checkRequiredParameter(content.getId(), "LiveStream.getId()");
      }

      @Override
      public Update set$Xgafv(java.lang.String $Xgafv) {
        return (Update) super.set$Xgafv($Xgafv);
      }

      @Override
      public Update setAccessToken(java.lang.String accessToken) {
        return (Update) super.setAccessToken(accessToken);
      }

      @Override
      public Update setAlt(java.lang.String alt) {
        return (Update) super.setAlt(alt);
      }

      @Override
      public Update setCallback(java.lang.String callback) {
        return (Update) super.setCallback(callback);
      }

      @Override
      public Update setFields(java.lang.String fields) {
        return (Update) super.setFields(fields);
      }

      @Override
      public Update setKey(java.lang.String key) {
        return (Update) super.setKey(key);
      }

      @Override
      public Update setOauthToken(java.lang.String oauthToken) {
        return (Update) super.setOauthToken(oauthToken);
      }

      @Override
      public Update setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Update) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Update setQuotaUser(java.lang.String quotaUser) {
        return (Update) super.setQuotaUser(quotaUser);
      }

      @Override
      public Update setUploadType(java.lang.String uploadType) {
        return (Update) super.setUploadType(uploadType);
      }

      @Override
      public Update setUploadProtocol(java.lang.String uploadProtocol) {
        return (Update) super.setUploadProtocol(uploadProtocol);
      }

      /**
       * The *part* parameter serves two purposes in this operation. It identifies the properties
       * that the write operation will set as well as the properties that the API response will
       * include. The part properties that you can include in the parameter value are id, snippet,
       * cdn, and status. Note that this method will override the existing values for all of the
       * mutable properties that are contained in any parts that the parameter value specifies. If
       * the request body does not specify a value for a mutable property, the existing value for
       * that property will be removed.
       */
      @com.google.api.client.util.Key
      private java.util.List<java.lang.String> part;

      /** The *part* parameter serves two purposes in this operation. It identifies the properties that the
     write operation will set as well as the properties that the API response will include. The part
     properties that you can include in the parameter value are id, snippet, cdn, and status. Note that
     this method will override the existing values for all of the mutable properties that are contained
     in any parts that the parameter value specifies. If the request body does not specify a value for a
     mutable property, the existing value for that property will be removed.
       */
      public java.util.List<java.lang.String> getPart() {
        return part;
      }

      /**
       * The *part* parameter serves two purposes in this operation. It identifies the properties
       * that the write operation will set as well as the properties that the API response will
       * include. The part properties that you can include in the parameter value are id, snippet,
       * cdn, and status. Note that this method will override the existing values for all of the
       * mutable properties that are contained in any parts that the parameter value specifies. If
       * the request body does not specify a value for a mutable property, the existing value for
       * that property will be removed.
       */
      public Update setPart(java.util.List<java.lang.String> part) {
        this.part = part;
        return this;
      }

      /**
       * *Note:* This parameter is intended exclusively for YouTube content partners. The
       * *onBehalfOfContentOwner* parameter indicates that the request's authorization credentials
       * identify a YouTube CMS user who is acting on behalf of the content owner specified in the
       * parameter value. This parameter is intended for YouTube content partners that own and
       * manage many different YouTube channels. It allows content owners to authenticate once and
       * get access to all their video and channel data, without having to provide authentication
       * credentials for each individual channel. The CMS account that the user authenticates with
       * must be linked to the specified YouTube content owner.
       */
      @com.google.api.client.util.Key
      private java.lang.String onBehalfOfContentOwner;

      /*** Note:* This parameter is intended exclusively for YouTube content partners. The
    * *onBehalfOfContentOwner* parameter indicates that the request's authorization credentials identify
    * a YouTube CMS user who is acting on behalf of the content owner specified in the parameter value.
    * This parameter is intended for YouTube content partners that own and manage many different YouTube
    * channels. It allows content owners to authenticate once and get access to all their video and
    * channel data, without having to provide authentication credentials for each individual channel.
    * The CMS account that the user authenticates with must be linked to the specified YouTube content
    * owner.
    *

       */
      public java.lang.String getOnBehalfOfContentOwner() {
        return onBehalfOfContentOwner;
      }

      /**
       * *Note:* This parameter is intended exclusively for YouTube content partners. The
       * *onBehalfOfContentOwner* parameter indicates that the request's authorization credentials
       * identify a YouTube CMS user who is acting on behalf of the content owner specified in the
       * parameter value. This parameter is intended for YouTube content partners that own and
       * manage many different YouTube channels. It allows content owners to authenticate once and
       * get access to all their video and channel data, without having to provide authentication
       * credentials for each individual channel. The CMS account that the user authenticates with
       * must be linked to the specified YouTube content owner.
       */
      public Update setOnBehalfOfContentOwner(java.lang.String onBehalfOfContentOwner) {
        this.onBehalfOfContentOwner = onBehalfOfContentOwner;
        return this;
      }

      /**
       * This parameter can only be used in a properly authorized request. *Note:* This parameter is
       * intended exclusively for YouTube content partners. The *onBehalfOfContentOwnerChannel*
       * parameter specifies the YouTube channel ID of the channel to which a video is being added.
       * This parameter is required when a request specifies a value for the onBehalfOfContentOwner
       * parameter, and it can only be used in conjunction with that parameter. In addition, the
       * request must be authorized using a CMS account that is linked to the content owner that the
       * onBehalfOfContentOwner parameter specifies. Finally, the channel that the
       * onBehalfOfContentOwnerChannel parameter value specifies must be linked to the content owner
       * that the onBehalfOfContentOwner parameter specifies. This parameter is intended for YouTube
       * content partners that own and manage many different YouTube channels. It allows content
       * owners to authenticate once and perform actions on behalf of the channel specified in the
       * parameter value, without having to provide authentication credentials for each separate
       * channel.
       */
      @com.google.api.client.util.Key
      private java.lang.String onBehalfOfContentOwnerChannel;

      /** This parameter can only be used in a properly authorized request. *Note:* This parameter is
     intended exclusively for YouTube content partners. The *onBehalfOfContentOwnerChannel* parameter
     specifies the YouTube channel ID of the channel to which a video is being added. This parameter is
     required when a request specifies a value for the onBehalfOfContentOwner parameter, and it can only
     be used in conjunction with that parameter. In addition, the request must be authorized using a CMS
     account that is linked to the content owner that the onBehalfOfContentOwner parameter specifies.
     Finally, the channel that the onBehalfOfContentOwnerChannel parameter value specifies must be
     linked to the content owner that the onBehalfOfContentOwner parameter specifies. This parameter is
     intended for YouTube content partners that own and manage many different YouTube channels. It
     allows content owners to authenticate once and perform actions on behalf of the channel specified
     in the parameter value, without having to provide authentication credentials for each separate
     channel.
       */
      public java.lang.String getOnBehalfOfContentOwnerChannel() {
        return onBehalfOfContentOwnerChannel;
      }

      /**
       * This parameter can only be used in a properly authorized request. *Note:* This parameter is
       * intended exclusively for YouTube content partners. The *onBehalfOfContentOwnerChannel*
       * parameter specifies the YouTube channel ID of the channel to which a video is being added.
       * This parameter is required when a request specifies a value for the onBehalfOfContentOwner
       * parameter, and it can only be used in conjunction with that parameter. In addition, the
       * request must be authorized using a CMS account that is linked to the content owner that the
       * onBehalfOfContentOwner parameter specifies. Finally, the channel that the
       * onBehalfOfContentOwnerChannel parameter value specifies must be linked to the content owner
       * that the onBehalfOfContentOwner parameter specifies. This parameter is intended for YouTube
       * content partners that own and manage many different YouTube channels. It allows content
       * owners to authenticate once and perform actions on behalf of the channel specified in the
       * parameter value, without having to provide authentication credentials for each separate
       * channel.
       */
      public Update setOnBehalfOfContentOwnerChannel(java.lang.String onBehalfOfContentOwnerChannel) {
        this.onBehalfOfContentOwnerChannel = onBehalfOfContentOwnerChannel;
        return this;
      }

      @Override
      public Update set(String parameterName, Object value) {
        return (Update) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the Members collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code YouTube youtube = new YouTube(...);}
   *   {@code YouTube.Members.List request = youtube.members().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Members members() {
    return new Members();
  }

  /**
   * The "members" collection of methods.
   */
  public class Members {

    /**
     * Retrieves a list of members that match the request criteria for a channel.
     *
     * Create a request for the method "members.list".
     *
     * This request holds the parameters needed by the youtube server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param part The *part* parameter specifies the member resource parts that the API response will include. Set the
     *        parameter value to snippet.
     * @return the request
     */
    public List list(java.util.List<java.lang.String> part) throws java.io.IOException {
      List result = new List(part);
      initialize(result);
      return result;
    }

    public class List extends YouTubeRequest<com.google.api.services.youtube.model.MemberListResponse> {

      private static final String REST_PATH = "youtube/v3/members";

      /**
       * Retrieves a list of members that match the request criteria for a channel.
       *
       * Create a request for the method "members.list".
       *
       * This request holds the parameters needed by the the youtube server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param part The *part* parameter specifies the member resource parts that the API response will include. Set the
     *        parameter value to snippet.
       * @since 1.13
       */
      protected List(java.util.List<java.lang.String> part) {
        super(YouTube.this, "GET", REST_PATH, null, com.google.api.services.youtube.model.MemberListResponse.class);
        this.part = com.google.api.client.util.Preconditions.checkNotNull(part, "Required parameter part must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List set$Xgafv(java.lang.String $Xgafv) {
        return (List) super.set$Xgafv($Xgafv);
      }

      @Override
      public List setAccessToken(java.lang.String accessToken) {
        return (List) super.setAccessToken(accessToken);
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setCallback(java.lang.String callback) {
        return (List) super.setCallback(callback);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUploadType(java.lang.String uploadType) {
        return (List) super.setUploadType(uploadType);
      }

      @Override
      public List setUploadProtocol(java.lang.String uploadProtocol) {
        return (List) super.setUploadProtocol(uploadProtocol);
      }

      /**
       * The *part* parameter specifies the member resource parts that the API response will
       * include. Set the parameter value to snippet.
       */
      @com.google.api.client.util.Key
      private java.util.List<java.lang.String> part;

      /** The *part* parameter specifies the member resource parts that the API response will include. Set
     the parameter value to snippet.
       */
      public java.util.List<java.lang.String> getPart() {
        return part;
      }

      /**
       * The *part* parameter specifies the member resource parts that the API response will
       * include. Set the parameter value to snippet.
       */
      public List setPart(java.util.List<java.lang.String> part) {
        this.part = part;
        return this;
      }

      /**
       * Comma separated list of channel IDs. Only data about members that are part of this list
       * will be included in the response.
       */
      @com.google.api.client.util.Key
      private java.lang.String filterByMemberChannelId;

      /** Comma separated list of channel IDs. Only data about members that are part of this list will be
     included in the response.
       */
      public java.lang.String getFilterByMemberChannelId() {
        return filterByMemberChannelId;
      }

      /**
       * Comma separated list of channel IDs. Only data about members that are part of this list
       * will be included in the response.
       */
      public List setFilterByMemberChannelId(java.lang.String filterByMemberChannelId) {
        this.filterByMemberChannelId = filterByMemberChannelId;
        return this;
      }

      /** Filter members in the results set to the ones that have access to a level. */
      @com.google.api.client.util.Key
      private java.lang.String hasAccessToLevel;

      /** Filter members in the results set to the ones that have access to a level.
       */
      public java.lang.String getHasAccessToLevel() {
        return hasAccessToLevel;
      }

      /** Filter members in the results set to the ones that have access to a level. */
      public List setHasAccessToLevel(java.lang.String hasAccessToLevel) {
        this.hasAccessToLevel = hasAccessToLevel;
        return this;
      }

      /**
       * The *maxResults* parameter specifies the maximum number of items that should be returned in
       * the result set.
       */
      @com.google.api.client.util.Key
      private java.lang.Long maxResults;

      /** The *maxResults* parameter specifies the maximum number of items that should be returned in the
     result set. [default: 5] [minimum: 0] [maximum: 1000]
       */
      public java.lang.Long getMaxResults() {
        return maxResults;
      }

      /**
       * The *maxResults* parameter specifies the maximum number of items that should be returned in
       * the result set.
       */
      public List setMaxResults(java.lang.Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      /** Parameter that specifies which channel members to return. */
      @com.google.api.client.util.Key
      private java.lang.String mode;

      /** Parameter that specifies which channel members to return. [default: all_current]
       */
      public java.lang.String getMode() {
        return mode;
      }

      /** Parameter that specifies which channel members to return. */
      public List setMode(java.lang.String mode) {
        this.mode = mode;
        return this;
      }

      /**
       * The *pageToken* parameter identifies a specific page in the result set that should be
       * returned. In an API response, the nextPageToken and prevPageToken properties identify other
       * pages that could be retrieved.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** The *pageToken* parameter identifies a specific page in the result set that should be returned. In
     an API response, the nextPageToken and prevPageToken properties identify other pages that could be
     retrieved.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * The *pageToken* parameter identifies a specific page in the result set that should be
       * returned. In an API response, the nextPageToken and prevPageToken properties identify other
       * pages that could be retrieved.
       */
      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the MembershipsLevels collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code YouTube youtube = new YouTube(...);}
   *   {@code YouTube.MembershipsLevels.List request = youtube.membershipsLevels().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public MembershipsLevels membershipsLevels() {
    return new MembershipsLevels();
  }

  /**
   * The "membershipsLevels" collection of methods.
   */
  public class MembershipsLevels {

    /**
     * Retrieves a list of all pricing levels offered by a creator to the fans.
     *
     * Create a request for the method "membershipsLevels.list".
     *
     * This request holds the parameters needed by the youtube server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param part The *part* parameter specifies the membershipsLevel resource parts that the API response will
     *        include. Supported values are id and snippet.
     * @return the request
     */
    public List list(java.util.List<java.lang.String> part) throws java.io.IOException {
      List result = new List(part);
      initialize(result);
      return result;
    }

    public class List extends YouTubeRequest<com.google.api.services.youtube.model.MembershipsLevelListResponse> {

      private static final String REST_PATH = "youtube/v3/membershipsLevels";

      /**
       * Retrieves a list of all pricing levels offered by a creator to the fans.
       *
       * Create a request for the method "membershipsLevels.list".
       *
       * This request holds the parameters needed by the the youtube server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param part The *part* parameter specifies the membershipsLevel resource parts that the API response will
     *        include. Supported values are id and snippet.
       * @since 1.13
       */
      protected List(java.util.List<java.lang.String> part) {
        super(YouTube.this, "GET", REST_PATH, null, com.google.api.services.youtube.model.MembershipsLevelListResponse.class);
        this.part = com.google.api.client.util.Preconditions.checkNotNull(part, "Required parameter part must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List set$Xgafv(java.lang.String $Xgafv) {
        return (List) super.set$Xgafv($Xgafv);
      }

      @Override
      public List setAccessToken(java.lang.String accessToken) {
        return (List) super.setAccessToken(accessToken);
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setCallback(java.lang.String callback) {
        return (List) super.setCallback(callback);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUploadType(java.lang.String uploadType) {
        return (List) super.setUploadType(uploadType);
      }

      @Override
      public List setUploadProtocol(java.lang.String uploadProtocol) {
        return (List) super.setUploadProtocol(uploadProtocol);
      }

      /**
       * The *part* parameter specifies the membershipsLevel resource parts that the API response
       * will include. Supported values are id and snippet.
       */
      @com.google.api.client.util.Key
      private java.util.List<java.lang.String> part;

      /** The *part* parameter specifies the membershipsLevel resource parts that the API response will
     include. Supported values are id and snippet.
       */
      public java.util.List<java.lang.String> getPart() {
        return part;
      }

      /**
       * The *part* parameter specifies the membershipsLevel resource parts that the API response
       * will include. Supported values are id and snippet.
       */
      public List setPart(java.util.List<java.lang.String> part) {
        this.part = part;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the PlaylistItems collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code YouTube youtube = new YouTube(...);}
   *   {@code YouTube.PlaylistItems.List request = youtube.playlistItems().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public PlaylistItems playlistItems() {
    return new PlaylistItems();
  }

  /**
   * The "playlistItems" collection of methods.
   */
  public class PlaylistItems {

    /**
     * Deletes a resource.
     *
     * Create a request for the method "playlistItems.delete".
     *
     * This request holds the parameters needed by the youtube server.  After setting any optional
     * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
     *
     * @param id
     * @return the request
     */
    public Delete delete(java.lang.String id) throws java.io.IOException {
      Delete result = new Delete(id);
      initialize(result);
      return result;
    }

    public class Delete extends YouTubeRequest<Void> {

      private static final String REST_PATH = "youtube/v3/playlistItems";

      /**
       * Deletes a resource.
       *
       * Create a request for the method "playlistItems.delete".
       *
       * This request holds the parameters needed by the the youtube server.  After setting any optional
       * parameters, call the {@link Delete#execute()} method to invoke the remote operation. <p> {@link
       * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param id
       * @since 1.13
       */
      protected Delete(java.lang.String id) {
        super(YouTube.this, "DELETE", REST_PATH, null, Void.class);
        this.id = com.google.api.client.util.Preconditions.checkNotNull(id, "Required parameter id must be specified.");
      }

      @Override
      public Delete set$Xgafv(java.lang.String $Xgafv) {
        return (Delete) super.set$Xgafv($Xgafv);
      }

      @Override
      public Delete setAccessToken(java.lang.String accessToken) {
        return (Delete) super.setAccessToken(accessToken);
      }

      @Override
      public Delete setAlt(java.lang.String alt) {
        return (Delete) super.setAlt(alt);
      }

      @Override
      public Delete setCallback(java.lang.String callback) {
        return (Delete) super.setCallback(callback);
      }

      @Override
      public Delete setFields(java.lang.String fields) {
        return (Delete) super.setFields(fields);
      }

      @Override
      public Delete setKey(java.lang.String key) {
        return (Delete) super.setKey(key);
      }

      @Override
      public Delete setOauthToken(java.lang.String oauthToken) {
        return (Delete) super.setOauthToken(oauthToken);
      }

      @Override
      public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Delete) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Delete setQuotaUser(java.lang.String quotaUser) {
        return (Delete) super.setQuotaUser(quotaUser);
      }

      @Override
      public Delete setUploadType(java.lang.String uploadType) {
        return (Delete) super.setUploadType(uploadType);
      }

      @Override
      public Delete setUploadProtocol(java.lang.String uploadProtocol) {
        return (Delete) super.setUploadProtocol(uploadProtocol);
      }

      @com.google.api.client.util.Key
      private java.lang.String id;

      /**

       */
      public java.lang.String getId() {
        return id;
      }

      public Delete setId(java.lang.String id) {
        this.id = id;
        return this;
      }

      /**
       * *Note:* This parameter is intended exclusively for YouTube content partners. The
       * *onBehalfOfContentOwner* parameter indicates that the request's authorization credentials
       * identify a YouTube CMS user who is acting on behalf of the content owner specified in the
       * parameter value. This parameter is intended for YouTube content partners that own and
       * manage many different YouTube channels. It allows content owners to authenticate once and
       * get access to all their video and channel data, without having to provide authentication
       * credentials for each individual channel. The CMS account that the user authenticates with
       * must be linked to the specified YouTube content owner.
       */
      @com.google.api.client.util.Key
      private java.lang.String onBehalfOfContentOwner;

      /*** Note:* This parameter is intended exclusively for YouTube content partners. The
    * *onBehalfOfContentOwner* parameter indicates that the request's authorization credentials identify
    * a YouTube CMS user who is acting on behalf of the content owner specified in the parameter value.
    * This parameter is intended for YouTube content partners that own and manage many different YouTube
    * channels. It allows content owners to authenticate once and get access to all their video and
    * channel data, without having to provide authentication credentials for each individual channel.
    * The CMS account that the user authenticates with must be linked to the specified YouTube content
    * owner.
    *

       */
      public java.lang.String getOnBehalfOfContentOwner() {
        return onBehalfOfContentOwner;
      }

      /**
       * *Note:* This parameter is intended exclusively for YouTube content partners. The
       * *onBehalfOfContentOwner* parameter indicates that the request's authorization credentials
       * identify a YouTube CMS user who is acting on behalf of the content owner specified in the
       * parameter value. This parameter is intended for YouTube content partners that own and
       * manage many different YouTube channels. It allows content owners to authenticate once and
       * get access to all their video and channel data, without having to provide authentication
       * credentials for each individual channel. The CMS account that the user authenticates with
       * must be linked to the specified YouTube content owner.
       */
      public Delete setOnBehalfOfContentOwner(java.lang.String onBehalfOfContentOwner) {
        this.onBehalfOfContentOwner = onBehalfOfContentOwner;
        return this;
      }

      @Override
      public Delete set(String parameterName, Object value) {
        return (Delete) super.set(parameterName, value);
      }
    }
    /**
     * Inserts a new resource into this collection.
     *
     * Create a request for the method "playlistItems.insert".
     *
     * This request holds the parameters needed by the youtube server.  After setting any optional
     * parameters, call the {@link Insert#execute()} method to invoke the remote operation.
     *
     * @param part The *part* parameter serves two purposes in this operation. It identifies the properties that the
     *        write operation will set as well as the properties that the API response will include.
     * @param content the {@link com.google.api.services.youtube.model.PlaylistItem}
     * @return the request
     */
    public Insert insert(java.util.List<java.lang.String> part, com.google.api.services.youtube.model.PlaylistItem content) throws java.io.IOException {
      Insert result = new Insert(part, content);
      initialize(result);
      return result;
    }

    public class Insert extends YouTubeRequest<com.google.api.services.youtube.model.PlaylistItem> {

      private static final String REST_PATH = "youtube/v3/playlistItems";

      /**
       * Inserts a new resource into this collection.
       *
       * Create a request for the method "playlistItems.insert".
       *
       * This request holds the parameters needed by the the youtube server.  After setting any optional
       * parameters, call the {@link Insert#execute()} method to invoke the remote operation. <p> {@link
       * Insert#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param part The *part* parameter serves two purposes in this operation. It identifies the properties that the
     *        write operation will set as well as the properties that the API response will include.
       * @param content the {@link com.google.api.services.youtube.model.PlaylistItem}
       * @since 1.13
       */
      protected Insert(java.util.List<java.lang.String> part, com.google.api.services.youtube.model.PlaylistItem content) {
        super(YouTube.this, "POST", REST_PATH, content, com.google.api.services.youtube.model.PlaylistItem.class);
        this.part = com.google.api.client.util.Preconditions.checkNotNull(part, "Required parameter part must be specified.");
      }

      @Override
      public Insert set$Xgafv(java.lang.String $Xgafv) {
        return (Insert) super.set$Xgafv($Xgafv);
      }

      @Override
      public Insert setAccessToken(java.lang.String accessToken) {
        return (Insert) super.setAccessToken(accessToken);
      }

      @Override
      public Insert setAlt(java.lang.String alt) {
        return (Insert) super.setAlt(alt);
      }

      @Override
      public Insert setCallback(java.lang.String callback) {
        return (Insert) super.setCallback(callback);
      }

      @Override
      public Insert setFields(java.lang.String fields) {
        return (Insert) super.setFields(fields);
      }

      @Override
      public Insert setKey(java.lang.String key) {
        return (Insert) super.setKey(key);
      }

      @Override
      public Insert setOauthToken(java.lang.String oauthToken) {
        return (Insert) super.setOauthToken(oauthToken);
      }

      @Override
      public Insert setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Insert) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Insert setQuotaUser(java.lang.String quotaUser) {
        return (Insert) super.setQuotaUser(quotaUser);
      }

      @Override
      public Insert setUploadType(java.lang.String uploadType) {
        return (Insert) super.setUploadType(uploadType);
      }

      @Override
      public Insert setUploadProtocol(java.lang.String uploadProtocol) {
        return (Insert) super.setUploadProtocol(uploadProtocol);
      }

      /**
       * The *part* parameter serves two purposes in this operation. It identifies the properties
       * that the write operation will set as well as the properties that the API response will
       * include.
       */
      @com.google.api.client.util.Key
      private java.util.List<java.lang.String> part;

      /** The *part* parameter serves two purposes in this operation. It identifies the properties that the
     write operation will set as well as the properties that the API response will include.
       */
      public java.util.List<java.lang.String> getPart() {
        return part;
      }

      /**
       * The *part* parameter serves two purposes in this operation. It identifies the properties
       * that the write operation will set as well as the properties that the API response will
       * include.
       */
      public Insert setPart(java.util.List<java.lang.String> part) {
        this.part = part;
        return this;
      }

      /**
       * *Note:* This parameter is intended exclusively for YouTube content partners. The
       * *onBehalfOfContentOwner* parameter indicates that the request's authorization credentials
       * identify a YouTube CMS user who is acting on behalf of the content owner specified in the
       * parameter value. This parameter is intended for YouTube content partners that own and
       * manage many different YouTube channels. It allows content owners to authenticate once and
       * get access to all their video and channel data, without having to provide authentication
       * credentials for each individual channel. The CMS account that the user authenticates with
       * must be linked to the specified YouTube content owner.
       */
      @com.google.api.client.util.Key
      private java.lang.String onBehalfOfContentOwner;

      /*** Note:* This parameter is intended exclusively for YouTube content partners. The
    * *onBehalfOfContentOwner* parameter indicates that the request's authorization credentials identify
    * a YouTube CMS user who is acting on behalf of the content owner specified in the parameter value.
    * This parameter is intended for YouTube content partners that own and manage many different YouTube
    * channels. It allows content owners to authenticate once and get access to all their video and
    * channel data, without having to provide authentication credentials for each individual channel.
    * The CMS account that the user authenticates with must be linked to the specified YouTube content
    * owner.
    *

       */
      public java.lang.String getOnBehalfOfContentOwner() {
        return onBehalfOfContentOwner;
      }

      /**
       * *Note:* This parameter is intended exclusively for YouTube content partners. The
       * *onBehalfOfContentOwner* parameter indicates that the request's authorization credentials
       * identify a YouTube CMS user who is acting on behalf of the content owner specified in the
       * parameter value. This parameter is intended for YouTube content partners that own and
       * manage many different YouTube channels. It allows content owners to authenticate once and
       * get access to all their video and channel data, without having to provide authentication
       * credentials for each individual channel. The CMS account that the user authenticates with
       * must be linked to the specified YouTube content owner.
       */
      public Insert setOnBehalfOfContentOwner(java.lang.String onBehalfOfContentOwner) {
        this.onBehalfOfContentOwner = onBehalfOfContentOwner;
        return this;
      }

      @Override
      public Insert set(String parameterName, Object value) {
        return (Insert) super.set(parameterName, value);
      }
    }
    /**
     * Retrieves a list of resources, possibly filtered.
     *
     * Create a request for the method "playlistItems.list".
     *
     * This request holds the parameters needed by the youtube server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param part The *part* parameter specifies a comma-separated list of one or more playlistItem resource
     *        properties that the API response will include. If the parameter identifies a property that
     *        contains child properties, the child properties will be included in the response. For
     *        example, in a playlistItem resource, the snippet property contains numerous fields,
     *        including the title, description, position, and resourceId properties. As such, if you set
     *        *part=snippet*, the API response will contain all of those properties.
     * @return the request
     */
    public List list(java.util.List<java.lang.String> part) throws java.io.IOException {
      List result = new List(part);
      initialize(result);
      return result;
    }

    public class List extends YouTubeRequest<com.google.api.services.youtube.model.PlaylistItemListResponse> {

      private static final String REST_PATH = "youtube/v3/playlistItems";

      /**
       * Retrieves a list of resources, possibly filtered.
       *
       * Create a request for the method "playlistItems.list".
       *
       * This request holds the parameters needed by the the youtube server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param part The *part* parameter specifies a comma-separated list of one or more playlistItem resource
     *        properties that the API response will include. If the parameter identifies a property that
     *        contains child properties, the child properties will be included in the response. For
     *        example, in a playlistItem resource, the snippet property contains numerous fields,
     *        including the title, description, position, and resourceId properties. As such, if you set
     *        *part=snippet*, the API response will contain all of those properties.
       * @since 1.13
       */
      protected List(java.util.List<java.lang.String> part) {
        super(YouTube.this, "GET", REST_PATH, null, com.google.api.services.youtube.model.PlaylistItemListResponse.class);
        this.part = com.google.api.client.util.Preconditions.checkNotNull(part, "Required parameter part must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List set$Xgafv(java.lang.String $Xgafv) {
        return (List) super.set$Xgafv($Xgafv);
      }

      @Override
      public List setAccessToken(java.lang.String accessToken) {
        return (List) super.setAccessToken(accessToken);
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setCallback(java.lang.String callback) {
        return (List) super.setCallback(callback);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUploadType(java.lang.String uploadType) {
        return (List) super.setUploadType(uploadType);
      }

      @Override
      public List setUploadProtocol(java.lang.String uploadProtocol) {
        return (List) super.setUploadProtocol(uploadProtocol);
      }

      /**
       * The *part* parameter specifies a comma-separated list of one or more playlistItem resource
       * properties that the API response will include. If the parameter identifies a property that
       * contains child properties, the child properties will be included in the response. For
       * example, in a playlistItem resource, the snippet property contains numerous fields,
       * including the title, description, position, and resourceId properties. As such, if you set
       * *part=snippet*, the API response will contain all of those properties.
       */
      @com.google.api.client.util.Key
      private java.util.List<java.lang.String> part;

      /** The *part* parameter specifies a comma-separated list of one or more playlistItem resource
     properties that the API response will include. If the parameter identifies a property that contains
     child properties, the child properties will be included in the response. For example, in a
     playlistItem resource, the snippet property contains numerous fields, including the title,
     description, position, and resourceId properties. As such, if you set *part=snippet*, the API
     response will contain all of those properties.
       */
      public java.util.List<java.lang.String> getPart() {
        return part;
      }

      /**
       * The *part* parameter specifies a comma-separated list of one or more playlistItem resource
       * properties that the API response will include. If the parameter identifies a property that
       * contains child properties, the child properties will be included in the response. For
       * example, in a playlistItem resource, the snippet property contains numerous fields,
       * including the title, description, position, and resourceId properties. As such, if you set
       * *part=snippet*, the API response will contain all of those properties.
       */
      public List setPart(java.util.List<java.lang.String> part) {
        this.part = part;
        return this;
      }

      @com.google.api.client.util.Key
      private java.util.List<java.lang.String> id;

      /**

       */
      public java.util.List<java.lang.String> getId() {
        return id;
      }

      public List setId(java.util.List<java.lang.String> id) {
        this.id = id;
        return this;
      }

      /**
       * The *maxResults* parameter specifies the maximum number of items that should be returned in
       * the result set.
       */
      @com.google.api.client.util.Key
      private java.lang.Long maxResults;

      /** The *maxResults* parameter specifies the maximum number of items that should be returned in the
     result set. [default: 5] [minimum: 0] [maximum: 50]
       */
      public java.lang.Long getMaxResults() {
        return maxResults;
      }

      /**
       * The *maxResults* parameter specifies the maximum number of items that should be returned in
       * the result set.
       */
      public List setMaxResults(java.lang.Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      /**
       * *Note:* This parameter is intended exclusively for YouTube content partners. The
       * *onBehalfOfContentOwner* parameter indicates that the request's authorization credentials
       * identify a YouTube CMS user who is acting on behalf of the content owner specified in the
       * parameter value. This parameter is intended for YouTube content partners that own and
       * manage many different YouTube channels. It allows content owners to authenticate once and
       * get access to all their video and channel data, without having to provide authentication
       * credentials for each individual channel. The CMS account that the user authenticates with
       * must be linked to the specified YouTube content owner.
       */
      @com.google.api.client.util.Key
      private java.lang.String onBehalfOfContentOwner;

      /*** Note:* This parameter is intended exclusively for YouTube content partners. The
    * *onBehalfOfContentOwner* parameter indicates that the request's authorization credentials identify
    * a YouTube CMS user who is acting on behalf of the content owner specified in the parameter value.
    * This parameter is intended for YouTube content partners that own and manage many different YouTube
    * channels. It allows content owners to authenticate once and get access to all their video and
    * channel data, without having to provide authentication credentials for each individual channel.
    * The CMS account that the user authenticates with must be linked to the specified YouTube content
    * owner.
    *

       */
      public java.lang.String getOnBehalfOfContentOwner() {
        return onBehalfOfContentOwner;
      }

      /**
       * *Note:* This parameter is intended exclusively for YouTube content partners. The
       * *onBehalfOfContentOwner* parameter indicates that the request's authorization credentials
       * identify a YouTube CMS user who is acting on behalf of the content owner specified in the
       * parameter value. This parameter is intended for YouTube content partners that own and
       * manage many different YouTube channels. It allows content owners to authenticate once and
       * get access to all their video and channel data, without having to provide authentication
       * credentials for each individual channel. The CMS account that the user authenticates with
       * must be linked to the specified YouTube content owner.
       */
      public List setOnBehalfOfContentOwner(java.lang.String onBehalfOfContentOwner) {
        this.onBehalfOfContentOwner = onBehalfOfContentOwner;
        return this;
      }

      /**
       * The *pageToken* parameter identifies a specific page in the result set that should be
       * returned. In an API response, the nextPageToken and prevPageToken properties identify other
       * pages that could be retrieved.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** The *pageToken* parameter identifies a specific page in the result set that should be returned. In
     an API response, the nextPageToken and prevPageToken properties identify other pages that could be
     retrieved.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * The *pageToken* parameter identifies a specific page in the result set that should be
       * returned. In an API response, the nextPageToken and prevPageToken properties identify other
       * pages that could be retrieved.
       */
      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      /** Return the playlist items within the given playlist. */
      @com.google.api.client.util.Key
      private java.lang.String playlistId;

      /** Return the playlist items within the given playlist.
       */
      public java.lang.String getPlaylistId() {
        return playlistId;
      }

      /** Return the playlist items within the given playlist. */
      public List setPlaylistId(java.lang.String playlistId) {
        this.playlistId = playlistId;
        return this;
      }

      /** Return the playlist items associated with the given video ID. */
      @com.google.api.client.util.Key
      private java.lang.String videoId;

      /** Return the playlist items associated with the given video ID.
       */
      public java.lang.String getVideoId() {
        return videoId;
      }

      /** Return the playlist items associated with the given video ID. */
      public List setVideoId(java.lang.String videoId) {
        this.videoId = videoId;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }
    /**
     * Updates an existing resource.
     *
     * Create a request for the method "playlistItems.update".
     *
     * This request holds the parameters needed by the youtube server.  After setting any optional
     * parameters, call the {@link Update#execute()} method to invoke the remote operation.
     *
     * @param part The *part* parameter serves two purposes in this operation. It identifies the properties that the
     *        write operation will set as well as the properties that the API response will include.
     *        Note that this method will override the existing values for all of the mutable properties
     *        that are contained in any parts that the parameter value specifies. For example, a
     *        playlist item can specify a start time and end time, which identify the times portion of
     *        the video that should play when users watch the video in the playlist. If your request is
     *        updating a playlist item that sets these values, and the request's part parameter value
     *        includes the contentDetails part, the playlist item's start and end times will be updated
     *        to whatever value the request body specifies. If the request body does not specify values,
     *        the existing start and end times will be removed and replaced with the default settings.
     * @param content the {@link com.google.api.services.youtube.model.PlaylistItem}
     * @return the request
     */
    public Update update(java.util.List<java.lang.String> part, com.google.api.services.youtube.model.PlaylistItem content) throws java.io.IOException {
      Update result = new Update(part, content);
      initialize(result);
      return result;
    }

    public class Update extends YouTubeRequest<com.google.api.services.youtube.model.PlaylistItem> {

      private static final String REST_PATH = "youtube/v3/playlistItems";

      /**
       * Updates an existing resource.
       *
       * Create a request for the method "playlistItems.update".
       *
       * This request holds the parameters needed by the the youtube server.  After setting any optional
       * parameters, call the {@link Update#execute()} method to invoke the remote operation. <p> {@link
       * Update#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param part The *part* parameter serves two purposes in this operation. It identifies the properties that the
     *        write operation will set as well as the properties that the API response will include.
     *        Note that this method will override the existing values for all of the mutable properties
     *        that are contained in any parts that the parameter value specifies. For example, a
     *        playlist item can specify a start time and end time, which identify the times portion of
     *        the video that should play when users watch the video in the playlist. If your request is
     *        updating a playlist item that sets these values, and the request's part parameter value
     *        includes the contentDetails part, the playlist item's start and end times will be updated
     *        to whatever value the request body specifies. If the request body does not specify values,
     *        the existing start and end times will be removed and replaced with the default settings.
       * @param content the {@link com.google.api.services.youtube.model.PlaylistItem}
       * @since 1.13
       */
      protected Update(java.util.List<java.lang.String> part, com.google.api.services.youtube.model.PlaylistItem content) {
        super(YouTube.this, "PUT", REST_PATH, content, com.google.api.services.youtube.model.PlaylistItem.class);
        this.part = com.google.api.client.util.Preconditions.checkNotNull(part, "Required parameter part must be specified.");
      }

      @Override
      public Update set$Xgafv(java.lang.String $Xgafv) {
        return (Update) super.set$Xgafv($Xgafv);
      }

      @Override
      public Update setAccessToken(java.lang.String accessToken) {
        return (Update) super.setAccessToken(accessToken);
      }

      @Override
      public Update setAlt(java.lang.String alt) {
        return (Update) super.setAlt(alt);
      }

      @Override
      public Update setCallback(java.lang.String callback) {
        return (Update) super.setCallback(callback);
      }

      @Override
      public Update setFields(java.lang.String fields) {
        return (Update) super.setFields(fields);
      }

      @Override
      public Update setKey(java.lang.String key) {
        return (Update) super.setKey(key);
      }

      @Override
      public Update setOauthToken(java.lang.String oauthToken) {
        return (Update) super.setOauthToken(oauthToken);
      }

      @Override
      public Update setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Update) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Update setQuotaUser(java.lang.String quotaUser) {
        return (Update) super.setQuotaUser(quotaUser);
      }

      @Override
      public Update setUploadType(java.lang.String uploadType) {
        return (Update) super.setUploadType(uploadType);
      }

      @Override
      public Update setUploadProtocol(java.lang.String uploadProtocol) {
        return (Update) super.setUploadProtocol(uploadProtocol);
      }

      /**
       * The *part* parameter serves two purposes in this operation. It identifies the properties
       * that the write operation will set as well as the properties that the API response will
       * include. Note that this method will override the existing values for all of the mutable
       * properties that are contained in any parts that the parameter value specifies. For example,
       * a playlist item can specify a start time and end time, which identify the times portion of
       * the video that should play when users watch the video in the playlist. If your request is
       * updating a playlist item that sets these values, and the request's part parameter value
       * includes the contentDetails part, the playlist item's start and end times will be updated
       * to whatever value the request body specifies. If the request body does not specify values,
       * the existing start and end times will be removed and replaced with the default settings.
       */
      @com.google.api.client.util.Key
      private java.util.List<java.lang.String> part;

      /** The *part* parameter serves two purposes in this operation. It identifies the properties that the
     write operation will set as well as the properties that the API response will include. Note that
     this method will override the existing values for all of the mutable properties that are contained
     in any parts that the parameter value specifies. For example, a playlist item can specify a start
     time and end time, which identify the times portion of the video that should play when users watch
     the video in the playlist. If your request is updating a playlist item that sets these values, and
     the request's part parameter value includes the contentDetails part, the playlist item's start and
     end times will be updated to whatever value the request body specifies. If the request body does
     not specify values, the existing start and end times will be removed and replaced with the default
     settings.
       */
      public java.util.List<java.lang.String> getPart() {
        return part;
      }

      /**
       * The *part* parameter serves two purposes in this operation. It identifies the properties
       * that the write operation will set as well as the properties that the API response will
       * include. Note that this method will override the existing values for all of the mutable
       * properties that are contained in any parts that the parameter value specifies. For example,
       * a playlist item can specify a start time and end time, which identify the times portion of
       * the video that should play when users watch the video in the playlist. If your request is
       * updating a playlist item that sets these values, and the request's part parameter value
       * includes the contentDetails part, the playlist item's start and end times will be updated
       * to whatever value the request body specifies. If the request body does not specify values,
       * the existing start and end times will be removed and replaced with the default settings.
       */
      public Update setPart(java.util.List<java.lang.String> part) {
        this.part = part;
        return this;
      }

      /**
       * *Note:* This parameter is intended exclusively for YouTube content partners. The
       * *onBehalfOfContentOwner* parameter indicates that the request's authorization credentials
       * identify a YouTube CMS user who is acting on behalf of the content owner specified in the
       * parameter value. This parameter is intended for YouTube content partners that own and
       * manage many different YouTube channels. It allows content owners to authenticate once and
       * get access to all their video and channel data, without having to provide authentication
       * credentials for each individual channel. The CMS account that the user authenticates with
       * must be linked to the specified YouTube content owner.
       */
      @com.google.api.client.util.Key
      private java.lang.String onBehalfOfContentOwner;

      /*** Note:* This parameter is intended exclusively for YouTube content partners. The
    * *onBehalfOfContentOwner* parameter indicates that the request's authorization credentials identify
    * a YouTube CMS user who is acting on behalf of the content owner specified in the parameter value.
    * This parameter is intended for YouTube content partners that own and manage many different YouTube
    * channels. It allows content owners to authenticate once and get access to all their video and
    * channel data, without having to provide authentication credentials for each individual channel.
    * The CMS account that the user authenticates with must be linked to the specified YouTube content
    * owner.
    *

       */
      public java.lang.String getOnBehalfOfContentOwner() {
        return onBehalfOfContentOwner;
      }

      /**
       * *Note:* This parameter is intended exclusively for YouTube content partners. The
       * *onBehalfOfContentOwner* parameter indicates that the request's authorization credentials
       * identify a YouTube CMS user who is acting on behalf of the content owner specified in the
       * parameter value. This parameter is intended for YouTube content partners that own and
       * manage many different YouTube channels. It allows content owners to authenticate once and
       * get access to all their video and channel data, without having to provide authentication
       * credentials for each individual channel. The CMS account that the user authenticates with
       * must be linked to the specified YouTube content owner.
       */
      public Update setOnBehalfOfContentOwner(java.lang.String onBehalfOfContentOwner) {
        this.onBehalfOfContentOwner = onBehalfOfContentOwner;
        return this;
      }

      @Override
      public Update set(String parameterName, Object value) {
        return (Update) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the Playlists collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code YouTube youtube = new YouTube(...);}
   *   {@code YouTube.Playlists.List request = youtube.playlists().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Playlists playlists() {
    return new Playlists();
  }

  /**
   * The "playlists" collection of methods.
   */
  public class Playlists {

    /**
     * Deletes a resource.
     *
     * Create a request for the method "playlists.delete".
     *
     * This request holds the parameters needed by the youtube server.  After setting any optional
     * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
     *
     * @param id
     * @return the request
     */
    public Delete delete(java.lang.String id) throws java.io.IOException {
      Delete result = new Delete(id);
      initialize(result);
      return result;
    }

    public class Delete extends YouTubeRequest<Void> {

      private static final String REST_PATH = "youtube/v3/playlists";

      /**
       * Deletes a resource.
       *
       * Create a request for the method "playlists.delete".
       *
       * This request holds the parameters needed by the the youtube server.  After setting any optional
       * parameters, call the {@link Delete#execute()} method to invoke the remote operation. <p> {@link
       * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param id
       * @since 1.13
       */
      protected Delete(java.lang.String id) {
        super(YouTube.this, "DELETE", REST_PATH, null, Void.class);
        this.id = com.google.api.client.util.Preconditions.checkNotNull(id, "Required parameter id must be specified.");
      }

      @Override
      public Delete set$Xgafv(java.lang.String $Xgafv) {
        return (Delete) super.set$Xgafv($Xgafv);
      }

      @Override
      public Delete setAccessToken(java.lang.String accessToken) {
        return (Delete) super.setAccessToken(accessToken);
      }

      @Override
      public Delete setAlt(java.lang.String alt) {
        return (Delete) super.setAlt(alt);
      }

      @Override
      public Delete setCallback(java.lang.String callback) {
        return (Delete) super.setCallback(callback);
      }

      @Override
      public Delete setFields(java.lang.String fields) {
        return (Delete) super.setFields(fields);
      }

      @Override
      public Delete setKey(java.lang.String key) {
        return (Delete) super.setKey(key);
      }

      @Override
      public Delete setOauthToken(java.lang.String oauthToken) {
        return (Delete) super.setOauthToken(oauthToken);
      }

      @Override
      public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Delete) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Delete setQuotaUser(java.lang.String quotaUser) {
        return (Delete) super.setQuotaUser(quotaUser);
      }

      @Override
      public Delete setUploadType(java.lang.String uploadType) {
        return (Delete) super.setUploadType(uploadType);
      }

      @Override
      public Delete setUploadProtocol(java.lang.String uploadProtocol) {
        return (Delete) super.setUploadProtocol(uploadProtocol);
      }

      @com.google.api.client.util.Key
      private java.lang.String id;

      /**

       */
      public java.lang.String getId() {
        return id;
      }

      public Delete setId(java.lang.String id) {
        this.id = id;
        return this;
      }

      /**
       * *Note:* This parameter is intended exclusively for YouTube content partners. The
       * *onBehalfOfContentOwner* parameter indicates that the request's authorization credentials
       * identify a YouTube CMS user who is acting on behalf of the content owner specified in the
       * parameter value. This parameter is intended for YouTube content partners that own and
       * manage many different YouTube channels. It allows content owners to authenticate once and
       * get access to all their video and channel data, without having to provide authentication
       * credentials for each individual channel. The CMS account that the user authenticates with
       * must be linked to the specified YouTube content owner.
       */
      @com.google.api.client.util.Key
      private java.lang.String onBehalfOfContentOwner;

      /*** Note:* This parameter is intended exclusively for YouTube content partners. The
    * *onBehalfOfContentOwner* parameter indicates that the request's authorization credentials identify
    * a YouTube CMS user who is acting on behalf of the content owner specified in the parameter value.
    * This parameter is intended for YouTube content partners that own and manage many different YouTube
    * channels. It allows content owners to authenticate once and get access to all their video and
    * channel data, without having to provide authentication credentials for each individual channel.
    * The CMS account that the user authenticates with must be linked to the specified YouTube content
    * owner.
    *

       */
      public java.lang.String getOnBehalfOfContentOwner() {
        return onBehalfOfContentOwner;
      }

      /**
       * *Note:* This parameter is intended exclusively for YouTube content partners. The
       * *onBehalfOfContentOwner* parameter indicates that the request's authorization credentials
       * identify a YouTube CMS user who is acting on behalf of the content owner specified in the
       * parameter value. This parameter is intended for YouTube content partners that own and
       * manage many different YouTube channels. It allows content owners to authenticate once and
       * get access to all their video and channel data, without having to provide authentication
       * credentials for each individual channel. The CMS account that the user authenticates with
       * must be linked to the specified YouTube content owner.
       */
      public Delete setOnBehalfOfContentOwner(java.lang.String onBehalfOfContentOwner) {
        this.onBehalfOfContentOwner = onBehalfOfContentOwner;
        return this;
      }

      @Override
      public Delete set(String parameterName, Object value) {
        return (Delete) super.set(parameterName, value);
      }
    }
    /**
     * Inserts a new resource into this collection.
     *
     * Create a request for the method "playlists.insert".
     *
     * This request holds the parameters needed by the youtube server.  After setting any optional
     * parameters, call the {@link Insert#execute()} method to invoke the remote operation.
     *
     * @param part The *part* parameter serves two purposes in this operation. It identifies the properties that the
     *        write operation will set as well as the properties that the API response will include.
     * @param content the {@link com.google.api.services.youtube.model.Playlist}
     * @return the request
     */
    public Insert insert(java.util.List<java.lang.String> part, com.google.api.services.youtube.model.Playlist content) throws java.io.IOException {
      Insert result = new Insert(part, content);
      initialize(result);
      return result;
    }

    public class Insert extends YouTubeRequest<com.google.api.services.youtube.model.Playlist> {

      private static final String REST_PATH = "youtube/v3/playlists";

      /**
       * Inserts a new resource into this collection.
       *
       * Create a request for the method "playlists.insert".
       *
       * This request holds the parameters needed by the the youtube server.  After setting any optional
       * parameters, call the {@link Insert#execute()} method to invoke the remote operation. <p> {@link
       * Insert#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param part The *part* parameter serves two purposes in this operation. It identifies the properties that the
     *        write operation will set as well as the properties that the API response will include.
       * @param content the {@link com.google.api.services.youtube.model.Playlist}
       * @since 1.13
       */
      protected Insert(java.util.List<java.lang.String> part, com.google.api.services.youtube.model.Playlist content) {
        super(YouTube.this, "POST", REST_PATH, content, com.google.api.services.youtube.model.Playlist.class);
        this.part = com.google.api.client.util.Preconditions.checkNotNull(part, "Required parameter part must be specified.");
      }

      @Override
      public Insert set$Xgafv(java.lang.String $Xgafv) {
        return (Insert) super.set$Xgafv($Xgafv);
      }

      @Override
      public Insert setAccessToken(java.lang.String accessToken) {
        return (Insert) super.setAccessToken(accessToken);
      }

      @Override
      public Insert setAlt(java.lang.String alt) {
        return (Insert) super.setAlt(alt);
      }

      @Override
      public Insert setCallback(java.lang.String callback) {
        return (Insert) super.setCallback(callback);
      }

      @Override
      public Insert setFields(java.lang.String fields) {
        return (Insert) super.setFields(fields);
      }

      @Override
      public Insert setKey(java.lang.String key) {
        return (Insert) super.setKey(key);
      }

      @Override
      public Insert setOauthToken(java.lang.String oauthToken) {
        return (Insert) super.setOauthToken(oauthToken);
      }

      @Override
      public Insert setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Insert) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Insert setQuotaUser(java.lang.String quotaUser) {
        return (Insert) super.setQuotaUser(quotaUser);
      }

      @Override
      public Insert setUploadType(java.lang.String uploadType) {
        return (Insert) super.setUploadType(uploadType);
      }

      @Override
      public Insert setUploadProtocol(java.lang.String uploadProtocol) {
        return (Insert) super.setUploadProtocol(uploadProtocol);
      }

      /**
       * The *part* parameter serves two purposes in this operation. It identifies the properties
       * that the write operation will set as well as the properties that the API response will
       * include.
       */
      @com.google.api.client.util.Key
      private java.util.List<java.lang.String> part;

      /** The *part* parameter serves two purposes in this operation. It identifies the properties that the
     write operation will set as well as the properties that the API response will include.
       */
      public java.util.List<java.lang.String> getPart() {
        return part;
      }

      /**
       * The *part* parameter serves two purposes in this operation. It identifies the properties
       * that the write operation will set as well as the properties that the API response will
       * include.
       */
      public Insert setPart(java.util.List<java.lang.String> part) {
        this.part = part;
        return this;
      }

      /**
       * *Note:* This parameter is intended exclusively for YouTube content partners. The
       * *onBehalfOfContentOwner* parameter indicates that the request's authorization credentials
       * identify a YouTube CMS user who is acting on behalf of the content owner specified in the
       * parameter value. This parameter is intended for YouTube content partners that own and
       * manage many different YouTube channels. It allows content owners to authenticate once and
       * get access to all their video and channel data, without having to provide authentication
       * credentials for each individual channel. The CMS account that the user authenticates with
       * must be linked to the specified YouTube content owner.
       */
      @com.google.api.client.util.Key
      private java.lang.String onBehalfOfContentOwner;

      /*** Note:* This parameter is intended exclusively for YouTube content partners. The
    * *onBehalfOfContentOwner* parameter indicates that the request's authorization credentials identify
    * a YouTube CMS user who is acting on behalf of the content owner specified in the parameter value.
    * This parameter is intended for YouTube content partners that own and manage many different YouTube
    * channels. It allows content owners to authenticate once and get access to all their video and
    * channel data, without having to provide authentication credentials for each individual channel.
    * The CMS account that the user authenticates with must be linked to the specified YouTube content
    * owner.
    *

       */
      public java.lang.String getOnBehalfOfContentOwner() {
        return onBehalfOfContentOwner;
      }

      /**
       * *Note:* This parameter is intended exclusively for YouTube content partners. The
       * *onBehalfOfContentOwner* parameter indicates that the request's authorization credentials
       * identify a YouTube CMS user who is acting on behalf of the content owner specified in the
       * parameter value. This parameter is intended for YouTube content partners that own and
       * manage many different YouTube channels. It allows content owners to authenticate once and
       * get access to all their video and channel data, without having to provide authentication
       * credentials for each individual channel. The CMS account that the user authenticates with
       * must be linked to the specified YouTube content owner.
       */
      public Insert setOnBehalfOfContentOwner(java.lang.String onBehalfOfContentOwner) {
        this.onBehalfOfContentOwner = onBehalfOfContentOwner;
        return this;
      }

      /**
       * This parameter can only be used in a properly authorized request. *Note:* This parameter is
       * intended exclusively for YouTube content partners. The *onBehalfOfContentOwnerChannel*
       * parameter specifies the YouTube channel ID of the channel to which a video is being added.
       * This parameter is required when a request specifies a value for the onBehalfOfContentOwner
       * parameter, and it can only be used in conjunction with that parameter. In addition, the
       * request must be authorized using a CMS account that is linked to the content owner that the
       * onBehalfOfContentOwner parameter specifies. Finally, the channel that the
       * onBehalfOfContentOwnerChannel parameter value specifies must be linked to the content owner
       * that the onBehalfOfContentOwner parameter specifies. This parameter is intended for YouTube
       * content partners that own and manage many different YouTube channels. It allows content
       * owners to authenticate once and perform actions on behalf of the channel specified in the
       * parameter value, without having to provide authentication credentials for each separate
       * channel.
       */
      @com.google.api.client.util.Key
      private java.lang.String onBehalfOfContentOwnerChannel;

      /** This parameter can only be used in a properly authorized request. *Note:* This parameter is
     intended exclusively for YouTube content partners. The *onBehalfOfContentOwnerChannel* parameter
     specifies the YouTube channel ID of the channel to which a video is being added. This parameter is
     required when a request specifies a value for the onBehalfOfContentOwner parameter, and it can only
     be used in conjunction with that parameter. In addition, the request must be authorized using a CMS
     account that is linked to the content owner that the onBehalfOfContentOwner parameter specifies.
     Finally, the channel that the onBehalfOfContentOwnerChannel parameter value specifies must be
     linked to the content owner that the onBehalfOfContentOwner parameter specifies. This parameter is
     intended for YouTube content partners that own and manage many different YouTube channels. It
     allows content owners to authenticate once and perform actions on behalf of the channel specified
     in the parameter value, without having to provide authentication credentials for each separate
     channel.
       */
      public java.lang.String getOnBehalfOfContentOwnerChannel() {
        return onBehalfOfContentOwnerChannel;
      }

      /**
       * This parameter can only be used in a properly authorized request. *Note:* This parameter is
       * intended exclusively for YouTube content partners. The *onBehalfOfContentOwnerChannel*
       * parameter specifies the YouTube channel ID of the channel to which a video is being added.
       * This parameter is required when a request specifies a value for the onBehalfOfContentOwner
       * parameter, and it can only be used in conjunction with that parameter. In addition, the
       * request must be authorized using a CMS account that is linked to the content owner that the
       * onBehalfOfContentOwner parameter specifies. Finally, the channel that the
       * onBehalfOfContentOwnerChannel parameter value specifies must be linked to the content owner
       * that the onBehalfOfContentOwner parameter specifies. This parameter is intended for YouTube
       * content partners that own and manage many different YouTube channels. It allows content
       * owners to authenticate once and perform actions on behalf of the channel specified in the
       * parameter value, without having to provide authentication credentials for each separate
       * channel.
       */
      public Insert setOnBehalfOfContentOwnerChannel(java.lang.String onBehalfOfContentOwnerChannel) {
        this.onBehalfOfContentOwnerChannel = onBehalfOfContentOwnerChannel;
        return this;
      }

      @Override
      public Insert set(String parameterName, Object value) {
        return (Insert) super.set(parameterName, value);
      }
    }
    /**
     * Retrieves a list of resources, possibly filtered.
     *
     * Create a request for the method "playlists.list".
     *
     * This request holds the parameters needed by the youtube server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param part The *part* parameter specifies a comma-separated list of one or more playlist resource properties
     *        that the API response will include. If the parameter identifies a property that contains
     *        child properties, the child properties will be included in the response. For example, in a
     *        playlist resource, the snippet property contains properties like author, title,
     *        description, tags, and timeCreated. As such, if you set *part=snippet*, the API response
     *        will contain all of those properties.
     * @return the request
     */
    public List list(java.util.List<java.lang.String> part) throws java.io.IOException {
      List result = new List(part);
      initialize(result);
      return result;
    }

    public class List extends YouTubeRequest<com.google.api.services.youtube.model.PlaylistListResponse> {

      private static final String REST_PATH = "youtube/v3/playlists";

      /**
       * Retrieves a list of resources, possibly filtered.
       *
       * Create a request for the method "playlists.list".
       *
       * This request holds the parameters needed by the the youtube server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param part The *part* parameter specifies a comma-separated list of one or more playlist resource properties
     *        that the API response will include. If the parameter identifies a property that contains
     *        child properties, the child properties will be included in the response. For example, in a
     *        playlist resource, the snippet property contains properties like author, title,
     *        description, tags, and timeCreated. As such, if you set *part=snippet*, the API response
     *        will contain all of those properties.
       * @since 1.13
       */
      protected List(java.util.List<java.lang.String> part) {
        super(YouTube.this, "GET", REST_PATH, null, com.google.api.services.youtube.model.PlaylistListResponse.class);
        this.part = com.google.api.client.util.Preconditions.checkNotNull(part, "Required parameter part must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List set$Xgafv(java.lang.String $Xgafv) {
        return (List) super.set$Xgafv($Xgafv);
      }

      @Override
      public List setAccessToken(java.lang.String accessToken) {
        return (List) super.setAccessToken(accessToken);
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setCallback(java.lang.String callback) {
        return (List) super.setCallback(callback);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUploadType(java.lang.String uploadType) {
        return (List) super.setUploadType(uploadType);
      }

      @Override
      public List setUploadProtocol(java.lang.String uploadProtocol) {
        return (List) super.setUploadProtocol(uploadProtocol);
      }

      /**
       * The *part* parameter specifies a comma-separated list of one or more playlist resource
       * properties that the API response will include. If the parameter identifies a property that
       * contains child properties, the child properties will be included in the response. For
       * example, in a playlist resource, the snippet property contains properties like author,
       * title, description, tags, and timeCreated. As such, if you set *part=snippet*, the API
       * response will contain all of those properties.
       */
      @com.google.api.client.util.Key
      private java.util.List<java.lang.String> part;

      /** The *part* parameter specifies a comma-separated list of one or more playlist resource properties
     that the API response will include. If the parameter identifies a property that contains child
     properties, the child properties will be included in the response. For example, in a playlist
     resource, the snippet property contains properties like author, title, description, tags, and
     timeCreated. As such, if you set *part=snippet*, the API response will contain all of those
     properties.
       */
      public java.util.List<java.lang.String> getPart() {
        return part;
      }

      /**
       * The *part* parameter specifies a comma-separated list of one or more playlist resource
       * properties that the API response will include. If the parameter identifies a property that
       * contains child properties, the child properties will be included in the response. For
       * example, in a playlist resource, the snippet property contains properties like author,
       * title, description, tags, and timeCreated. As such, if you set *part=snippet*, the API
       * response will contain all of those properties.
       */
      public List setPart(java.util.List<java.lang.String> part) {
        this.part = part;
        return this;
      }

      /** Return the playlists owned by the specified channel ID. */
      @com.google.api.client.util.Key
      private java.lang.String channelId;

      /** Return the playlists owned by the specified channel ID.
       */
      public java.lang.String getChannelId() {
        return channelId;
      }

      /** Return the playlists owned by the specified channel ID. */
      public List setChannelId(java.lang.String channelId) {
        this.channelId = channelId;
        return this;
      }

      /** Returen content in specified language */
      @com.google.api.client.util.Key
      private java.lang.String hl;

      /** Returen content in specified language
       */
      public java.lang.String getHl() {
        return hl;
      }

      /** Returen content in specified language */
      public List setHl(java.lang.String hl) {
        this.hl = hl;
        return this;
      }

      /** Return the playlists with the given IDs for Stubby or Apiary. */
      @com.google.api.client.util.Key
      private java.util.List<java.lang.String> id;

      /** Return the playlists with the given IDs for Stubby or Apiary.
       */
      public java.util.List<java.lang.String> getId() {
        return id;
      }

      /** Return the playlists with the given IDs for Stubby or Apiary. */
      public List setId(java.util.List<java.lang.String> id) {
        this.id = id;
        return this;
      }

      /**
       * The *maxResults* parameter specifies the maximum number of items that should be returned in
       * the result set.
       */
      @com.google.api.client.util.Key
      private java.lang.Long maxResults;

      /** The *maxResults* parameter specifies the maximum number of items that should be returned in the
     result set. [default: 5] [minimum: 0] [maximum: 50]
       */
      public java.lang.Long getMaxResults() {
        return maxResults;
      }

      /**
       * The *maxResults* parameter specifies the maximum number of items that should be returned in
       * the result set.
       */
      public List setMaxResults(java.lang.Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      /** Return the playlists owned by the authenticated user. */
      @com.google.api.client.util.Key
      private java.lang.Boolean mine;

      /** Return the playlists owned by the authenticated user.
       */
      public java.lang.Boolean getMine() {
        return mine;
      }

      /** Return the playlists owned by the authenticated user. */
      public List setMine(java.lang.Boolean mine) {
        this.mine = mine;
        return this;
      }

      /**
       * *Note:* This parameter is intended exclusively for YouTube content partners. The
       * *onBehalfOfContentOwner* parameter indicates that the request's authorization credentials
       * identify a YouTube CMS user who is acting on behalf of the content owner specified in the
       * parameter value. This parameter is intended for YouTube content partners that own and
       * manage many different YouTube channels. It allows content owners to authenticate once and
       * get access to all their video and channel data, without having to provide authentication
       * credentials for each individual channel. The CMS account that the user authenticates with
       * must be linked to the specified YouTube content owner.
       */
      @com.google.api.client.util.Key
      private java.lang.String onBehalfOfContentOwner;

      /*** Note:* This parameter is intended exclusively for YouTube content partners. The
    * *onBehalfOfContentOwner* parameter indicates that the request's authorization credentials identify
    * a YouTube CMS user who is acting on behalf of the content owner specified in the parameter value.
    * This parameter is intended for YouTube content partners that own and manage many different YouTube
    * channels. It allows content owners to authenticate once and get access to all their video and
    * channel data, without having to provide authentication credentials for each individual channel.
    * The CMS account that the user authenticates with must be linked to the specified YouTube content
    * owner.
    *

       */
      public java.lang.String getOnBehalfOfContentOwner() {
        return onBehalfOfContentOwner;
      }

      /**
       * *Note:* This parameter is intended exclusively for YouTube content partners. The
       * *onBehalfOfContentOwner* parameter indicates that the request's authorization credentials
       * identify a YouTube CMS user who is acting on behalf of the content owner specified in the
       * parameter value. This parameter is intended for YouTube content partners that own and
       * manage many different YouTube channels. It allows content owners to authenticate once and
       * get access to all their video and channel data, without having to provide authentication
       * credentials for each individual channel. The CMS account that the user authenticates with
       * must be linked to the specified YouTube content owner.
       */
      public List setOnBehalfOfContentOwner(java.lang.String onBehalfOfContentOwner) {
        this.onBehalfOfContentOwner = onBehalfOfContentOwner;
        return this;
      }

      /**
       * This parameter can only be used in a properly authorized request. *Note:* This parameter is
       * intended exclusively for YouTube content partners. The *onBehalfOfContentOwnerChannel*
       * parameter specifies the YouTube channel ID of the channel to which a video is being added.
       * This parameter is required when a request specifies a value for the onBehalfOfContentOwner
       * parameter, and it can only be used in conjunction with that parameter. In addition, the
       * request must be authorized using a CMS account that is linked to the content owner that the
       * onBehalfOfContentOwner parameter specifies. Finally, the channel that the
       * onBehalfOfContentOwnerChannel parameter value specifies must be linked to the content owner
       * that the onBehalfOfContentOwner parameter specifies. This parameter is intended for YouTube
       * content partners that own and manage many different YouTube channels. It allows content
       * owners to authenticate once and perform actions on behalf of the channel specified in the
       * parameter value, without having to provide authentication credentials for each separate
       * channel.
       */
      @com.google.api.client.util.Key
      private java.lang.String onBehalfOfContentOwnerChannel;

      /** This parameter can only be used in a properly authorized request. *Note:* This parameter is
     intended exclusively for YouTube content partners. The *onBehalfOfContentOwnerChannel* parameter
     specifies the YouTube channel ID of the channel to which a video is being added. This parameter is
     required when a request specifies a value for the onBehalfOfContentOwner parameter, and it can only
     be used in conjunction with that parameter. In addition, the request must be authorized using a CMS
     account that is linked to the content owner that the onBehalfOfContentOwner parameter specifies.
     Finally, the channel that the onBehalfOfContentOwnerChannel parameter value specifies must be
     linked to the content owner that the onBehalfOfContentOwner parameter specifies. This parameter is
     intended for YouTube content partners that own and manage many different YouTube channels. It
     allows content owners to authenticate once and perform actions on behalf of the channel specified
     in the parameter value, without having to provide authentication credentials for each separate
     channel.
       */
      public java.lang.String getOnBehalfOfContentOwnerChannel() {
        return onBehalfOfContentOwnerChannel;
      }

      /**
       * This parameter can only be used in a properly authorized request. *Note:* This parameter is
       * intended exclusively for YouTube content partners. The *onBehalfOfContentOwnerChannel*
       * parameter specifies the YouTube channel ID of the channel to which a video is being added.
       * This parameter is required when a request specifies a value for the onBehalfOfContentOwner
       * parameter, and it can only be used in conjunction with that parameter. In addition, the
       * request must be authorized using a CMS account that is linked to the content owner that the
       * onBehalfOfContentOwner parameter specifies. Finally, the channel that the
       * onBehalfOfContentOwnerChannel parameter value specifies must be linked to the content owner
       * that the onBehalfOfContentOwner parameter specifies. This parameter is intended for YouTube
       * content partners that own and manage many different YouTube channels. It allows content
       * owners to authenticate once and perform actions on behalf of the channel specified in the
       * parameter value, without having to provide authentication credentials for each separate
       * channel.
       */
      public List setOnBehalfOfContentOwnerChannel(java.lang.String onBehalfOfContentOwnerChannel) {
        this.onBehalfOfContentOwnerChannel = onBehalfOfContentOwnerChannel;
        return this;
      }

      /**
       * The *pageToken* parameter identifies a specific page in the result set that should be
       * returned. In an API response, the nextPageToken and prevPageToken properties identify other
       * pages that could be retrieved.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** The *pageToken* parameter identifies a specific page in the result set that should be returned. In
     an API response, the nextPageToken and prevPageToken properties identify other pages that could be
     retrieved.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * The *pageToken* parameter identifies a specific page in the result set that should be
       * returned. In an API response, the nextPageToken and prevPageToken properties identify other
       * pages that could be retrieved.
       */
      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }
    /**
     * Updates an existing resource.
     *
     * Create a request for the method "playlists.update".
     *
     * This request holds the parameters needed by the youtube server.  After setting any optional
     * parameters, call the {@link Update#execute()} method to invoke the remote operation.
     *
     * @param part The *part* parameter serves two purposes in this operation. It identifies the properties that the
     *        write operation will set as well as the properties that the API response will include.
     *        Note that this method will override the existing values for mutable properties that are
     *        contained in any parts that the request body specifies. For example, a playlist's
     *        description is contained in the snippet part, which must be included in the request body.
     *        If the request does not specify a value for the snippet.description property, the
     *        playlist's existing description will be deleted.
     * @param content the {@link com.google.api.services.youtube.model.Playlist}
     * @return the request
     */
    public Update update(java.util.List<java.lang.String> part, com.google.api.services.youtube.model.Playlist content) throws java.io.IOException {
      Update result = new Update(part, content);
      initialize(result);
      return result;
    }

    public class Update extends YouTubeRequest<com.google.api.services.youtube.model.Playlist> {

      private static final String REST_PATH = "youtube/v3/playlists";

      /**
       * Updates an existing resource.
       *
       * Create a request for the method "playlists.update".
       *
       * This request holds the parameters needed by the the youtube server.  After setting any optional
       * parameters, call the {@link Update#execute()} method to invoke the remote operation. <p> {@link
       * Update#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param part The *part* parameter serves two purposes in this operation. It identifies the properties that the
     *        write operation will set as well as the properties that the API response will include.
     *        Note that this method will override the existing values for mutable properties that are
     *        contained in any parts that the request body specifies. For example, a playlist's
     *        description is contained in the snippet part, which must be included in the request body.
     *        If the request does not specify a value for the snippet.description property, the
     *        playlist's existing description will be deleted.
       * @param content the {@link com.google.api.services.youtube.model.Playlist}
       * @since 1.13
       */
      protected Update(java.util.List<java.lang.String> part, com.google.api.services.youtube.model.Playlist content) {
        super(YouTube.this, "PUT", REST_PATH, content, com.google.api.services.youtube.model.Playlist.class);
        this.part = com.google.api.client.util.Preconditions.checkNotNull(part, "Required parameter part must be specified.");
      }

      @Override
      public Update set$Xgafv(java.lang.String $Xgafv) {
        return (Update) super.set$Xgafv($Xgafv);
      }

      @Override
      public Update setAccessToken(java.lang.String accessToken) {
        return (Update) super.setAccessToken(accessToken);
      }

      @Override
      public Update setAlt(java.lang.String alt) {
        return (Update) super.setAlt(alt);
      }

      @Override
      public Update setCallback(java.lang.String callback) {
        return (Update) super.setCallback(callback);
      }

      @Override
      public Update setFields(java.lang.String fields) {
        return (Update) super.setFields(fields);
      }

      @Override
      public Update setKey(java.lang.String key) {
        return (Update) super.setKey(key);
      }

      @Override
      public Update setOauthToken(java.lang.String oauthToken) {
        return (Update) super.setOauthToken(oauthToken);
      }

      @Override
      public Update setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Update) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Update setQuotaUser(java.lang.String quotaUser) {
        return (Update) super.setQuotaUser(quotaUser);
      }

      @Override
      public Update setUploadType(java.lang.String uploadType) {
        return (Update) super.setUploadType(uploadType);
      }

      @Override
      public Update setUploadProtocol(java.lang.String uploadProtocol) {
        return (Update) super.setUploadProtocol(uploadProtocol);
      }

      /**
       * The *part* parameter serves two purposes in this operation. It identifies the properties
       * that the write operation will set as well as the properties that the API response will
       * include. Note that this method will override the existing values for mutable properties
       * that are contained in any parts that the request body specifies. For example, a playlist's
       * description is contained in the snippet part, which must be included in the request body.
       * If the request does not specify a value for the snippet.description property, the
       * playlist's existing description will be deleted.
       */
      @com.google.api.client.util.Key
      private java.util.List<java.lang.String> part;

      /** The *part* parameter serves two purposes in this operation. It identifies the properties that the
     write operation will set as well as the properties that the API response will include. Note that
     this method will override the existing values for mutable properties that are contained in any
     parts that the request body specifies. For example, a playlist's description is contained in the
     snippet part, which must be included in the request body. If the request does not specify a value
     for the snippet.description property, the playlist's existing description will be deleted.
       */
      public java.util.List<java.lang.String> getPart() {
        return part;
      }

      /**
       * The *part* parameter serves two purposes in this operation. It identifies the properties
       * that the write operation will set as well as the properties that the API response will
       * include. Note that this method will override the existing values for mutable properties
       * that are contained in any parts that the request body specifies. For example, a playlist's
       * description is contained in the snippet part, which must be included in the request body.
       * If the request does not specify a value for the snippet.description property, the
       * playlist's existing description will be deleted.
       */
      public Update setPart(java.util.List<java.lang.String> part) {
        this.part = part;
        return this;
      }

      /**
       * *Note:* This parameter is intended exclusively for YouTube content partners. The
       * *onBehalfOfContentOwner* parameter indicates that the request's authorization credentials
       * identify a YouTube CMS user who is acting on behalf of the content owner specified in the
       * parameter value. This parameter is intended for YouTube content partners that own and
       * manage many different YouTube channels. It allows content owners to authenticate once and
       * get access to all their video and channel data, without having to provide authentication
       * credentials for each individual channel. The CMS account that the user authenticates with
       * must be linked to the specified YouTube content owner.
       */
      @com.google.api.client.util.Key
      private java.lang.String onBehalfOfContentOwner;

      /*** Note:* This parameter is intended exclusively for YouTube content partners. The
    * *onBehalfOfContentOwner* parameter indicates that the request's authorization credentials identify
    * a YouTube CMS user who is acting on behalf of the content owner specified in the parameter value.
    * This parameter is intended for YouTube content partners that own and manage many different YouTube
    * channels. It allows content owners to authenticate once and get access to all their video and
    * channel data, without having to provide authentication credentials for each individual channel.
    * The CMS account that the user authenticates with must be linked to the specified YouTube content
    * owner.
    *

       */
      public java.lang.String getOnBehalfOfContentOwner() {
        return onBehalfOfContentOwner;
      }

      /**
       * *Note:* This parameter is intended exclusively for YouTube content partners. The
       * *onBehalfOfContentOwner* parameter indicates that the request's authorization credentials
       * identify a YouTube CMS user who is acting on behalf of the content owner specified in the
       * parameter value. This parameter is intended for YouTube content partners that own and
       * manage many different YouTube channels. It allows content owners to authenticate once and
       * get access to all their video and channel data, without having to provide authentication
       * credentials for each individual channel. The CMS account that the user authenticates with
       * must be linked to the specified YouTube content owner.
       */
      public Update setOnBehalfOfContentOwner(java.lang.String onBehalfOfContentOwner) {
        this.onBehalfOfContentOwner = onBehalfOfContentOwner;
        return this;
      }

      @Override
      public Update set(String parameterName, Object value) {
        return (Update) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the Search collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code YouTube youtube = new YouTube(...);}
   *   {@code YouTube.Search.List request = youtube.search().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Search search() {
    return new Search();
  }

  /**
   * The "search" collection of methods.
   */
  public class Search {

    /**
     * Retrieves a list of search resources
     *
     * Create a request for the method "search.list".
     *
     * This request holds the parameters needed by the youtube server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param part The *part* parameter specifies a comma-separated list of one or more search resource properties that
     *        the API response will include. Set the parameter value to snippet.
     * @return the request
     */
    public List list(java.util.List<java.lang.String> part) throws java.io.IOException {
      List result = new List(part);
      initialize(result);
      return result;
    }

    public class List extends YouTubeRequest<com.google.api.services.youtube.model.SearchListResponse> {

      private static final String REST_PATH = "youtube/v3/search";

      /**
       * Retrieves a list of search resources
       *
       * Create a request for the method "search.list".
       *
       * This request holds the parameters needed by the the youtube server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param part The *part* parameter specifies a comma-separated list of one or more search resource properties that
     *        the API response will include. Set the parameter value to snippet.
       * @since 1.13
       */
      protected List(java.util.List<java.lang.String> part) {
        super(YouTube.this, "GET", REST_PATH, null, com.google.api.services.youtube.model.SearchListResponse.class);
        this.part = com.google.api.client.util.Preconditions.checkNotNull(part, "Required parameter part must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List set$Xgafv(java.lang.String $Xgafv) {
        return (List) super.set$Xgafv($Xgafv);
      }

      @Override
      public List setAccessToken(java.lang.String accessToken) {
        return (List) super.setAccessToken(accessToken);
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setCallback(java.lang.String callback) {
        return (List) super.setCallback(callback);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUploadType(java.lang.String uploadType) {
        return (List) super.setUploadType(uploadType);
      }

      @Override
      public List setUploadProtocol(java.lang.String uploadProtocol) {
        return (List) super.setUploadProtocol(uploadProtocol);
      }

      /**
       * The *part* parameter specifies a comma-separated list of one or more search resource
       * properties that the API response will include. Set the parameter value to snippet.
       */
      @com.google.api.client.util.Key
      private java.util.List<java.lang.String> part;

      /** The *part* parameter specifies a comma-separated list of one or more search resource properties
     that the API response will include. Set the parameter value to snippet.
       */
      public java.util.List<java.lang.String> getPart() {
        return part;
      }

      /**
       * The *part* parameter specifies a comma-separated list of one or more search resource
       * properties that the API response will include. Set the parameter value to snippet.
       */
      public List setPart(java.util.List<java.lang.String> part) {
        this.part = part;
        return this;
      }

      /** Filter on resources belonging to this channelId. */
      @com.google.api.client.util.Key
      private java.lang.String channelId;

      /** Filter on resources belonging to this channelId.
       */
      public java.lang.String getChannelId() {
        return channelId;
      }

      /** Filter on resources belonging to this channelId. */
      public List setChannelId(java.lang.String channelId) {
        this.channelId = channelId;
        return this;
      }

      /** Add a filter on the channel search. */
      @com.google.api.client.util.Key
      private java.lang.String channelType;

      /** Add a filter on the channel search.
       */
      public java.lang.String getChannelType() {
        return channelType;
      }

      /** Add a filter on the channel search. */
      public List setChannelType(java.lang.String channelType) {
        this.channelType = channelType;
        return this;
      }

      /** Filter on the livestream status of the videos. */
      @com.google.api.client.util.Key
      private java.lang.String eventType;

      /** Filter on the livestream status of the videos.
       */
      public java.lang.String getEventType() {
        return eventType;
      }

      /** Filter on the livestream status of the videos. */
      public List setEventType(java.lang.String eventType) {
        this.eventType = eventType;
        return this;
      }

      /** Search owned by a content owner. */
      @com.google.api.client.util.Key
      private java.lang.Boolean forContentOwner;

      /** Search owned by a content owner.
       */
      public java.lang.Boolean getForContentOwner() {
        return forContentOwner;
      }

      /** Search owned by a content owner. */
      public List setForContentOwner(java.lang.Boolean forContentOwner) {
        this.forContentOwner = forContentOwner;
        return this;
      }

      /**
       * Restrict the search to only retrieve videos uploaded using the project id of the
       * authenticated user.
       */
      @com.google.api.client.util.Key
      private java.lang.Boolean forDeveloper;

      /** Restrict the search to only retrieve videos uploaded using the project id of the authenticated
     user.
       */
      public java.lang.Boolean getForDeveloper() {
        return forDeveloper;
      }

      /**
       * Restrict the search to only retrieve videos uploaded using the project id of the
       * authenticated user.
       */
      public List setForDeveloper(java.lang.Boolean forDeveloper) {
        this.forDeveloper = forDeveloper;
        return this;
      }

      /** Search for the private videos of the authenticated user. */
      @com.google.api.client.util.Key
      private java.lang.Boolean forMine;

      /** Search for the private videos of the authenticated user.
       */
      public java.lang.Boolean getForMine() {
        return forMine;
      }

      /** Search for the private videos of the authenticated user. */
      public List setForMine(java.lang.Boolean forMine) {
        this.forMine = forMine;
        return this;
      }

      /** Filter on location of the video */
      @com.google.api.client.util.Key
      private java.lang.String location;

      /** Filter on location of the video
       */
      public java.lang.String getLocation() {
        return location;
      }

      /** Filter on location of the video */
      public List setLocation(java.lang.String location) {
        this.location = location;
        return this;
      }

      /** Filter on distance from the location (specified above). */
      @com.google.api.client.util.Key
      private java.lang.String locationRadius;

      /** Filter on distance from the location (specified above).
       */
      public java.lang.String getLocationRadius() {
        return locationRadius;
      }

      /** Filter on distance from the location (specified above). */
      public List setLocationRadius(java.lang.String locationRadius) {
        this.locationRadius = locationRadius;
        return this;
      }

      /**
       * The *maxResults* parameter specifies the maximum number of items that should be returned in
       * the result set.
       */
      @com.google.api.client.util.Key
      private java.lang.Long maxResults;

      /** The *maxResults* parameter specifies the maximum number of items that should be returned in the
     result set. [default: 5] [minimum: 0] [maximum: 50]
       */
      public java.lang.Long getMaxResults() {
        return maxResults;
      }

      /**
       * The *maxResults* parameter specifies the maximum number of items that should be returned in
       * the result set.
       */
      public List setMaxResults(java.lang.Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      /**
       * *Note:* This parameter is intended exclusively for YouTube content partners. The
       * *onBehalfOfContentOwner* parameter indicates that the request's authorization credentials
       * identify a YouTube CMS user who is acting on behalf of the content owner specified in the
       * parameter value. This parameter is intended for YouTube content partners that own and
       * manage many different YouTube channels. It allows content owners to authenticate once and
       * get access to all their video and channel data, without having to provide authentication
       * credentials for each individual channel. The CMS account that the user authenticates with
       * must be linked to the specified YouTube content owner.
       */
      @com.google.api.client.util.Key
      private java.lang.String onBehalfOfContentOwner;

      /*** Note:* This parameter is intended exclusively for YouTube content partners. The
    * *onBehalfOfContentOwner* parameter indicates that the request's authorization credentials identify
    * a YouTube CMS user who is acting on behalf of the content owner specified in the parameter value.
    * This parameter is intended for YouTube content partners that own and manage many different YouTube
    * channels. It allows content owners to authenticate once and get access to all their video and
    * channel data, without having to provide authentication credentials for each individual channel.
    * The CMS account that the user authenticates with must be linked to the specified YouTube content
    * owner.
    *

       */
      public java.lang.String getOnBehalfOfContentOwner() {
        return onBehalfOfContentOwner;
      }

      /**
       * *Note:* This parameter is intended exclusively for YouTube content partners. The
       * *onBehalfOfContentOwner* parameter indicates that the request's authorization credentials
       * identify a YouTube CMS user who is acting on behalf of the content owner specified in the
       * parameter value. This parameter is intended for YouTube content partners that own and
       * manage many different YouTube channels. It allows content owners to authenticate once and
       * get access to all their video and channel data, without having to provide authentication
       * credentials for each individual channel. The CMS account that the user authenticates with
       * must be linked to the specified YouTube content owner.
       */
      public List setOnBehalfOfContentOwner(java.lang.String onBehalfOfContentOwner) {
        this.onBehalfOfContentOwner = onBehalfOfContentOwner;
        return this;
      }

      /** Sort order of the results. */
      @com.google.api.client.util.Key
      private java.lang.String order;

      /** Sort order of the results. [default: relevance]
       */
      public java.lang.String getOrder() {
        return order;
      }

      /** Sort order of the results. */
      public List setOrder(java.lang.String order) {
        this.order = order;
        return this;
      }

      /**
       * The *pageToken* parameter identifies a specific page in the result set that should be
       * returned. In an API response, the nextPageToken and prevPageToken properties identify other
       * pages that could be retrieved.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** The *pageToken* parameter identifies a specific page in the result set that should be returned. In
     an API response, the nextPageToken and prevPageToken properties identify other pages that could be
     retrieved.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * The *pageToken* parameter identifies a specific page in the result set that should be
       * returned. In an API response, the nextPageToken and prevPageToken properties identify other
       * pages that could be retrieved.
       */
      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      /** Filter on resources published after this date. */
      @com.google.api.client.util.Key
      private String publishedAfter;

      /** Filter on resources published after this date.
       */
      public String getPublishedAfter() {
        return publishedAfter;
      }

      /** Filter on resources published after this date. */
      public List setPublishedAfter(String publishedAfter) {
        this.publishedAfter = publishedAfter;
        return this;
      }

      /** Filter on resources published before this date. */
      @com.google.api.client.util.Key
      private String publishedBefore;

      /** Filter on resources published before this date.
       */
      public String getPublishedBefore() {
        return publishedBefore;
      }

      /** Filter on resources published before this date. */
      public List setPublishedBefore(String publishedBefore) {
        this.publishedBefore = publishedBefore;
        return this;
      }

      /** Textual search terms to match. */
      @com.google.api.client.util.Key
      private java.lang.String q;

      /** Textual search terms to match.
       */
      public java.lang.String getQ() {
        return q;
      }

      /** Textual search terms to match. */
      public List setQ(java.lang.String q) {
        this.q = q;
        return this;
      }

      /** Display the content as seen by viewers in this country. */
      @com.google.api.client.util.Key
      private java.lang.String regionCode;

      /** Display the content as seen by viewers in this country.
       */
      public java.lang.String getRegionCode() {
        return regionCode;
      }

      /** Display the content as seen by viewers in this country. */
      public List setRegionCode(java.lang.String regionCode) {
        this.regionCode = regionCode;
        return this;
      }

      /** Search related to a resource. */
      @com.google.api.client.util.Key
      private java.lang.String relatedToVideoId;

      /** Search related to a resource.
       */
      public java.lang.String getRelatedToVideoId() {
        return relatedToVideoId;
      }

      /** Search related to a resource. */
      public List setRelatedToVideoId(java.lang.String relatedToVideoId) {
        this.relatedToVideoId = relatedToVideoId;
        return this;
      }

      /** Return results relevant to this language. */
      @com.google.api.client.util.Key
      private java.lang.String relevanceLanguage;

      /** Return results relevant to this language.
       */
      public java.lang.String getRelevanceLanguage() {
        return relevanceLanguage;
      }

      /** Return results relevant to this language. */
      public List setRelevanceLanguage(java.lang.String relevanceLanguage) {
        this.relevanceLanguage = relevanceLanguage;
        return this;
      }

      /**
       * Indicates whether the search results should include restricted content as well as standard
       * content.
       */
      @com.google.api.client.util.Key
      private java.lang.String safeSearch;

      /** Indicates whether the search results should include restricted content as well as standard content.
     [default: moderate]
       */
      public java.lang.String getSafeSearch() {
        return safeSearch;
      }

      /**
       * Indicates whether the search results should include restricted content as well as standard
       * content.
       */
      public List setSafeSearch(java.lang.String safeSearch) {
        this.safeSearch = safeSearch;
        return this;
      }

      /** Restrict results to a particular topic. */
      @com.google.api.client.util.Key
      private java.lang.String topicId;

      /** Restrict results to a particular topic.
       */
      public java.lang.String getTopicId() {
        return topicId;
      }

      /** Restrict results to a particular topic. */
      public List setTopicId(java.lang.String topicId) {
        this.topicId = topicId;
        return this;
      }

      /** Restrict results to a particular set of resource types from One Platform. */
      @com.google.api.client.util.Key
      private java.util.List<java.lang.String> type;

      /** Restrict results to a particular set of resource types from One Platform.
       */
      public java.util.List<java.lang.String> getType() {
        return type;
      }

      /** Restrict results to a particular set of resource types from One Platform. */
      public List setType(java.util.List<java.lang.String> type) {
        this.type = type;
        return this;
      }

      /** Filter on the presence of captions on the videos. */
      @com.google.api.client.util.Key
      private java.lang.String videoCaption;

      /** Filter on the presence of captions on the videos.
       */
      public java.lang.String getVideoCaption() {
        return videoCaption;
      }

      /** Filter on the presence of captions on the videos. */
      public List setVideoCaption(java.lang.String videoCaption) {
        this.videoCaption = videoCaption;
        return this;
      }

      /** Filter on videos in a specific category. */
      @com.google.api.client.util.Key
      private java.lang.String videoCategoryId;

      /** Filter on videos in a specific category.
       */
      public java.lang.String getVideoCategoryId() {
        return videoCategoryId;
      }

      /** Filter on videos in a specific category. */
      public List setVideoCategoryId(java.lang.String videoCategoryId) {
        this.videoCategoryId = videoCategoryId;
        return this;
      }

      /** Filter on the definition of the videos. */
      @com.google.api.client.util.Key
      private java.lang.String videoDefinition;

      /** Filter on the definition of the videos.
       */
      public java.lang.String getVideoDefinition() {
        return videoDefinition;
      }

      /** Filter on the definition of the videos. */
      public List setVideoDefinition(java.lang.String videoDefinition) {
        this.videoDefinition = videoDefinition;
        return this;
      }

      /** Filter on 3d videos. */
      @com.google.api.client.util.Key
      private java.lang.String videoDimension;

      /** Filter on 3d videos.
       */
      public java.lang.String getVideoDimension() {
        return videoDimension;
      }

      /** Filter on 3d videos. */
      public List setVideoDimension(java.lang.String videoDimension) {
        this.videoDimension = videoDimension;
        return this;
      }

      /** Filter on the duration of the videos. */
      @com.google.api.client.util.Key
      private java.lang.String videoDuration;

      /** Filter on the duration of the videos.
       */
      public java.lang.String getVideoDuration() {
        return videoDuration;
      }

      /** Filter on the duration of the videos. */
      public List setVideoDuration(java.lang.String videoDuration) {
        this.videoDuration = videoDuration;
        return this;
      }

      /** Filter on embeddable videos. */
      @com.google.api.client.util.Key
      private java.lang.String videoEmbeddable;

      /** Filter on embeddable videos.
       */
      public java.lang.String getVideoEmbeddable() {
        return videoEmbeddable;
      }

      /** Filter on embeddable videos. */
      public List setVideoEmbeddable(java.lang.String videoEmbeddable) {
        this.videoEmbeddable = videoEmbeddable;
        return this;
      }

      /** Filter on the license of the videos. */
      @com.google.api.client.util.Key
      private java.lang.String videoLicense;

      /** Filter on the license of the videos.
       */
      public java.lang.String getVideoLicense() {
        return videoLicense;
      }

      /** Filter on the license of the videos. */
      public List setVideoLicense(java.lang.String videoLicense) {
        this.videoLicense = videoLicense;
        return this;
      }

      /** Filter on syndicated videos. */
      @com.google.api.client.util.Key
      private java.lang.String videoSyndicated;

      /** Filter on syndicated videos.
       */
      public java.lang.String getVideoSyndicated() {
        return videoSyndicated;
      }

      /** Filter on syndicated videos. */
      public List setVideoSyndicated(java.lang.String videoSyndicated) {
        this.videoSyndicated = videoSyndicated;
        return this;
      }

      /** Filter on videos of a specific type. */
      @com.google.api.client.util.Key
      private java.lang.String videoType;

      /** Filter on videos of a specific type.
       */
      public java.lang.String getVideoType() {
        return videoType;
      }

      /** Filter on videos of a specific type. */
      public List setVideoType(java.lang.String videoType) {
        this.videoType = videoType;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the Subscriptions collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code YouTube youtube = new YouTube(...);}
   *   {@code YouTube.Subscriptions.List request = youtube.subscriptions().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Subscriptions subscriptions() {
    return new Subscriptions();
  }

  /**
   * The "subscriptions" collection of methods.
   */
  public class Subscriptions {

    /**
     * Deletes a resource.
     *
     * Create a request for the method "subscriptions.delete".
     *
     * This request holds the parameters needed by the youtube server.  After setting any optional
     * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
     *
     * @param id
     * @return the request
     */
    public Delete delete(java.lang.String id) throws java.io.IOException {
      Delete result = new Delete(id);
      initialize(result);
      return result;
    }

    public class Delete extends YouTubeRequest<Void> {

      private static final String REST_PATH = "youtube/v3/subscriptions";

      /**
       * Deletes a resource.
       *
       * Create a request for the method "subscriptions.delete".
       *
       * This request holds the parameters needed by the the youtube server.  After setting any optional
       * parameters, call the {@link Delete#execute()} method to invoke the remote operation. <p> {@link
       * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param id
       * @since 1.13
       */
      protected Delete(java.lang.String id) {
        super(YouTube.this, "DELETE", REST_PATH, null, Void.class);
        this.id = com.google.api.client.util.Preconditions.checkNotNull(id, "Required parameter id must be specified.");
      }

      @Override
      public Delete set$Xgafv(java.lang.String $Xgafv) {
        return (Delete) super.set$Xgafv($Xgafv);
      }

      @Override
      public Delete setAccessToken(java.lang.String accessToken) {
        return (Delete) super.setAccessToken(accessToken);
      }

      @Override
      public Delete setAlt(java.lang.String alt) {
        return (Delete) super.setAlt(alt);
      }

      @Override
      public Delete setCallback(java.lang.String callback) {
        return (Delete) super.setCallback(callback);
      }

      @Override
      public Delete setFields(java.lang.String fields) {
        return (Delete) super.setFields(fields);
      }

      @Override
      public Delete setKey(java.lang.String key) {
        return (Delete) super.setKey(key);
      }

      @Override
      public Delete setOauthToken(java.lang.String oauthToken) {
        return (Delete) super.setOauthToken(oauthToken);
      }

      @Override
      public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Delete) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Delete setQuotaUser(java.lang.String quotaUser) {
        return (Delete) super.setQuotaUser(quotaUser);
      }

      @Override
      public Delete setUploadType(java.lang.String uploadType) {
        return (Delete) super.setUploadType(uploadType);
      }

      @Override
      public Delete setUploadProtocol(java.lang.String uploadProtocol) {
        return (Delete) super.setUploadProtocol(uploadProtocol);
      }

      @com.google.api.client.util.Key
      private java.lang.String id;

      /**

       */
      public java.lang.String getId() {
        return id;
      }

      public Delete setId(java.lang.String id) {
        this.id = id;
        return this;
      }

      @Override
      public Delete set(String parameterName, Object value) {
        return (Delete) super.set(parameterName, value);
      }
    }
    /**
     * Inserts a new resource into this collection.
     *
     * Create a request for the method "subscriptions.insert".
     *
     * This request holds the parameters needed by the youtube server.  After setting any optional
     * parameters, call the {@link Insert#execute()} method to invoke the remote operation.
     *
     * @param part The *part* parameter serves two purposes in this operation. It identifies the properties that the
     *        write operation will set as well as the properties that the API response will include.
     * @param content the {@link com.google.api.services.youtube.model.Subscription}
     * @return the request
     */
    public Insert insert(java.util.List<java.lang.String> part, com.google.api.services.youtube.model.Subscription content) throws java.io.IOException {
      Insert result = new Insert(part, content);
      initialize(result);
      return result;
    }

    public class Insert extends YouTubeRequest<com.google.api.services.youtube.model.Subscription> {

      private static final String REST_PATH = "youtube/v3/subscriptions";

      /**
       * Inserts a new resource into this collection.
       *
       * Create a request for the method "subscriptions.insert".
       *
       * This request holds the parameters needed by the the youtube server.  After setting any optional
       * parameters, call the {@link Insert#execute()} method to invoke the remote operation. <p> {@link
       * Insert#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param part The *part* parameter serves two purposes in this operation. It identifies the properties that the
     *        write operation will set as well as the properties that the API response will include.
       * @param content the {@link com.google.api.services.youtube.model.Subscription}
       * @since 1.13
       */
      protected Insert(java.util.List<java.lang.String> part, com.google.api.services.youtube.model.Subscription content) {
        super(YouTube.this, "POST", REST_PATH, content, com.google.api.services.youtube.model.Subscription.class);
        this.part = com.google.api.client.util.Preconditions.checkNotNull(part, "Required parameter part must be specified.");
      }

      @Override
      public Insert set$Xgafv(java.lang.String $Xgafv) {
        return (Insert) super.set$Xgafv($Xgafv);
      }

      @Override
      public Insert setAccessToken(java.lang.String accessToken) {
        return (Insert) super.setAccessToken(accessToken);
      }

      @Override
      public Insert setAlt(java.lang.String alt) {
        return (Insert) super.setAlt(alt);
      }

      @Override
      public Insert setCallback(java.lang.String callback) {
        return (Insert) super.setCallback(callback);
      }

      @Override
      public Insert setFields(java.lang.String fields) {
        return (Insert) super.setFields(fields);
      }

      @Override
      public Insert setKey(java.lang.String key) {
        return (Insert) super.setKey(key);
      }

      @Override
      public Insert setOauthToken(java.lang.String oauthToken) {
        return (Insert) super.setOauthToken(oauthToken);
      }

      @Override
      public Insert setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Insert) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Insert setQuotaUser(java.lang.String quotaUser) {
        return (Insert) super.setQuotaUser(quotaUser);
      }

      @Override
      public Insert setUploadType(java.lang.String uploadType) {
        return (Insert) super.setUploadType(uploadType);
      }

      @Override
      public Insert setUploadProtocol(java.lang.String uploadProtocol) {
        return (Insert) super.setUploadProtocol(uploadProtocol);
      }

      /**
       * The *part* parameter serves two purposes in this operation. It identifies the properties
       * that the write operation will set as well as the properties that the API response will
       * include.
       */
      @com.google.api.client.util.Key
      private java.util.List<java.lang.String> part;

      /** The *part* parameter serves two purposes in this operation. It identifies the properties that the
     write operation will set as well as the properties that the API response will include.
       */
      public java.util.List<java.lang.String> getPart() {
        return part;
      }

      /**
       * The *part* parameter serves two purposes in this operation. It identifies the properties
       * that the write operation will set as well as the properties that the API response will
       * include.
       */
      public Insert setPart(java.util.List<java.lang.String> part) {
        this.part = part;
        return this;
      }

      @Override
      public Insert set(String parameterName, Object value) {
        return (Insert) super.set(parameterName, value);
      }
    }
    /**
     * Retrieves a list of resources, possibly filtered.
     *
     * Create a request for the method "subscriptions.list".
     *
     * This request holds the parameters needed by the youtube server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param part The *part* parameter specifies a comma-separated list of one or more subscription resource
     *        properties that the API response will include. If the parameter identifies a property that
     *        contains child properties, the child properties will be included in the response. For
     *        example, in a subscription resource, the snippet property contains other properties, such
     *        as a display title for the subscription. If you set *part=snippet*, the API response will
     *        also contain all of those nested properties.
     * @return the request
     */
    public List list(java.util.List<java.lang.String> part) throws java.io.IOException {
      List result = new List(part);
      initialize(result);
      return result;
    }

    public class List extends YouTubeRequest<com.google.api.services.youtube.model.SubscriptionListResponse> {

      private static final String REST_PATH = "youtube/v3/subscriptions";

      /**
       * Retrieves a list of resources, possibly filtered.
       *
       * Create a request for the method "subscriptions.list".
       *
       * This request holds the parameters needed by the the youtube server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param part The *part* parameter specifies a comma-separated list of one or more subscription resource
     *        properties that the API response will include. If the parameter identifies a property that
     *        contains child properties, the child properties will be included in the response. For
     *        example, in a subscription resource, the snippet property contains other properties, such
     *        as a display title for the subscription. If you set *part=snippet*, the API response will
     *        also contain all of those nested properties.
       * @since 1.13
       */
      protected List(java.util.List<java.lang.String> part) {
        super(YouTube.this, "GET", REST_PATH, null, com.google.api.services.youtube.model.SubscriptionListResponse.class);
        this.part = com.google.api.client.util.Preconditions.checkNotNull(part, "Required parameter part must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List set$Xgafv(java.lang.String $Xgafv) {
        return (List) super.set$Xgafv($Xgafv);
      }

      @Override
      public List setAccessToken(java.lang.String accessToken) {
        return (List) super.setAccessToken(accessToken);
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setCallback(java.lang.String callback) {
        return (List) super.setCallback(callback);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUploadType(java.lang.String uploadType) {
        return (List) super.setUploadType(uploadType);
      }

      @Override
      public List setUploadProtocol(java.lang.String uploadProtocol) {
        return (List) super.setUploadProtocol(uploadProtocol);
      }

      /**
       * The *part* parameter specifies a comma-separated list of one or more subscription resource
       * properties that the API response will include. If the parameter identifies a property that
       * contains child properties, the child properties will be included in the response. For
       * example, in a subscription resource, the snippet property contains other properties, such
       * as a display title for the subscription. If you set *part=snippet*, the API response will
       * also contain all of those nested properties.
       */
      @com.google.api.client.util.Key
      private java.util.List<java.lang.String> part;

      /** The *part* parameter specifies a comma-separated list of one or more subscription resource
     properties that the API response will include. If the parameter identifies a property that contains
     child properties, the child properties will be included in the response. For example, in a
     subscription resource, the snippet property contains other properties, such as a display title for
     the subscription. If you set *part=snippet*, the API response will also contain all of those nested
     properties.
       */
      public java.util.List<java.lang.String> getPart() {
        return part;
      }

      /**
       * The *part* parameter specifies a comma-separated list of one or more subscription resource
       * properties that the API response will include. If the parameter identifies a property that
       * contains child properties, the child properties will be included in the response. For
       * example, in a subscription resource, the snippet property contains other properties, such
       * as a display title for the subscription. If you set *part=snippet*, the API response will
       * also contain all of those nested properties.
       */
      public List setPart(java.util.List<java.lang.String> part) {
        this.part = part;
        return this;
      }

      /** Return the subscriptions of the given channel owner. */
      @com.google.api.client.util.Key
      private java.lang.String channelId;

      /** Return the subscriptions of the given channel owner.
       */
      public java.lang.String getChannelId() {
        return channelId;
      }

      /** Return the subscriptions of the given channel owner. */
      public List setChannelId(java.lang.String channelId) {
        this.channelId = channelId;
        return this;
      }

      /**
       * Return the subscriptions to the subset of these channels that the authenticated user is
       * subscribed to.
       */
      @com.google.api.client.util.Key
      private java.lang.String forChannelId;

      /** Return the subscriptions to the subset of these channels that the authenticated user is subscribed
     to.
       */
      public java.lang.String getForChannelId() {
        return forChannelId;
      }

      /**
       * Return the subscriptions to the subset of these channels that the authenticated user is
       * subscribed to.
       */
      public List setForChannelId(java.lang.String forChannelId) {
        this.forChannelId = forChannelId;
        return this;
      }

      /** Return the subscriptions with the given IDs for Stubby or Apiary. */
      @com.google.api.client.util.Key
      private java.util.List<java.lang.String> id;

      /** Return the subscriptions with the given IDs for Stubby or Apiary.
       */
      public java.util.List<java.lang.String> getId() {
        return id;
      }

      /** Return the subscriptions with the given IDs for Stubby or Apiary. */
      public List setId(java.util.List<java.lang.String> id) {
        this.id = id;
        return this;
      }

      /**
       * The *maxResults* parameter specifies the maximum number of items that should be returned in
       * the result set.
       */
      @com.google.api.client.util.Key
      private java.lang.Long maxResults;

      /** The *maxResults* parameter specifies the maximum number of items that should be returned in the
     result set. [default: 5] [minimum: 0] [maximum: 50]
       */
      public java.lang.Long getMaxResults() {
        return maxResults;
      }

      /**
       * The *maxResults* parameter specifies the maximum number of items that should be returned in
       * the result set.
       */
      public List setMaxResults(java.lang.Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      /** Flag for returning the subscriptions of the authenticated user. */
      @com.google.api.client.util.Key
      private java.lang.Boolean mine;

      /** Flag for returning the subscriptions of the authenticated user.
       */
      public java.lang.Boolean getMine() {
        return mine;
      }

      /** Flag for returning the subscriptions of the authenticated user. */
      public List setMine(java.lang.Boolean mine) {
        this.mine = mine;
        return this;
      }

      @com.google.api.client.util.Key
      private java.lang.Boolean myRecentSubscribers;

      /**

       */
      public java.lang.Boolean getMyRecentSubscribers() {
        return myRecentSubscribers;
      }

      public List setMyRecentSubscribers(java.lang.Boolean myRecentSubscribers) {
        this.myRecentSubscribers = myRecentSubscribers;
        return this;
      }

      /** Return the subscribers of the given channel owner. */
      @com.google.api.client.util.Key
      private java.lang.Boolean mySubscribers;

      /** Return the subscribers of the given channel owner.
       */
      public java.lang.Boolean getMySubscribers() {
        return mySubscribers;
      }

      /** Return the subscribers of the given channel owner. */
      public List setMySubscribers(java.lang.Boolean mySubscribers) {
        this.mySubscribers = mySubscribers;
        return this;
      }

      /**
       * *Note:* This parameter is intended exclusively for YouTube content partners. The
       * *onBehalfOfContentOwner* parameter indicates that the request's authorization credentials
       * identify a YouTube CMS user who is acting on behalf of the content owner specified in the
       * parameter value. This parameter is intended for YouTube content partners that own and
       * manage many different YouTube channels. It allows content owners to authenticate once and
       * get access to all their video and channel data, without having to provide authentication
       * credentials for each individual channel. The CMS account that the user authenticates with
       * must be linked to the specified YouTube content owner.
       */
      @com.google.api.client.util.Key
      private java.lang.String onBehalfOfContentOwner;

      /*** Note:* This parameter is intended exclusively for YouTube content partners. The
    * *onBehalfOfContentOwner* parameter indicates that the request's authorization credentials identify
    * a YouTube CMS user who is acting on behalf of the content owner specified in the parameter value.
    * This parameter is intended for YouTube content partners that own and manage many different YouTube
    * channels. It allows content owners to authenticate once and get access to all their video and
    * channel data, without having to provide authentication credentials for each individual channel.
    * The CMS account that the user authenticates with must be linked to the specified YouTube content
    * owner.
    *

       */
      public java.lang.String getOnBehalfOfContentOwner() {
        return onBehalfOfContentOwner;
      }

      /**
       * *Note:* This parameter is intended exclusively for YouTube content partners. The
       * *onBehalfOfContentOwner* parameter indicates that the request's authorization credentials
       * identify a YouTube CMS user who is acting on behalf of the content owner specified in the
       * parameter value. This parameter is intended for YouTube content partners that own and
       * manage many different YouTube channels. It allows content owners to authenticate once and
       * get access to all their video and channel data, without having to provide authentication
       * credentials for each individual channel. The CMS account that the user authenticates with
       * must be linked to the specified YouTube content owner.
       */
      public List setOnBehalfOfContentOwner(java.lang.String onBehalfOfContentOwner) {
        this.onBehalfOfContentOwner = onBehalfOfContentOwner;
        return this;
      }

      /**
       * This parameter can only be used in a properly authorized request. *Note:* This parameter is
       * intended exclusively for YouTube content partners. The *onBehalfOfContentOwnerChannel*
       * parameter specifies the YouTube channel ID of the channel to which a video is being added.
       * This parameter is required when a request specifies a value for the onBehalfOfContentOwner
       * parameter, and it can only be used in conjunction with that parameter. In addition, the
       * request must be authorized using a CMS account that is linked to the content owner that the
       * onBehalfOfContentOwner parameter specifies. Finally, the channel that the
       * onBehalfOfContentOwnerChannel parameter value specifies must be linked to the content owner
       * that the onBehalfOfContentOwner parameter specifies. This parameter is intended for YouTube
       * content partners that own and manage many different YouTube channels. It allows content
       * owners to authenticate once and perform actions on behalf of the channel specified in the
       * parameter value, without having to provide authentication credentials for each separate
       * channel.
       */
      @com.google.api.client.util.Key
      private java.lang.String onBehalfOfContentOwnerChannel;

      /** This parameter can only be used in a properly authorized request. *Note:* This parameter is
     intended exclusively for YouTube content partners. The *onBehalfOfContentOwnerChannel* parameter
     specifies the YouTube channel ID of the channel to which a video is being added. This parameter is
     required when a request specifies a value for the onBehalfOfContentOwner parameter, and it can only
     be used in conjunction with that parameter. In addition, the request must be authorized using a CMS
     account that is linked to the content owner that the onBehalfOfContentOwner parameter specifies.
     Finally, the channel that the onBehalfOfContentOwnerChannel parameter value specifies must be
     linked to the content owner that the onBehalfOfContentOwner parameter specifies. This parameter is
     intended for YouTube content partners that own and manage many different YouTube channels. It
     allows content owners to authenticate once and perform actions on behalf of the channel specified
     in the parameter value, without having to provide authentication credentials for each separate
     channel.
       */
      public java.lang.String getOnBehalfOfContentOwnerChannel() {
        return onBehalfOfContentOwnerChannel;
      }

      /**
       * This parameter can only be used in a properly authorized request. *Note:* This parameter is
       * intended exclusively for YouTube content partners. The *onBehalfOfContentOwnerChannel*
       * parameter specifies the YouTube channel ID of the channel to which a video is being added.
       * This parameter is required when a request specifies a value for the onBehalfOfContentOwner
       * parameter, and it can only be used in conjunction with that parameter. In addition, the
       * request must be authorized using a CMS account that is linked to the content owner that the
       * onBehalfOfContentOwner parameter specifies. Finally, the channel that the
       * onBehalfOfContentOwnerChannel parameter value specifies must be linked to the content owner
       * that the onBehalfOfContentOwner parameter specifies. This parameter is intended for YouTube
       * content partners that own and manage many different YouTube channels. It allows content
       * owners to authenticate once and perform actions on behalf of the channel specified in the
       * parameter value, without having to provide authentication credentials for each separate
       * channel.
       */
      public List setOnBehalfOfContentOwnerChannel(java.lang.String onBehalfOfContentOwnerChannel) {
        this.onBehalfOfContentOwnerChannel = onBehalfOfContentOwnerChannel;
        return this;
      }

      /** The order of the returned subscriptions */
      @com.google.api.client.util.Key
      private java.lang.String order;

      /** The order of the returned subscriptions [default: relevance]
       */
      public java.lang.String getOrder() {
        return order;
      }

      /** The order of the returned subscriptions */
      public List setOrder(java.lang.String order) {
        this.order = order;
        return this;
      }

      /**
       * The *pageToken* parameter identifies a specific page in the result set that should be
       * returned. In an API response, the nextPageToken and prevPageToken properties identify other
       * pages that could be retrieved.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** The *pageToken* parameter identifies a specific page in the result set that should be returned. In
     an API response, the nextPageToken and prevPageToken properties identify other pages that could be
     retrieved.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * The *pageToken* parameter identifies a specific page in the result set that should be
       * returned. In an API response, the nextPageToken and prevPageToken properties identify other
       * pages that could be retrieved.
       */
      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the SuperChatEvents collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code YouTube youtube = new YouTube(...);}
   *   {@code YouTube.SuperChatEvents.List request = youtube.superChatEvents().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public SuperChatEvents superChatEvents() {
    return new SuperChatEvents();
  }

  /**
   * The "superChatEvents" collection of methods.
   */
  public class SuperChatEvents {

    /**
     * Retrieves a list of resources, possibly filtered.
     *
     * Create a request for the method "superChatEvents.list".
     *
     * This request holds the parameters needed by the youtube server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param part The *part* parameter specifies the superChatEvent resource parts that the API response will include.
     *        This parameter is currently not supported.
     * @return the request
     */
    public List list(java.util.List<java.lang.String> part) throws java.io.IOException {
      List result = new List(part);
      initialize(result);
      return result;
    }

    public class List extends YouTubeRequest<com.google.api.services.youtube.model.SuperChatEventListResponse> {

      private static final String REST_PATH = "youtube/v3/superChatEvents";

      /**
       * Retrieves a list of resources, possibly filtered.
       *
       * Create a request for the method "superChatEvents.list".
       *
       * This request holds the parameters needed by the the youtube server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param part The *part* parameter specifies the superChatEvent resource parts that the API response will include.
     *        This parameter is currently not supported.
       * @since 1.13
       */
      protected List(java.util.List<java.lang.String> part) {
        super(YouTube.this, "GET", REST_PATH, null, com.google.api.services.youtube.model.SuperChatEventListResponse.class);
        this.part = com.google.api.client.util.Preconditions.checkNotNull(part, "Required parameter part must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List set$Xgafv(java.lang.String $Xgafv) {
        return (List) super.set$Xgafv($Xgafv);
      }

      @Override
      public List setAccessToken(java.lang.String accessToken) {
        return (List) super.setAccessToken(accessToken);
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setCallback(java.lang.String callback) {
        return (List) super.setCallback(callback);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUploadType(java.lang.String uploadType) {
        return (List) super.setUploadType(uploadType);
      }

      @Override
      public List setUploadProtocol(java.lang.String uploadProtocol) {
        return (List) super.setUploadProtocol(uploadProtocol);
      }

      /**
       * The *part* parameter specifies the superChatEvent resource parts that the API response will
       * include. This parameter is currently not supported.
       */
      @com.google.api.client.util.Key
      private java.util.List<java.lang.String> part;

      /** The *part* parameter specifies the superChatEvent resource parts that the API response will
     include. This parameter is currently not supported.
       */
      public java.util.List<java.lang.String> getPart() {
        return part;
      }

      /**
       * The *part* parameter specifies the superChatEvent resource parts that the API response will
       * include. This parameter is currently not supported.
       */
      public List setPart(java.util.List<java.lang.String> part) {
        this.part = part;
        return this;
      }

      /** Return rendered funding amounts in specified language. */
      @com.google.api.client.util.Key
      private java.lang.String hl;

      /** Return rendered funding amounts in specified language.
       */
      public java.lang.String getHl() {
        return hl;
      }

      /** Return rendered funding amounts in specified language. */
      public List setHl(java.lang.String hl) {
        this.hl = hl;
        return this;
      }

      /**
       * The *maxResults* parameter specifies the maximum number of items that should be returned in
       * the result set.
       */
      @com.google.api.client.util.Key
      private java.lang.Long maxResults;

      /** The *maxResults* parameter specifies the maximum number of items that should be returned in the
     result set. [default: 5] [minimum: 1] [maximum: 50]
       */
      public java.lang.Long getMaxResults() {
        return maxResults;
      }

      /**
       * The *maxResults* parameter specifies the maximum number of items that should be returned in
       * the result set.
       */
      public List setMaxResults(java.lang.Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      /**
       * The *pageToken* parameter identifies a specific page in the result set that should be
       * returned. In an API response, the nextPageToken and prevPageToken properties identify other
       * pages that could be retrieved.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** The *pageToken* parameter identifies a specific page in the result set that should be returned. In
     an API response, the nextPageToken and prevPageToken properties identify other pages that could be
     retrieved.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * The *pageToken* parameter identifies a specific page in the result set that should be
       * returned. In an API response, the nextPageToken and prevPageToken properties identify other
       * pages that could be retrieved.
       */
      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the Tests collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code YouTube youtube = new YouTube(...);}
   *   {@code YouTube.Tests.List request = youtube.tests().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Tests tests() {
    return new Tests();
  }

  /**
   * The "tests" collection of methods.
   */
  public class Tests {

    /**
     * POST method.
     *
     * Create a request for the method "tests.insert".
     *
     * This request holds the parameters needed by the youtube server.  After setting any optional
     * parameters, call the {@link Insert#execute()} method to invoke the remote operation.
     *
     * @param part
     * @param content the {@link com.google.api.services.youtube.model.TestItem}
     * @return the request
     */
    public Insert insert(java.util.List<java.lang.String> part, com.google.api.services.youtube.model.TestItem content) throws java.io.IOException {
      Insert result = new Insert(part, content);
      initialize(result);
      return result;
    }

    public class Insert extends YouTubeRequest<com.google.api.services.youtube.model.TestItem> {

      private static final String REST_PATH = "youtube/v3/tests";

      /**
       * POST method.
       *
       * Create a request for the method "tests.insert".
       *
       * This request holds the parameters needed by the the youtube server.  After setting any optional
       * parameters, call the {@link Insert#execute()} method to invoke the remote operation. <p> {@link
       * Insert#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param part
       * @param content the {@link com.google.api.services.youtube.model.TestItem}
       * @since 1.13
       */
      protected Insert(java.util.List<java.lang.String> part, com.google.api.services.youtube.model.TestItem content) {
        super(YouTube.this, "POST", REST_PATH, content, com.google.api.services.youtube.model.TestItem.class);
        this.part = com.google.api.client.util.Preconditions.checkNotNull(part, "Required parameter part must be specified.");
      }

      @Override
      public Insert set$Xgafv(java.lang.String $Xgafv) {
        return (Insert) super.set$Xgafv($Xgafv);
      }

      @Override
      public Insert setAccessToken(java.lang.String accessToken) {
        return (Insert) super.setAccessToken(accessToken);
      }

      @Override
      public Insert setAlt(java.lang.String alt) {
        return (Insert) super.setAlt(alt);
      }

      @Override
      public Insert setCallback(java.lang.String callback) {
        return (Insert) super.setCallback(callback);
      }

      @Override
      public Insert setFields(java.lang.String fields) {
        return (Insert) super.setFields(fields);
      }

      @Override
      public Insert setKey(java.lang.String key) {
        return (Insert) super.setKey(key);
      }

      @Override
      public Insert setOauthToken(java.lang.String oauthToken) {
        return (Insert) super.setOauthToken(oauthToken);
      }

      @Override
      public Insert setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Insert) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Insert setQuotaUser(java.lang.String quotaUser) {
        return (Insert) super.setQuotaUser(quotaUser);
      }

      @Override
      public Insert setUploadType(java.lang.String uploadType) {
        return (Insert) super.setUploadType(uploadType);
      }

      @Override
      public Insert setUploadProtocol(java.lang.String uploadProtocol) {
        return (Insert) super.setUploadProtocol(uploadProtocol);
      }

      @com.google.api.client.util.Key
      private java.util.List<java.lang.String> part;

      /**

       */
      public java.util.List<java.lang.String> getPart() {
        return part;
      }

      public Insert setPart(java.util.List<java.lang.String> part) {
        this.part = part;
        return this;
      }

      @com.google.api.client.util.Key
      private java.lang.String externalChannelId;

      /**

       */
      public java.lang.String getExternalChannelId() {
        return externalChannelId;
      }

      public Insert setExternalChannelId(java.lang.String externalChannelId) {
        this.externalChannelId = externalChannelId;
        return this;
      }

      @Override
      public Insert set(String parameterName, Object value) {
        return (Insert) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the ThirdPartyLinks collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code YouTube youtube = new YouTube(...);}
   *   {@code YouTube.ThirdPartyLinks.List request = youtube.thirdPartyLinks().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public ThirdPartyLinks thirdPartyLinks() {
    return new ThirdPartyLinks();
  }

  /**
   * The "thirdPartyLinks" collection of methods.
   */
  public class ThirdPartyLinks {

    /**
     * Deletes a resource.
     *
     * Create a request for the method "thirdPartyLinks.delete".
     *
     * This request holds the parameters needed by the youtube server.  After setting any optional
     * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
     *
     * @param linkingToken Delete the partner links with the given linking token.
     * @param type Type of the link to be deleted.
     * @return the request
     */
    public Delete delete(java.lang.String linkingToken, java.lang.String type) throws java.io.IOException {
      Delete result = new Delete(linkingToken, type);
      initialize(result);
      return result;
    }

    public class Delete extends YouTubeRequest<Void> {

      private static final String REST_PATH = "youtube/v3/thirdPartyLinks";

      /**
       * Deletes a resource.
       *
       * Create a request for the method "thirdPartyLinks.delete".
       *
       * This request holds the parameters needed by the the youtube server.  After setting any optional
       * parameters, call the {@link Delete#execute()} method to invoke the remote operation. <p> {@link
       * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param linkingToken Delete the partner links with the given linking token.
       * @param type Type of the link to be deleted.
       * @since 1.13
       */
      protected Delete(java.lang.String linkingToken, java.lang.String type) {
        super(YouTube.this, "DELETE", REST_PATH, null, Void.class);
        this.linkingToken = com.google.api.client.util.Preconditions.checkNotNull(linkingToken, "Required parameter linkingToken must be specified.");
        this.type = com.google.api.client.util.Preconditions.checkNotNull(type, "Required parameter type must be specified.");
      }

      @Override
      public Delete set$Xgafv(java.lang.String $Xgafv) {
        return (Delete) super.set$Xgafv($Xgafv);
      }

      @Override
      public Delete setAccessToken(java.lang.String accessToken) {
        return (Delete) super.setAccessToken(accessToken);
      }

      @Override
      public Delete setAlt(java.lang.String alt) {
        return (Delete) super.setAlt(alt);
      }

      @Override
      public Delete setCallback(java.lang.String callback) {
        return (Delete) super.setCallback(callback);
      }

      @Override
      public Delete setFields(java.lang.String fields) {
        return (Delete) super.setFields(fields);
      }

      @Override
      public Delete setKey(java.lang.String key) {
        return (Delete) super.setKey(key);
      }

      @Override
      public Delete setOauthToken(java.lang.String oauthToken) {
        return (Delete) super.setOauthToken(oauthToken);
      }

      @Override
      public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Delete) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Delete setQuotaUser(java.lang.String quotaUser) {
        return (Delete) super.setQuotaUser(quotaUser);
      }

      @Override
      public Delete setUploadType(java.lang.String uploadType) {
        return (Delete) super.setUploadType(uploadType);
      }

      @Override
      public Delete setUploadProtocol(java.lang.String uploadProtocol) {
        return (Delete) super.setUploadProtocol(uploadProtocol);
      }

      /** Delete the partner links with the given linking token. */
      @com.google.api.client.util.Key
      private java.lang.String linkingToken;

      /** Delete the partner links with the given linking token.
       */
      public java.lang.String getLinkingToken() {
        return linkingToken;
      }

      /** Delete the partner links with the given linking token. */
      public Delete setLinkingToken(java.lang.String linkingToken) {
        this.linkingToken = linkingToken;
        return this;
      }

      /** Type of the link to be deleted. */
      @com.google.api.client.util.Key
      private java.lang.String type;

      /** Type of the link to be deleted.
       */
      public java.lang.String getType() {
        return type;
      }

      /** Type of the link to be deleted. */
      public Delete setType(java.lang.String type) {
        this.type = type;
        return this;
      }

      /** Channel ID to which changes should be applied, for delegation. */
      @com.google.api.client.util.Key
      private java.lang.String externalChannelId;

      /** Channel ID to which changes should be applied, for delegation.
       */
      public java.lang.String getExternalChannelId() {
        return externalChannelId;
      }

      /** Channel ID to which changes should be applied, for delegation. */
      public Delete setExternalChannelId(java.lang.String externalChannelId) {
        this.externalChannelId = externalChannelId;
        return this;
      }

      /** Do not use. Required for compatibility. */
      @com.google.api.client.util.Key
      private java.util.List<java.lang.String> part;

      /** Do not use. Required for compatibility.
       */
      public java.util.List<java.lang.String> getPart() {
        return part;
      }

      /** Do not use. Required for compatibility. */
      public Delete setPart(java.util.List<java.lang.String> part) {
        this.part = part;
        return this;
      }

      @Override
      public Delete set(String parameterName, Object value) {
        return (Delete) super.set(parameterName, value);
      }
    }
    /**
     * Inserts a new resource into this collection.
     *
     * Create a request for the method "thirdPartyLinks.insert".
     *
     * This request holds the parameters needed by the youtube server.  After setting any optional
     * parameters, call the {@link Insert#execute()} method to invoke the remote operation.
     *
     * @param part The *part* parameter specifies the thirdPartyLink resource parts that the API request and response
     *        will include. Supported values are linkingToken, status, and snippet.
     * @param content the {@link com.google.api.services.youtube.model.ThirdPartyLink}
     * @return the request
     */
    public Insert insert(java.util.List<java.lang.String> part, com.google.api.services.youtube.model.ThirdPartyLink content) throws java.io.IOException {
      Insert result = new Insert(part, content);
      initialize(result);
      return result;
    }

    public class Insert extends YouTubeRequest<com.google.api.services.youtube.model.ThirdPartyLink> {

      private static final String REST_PATH = "youtube/v3/thirdPartyLinks";

      /**
       * Inserts a new resource into this collection.
       *
       * Create a request for the method "thirdPartyLinks.insert".
       *
       * This request holds the parameters needed by the the youtube server.  After setting any optional
       * parameters, call the {@link Insert#execute()} method to invoke the remote operation. <p> {@link
       * Insert#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param part The *part* parameter specifies the thirdPartyLink resource parts that the API request and response
     *        will include. Supported values are linkingToken, status, and snippet.
       * @param content the {@link com.google.api.services.youtube.model.ThirdPartyLink}
       * @since 1.13
       */
      protected Insert(java.util.List<java.lang.String> part, com.google.api.services.youtube.model.ThirdPartyLink content) {
        super(YouTube.this, "POST", REST_PATH, content, com.google.api.services.youtube.model.ThirdPartyLink.class);
        this.part = com.google.api.client.util.Preconditions.checkNotNull(part, "Required parameter part must be specified.");
      }

      @Override
      public Insert set$Xgafv(java.lang.String $Xgafv) {
        return (Insert) super.set$Xgafv($Xgafv);
      }

      @Override
      public Insert setAccessToken(java.lang.String accessToken) {
        return (Insert) super.setAccessToken(accessToken);
      }

      @Override
      public Insert setAlt(java.lang.String alt) {
        return (Insert) super.setAlt(alt);
      }

      @Override
      public Insert setCallback(java.lang.String callback) {
        return (Insert) super.setCallback(callback);
      }

      @Override
      public Insert setFields(java.lang.String fields) {
        return (Insert) super.setFields(fields);
      }

      @Override
      public Insert setKey(java.lang.String key) {
        return (Insert) super.setKey(key);
      }

      @Override
      public Insert setOauthToken(java.lang.String oauthToken) {
        return (Insert) super.setOauthToken(oauthToken);
      }

      @Override
      public Insert setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Insert) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Insert setQuotaUser(java.lang.String quotaUser) {
        return (Insert) super.setQuotaUser(quotaUser);
      }

      @Override
      public Insert setUploadType(java.lang.String uploadType) {
        return (Insert) super.setUploadType(uploadType);
      }

      @Override
      public Insert setUploadProtocol(java.lang.String uploadProtocol) {
        return (Insert) super.setUploadProtocol(uploadProtocol);
      }

      /**
       * The *part* parameter specifies the thirdPartyLink resource parts that the API request and
       * response will include. Supported values are linkingToken, status, and snippet.
       */
      @com.google.api.client.util.Key
      private java.util.List<java.lang.String> part;

      /** The *part* parameter specifies the thirdPartyLink resource parts that the API request and response
     will include. Supported values are linkingToken, status, and snippet.
       */
      public java.util.List<java.lang.String> getPart() {
        return part;
      }

      /**
       * The *part* parameter specifies the thirdPartyLink resource parts that the API request and
       * response will include. Supported values are linkingToken, status, and snippet.
       */
      public Insert setPart(java.util.List<java.lang.String> part) {
        this.part = part;
        return this;
      }

      /** Channel ID to which changes should be applied, for delegation. */
      @com.google.api.client.util.Key
      private java.lang.String externalChannelId;

      /** Channel ID to which changes should be applied, for delegation.
       */
      public java.lang.String getExternalChannelId() {
        return externalChannelId;
      }

      /** Channel ID to which changes should be applied, for delegation. */
      public Insert setExternalChannelId(java.lang.String externalChannelId) {
        this.externalChannelId = externalChannelId;
        return this;
      }

      @Override
      public Insert set(String parameterName, Object value) {
        return (Insert) super.set(parameterName, value);
      }
    }
    /**
     * Retrieves a list of resources, possibly filtered.
     *
     * Create a request for the method "thirdPartyLinks.list".
     *
     * This request holds the parameters needed by the youtube server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param part The *part* parameter specifies the thirdPartyLink resource parts that the API response will include.
     *        Supported values are linkingToken, status, and snippet.
     * @return the request
     */
    public List list(java.util.List<java.lang.String> part) throws java.io.IOException {
      List result = new List(part);
      initialize(result);
      return result;
    }

    public class List extends YouTubeRequest<com.google.api.services.youtube.model.ThirdPartyLinkListResponse> {

      private static final String REST_PATH = "youtube/v3/thirdPartyLinks";

      /**
       * Retrieves a list of resources, possibly filtered.
       *
       * Create a request for the method "thirdPartyLinks.list".
       *
       * This request holds the parameters needed by the the youtube server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param part The *part* parameter specifies the thirdPartyLink resource parts that the API response will include.
     *        Supported values are linkingToken, status, and snippet.
       * @since 1.13
       */
      protected List(java.util.List<java.lang.String> part) {
        super(YouTube.this, "GET", REST_PATH, null, com.google.api.services.youtube.model.ThirdPartyLinkListResponse.class);
        this.part = com.google.api.client.util.Preconditions.checkNotNull(part, "Required parameter part must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List set$Xgafv(java.lang.String $Xgafv) {
        return (List) super.set$Xgafv($Xgafv);
      }

      @Override
      public List setAccessToken(java.lang.String accessToken) {
        return (List) super.setAccessToken(accessToken);
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setCallback(java.lang.String callback) {
        return (List) super.setCallback(callback);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUploadType(java.lang.String uploadType) {
        return (List) super.setUploadType(uploadType);
      }

      @Override
      public List setUploadProtocol(java.lang.String uploadProtocol) {
        return (List) super.setUploadProtocol(uploadProtocol);
      }

      /**
       * The *part* parameter specifies the thirdPartyLink resource parts that the API response will
       * include. Supported values are linkingToken, status, and snippet.
       */
      @com.google.api.client.util.Key
      private java.util.List<java.lang.String> part;

      /** The *part* parameter specifies the thirdPartyLink resource parts that the API response will
     include. Supported values are linkingToken, status, and snippet.
       */
      public java.util.List<java.lang.String> getPart() {
        return part;
      }

      /**
       * The *part* parameter specifies the thirdPartyLink resource parts that the API response will
       * include. Supported values are linkingToken, status, and snippet.
       */
      public List setPart(java.util.List<java.lang.String> part) {
        this.part = part;
        return this;
      }

      /** Channel ID to which changes should be applied, for delegation. */
      @com.google.api.client.util.Key
      private java.lang.String externalChannelId;

      /** Channel ID to which changes should be applied, for delegation.
       */
      public java.lang.String getExternalChannelId() {
        return externalChannelId;
      }

      /** Channel ID to which changes should be applied, for delegation. */
      public List setExternalChannelId(java.lang.String externalChannelId) {
        this.externalChannelId = externalChannelId;
        return this;
      }

      /** Get a third party link with the given linking token. */
      @com.google.api.client.util.Key
      private java.lang.String linkingToken;

      /** Get a third party link with the given linking token.
       */
      public java.lang.String getLinkingToken() {
        return linkingToken;
      }

      /** Get a third party link with the given linking token. */
      public List setLinkingToken(java.lang.String linkingToken) {
        this.linkingToken = linkingToken;
        return this;
      }

      /** Get a third party link of the given type. */
      @com.google.api.client.util.Key
      private java.lang.String type;

      /** Get a third party link of the given type.
       */
      public java.lang.String getType() {
        return type;
      }

      /** Get a third party link of the given type. */
      public List setType(java.lang.String type) {
        this.type = type;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }
    /**
     * Updates an existing resource.
     *
     * Create a request for the method "thirdPartyLinks.update".
     *
     * This request holds the parameters needed by the youtube server.  After setting any optional
     * parameters, call the {@link Update#execute()} method to invoke the remote operation.
     *
     * @param part The *part* parameter specifies the thirdPartyLink resource parts that the API request and response
     *        will include. Supported values are linkingToken, status, and snippet.
     * @param content the {@link com.google.api.services.youtube.model.ThirdPartyLink}
     * @return the request
     */
    public Update update(java.util.List<java.lang.String> part, com.google.api.services.youtube.model.ThirdPartyLink content) throws java.io.IOException {
      Update result = new Update(part, content);
      initialize(result);
      return result;
    }

    public class Update extends YouTubeRequest<com.google.api.services.youtube.model.ThirdPartyLink> {

      private static final String REST_PATH = "youtube/v3/thirdPartyLinks";

      /**
       * Updates an existing resource.
       *
       * Create a request for the method "thirdPartyLinks.update".
       *
       * This request holds the parameters needed by the the youtube server.  After setting any optional
       * parameters, call the {@link Update#execute()} method to invoke the remote operation. <p> {@link
       * Update#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param part The *part* parameter specifies the thirdPartyLink resource parts that the API request and response
     *        will include. Supported values are linkingToken, status, and snippet.
       * @param content the {@link com.google.api.services.youtube.model.ThirdPartyLink}
       * @since 1.13
       */
      protected Update(java.util.List<java.lang.String> part, com.google.api.services.youtube.model.ThirdPartyLink content) {
        super(YouTube.this, "PUT", REST_PATH, content, com.google.api.services.youtube.model.ThirdPartyLink.class);
        this.part = com.google.api.client.util.Preconditions.checkNotNull(part, "Required parameter part must be specified.");
      }

      @Override
      public Update set$Xgafv(java.lang.String $Xgafv) {
        return (Update) super.set$Xgafv($Xgafv);
      }

      @Override
      public Update setAccessToken(java.lang.String accessToken) {
        return (Update) super.setAccessToken(accessToken);
      }

      @Override
      public Update setAlt(java.lang.String alt) {
        return (Update) super.setAlt(alt);
      }

      @Override
      public Update setCallback(java.lang.String callback) {
        return (Update) super.setCallback(callback);
      }

      @Override
      public Update setFields(java.lang.String fields) {
        return (Update) super.setFields(fields);
      }

      @Override
      public Update setKey(java.lang.String key) {
        return (Update) super.setKey(key);
      }

      @Override
      public Update setOauthToken(java.lang.String oauthToken) {
        return (Update) super.setOauthToken(oauthToken);
      }

      @Override
      public Update setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Update) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Update setQuotaUser(java.lang.String quotaUser) {
        return (Update) super.setQuotaUser(quotaUser);
      }

      @Override
      public Update setUploadType(java.lang.String uploadType) {
        return (Update) super.setUploadType(uploadType);
      }

      @Override
      public Update setUploadProtocol(java.lang.String uploadProtocol) {
        return (Update) super.setUploadProtocol(uploadProtocol);
      }

      /**
       * The *part* parameter specifies the thirdPartyLink resource parts that the API request and
       * response will include. Supported values are linkingToken, status, and snippet.
       */
      @com.google.api.client.util.Key
      private java.util.List<java.lang.String> part;

      /** The *part* parameter specifies the thirdPartyLink resource parts that the API request and response
     will include. Supported values are linkingToken, status, and snippet.
       */
      public java.util.List<java.lang.String> getPart() {
        return part;
      }

      /**
       * The *part* parameter specifies the thirdPartyLink resource parts that the API request and
       * response will include. Supported values are linkingToken, status, and snippet.
       */
      public Update setPart(java.util.List<java.lang.String> part) {
        this.part = part;
        return this;
      }

      /** Channel ID to which changes should be applied, for delegation. */
      @com.google.api.client.util.Key
      private java.lang.String externalChannelId;

      /** Channel ID to which changes should be applied, for delegation.
       */
      public java.lang.String getExternalChannelId() {
        return externalChannelId;
      }

      /** Channel ID to which changes should be applied, for delegation. */
      public Update setExternalChannelId(java.lang.String externalChannelId) {
        this.externalChannelId = externalChannelId;
        return this;
      }

      @Override
      public Update set(String parameterName, Object value) {
        return (Update) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the Thumbnails collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code YouTube youtube = new YouTube(...);}
   *   {@code YouTube.Thumbnails.List request = youtube.thumbnails().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Thumbnails thumbnails() {
    return new Thumbnails();
  }

  /**
   * The "thumbnails" collection of methods.
   */
  public class Thumbnails {

    /**
     * As this is not an insert in a strict sense (it supports uploading/setting of a thumbnail for
     * multiple videos, which doesn't result in creation of a single resource), I use a custom verb
     * here.
     *
     * Create a request for the method "thumbnails.set".
     *
     * This request holds the parameters needed by the youtube server.  After setting any optional
     * parameters, call the {@link Set#execute()} method to invoke the remote operation.
     *
     * @param videoId Returns the Thumbnail with the given video IDs for Stubby or Apiary.
     * @return the request
     */
    public Set set(java.lang.String videoId) throws java.io.IOException {
      Set result = new Set(videoId);
      initialize(result);
      return result;
    }

    /**
     * As this is not an insert in a strict sense (it supports uploading/setting of a thumbnail for
     * multiple videos, which doesn't result in creation of a single resource), I use a custom verb
     * here.
     *
     * Create a request for the method "thumbnails.set".
     *
     * This request holds the parameters needed by the the youtube server.  After setting any optional
     * parameters, call the {@link Set#execute()} method to invoke the remote operation.
     *
     * <p>
     * This method should be used for uploading media content.
     * </p>
     *
     * @param videoId Returns the Thumbnail with the given video IDs for Stubby or Apiary.
     * @param mediaContent The media HTTP content or {@code null} if none.
     * @return the request
     * @throws java.io.IOException if the initialization of the request fails
     */
    public Set set(java.lang.String videoId, com.google.api.client.http.AbstractInputStreamContent mediaContent) throws java.io.IOException {
      Set result = new Set(videoId, mediaContent);
      initialize(result);
      return result;
    }

    public class Set extends YouTubeRequest<com.google.api.services.youtube.model.ThumbnailSetResponse> {

      private static final String REST_PATH = "youtube/v3/thumbnails/set";

      /**
       * As this is not an insert in a strict sense (it supports uploading/setting of a thumbnail for
       * multiple videos, which doesn't result in creation of a single resource), I use a custom verb
       * here.
       *
       * Create a request for the method "thumbnails.set".
       *
       * This request holds the parameters needed by the the youtube server.  After setting any optional
       * parameters, call the {@link Set#execute()} method to invoke the remote operation. <p> {@link
       * Set#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param videoId Returns the Thumbnail with the given video IDs for Stubby or Apiary.
       * @since 1.13
       */
      protected Set(java.lang.String videoId) {
        super(YouTube.this, "POST", REST_PATH, null, com.google.api.services.youtube.model.ThumbnailSetResponse.class);
        this.videoId = com.google.api.client.util.Preconditions.checkNotNull(videoId, "Required parameter videoId must be specified.");
      }

      /**
       * As this is not an insert in a strict sense (it supports uploading/setting of a thumbnail for
       * multiple videos, which doesn't result in creation of a single resource), I use a custom verb
       * here.
       *
       * Create a request for the method "thumbnails.set".
       *
       * This request holds the parameters needed by the the youtube server.  After setting any optional
       * parameters, call the {@link Set#execute()} method to invoke the remote operation. <p> {@link
       * Set#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * <p>
       * This constructor should be used for uploading media content.
       * </p>
       *
       * @param videoId Returns the Thumbnail with the given video IDs for Stubby or Apiary.
       * @param mediaContent The media HTTP content or {@code null} if none.
       * @since 1.13
       */
      protected Set(java.lang.String videoId, com.google.api.client.http.AbstractInputStreamContent mediaContent) {
        super(YouTube.this, "POST", "/upload/" + getServicePath() + REST_PATH, null, com.google.api.services.youtube.model.ThumbnailSetResponse.class);
        this.videoId = com.google.api.client.util.Preconditions.checkNotNull(videoId, "Required parameter videoId must be specified.");
        initializeMediaUpload(mediaContent);
      }

      @Override
      public Set set$Xgafv(java.lang.String $Xgafv) {
        return (Set) super.set$Xgafv($Xgafv);
      }

      @Override
      public Set setAccessToken(java.lang.String accessToken) {
        return (Set) super.setAccessToken(accessToken);
      }

      @Override
      public Set setAlt(java.lang.String alt) {
        return (Set) super.setAlt(alt);
      }

      @Override
      public Set setCallback(java.lang.String callback) {
        return (Set) super.setCallback(callback);
      }

      @Override
      public Set setFields(java.lang.String fields) {
        return (Set) super.setFields(fields);
      }

      @Override
      public Set setKey(java.lang.String key) {
        return (Set) super.setKey(key);
      }

      @Override
      public Set setOauthToken(java.lang.String oauthToken) {
        return (Set) super.setOauthToken(oauthToken);
      }

      @Override
      public Set setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Set) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Set setQuotaUser(java.lang.String quotaUser) {
        return (Set) super.setQuotaUser(quotaUser);
      }

      @Override
      public Set setUploadType(java.lang.String uploadType) {
        return (Set) super.setUploadType(uploadType);
      }

      @Override
      public Set setUploadProtocol(java.lang.String uploadProtocol) {
        return (Set) super.setUploadProtocol(uploadProtocol);
      }

      /** Returns the Thumbnail with the given video IDs for Stubby or Apiary. */
      @com.google.api.client.util.Key
      private java.lang.String videoId;

      /** Returns the Thumbnail with the given video IDs for Stubby or Apiary.
       */
      public java.lang.String getVideoId() {
        return videoId;
      }

      /** Returns the Thumbnail with the given video IDs for Stubby or Apiary. */
      public Set setVideoId(java.lang.String videoId) {
        this.videoId = videoId;
        return this;
      }

      /**
       * *Note:* This parameter is intended exclusively for YouTube content partners. The
       * *onBehalfOfContentOwner* parameter indicates that the request's authorization credentials
       * identify a YouTube CMS user who is acting on behalf of the content owner specified in the
       * parameter value. This parameter is intended for YouTube content partners that own and
       * manage many different YouTube channels. It allows content owners to authenticate once and
       * get access to all their video and channel data, without having to provide authentication
       * credentials for each individual channel. The actual CMS account that the user authenticates
       * with must be linked to the specified YouTube content owner.
       */
      @com.google.api.client.util.Key
      private java.lang.String onBehalfOfContentOwner;

      /*** Note:* This parameter is intended exclusively for YouTube content partners. The
    * *onBehalfOfContentOwner* parameter indicates that the request's authorization credentials identify
    * a YouTube CMS user who is acting on behalf of the content owner specified in the parameter value.
    * This parameter is intended for YouTube content partners that own and manage many different YouTube
    * channels. It allows content owners to authenticate once and get access to all their video and
    * channel data, without having to provide authentication credentials for each individual channel.
    * The actual CMS account that the user authenticates with must be linked to the specified YouTube
    * content owner.
    *

       */
      public java.lang.String getOnBehalfOfContentOwner() {
        return onBehalfOfContentOwner;
      }

      /**
       * *Note:* This parameter is intended exclusively for YouTube content partners. The
       * *onBehalfOfContentOwner* parameter indicates that the request's authorization credentials
       * identify a YouTube CMS user who is acting on behalf of the content owner specified in the
       * parameter value. This parameter is intended for YouTube content partners that own and
       * manage many different YouTube channels. It allows content owners to authenticate once and
       * get access to all their video and channel data, without having to provide authentication
       * credentials for each individual channel. The actual CMS account that the user authenticates
       * with must be linked to the specified YouTube content owner.
       */
      public Set setOnBehalfOfContentOwner(java.lang.String onBehalfOfContentOwner) {
        this.onBehalfOfContentOwner = onBehalfOfContentOwner;
        return this;
      }

      @Override
      public Set set(String parameterName, Object value) {
        return (Set) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the VideoAbuseReportReasons collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code YouTube youtube = new YouTube(...);}
   *   {@code YouTube.VideoAbuseReportReasons.List request = youtube.videoAbuseReportReasons().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public VideoAbuseReportReasons videoAbuseReportReasons() {
    return new VideoAbuseReportReasons();
  }

  /**
   * The "videoAbuseReportReasons" collection of methods.
   */
  public class VideoAbuseReportReasons {

    /**
     * Retrieves a list of resources, possibly filtered.
     *
     * Create a request for the method "videoAbuseReportReasons.list".
     *
     * This request holds the parameters needed by the youtube server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param part The *part* parameter specifies the videoCategory resource parts that the API response will include.
     *        Supported values are id and snippet.
     * @return the request
     */
    public List list(java.util.List<java.lang.String> part) throws java.io.IOException {
      List result = new List(part);
      initialize(result);
      return result;
    }

    public class List extends YouTubeRequest<com.google.api.services.youtube.model.VideoAbuseReportReasonListResponse> {

      private static final String REST_PATH = "youtube/v3/videoAbuseReportReasons";

      /**
       * Retrieves a list of resources, possibly filtered.
       *
       * Create a request for the method "videoAbuseReportReasons.list".
       *
       * This request holds the parameters needed by the the youtube server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param part The *part* parameter specifies the videoCategory resource parts that the API response will include.
     *        Supported values are id and snippet.
       * @since 1.13
       */
      protected List(java.util.List<java.lang.String> part) {
        super(YouTube.this, "GET", REST_PATH, null, com.google.api.services.youtube.model.VideoAbuseReportReasonListResponse.class);
        this.part = com.google.api.client.util.Preconditions.checkNotNull(part, "Required parameter part must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List set$Xgafv(java.lang.String $Xgafv) {
        return (List) super.set$Xgafv($Xgafv);
      }

      @Override
      public List setAccessToken(java.lang.String accessToken) {
        return (List) super.setAccessToken(accessToken);
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setCallback(java.lang.String callback) {
        return (List) super.setCallback(callback);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUploadType(java.lang.String uploadType) {
        return (List) super.setUploadType(uploadType);
      }

      @Override
      public List setUploadProtocol(java.lang.String uploadProtocol) {
        return (List) super.setUploadProtocol(uploadProtocol);
      }

      /**
       * The *part* parameter specifies the videoCategory resource parts that the API response will
       * include. Supported values are id and snippet.
       */
      @com.google.api.client.util.Key
      private java.util.List<java.lang.String> part;

      /** The *part* parameter specifies the videoCategory resource parts that the API response will include.
     Supported values are id and snippet.
       */
      public java.util.List<java.lang.String> getPart() {
        return part;
      }

      /**
       * The *part* parameter specifies the videoCategory resource parts that the API response will
       * include. Supported values are id and snippet.
       */
      public List setPart(java.util.List<java.lang.String> part) {
        this.part = part;
        return this;
      }

      @com.google.api.client.util.Key
      private java.lang.String hl;

      /**
     [ default: en-US]
     [

       */
      public java.lang.String getHl() {
        return hl;
      }

      public List setHl(java.lang.String hl) {
        this.hl = hl;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the VideoCategories collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code YouTube youtube = new YouTube(...);}
   *   {@code YouTube.VideoCategories.List request = youtube.videoCategories().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public VideoCategories videoCategories() {
    return new VideoCategories();
  }

  /**
   * The "videoCategories" collection of methods.
   */
  public class VideoCategories {

    /**
     * Retrieves a list of resources, possibly filtered.
     *
     * Create a request for the method "videoCategories.list".
     *
     * This request holds the parameters needed by the youtube server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param part The *part* parameter specifies the videoCategory resource properties that the API response will
     *        include. Set the parameter value to snippet.
     * @return the request
     */
    public List list(java.util.List<java.lang.String> part) throws java.io.IOException {
      List result = new List(part);
      initialize(result);
      return result;
    }

    public class List extends YouTubeRequest<com.google.api.services.youtube.model.VideoCategoryListResponse> {

      private static final String REST_PATH = "youtube/v3/videoCategories";

      /**
       * Retrieves a list of resources, possibly filtered.
       *
       * Create a request for the method "videoCategories.list".
       *
       * This request holds the parameters needed by the the youtube server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param part The *part* parameter specifies the videoCategory resource properties that the API response will
     *        include. Set the parameter value to snippet.
       * @since 1.13
       */
      protected List(java.util.List<java.lang.String> part) {
        super(YouTube.this, "GET", REST_PATH, null, com.google.api.services.youtube.model.VideoCategoryListResponse.class);
        this.part = com.google.api.client.util.Preconditions.checkNotNull(part, "Required parameter part must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List set$Xgafv(java.lang.String $Xgafv) {
        return (List) super.set$Xgafv($Xgafv);
      }

      @Override
      public List setAccessToken(java.lang.String accessToken) {
        return (List) super.setAccessToken(accessToken);
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setCallback(java.lang.String callback) {
        return (List) super.setCallback(callback);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUploadType(java.lang.String uploadType) {
        return (List) super.setUploadType(uploadType);
      }

      @Override
      public List setUploadProtocol(java.lang.String uploadProtocol) {
        return (List) super.setUploadProtocol(uploadProtocol);
      }

      /**
       * The *part* parameter specifies the videoCategory resource properties that the API response
       * will include. Set the parameter value to snippet.
       */
      @com.google.api.client.util.Key
      private java.util.List<java.lang.String> part;

      /** The *part* parameter specifies the videoCategory resource properties that the API response will
     include. Set the parameter value to snippet.
       */
      public java.util.List<java.lang.String> getPart() {
        return part;
      }

      /**
       * The *part* parameter specifies the videoCategory resource properties that the API response
       * will include. Set the parameter value to snippet.
       */
      public List setPart(java.util.List<java.lang.String> part) {
        this.part = part;
        return this;
      }

      @com.google.api.client.util.Key
      private java.lang.String hl;

      /**
     [ default: en-US]
     [

       */
      public java.lang.String getHl() {
        return hl;
      }

      public List setHl(java.lang.String hl) {
        this.hl = hl;
        return this;
      }

      /** Returns the video categories with the given IDs for Stubby or Apiary. */
      @com.google.api.client.util.Key
      private java.util.List<java.lang.String> id;

      /** Returns the video categories with the given IDs for Stubby or Apiary.
       */
      public java.util.List<java.lang.String> getId() {
        return id;
      }

      /** Returns the video categories with the given IDs for Stubby or Apiary. */
      public List setId(java.util.List<java.lang.String> id) {
        this.id = id;
        return this;
      }

      @com.google.api.client.util.Key
      private java.lang.String regionCode;

      /**

       */
      public java.lang.String getRegionCode() {
        return regionCode;
      }

      public List setRegionCode(java.lang.String regionCode) {
        this.regionCode = regionCode;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the Videos collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code YouTube youtube = new YouTube(...);}
   *   {@code YouTube.Videos.List request = youtube.videos().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Videos videos() {
    return new Videos();
  }

  /**
   * The "videos" collection of methods.
   */
  public class Videos {

    /**
     * Deletes a resource.
     *
     * Create a request for the method "videos.delete".
     *
     * This request holds the parameters needed by the youtube server.  After setting any optional
     * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
     *
     * @param id
     * @return the request
     */
    public Delete delete(java.lang.String id) throws java.io.IOException {
      Delete result = new Delete(id);
      initialize(result);
      return result;
    }

    public class Delete extends YouTubeRequest<Void> {

      private static final String REST_PATH = "youtube/v3/videos";

      /**
       * Deletes a resource.
       *
       * Create a request for the method "videos.delete".
       *
       * This request holds the parameters needed by the the youtube server.  After setting any optional
       * parameters, call the {@link Delete#execute()} method to invoke the remote operation. <p> {@link
       * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param id
       * @since 1.13
       */
      protected Delete(java.lang.String id) {
        super(YouTube.this, "DELETE", REST_PATH, null, Void.class);
        this.id = com.google.api.client.util.Preconditions.checkNotNull(id, "Required parameter id must be specified.");
      }

      @Override
      public Delete set$Xgafv(java.lang.String $Xgafv) {
        return (Delete) super.set$Xgafv($Xgafv);
      }

      @Override
      public Delete setAccessToken(java.lang.String accessToken) {
        return (Delete) super.setAccessToken(accessToken);
      }

      @Override
      public Delete setAlt(java.lang.String alt) {
        return (Delete) super.setAlt(alt);
      }

      @Override
      public Delete setCallback(java.lang.String callback) {
        return (Delete) super.setCallback(callback);
      }

      @Override
      public Delete setFields(java.lang.String fields) {
        return (Delete) super.setFields(fields);
      }

      @Override
      public Delete setKey(java.lang.String key) {
        return (Delete) super.setKey(key);
      }

      @Override
      public Delete setOauthToken(java.lang.String oauthToken) {
        return (Delete) super.setOauthToken(oauthToken);
      }

      @Override
      public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Delete) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Delete setQuotaUser(java.lang.String quotaUser) {
        return (Delete) super.setQuotaUser(quotaUser);
      }

      @Override
      public Delete setUploadType(java.lang.String uploadType) {
        return (Delete) super.setUploadType(uploadType);
      }

      @Override
      public Delete setUploadProtocol(java.lang.String uploadProtocol) {
        return (Delete) super.setUploadProtocol(uploadProtocol);
      }

      @com.google.api.client.util.Key
      private java.lang.String id;

      /**

       */
      public java.lang.String getId() {
        return id;
      }

      public Delete setId(java.lang.String id) {
        this.id = id;
        return this;
      }

      /**
       * *Note:* This parameter is intended exclusively for YouTube content partners. The
       * *onBehalfOfContentOwner* parameter indicates that the request's authorization credentials
       * identify a YouTube CMS user who is acting on behalf of the content owner specified in the
       * parameter value. This parameter is intended for YouTube content partners that own and
       * manage many different YouTube channels. It allows content owners to authenticate once and
       * get access to all their video and channel data, without having to provide authentication
       * credentials for each individual channel. The actual CMS account that the user authenticates
       * with must be linked to the specified YouTube content owner.
       */
      @com.google.api.client.util.Key
      private java.lang.String onBehalfOfContentOwner;

      /*** Note:* This parameter is intended exclusively for YouTube content partners. The
    * *onBehalfOfContentOwner* parameter indicates that the request's authorization credentials identify
    * a YouTube CMS user who is acting on behalf of the content owner specified in the parameter value.
    * This parameter is intended for YouTube content partners that own and manage many different YouTube
    * channels. It allows content owners to authenticate once and get access to all their video and
    * channel data, without having to provide authentication credentials for each individual channel.
    * The actual CMS account that the user authenticates with must be linked to the specified YouTube
    * content owner.
    *

       */
      public java.lang.String getOnBehalfOfContentOwner() {
        return onBehalfOfContentOwner;
      }

      /**
       * *Note:* This parameter is intended exclusively for YouTube content partners. The
       * *onBehalfOfContentOwner* parameter indicates that the request's authorization credentials
       * identify a YouTube CMS user who is acting on behalf of the content owner specified in the
       * parameter value. This parameter is intended for YouTube content partners that own and
       * manage many different YouTube channels. It allows content owners to authenticate once and
       * get access to all their video and channel data, without having to provide authentication
       * credentials for each individual channel. The actual CMS account that the user authenticates
       * with must be linked to the specified YouTube content owner.
       */
      public Delete setOnBehalfOfContentOwner(java.lang.String onBehalfOfContentOwner) {
        this.onBehalfOfContentOwner = onBehalfOfContentOwner;
        return this;
      }

      @Override
      public Delete set(String parameterName, Object value) {
        return (Delete) super.set(parameterName, value);
      }
    }
    /**
     * Retrieves the ratings that the authorized user gave to a list of specified videos.
     *
     * Create a request for the method "videos.getRating".
     *
     * This request holds the parameters needed by the youtube server.  After setting any optional
     * parameters, call the {@link GetRating#execute()} method to invoke the remote operation.
     *
     * @param id
     * @return the request
     */
    public GetRating getRating(java.util.List<java.lang.String> id) throws java.io.IOException {
      GetRating result = new GetRating(id);
      initialize(result);
      return result;
    }

    public class GetRating extends YouTubeRequest<com.google.api.services.youtube.model.VideoGetRatingResponse> {

      private static final String REST_PATH = "youtube/v3/videos/getRating";

      /**
       * Retrieves the ratings that the authorized user gave to a list of specified videos.
       *
       * Create a request for the method "videos.getRating".
       *
       * This request holds the parameters needed by the the youtube server.  After setting any optional
       * parameters, call the {@link GetRating#execute()} method to invoke the remote operation. <p>
       * {@link
       * GetRating#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param id
       * @since 1.13
       */
      protected GetRating(java.util.List<java.lang.String> id) {
        super(YouTube.this, "GET", REST_PATH, null, com.google.api.services.youtube.model.VideoGetRatingResponse.class);
        this.id = com.google.api.client.util.Preconditions.checkNotNull(id, "Required parameter id must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public GetRating set$Xgafv(java.lang.String $Xgafv) {
        return (GetRating) super.set$Xgafv($Xgafv);
      }

      @Override
      public GetRating setAccessToken(java.lang.String accessToken) {
        return (GetRating) super.setAccessToken(accessToken);
      }

      @Override
      public GetRating setAlt(java.lang.String alt) {
        return (GetRating) super.setAlt(alt);
      }

      @Override
      public GetRating setCallback(java.lang.String callback) {
        return (GetRating) super.setCallback(callback);
      }

      @Override
      public GetRating setFields(java.lang.String fields) {
        return (GetRating) super.setFields(fields);
      }

      @Override
      public GetRating setKey(java.lang.String key) {
        return (GetRating) super.setKey(key);
      }

      @Override
      public GetRating setOauthToken(java.lang.String oauthToken) {
        return (GetRating) super.setOauthToken(oauthToken);
      }

      @Override
      public GetRating setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (GetRating) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public GetRating setQuotaUser(java.lang.String quotaUser) {
        return (GetRating) super.setQuotaUser(quotaUser);
      }

      @Override
      public GetRating setUploadType(java.lang.String uploadType) {
        return (GetRating) super.setUploadType(uploadType);
      }

      @Override
      public GetRating setUploadProtocol(java.lang.String uploadProtocol) {
        return (GetRating) super.setUploadProtocol(uploadProtocol);
      }

      @com.google.api.client.util.Key
      private java.util.List<java.lang.String> id;

      /**

       */
      public java.util.List<java.lang.String> getId() {
        return id;
      }

      public GetRating setId(java.util.List<java.lang.String> id) {
        this.id = id;
        return this;
      }

      /**
       * *Note:* This parameter is intended exclusively for YouTube content partners. The
       * *onBehalfOfContentOwner* parameter indicates that the request's authorization credentials
       * identify a YouTube CMS user who is acting on behalf of the content owner specified in the
       * parameter value. This parameter is intended for YouTube content partners that own and
       * manage many different YouTube channels. It allows content owners to authenticate once and
       * get access to all their video and channel data, without having to provide authentication
       * credentials for each individual channel. The CMS account that the user authenticates with
       * must be linked to the specified YouTube content owner.
       */
      @com.google.api.client.util.Key
      private java.lang.String onBehalfOfContentOwner;

      /*** Note:* This parameter is intended exclusively for YouTube content partners. The
    * *onBehalfOfContentOwner* parameter indicates that the request's authorization credentials identify
    * a YouTube CMS user who is acting on behalf of the content owner specified in the parameter value.
    * This parameter is intended for YouTube content partners that own and manage many different YouTube
    * channels. It allows content owners to authenticate once and get access to all their video and
    * channel data, without having to provide authentication credentials for each individual channel.
    * The CMS account that the user authenticates with must be linked to the specified YouTube content
    * owner.
    *

       */
      public java.lang.String getOnBehalfOfContentOwner() {
        return onBehalfOfContentOwner;
      }

      /**
       * *Note:* This parameter is intended exclusively for YouTube content partners. The
       * *onBehalfOfContentOwner* parameter indicates that the request's authorization credentials
       * identify a YouTube CMS user who is acting on behalf of the content owner specified in the
       * parameter value. This parameter is intended for YouTube content partners that own and
       * manage many different YouTube channels. It allows content owners to authenticate once and
       * get access to all their video and channel data, without having to provide authentication
       * credentials for each individual channel. The CMS account that the user authenticates with
       * must be linked to the specified YouTube content owner.
       */
      public GetRating setOnBehalfOfContentOwner(java.lang.String onBehalfOfContentOwner) {
        this.onBehalfOfContentOwner = onBehalfOfContentOwner;
        return this;
      }

      @Override
      public GetRating set(String parameterName, Object value) {
        return (GetRating) super.set(parameterName, value);
      }
    }
    /**
     * Inserts a new resource into this collection.
     *
     * Create a request for the method "videos.insert".
     *
     * This request holds the parameters needed by the youtube server.  After setting any optional
     * parameters, call the {@link Insert#execute()} method to invoke the remote operation.
     *
     * @param part The *part* parameter serves two purposes in this operation. It identifies the properties that the
     *        write operation will set as well as the properties that the API response will include.
     *        Note that not all parts contain properties that can be set when inserting or updating a
     *        video. For example, the statistics object encapsulates statistics that YouTube calculates
     *        for a video and does not contain values that you can set or modify. If the parameter value
     *        specifies a part that does not contain mutable values, that part will still be included in
     *        the API response.
     * @param content the {@link com.google.api.services.youtube.model.Video}
     * @return the request
     */
    public Insert insert(java.util.List<java.lang.String> part, com.google.api.services.youtube.model.Video content) throws java.io.IOException {
      Insert result = new Insert(part, content);
      initialize(result);
      return result;
    }

    /**
     * Inserts a new resource into this collection.
     *
     * Create a request for the method "videos.insert".
     *
     * This request holds the parameters needed by the the youtube server.  After setting any optional
     * parameters, call the {@link Insert#execute()} method to invoke the remote operation.
     *
     * <p>
     * This method should be used for uploading media content.
     * </p>
     *
     * @param part The *part* parameter serves two purposes in this operation. It identifies the properties that the
     *        write operation will set as well as the properties that the API response will include.
     *        Note that not all parts contain properties that can be set when inserting or updating a
     *        video. For example, the statistics object encapsulates statistics that YouTube calculates
     *        for a video and does not contain values that you can set or modify. If the parameter value
     *        specifies a part that does not contain mutable values, that part will still be included in
     *        the API response.
     * @param content the {@link com.google.api.services.youtube.model.Video} media metadata or {@code null} if none
     * @param mediaContent The media HTTP content or {@code null} if none.
     * @return the request
     * @throws java.io.IOException if the initialization of the request fails
     */
    public Insert insert(java.util.List<java.lang.String> part, com.google.api.services.youtube.model.Video content, com.google.api.client.http.AbstractInputStreamContent mediaContent) throws java.io.IOException {
      Insert result = new Insert(part, content, mediaContent);
      initialize(result);
      return result;
    }

    public class Insert extends YouTubeRequest<com.google.api.services.youtube.model.Video> {

      private static final String REST_PATH = "youtube/v3/videos";

      /**
       * Inserts a new resource into this collection.
       *
       * Create a request for the method "videos.insert".
       *
       * This request holds the parameters needed by the the youtube server.  After setting any optional
       * parameters, call the {@link Insert#execute()} method to invoke the remote operation. <p> {@link
       * Insert#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param part The *part* parameter serves two purposes in this operation. It identifies the properties that the
     *        write operation will set as well as the properties that the API response will include.
     *        Note that not all parts contain properties that can be set when inserting or updating a
     *        video. For example, the statistics object encapsulates statistics that YouTube calculates
     *        for a video and does not contain values that you can set or modify. If the parameter value
     *        specifies a part that does not contain mutable values, that part will still be included in
     *        the API response.
       * @param content the {@link com.google.api.services.youtube.model.Video}
       * @since 1.13
       */
      protected Insert(java.util.List<java.lang.String> part, com.google.api.services.youtube.model.Video content) {
        super(YouTube.this, "POST", REST_PATH, content, com.google.api.services.youtube.model.Video.class);
        this.part = com.google.api.client.util.Preconditions.checkNotNull(part, "Required parameter part must be specified.");
      }

      /**
       * Inserts a new resource into this collection.
       *
       * Create a request for the method "videos.insert".
       *
       * This request holds the parameters needed by the the youtube server.  After setting any optional
       * parameters, call the {@link Insert#execute()} method to invoke the remote operation. <p> {@link
       * Insert#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * <p>
       * This constructor should be used for uploading media content.
       * </p>
       *
       * @param part The *part* parameter serves two purposes in this operation. It identifies the properties that the
     *        write operation will set as well as the properties that the API response will include.
     *        Note that not all parts contain properties that can be set when inserting or updating a
     *        video. For example, the statistics object encapsulates statistics that YouTube calculates
     *        for a video and does not contain values that you can set or modify. If the parameter value
     *        specifies a part that does not contain mutable values, that part will still be included in
     *        the API response.
       * @param content the {@link com.google.api.services.youtube.model.Video} media metadata or {@code null} if none
       * @param mediaContent The media HTTP content or {@code null} if none.
       * @since 1.13
       */
      protected Insert(java.util.List<java.lang.String> part, com.google.api.services.youtube.model.Video content, com.google.api.client.http.AbstractInputStreamContent mediaContent) {
        super(YouTube.this, "POST", "/upload/" + getServicePath() + REST_PATH, content, com.google.api.services.youtube.model.Video.class);
        this.part = com.google.api.client.util.Preconditions.checkNotNull(part, "Required parameter part must be specified.");
        initializeMediaUpload(mediaContent);
      }

      @Override
      public Insert set$Xgafv(java.lang.String $Xgafv) {
        return (Insert) super.set$Xgafv($Xgafv);
      }

      @Override
      public Insert setAccessToken(java.lang.String accessToken) {
        return (Insert) super.setAccessToken(accessToken);
      }

      @Override
      public Insert setAlt(java.lang.String alt) {
        return (Insert) super.setAlt(alt);
      }

      @Override
      public Insert setCallback(java.lang.String callback) {
        return (Insert) super.setCallback(callback);
      }

      @Override
      public Insert setFields(java.lang.String fields) {
        return (Insert) super.setFields(fields);
      }

      @Override
      public Insert setKey(java.lang.String key) {
        return (Insert) super.setKey(key);
      }

      @Override
      public Insert setOauthToken(java.lang.String oauthToken) {
        return (Insert) super.setOauthToken(oauthToken);
      }

      @Override
      public Insert setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Insert) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Insert setQuotaUser(java.lang.String quotaUser) {
        return (Insert) super.setQuotaUser(quotaUser);
      }

      @Override
      public Insert setUploadType(java.lang.String uploadType) {
        return (Insert) super.setUploadType(uploadType);
      }

      @Override
      public Insert setUploadProtocol(java.lang.String uploadProtocol) {
        return (Insert) super.setUploadProtocol(uploadProtocol);
      }

      /**
       * The *part* parameter serves two purposes in this operation. It identifies the properties
       * that the write operation will set as well as the properties that the API response will
       * include. Note that not all parts contain properties that can be set when inserting or
       * updating a video. For example, the statistics object encapsulates statistics that YouTube
       * calculates for a video and does not contain values that you can set or modify. If the
       * parameter value specifies a part that does not contain mutable values, that part will still
       * be included in the API response.
       */
      @com.google.api.client.util.Key
      private java.util.List<java.lang.String> part;

      /** The *part* parameter serves two purposes in this operation. It identifies the properties that the
     write operation will set as well as the properties that the API response will include. Note that
     not all parts contain properties that can be set when inserting or updating a video. For example,
     the statistics object encapsulates statistics that YouTube calculates for a video and does not
     contain values that you can set or modify. If the parameter value specifies a part that does not
     contain mutable values, that part will still be included in the API response.
       */
      public java.util.List<java.lang.String> getPart() {
        return part;
      }

      /**
       * The *part* parameter serves two purposes in this operation. It identifies the properties
       * that the write operation will set as well as the properties that the API response will
       * include. Note that not all parts contain properties that can be set when inserting or
       * updating a video. For example, the statistics object encapsulates statistics that YouTube
       * calculates for a video and does not contain values that you can set or modify. If the
       * parameter value specifies a part that does not contain mutable values, that part will still
       * be included in the API response.
       */
      public Insert setPart(java.util.List<java.lang.String> part) {
        this.part = part;
        return this;
      }

      /** Should auto-levels be applied to the upload. */
      @com.google.api.client.util.Key
      private java.lang.Boolean autoLevels;

      /** Should auto-levels be applied to the upload.
       */
      public java.lang.Boolean getAutoLevels() {
        return autoLevels;
      }

      /** Should auto-levels be applied to the upload. */
      public Insert setAutoLevels(java.lang.Boolean autoLevels) {
        this.autoLevels = autoLevels;
        return this;
      }

      /**
       * Notify the channel subscribers about the new video. As default, the notification is
       * enabled.
       */
      @com.google.api.client.util.Key
      private java.lang.Boolean notifySubscribers;

      /** Notify the channel subscribers about the new video. As default, the notification is enabled.
     [default: true]
       */
      public java.lang.Boolean getNotifySubscribers() {
        return notifySubscribers;
      }

      /**
       * Notify the channel subscribers about the new video. As default, the notification is
       * enabled.
       */
      public Insert setNotifySubscribers(java.lang.Boolean notifySubscribers) {
        this.notifySubscribers = notifySubscribers;
        return this;
      }

      /**
       * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
       *
       * <p>
       * Boolean properties can have four possible values:
       * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
       * or {@link Boolean#FALSE}.
       * </p>
       *
       * <p>
       * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
       * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
       * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * </p>
       *
       * <p>
       * Notify the channel subscribers about the new video. As default, the notification is enabled.
       * </p>
       */
      public boolean isNotifySubscribers() {
        if (notifySubscribers == null || notifySubscribers == com.google.api.client.util.Data.NULL_BOOLEAN) {
          return true;
        }
        return notifySubscribers;
      }

      /**
       * *Note:* This parameter is intended exclusively for YouTube content partners. The
       * *onBehalfOfContentOwner* parameter indicates that the request's authorization credentials
       * identify a YouTube CMS user who is acting on behalf of the content owner specified in the
       * parameter value. This parameter is intended for YouTube content partners that own and
       * manage many different YouTube channels. It allows content owners to authenticate once and
       * get access to all their video and channel data, without having to provide authentication
       * credentials for each individual channel. The CMS account that the user authenticates with
       * must be linked to the specified YouTube content owner.
       */
      @com.google.api.client.util.Key
      private java.lang.String onBehalfOfContentOwner;

      /*** Note:* This parameter is intended exclusively for YouTube content partners. The
    * *onBehalfOfContentOwner* parameter indicates that the request's authorization credentials identify
    * a YouTube CMS user who is acting on behalf of the content owner specified in the parameter value.
    * This parameter is intended for YouTube content partners that own and manage many different YouTube
    * channels. It allows content owners to authenticate once and get access to all their video and
    * channel data, without having to provide authentication credentials for each individual channel.
    * The CMS account that the user authenticates with must be linked to the specified YouTube content
    * owner.
    *

       */
      public java.lang.String getOnBehalfOfContentOwner() {
        return onBehalfOfContentOwner;
      }

      /**
       * *Note:* This parameter is intended exclusively for YouTube content partners. The
       * *onBehalfOfContentOwner* parameter indicates that the request's authorization credentials
       * identify a YouTube CMS user who is acting on behalf of the content owner specified in the
       * parameter value. This parameter is intended for YouTube content partners that own and
       * manage many different YouTube channels. It allows content owners to authenticate once and
       * get access to all their video and channel data, without having to provide authentication
       * credentials for each individual channel. The CMS account that the user authenticates with
       * must be linked to the specified YouTube content owner.
       */
      public Insert setOnBehalfOfContentOwner(java.lang.String onBehalfOfContentOwner) {
        this.onBehalfOfContentOwner = onBehalfOfContentOwner;
        return this;
      }

      /**
       * This parameter can only be used in a properly authorized request. *Note:* This parameter is
       * intended exclusively for YouTube content partners. The *onBehalfOfContentOwnerChannel*
       * parameter specifies the YouTube channel ID of the channel to which a video is being added.
       * This parameter is required when a request specifies a value for the onBehalfOfContentOwner
       * parameter, and it can only be used in conjunction with that parameter. In addition, the
       * request must be authorized using a CMS account that is linked to the content owner that the
       * onBehalfOfContentOwner parameter specifies. Finally, the channel that the
       * onBehalfOfContentOwnerChannel parameter value specifies must be linked to the content owner
       * that the onBehalfOfContentOwner parameter specifies. This parameter is intended for YouTube
       * content partners that own and manage many different YouTube channels. It allows content
       * owners to authenticate once and perform actions on behalf of the channel specified in the
       * parameter value, without having to provide authentication credentials for each separate
       * channel.
       */
      @com.google.api.client.util.Key
      private java.lang.String onBehalfOfContentOwnerChannel;

      /** This parameter can only be used in a properly authorized request. *Note:* This parameter is
     intended exclusively for YouTube content partners. The *onBehalfOfContentOwnerChannel* parameter
     specifies the YouTube channel ID of the channel to which a video is being added. This parameter is
     required when a request specifies a value for the onBehalfOfContentOwner parameter, and it can only
     be used in conjunction with that parameter. In addition, the request must be authorized using a CMS
     account that is linked to the content owner that the onBehalfOfContentOwner parameter specifies.
     Finally, the channel that the onBehalfOfContentOwnerChannel parameter value specifies must be
     linked to the content owner that the onBehalfOfContentOwner parameter specifies. This parameter is
     intended for YouTube content partners that own and manage many different YouTube channels. It
     allows content owners to authenticate once and perform actions on behalf of the channel specified
     in the parameter value, without having to provide authentication credentials for each separate
     channel.
       */
      public java.lang.String getOnBehalfOfContentOwnerChannel() {
        return onBehalfOfContentOwnerChannel;
      }

      /**
       * This parameter can only be used in a properly authorized request. *Note:* This parameter is
       * intended exclusively for YouTube content partners. The *onBehalfOfContentOwnerChannel*
       * parameter specifies the YouTube channel ID of the channel to which a video is being added.
       * This parameter is required when a request specifies a value for the onBehalfOfContentOwner
       * parameter, and it can only be used in conjunction with that parameter. In addition, the
       * request must be authorized using a CMS account that is linked to the content owner that the
       * onBehalfOfContentOwner parameter specifies. Finally, the channel that the
       * onBehalfOfContentOwnerChannel parameter value specifies must be linked to the content owner
       * that the onBehalfOfContentOwner parameter specifies. This parameter is intended for YouTube
       * content partners that own and manage many different YouTube channels. It allows content
       * owners to authenticate once and perform actions on behalf of the channel specified in the
       * parameter value, without having to provide authentication credentials for each separate
       * channel.
       */
      public Insert setOnBehalfOfContentOwnerChannel(java.lang.String onBehalfOfContentOwnerChannel) {
        this.onBehalfOfContentOwnerChannel = onBehalfOfContentOwnerChannel;
        return this;
      }

      /** Should stabilize be applied to the upload. */
      @com.google.api.client.util.Key
      private java.lang.Boolean stabilize;

      /** Should stabilize be applied to the upload.
       */
      public java.lang.Boolean getStabilize() {
        return stabilize;
      }

      /** Should stabilize be applied to the upload. */
      public Insert setStabilize(java.lang.Boolean stabilize) {
        this.stabilize = stabilize;
        return this;
      }

      @Override
      public Insert set(String parameterName, Object value) {
        return (Insert) super.set(parameterName, value);
      }
    }
    /**
     * Retrieves a list of resources, possibly filtered.
     *
     * Create a request for the method "videos.list".
     *
     * This request holds the parameters needed by the youtube server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param part The *part* parameter specifies a comma-separated list of one or more video resource properties that
     *        the API response will include. If the parameter identifies a property that contains child
     *        properties, the child properties will be included in the response. For example, in a video
     *        resource, the snippet property contains the channelId, title, description, tags, and
     *        categoryId properties. As such, if you set *part=snippet*, the API response will contain
     *        all of those properties.
     * @return the request
     */
    public List list(java.util.List<java.lang.String> part) throws java.io.IOException {
      List result = new List(part);
      initialize(result);
      return result;
    }

    public class List extends YouTubeRequest<com.google.api.services.youtube.model.VideoListResponse> {

      private static final String REST_PATH = "youtube/v3/videos";

      /**
       * Retrieves a list of resources, possibly filtered.
       *
       * Create a request for the method "videos.list".
       *
       * This request holds the parameters needed by the the youtube server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param part The *part* parameter specifies a comma-separated list of one or more video resource properties that
     *        the API response will include. If the parameter identifies a property that contains child
     *        properties, the child properties will be included in the response. For example, in a video
     *        resource, the snippet property contains the channelId, title, description, tags, and
     *        categoryId properties. As such, if you set *part=snippet*, the API response will contain
     *        all of those properties.
       * @since 1.13
       */
      protected List(java.util.List<java.lang.String> part) {
        super(YouTube.this, "GET", REST_PATH, null, com.google.api.services.youtube.model.VideoListResponse.class);
        this.part = com.google.api.client.util.Preconditions.checkNotNull(part, "Required parameter part must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List set$Xgafv(java.lang.String $Xgafv) {
        return (List) super.set$Xgafv($Xgafv);
      }

      @Override
      public List setAccessToken(java.lang.String accessToken) {
        return (List) super.setAccessToken(accessToken);
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setCallback(java.lang.String callback) {
        return (List) super.setCallback(callback);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUploadType(java.lang.String uploadType) {
        return (List) super.setUploadType(uploadType);
      }

      @Override
      public List setUploadProtocol(java.lang.String uploadProtocol) {
        return (List) super.setUploadProtocol(uploadProtocol);
      }

      /**
       * The *part* parameter specifies a comma-separated list of one or more video resource
       * properties that the API response will include. If the parameter identifies a property that
       * contains child properties, the child properties will be included in the response. For
       * example, in a video resource, the snippet property contains the channelId, title,
       * description, tags, and categoryId properties. As such, if you set *part=snippet*, the API
       * response will contain all of those properties.
       */
      @com.google.api.client.util.Key
      private java.util.List<java.lang.String> part;

      /** The *part* parameter specifies a comma-separated list of one or more video resource properties that
     the API response will include. If the parameter identifies a property that contains child
     properties, the child properties will be included in the response. For example, in a video
     resource, the snippet property contains the channelId, title, description, tags, and categoryId
     properties. As such, if you set *part=snippet*, the API response will contain all of those
     properties.
       */
      public java.util.List<java.lang.String> getPart() {
        return part;
      }

      /**
       * The *part* parameter specifies a comma-separated list of one or more video resource
       * properties that the API response will include. If the parameter identifies a property that
       * contains child properties, the child properties will be included in the response. For
       * example, in a video resource, the snippet property contains the channelId, title,
       * description, tags, and categoryId properties. As such, if you set *part=snippet*, the API
       * response will contain all of those properties.
       */
      public List setPart(java.util.List<java.lang.String> part) {
        this.part = part;
        return this;
      }

      /** Return the videos that are in the specified chart. */
      @com.google.api.client.util.Key
      private java.lang.String chart;

      /** Return the videos that are in the specified chart.
       */
      public java.lang.String getChart() {
        return chart;
      }

      /** Return the videos that are in the specified chart. */
      public List setChart(java.lang.String chart) {
        this.chart = chart;
        return this;
      }

      /**
       * Stands for "host language". Specifies the localization language of the metadata to be
       * filled into snippet.localized. The field is filled with the default metadata if there is no
       * localization in the specified language. The parameter value must be a language code
       * included in the list returned by the i18nLanguages.list method (e.g. en_US, es_MX).
       */
      @com.google.api.client.util.Key
      private java.lang.String hl;

      /** Stands for "host language". Specifies the localization language of the metadata to be filled into
     snippet.localized. The field is filled with the default metadata if there is no localization in the
     specified language. The parameter value must be a language code included in the list returned by
     the i18nLanguages.list method (e.g. en_US, es_MX).
       */
      public java.lang.String getHl() {
        return hl;
      }

      /**
       * Stands for "host language". Specifies the localization language of the metadata to be
       * filled into snippet.localized. The field is filled with the default metadata if there is no
       * localization in the specified language. The parameter value must be a language code
       * included in the list returned by the i18nLanguages.list method (e.g. en_US, es_MX).
       */
      public List setHl(java.lang.String hl) {
        this.hl = hl;
        return this;
      }

      /** Return videos with the given ids. */
      @com.google.api.client.util.Key
      private java.util.List<java.lang.String> id;

      /** Return videos with the given ids.
       */
      public java.util.List<java.lang.String> getId() {
        return id;
      }

      /** Return videos with the given ids. */
      public List setId(java.util.List<java.lang.String> id) {
        this.id = id;
        return this;
      }

      @com.google.api.client.util.Key
      private java.lang.String locale;

      /**

       */
      public java.lang.String getLocale() {
        return locale;
      }

      public List setLocale(java.lang.String locale) {
        this.locale = locale;
        return this;
      }

      @com.google.api.client.util.Key
      private java.lang.Integer maxHeight;

      /**
     [minimum: 72] [maximum: 8192]
       */
      public java.lang.Integer getMaxHeight() {
        return maxHeight;
      }

      public List setMaxHeight(java.lang.Integer maxHeight) {
        this.maxHeight = maxHeight;
        return this;
      }

      /**
       * The *maxResults* parameter specifies the maximum number of items that should be returned in
       * the result set. *Note:* This parameter is supported for use in conjunction with the
       * myRating and chart parameters, but it is not supported for use in conjunction with the id
       * parameter.
       */
      @com.google.api.client.util.Key
      private java.lang.Long maxResults;

      /** The *maxResults* parameter specifies the maximum number of items that should be returned in the
     result set. *Note:* This parameter is supported for use in conjunction with the myRating and chart
     parameters, but it is not supported for use in conjunction with the id parameter. [default: 5]
     [minimum: 1] [maximum: 50]
       */
      public java.lang.Long getMaxResults() {
        return maxResults;
      }

      /**
       * The *maxResults* parameter specifies the maximum number of items that should be returned in
       * the result set. *Note:* This parameter is supported for use in conjunction with the
       * myRating and chart parameters, but it is not supported for use in conjunction with the id
       * parameter.
       */
      public List setMaxResults(java.lang.Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      /** Return the player with maximum height specified in */
      @com.google.api.client.util.Key
      private java.lang.Integer maxWidth;

      /** Return the player with maximum height specified in

     [minimum: 72] [maximum: 8192]
       */
      public java.lang.Integer getMaxWidth() {
        return maxWidth;
      }

      /** Return the player with maximum height specified in */
      public List setMaxWidth(java.lang.Integer maxWidth) {
        this.maxWidth = maxWidth;
        return this;
      }

      /**
       * Return videos liked/disliked by the authenticated user. Does not support
       * RateType.RATED_TYPE_NONE.
       */
      @com.google.api.client.util.Key
      private java.lang.String myRating;

      /** Return videos liked/disliked by the authenticated user. Does not support RateType.RATED_TYPE_NONE.
       */
      public java.lang.String getMyRating() {
        return myRating;
      }

      /**
       * Return videos liked/disliked by the authenticated user. Does not support
       * RateType.RATED_TYPE_NONE.
       */
      public List setMyRating(java.lang.String myRating) {
        this.myRating = myRating;
        return this;
      }

      /**
       * *Note:* This parameter is intended exclusively for YouTube content partners. The
       * *onBehalfOfContentOwner* parameter indicates that the request's authorization credentials
       * identify a YouTube CMS user who is acting on behalf of the content owner specified in the
       * parameter value. This parameter is intended for YouTube content partners that own and
       * manage many different YouTube channels. It allows content owners to authenticate once and
       * get access to all their video and channel data, without having to provide authentication
       * credentials for each individual channel. The CMS account that the user authenticates with
       * must be linked to the specified YouTube content owner.
       */
      @com.google.api.client.util.Key
      private java.lang.String onBehalfOfContentOwner;

      /*** Note:* This parameter is intended exclusively for YouTube content partners. The
    * *onBehalfOfContentOwner* parameter indicates that the request's authorization credentials identify
    * a YouTube CMS user who is acting on behalf of the content owner specified in the parameter value.
    * This parameter is intended for YouTube content partners that own and manage many different YouTube
    * channels. It allows content owners to authenticate once and get access to all their video and
    * channel data, without having to provide authentication credentials for each individual channel.
    * The CMS account that the user authenticates with must be linked to the specified YouTube content
    * owner.
    *

       */
      public java.lang.String getOnBehalfOfContentOwner() {
        return onBehalfOfContentOwner;
      }

      /**
       * *Note:* This parameter is intended exclusively for YouTube content partners. The
       * *onBehalfOfContentOwner* parameter indicates that the request's authorization credentials
       * identify a YouTube CMS user who is acting on behalf of the content owner specified in the
       * parameter value. This parameter is intended for YouTube content partners that own and
       * manage many different YouTube channels. It allows content owners to authenticate once and
       * get access to all their video and channel data, without having to provide authentication
       * credentials for each individual channel. The CMS account that the user authenticates with
       * must be linked to the specified YouTube content owner.
       */
      public List setOnBehalfOfContentOwner(java.lang.String onBehalfOfContentOwner) {
        this.onBehalfOfContentOwner = onBehalfOfContentOwner;
        return this;
      }

      /**
       * The *pageToken* parameter identifies a specific page in the result set that should be
       * returned. In an API response, the nextPageToken and prevPageToken properties identify other
       * pages that could be retrieved. *Note:* This parameter is supported for use in conjunction
       * with the myRating and chart parameters, but it is not supported for use in conjunction with
       * the id parameter.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** The *pageToken* parameter identifies a specific page in the result set that should be returned. In
     an API response, the nextPageToken and prevPageToken properties identify other pages that could be
     retrieved. *Note:* This parameter is supported for use in conjunction with the myRating and chart
     parameters, but it is not supported for use in conjunction with the id parameter.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * The *pageToken* parameter identifies a specific page in the result set that should be
       * returned. In an API response, the nextPageToken and prevPageToken properties identify other
       * pages that could be retrieved. *Note:* This parameter is supported for use in conjunction
       * with the myRating and chart parameters, but it is not supported for use in conjunction with
       * the id parameter.
       */
      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      /** Use a chart that is specific to the specified region */
      @com.google.api.client.util.Key
      private java.lang.String regionCode;

      /** Use a chart that is specific to the specified region
       */
      public java.lang.String getRegionCode() {
        return regionCode;
      }

      /** Use a chart that is specific to the specified region */
      public List setRegionCode(java.lang.String regionCode) {
        this.regionCode = regionCode;
        return this;
      }

      /** Use chart that is specific to the specified video category */
      @com.google.api.client.util.Key
      private java.lang.String videoCategoryId;

      /** Use chart that is specific to the specified video category [default: 0]
       */
      public java.lang.String getVideoCategoryId() {
        return videoCategoryId;
      }

      /** Use chart that is specific to the specified video category */
      public List setVideoCategoryId(java.lang.String videoCategoryId) {
        this.videoCategoryId = videoCategoryId;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }
    /**
     * Adds a like or dislike rating to a video or removes a rating from a video.
     *
     * Create a request for the method "videos.rate".
     *
     * This request holds the parameters needed by the youtube server.  After setting any optional
     * parameters, call the {@link Rate#execute()} method to invoke the remote operation.
     *
     * @param id
     * @param rating
     * @return the request
     */
    public Rate rate(java.lang.String id, java.lang.String rating) throws java.io.IOException {
      Rate result = new Rate(id, rating);
      initialize(result);
      return result;
    }

    public class Rate extends YouTubeRequest<Void> {

      private static final String REST_PATH = "youtube/v3/videos/rate";

      /**
       * Adds a like or dislike rating to a video or removes a rating from a video.
       *
       * Create a request for the method "videos.rate".
       *
       * This request holds the parameters needed by the the youtube server.  After setting any optional
       * parameters, call the {@link Rate#execute()} method to invoke the remote operation. <p> {@link
       * Rate#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param id
       * @param rating
       * @since 1.13
       */
      protected Rate(java.lang.String id, java.lang.String rating) {
        super(YouTube.this, "POST", REST_PATH, null, Void.class);
        this.id = com.google.api.client.util.Preconditions.checkNotNull(id, "Required parameter id must be specified.");
        this.rating = com.google.api.client.util.Preconditions.checkNotNull(rating, "Required parameter rating must be specified.");
      }

      @Override
      public Rate set$Xgafv(java.lang.String $Xgafv) {
        return (Rate) super.set$Xgafv($Xgafv);
      }

      @Override
      public Rate setAccessToken(java.lang.String accessToken) {
        return (Rate) super.setAccessToken(accessToken);
      }

      @Override
      public Rate setAlt(java.lang.String alt) {
        return (Rate) super.setAlt(alt);
      }

      @Override
      public Rate setCallback(java.lang.String callback) {
        return (Rate) super.setCallback(callback);
      }

      @Override
      public Rate setFields(java.lang.String fields) {
        return (Rate) super.setFields(fields);
      }

      @Override
      public Rate setKey(java.lang.String key) {
        return (Rate) super.setKey(key);
      }

      @Override
      public Rate setOauthToken(java.lang.String oauthToken) {
        return (Rate) super.setOauthToken(oauthToken);
      }

      @Override
      public Rate setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Rate) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Rate setQuotaUser(java.lang.String quotaUser) {
        return (Rate) super.setQuotaUser(quotaUser);
      }

      @Override
      public Rate setUploadType(java.lang.String uploadType) {
        return (Rate) super.setUploadType(uploadType);
      }

      @Override
      public Rate setUploadProtocol(java.lang.String uploadProtocol) {
        return (Rate) super.setUploadProtocol(uploadProtocol);
      }

      @com.google.api.client.util.Key
      private java.lang.String id;

      /**

       */
      public java.lang.String getId() {
        return id;
      }

      public Rate setId(java.lang.String id) {
        this.id = id;
        return this;
      }

      @com.google.api.client.util.Key
      private java.lang.String rating;

      /**

       */
      public java.lang.String getRating() {
        return rating;
      }

      public Rate setRating(java.lang.String rating) {
        this.rating = rating;
        return this;
      }

      @Override
      public Rate set(String parameterName, Object value) {
        return (Rate) super.set(parameterName, value);
      }
    }
    /**
     * Report abuse for a video.
     *
     * Create a request for the method "videos.reportAbuse".
     *
     * This request holds the parameters needed by the youtube server.  After setting any optional
     * parameters, call the {@link ReportAbuse#execute()} method to invoke the remote operation.
     *
     * @param content the {@link com.google.api.services.youtube.model.VideoAbuseReport}
     * @return the request
     */
    public ReportAbuse reportAbuse(com.google.api.services.youtube.model.VideoAbuseReport content) throws java.io.IOException {
      ReportAbuse result = new ReportAbuse(content);
      initialize(result);
      return result;
    }

    public class ReportAbuse extends YouTubeRequest<Void> {

      private static final String REST_PATH = "youtube/v3/videos/reportAbuse";

      /**
       * Report abuse for a video.
       *
       * Create a request for the method "videos.reportAbuse".
       *
       * This request holds the parameters needed by the the youtube server.  After setting any optional
       * parameters, call the {@link ReportAbuse#execute()} method to invoke the remote operation. <p>
       * {@link
       * ReportAbuse#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param content the {@link com.google.api.services.youtube.model.VideoAbuseReport}
       * @since 1.13
       */
      protected ReportAbuse(com.google.api.services.youtube.model.VideoAbuseReport content) {
        super(YouTube.this, "POST", REST_PATH, content, Void.class);
      }

      @Override
      public ReportAbuse set$Xgafv(java.lang.String $Xgafv) {
        return (ReportAbuse) super.set$Xgafv($Xgafv);
      }

      @Override
      public ReportAbuse setAccessToken(java.lang.String accessToken) {
        return (ReportAbuse) super.setAccessToken(accessToken);
      }

      @Override
      public ReportAbuse setAlt(java.lang.String alt) {
        return (ReportAbuse) super.setAlt(alt);
      }

      @Override
      public ReportAbuse setCallback(java.lang.String callback) {
        return (ReportAbuse) super.setCallback(callback);
      }

      @Override
      public ReportAbuse setFields(java.lang.String fields) {
        return (ReportAbuse) super.setFields(fields);
      }

      @Override
      public ReportAbuse setKey(java.lang.String key) {
        return (ReportAbuse) super.setKey(key);
      }

      @Override
      public ReportAbuse setOauthToken(java.lang.String oauthToken) {
        return (ReportAbuse) super.setOauthToken(oauthToken);
      }

      @Override
      public ReportAbuse setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (ReportAbuse) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public ReportAbuse setQuotaUser(java.lang.String quotaUser) {
        return (ReportAbuse) super.setQuotaUser(quotaUser);
      }

      @Override
      public ReportAbuse setUploadType(java.lang.String uploadType) {
        return (ReportAbuse) super.setUploadType(uploadType);
      }

      @Override
      public ReportAbuse setUploadProtocol(java.lang.String uploadProtocol) {
        return (ReportAbuse) super.setUploadProtocol(uploadProtocol);
      }

      /**
       * *Note:* This parameter is intended exclusively for YouTube content partners. The
       * *onBehalfOfContentOwner* parameter indicates that the request's authorization credentials
       * identify a YouTube CMS user who is acting on behalf of the content owner specified in the
       * parameter value. This parameter is intended for YouTube content partners that own and
       * manage many different YouTube channels. It allows content owners to authenticate once and
       * get access to all their video and channel data, without having to provide authentication
       * credentials for each individual channel. The CMS account that the user authenticates with
       * must be linked to the specified YouTube content owner.
       */
      @com.google.api.client.util.Key
      private java.lang.String onBehalfOfContentOwner;

      /*** Note:* This parameter is intended exclusively for YouTube content partners. The
    * *onBehalfOfContentOwner* parameter indicates that the request's authorization credentials identify
    * a YouTube CMS user who is acting on behalf of the content owner specified in the parameter value.
    * This parameter is intended for YouTube content partners that own and manage many different YouTube
    * channels. It allows content owners to authenticate once and get access to all their video and
    * channel data, without having to provide authentication credentials for each individual channel.
    * The CMS account that the user authenticates with must be linked to the specified YouTube content
    * owner.
    *

       */
      public java.lang.String getOnBehalfOfContentOwner() {
        return onBehalfOfContentOwner;
      }

      /**
       * *Note:* This parameter is intended exclusively for YouTube content partners. The
       * *onBehalfOfContentOwner* parameter indicates that the request's authorization credentials
       * identify a YouTube CMS user who is acting on behalf of the content owner specified in the
       * parameter value. This parameter is intended for YouTube content partners that own and
       * manage many different YouTube channels. It allows content owners to authenticate once and
       * get access to all their video and channel data, without having to provide authentication
       * credentials for each individual channel. The CMS account that the user authenticates with
       * must be linked to the specified YouTube content owner.
       */
      public ReportAbuse setOnBehalfOfContentOwner(java.lang.String onBehalfOfContentOwner) {
        this.onBehalfOfContentOwner = onBehalfOfContentOwner;
        return this;
      }

      @Override
      public ReportAbuse set(String parameterName, Object value) {
        return (ReportAbuse) super.set(parameterName, value);
      }
    }
    /**
     * Updates an existing resource.
     *
     * Create a request for the method "videos.update".
     *
     * This request holds the parameters needed by the youtube server.  After setting any optional
     * parameters, call the {@link Update#execute()} method to invoke the remote operation.
     *
     * @param part The *part* parameter serves two purposes in this operation. It identifies the properties that the
     *        write operation will set as well as the properties that the API response will include.
     *        Note that this method will override the existing values for all of the mutable properties
     *        that are contained in any parts that the parameter value specifies. For example, a video's
     *        privacy setting is contained in the status part. As such, if your request is updating a
     *        private video, and the request's part parameter value includes the status part, the
     *        video's privacy setting will be updated to whatever value the request body specifies. If
     *        the request body does not specify a value, the existing privacy setting will be removed
     *        and the video will revert to the default privacy setting. In addition, not all parts
     *        contain properties that can be set when inserting or updating a video. For example, the
     *        statistics object encapsulates statistics that YouTube calculates for a video and does not
     *        contain values that you can set or modify. If the parameter value specifies a part that
     *        does not contain mutable values, that part will still be included in the API response.
     * @param content the {@link com.google.api.services.youtube.model.Video}
     * @return the request
     */
    public Update update(java.util.List<java.lang.String> part, com.google.api.services.youtube.model.Video content) throws java.io.IOException {
      Update result = new Update(part, content);
      initialize(result);
      return result;
    }

    public class Update extends YouTubeRequest<com.google.api.services.youtube.model.Video> {

      private static final String REST_PATH = "youtube/v3/videos";

      /**
       * Updates an existing resource.
       *
       * Create a request for the method "videos.update".
       *
       * This request holds the parameters needed by the the youtube server.  After setting any optional
       * parameters, call the {@link Update#execute()} method to invoke the remote operation. <p> {@link
       * Update#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param part The *part* parameter serves two purposes in this operation. It identifies the properties that the
     *        write operation will set as well as the properties that the API response will include.
     *        Note that this method will override the existing values for all of the mutable properties
     *        that are contained in any parts that the parameter value specifies. For example, a video's
     *        privacy setting is contained in the status part. As such, if your request is updating a
     *        private video, and the request's part parameter value includes the status part, the
     *        video's privacy setting will be updated to whatever value the request body specifies. If
     *        the request body does not specify a value, the existing privacy setting will be removed
     *        and the video will revert to the default privacy setting. In addition, not all parts
     *        contain properties that can be set when inserting or updating a video. For example, the
     *        statistics object encapsulates statistics that YouTube calculates for a video and does not
     *        contain values that you can set or modify. If the parameter value specifies a part that
     *        does not contain mutable values, that part will still be included in the API response.
       * @param content the {@link com.google.api.services.youtube.model.Video}
       * @since 1.13
       */
      protected Update(java.util.List<java.lang.String> part, com.google.api.services.youtube.model.Video content) {
        super(YouTube.this, "PUT", REST_PATH, content, com.google.api.services.youtube.model.Video.class);
        this.part = com.google.api.client.util.Preconditions.checkNotNull(part, "Required parameter part must be specified.");
        checkRequiredParameter(content, "content");
        checkRequiredParameter(content.getId(), "Video.getId()");
      }

      @Override
      public Update set$Xgafv(java.lang.String $Xgafv) {
        return (Update) super.set$Xgafv($Xgafv);
      }

      @Override
      public Update setAccessToken(java.lang.String accessToken) {
        return (Update) super.setAccessToken(accessToken);
      }

      @Override
      public Update setAlt(java.lang.String alt) {
        return (Update) super.setAlt(alt);
      }

      @Override
      public Update setCallback(java.lang.String callback) {
        return (Update) super.setCallback(callback);
      }

      @Override
      public Update setFields(java.lang.String fields) {
        return (Update) super.setFields(fields);
      }

      @Override
      public Update setKey(java.lang.String key) {
        return (Update) super.setKey(key);
      }

      @Override
      public Update setOauthToken(java.lang.String oauthToken) {
        return (Update) super.setOauthToken(oauthToken);
      }

      @Override
      public Update setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Update) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Update setQuotaUser(java.lang.String quotaUser) {
        return (Update) super.setQuotaUser(quotaUser);
      }

      @Override
      public Update setUploadType(java.lang.String uploadType) {
        return (Update) super.setUploadType(uploadType);
      }

      @Override
      public Update setUploadProtocol(java.lang.String uploadProtocol) {
        return (Update) super.setUploadProtocol(uploadProtocol);
      }

      /**
       * The *part* parameter serves two purposes in this operation. It identifies the properties
       * that the write operation will set as well as the properties that the API response will
       * include. Note that this method will override the existing values for all of the mutable
       * properties that are contained in any parts that the parameter value specifies. For example,
       * a video's privacy setting is contained in the status part. As such, if your request is
       * updating a private video, and the request's part parameter value includes the status part,
       * the video's privacy setting will be updated to whatever value the request body specifies.
       * If the request body does not specify a value, the existing privacy setting will be removed
       * and the video will revert to the default privacy setting. In addition, not all parts
       * contain properties that can be set when inserting or updating a video. For example, the
       * statistics object encapsulates statistics that YouTube calculates for a video and does not
       * contain values that you can set or modify. If the parameter value specifies a part that
       * does not contain mutable values, that part will still be included in the API response.
       */
      @com.google.api.client.util.Key
      private java.util.List<java.lang.String> part;

      /** The *part* parameter serves two purposes in this operation. It identifies the properties that the
     write operation will set as well as the properties that the API response will include. Note that
     this method will override the existing values for all of the mutable properties that are contained
     in any parts that the parameter value specifies. For example, a video's privacy setting is
     contained in the status part. As such, if your request is updating a private video, and the
     request's part parameter value includes the status part, the video's privacy setting will be
     updated to whatever value the request body specifies. If the request body does not specify a value,
     the existing privacy setting will be removed and the video will revert to the default privacy
     setting. In addition, not all parts contain properties that can be set when inserting or updating a
     video. For example, the statistics object encapsulates statistics that YouTube calculates for a
     video and does not contain values that you can set or modify. If the parameter value specifies a
     part that does not contain mutable values, that part will still be included in the API response.
       */
      public java.util.List<java.lang.String> getPart() {
        return part;
      }

      /**
       * The *part* parameter serves two purposes in this operation. It identifies the properties
       * that the write operation will set as well as the properties that the API response will
       * include. Note that this method will override the existing values for all of the mutable
       * properties that are contained in any parts that the parameter value specifies. For example,
       * a video's privacy setting is contained in the status part. As such, if your request is
       * updating a private video, and the request's part parameter value includes the status part,
       * the video's privacy setting will be updated to whatever value the request body specifies.
       * If the request body does not specify a value, the existing privacy setting will be removed
       * and the video will revert to the default privacy setting. In addition, not all parts
       * contain properties that can be set when inserting or updating a video. For example, the
       * statistics object encapsulates statistics that YouTube calculates for a video and does not
       * contain values that you can set or modify. If the parameter value specifies a part that
       * does not contain mutable values, that part will still be included in the API response.
       */
      public Update setPart(java.util.List<java.lang.String> part) {
        this.part = part;
        return this;
      }

      /**
       * *Note:* This parameter is intended exclusively for YouTube content partners. The
       * *onBehalfOfContentOwner* parameter indicates that the request's authorization credentials
       * identify a YouTube CMS user who is acting on behalf of the content owner specified in the
       * parameter value. This parameter is intended for YouTube content partners that own and
       * manage many different YouTube channels. It allows content owners to authenticate once and
       * get access to all their video and channel data, without having to provide authentication
       * credentials for each individual channel. The actual CMS account that the user authenticates
       * with must be linked to the specified YouTube content owner.
       */
      @com.google.api.client.util.Key
      private java.lang.String onBehalfOfContentOwner;

      /*** Note:* This parameter is intended exclusively for YouTube content partners. The
    * *onBehalfOfContentOwner* parameter indicates that the request's authorization credentials identify
    * a YouTube CMS user who is acting on behalf of the content owner specified in the parameter value.
    * This parameter is intended for YouTube content partners that own and manage many different YouTube
    * channels. It allows content owners to authenticate once and get access to all their video and
    * channel data, without having to provide authentication credentials for each individual channel.
    * The actual CMS account that the user authenticates with must be linked to the specified YouTube
    * content owner.
    *

       */
      public java.lang.String getOnBehalfOfContentOwner() {
        return onBehalfOfContentOwner;
      }

      /**
       * *Note:* This parameter is intended exclusively for YouTube content partners. The
       * *onBehalfOfContentOwner* parameter indicates that the request's authorization credentials
       * identify a YouTube CMS user who is acting on behalf of the content owner specified in the
       * parameter value. This parameter is intended for YouTube content partners that own and
       * manage many different YouTube channels. It allows content owners to authenticate once and
       * get access to all their video and channel data, without having to provide authentication
       * credentials for each individual channel. The actual CMS account that the user authenticates
       * with must be linked to the specified YouTube content owner.
       */
      public Update setOnBehalfOfContentOwner(java.lang.String onBehalfOfContentOwner) {
        this.onBehalfOfContentOwner = onBehalfOfContentOwner;
        return this;
      }

      @Override
      public Update set(String parameterName, Object value) {
        return (Update) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the Watermarks collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code YouTube youtube = new YouTube(...);}
   *   {@code YouTube.Watermarks.List request = youtube.watermarks().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Watermarks watermarks() {
    return new Watermarks();
  }

  /**
   * The "watermarks" collection of methods.
   */
  public class Watermarks {

    /**
     * Allows upload of watermark image and setting it for a channel.
     *
     * Create a request for the method "watermarks.set".
     *
     * This request holds the parameters needed by the youtube server.  After setting any optional
     * parameters, call the {@link Set#execute()} method to invoke the remote operation.
     *
     * @param channelId
     * @param content the {@link com.google.api.services.youtube.model.InvideoBranding}
     * @return the request
     */
    public Set set(java.lang.String channelId, com.google.api.services.youtube.model.InvideoBranding content) throws java.io.IOException {
      Set result = new Set(channelId, content);
      initialize(result);
      return result;
    }

    /**
     * Allows upload of watermark image and setting it for a channel.
     *
     * Create a request for the method "watermarks.set".
     *
     * This request holds the parameters needed by the the youtube server.  After setting any optional
     * parameters, call the {@link Set#execute()} method to invoke the remote operation.
     *
     * <p>
     * This method should be used for uploading media content.
     * </p>
     *
     * @param channelId
     * @param content the {@link com.google.api.services.youtube.model.InvideoBranding} media metadata or {@code null} if none
     * @param mediaContent The media HTTP content or {@code null} if none.
     * @return the request
     * @throws java.io.IOException if the initialization of the request fails
     */
    public Set set(java.lang.String channelId, com.google.api.services.youtube.model.InvideoBranding content, com.google.api.client.http.AbstractInputStreamContent mediaContent) throws java.io.IOException {
      Set result = new Set(channelId, content, mediaContent);
      initialize(result);
      return result;
    }

    public class Set extends YouTubeRequest<Void> {

      private static final String REST_PATH = "youtube/v3/watermarks/set";

      /**
       * Allows upload of watermark image and setting it for a channel.
       *
       * Create a request for the method "watermarks.set".
       *
       * This request holds the parameters needed by the the youtube server.  After setting any optional
       * parameters, call the {@link Set#execute()} method to invoke the remote operation. <p> {@link
       * Set#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param channelId
       * @param content the {@link com.google.api.services.youtube.model.InvideoBranding}
       * @since 1.13
       */
      protected Set(java.lang.String channelId, com.google.api.services.youtube.model.InvideoBranding content) {
        super(YouTube.this, "POST", REST_PATH, content, Void.class);
        this.channelId = com.google.api.client.util.Preconditions.checkNotNull(channelId, "Required parameter channelId must be specified.");
      }

      /**
       * Allows upload of watermark image and setting it for a channel.
       *
       * Create a request for the method "watermarks.set".
       *
       * This request holds the parameters needed by the the youtube server.  After setting any optional
       * parameters, call the {@link Set#execute()} method to invoke the remote operation. <p> {@link
       * Set#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * <p>
       * This constructor should be used for uploading media content.
       * </p>
       *
       * @param channelId
       * @param content the {@link com.google.api.services.youtube.model.InvideoBranding} media metadata or {@code null} if none
       * @param mediaContent The media HTTP content or {@code null} if none.
       * @since 1.13
       */
      protected Set(java.lang.String channelId, com.google.api.services.youtube.model.InvideoBranding content, com.google.api.client.http.AbstractInputStreamContent mediaContent) {
        super(YouTube.this, "POST", "/upload/" + getServicePath() + REST_PATH, content, Void.class);
        this.channelId = com.google.api.client.util.Preconditions.checkNotNull(channelId, "Required parameter channelId must be specified.");
        initializeMediaUpload(mediaContent);
      }

      @Override
      public Set set$Xgafv(java.lang.String $Xgafv) {
        return (Set) super.set$Xgafv($Xgafv);
      }

      @Override
      public Set setAccessToken(java.lang.String accessToken) {
        return (Set) super.setAccessToken(accessToken);
      }

      @Override
      public Set setAlt(java.lang.String alt) {
        return (Set) super.setAlt(alt);
      }

      @Override
      public Set setCallback(java.lang.String callback) {
        return (Set) super.setCallback(callback);
      }

      @Override
      public Set setFields(java.lang.String fields) {
        return (Set) super.setFields(fields);
      }

      @Override
      public Set setKey(java.lang.String key) {
        return (Set) super.setKey(key);
      }

      @Override
      public Set setOauthToken(java.lang.String oauthToken) {
        return (Set) super.setOauthToken(oauthToken);
      }

      @Override
      public Set setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Set) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Set setQuotaUser(java.lang.String quotaUser) {
        return (Set) super.setQuotaUser(quotaUser);
      }

      @Override
      public Set setUploadType(java.lang.String uploadType) {
        return (Set) super.setUploadType(uploadType);
      }

      @Override
      public Set setUploadProtocol(java.lang.String uploadProtocol) {
        return (Set) super.setUploadProtocol(uploadProtocol);
      }

      @com.google.api.client.util.Key
      private java.lang.String channelId;

      /**

       */
      public java.lang.String getChannelId() {
        return channelId;
      }

      public Set setChannelId(java.lang.String channelId) {
        this.channelId = channelId;
        return this;
      }

      /**
       * *Note:* This parameter is intended exclusively for YouTube content partners. The
       * *onBehalfOfContentOwner* parameter indicates that the request's authorization credentials
       * identify a YouTube CMS user who is acting on behalf of the content owner specified in the
       * parameter value. This parameter is intended for YouTube content partners that own and
       * manage many different YouTube channels. It allows content owners to authenticate once and
       * get access to all their video and channel data, without having to provide authentication
       * credentials for each individual channel. The CMS account that the user authenticates with
       * must be linked to the specified YouTube content owner.
       */
      @com.google.api.client.util.Key
      private java.lang.String onBehalfOfContentOwner;

      /*** Note:* This parameter is intended exclusively for YouTube content partners. The
    * *onBehalfOfContentOwner* parameter indicates that the request's authorization credentials identify
    * a YouTube CMS user who is acting on behalf of the content owner specified in the parameter value.
    * This parameter is intended for YouTube content partners that own and manage many different YouTube
    * channels. It allows content owners to authenticate once and get access to all their video and
    * channel data, without having to provide authentication credentials for each individual channel.
    * The CMS account that the user authenticates with must be linked to the specified YouTube content
    * owner.
    *

       */
      public java.lang.String getOnBehalfOfContentOwner() {
        return onBehalfOfContentOwner;
      }

      /**
       * *Note:* This parameter is intended exclusively for YouTube content partners. The
       * *onBehalfOfContentOwner* parameter indicates that the request's authorization credentials
       * identify a YouTube CMS user who is acting on behalf of the content owner specified in the
       * parameter value. This parameter is intended for YouTube content partners that own and
       * manage many different YouTube channels. It allows content owners to authenticate once and
       * get access to all their video and channel data, without having to provide authentication
       * credentials for each individual channel. The CMS account that the user authenticates with
       * must be linked to the specified YouTube content owner.
       */
      public Set setOnBehalfOfContentOwner(java.lang.String onBehalfOfContentOwner) {
        this.onBehalfOfContentOwner = onBehalfOfContentOwner;
        return this;
      }

      @Override
      public Set set(String parameterName, Object value) {
        return (Set) super.set(parameterName, value);
      }
    }
    /**
     * Allows removal of channel watermark.
     *
     * Create a request for the method "watermarks.unset".
     *
     * This request holds the parameters needed by the youtube server.  After setting any optional
     * parameters, call the {@link Unset#execute()} method to invoke the remote operation.
     *
     * @param channelId
     * @return the request
     */
    public Unset unset(java.lang.String channelId) throws java.io.IOException {
      Unset result = new Unset(channelId);
      initialize(result);
      return result;
    }

    public class Unset extends YouTubeRequest<Void> {

      private static final String REST_PATH = "youtube/v3/watermarks/unset";

      /**
       * Allows removal of channel watermark.
       *
       * Create a request for the method "watermarks.unset".
       *
       * This request holds the parameters needed by the the youtube server.  After setting any optional
       * parameters, call the {@link Unset#execute()} method to invoke the remote operation. <p> {@link
       * Unset#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param channelId
       * @since 1.13
       */
      protected Unset(java.lang.String channelId) {
        super(YouTube.this, "POST", REST_PATH, null, Void.class);
        this.channelId = com.google.api.client.util.Preconditions.checkNotNull(channelId, "Required parameter channelId must be specified.");
      }

      @Override
      public Unset set$Xgafv(java.lang.String $Xgafv) {
        return (Unset) super.set$Xgafv($Xgafv);
      }

      @Override
      public Unset setAccessToken(java.lang.String accessToken) {
        return (Unset) super.setAccessToken(accessToken);
      }

      @Override
      public Unset setAlt(java.lang.String alt) {
        return (Unset) super.setAlt(alt);
      }

      @Override
      public Unset setCallback(java.lang.String callback) {
        return (Unset) super.setCallback(callback);
      }

      @Override
      public Unset setFields(java.lang.String fields) {
        return (Unset) super.setFields(fields);
      }

      @Override
      public Unset setKey(java.lang.String key) {
        return (Unset) super.setKey(key);
      }

      @Override
      public Unset setOauthToken(java.lang.String oauthToken) {
        return (Unset) super.setOauthToken(oauthToken);
      }

      @Override
      public Unset setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Unset) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Unset setQuotaUser(java.lang.String quotaUser) {
        return (Unset) super.setQuotaUser(quotaUser);
      }

      @Override
      public Unset setUploadType(java.lang.String uploadType) {
        return (Unset) super.setUploadType(uploadType);
      }

      @Override
      public Unset setUploadProtocol(java.lang.String uploadProtocol) {
        return (Unset) super.setUploadProtocol(uploadProtocol);
      }

      @com.google.api.client.util.Key
      private java.lang.String channelId;

      /**

       */
      public java.lang.String getChannelId() {
        return channelId;
      }

      public Unset setChannelId(java.lang.String channelId) {
        this.channelId = channelId;
        return this;
      }

      /**
       * *Note:* This parameter is intended exclusively for YouTube content partners. The
       * *onBehalfOfContentOwner* parameter indicates that the request's authorization credentials
       * identify a YouTube CMS user who is acting on behalf of the content owner specified in the
       * parameter value. This parameter is intended for YouTube content partners that own and
       * manage many different YouTube channels. It allows content owners to authenticate once and
       * get access to all their video and channel data, without having to provide authentication
       * credentials for each individual channel. The CMS account that the user authenticates with
       * must be linked to the specified YouTube content owner.
       */
      @com.google.api.client.util.Key
      private java.lang.String onBehalfOfContentOwner;

      /*** Note:* This parameter is intended exclusively for YouTube content partners. The
    * *onBehalfOfContentOwner* parameter indicates that the request's authorization credentials identify
    * a YouTube CMS user who is acting on behalf of the content owner specified in the parameter value.
    * This parameter is intended for YouTube content partners that own and manage many different YouTube
    * channels. It allows content owners to authenticate once and get access to all their video and
    * channel data, without having to provide authentication credentials for each individual channel.
    * The CMS account that the user authenticates with must be linked to the specified YouTube content
    * owner.
    *

       */
      public java.lang.String getOnBehalfOfContentOwner() {
        return onBehalfOfContentOwner;
      }

      /**
       * *Note:* This parameter is intended exclusively for YouTube content partners. The
       * *onBehalfOfContentOwner* parameter indicates that the request's authorization credentials
       * identify a YouTube CMS user who is acting on behalf of the content owner specified in the
       * parameter value. This parameter is intended for YouTube content partners that own and
       * manage many different YouTube channels. It allows content owners to authenticate once and
       * get access to all their video and channel data, without having to provide authentication
       * credentials for each individual channel. The CMS account that the user authenticates with
       * must be linked to the specified YouTube content owner.
       */
      public Unset setOnBehalfOfContentOwner(java.lang.String onBehalfOfContentOwner) {
        this.onBehalfOfContentOwner = onBehalfOfContentOwner;
        return this;
      }

      @Override
      public Unset set(String parameterName, Object value) {
        return (Unset) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the Youtube collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code YouTube youtube = new YouTube(...);}
   *   {@code YouTube.Youtube.List request = youtube.youtube().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Youtube youtube() {
    return new Youtube();
  }

  /**
   * The "youtube" collection of methods.
   */
  public class Youtube {

    /**
     * An accessor for creating requests from the V3 collection.
     *
     * <p>The typical use is:</p>
     * <pre>
     *   {@code YouTube youtube = new YouTube(...);}
     *   {@code YouTube.V3.List request = youtube.v3().list(parameters ...)}
     * </pre>
     *
     * @return the resource collection
     */
    public V3 v3() {
      return new V3();
    }

    /**
     * The "v3" collection of methods.
     */
    public class V3 {

      /**
       * Updates an existing resource.
       *
       * Create a request for the method "v3.updateCommentThreads".
       *
       * This request holds the parameters needed by the youtube server.  After setting any optional
       * parameters, call the {@link UpdateCommentThreads#execute()} method to invoke the remote
       * operation.
       *
       * @param content the {@link com.google.api.services.youtube.model.CommentThread}
       * @return the request
       */
      public UpdateCommentThreads updateCommentThreads(com.google.api.services.youtube.model.CommentThread content) throws java.io.IOException {
        UpdateCommentThreads result = new UpdateCommentThreads(content);
        initialize(result);
        return result;
      }

      public class UpdateCommentThreads extends YouTubeRequest<com.google.api.services.youtube.model.CommentThread> {

        private static final String REST_PATH = "youtube/v3/commentThreads";

        /**
         * Updates an existing resource.
         *
         * Create a request for the method "v3.updateCommentThreads".
         *
         * This request holds the parameters needed by the the youtube server.  After setting any optional
         * parameters, call the {@link UpdateCommentThreads#execute()} method to invoke the remote
         * operation. <p> {@link UpdateCommentThreads#initialize(com.google.api.client.googleapis.services
         * .AbstractGoogleClientRequest)} must be called to initialize this instance immediately after
         * invoking the constructor. </p>
         *
         * @param content the {@link com.google.api.services.youtube.model.CommentThread}
         * @since 1.13
         */
        protected UpdateCommentThreads(com.google.api.services.youtube.model.CommentThread content) {
          super(YouTube.this, "PUT", REST_PATH, content, com.google.api.services.youtube.model.CommentThread.class);
        }

        @Override
        public UpdateCommentThreads set$Xgafv(java.lang.String $Xgafv) {
          return (UpdateCommentThreads) super.set$Xgafv($Xgafv);
        }

        @Override
        public UpdateCommentThreads setAccessToken(java.lang.String accessToken) {
          return (UpdateCommentThreads) super.setAccessToken(accessToken);
        }

        @Override
        public UpdateCommentThreads setAlt(java.lang.String alt) {
          return (UpdateCommentThreads) super.setAlt(alt);
        }

        @Override
        public UpdateCommentThreads setCallback(java.lang.String callback) {
          return (UpdateCommentThreads) super.setCallback(callback);
        }

        @Override
        public UpdateCommentThreads setFields(java.lang.String fields) {
          return (UpdateCommentThreads) super.setFields(fields);
        }

        @Override
        public UpdateCommentThreads setKey(java.lang.String key) {
          return (UpdateCommentThreads) super.setKey(key);
        }

        @Override
        public UpdateCommentThreads setOauthToken(java.lang.String oauthToken) {
          return (UpdateCommentThreads) super.setOauthToken(oauthToken);
        }

        @Override
        public UpdateCommentThreads setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (UpdateCommentThreads) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public UpdateCommentThreads setQuotaUser(java.lang.String quotaUser) {
          return (UpdateCommentThreads) super.setQuotaUser(quotaUser);
        }

        @Override
        public UpdateCommentThreads setUploadType(java.lang.String uploadType) {
          return (UpdateCommentThreads) super.setUploadType(uploadType);
        }

        @Override
        public UpdateCommentThreads setUploadProtocol(java.lang.String uploadProtocol) {
          return (UpdateCommentThreads) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * The *part* parameter specifies a comma-separated list of commentThread resource
         * properties that the API response will include. You must at least include the snippet part
         * in the parameter value since that part contains all of the properties that the API
         * request can update.
         */
        @com.google.api.client.util.Key
        private java.util.List<java.lang.String> part;

        /** The *part* parameter specifies a comma-separated list of commentThread resource properties that the
       API response will include. You must at least include the snippet part in the parameter value since
       that part contains all of the properties that the API request can update.
         */
        public java.util.List<java.lang.String> getPart() {
          return part;
        }

        /**
         * The *part* parameter specifies a comma-separated list of commentThread resource
         * properties that the API response will include. You must at least include the snippet part
         * in the parameter value since that part contains all of the properties that the API
         * request can update.
         */
        public UpdateCommentThreads setPart(java.util.List<java.lang.String> part) {
          this.part = part;
          return this;
        }

        @Override
        public UpdateCommentThreads set(String parameterName, Object value) {
          return (UpdateCommentThreads) super.set(parameterName, value);
        }
      }

    }
  }

  /**
   * Builder for {@link YouTube}.
   *
   * <p>
   * Implementation is not thread-safe.
   * </p>
   *
   * @since 1.3.0
   */
  public static final class Builder extends com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient.Builder {

    private static String chooseEndpoint(com.google.api.client.http.HttpTransport transport) {
      // If the GOOGLE_API_USE_MTLS_ENDPOINT environment variable value is "always", use mTLS endpoint.
      // If the env variable is "auto", use mTLS endpoint if and only if the transport is mTLS.
      // Use the regular endpoint for all other cases.
      String useMtlsEndpoint = System.getenv("GOOGLE_API_USE_MTLS_ENDPOINT");
      useMtlsEndpoint = useMtlsEndpoint == null ? "auto" : useMtlsEndpoint;
      if ("always".equals(useMtlsEndpoint) || ("auto".equals(useMtlsEndpoint) && transport != null && transport.isMtls())) {
        return DEFAULT_MTLS_ROOT_URL;
      }
      return DEFAULT_ROOT_URL;
    }

    /**
     * Returns an instance of a new builder.
     *
     * @param transport HTTP transport, which should normally be:
     *        <ul>
     *        <li>Google App Engine:
     *        {@code com.google.api.client.extensions.appengine.http.UrlFetchTransport}</li>
     *        <li>Android: {@code newCompatibleTransport} from
     *        {@code com.google.api.client.extensions.android.http.AndroidHttp}</li>
     *        <li>Java: {@link com.google.api.client.googleapis.javanet.GoogleNetHttpTransport#newTrustedTransport()}
     *        </li>
     *        </ul>
     * @param jsonFactory JSON factory, which may be:
     *        <ul>
     *        <li>Jackson: {@code com.google.api.client.json.jackson2.JacksonFactory}</li>
     *        <li>Google GSON: {@code com.google.api.client.json.gson.GsonFactory}</li>
     *        <li>Android Honeycomb or higher:
     *        {@code com.google.api.client.extensions.android.json.AndroidJsonFactory}</li>
     *        </ul>
     * @param httpRequestInitializer HTTP request initializer or {@code null} for none
     * @since 1.7
     */
    public Builder(com.google.api.client.http.HttpTransport transport, com.google.api.client.json.JsonFactory jsonFactory,
        com.google.api.client.http.HttpRequestInitializer httpRequestInitializer) {
      super(
          transport,
          jsonFactory,
          Builder.chooseEndpoint(transport),
          DEFAULT_SERVICE_PATH,
          httpRequestInitializer,
          false);
      setBatchPath(DEFAULT_BATCH_PATH);
    }

    /** Builds a new instance of {@link YouTube}. */
    @Override
    public YouTube build() {
      return new YouTube(this);
    }

    @Override
    public Builder setRootUrl(String rootUrl) {
      return (Builder) super.setRootUrl(rootUrl);
    }

    @Override
    public Builder setServicePath(String servicePath) {
      return (Builder) super.setServicePath(servicePath);
    }

    @Override
    public Builder setBatchPath(String batchPath) {
      return (Builder) super.setBatchPath(batchPath);
    }

    @Override
    public Builder setHttpRequestInitializer(com.google.api.client.http.HttpRequestInitializer httpRequestInitializer) {
      return (Builder) super.setHttpRequestInitializer(httpRequestInitializer);
    }

    @Override
    public Builder setApplicationName(String applicationName) {
      return (Builder) super.setApplicationName(applicationName);
    }

    @Override
    public Builder setSuppressPatternChecks(boolean suppressPatternChecks) {
      return (Builder) super.setSuppressPatternChecks(suppressPatternChecks);
    }

    @Override
    public Builder setSuppressRequiredParameterChecks(boolean suppressRequiredParameterChecks) {
      return (Builder) super.setSuppressRequiredParameterChecks(suppressRequiredParameterChecks);
    }

    @Override
    public Builder setSuppressAllChecks(boolean suppressAllChecks) {
      return (Builder) super.setSuppressAllChecks(suppressAllChecks);
    }

    /**
     * Set the {@link YouTubeRequestInitializer}.
     *
     * @since 1.12
     */
    public Builder setYouTubeRequestInitializer(
        YouTubeRequestInitializer youtubeRequestInitializer) {
      return (Builder) super.setGoogleClientRequestInitializer(youtubeRequestInitializer);
    }

    @Override
    public Builder setGoogleClientRequestInitializer(
        com.google.api.client.googleapis.services.GoogleClientRequestInitializer googleClientRequestInitializer) {
      return (Builder) super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
    }
  }
}
