/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.youtube;

/**
 * Available OAuth 2.0 scopes for use with the YouTube Data API v3.
 *
 * @since 1.4
 */
public class YouTubeScopes {

  /** Manage your YouTube account. */
  public static final String YOUTUBE = "https://www.googleapis.com/auth/youtube";

  /** See a list of your current active channel members, their current level, and when they became a member. */
  public static final String YOUTUBE_CHANNEL_MEMBERSHIPS_CREATOR = "https://www.googleapis.com/auth/youtube.channel-memberships.creator";

  /** See, edit, and permanently delete your YouTube videos, ratings, comments and captions. */
  public static final String YOUTUBE_FORCE_SSL = "https://www.googleapis.com/auth/youtube.force-ssl";

  /** View your YouTube account. */
  public static final String YOUTUBE_READONLY = "https://www.googleapis.com/auth/youtube.readonly";

  /** Manage your YouTube videos. */
  public static final String YOUTUBE_UPLOAD = "https://www.googleapis.com/auth/youtube.upload";

  /** View and manage your assets and associated content on YouTube. */
  public static final String YOUTUBEPARTNER = "https://www.googleapis.com/auth/youtubepartner";

  /** View private information of your YouTube channel relevant during the audit process with a YouTube partner. */
  public static final String YOUTUBEPARTNER_CHANNEL_AUDIT = "https://www.googleapis.com/auth/youtubepartner-channel-audit";

  /**
   * Returns an unmodifiable set that contains all scopes declared by this class.
   *
   * @since 1.16
   */
  public static java.util.Set<String> all() {
    java.util.Set<String> set = new java.util.HashSet<String>();
    set.add(YOUTUBE);
    set.add(YOUTUBE_CHANNEL_MEMBERSHIPS_CREATOR);
    set.add(YOUTUBE_FORCE_SSL);
    set.add(YOUTUBE_READONLY);
    set.add(YOUTUBE_UPLOAD);
    set.add(YOUTUBEPARTNER);
    set.add(YOUTUBEPARTNER_CHANNEL_AUDIT);
    return java.util.Collections.unmodifiableSet(set);
  }

  private YouTubeScopes() {
  }
}
