/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.youtube.model;

/**
 * Details about the content of an activity: the video that was shared, the channel that was
 * subscribed to, etc.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the YouTube Data API v3. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ActivityContentDetails extends com.google.api.client.json.GenericJson {

  /**
   * The bulletin object contains details about a channel bulletin post. This object is only present
   * if the snippet.type is bulletin.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ActivityContentDetailsBulletin bulletin;

  /**
   * The channelItem object contains details about a resource which was added to a channel. This
   * property is only present if the snippet.type is channelItem.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ActivityContentDetailsChannelItem channelItem;

  /**
   * The comment object contains information about a resource that received a comment. This property
   * is only present if the snippet.type is comment.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ActivityContentDetailsComment comment;

  /**
   * The favorite object contains information about a video that was marked as a favorite video.
   * This property is only present if the snippet.type is favorite.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ActivityContentDetailsFavorite favorite;

  /**
   * The like object contains information about a resource that received a positive (like) rating.
   * This property is only present if the snippet.type is like.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ActivityContentDetailsLike like;

  /**
   * The playlistItem object contains information about a new playlist item. This property is only
   * present if the snippet.type is playlistItem.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ActivityContentDetailsPlaylistItem playlistItem;

  /**
   * The promotedItem object contains details about a resource which is being promoted. This
   * property is only present if the snippet.type is promotedItem.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ActivityContentDetailsPromotedItem promotedItem;

  /**
   * The recommendation object contains information about a recommended resource. This property is
   * only present if the snippet.type is recommendation.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ActivityContentDetailsRecommendation recommendation;

  /**
   * The social object contains details about a social network post. This property is only present
   * if the snippet.type is social.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ActivityContentDetailsSocial social;

  /**
   * The subscription object contains information about a channel that a user subscribed to. This
   * property is only present if the snippet.type is subscription.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ActivityContentDetailsSubscription subscription;

  /**
   * The upload object contains information about the uploaded video. This property is only present
   * if the snippet.type is upload.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ActivityContentDetailsUpload upload;

  /**
   * The bulletin object contains details about a channel bulletin post. This object is only present
   * if the snippet.type is bulletin.
   * @return value or {@code null} for none
   */
  public ActivityContentDetailsBulletin getBulletin() {
    return bulletin;
  }

  /**
   * The bulletin object contains details about a channel bulletin post. This object is only present
   * if the snippet.type is bulletin.
   * @param bulletin bulletin or {@code null} for none
   */
  public ActivityContentDetails setBulletin(ActivityContentDetailsBulletin bulletin) {
    this.bulletin = bulletin;
    return this;
  }

  /**
   * The channelItem object contains details about a resource which was added to a channel. This
   * property is only present if the snippet.type is channelItem.
   * @return value or {@code null} for none
   */
  public ActivityContentDetailsChannelItem getChannelItem() {
    return channelItem;
  }

  /**
   * The channelItem object contains details about a resource which was added to a channel. This
   * property is only present if the snippet.type is channelItem.
   * @param channelItem channelItem or {@code null} for none
   */
  public ActivityContentDetails setChannelItem(ActivityContentDetailsChannelItem channelItem) {
    this.channelItem = channelItem;
    return this;
  }

  /**
   * The comment object contains information about a resource that received a comment. This property
   * is only present if the snippet.type is comment.
   * @return value or {@code null} for none
   */
  public ActivityContentDetailsComment getComment() {
    return comment;
  }

  /**
   * The comment object contains information about a resource that received a comment. This property
   * is only present if the snippet.type is comment.
   * @param comment comment or {@code null} for none
   */
  public ActivityContentDetails setComment(ActivityContentDetailsComment comment) {
    this.comment = comment;
    return this;
  }

  /**
   * The favorite object contains information about a video that was marked as a favorite video.
   * This property is only present if the snippet.type is favorite.
   * @return value or {@code null} for none
   */
  public ActivityContentDetailsFavorite getFavorite() {
    return favorite;
  }

  /**
   * The favorite object contains information about a video that was marked as a favorite video.
   * This property is only present if the snippet.type is favorite.
   * @param favorite favorite or {@code null} for none
   */
  public ActivityContentDetails setFavorite(ActivityContentDetailsFavorite favorite) {
    this.favorite = favorite;
    return this;
  }

  /**
   * The like object contains information about a resource that received a positive (like) rating.
   * This property is only present if the snippet.type is like.
   * @return value or {@code null} for none
   */
  public ActivityContentDetailsLike getLike() {
    return like;
  }

  /**
   * The like object contains information about a resource that received a positive (like) rating.
   * This property is only present if the snippet.type is like.
   * @param like like or {@code null} for none
   */
  public ActivityContentDetails setLike(ActivityContentDetailsLike like) {
    this.like = like;
    return this;
  }

  /**
   * The playlistItem object contains information about a new playlist item. This property is only
   * present if the snippet.type is playlistItem.
   * @return value or {@code null} for none
   */
  public ActivityContentDetailsPlaylistItem getPlaylistItem() {
    return playlistItem;
  }

  /**
   * The playlistItem object contains information about a new playlist item. This property is only
   * present if the snippet.type is playlistItem.
   * @param playlistItem playlistItem or {@code null} for none
   */
  public ActivityContentDetails setPlaylistItem(ActivityContentDetailsPlaylistItem playlistItem) {
    this.playlistItem = playlistItem;
    return this;
  }

  /**
   * The promotedItem object contains details about a resource which is being promoted. This
   * property is only present if the snippet.type is promotedItem.
   * @return value or {@code null} for none
   */
  public ActivityContentDetailsPromotedItem getPromotedItem() {
    return promotedItem;
  }

  /**
   * The promotedItem object contains details about a resource which is being promoted. This
   * property is only present if the snippet.type is promotedItem.
   * @param promotedItem promotedItem or {@code null} for none
   */
  public ActivityContentDetails setPromotedItem(ActivityContentDetailsPromotedItem promotedItem) {
    this.promotedItem = promotedItem;
    return this;
  }

  /**
   * The recommendation object contains information about a recommended resource. This property is
   * only present if the snippet.type is recommendation.
   * @return value or {@code null} for none
   */
  public ActivityContentDetailsRecommendation getRecommendation() {
    return recommendation;
  }

  /**
   * The recommendation object contains information about a recommended resource. This property is
   * only present if the snippet.type is recommendation.
   * @param recommendation recommendation or {@code null} for none
   */
  public ActivityContentDetails setRecommendation(ActivityContentDetailsRecommendation recommendation) {
    this.recommendation = recommendation;
    return this;
  }

  /**
   * The social object contains details about a social network post. This property is only present
   * if the snippet.type is social.
   * @return value or {@code null} for none
   */
  public ActivityContentDetailsSocial getSocial() {
    return social;
  }

  /**
   * The social object contains details about a social network post. This property is only present
   * if the snippet.type is social.
   * @param social social or {@code null} for none
   */
  public ActivityContentDetails setSocial(ActivityContentDetailsSocial social) {
    this.social = social;
    return this;
  }

  /**
   * The subscription object contains information about a channel that a user subscribed to. This
   * property is only present if the snippet.type is subscription.
   * @return value or {@code null} for none
   */
  public ActivityContentDetailsSubscription getSubscription() {
    return subscription;
  }

  /**
   * The subscription object contains information about a channel that a user subscribed to. This
   * property is only present if the snippet.type is subscription.
   * @param subscription subscription or {@code null} for none
   */
  public ActivityContentDetails setSubscription(ActivityContentDetailsSubscription subscription) {
    this.subscription = subscription;
    return this;
  }

  /**
   * The upload object contains information about the uploaded video. This property is only present
   * if the snippet.type is upload.
   * @return value or {@code null} for none
   */
  public ActivityContentDetailsUpload getUpload() {
    return upload;
  }

  /**
   * The upload object contains information about the uploaded video. This property is only present
   * if the snippet.type is upload.
   * @param upload upload or {@code null} for none
   */
  public ActivityContentDetails setUpload(ActivityContentDetailsUpload upload) {
    this.upload = upload;
    return this;
  }

  @Override
  public ActivityContentDetails set(String fieldName, Object value) {
    return (ActivityContentDetails) super.set(fieldName, value);
  }

  @Override
  public ActivityContentDetails clone() {
    return (ActivityContentDetails) super.clone();
  }

}
