/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.youtube.model;

/**
 * Information specific to a store on a merchandising platform linked to a YouTube channel.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the YouTube Data API v3. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ChannelToStoreLinkDetails extends com.google.api.client.json.GenericJson {

  /**
   * Google Merchant Center id of the store.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.math.BigInteger merchantId;

  /**
   * Name of the store.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String storeName;

  /**
   * Landing page of the store.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String storeUrl;

  /**
   * Google Merchant Center id of the store.
   * @return value or {@code null} for none
   */
  public java.math.BigInteger getMerchantId() {
    return merchantId;
  }

  /**
   * Google Merchant Center id of the store.
   * @param merchantId merchantId or {@code null} for none
   */
  public ChannelToStoreLinkDetails setMerchantId(java.math.BigInteger merchantId) {
    this.merchantId = merchantId;
    return this;
  }

  /**
   * Name of the store.
   * @return value or {@code null} for none
   */
  public java.lang.String getStoreName() {
    return storeName;
  }

  /**
   * Name of the store.
   * @param storeName storeName or {@code null} for none
   */
  public ChannelToStoreLinkDetails setStoreName(java.lang.String storeName) {
    this.storeName = storeName;
    return this;
  }

  /**
   * Landing page of the store.
   * @return value or {@code null} for none
   */
  public java.lang.String getStoreUrl() {
    return storeUrl;
  }

  /**
   * Landing page of the store.
   * @param storeUrl storeUrl or {@code null} for none
   */
  public ChannelToStoreLinkDetails setStoreUrl(java.lang.String storeUrl) {
    this.storeUrl = storeUrl;
    return this;
  }

  @Override
  public ChannelToStoreLinkDetails set(String fieldName, Object value) {
    return (ChannelToStoreLinkDetails) super.set(fieldName, value);
  }

  @Override
  public ChannelToStoreLinkDetails clone() {
    return (ChannelToStoreLinkDetails) super.clone();
  }

}
