/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.youtube.model;

/**
 * Freebase topic information related to the channel.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the YouTube Data API v3. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ChannelTopicDetails extends com.google.api.client.json.GenericJson {

  /**
   * A list of Wikipedia URLs that describe the channel's content.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> topicCategories;

  /**
   * A list of Freebase topic IDs associated with the channel. You can retrieve information about
   * each topic using the Freebase Topic API.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> topicIds;

  /**
   * A list of Wikipedia URLs that describe the channel's content.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getTopicCategories() {
    return topicCategories;
  }

  /**
   * A list of Wikipedia URLs that describe the channel's content.
   * @param topicCategories topicCategories or {@code null} for none
   */
  public ChannelTopicDetails setTopicCategories(java.util.List<java.lang.String> topicCategories) {
    this.topicCategories = topicCategories;
    return this;
  }

  /**
   * A list of Freebase topic IDs associated with the channel. You can retrieve information about
   * each topic using the Freebase Topic API.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getTopicIds() {
    return topicIds;
  }

  /**
   * A list of Freebase topic IDs associated with the channel. You can retrieve information about
   * each topic using the Freebase Topic API.
   * @param topicIds topicIds or {@code null} for none
   */
  public ChannelTopicDetails setTopicIds(java.util.List<java.lang.String> topicIds) {
    this.topicIds = topicIds;
    return this;
  }

  @Override
  public ChannelTopicDetails set(String fieldName, Object value) {
    return (ChannelTopicDetails) super.set(fieldName, value);
  }

  @Override
  public ChannelTopicDetails clone() {
    return (ChannelTopicDetails) super.clone();
  }

}
