/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.youtube.model;

/**
 * Branding properties for images associated with the channel.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the YouTube Data API v3. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ImageSettings extends com.google.api.client.json.GenericJson {

  /**
   * The URL for the background image shown on the video watch page. The image should be 1200px by
   * 615px, with a maximum file size of 128k.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private LocalizedProperty backgroundImageUrl;

  /**
   * This is generated when a ChannelBanner.Insert request has succeeded for the given channel.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String bannerExternalUrl;

  /**
   * Banner image. Desktop size (1060x175).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String bannerImageUrl;

  /**
   * Banner image. Mobile size high resolution (1440x395).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String bannerMobileExtraHdImageUrl;

  /**
   * Banner image. Mobile size high resolution (1280x360).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String bannerMobileHdImageUrl;

  /**
   * Banner image. Mobile size (640x175).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String bannerMobileImageUrl;

  /**
   * Banner image. Mobile size low resolution (320x88).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String bannerMobileLowImageUrl;

  /**
   * Banner image. Mobile size medium/high resolution (960x263).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String bannerMobileMediumHdImageUrl;

  /**
   * Banner image. Tablet size extra high resolution (2560x424).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String bannerTabletExtraHdImageUrl;

  /**
   * Banner image. Tablet size high resolution (2276x377).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String bannerTabletHdImageUrl;

  /**
   * Banner image. Tablet size (1707x283).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String bannerTabletImageUrl;

  /**
   * Banner image. Tablet size low resolution (1138x188).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String bannerTabletLowImageUrl;

  /**
   * Banner image. TV size high resolution (1920x1080).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String bannerTvHighImageUrl;

  /**
   * Banner image. TV size extra high resolution (2120x1192).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String bannerTvImageUrl;

  /**
   * Banner image. TV size low resolution (854x480).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String bannerTvLowImageUrl;

  /**
   * Banner image. TV size medium resolution (1280x720).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String bannerTvMediumImageUrl;

  /**
   * The image map script for the large banner image.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private LocalizedProperty largeBrandedBannerImageImapScript;

  /**
   * The URL for the 854px by 70px image that appears below the video player in the expanded video
   * view of the video watch page.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private LocalizedProperty largeBrandedBannerImageUrl;

  /**
   * The image map script for the small banner image.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private LocalizedProperty smallBrandedBannerImageImapScript;

  /**
   * The URL for the 640px by 70px banner image that appears below the video player in the default
   * view of the video watch page. The URL for the image that appears above the top-left corner of
   * the video player. This is a 25-pixel-high image with a flexible width that cannot exceed 170
   * pixels.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private LocalizedProperty smallBrandedBannerImageUrl;

  /**
   * The URL for a 1px by 1px tracking pixel that can be used to collect statistics for views of the
   * channel or video pages.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String trackingImageUrl;

  /**
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String watchIconImageUrl;

  /**
   * The URL for the background image shown on the video watch page. The image should be 1200px by
   * 615px, with a maximum file size of 128k.
   * @return value or {@code null} for none
   */
  public LocalizedProperty getBackgroundImageUrl() {
    return backgroundImageUrl;
  }

  /**
   * The URL for the background image shown on the video watch page. The image should be 1200px by
   * 615px, with a maximum file size of 128k.
   * @param backgroundImageUrl backgroundImageUrl or {@code null} for none
   */
  public ImageSettings setBackgroundImageUrl(LocalizedProperty backgroundImageUrl) {
    this.backgroundImageUrl = backgroundImageUrl;
    return this;
  }

  /**
   * This is generated when a ChannelBanner.Insert request has succeeded for the given channel.
   * @return value or {@code null} for none
   */
  public java.lang.String getBannerExternalUrl() {
    return bannerExternalUrl;
  }

  /**
   * This is generated when a ChannelBanner.Insert request has succeeded for the given channel.
   * @param bannerExternalUrl bannerExternalUrl or {@code null} for none
   */
  public ImageSettings setBannerExternalUrl(java.lang.String bannerExternalUrl) {
    this.bannerExternalUrl = bannerExternalUrl;
    return this;
  }

  /**
   * Banner image. Desktop size (1060x175).
   * @return value or {@code null} for none
   */
  public java.lang.String getBannerImageUrl() {
    return bannerImageUrl;
  }

  /**
   * Banner image. Desktop size (1060x175).
   * @param bannerImageUrl bannerImageUrl or {@code null} for none
   */
  public ImageSettings setBannerImageUrl(java.lang.String bannerImageUrl) {
    this.bannerImageUrl = bannerImageUrl;
    return this;
  }

  /**
   * Banner image. Mobile size high resolution (1440x395).
   * @return value or {@code null} for none
   */
  public java.lang.String getBannerMobileExtraHdImageUrl() {
    return bannerMobileExtraHdImageUrl;
  }

  /**
   * Banner image. Mobile size high resolution (1440x395).
   * @param bannerMobileExtraHdImageUrl bannerMobileExtraHdImageUrl or {@code null} for none
   */
  public ImageSettings setBannerMobileExtraHdImageUrl(java.lang.String bannerMobileExtraHdImageUrl) {
    this.bannerMobileExtraHdImageUrl = bannerMobileExtraHdImageUrl;
    return this;
  }

  /**
   * Banner image. Mobile size high resolution (1280x360).
   * @return value or {@code null} for none
   */
  public java.lang.String getBannerMobileHdImageUrl() {
    return bannerMobileHdImageUrl;
  }

  /**
   * Banner image. Mobile size high resolution (1280x360).
   * @param bannerMobileHdImageUrl bannerMobileHdImageUrl or {@code null} for none
   */
  public ImageSettings setBannerMobileHdImageUrl(java.lang.String bannerMobileHdImageUrl) {
    this.bannerMobileHdImageUrl = bannerMobileHdImageUrl;
    return this;
  }

  /**
   * Banner image. Mobile size (640x175).
   * @return value or {@code null} for none
   */
  public java.lang.String getBannerMobileImageUrl() {
    return bannerMobileImageUrl;
  }

  /**
   * Banner image. Mobile size (640x175).
   * @param bannerMobileImageUrl bannerMobileImageUrl or {@code null} for none
   */
  public ImageSettings setBannerMobileImageUrl(java.lang.String bannerMobileImageUrl) {
    this.bannerMobileImageUrl = bannerMobileImageUrl;
    return this;
  }

  /**
   * Banner image. Mobile size low resolution (320x88).
   * @return value or {@code null} for none
   */
  public java.lang.String getBannerMobileLowImageUrl() {
    return bannerMobileLowImageUrl;
  }

  /**
   * Banner image. Mobile size low resolution (320x88).
   * @param bannerMobileLowImageUrl bannerMobileLowImageUrl or {@code null} for none
   */
  public ImageSettings setBannerMobileLowImageUrl(java.lang.String bannerMobileLowImageUrl) {
    this.bannerMobileLowImageUrl = bannerMobileLowImageUrl;
    return this;
  }

  /**
   * Banner image. Mobile size medium/high resolution (960x263).
   * @return value or {@code null} for none
   */
  public java.lang.String getBannerMobileMediumHdImageUrl() {
    return bannerMobileMediumHdImageUrl;
  }

  /**
   * Banner image. Mobile size medium/high resolution (960x263).
   * @param bannerMobileMediumHdImageUrl bannerMobileMediumHdImageUrl or {@code null} for none
   */
  public ImageSettings setBannerMobileMediumHdImageUrl(java.lang.String bannerMobileMediumHdImageUrl) {
    this.bannerMobileMediumHdImageUrl = bannerMobileMediumHdImageUrl;
    return this;
  }

  /**
   * Banner image. Tablet size extra high resolution (2560x424).
   * @return value or {@code null} for none
   */
  public java.lang.String getBannerTabletExtraHdImageUrl() {
    return bannerTabletExtraHdImageUrl;
  }

  /**
   * Banner image. Tablet size extra high resolution (2560x424).
   * @param bannerTabletExtraHdImageUrl bannerTabletExtraHdImageUrl or {@code null} for none
   */
  public ImageSettings setBannerTabletExtraHdImageUrl(java.lang.String bannerTabletExtraHdImageUrl) {
    this.bannerTabletExtraHdImageUrl = bannerTabletExtraHdImageUrl;
    return this;
  }

  /**
   * Banner image. Tablet size high resolution (2276x377).
   * @return value or {@code null} for none
   */
  public java.lang.String getBannerTabletHdImageUrl() {
    return bannerTabletHdImageUrl;
  }

  /**
   * Banner image. Tablet size high resolution (2276x377).
   * @param bannerTabletHdImageUrl bannerTabletHdImageUrl or {@code null} for none
   */
  public ImageSettings setBannerTabletHdImageUrl(java.lang.String bannerTabletHdImageUrl) {
    this.bannerTabletHdImageUrl = bannerTabletHdImageUrl;
    return this;
  }

  /**
   * Banner image. Tablet size (1707x283).
   * @return value or {@code null} for none
   */
  public java.lang.String getBannerTabletImageUrl() {
    return bannerTabletImageUrl;
  }

  /**
   * Banner image. Tablet size (1707x283).
   * @param bannerTabletImageUrl bannerTabletImageUrl or {@code null} for none
   */
  public ImageSettings setBannerTabletImageUrl(java.lang.String bannerTabletImageUrl) {
    this.bannerTabletImageUrl = bannerTabletImageUrl;
    return this;
  }

  /**
   * Banner image. Tablet size low resolution (1138x188).
   * @return value or {@code null} for none
   */
  public java.lang.String getBannerTabletLowImageUrl() {
    return bannerTabletLowImageUrl;
  }

  /**
   * Banner image. Tablet size low resolution (1138x188).
   * @param bannerTabletLowImageUrl bannerTabletLowImageUrl or {@code null} for none
   */
  public ImageSettings setBannerTabletLowImageUrl(java.lang.String bannerTabletLowImageUrl) {
    this.bannerTabletLowImageUrl = bannerTabletLowImageUrl;
    return this;
  }

  /**
   * Banner image. TV size high resolution (1920x1080).
   * @return value or {@code null} for none
   */
  public java.lang.String getBannerTvHighImageUrl() {
    return bannerTvHighImageUrl;
  }

  /**
   * Banner image. TV size high resolution (1920x1080).
   * @param bannerTvHighImageUrl bannerTvHighImageUrl or {@code null} for none
   */
  public ImageSettings setBannerTvHighImageUrl(java.lang.String bannerTvHighImageUrl) {
    this.bannerTvHighImageUrl = bannerTvHighImageUrl;
    return this;
  }

  /**
   * Banner image. TV size extra high resolution (2120x1192).
   * @return value or {@code null} for none
   */
  public java.lang.String getBannerTvImageUrl() {
    return bannerTvImageUrl;
  }

  /**
   * Banner image. TV size extra high resolution (2120x1192).
   * @param bannerTvImageUrl bannerTvImageUrl or {@code null} for none
   */
  public ImageSettings setBannerTvImageUrl(java.lang.String bannerTvImageUrl) {
    this.bannerTvImageUrl = bannerTvImageUrl;
    return this;
  }

  /**
   * Banner image. TV size low resolution (854x480).
   * @return value or {@code null} for none
   */
  public java.lang.String getBannerTvLowImageUrl() {
    return bannerTvLowImageUrl;
  }

  /**
   * Banner image. TV size low resolution (854x480).
   * @param bannerTvLowImageUrl bannerTvLowImageUrl or {@code null} for none
   */
  public ImageSettings setBannerTvLowImageUrl(java.lang.String bannerTvLowImageUrl) {
    this.bannerTvLowImageUrl = bannerTvLowImageUrl;
    return this;
  }

  /**
   * Banner image. TV size medium resolution (1280x720).
   * @return value or {@code null} for none
   */
  public java.lang.String getBannerTvMediumImageUrl() {
    return bannerTvMediumImageUrl;
  }

  /**
   * Banner image. TV size medium resolution (1280x720).
   * @param bannerTvMediumImageUrl bannerTvMediumImageUrl or {@code null} for none
   */
  public ImageSettings setBannerTvMediumImageUrl(java.lang.String bannerTvMediumImageUrl) {
    this.bannerTvMediumImageUrl = bannerTvMediumImageUrl;
    return this;
  }

  /**
   * The image map script for the large banner image.
   * @return value or {@code null} for none
   */
  public LocalizedProperty getLargeBrandedBannerImageImapScript() {
    return largeBrandedBannerImageImapScript;
  }

  /**
   * The image map script for the large banner image.
   * @param largeBrandedBannerImageImapScript largeBrandedBannerImageImapScript or {@code null} for none
   */
  public ImageSettings setLargeBrandedBannerImageImapScript(LocalizedProperty largeBrandedBannerImageImapScript) {
    this.largeBrandedBannerImageImapScript = largeBrandedBannerImageImapScript;
    return this;
  }

  /**
   * The URL for the 854px by 70px image that appears below the video player in the expanded video
   * view of the video watch page.
   * @return value or {@code null} for none
   */
  public LocalizedProperty getLargeBrandedBannerImageUrl() {
    return largeBrandedBannerImageUrl;
  }

  /**
   * The URL for the 854px by 70px image that appears below the video player in the expanded video
   * view of the video watch page.
   * @param largeBrandedBannerImageUrl largeBrandedBannerImageUrl or {@code null} for none
   */
  public ImageSettings setLargeBrandedBannerImageUrl(LocalizedProperty largeBrandedBannerImageUrl) {
    this.largeBrandedBannerImageUrl = largeBrandedBannerImageUrl;
    return this;
  }

  /**
   * The image map script for the small banner image.
   * @return value or {@code null} for none
   */
  public LocalizedProperty getSmallBrandedBannerImageImapScript() {
    return smallBrandedBannerImageImapScript;
  }

  /**
   * The image map script for the small banner image.
   * @param smallBrandedBannerImageImapScript smallBrandedBannerImageImapScript or {@code null} for none
   */
  public ImageSettings setSmallBrandedBannerImageImapScript(LocalizedProperty smallBrandedBannerImageImapScript) {
    this.smallBrandedBannerImageImapScript = smallBrandedBannerImageImapScript;
    return this;
  }

  /**
   * The URL for the 640px by 70px banner image that appears below the video player in the default
   * view of the video watch page. The URL for the image that appears above the top-left corner of
   * the video player. This is a 25-pixel-high image with a flexible width that cannot exceed 170
   * pixels.
   * @return value or {@code null} for none
   */
  public LocalizedProperty getSmallBrandedBannerImageUrl() {
    return smallBrandedBannerImageUrl;
  }

  /**
   * The URL for the 640px by 70px banner image that appears below the video player in the default
   * view of the video watch page. The URL for the image that appears above the top-left corner of
   * the video player. This is a 25-pixel-high image with a flexible width that cannot exceed 170
   * pixels.
   * @param smallBrandedBannerImageUrl smallBrandedBannerImageUrl or {@code null} for none
   */
  public ImageSettings setSmallBrandedBannerImageUrl(LocalizedProperty smallBrandedBannerImageUrl) {
    this.smallBrandedBannerImageUrl = smallBrandedBannerImageUrl;
    return this;
  }

  /**
   * The URL for a 1px by 1px tracking pixel that can be used to collect statistics for views of the
   * channel or video pages.
   * @return value or {@code null} for none
   */
  public java.lang.String getTrackingImageUrl() {
    return trackingImageUrl;
  }

  /**
   * The URL for a 1px by 1px tracking pixel that can be used to collect statistics for views of the
   * channel or video pages.
   * @param trackingImageUrl trackingImageUrl or {@code null} for none
   */
  public ImageSettings setTrackingImageUrl(java.lang.String trackingImageUrl) {
    this.trackingImageUrl = trackingImageUrl;
    return this;
  }

  /**
   * @return value or {@code null} for none
   */
  public java.lang.String getWatchIconImageUrl() {
    return watchIconImageUrl;
  }

  /**
   * @param watchIconImageUrl watchIconImageUrl or {@code null} for none
   */
  public ImageSettings setWatchIconImageUrl(java.lang.String watchIconImageUrl) {
    this.watchIconImageUrl = watchIconImageUrl;
    return this;
  }

  @Override
  public ImageSettings set(String fieldName, Object value) {
    return (ImageSettings) super.set(fieldName, value);
  }

  @Override
  public ImageSettings clone() {
    return (ImageSettings) super.clone();
  }

}
