/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.youtube.model;

/**
 * Describes information necessary for ingesting an RTMP, HTTP, or SRT stream.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the YouTube Data API v3. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class IngestionInfo extends com.google.api.client.json.GenericJson {

  /**
   * The backup ingestion URL that you should use to stream video to YouTube. You have the option of
   * simultaneously streaming the content that you are sending to the ingestionAddress to this URL.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String backupIngestionAddress;

  /**
   * The primary ingestion URL that you should use to stream video to YouTube. You must stream video
   * to this URL. Depending on which application or tool you use to encode your video stream, you
   * may need to enter the stream URL and stream name separately or you may need to concatenate them
   * in the following format: *STREAM_URL/STREAM_NAME*
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String ingestionAddress;

  /**
   * This ingestion url may be used instead of backupIngestionAddress in order to stream via RTMPS.
   * Not applicable to non-RTMP streams.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String rtmpsBackupIngestionAddress;

  /**
   * This ingestion url may be used instead of ingestionAddress in order to stream via RTMPS. Not
   * applicable to non-RTMP streams.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String rtmpsIngestionAddress;

  /**
   * The stream name that YouTube assigns to the video stream.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String streamName;

  /**
   * The backup ingestion URL that you should use to stream video to YouTube. You have the option of
   * simultaneously streaming the content that you are sending to the ingestionAddress to this URL.
   * @return value or {@code null} for none
   */
  public java.lang.String getBackupIngestionAddress() {
    return backupIngestionAddress;
  }

  /**
   * The backup ingestion URL that you should use to stream video to YouTube. You have the option of
   * simultaneously streaming the content that you are sending to the ingestionAddress to this URL.
   * @param backupIngestionAddress backupIngestionAddress or {@code null} for none
   */
  public IngestionInfo setBackupIngestionAddress(java.lang.String backupIngestionAddress) {
    this.backupIngestionAddress = backupIngestionAddress;
    return this;
  }

  /**
   * The primary ingestion URL that you should use to stream video to YouTube. You must stream video
   * to this URL. Depending on which application or tool you use to encode your video stream, you
   * may need to enter the stream URL and stream name separately or you may need to concatenate them
   * in the following format: *STREAM_URL/STREAM_NAME*
   * @return value or {@code null} for none
   */
  public java.lang.String getIngestionAddress() {
    return ingestionAddress;
  }

  /**
   * The primary ingestion URL that you should use to stream video to YouTube. You must stream video
   * to this URL. Depending on which application or tool you use to encode your video stream, you
   * may need to enter the stream URL and stream name separately or you may need to concatenate them
   * in the following format: *STREAM_URL/STREAM_NAME*
   * @param ingestionAddress ingestionAddress or {@code null} for none
   */
  public IngestionInfo setIngestionAddress(java.lang.String ingestionAddress) {
    this.ingestionAddress = ingestionAddress;
    return this;
  }

  /**
   * This ingestion url may be used instead of backupIngestionAddress in order to stream via RTMPS.
   * Not applicable to non-RTMP streams.
   * @return value or {@code null} for none
   */
  public java.lang.String getRtmpsBackupIngestionAddress() {
    return rtmpsBackupIngestionAddress;
  }

  /**
   * This ingestion url may be used instead of backupIngestionAddress in order to stream via RTMPS.
   * Not applicable to non-RTMP streams.
   * @param rtmpsBackupIngestionAddress rtmpsBackupIngestionAddress or {@code null} for none
   */
  public IngestionInfo setRtmpsBackupIngestionAddress(java.lang.String rtmpsBackupIngestionAddress) {
    this.rtmpsBackupIngestionAddress = rtmpsBackupIngestionAddress;
    return this;
  }

  /**
   * This ingestion url may be used instead of ingestionAddress in order to stream via RTMPS. Not
   * applicable to non-RTMP streams.
   * @return value or {@code null} for none
   */
  public java.lang.String getRtmpsIngestionAddress() {
    return rtmpsIngestionAddress;
  }

  /**
   * This ingestion url may be used instead of ingestionAddress in order to stream via RTMPS. Not
   * applicable to non-RTMP streams.
   * @param rtmpsIngestionAddress rtmpsIngestionAddress or {@code null} for none
   */
  public IngestionInfo setRtmpsIngestionAddress(java.lang.String rtmpsIngestionAddress) {
    this.rtmpsIngestionAddress = rtmpsIngestionAddress;
    return this;
  }

  /**
   * The stream name that YouTube assigns to the video stream.
   * @return value or {@code null} for none
   */
  public java.lang.String getStreamName() {
    return streamName;
  }

  /**
   * The stream name that YouTube assigns to the video stream.
   * @param streamName streamName or {@code null} for none
   */
  public IngestionInfo setStreamName(java.lang.String streamName) {
    this.streamName = streamName;
    return this;
  }

  @Override
  public IngestionInfo set(String fieldName, Object value) {
    return (IngestionInfo) super.set(fieldName, value);
  }

  @Override
  public IngestionInfo clone() {
    return (IngestionInfo) super.clone();
  }

}
