/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.youtube.model;

/**
 * Model definition for LiveChatMemberMilestoneChatDetails.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the YouTube Data API v3. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class LiveChatMemberMilestoneChatDetails extends com.google.api.client.json.GenericJson {

  /**
   * The name of the Level at which the viever is a member. The Level names are defined by the
   * YouTube channel offering the Membership. In some situations this field isn't filled.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String memberLevelName;

  /**
   * The total amount of months (rounded up) the viewer has been a member that granted them this
   * Member Milestone Chat. This is the same number of months as is being displayed to YouTube
   * users.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Long memberMonth;

  /**
   * The comment added by the member to this Member Milestone Chat. This field is empty for messages
   * without a comment from the member.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String userComment;

  /**
   * The name of the Level at which the viever is a member. The Level names are defined by the
   * YouTube channel offering the Membership. In some situations this field isn't filled.
   * @return value or {@code null} for none
   */
  public java.lang.String getMemberLevelName() {
    return memberLevelName;
  }

  /**
   * The name of the Level at which the viever is a member. The Level names are defined by the
   * YouTube channel offering the Membership. In some situations this field isn't filled.
   * @param memberLevelName memberLevelName or {@code null} for none
   */
  public LiveChatMemberMilestoneChatDetails setMemberLevelName(java.lang.String memberLevelName) {
    this.memberLevelName = memberLevelName;
    return this;
  }

  /**
   * The total amount of months (rounded up) the viewer has been a member that granted them this
   * Member Milestone Chat. This is the same number of months as is being displayed to YouTube
   * users.
   * @return value or {@code null} for none
   */
  public java.lang.Long getMemberMonth() {
    return memberMonth;
  }

  /**
   * The total amount of months (rounded up) the viewer has been a member that granted them this
   * Member Milestone Chat. This is the same number of months as is being displayed to YouTube
   * users.
   * @param memberMonth memberMonth or {@code null} for none
   */
  public LiveChatMemberMilestoneChatDetails setMemberMonth(java.lang.Long memberMonth) {
    this.memberMonth = memberMonth;
    return this;
  }

  /**
   * The comment added by the member to this Member Milestone Chat. This field is empty for messages
   * without a comment from the member.
   * @return value or {@code null} for none
   */
  public java.lang.String getUserComment() {
    return userComment;
  }

  /**
   * The comment added by the member to this Member Milestone Chat. This field is empty for messages
   * without a comment from the member.
   * @param userComment userComment or {@code null} for none
   */
  public LiveChatMemberMilestoneChatDetails setUserComment(java.lang.String userComment) {
    this.userComment = userComment;
    return this;
  }

  @Override
  public LiveChatMemberMilestoneChatDetails set(String fieldName, Object value) {
    return (LiveChatMemberMilestoneChatDetails) super.set(fieldName, value);
  }

  @Override
  public LiveChatMemberMilestoneChatDetails clone() {
    return (LiveChatMemberMilestoneChatDetails) super.clone();
  }

}
