/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.youtube.model;

/**
 * Model definition for LiveChatMessageAuthorDetails.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the YouTube Data API v3. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class LiveChatMessageAuthorDetails extends com.google.api.client.json.GenericJson {

  /**
   * The YouTube channel ID.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String channelId;

  /**
   * The channel's URL.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String channelUrl;

  /**
   * The channel's display name.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String displayName;

  /**
   * Whether the author is a moderator of the live chat.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean isChatModerator;

  /**
   * Whether the author is the owner of the live chat.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean isChatOwner;

  /**
   * Whether the author is a sponsor of the live chat.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean isChatSponsor;

  /**
   * Whether the author's identity has been verified by YouTube.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean isVerified;

  /**
   * The channels's avatar URL.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String profileImageUrl;

  /**
   * The YouTube channel ID.
   * @return value or {@code null} for none
   */
  public java.lang.String getChannelId() {
    return channelId;
  }

  /**
   * The YouTube channel ID.
   * @param channelId channelId or {@code null} for none
   */
  public LiveChatMessageAuthorDetails setChannelId(java.lang.String channelId) {
    this.channelId = channelId;
    return this;
  }

  /**
   * The channel's URL.
   * @return value or {@code null} for none
   */
  public java.lang.String getChannelUrl() {
    return channelUrl;
  }

  /**
   * The channel's URL.
   * @param channelUrl channelUrl or {@code null} for none
   */
  public LiveChatMessageAuthorDetails setChannelUrl(java.lang.String channelUrl) {
    this.channelUrl = channelUrl;
    return this;
  }

  /**
   * The channel's display name.
   * @return value or {@code null} for none
   */
  public java.lang.String getDisplayName() {
    return displayName;
  }

  /**
   * The channel's display name.
   * @param displayName displayName or {@code null} for none
   */
  public LiveChatMessageAuthorDetails setDisplayName(java.lang.String displayName) {
    this.displayName = displayName;
    return this;
  }

  /**
   * Whether the author is a moderator of the live chat.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getIsChatModerator() {
    return isChatModerator;
  }

  /**
   * Whether the author is a moderator of the live chat.
   * @param isChatModerator isChatModerator or {@code null} for none
   */
  public LiveChatMessageAuthorDetails setIsChatModerator(java.lang.Boolean isChatModerator) {
    this.isChatModerator = isChatModerator;
    return this;
  }

  /**
   * Whether the author is the owner of the live chat.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getIsChatOwner() {
    return isChatOwner;
  }

  /**
   * Whether the author is the owner of the live chat.
   * @param isChatOwner isChatOwner or {@code null} for none
   */
  public LiveChatMessageAuthorDetails setIsChatOwner(java.lang.Boolean isChatOwner) {
    this.isChatOwner = isChatOwner;
    return this;
  }

  /**
   * Whether the author is a sponsor of the live chat.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getIsChatSponsor() {
    return isChatSponsor;
  }

  /**
   * Whether the author is a sponsor of the live chat.
   * @param isChatSponsor isChatSponsor or {@code null} for none
   */
  public LiveChatMessageAuthorDetails setIsChatSponsor(java.lang.Boolean isChatSponsor) {
    this.isChatSponsor = isChatSponsor;
    return this;
  }

  /**
   * Whether the author's identity has been verified by YouTube.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getIsVerified() {
    return isVerified;
  }

  /**
   * Whether the author's identity has been verified by YouTube.
   * @param isVerified isVerified or {@code null} for none
   */
  public LiveChatMessageAuthorDetails setIsVerified(java.lang.Boolean isVerified) {
    this.isVerified = isVerified;
    return this;
  }

  /**
   * The channels's avatar URL.
   * @return value or {@code null} for none
   */
  public java.lang.String getProfileImageUrl() {
    return profileImageUrl;
  }

  /**
   * The channels's avatar URL.
   * @param profileImageUrl profileImageUrl or {@code null} for none
   */
  public LiveChatMessageAuthorDetails setProfileImageUrl(java.lang.String profileImageUrl) {
    this.profileImageUrl = profileImageUrl;
    return this;
  }

  @Override
  public LiveChatMessageAuthorDetails set(String fieldName, Object value) {
    return (LiveChatMessageAuthorDetails) super.set(fieldName, value);
  }

  @Override
  public LiveChatMessageAuthorDetails clone() {
    return (LiveChatMessageAuthorDetails) super.clone();
  }

}
