/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.youtube.model;

/**
 * Model definition for MembershipsDetails.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the YouTube Data API v3. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class MembershipsDetails extends com.google.api.client.json.GenericJson {

  /**
   * Ids of all levels that the user has access to. This includes the currently active level and all
   * other levels that are included because of a higher purchase.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> accessibleLevels;

  /**
   * Id of the highest level that the user has access to at the moment.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String highestAccessibleLevel;

  /**
   * Display name for the highest level that the user has access to at the moment.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String highestAccessibleLevelDisplayName;

  /**
   * Data about memberships duration without taking into consideration pricing levels.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private MembershipsDuration membershipsDuration;

  /**
   * Data about memberships duration on particular pricing levels.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<MembershipsDurationAtLevel> membershipsDurationAtLevels;

  /**
   * Ids of all levels that the user has access to. This includes the currently active level and all
   * other levels that are included because of a higher purchase.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getAccessibleLevels() {
    return accessibleLevels;
  }

  /**
   * Ids of all levels that the user has access to. This includes the currently active level and all
   * other levels that are included because of a higher purchase.
   * @param accessibleLevels accessibleLevels or {@code null} for none
   */
  public MembershipsDetails setAccessibleLevels(java.util.List<java.lang.String> accessibleLevels) {
    this.accessibleLevels = accessibleLevels;
    return this;
  }

  /**
   * Id of the highest level that the user has access to at the moment.
   * @return value or {@code null} for none
   */
  public java.lang.String getHighestAccessibleLevel() {
    return highestAccessibleLevel;
  }

  /**
   * Id of the highest level that the user has access to at the moment.
   * @param highestAccessibleLevel highestAccessibleLevel or {@code null} for none
   */
  public MembershipsDetails setHighestAccessibleLevel(java.lang.String highestAccessibleLevel) {
    this.highestAccessibleLevel = highestAccessibleLevel;
    return this;
  }

  /**
   * Display name for the highest level that the user has access to at the moment.
   * @return value or {@code null} for none
   */
  public java.lang.String getHighestAccessibleLevelDisplayName() {
    return highestAccessibleLevelDisplayName;
  }

  /**
   * Display name for the highest level that the user has access to at the moment.
   * @param highestAccessibleLevelDisplayName highestAccessibleLevelDisplayName or {@code null} for none
   */
  public MembershipsDetails setHighestAccessibleLevelDisplayName(java.lang.String highestAccessibleLevelDisplayName) {
    this.highestAccessibleLevelDisplayName = highestAccessibleLevelDisplayName;
    return this;
  }

  /**
   * Data about memberships duration without taking into consideration pricing levels.
   * @return value or {@code null} for none
   */
  public MembershipsDuration getMembershipsDuration() {
    return membershipsDuration;
  }

  /**
   * Data about memberships duration without taking into consideration pricing levels.
   * @param membershipsDuration membershipsDuration or {@code null} for none
   */
  public MembershipsDetails setMembershipsDuration(MembershipsDuration membershipsDuration) {
    this.membershipsDuration = membershipsDuration;
    return this;
  }

  /**
   * Data about memberships duration on particular pricing levels.
   * @return value or {@code null} for none
   */
  public java.util.List<MembershipsDurationAtLevel> getMembershipsDurationAtLevels() {
    return membershipsDurationAtLevels;
  }

  /**
   * Data about memberships duration on particular pricing levels.
   * @param membershipsDurationAtLevels membershipsDurationAtLevels or {@code null} for none
   */
  public MembershipsDetails setMembershipsDurationAtLevels(java.util.List<MembershipsDurationAtLevel> membershipsDurationAtLevels) {
    this.membershipsDurationAtLevels = membershipsDurationAtLevels;
    return this;
  }

  @Override
  public MembershipsDetails set(String fieldName, Object value) {
    return (MembershipsDetails) super.set(fieldName, value);
  }

  @Override
  public MembershipsDetails clone() {
    return (MembershipsDetails) super.clone();
  }

}
