/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.youtube.model;

/**
 * Basic details about a subscription's subscriber including title, description, channel ID and
 * thumbnails.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the YouTube Data API v3. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class SubscriptionSubscriberSnippet extends com.google.api.client.json.GenericJson {

  /**
   * The channel ID of the subscriber.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String channelId;

  /**
   * The description of the subscriber.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String description;

  /**
   * Thumbnails for this subscriber.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ThumbnailDetails thumbnails;

  /**
   * The title of the subscriber.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String title;

  /**
   * The channel ID of the subscriber.
   * @return value or {@code null} for none
   */
  public java.lang.String getChannelId() {
    return channelId;
  }

  /**
   * The channel ID of the subscriber.
   * @param channelId channelId or {@code null} for none
   */
  public SubscriptionSubscriberSnippet setChannelId(java.lang.String channelId) {
    this.channelId = channelId;
    return this;
  }

  /**
   * The description of the subscriber.
   * @return value or {@code null} for none
   */
  public java.lang.String getDescription() {
    return description;
  }

  /**
   * The description of the subscriber.
   * @param description description or {@code null} for none
   */
  public SubscriptionSubscriberSnippet setDescription(java.lang.String description) {
    this.description = description;
    return this;
  }

  /**
   * Thumbnails for this subscriber.
   * @return value or {@code null} for none
   */
  public ThumbnailDetails getThumbnails() {
    return thumbnails;
  }

  /**
   * Thumbnails for this subscriber.
   * @param thumbnails thumbnails or {@code null} for none
   */
  public SubscriptionSubscriberSnippet setThumbnails(ThumbnailDetails thumbnails) {
    this.thumbnails = thumbnails;
    return this;
  }

  /**
   * The title of the subscriber.
   * @return value or {@code null} for none
   */
  public java.lang.String getTitle() {
    return title;
  }

  /**
   * The title of the subscriber.
   * @param title title or {@code null} for none
   */
  public SubscriptionSubscriberSnippet setTitle(java.lang.String title) {
    this.title = title;
    return this;
  }

  @Override
  public SubscriptionSubscriberSnippet set(String fieldName, Object value) {
    return (SubscriptionSubscriberSnippet) super.set(fieldName, value);
  }

  @Override
  public SubscriptionSubscriberSnippet clone() {
    return (SubscriptionSubscriberSnippet) super.clone();
  }

}
