/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.youtube.model;

/**
 * Model definition for SuperStickerMetadata.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the YouTube Data API v3. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class SuperStickerMetadata extends com.google.api.client.json.GenericJson {

  /**
   * Internationalized alt text that describes the sticker image and any animation associated with
   * it.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String altText;

  /**
   * Specifies the localization language in which the alt text is returned.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String altTextLanguage;

  /**
   * Unique identifier of the Super Sticker. This is a shorter form of the alt_text that includes
   * pack name and a recognizable characteristic of the sticker.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String stickerId;

  /**
   * Internationalized alt text that describes the sticker image and any animation associated with
   * it.
   * @return value or {@code null} for none
   */
  public java.lang.String getAltText() {
    return altText;
  }

  /**
   * Internationalized alt text that describes the sticker image and any animation associated with
   * it.
   * @param altText altText or {@code null} for none
   */
  public SuperStickerMetadata setAltText(java.lang.String altText) {
    this.altText = altText;
    return this;
  }

  /**
   * Specifies the localization language in which the alt text is returned.
   * @return value or {@code null} for none
   */
  public java.lang.String getAltTextLanguage() {
    return altTextLanguage;
  }

  /**
   * Specifies the localization language in which the alt text is returned.
   * @param altTextLanguage altTextLanguage or {@code null} for none
   */
  public SuperStickerMetadata setAltTextLanguage(java.lang.String altTextLanguage) {
    this.altTextLanguage = altTextLanguage;
    return this;
  }

  /**
   * Unique identifier of the Super Sticker. This is a shorter form of the alt_text that includes
   * pack name and a recognizable characteristic of the sticker.
   * @return value or {@code null} for none
   */
  public java.lang.String getStickerId() {
    return stickerId;
  }

  /**
   * Unique identifier of the Super Sticker. This is a shorter form of the alt_text that includes
   * pack name and a recognizable characteristic of the sticker.
   * @param stickerId stickerId or {@code null} for none
   */
  public SuperStickerMetadata setStickerId(java.lang.String stickerId) {
    this.stickerId = stickerId;
    return this;
  }

  @Override
  public SuperStickerMetadata set(String fieldName, Object value) {
    return (SuperStickerMetadata) super.set(fieldName, value);
  }

  @Override
  public SuperStickerMetadata clone() {
    return (SuperStickerMetadata) super.clone();
  }

}
