/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.youtube.model;

/**
 * Basic information about a third party account link, including its type and type-specific
 * information.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the YouTube Data API v3. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ThirdPartyLinkSnippet extends com.google.api.client.json.GenericJson {

  /**
   * Information specific to a link between a channel and a store on a merchandising platform.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ChannelToStoreLinkDetails channelToStoreLink;

  /**
   * Type of the link named after the entities that are being linked.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String type;

  /**
   * Information specific to a link between a channel and a store on a merchandising platform.
   * @return value or {@code null} for none
   */
  public ChannelToStoreLinkDetails getChannelToStoreLink() {
    return channelToStoreLink;
  }

  /**
   * Information specific to a link between a channel and a store on a merchandising platform.
   * @param channelToStoreLink channelToStoreLink or {@code null} for none
   */
  public ThirdPartyLinkSnippet setChannelToStoreLink(ChannelToStoreLinkDetails channelToStoreLink) {
    this.channelToStoreLink = channelToStoreLink;
    return this;
  }

  /**
   * Type of the link named after the entities that are being linked.
   * @return value or {@code null} for none
   */
  public java.lang.String getType() {
    return type;
  }

  /**
   * Type of the link named after the entities that are being linked.
   * @param type type or {@code null} for none
   */
  public ThirdPartyLinkSnippet setType(java.lang.String type) {
    this.type = type;
    return this;
  }

  @Override
  public ThirdPartyLinkSnippet set(String fieldName, Object value) {
    return (ThirdPartyLinkSnippet) super.set(fieldName, value);
  }

  @Override
  public ThirdPartyLinkSnippet clone() {
    return (ThirdPartyLinkSnippet) super.clone();
  }

}
