/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.youtube.model;

/**
 * Note that there may be a 5-second end-point resolution issue. For instance, if a cuepoint comes
 * in for 22:03:27, we may stuff the cuepoint into 22:03:25 or 22:03:30, depending. This is an
 * artifact of HLS.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the YouTube Data API v3. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Cuepoint extends com.google.api.client.json.GenericJson {

  /**
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String cueType;

  /**
   * The duration of this cuepoint.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Long durationSecs;

  /**
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String etag;

  /**
   * The identifier for cuepoint resource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String id;

  /**
   * The time when the cuepoint should be inserted by offset to the broadcast actual start time.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long insertionOffsetTimeMs;

  /**
   * The wall clock time at which the cuepoint should be inserted. Only one of
   * insertion_offset_time_ms and walltime_ms may be set at a time.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.math.BigInteger walltimeMs;

  /**
   * @return value or {@code null} for none
   */
  public java.lang.String getCueType() {
    return cueType;
  }

  /**
   * @param cueType cueType or {@code null} for none
   */
  public Cuepoint setCueType(java.lang.String cueType) {
    this.cueType = cueType;
    return this;
  }

  /**
   * The duration of this cuepoint.
   * @return value or {@code null} for none
   */
  public java.lang.Long getDurationSecs() {
    return durationSecs;
  }

  /**
   * The duration of this cuepoint.
   * @param durationSecs durationSecs or {@code null} for none
   */
  public Cuepoint setDurationSecs(java.lang.Long durationSecs) {
    this.durationSecs = durationSecs;
    return this;
  }

  /**
   * @return value or {@code null} for none
   */
  public java.lang.String getEtag() {
    return etag;
  }

  /**
   * @param etag etag or {@code null} for none
   */
  public Cuepoint setEtag(java.lang.String etag) {
    this.etag = etag;
    return this;
  }

  /**
   * The identifier for cuepoint resource.
   * @return value or {@code null} for none
   */
  public java.lang.String getId() {
    return id;
  }

  /**
   * The identifier for cuepoint resource.
   * @param id id or {@code null} for none
   */
  public Cuepoint setId(java.lang.String id) {
    this.id = id;
    return this;
  }

  /**
   * The time when the cuepoint should be inserted by offset to the broadcast actual start time.
   * @return value or {@code null} for none
   */
  public java.lang.Long getInsertionOffsetTimeMs() {
    return insertionOffsetTimeMs;
  }

  /**
   * The time when the cuepoint should be inserted by offset to the broadcast actual start time.
   * @param insertionOffsetTimeMs insertionOffsetTimeMs or {@code null} for none
   */
  public Cuepoint setInsertionOffsetTimeMs(java.lang.Long insertionOffsetTimeMs) {
    this.insertionOffsetTimeMs = insertionOffsetTimeMs;
    return this;
  }

  /**
   * The wall clock time at which the cuepoint should be inserted. Only one of
   * insertion_offset_time_ms and walltime_ms may be set at a time.
   * @return value or {@code null} for none
   */
  public java.math.BigInteger getWalltimeMs() {
    return walltimeMs;
  }

  /**
   * The wall clock time at which the cuepoint should be inserted. Only one of
   * insertion_offset_time_ms and walltime_ms may be set at a time.
   * @param walltimeMs walltimeMs or {@code null} for none
   */
  public Cuepoint setWalltimeMs(java.math.BigInteger walltimeMs) {
    this.walltimeMs = walltimeMs;
    return this;
  }

  @Override
  public Cuepoint set(String fieldName, Object value) {
    return (Cuepoint) super.set(fieldName, value);
  }

  @Override
  public Cuepoint clone() {
    return (Cuepoint) super.clone();
  }

}
