/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.youtube.model;

/**
 * Model definition for LiveChatGiftMembershipReceivedDetails.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the YouTube Data API v3. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class LiveChatGiftMembershipReceivedDetails extends com.google.api.client.json.GenericJson {

  /**
   * The ID of the membership gifting message that is related to this gift membership. This ID will
   * always refer to a message whose type is 'membershipGiftingEvent'.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String associatedMembershipGiftingMessageId;

  /**
   * The ID of the user that made the membership gifting purchase. This matches the
   * `snippet.authorChannelId` of the associated membership gifting message.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String gifterChannelId;

  /**
   * The name of the Level at which the viewer is a member. This matches the
   * `snippet.membershipGiftingDetails.giftMembershipsLevelName` of the associated membership
   * gifting message. The Level names are defined by the YouTube channel offering the Membership. In
   * some situations this field isn't filled.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String memberLevelName;

  /**
   * The ID of the membership gifting message that is related to this gift membership. This ID will
   * always refer to a message whose type is 'membershipGiftingEvent'.
   * @return value or {@code null} for none
   */
  public java.lang.String getAssociatedMembershipGiftingMessageId() {
    return associatedMembershipGiftingMessageId;
  }

  /**
   * The ID of the membership gifting message that is related to this gift membership. This ID will
   * always refer to a message whose type is 'membershipGiftingEvent'.
   * @param associatedMembershipGiftingMessageId associatedMembershipGiftingMessageId or {@code null} for none
   */
  public LiveChatGiftMembershipReceivedDetails setAssociatedMembershipGiftingMessageId(java.lang.String associatedMembershipGiftingMessageId) {
    this.associatedMembershipGiftingMessageId = associatedMembershipGiftingMessageId;
    return this;
  }

  /**
   * The ID of the user that made the membership gifting purchase. This matches the
   * `snippet.authorChannelId` of the associated membership gifting message.
   * @return value or {@code null} for none
   */
  public java.lang.String getGifterChannelId() {
    return gifterChannelId;
  }

  /**
   * The ID of the user that made the membership gifting purchase. This matches the
   * `snippet.authorChannelId` of the associated membership gifting message.
   * @param gifterChannelId gifterChannelId or {@code null} for none
   */
  public LiveChatGiftMembershipReceivedDetails setGifterChannelId(java.lang.String gifterChannelId) {
    this.gifterChannelId = gifterChannelId;
    return this;
  }

  /**
   * The name of the Level at which the viewer is a member. This matches the
   * `snippet.membershipGiftingDetails.giftMembershipsLevelName` of the associated membership
   * gifting message. The Level names are defined by the YouTube channel offering the Membership. In
   * some situations this field isn't filled.
   * @return value or {@code null} for none
   */
  public java.lang.String getMemberLevelName() {
    return memberLevelName;
  }

  /**
   * The name of the Level at which the viewer is a member. This matches the
   * `snippet.membershipGiftingDetails.giftMembershipsLevelName` of the associated membership
   * gifting message. The Level names are defined by the YouTube channel offering the Membership. In
   * some situations this field isn't filled.
   * @param memberLevelName memberLevelName or {@code null} for none
   */
  public LiveChatGiftMembershipReceivedDetails setMemberLevelName(java.lang.String memberLevelName) {
    this.memberLevelName = memberLevelName;
    return this;
  }

  @Override
  public LiveChatGiftMembershipReceivedDetails set(String fieldName, Object value) {
    return (LiveChatGiftMembershipReceivedDetails) super.set(fieldName, value);
  }

  @Override
  public LiveChatGiftMembershipReceivedDetails clone() {
    return (LiveChatGiftMembershipReceivedDetails) super.clone();
  }

}
