/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.youtube.model;

/**
 * Model definition for LiveChatMembershipGiftingDetails.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the YouTube Data API v3. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class LiveChatMembershipGiftingDetails extends com.google.api.client.json.GenericJson {

  /**
   * The number of gift memberships purchased by the user.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer giftMembershipsCount;

  /**
   * The name of the level of the gift memberships purchased by the user. The Level names are
   * defined by the YouTube channel offering the Membership. In some situations this field isn't
   * filled.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String giftMembershipsLevelName;

  /**
   * The number of gift memberships purchased by the user.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getGiftMembershipsCount() {
    return giftMembershipsCount;
  }

  /**
   * The number of gift memberships purchased by the user.
   * @param giftMembershipsCount giftMembershipsCount or {@code null} for none
   */
  public LiveChatMembershipGiftingDetails setGiftMembershipsCount(java.lang.Integer giftMembershipsCount) {
    this.giftMembershipsCount = giftMembershipsCount;
    return this;
  }

  /**
   * The name of the level of the gift memberships purchased by the user. The Level names are
   * defined by the YouTube channel offering the Membership. In some situations this field isn't
   * filled.
   * @return value or {@code null} for none
   */
  public java.lang.String getGiftMembershipsLevelName() {
    return giftMembershipsLevelName;
  }

  /**
   * The name of the level of the gift memberships purchased by the user. The Level names are
   * defined by the YouTube channel offering the Membership. In some situations this field isn't
   * filled.
   * @param giftMembershipsLevelName giftMembershipsLevelName or {@code null} for none
   */
  public LiveChatMembershipGiftingDetails setGiftMembershipsLevelName(java.lang.String giftMembershipsLevelName) {
    this.giftMembershipsLevelName = giftMembershipsLevelName;
    return this;
  }

  @Override
  public LiveChatMembershipGiftingDetails set(String fieldName, Object value) {
    return (LiveChatMembershipGiftingDetails) super.set(fieldName, value);
  }

  @Override
  public LiveChatMembershipGiftingDetails clone() {
    return (LiveChatMembershipGiftingDetails) super.clone();
  }

}
