/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.youtube.model;

/**
 * Model definition for LiveChatNewSponsorDetails.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the YouTube Data API v3. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class LiveChatNewSponsorDetails extends com.google.api.client.json.GenericJson {

  /**
   * If the viewer just had upgraded from a lower level. For viewers that were not members at the
   * time of purchase, this field is false.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean isUpgrade;

  /**
   * The name of the Level that the viewer just had joined. The Level names are defined by the
   * YouTube channel offering the Membership. In some situations this field isn't filled.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String memberLevelName;

  /**
   * If the viewer just had upgraded from a lower level. For viewers that were not members at the
   * time of purchase, this field is false.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getIsUpgrade() {
    return isUpgrade;
  }

  /**
   * If the viewer just had upgraded from a lower level. For viewers that were not members at the
   * time of purchase, this field is false.
   * @param isUpgrade isUpgrade or {@code null} for none
   */
  public LiveChatNewSponsorDetails setIsUpgrade(java.lang.Boolean isUpgrade) {
    this.isUpgrade = isUpgrade;
    return this;
  }

  /**
   * The name of the Level that the viewer just had joined. The Level names are defined by the
   * YouTube channel offering the Membership. In some situations this field isn't filled.
   * @return value or {@code null} for none
   */
  public java.lang.String getMemberLevelName() {
    return memberLevelName;
  }

  /**
   * The name of the Level that the viewer just had joined. The Level names are defined by the
   * YouTube channel offering the Membership. In some situations this field isn't filled.
   * @param memberLevelName memberLevelName or {@code null} for none
   */
  public LiveChatNewSponsorDetails setMemberLevelName(java.lang.String memberLevelName) {
    this.memberLevelName = memberLevelName;
    return this;
  }

  @Override
  public LiveChatNewSponsorDetails set(String fieldName, Object value) {
    return (LiveChatNewSponsorDetails) super.set(fieldName, value);
  }

  @Override
  public LiveChatNewSponsorDetails clone() {
    return (LiveChatNewSponsorDetails) super.clone();
  }

}
