/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.youtube.model;

/**
 * Model definition for MemberSnippet.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the YouTube Data API v3. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class MemberSnippet extends com.google.api.client.json.GenericJson {

  /**
   * The id of the channel that's offering memberships.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String creatorChannelId;

  /**
   * Details about the member.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ChannelProfileDetails memberDetails;

  /**
   * Details about the user's membership.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private MembershipsDetails membershipsDetails;

  /**
   * The id of the channel that's offering memberships.
   * @return value or {@code null} for none
   */
  public java.lang.String getCreatorChannelId() {
    return creatorChannelId;
  }

  /**
   * The id of the channel that's offering memberships.
   * @param creatorChannelId creatorChannelId or {@code null} for none
   */
  public MemberSnippet setCreatorChannelId(java.lang.String creatorChannelId) {
    this.creatorChannelId = creatorChannelId;
    return this;
  }

  /**
   * Details about the member.
   * @return value or {@code null} for none
   */
  public ChannelProfileDetails getMemberDetails() {
    return memberDetails;
  }

  /**
   * Details about the member.
   * @param memberDetails memberDetails or {@code null} for none
   */
  public MemberSnippet setMemberDetails(ChannelProfileDetails memberDetails) {
    this.memberDetails = memberDetails;
    return this;
  }

  /**
   * Details about the user's membership.
   * @return value or {@code null} for none
   */
  public MembershipsDetails getMembershipsDetails() {
    return membershipsDetails;
  }

  /**
   * Details about the user's membership.
   * @param membershipsDetails membershipsDetails or {@code null} for none
   */
  public MemberSnippet setMembershipsDetails(MembershipsDetails membershipsDetails) {
    this.membershipsDetails = membershipsDetails;
    return this;
  }

  @Override
  public MemberSnippet set(String fieldName, Object value) {
    return (MemberSnippet) super.set(fieldName, value);
  }

  @Override
  public MemberSnippet clone() {
    return (MemberSnippet) super.clone();
  }

}
