/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.youtube.model;

/**
 * A *subscription* resource contains information about a YouTube user subscription. A subscription
 * notifies a user when new videos are added to a channel or when another user takes one of several
 * actions on YouTube, such as uploading a video, rating a video, or commenting on a video.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the YouTube Data API v3. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Subscription extends com.google.api.client.json.GenericJson {

  /**
   * The contentDetails object contains basic statistics about the subscription.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private SubscriptionContentDetails contentDetails;

  /**
   * Etag of this resource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String etag;

  /**
   * The ID that YouTube uses to uniquely identify the subscription.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String id;

  /**
   * Identifies what kind of resource this is. Value: the fixed string "youtube#subscription".
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * The snippet object contains basic details about the subscription, including its title and the
   * channel that the user subscribed to.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private SubscriptionSnippet snippet;

  /**
   * The subscriberSnippet object contains basic details about the subscriber.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private SubscriptionSubscriberSnippet subscriberSnippet;

  /**
   * The contentDetails object contains basic statistics about the subscription.
   * @return value or {@code null} for none
   */
  public SubscriptionContentDetails getContentDetails() {
    return contentDetails;
  }

  /**
   * The contentDetails object contains basic statistics about the subscription.
   * @param contentDetails contentDetails or {@code null} for none
   */
  public Subscription setContentDetails(SubscriptionContentDetails contentDetails) {
    this.contentDetails = contentDetails;
    return this;
  }

  /**
   * Etag of this resource.
   * @return value or {@code null} for none
   */
  public java.lang.String getEtag() {
    return etag;
  }

  /**
   * Etag of this resource.
   * @param etag etag or {@code null} for none
   */
  public Subscription setEtag(java.lang.String etag) {
    this.etag = etag;
    return this;
  }

  /**
   * The ID that YouTube uses to uniquely identify the subscription.
   * @return value or {@code null} for none
   */
  public java.lang.String getId() {
    return id;
  }

  /**
   * The ID that YouTube uses to uniquely identify the subscription.
   * @param id id or {@code null} for none
   */
  public Subscription setId(java.lang.String id) {
    this.id = id;
    return this;
  }

  /**
   * Identifies what kind of resource this is. Value: the fixed string "youtube#subscription".
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * Identifies what kind of resource this is. Value: the fixed string "youtube#subscription".
   * @param kind kind or {@code null} for none
   */
  public Subscription setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * The snippet object contains basic details about the subscription, including its title and the
   * channel that the user subscribed to.
   * @return value or {@code null} for none
   */
  public SubscriptionSnippet getSnippet() {
    return snippet;
  }

  /**
   * The snippet object contains basic details about the subscription, including its title and the
   * channel that the user subscribed to.
   * @param snippet snippet or {@code null} for none
   */
  public Subscription setSnippet(SubscriptionSnippet snippet) {
    this.snippet = snippet;
    return this;
  }

  /**
   * The subscriberSnippet object contains basic details about the subscriber.
   * @return value or {@code null} for none
   */
  public SubscriptionSubscriberSnippet getSubscriberSnippet() {
    return subscriberSnippet;
  }

  /**
   * The subscriberSnippet object contains basic details about the subscriber.
   * @param subscriberSnippet subscriberSnippet or {@code null} for none
   */
  public Subscription setSubscriberSnippet(SubscriptionSubscriberSnippet subscriberSnippet) {
    this.subscriberSnippet = subscriberSnippet;
    return this;
  }

  @Override
  public Subscription set(String fieldName, Object value) {
    return (Subscription) super.set(fieldName, value);
  }

  @Override
  public Subscription clone() {
    return (Subscription) super.clone();
  }

}
