/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.services.youtube;

import com.google.api.client.googleapis.GoogleUtils;
import com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.google.api.client.googleapis.services.GoogleClientRequestInitializer;
import com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient;
import com.google.api.client.http.AbstractInputStreamContent;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.UriTemplate;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.util.Data;
import com.google.api.client.util.Key;
import com.google.api.client.util.Preconditions;
import com.google.api.services.youtube.YouTubeRequest;
import com.google.api.services.youtube.YouTubeRequestInitializer;
import com.google.api.services.youtube.model.AbuseReport;
import com.google.api.services.youtube.model.ActivityListResponse;
import com.google.api.services.youtube.model.Caption;
import com.google.api.services.youtube.model.CaptionListResponse;
import com.google.api.services.youtube.model.Channel;
import com.google.api.services.youtube.model.ChannelBannerResource;
import com.google.api.services.youtube.model.ChannelListResponse;
import com.google.api.services.youtube.model.ChannelSection;
import com.google.api.services.youtube.model.ChannelSectionListResponse;
import com.google.api.services.youtube.model.Comment;
import com.google.api.services.youtube.model.CommentListResponse;
import com.google.api.services.youtube.model.CommentThread;
import com.google.api.services.youtube.model.CommentThreadListResponse;
import com.google.api.services.youtube.model.Cuepoint;
import com.google.api.services.youtube.model.I18nLanguageListResponse;
import com.google.api.services.youtube.model.I18nRegionListResponse;
import com.google.api.services.youtube.model.InvideoBranding;
import com.google.api.services.youtube.model.LiveBroadcast;
import com.google.api.services.youtube.model.LiveBroadcastListResponse;
import com.google.api.services.youtube.model.LiveChatBan;
import com.google.api.services.youtube.model.LiveChatMessage;
import com.google.api.services.youtube.model.LiveChatMessageListResponse;
import com.google.api.services.youtube.model.LiveChatModerator;
import com.google.api.services.youtube.model.LiveChatModeratorListResponse;
import com.google.api.services.youtube.model.LiveStream;
import com.google.api.services.youtube.model.LiveStreamListResponse;
import com.google.api.services.youtube.model.MemberListResponse;
import com.google.api.services.youtube.model.MembershipsLevelListResponse;
import com.google.api.services.youtube.model.Playlist;
import com.google.api.services.youtube.model.PlaylistImage;
import com.google.api.services.youtube.model.PlaylistImageListResponse;
import com.google.api.services.youtube.model.PlaylistItem;
import com.google.api.services.youtube.model.PlaylistItemListResponse;
import com.google.api.services.youtube.model.PlaylistListResponse;
import com.google.api.services.youtube.model.SearchListResponse;
import com.google.api.services.youtube.model.Subscription;
import com.google.api.services.youtube.model.SubscriptionListResponse;
import com.google.api.services.youtube.model.SuperChatEventListResponse;
import com.google.api.services.youtube.model.TestItem;
import com.google.api.services.youtube.model.ThirdPartyLink;
import com.google.api.services.youtube.model.ThirdPartyLinkListResponse;
import com.google.api.services.youtube.model.ThumbnailSetResponse;
import com.google.api.services.youtube.model.Video;
import com.google.api.services.youtube.model.VideoAbuseReport;
import com.google.api.services.youtube.model.VideoAbuseReportReasonListResponse;
import com.google.api.services.youtube.model.VideoCategoryListResponse;
import com.google.api.services.youtube.model.VideoGetRatingResponse;
import com.google.api.services.youtube.model.VideoListResponse;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;

public class YouTube
extends AbstractGoogleJsonClient {
    public static final String DEFAULT_ROOT_URL = "https://youtube.googleapis.com/";
    public static final String DEFAULT_MTLS_ROOT_URL = "https://youtube.mtls.googleapis.com/";
    public static final String DEFAULT_SERVICE_PATH = "";
    public static final String DEFAULT_BATCH_PATH = "batch";
    public static final String DEFAULT_BASE_URL = "https://youtube.googleapis.com/";

    public YouTube(HttpTransport transport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
        this(new Builder(transport, jsonFactory, httpRequestInitializer));
    }

    YouTube(Builder builder) {
        super((AbstractGoogleJsonClient.Builder)builder);
    }

    protected void initialize(AbstractGoogleClientRequest<?> httpClientRequest) throws IOException {
        super.initialize(httpClientRequest);
    }

    public AbuseReports abuseReports() {
        return new AbuseReports();
    }

    public Activities activities() {
        return new Activities();
    }

    public Captions captions() {
        return new Captions();
    }

    public ChannelBanners channelBanners() {
        return new ChannelBanners();
    }

    public ChannelSections channelSections() {
        return new ChannelSections();
    }

    public Channels channels() {
        return new Channels();
    }

    public CommentThreads commentThreads() {
        return new CommentThreads();
    }

    public Comments comments() {
        return new Comments();
    }

    public I18nLanguages i18nLanguages() {
        return new I18nLanguages();
    }

    public I18nRegions i18nRegions() {
        return new I18nRegions();
    }

    public LiveBroadcasts liveBroadcasts() {
        return new LiveBroadcasts();
    }

    public LiveChatBans liveChatBans() {
        return new LiveChatBans();
    }

    public LiveChatMessages liveChatMessages() {
        return new LiveChatMessages();
    }

    public LiveChatModerators liveChatModerators() {
        return new LiveChatModerators();
    }

    public LiveStreams liveStreams() {
        return new LiveStreams();
    }

    public Members members() {
        return new Members();
    }

    public MembershipsLevels membershipsLevels() {
        return new MembershipsLevels();
    }

    public PlaylistImages playlistImages() {
        return new PlaylistImages();
    }

    public PlaylistItems playlistItems() {
        return new PlaylistItems();
    }

    public Playlists playlists() {
        return new Playlists();
    }

    public Search search() {
        return new Search();
    }

    public Subscriptions subscriptions() {
        return new Subscriptions();
    }

    public SuperChatEvents superChatEvents() {
        return new SuperChatEvents();
    }

    public Tests tests() {
        return new Tests();
    }

    public ThirdPartyLinks thirdPartyLinks() {
        return new ThirdPartyLinks();
    }

    public Thumbnails thumbnails() {
        return new Thumbnails();
    }

    public VideoAbuseReportReasons videoAbuseReportReasons() {
        return new VideoAbuseReportReasons();
    }

    public VideoCategories videoCategories() {
        return new VideoCategories();
    }

    public VideoTrainability videoTrainability() {
        return new VideoTrainability();
    }

    public Videos videos() {
        return new Videos();
    }

    public Watermarks watermarks() {
        return new Watermarks();
    }

    public Youtube youtube() {
        return new Youtube();
    }

    static {
        Preconditions.checkState((GoogleUtils.MAJOR_VERSION == 1 && (GoogleUtils.MINOR_VERSION >= 32 || GoogleUtils.MINOR_VERSION == 31 && GoogleUtils.BUGFIX_VERSION >= 1) || GoogleUtils.MAJOR_VERSION >= 2 ? 1 : 0) != 0, (String)"You are currently running with version %s of google-api-client. You need at least version 1.31.1 of google-api-client to run version 2.0.0 of the YouTube Data API v3 library.", (Object[])new Object[]{GoogleUtils.VERSION});
    }

    public static final class Builder
    extends AbstractGoogleJsonClient.Builder {
        private static String chooseEndpoint(HttpTransport transport) {
            String useMtlsEndpoint = System.getenv("GOOGLE_API_USE_MTLS_ENDPOINT");
            String string = useMtlsEndpoint = useMtlsEndpoint == null ? "auto" : useMtlsEndpoint;
            if ("always".equals(useMtlsEndpoint) || "auto".equals(useMtlsEndpoint) && transport != null && transport.isMtls()) {
                return YouTube.DEFAULT_MTLS_ROOT_URL;
            }
            return "https://youtube.googleapis.com/";
        }

        public Builder(HttpTransport transport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
            super(transport, jsonFactory, Builder.chooseEndpoint(transport), YouTube.DEFAULT_SERVICE_PATH, httpRequestInitializer, false);
            this.setBatchPath(YouTube.DEFAULT_BATCH_PATH);
        }

        public YouTube build() {
            return new YouTube(this);
        }

        public Builder setRootUrl(String rootUrl) {
            return (Builder)super.setRootUrl(rootUrl);
        }

        public Builder setServicePath(String servicePath) {
            return (Builder)super.setServicePath(servicePath);
        }

        public Builder setBatchPath(String batchPath) {
            return (Builder)super.setBatchPath(batchPath);
        }

        public Builder setHttpRequestInitializer(HttpRequestInitializer httpRequestInitializer) {
            return (Builder)super.setHttpRequestInitializer(httpRequestInitializer);
        }

        public Builder setApplicationName(String applicationName) {
            return (Builder)super.setApplicationName(applicationName);
        }

        public Builder setSuppressPatternChecks(boolean suppressPatternChecks) {
            return (Builder)super.setSuppressPatternChecks(suppressPatternChecks);
        }

        public Builder setSuppressRequiredParameterChecks(boolean suppressRequiredParameterChecks) {
            return (Builder)super.setSuppressRequiredParameterChecks(suppressRequiredParameterChecks);
        }

        public Builder setSuppressAllChecks(boolean suppressAllChecks) {
            return (Builder)super.setSuppressAllChecks(suppressAllChecks);
        }

        public Builder setYouTubeRequestInitializer(YouTubeRequestInitializer youtubeRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer((GoogleClientRequestInitializer)youtubeRequestInitializer);
        }

        public Builder setGoogleClientRequestInitializer(GoogleClientRequestInitializer googleClientRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
        }

        public Builder setUniverseDomain(String universeDomain) {
            return (Builder)super.setUniverseDomain(universeDomain);
        }
    }

    public class Youtube {
        public V3 v3() {
            return new V3();
        }

        public class V3 {
            public UpdateCommentThreads updateCommentThreads(CommentThread content) throws IOException {
                UpdateCommentThreads result = new UpdateCommentThreads(content);
                YouTube.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public class UpdateCommentThreads
            extends YouTubeRequest<CommentThread> {
                private static final String REST_PATH = "youtube/v3/commentThreads";
                @Key
                private List<String> part;

                protected UpdateCommentThreads(CommentThread content) {
                    super(YouTube.this, "PUT", REST_PATH, (Object)content, CommentThread.class);
                }

                public UpdateCommentThreads set$Xgafv(String $Xgafv) {
                    return (UpdateCommentThreads)super.set$Xgafv($Xgafv);
                }

                public UpdateCommentThreads setAccessToken(String accessToken) {
                    return (UpdateCommentThreads)super.setAccessToken(accessToken);
                }

                public UpdateCommentThreads setAlt(String alt) {
                    return (UpdateCommentThreads)super.setAlt(alt);
                }

                public UpdateCommentThreads setCallback(String callback) {
                    return (UpdateCommentThreads)super.setCallback(callback);
                }

                public UpdateCommentThreads setFields(String fields) {
                    return (UpdateCommentThreads)super.setFields(fields);
                }

                public UpdateCommentThreads setKey(String key) {
                    return (UpdateCommentThreads)super.setKey(key);
                }

                public UpdateCommentThreads setOauthToken(String oauthToken) {
                    return (UpdateCommentThreads)super.setOauthToken(oauthToken);
                }

                public UpdateCommentThreads setPrettyPrint(Boolean prettyPrint) {
                    return (UpdateCommentThreads)super.setPrettyPrint(prettyPrint);
                }

                public UpdateCommentThreads setQuotaUser(String quotaUser) {
                    return (UpdateCommentThreads)super.setQuotaUser(quotaUser);
                }

                public UpdateCommentThreads setUploadType(String uploadType) {
                    return (UpdateCommentThreads)super.setUploadType(uploadType);
                }

                public UpdateCommentThreads setUploadProtocol(String uploadProtocol) {
                    return (UpdateCommentThreads)super.setUploadProtocol(uploadProtocol);
                }

                public List<String> getPart() {
                    return this.part;
                }

                public UpdateCommentThreads setPart(List<String> part) {
                    this.part = part;
                    return this;
                }

                @Override
                public UpdateCommentThreads set(String parameterName, Object value) {
                    return (UpdateCommentThreads)super.set(parameterName, value);
                }
            }
        }
    }

    public class Watermarks {
        public Set set(String channelId, InvideoBranding content) throws IOException {
            Set result = new Set(channelId, content);
            YouTube.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Set set(String channelId, InvideoBranding content, AbstractInputStreamContent mediaContent) throws IOException {
            Set result = new Set(channelId, content, mediaContent);
            YouTube.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Unset unset(String channelId) throws IOException {
            Unset result = new Unset(channelId);
            YouTube.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class Unset
        extends YouTubeRequest<Void> {
            private static final String REST_PATH = "youtube/v3/watermarks/unset";
            @Key
            private String channelId;
            @Key
            private String onBehalfOfContentOwner;

            protected Unset(String channelId) {
                super(YouTube.this, "POST", REST_PATH, null, Void.class);
                this.channelId = (String)Preconditions.checkNotNull((Object)channelId, (Object)"Required parameter channelId must be specified.");
            }

            public Unset set$Xgafv(String $Xgafv) {
                return (Unset)super.set$Xgafv($Xgafv);
            }

            public Unset setAccessToken(String accessToken) {
                return (Unset)super.setAccessToken(accessToken);
            }

            public Unset setAlt(String alt) {
                return (Unset)super.setAlt(alt);
            }

            public Unset setCallback(String callback) {
                return (Unset)super.setCallback(callback);
            }

            public Unset setFields(String fields) {
                return (Unset)super.setFields(fields);
            }

            public Unset setKey(String key) {
                return (Unset)super.setKey(key);
            }

            public Unset setOauthToken(String oauthToken) {
                return (Unset)super.setOauthToken(oauthToken);
            }

            public Unset setPrettyPrint(Boolean prettyPrint) {
                return (Unset)super.setPrettyPrint(prettyPrint);
            }

            public Unset setQuotaUser(String quotaUser) {
                return (Unset)super.setQuotaUser(quotaUser);
            }

            public Unset setUploadType(String uploadType) {
                return (Unset)super.setUploadType(uploadType);
            }

            public Unset setUploadProtocol(String uploadProtocol) {
                return (Unset)super.setUploadProtocol(uploadProtocol);
            }

            public String getChannelId() {
                return this.channelId;
            }

            public Unset setChannelId(String channelId) {
                this.channelId = channelId;
                return this;
            }

            public String getOnBehalfOfContentOwner() {
                return this.onBehalfOfContentOwner;
            }

            public Unset setOnBehalfOfContentOwner(String onBehalfOfContentOwner) {
                this.onBehalfOfContentOwner = onBehalfOfContentOwner;
                return this;
            }

            @Override
            public Unset set(String parameterName, Object value) {
                return (Unset)super.set(parameterName, value);
            }
        }

        public class Set
        extends YouTubeRequest<Void> {
            private static final String REST_PATH = "youtube/v3/watermarks/set";
            @Key
            private String channelId;
            @Key
            private String onBehalfOfContentOwner;

            protected Set(String channelId, InvideoBranding content) {
                super(YouTube.this, "POST", REST_PATH, (Object)content, Void.class);
                this.channelId = (String)Preconditions.checkNotNull((Object)channelId, (Object)"Required parameter channelId must be specified.");
            }

            protected Set(String channelId, InvideoBranding content, AbstractInputStreamContent mediaContent) {
                super(YouTube.this, "POST", "/upload/" + YouTube.this.getServicePath() + REST_PATH, (Object)content, Void.class);
                this.channelId = (String)Preconditions.checkNotNull((Object)channelId, (Object)"Required parameter channelId must be specified.");
                Preconditions.checkNotNull((Object)mediaContent, (Object)"Required parameter mediaContent must be specified.");
                this.initializeMediaUpload(mediaContent);
            }

            public Set set$Xgafv(String $Xgafv) {
                return (Set)super.set$Xgafv($Xgafv);
            }

            public Set setAccessToken(String accessToken) {
                return (Set)super.setAccessToken(accessToken);
            }

            public Set setAlt(String alt) {
                return (Set)super.setAlt(alt);
            }

            public Set setCallback(String callback) {
                return (Set)super.setCallback(callback);
            }

            public Set setFields(String fields) {
                return (Set)super.setFields(fields);
            }

            public Set setKey(String key) {
                return (Set)super.setKey(key);
            }

            public Set setOauthToken(String oauthToken) {
                return (Set)super.setOauthToken(oauthToken);
            }

            public Set setPrettyPrint(Boolean prettyPrint) {
                return (Set)super.setPrettyPrint(prettyPrint);
            }

            public Set setQuotaUser(String quotaUser) {
                return (Set)super.setQuotaUser(quotaUser);
            }

            public Set setUploadType(String uploadType) {
                return (Set)super.setUploadType(uploadType);
            }

            public Set setUploadProtocol(String uploadProtocol) {
                return (Set)super.setUploadProtocol(uploadProtocol);
            }

            public String getChannelId() {
                return this.channelId;
            }

            public Set setChannelId(String channelId) {
                this.channelId = channelId;
                return this;
            }

            public String getOnBehalfOfContentOwner() {
                return this.onBehalfOfContentOwner;
            }

            public Set setOnBehalfOfContentOwner(String onBehalfOfContentOwner) {
                this.onBehalfOfContentOwner = onBehalfOfContentOwner;
                return this;
            }

            @Override
            public Set set(String parameterName, Object value) {
                return (Set)super.set(parameterName, value);
            }
        }
    }

    public class Videos {
        public Delete delete(String id) throws IOException {
            Delete result = new Delete(id);
            YouTube.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public GetRating getRating(java.util.List<String> id) throws IOException {
            GetRating result = new GetRating(id);
            YouTube.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Insert insert(java.util.List<String> part, Video content) throws IOException {
            Insert result = new Insert(part, content);
            YouTube.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Insert insert(java.util.List<String> part, Video content, AbstractInputStreamContent mediaContent) throws IOException {
            Insert result = new Insert(part, content, mediaContent);
            YouTube.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list(java.util.List<String> part) throws IOException {
            List result = new List(part);
            YouTube.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Rate rate(String id, String rating) throws IOException {
            Rate result = new Rate(id, rating);
            YouTube.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public ReportAbuse reportAbuse(VideoAbuseReport content) throws IOException {
            ReportAbuse result = new ReportAbuse(content);
            YouTube.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Update update(java.util.List<String> part, Video content) throws IOException {
            Update result = new Update(part, content);
            YouTube.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class Update
        extends YouTubeRequest<Video> {
            private static final String REST_PATH = "youtube/v3/videos";
            @Key
            private java.util.List<String> part;
            @Key
            private String onBehalfOfContentOwner;

            protected Update(java.util.List<String> part, Video content) {
                super(YouTube.this, "PUT", REST_PATH, (Object)content, Video.class);
                this.part = (java.util.List)Preconditions.checkNotNull(part, (Object)"Required parameter part must be specified.");
                this.checkRequiredParameter((Object)content, "content");
                this.checkRequiredParameter(content.getId(), "Video.getId()");
            }

            public Update set$Xgafv(String $Xgafv) {
                return (Update)super.set$Xgafv($Xgafv);
            }

            public Update setAccessToken(String accessToken) {
                return (Update)super.setAccessToken(accessToken);
            }

            public Update setAlt(String alt) {
                return (Update)super.setAlt(alt);
            }

            public Update setCallback(String callback) {
                return (Update)super.setCallback(callback);
            }

            public Update setFields(String fields) {
                return (Update)super.setFields(fields);
            }

            public Update setKey(String key) {
                return (Update)super.setKey(key);
            }

            public Update setOauthToken(String oauthToken) {
                return (Update)super.setOauthToken(oauthToken);
            }

            public Update setPrettyPrint(Boolean prettyPrint) {
                return (Update)super.setPrettyPrint(prettyPrint);
            }

            public Update setQuotaUser(String quotaUser) {
                return (Update)super.setQuotaUser(quotaUser);
            }

            public Update setUploadType(String uploadType) {
                return (Update)super.setUploadType(uploadType);
            }

            public Update setUploadProtocol(String uploadProtocol) {
                return (Update)super.setUploadProtocol(uploadProtocol);
            }

            public java.util.List<String> getPart() {
                return this.part;
            }

            public Update setPart(java.util.List<String> part) {
                this.part = part;
                return this;
            }

            public String getOnBehalfOfContentOwner() {
                return this.onBehalfOfContentOwner;
            }

            public Update setOnBehalfOfContentOwner(String onBehalfOfContentOwner) {
                this.onBehalfOfContentOwner = onBehalfOfContentOwner;
                return this;
            }

            @Override
            public Update set(String parameterName, Object value) {
                return (Update)super.set(parameterName, value);
            }
        }

        public class ReportAbuse
        extends YouTubeRequest<Void> {
            private static final String REST_PATH = "youtube/v3/videos/reportAbuse";
            @Key
            private String onBehalfOfContentOwner;

            protected ReportAbuse(VideoAbuseReport content) {
                super(YouTube.this, "POST", REST_PATH, (Object)content, Void.class);
            }

            public ReportAbuse set$Xgafv(String $Xgafv) {
                return (ReportAbuse)super.set$Xgafv($Xgafv);
            }

            public ReportAbuse setAccessToken(String accessToken) {
                return (ReportAbuse)super.setAccessToken(accessToken);
            }

            public ReportAbuse setAlt(String alt) {
                return (ReportAbuse)super.setAlt(alt);
            }

            public ReportAbuse setCallback(String callback) {
                return (ReportAbuse)super.setCallback(callback);
            }

            public ReportAbuse setFields(String fields) {
                return (ReportAbuse)super.setFields(fields);
            }

            public ReportAbuse setKey(String key) {
                return (ReportAbuse)super.setKey(key);
            }

            public ReportAbuse setOauthToken(String oauthToken) {
                return (ReportAbuse)super.setOauthToken(oauthToken);
            }

            public ReportAbuse setPrettyPrint(Boolean prettyPrint) {
                return (ReportAbuse)super.setPrettyPrint(prettyPrint);
            }

            public ReportAbuse setQuotaUser(String quotaUser) {
                return (ReportAbuse)super.setQuotaUser(quotaUser);
            }

            public ReportAbuse setUploadType(String uploadType) {
                return (ReportAbuse)super.setUploadType(uploadType);
            }

            public ReportAbuse setUploadProtocol(String uploadProtocol) {
                return (ReportAbuse)super.setUploadProtocol(uploadProtocol);
            }

            public String getOnBehalfOfContentOwner() {
                return this.onBehalfOfContentOwner;
            }

            public ReportAbuse setOnBehalfOfContentOwner(String onBehalfOfContentOwner) {
                this.onBehalfOfContentOwner = onBehalfOfContentOwner;
                return this;
            }

            @Override
            public ReportAbuse set(String parameterName, Object value) {
                return (ReportAbuse)super.set(parameterName, value);
            }
        }

        public class Rate
        extends YouTubeRequest<Void> {
            private static final String REST_PATH = "youtube/v3/videos/rate";
            @Key
            private String id;
            @Key
            private String rating;

            protected Rate(String id, String rating) {
                super(YouTube.this, "POST", REST_PATH, null, Void.class);
                this.id = (String)Preconditions.checkNotNull((Object)id, (Object)"Required parameter id must be specified.");
                this.rating = (String)Preconditions.checkNotNull((Object)rating, (Object)"Required parameter rating must be specified.");
            }

            public Rate set$Xgafv(String $Xgafv) {
                return (Rate)super.set$Xgafv($Xgafv);
            }

            public Rate setAccessToken(String accessToken) {
                return (Rate)super.setAccessToken(accessToken);
            }

            public Rate setAlt(String alt) {
                return (Rate)super.setAlt(alt);
            }

            public Rate setCallback(String callback) {
                return (Rate)super.setCallback(callback);
            }

            public Rate setFields(String fields) {
                return (Rate)super.setFields(fields);
            }

            public Rate setKey(String key) {
                return (Rate)super.setKey(key);
            }

            public Rate setOauthToken(String oauthToken) {
                return (Rate)super.setOauthToken(oauthToken);
            }

            public Rate setPrettyPrint(Boolean prettyPrint) {
                return (Rate)super.setPrettyPrint(prettyPrint);
            }

            public Rate setQuotaUser(String quotaUser) {
                return (Rate)super.setQuotaUser(quotaUser);
            }

            public Rate setUploadType(String uploadType) {
                return (Rate)super.setUploadType(uploadType);
            }

            public Rate setUploadProtocol(String uploadProtocol) {
                return (Rate)super.setUploadProtocol(uploadProtocol);
            }

            public String getId() {
                return this.id;
            }

            public Rate setId(String id) {
                this.id = id;
                return this;
            }

            public String getRating() {
                return this.rating;
            }

            public Rate setRating(String rating) {
                this.rating = rating;
                return this;
            }

            @Override
            public Rate set(String parameterName, Object value) {
                return (Rate)super.set(parameterName, value);
            }
        }

        public class List
        extends YouTubeRequest<VideoListResponse> {
            private static final String REST_PATH = "youtube/v3/videos";
            @Key
            private java.util.List<String> part;
            @Key
            private String chart;
            @Key
            private String hl;
            @Key
            private java.util.List<String> id;
            @Key
            private String locale;
            @Key
            private Integer maxHeight;
            @Key
            private Long maxResults;
            @Key
            private Integer maxWidth;
            @Key
            private String myRating;
            @Key
            private String onBehalfOfContentOwner;
            @Key
            private String pageToken;
            @Key
            private String regionCode;
            @Key
            private String videoCategoryId;

            protected List(java.util.List<String> part) {
                super(YouTube.this, "GET", REST_PATH, null, VideoListResponse.class);
                this.part = (java.util.List)Preconditions.checkNotNull(part, (Object)"Required parameter part must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String $Xgafv) {
                return (List)super.set$Xgafv($Xgafv);
            }

            public List setAccessToken(String accessToken) {
                return (List)super.setAccessToken(accessToken);
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setCallback(String callback) {
                return (List)super.setCallback(callback);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUploadType(String uploadType) {
                return (List)super.setUploadType(uploadType);
            }

            public List setUploadProtocol(String uploadProtocol) {
                return (List)super.setUploadProtocol(uploadProtocol);
            }

            public java.util.List<String> getPart() {
                return this.part;
            }

            public List setPart(java.util.List<String> part) {
                this.part = part;
                return this;
            }

            public String getChart() {
                return this.chart;
            }

            public List setChart(String chart) {
                this.chart = chart;
                return this;
            }

            public String getHl() {
                return this.hl;
            }

            public List setHl(String hl) {
                this.hl = hl;
                return this;
            }

            public java.util.List<String> getId() {
                return this.id;
            }

            public List setId(java.util.List<String> id) {
                this.id = id;
                return this;
            }

            public String getLocale() {
                return this.locale;
            }

            public List setLocale(String locale) {
                this.locale = locale;
                return this;
            }

            public Integer getMaxHeight() {
                return this.maxHeight;
            }

            public List setMaxHeight(Integer maxHeight) {
                this.maxHeight = maxHeight;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long maxResults) {
                this.maxResults = maxResults;
                return this;
            }

            public Integer getMaxWidth() {
                return this.maxWidth;
            }

            public List setMaxWidth(Integer maxWidth) {
                this.maxWidth = maxWidth;
                return this;
            }

            public String getMyRating() {
                return this.myRating;
            }

            public List setMyRating(String myRating) {
                this.myRating = myRating;
                return this;
            }

            public String getOnBehalfOfContentOwner() {
                return this.onBehalfOfContentOwner;
            }

            public List setOnBehalfOfContentOwner(String onBehalfOfContentOwner) {
                this.onBehalfOfContentOwner = onBehalfOfContentOwner;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            public String getRegionCode() {
                return this.regionCode;
            }

            public List setRegionCode(String regionCode) {
                this.regionCode = regionCode;
                return this;
            }

            public String getVideoCategoryId() {
                return this.videoCategoryId;
            }

            public List setVideoCategoryId(String videoCategoryId) {
                this.videoCategoryId = videoCategoryId;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class Insert
        extends YouTubeRequest<Video> {
            private static final String REST_PATH = "youtube/v3/videos";
            @Key
            private java.util.List<String> part;
            @Key
            private Boolean autoLevels;
            @Key
            private Boolean notifySubscribers;
            @Key
            private String onBehalfOfContentOwner;
            @Key
            private String onBehalfOfContentOwnerChannel;
            @Key
            private Boolean stabilize;

            protected Insert(java.util.List<String> part, Video content) {
                super(YouTube.this, "POST", REST_PATH, (Object)content, Video.class);
                this.part = (java.util.List)Preconditions.checkNotNull(part, (Object)"Required parameter part must be specified.");
            }

            protected Insert(java.util.List<String> part, Video content, AbstractInputStreamContent mediaContent) {
                super(YouTube.this, "POST", "/upload/" + YouTube.this.getServicePath() + REST_PATH, (Object)content, Video.class);
                this.part = (java.util.List)Preconditions.checkNotNull(part, (Object)"Required parameter part must be specified.");
                Preconditions.checkNotNull((Object)mediaContent, (Object)"Required parameter mediaContent must be specified.");
                this.initializeMediaUpload(mediaContent);
            }

            public Insert set$Xgafv(String $Xgafv) {
                return (Insert)super.set$Xgafv($Xgafv);
            }

            public Insert setAccessToken(String accessToken) {
                return (Insert)super.setAccessToken(accessToken);
            }

            public Insert setAlt(String alt) {
                return (Insert)super.setAlt(alt);
            }

            public Insert setCallback(String callback) {
                return (Insert)super.setCallback(callback);
            }

            public Insert setFields(String fields) {
                return (Insert)super.setFields(fields);
            }

            public Insert setKey(String key) {
                return (Insert)super.setKey(key);
            }

            public Insert setOauthToken(String oauthToken) {
                return (Insert)super.setOauthToken(oauthToken);
            }

            public Insert setPrettyPrint(Boolean prettyPrint) {
                return (Insert)super.setPrettyPrint(prettyPrint);
            }

            public Insert setQuotaUser(String quotaUser) {
                return (Insert)super.setQuotaUser(quotaUser);
            }

            public Insert setUploadType(String uploadType) {
                return (Insert)super.setUploadType(uploadType);
            }

            public Insert setUploadProtocol(String uploadProtocol) {
                return (Insert)super.setUploadProtocol(uploadProtocol);
            }

            public java.util.List<String> getPart() {
                return this.part;
            }

            public Insert setPart(java.util.List<String> part) {
                this.part = part;
                return this;
            }

            public Boolean getAutoLevels() {
                return this.autoLevels;
            }

            public Insert setAutoLevels(Boolean autoLevels) {
                this.autoLevels = autoLevels;
                return this;
            }

            public Boolean getNotifySubscribers() {
                return this.notifySubscribers;
            }

            public Insert setNotifySubscribers(Boolean notifySubscribers) {
                this.notifySubscribers = notifySubscribers;
                return this;
            }

            public boolean isNotifySubscribers() {
                if (this.notifySubscribers == null || this.notifySubscribers == Data.NULL_BOOLEAN) {
                    return true;
                }
                return this.notifySubscribers;
            }

            public String getOnBehalfOfContentOwner() {
                return this.onBehalfOfContentOwner;
            }

            public Insert setOnBehalfOfContentOwner(String onBehalfOfContentOwner) {
                this.onBehalfOfContentOwner = onBehalfOfContentOwner;
                return this;
            }

            public String getOnBehalfOfContentOwnerChannel() {
                return this.onBehalfOfContentOwnerChannel;
            }

            public Insert setOnBehalfOfContentOwnerChannel(String onBehalfOfContentOwnerChannel) {
                this.onBehalfOfContentOwnerChannel = onBehalfOfContentOwnerChannel;
                return this;
            }

            public Boolean getStabilize() {
                return this.stabilize;
            }

            public Insert setStabilize(Boolean stabilize) {
                this.stabilize = stabilize;
                return this;
            }

            @Override
            public Insert set(String parameterName, Object value) {
                return (Insert)super.set(parameterName, value);
            }
        }

        public class GetRating
        extends YouTubeRequest<VideoGetRatingResponse> {
            private static final String REST_PATH = "youtube/v3/videos/getRating";
            @Key
            private java.util.List<String> id;
            @Key
            private String onBehalfOfContentOwner;

            protected GetRating(java.util.List<String> id) {
                super(YouTube.this, "GET", REST_PATH, null, VideoGetRatingResponse.class);
                this.id = (java.util.List)Preconditions.checkNotNull(id, (Object)"Required parameter id must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public GetRating set$Xgafv(String $Xgafv) {
                return (GetRating)super.set$Xgafv($Xgafv);
            }

            public GetRating setAccessToken(String accessToken) {
                return (GetRating)super.setAccessToken(accessToken);
            }

            public GetRating setAlt(String alt) {
                return (GetRating)super.setAlt(alt);
            }

            public GetRating setCallback(String callback) {
                return (GetRating)super.setCallback(callback);
            }

            public GetRating setFields(String fields) {
                return (GetRating)super.setFields(fields);
            }

            public GetRating setKey(String key) {
                return (GetRating)super.setKey(key);
            }

            public GetRating setOauthToken(String oauthToken) {
                return (GetRating)super.setOauthToken(oauthToken);
            }

            public GetRating setPrettyPrint(Boolean prettyPrint) {
                return (GetRating)super.setPrettyPrint(prettyPrint);
            }

            public GetRating setQuotaUser(String quotaUser) {
                return (GetRating)super.setQuotaUser(quotaUser);
            }

            public GetRating setUploadType(String uploadType) {
                return (GetRating)super.setUploadType(uploadType);
            }

            public GetRating setUploadProtocol(String uploadProtocol) {
                return (GetRating)super.setUploadProtocol(uploadProtocol);
            }

            public java.util.List<String> getId() {
                return this.id;
            }

            public GetRating setId(java.util.List<String> id) {
                this.id = id;
                return this;
            }

            public String getOnBehalfOfContentOwner() {
                return this.onBehalfOfContentOwner;
            }

            public GetRating setOnBehalfOfContentOwner(String onBehalfOfContentOwner) {
                this.onBehalfOfContentOwner = onBehalfOfContentOwner;
                return this;
            }

            @Override
            public GetRating set(String parameterName, Object value) {
                return (GetRating)super.set(parameterName, value);
            }
        }

        public class Delete
        extends YouTubeRequest<Void> {
            private static final String REST_PATH = "youtube/v3/videos";
            @Key
            private String id;
            @Key
            private String onBehalfOfContentOwner;

            protected Delete(String id) {
                super(YouTube.this, "DELETE", REST_PATH, null, Void.class);
                this.id = (String)Preconditions.checkNotNull((Object)id, (Object)"Required parameter id must be specified.");
            }

            public Delete set$Xgafv(String $Xgafv) {
                return (Delete)super.set$Xgafv($Xgafv);
            }

            public Delete setAccessToken(String accessToken) {
                return (Delete)super.setAccessToken(accessToken);
            }

            public Delete setAlt(String alt) {
                return (Delete)super.setAlt(alt);
            }

            public Delete setCallback(String callback) {
                return (Delete)super.setCallback(callback);
            }

            public Delete setFields(String fields) {
                return (Delete)super.setFields(fields);
            }

            public Delete setKey(String key) {
                return (Delete)super.setKey(key);
            }

            public Delete setOauthToken(String oauthToken) {
                return (Delete)super.setOauthToken(oauthToken);
            }

            public Delete setPrettyPrint(Boolean prettyPrint) {
                return (Delete)super.setPrettyPrint(prettyPrint);
            }

            public Delete setQuotaUser(String quotaUser) {
                return (Delete)super.setQuotaUser(quotaUser);
            }

            public Delete setUploadType(String uploadType) {
                return (Delete)super.setUploadType(uploadType);
            }

            public Delete setUploadProtocol(String uploadProtocol) {
                return (Delete)super.setUploadProtocol(uploadProtocol);
            }

            public String getId() {
                return this.id;
            }

            public Delete setId(String id) {
                this.id = id;
                return this;
            }

            public String getOnBehalfOfContentOwner() {
                return this.onBehalfOfContentOwner;
            }

            public Delete setOnBehalfOfContentOwner(String onBehalfOfContentOwner) {
                this.onBehalfOfContentOwner = onBehalfOfContentOwner;
                return this;
            }

            @Override
            public Delete set(String parameterName, Object value) {
                return (Delete)super.set(parameterName, value);
            }
        }
    }

    public class VideoTrainability {
        public Get get() throws IOException {
            Get result = new Get();
            YouTube.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class Get
        extends YouTubeRequest<com.google.api.services.youtube.model.VideoTrainability> {
            private static final String REST_PATH = "youtube/v3/videoTrainability";
            @Key
            private String id;

            protected Get() {
                super(YouTube.this, "GET", REST_PATH, null, com.google.api.services.youtube.model.VideoTrainability.class);
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String $Xgafv) {
                return (Get)super.set$Xgafv($Xgafv);
            }

            public Get setAccessToken(String accessToken) {
                return (Get)super.setAccessToken(accessToken);
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setCallback(String callback) {
                return (Get)super.setCallback(callback);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUploadType(String uploadType) {
                return (Get)super.setUploadType(uploadType);
            }

            public Get setUploadProtocol(String uploadProtocol) {
                return (Get)super.setUploadProtocol(uploadProtocol);
            }

            public String getId() {
                return this.id;
            }

            public Get setId(String id) {
                this.id = id;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }
    }

    public class VideoCategories {
        public List list(java.util.List<String> part) throws IOException {
            List result = new List(part);
            YouTube.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class List
        extends YouTubeRequest<VideoCategoryListResponse> {
            private static final String REST_PATH = "youtube/v3/videoCategories";
            @Key
            private java.util.List<String> part;
            @Key
            private String hl;
            @Key
            private java.util.List<String> id;
            @Key
            private String regionCode;

            protected List(java.util.List<String> part) {
                super(YouTube.this, "GET", REST_PATH, null, VideoCategoryListResponse.class);
                this.part = (java.util.List)Preconditions.checkNotNull(part, (Object)"Required parameter part must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String $Xgafv) {
                return (List)super.set$Xgafv($Xgafv);
            }

            public List setAccessToken(String accessToken) {
                return (List)super.setAccessToken(accessToken);
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setCallback(String callback) {
                return (List)super.setCallback(callback);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUploadType(String uploadType) {
                return (List)super.setUploadType(uploadType);
            }

            public List setUploadProtocol(String uploadProtocol) {
                return (List)super.setUploadProtocol(uploadProtocol);
            }

            public java.util.List<String> getPart() {
                return this.part;
            }

            public List setPart(java.util.List<String> part) {
                this.part = part;
                return this;
            }

            public String getHl() {
                return this.hl;
            }

            public List setHl(String hl) {
                this.hl = hl;
                return this;
            }

            public java.util.List<String> getId() {
                return this.id;
            }

            public List setId(java.util.List<String> id) {
                this.id = id;
                return this;
            }

            public String getRegionCode() {
                return this.regionCode;
            }

            public List setRegionCode(String regionCode) {
                this.regionCode = regionCode;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }
    }

    public class VideoAbuseReportReasons {
        public List list(java.util.List<String> part) throws IOException {
            List result = new List(part);
            YouTube.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class List
        extends YouTubeRequest<VideoAbuseReportReasonListResponse> {
            private static final String REST_PATH = "youtube/v3/videoAbuseReportReasons";
            @Key
            private java.util.List<String> part;
            @Key
            private String hl;

            protected List(java.util.List<String> part) {
                super(YouTube.this, "GET", REST_PATH, null, VideoAbuseReportReasonListResponse.class);
                this.part = (java.util.List)Preconditions.checkNotNull(part, (Object)"Required parameter part must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String $Xgafv) {
                return (List)super.set$Xgafv($Xgafv);
            }

            public List setAccessToken(String accessToken) {
                return (List)super.setAccessToken(accessToken);
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setCallback(String callback) {
                return (List)super.setCallback(callback);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUploadType(String uploadType) {
                return (List)super.setUploadType(uploadType);
            }

            public List setUploadProtocol(String uploadProtocol) {
                return (List)super.setUploadProtocol(uploadProtocol);
            }

            public java.util.List<String> getPart() {
                return this.part;
            }

            public List setPart(java.util.List<String> part) {
                this.part = part;
                return this;
            }

            public String getHl() {
                return this.hl;
            }

            public List setHl(String hl) {
                this.hl = hl;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }
    }

    public class Thumbnails {
        public Set set(String videoId) throws IOException {
            Set result = new Set(videoId);
            YouTube.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Set set(String videoId, AbstractInputStreamContent mediaContent) throws IOException {
            Set result = new Set(videoId, mediaContent);
            YouTube.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class Set
        extends YouTubeRequest<ThumbnailSetResponse> {
            private static final String REST_PATH = "youtube/v3/thumbnails/set";
            @Key
            private String videoId;
            @Key
            private String onBehalfOfContentOwner;

            protected Set(String videoId) {
                super(YouTube.this, "POST", REST_PATH, null, ThumbnailSetResponse.class);
                this.videoId = (String)Preconditions.checkNotNull((Object)videoId, (Object)"Required parameter videoId must be specified.");
            }

            protected Set(String videoId, AbstractInputStreamContent mediaContent) {
                super(YouTube.this, "POST", "/upload/" + YouTube.this.getServicePath() + REST_PATH, null, ThumbnailSetResponse.class);
                this.videoId = (String)Preconditions.checkNotNull((Object)videoId, (Object)"Required parameter videoId must be specified.");
                Preconditions.checkNotNull((Object)mediaContent, (Object)"Required parameter mediaContent must be specified.");
                this.initializeMediaUpload(mediaContent);
            }

            public Set set$Xgafv(String $Xgafv) {
                return (Set)super.set$Xgafv($Xgafv);
            }

            public Set setAccessToken(String accessToken) {
                return (Set)super.setAccessToken(accessToken);
            }

            public Set setAlt(String alt) {
                return (Set)super.setAlt(alt);
            }

            public Set setCallback(String callback) {
                return (Set)super.setCallback(callback);
            }

            public Set setFields(String fields) {
                return (Set)super.setFields(fields);
            }

            public Set setKey(String key) {
                return (Set)super.setKey(key);
            }

            public Set setOauthToken(String oauthToken) {
                return (Set)super.setOauthToken(oauthToken);
            }

            public Set setPrettyPrint(Boolean prettyPrint) {
                return (Set)super.setPrettyPrint(prettyPrint);
            }

            public Set setQuotaUser(String quotaUser) {
                return (Set)super.setQuotaUser(quotaUser);
            }

            public Set setUploadType(String uploadType) {
                return (Set)super.setUploadType(uploadType);
            }

            public Set setUploadProtocol(String uploadProtocol) {
                return (Set)super.setUploadProtocol(uploadProtocol);
            }

            public String getVideoId() {
                return this.videoId;
            }

            public Set setVideoId(String videoId) {
                this.videoId = videoId;
                return this;
            }

            public String getOnBehalfOfContentOwner() {
                return this.onBehalfOfContentOwner;
            }

            public Set setOnBehalfOfContentOwner(String onBehalfOfContentOwner) {
                this.onBehalfOfContentOwner = onBehalfOfContentOwner;
                return this;
            }

            @Override
            public Set set(String parameterName, Object value) {
                return (Set)super.set(parameterName, value);
            }
        }
    }

    public class ThirdPartyLinks {
        public Delete delete(String linkingToken, String type) throws IOException {
            Delete result = new Delete(linkingToken, type);
            YouTube.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Insert insert(java.util.List<String> part, ThirdPartyLink content) throws IOException {
            Insert result = new Insert(part, content);
            YouTube.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list(java.util.List<String> part) throws IOException {
            List result = new List(part);
            YouTube.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Update update(java.util.List<String> part, ThirdPartyLink content) throws IOException {
            Update result = new Update(part, content);
            YouTube.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class Update
        extends YouTubeRequest<ThirdPartyLink> {
            private static final String REST_PATH = "youtube/v3/thirdPartyLinks";
            @Key
            private java.util.List<String> part;
            @Key
            private String externalChannelId;

            protected Update(java.util.List<String> part, ThirdPartyLink content) {
                super(YouTube.this, "PUT", REST_PATH, (Object)content, ThirdPartyLink.class);
                this.part = (java.util.List)Preconditions.checkNotNull(part, (Object)"Required parameter part must be specified.");
            }

            public Update set$Xgafv(String $Xgafv) {
                return (Update)super.set$Xgafv($Xgafv);
            }

            public Update setAccessToken(String accessToken) {
                return (Update)super.setAccessToken(accessToken);
            }

            public Update setAlt(String alt) {
                return (Update)super.setAlt(alt);
            }

            public Update setCallback(String callback) {
                return (Update)super.setCallback(callback);
            }

            public Update setFields(String fields) {
                return (Update)super.setFields(fields);
            }

            public Update setKey(String key) {
                return (Update)super.setKey(key);
            }

            public Update setOauthToken(String oauthToken) {
                return (Update)super.setOauthToken(oauthToken);
            }

            public Update setPrettyPrint(Boolean prettyPrint) {
                return (Update)super.setPrettyPrint(prettyPrint);
            }

            public Update setQuotaUser(String quotaUser) {
                return (Update)super.setQuotaUser(quotaUser);
            }

            public Update setUploadType(String uploadType) {
                return (Update)super.setUploadType(uploadType);
            }

            public Update setUploadProtocol(String uploadProtocol) {
                return (Update)super.setUploadProtocol(uploadProtocol);
            }

            public java.util.List<String> getPart() {
                return this.part;
            }

            public Update setPart(java.util.List<String> part) {
                this.part = part;
                return this;
            }

            public String getExternalChannelId() {
                return this.externalChannelId;
            }

            public Update setExternalChannelId(String externalChannelId) {
                this.externalChannelId = externalChannelId;
                return this;
            }

            @Override
            public Update set(String parameterName, Object value) {
                return (Update)super.set(parameterName, value);
            }
        }

        public class List
        extends YouTubeRequest<ThirdPartyLinkListResponse> {
            private static final String REST_PATH = "youtube/v3/thirdPartyLinks";
            @Key
            private java.util.List<String> part;
            @Key
            private String externalChannelId;
            @Key
            private String linkingToken;
            @Key
            private String type;

            protected List(java.util.List<String> part) {
                super(YouTube.this, "GET", REST_PATH, null, ThirdPartyLinkListResponse.class);
                this.part = (java.util.List)Preconditions.checkNotNull(part, (Object)"Required parameter part must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String $Xgafv) {
                return (List)super.set$Xgafv($Xgafv);
            }

            public List setAccessToken(String accessToken) {
                return (List)super.setAccessToken(accessToken);
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setCallback(String callback) {
                return (List)super.setCallback(callback);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUploadType(String uploadType) {
                return (List)super.setUploadType(uploadType);
            }

            public List setUploadProtocol(String uploadProtocol) {
                return (List)super.setUploadProtocol(uploadProtocol);
            }

            public java.util.List<String> getPart() {
                return this.part;
            }

            public List setPart(java.util.List<String> part) {
                this.part = part;
                return this;
            }

            public String getExternalChannelId() {
                return this.externalChannelId;
            }

            public List setExternalChannelId(String externalChannelId) {
                this.externalChannelId = externalChannelId;
                return this;
            }

            public String getLinkingToken() {
                return this.linkingToken;
            }

            public List setLinkingToken(String linkingToken) {
                this.linkingToken = linkingToken;
                return this;
            }

            public String getType() {
                return this.type;
            }

            public List setType(String type) {
                this.type = type;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class Insert
        extends YouTubeRequest<ThirdPartyLink> {
            private static final String REST_PATH = "youtube/v3/thirdPartyLinks";
            @Key
            private java.util.List<String> part;
            @Key
            private String externalChannelId;

            protected Insert(java.util.List<String> part, ThirdPartyLink content) {
                super(YouTube.this, "POST", REST_PATH, (Object)content, ThirdPartyLink.class);
                this.part = (java.util.List)Preconditions.checkNotNull(part, (Object)"Required parameter part must be specified.");
            }

            public Insert set$Xgafv(String $Xgafv) {
                return (Insert)super.set$Xgafv($Xgafv);
            }

            public Insert setAccessToken(String accessToken) {
                return (Insert)super.setAccessToken(accessToken);
            }

            public Insert setAlt(String alt) {
                return (Insert)super.setAlt(alt);
            }

            public Insert setCallback(String callback) {
                return (Insert)super.setCallback(callback);
            }

            public Insert setFields(String fields) {
                return (Insert)super.setFields(fields);
            }

            public Insert setKey(String key) {
                return (Insert)super.setKey(key);
            }

            public Insert setOauthToken(String oauthToken) {
                return (Insert)super.setOauthToken(oauthToken);
            }

            public Insert setPrettyPrint(Boolean prettyPrint) {
                return (Insert)super.setPrettyPrint(prettyPrint);
            }

            public Insert setQuotaUser(String quotaUser) {
                return (Insert)super.setQuotaUser(quotaUser);
            }

            public Insert setUploadType(String uploadType) {
                return (Insert)super.setUploadType(uploadType);
            }

            public Insert setUploadProtocol(String uploadProtocol) {
                return (Insert)super.setUploadProtocol(uploadProtocol);
            }

            public java.util.List<String> getPart() {
                return this.part;
            }

            public Insert setPart(java.util.List<String> part) {
                this.part = part;
                return this;
            }

            public String getExternalChannelId() {
                return this.externalChannelId;
            }

            public Insert setExternalChannelId(String externalChannelId) {
                this.externalChannelId = externalChannelId;
                return this;
            }

            @Override
            public Insert set(String parameterName, Object value) {
                return (Insert)super.set(parameterName, value);
            }
        }

        public class Delete
        extends YouTubeRequest<Void> {
            private static final String REST_PATH = "youtube/v3/thirdPartyLinks";
            @Key
            private String linkingToken;
            @Key
            private String type;
            @Key
            private String externalChannelId;
            @Key
            private java.util.List<String> part;

            protected Delete(String linkingToken, String type) {
                super(YouTube.this, "DELETE", REST_PATH, null, Void.class);
                this.linkingToken = (String)Preconditions.checkNotNull((Object)linkingToken, (Object)"Required parameter linkingToken must be specified.");
                this.type = (String)Preconditions.checkNotNull((Object)type, (Object)"Required parameter type must be specified.");
            }

            public Delete set$Xgafv(String $Xgafv) {
                return (Delete)super.set$Xgafv($Xgafv);
            }

            public Delete setAccessToken(String accessToken) {
                return (Delete)super.setAccessToken(accessToken);
            }

            public Delete setAlt(String alt) {
                return (Delete)super.setAlt(alt);
            }

            public Delete setCallback(String callback) {
                return (Delete)super.setCallback(callback);
            }

            public Delete setFields(String fields) {
                return (Delete)super.setFields(fields);
            }

            public Delete setKey(String key) {
                return (Delete)super.setKey(key);
            }

            public Delete setOauthToken(String oauthToken) {
                return (Delete)super.setOauthToken(oauthToken);
            }

            public Delete setPrettyPrint(Boolean prettyPrint) {
                return (Delete)super.setPrettyPrint(prettyPrint);
            }

            public Delete setQuotaUser(String quotaUser) {
                return (Delete)super.setQuotaUser(quotaUser);
            }

            public Delete setUploadType(String uploadType) {
                return (Delete)super.setUploadType(uploadType);
            }

            public Delete setUploadProtocol(String uploadProtocol) {
                return (Delete)super.setUploadProtocol(uploadProtocol);
            }

            public String getLinkingToken() {
                return this.linkingToken;
            }

            public Delete setLinkingToken(String linkingToken) {
                this.linkingToken = linkingToken;
                return this;
            }

            public String getType() {
                return this.type;
            }

            public Delete setType(String type) {
                this.type = type;
                return this;
            }

            public String getExternalChannelId() {
                return this.externalChannelId;
            }

            public Delete setExternalChannelId(String externalChannelId) {
                this.externalChannelId = externalChannelId;
                return this;
            }

            public java.util.List<String> getPart() {
                return this.part;
            }

            public Delete setPart(java.util.List<String> part) {
                this.part = part;
                return this;
            }

            @Override
            public Delete set(String parameterName, Object value) {
                return (Delete)super.set(parameterName, value);
            }
        }
    }

    public class Tests {
        public Insert insert(List<String> part, TestItem content) throws IOException {
            Insert result = new Insert(part, content);
            YouTube.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class Insert
        extends YouTubeRequest<TestItem> {
            private static final String REST_PATH = "youtube/v3/tests";
            @Key
            private List<String> part;
            @Key
            private String externalChannelId;

            protected Insert(List<String> part, TestItem content) {
                super(YouTube.this, "POST", REST_PATH, (Object)content, TestItem.class);
                this.part = (List)Preconditions.checkNotNull(part, (Object)"Required parameter part must be specified.");
            }

            public Insert set$Xgafv(String $Xgafv) {
                return (Insert)super.set$Xgafv($Xgafv);
            }

            public Insert setAccessToken(String accessToken) {
                return (Insert)super.setAccessToken(accessToken);
            }

            public Insert setAlt(String alt) {
                return (Insert)super.setAlt(alt);
            }

            public Insert setCallback(String callback) {
                return (Insert)super.setCallback(callback);
            }

            public Insert setFields(String fields) {
                return (Insert)super.setFields(fields);
            }

            public Insert setKey(String key) {
                return (Insert)super.setKey(key);
            }

            public Insert setOauthToken(String oauthToken) {
                return (Insert)super.setOauthToken(oauthToken);
            }

            public Insert setPrettyPrint(Boolean prettyPrint) {
                return (Insert)super.setPrettyPrint(prettyPrint);
            }

            public Insert setQuotaUser(String quotaUser) {
                return (Insert)super.setQuotaUser(quotaUser);
            }

            public Insert setUploadType(String uploadType) {
                return (Insert)super.setUploadType(uploadType);
            }

            public Insert setUploadProtocol(String uploadProtocol) {
                return (Insert)super.setUploadProtocol(uploadProtocol);
            }

            public List<String> getPart() {
                return this.part;
            }

            public Insert setPart(List<String> part) {
                this.part = part;
                return this;
            }

            public String getExternalChannelId() {
                return this.externalChannelId;
            }

            public Insert setExternalChannelId(String externalChannelId) {
                this.externalChannelId = externalChannelId;
                return this;
            }

            @Override
            public Insert set(String parameterName, Object value) {
                return (Insert)super.set(parameterName, value);
            }
        }
    }

    public class SuperChatEvents {
        public List list(java.util.List<String> part) throws IOException {
            List result = new List(part);
            YouTube.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class List
        extends YouTubeRequest<SuperChatEventListResponse> {
            private static final String REST_PATH = "youtube/v3/superChatEvents";
            @Key
            private java.util.List<String> part;
            @Key
            private String hl;
            @Key
            private Long maxResults;
            @Key
            private String pageToken;

            protected List(java.util.List<String> part) {
                super(YouTube.this, "GET", REST_PATH, null, SuperChatEventListResponse.class);
                this.part = (java.util.List)Preconditions.checkNotNull(part, (Object)"Required parameter part must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String $Xgafv) {
                return (List)super.set$Xgafv($Xgafv);
            }

            public List setAccessToken(String accessToken) {
                return (List)super.setAccessToken(accessToken);
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setCallback(String callback) {
                return (List)super.setCallback(callback);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUploadType(String uploadType) {
                return (List)super.setUploadType(uploadType);
            }

            public List setUploadProtocol(String uploadProtocol) {
                return (List)super.setUploadProtocol(uploadProtocol);
            }

            public java.util.List<String> getPart() {
                return this.part;
            }

            public List setPart(java.util.List<String> part) {
                this.part = part;
                return this;
            }

            public String getHl() {
                return this.hl;
            }

            public List setHl(String hl) {
                this.hl = hl;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long maxResults) {
                this.maxResults = maxResults;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }
    }

    public class Subscriptions {
        public Delete delete(String id) throws IOException {
            Delete result = new Delete(id);
            YouTube.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Insert insert(java.util.List<String> part, Subscription content) throws IOException {
            Insert result = new Insert(part, content);
            YouTube.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list(java.util.List<String> part) throws IOException {
            List result = new List(part);
            YouTube.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class List
        extends YouTubeRequest<SubscriptionListResponse> {
            private static final String REST_PATH = "youtube/v3/subscriptions";
            @Key
            private java.util.List<String> part;
            @Key
            private String channelId;
            @Key
            private String forChannelId;
            @Key
            private java.util.List<String> id;
            @Key
            private Long maxResults;
            @Key
            private Boolean mine;
            @Key
            private Boolean myRecentSubscribers;
            @Key
            private Boolean mySubscribers;
            @Key
            private String onBehalfOfContentOwner;
            @Key
            private String onBehalfOfContentOwnerChannel;
            @Key
            private String order;
            @Key
            private String pageToken;

            protected List(java.util.List<String> part) {
                super(YouTube.this, "GET", REST_PATH, null, SubscriptionListResponse.class);
                this.part = (java.util.List)Preconditions.checkNotNull(part, (Object)"Required parameter part must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String $Xgafv) {
                return (List)super.set$Xgafv($Xgafv);
            }

            public List setAccessToken(String accessToken) {
                return (List)super.setAccessToken(accessToken);
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setCallback(String callback) {
                return (List)super.setCallback(callback);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUploadType(String uploadType) {
                return (List)super.setUploadType(uploadType);
            }

            public List setUploadProtocol(String uploadProtocol) {
                return (List)super.setUploadProtocol(uploadProtocol);
            }

            public java.util.List<String> getPart() {
                return this.part;
            }

            public List setPart(java.util.List<String> part) {
                this.part = part;
                return this;
            }

            public String getChannelId() {
                return this.channelId;
            }

            public List setChannelId(String channelId) {
                this.channelId = channelId;
                return this;
            }

            public String getForChannelId() {
                return this.forChannelId;
            }

            public List setForChannelId(String forChannelId) {
                this.forChannelId = forChannelId;
                return this;
            }

            public java.util.List<String> getId() {
                return this.id;
            }

            public List setId(java.util.List<String> id) {
                this.id = id;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long maxResults) {
                this.maxResults = maxResults;
                return this;
            }

            public Boolean getMine() {
                return this.mine;
            }

            public List setMine(Boolean mine) {
                this.mine = mine;
                return this;
            }

            public Boolean getMyRecentSubscribers() {
                return this.myRecentSubscribers;
            }

            public List setMyRecentSubscribers(Boolean myRecentSubscribers) {
                this.myRecentSubscribers = myRecentSubscribers;
                return this;
            }

            public Boolean getMySubscribers() {
                return this.mySubscribers;
            }

            public List setMySubscribers(Boolean mySubscribers) {
                this.mySubscribers = mySubscribers;
                return this;
            }

            public String getOnBehalfOfContentOwner() {
                return this.onBehalfOfContentOwner;
            }

            public List setOnBehalfOfContentOwner(String onBehalfOfContentOwner) {
                this.onBehalfOfContentOwner = onBehalfOfContentOwner;
                return this;
            }

            public String getOnBehalfOfContentOwnerChannel() {
                return this.onBehalfOfContentOwnerChannel;
            }

            public List setOnBehalfOfContentOwnerChannel(String onBehalfOfContentOwnerChannel) {
                this.onBehalfOfContentOwnerChannel = onBehalfOfContentOwnerChannel;
                return this;
            }

            public String getOrder() {
                return this.order;
            }

            public List setOrder(String order) {
                this.order = order;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class Insert
        extends YouTubeRequest<Subscription> {
            private static final String REST_PATH = "youtube/v3/subscriptions";
            @Key
            private java.util.List<String> part;

            protected Insert(java.util.List<String> part, Subscription content) {
                super(YouTube.this, "POST", REST_PATH, (Object)content, Subscription.class);
                this.part = (java.util.List)Preconditions.checkNotNull(part, (Object)"Required parameter part must be specified.");
            }

            public Insert set$Xgafv(String $Xgafv) {
                return (Insert)super.set$Xgafv($Xgafv);
            }

            public Insert setAccessToken(String accessToken) {
                return (Insert)super.setAccessToken(accessToken);
            }

            public Insert setAlt(String alt) {
                return (Insert)super.setAlt(alt);
            }

            public Insert setCallback(String callback) {
                return (Insert)super.setCallback(callback);
            }

            public Insert setFields(String fields) {
                return (Insert)super.setFields(fields);
            }

            public Insert setKey(String key) {
                return (Insert)super.setKey(key);
            }

            public Insert setOauthToken(String oauthToken) {
                return (Insert)super.setOauthToken(oauthToken);
            }

            public Insert setPrettyPrint(Boolean prettyPrint) {
                return (Insert)super.setPrettyPrint(prettyPrint);
            }

            public Insert setQuotaUser(String quotaUser) {
                return (Insert)super.setQuotaUser(quotaUser);
            }

            public Insert setUploadType(String uploadType) {
                return (Insert)super.setUploadType(uploadType);
            }

            public Insert setUploadProtocol(String uploadProtocol) {
                return (Insert)super.setUploadProtocol(uploadProtocol);
            }

            public java.util.List<String> getPart() {
                return this.part;
            }

            public Insert setPart(java.util.List<String> part) {
                this.part = part;
                return this;
            }

            @Override
            public Insert set(String parameterName, Object value) {
                return (Insert)super.set(parameterName, value);
            }
        }

        public class Delete
        extends YouTubeRequest<Void> {
            private static final String REST_PATH = "youtube/v3/subscriptions";
            @Key
            private String id;

            protected Delete(String id) {
                super(YouTube.this, "DELETE", REST_PATH, null, Void.class);
                this.id = (String)Preconditions.checkNotNull((Object)id, (Object)"Required parameter id must be specified.");
            }

            public Delete set$Xgafv(String $Xgafv) {
                return (Delete)super.set$Xgafv($Xgafv);
            }

            public Delete setAccessToken(String accessToken) {
                return (Delete)super.setAccessToken(accessToken);
            }

            public Delete setAlt(String alt) {
                return (Delete)super.setAlt(alt);
            }

            public Delete setCallback(String callback) {
                return (Delete)super.setCallback(callback);
            }

            public Delete setFields(String fields) {
                return (Delete)super.setFields(fields);
            }

            public Delete setKey(String key) {
                return (Delete)super.setKey(key);
            }

            public Delete setOauthToken(String oauthToken) {
                return (Delete)super.setOauthToken(oauthToken);
            }

            public Delete setPrettyPrint(Boolean prettyPrint) {
                return (Delete)super.setPrettyPrint(prettyPrint);
            }

            public Delete setQuotaUser(String quotaUser) {
                return (Delete)super.setQuotaUser(quotaUser);
            }

            public Delete setUploadType(String uploadType) {
                return (Delete)super.setUploadType(uploadType);
            }

            public Delete setUploadProtocol(String uploadProtocol) {
                return (Delete)super.setUploadProtocol(uploadProtocol);
            }

            public String getId() {
                return this.id;
            }

            public Delete setId(String id) {
                this.id = id;
                return this;
            }

            @Override
            public Delete set(String parameterName, Object value) {
                return (Delete)super.set(parameterName, value);
            }
        }
    }

    public class Search {
        public List list(java.util.List<String> part) throws IOException {
            List result = new List(part);
            YouTube.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class List
        extends YouTubeRequest<SearchListResponse> {
            private static final String REST_PATH = "youtube/v3/search";
            @Key
            private java.util.List<String> part;
            @Key
            private String channelId;
            @Key
            private String channelType;
            @Key
            private String eventType;
            @Key
            private Boolean forContentOwner;
            @Key
            private Boolean forDeveloper;
            @Key
            private Boolean forMine;
            @Key
            private String location;
            @Key
            private String locationRadius;
            @Key
            private Long maxResults;
            @Key
            private String onBehalfOfContentOwner;
            @Key
            private String order;
            @Key
            private String pageToken;
            @Key
            private String publishedAfter;
            @Key
            private String publishedBefore;
            @Key
            private String q;
            @Key
            private String regionCode;
            @Key
            private String relevanceLanguage;
            @Key
            private String safeSearch;
            @Key
            private String topicId;
            @Key
            private java.util.List<String> type;
            @Key
            private String videoCaption;
            @Key
            private String videoCategoryId;
            @Key
            private String videoDefinition;
            @Key
            private String videoDimension;
            @Key
            private String videoDuration;
            @Key
            private String videoEmbeddable;
            @Key
            private String videoLicense;
            @Key
            private String videoPaidProductPlacement;
            @Key
            private String videoSyndicated;
            @Key
            private String videoType;

            protected List(java.util.List<String> part) {
                super(YouTube.this, "GET", REST_PATH, null, SearchListResponse.class);
                this.part = (java.util.List)Preconditions.checkNotNull(part, (Object)"Required parameter part must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String $Xgafv) {
                return (List)super.set$Xgafv($Xgafv);
            }

            public List setAccessToken(String accessToken) {
                return (List)super.setAccessToken(accessToken);
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setCallback(String callback) {
                return (List)super.setCallback(callback);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUploadType(String uploadType) {
                return (List)super.setUploadType(uploadType);
            }

            public List setUploadProtocol(String uploadProtocol) {
                return (List)super.setUploadProtocol(uploadProtocol);
            }

            public java.util.List<String> getPart() {
                return this.part;
            }

            public List setPart(java.util.List<String> part) {
                this.part = part;
                return this;
            }

            public String getChannelId() {
                return this.channelId;
            }

            public List setChannelId(String channelId) {
                this.channelId = channelId;
                return this;
            }

            public String getChannelType() {
                return this.channelType;
            }

            public List setChannelType(String channelType) {
                this.channelType = channelType;
                return this;
            }

            public String getEventType() {
                return this.eventType;
            }

            public List setEventType(String eventType) {
                this.eventType = eventType;
                return this;
            }

            public Boolean getForContentOwner() {
                return this.forContentOwner;
            }

            public List setForContentOwner(Boolean forContentOwner) {
                this.forContentOwner = forContentOwner;
                return this;
            }

            public Boolean getForDeveloper() {
                return this.forDeveloper;
            }

            public List setForDeveloper(Boolean forDeveloper) {
                this.forDeveloper = forDeveloper;
                return this;
            }

            public Boolean getForMine() {
                return this.forMine;
            }

            public List setForMine(Boolean forMine) {
                this.forMine = forMine;
                return this;
            }

            public String getLocation() {
                return this.location;
            }

            public List setLocation(String location) {
                this.location = location;
                return this;
            }

            public String getLocationRadius() {
                return this.locationRadius;
            }

            public List setLocationRadius(String locationRadius) {
                this.locationRadius = locationRadius;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long maxResults) {
                this.maxResults = maxResults;
                return this;
            }

            public String getOnBehalfOfContentOwner() {
                return this.onBehalfOfContentOwner;
            }

            public List setOnBehalfOfContentOwner(String onBehalfOfContentOwner) {
                this.onBehalfOfContentOwner = onBehalfOfContentOwner;
                return this;
            }

            public String getOrder() {
                return this.order;
            }

            public List setOrder(String order) {
                this.order = order;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            public String getPublishedAfter() {
                return this.publishedAfter;
            }

            public List setPublishedAfter(String publishedAfter) {
                this.publishedAfter = publishedAfter;
                return this;
            }

            public String getPublishedBefore() {
                return this.publishedBefore;
            }

            public List setPublishedBefore(String publishedBefore) {
                this.publishedBefore = publishedBefore;
                return this;
            }

            public String getQ() {
                return this.q;
            }

            public List setQ(String q) {
                this.q = q;
                return this;
            }

            public String getRegionCode() {
                return this.regionCode;
            }

            public List setRegionCode(String regionCode) {
                this.regionCode = regionCode;
                return this;
            }

            public String getRelevanceLanguage() {
                return this.relevanceLanguage;
            }

            public List setRelevanceLanguage(String relevanceLanguage) {
                this.relevanceLanguage = relevanceLanguage;
                return this;
            }

            public String getSafeSearch() {
                return this.safeSearch;
            }

            public List setSafeSearch(String safeSearch) {
                this.safeSearch = safeSearch;
                return this;
            }

            public String getTopicId() {
                return this.topicId;
            }

            public List setTopicId(String topicId) {
                this.topicId = topicId;
                return this;
            }

            public java.util.List<String> getType() {
                return this.type;
            }

            public List setType(java.util.List<String> type) {
                this.type = type;
                return this;
            }

            public String getVideoCaption() {
                return this.videoCaption;
            }

            public List setVideoCaption(String videoCaption) {
                this.videoCaption = videoCaption;
                return this;
            }

            public String getVideoCategoryId() {
                return this.videoCategoryId;
            }

            public List setVideoCategoryId(String videoCategoryId) {
                this.videoCategoryId = videoCategoryId;
                return this;
            }

            public String getVideoDefinition() {
                return this.videoDefinition;
            }

            public List setVideoDefinition(String videoDefinition) {
                this.videoDefinition = videoDefinition;
                return this;
            }

            public String getVideoDimension() {
                return this.videoDimension;
            }

            public List setVideoDimension(String videoDimension) {
                this.videoDimension = videoDimension;
                return this;
            }

            public String getVideoDuration() {
                return this.videoDuration;
            }

            public List setVideoDuration(String videoDuration) {
                this.videoDuration = videoDuration;
                return this;
            }

            public String getVideoEmbeddable() {
                return this.videoEmbeddable;
            }

            public List setVideoEmbeddable(String videoEmbeddable) {
                this.videoEmbeddable = videoEmbeddable;
                return this;
            }

            public String getVideoLicense() {
                return this.videoLicense;
            }

            public List setVideoLicense(String videoLicense) {
                this.videoLicense = videoLicense;
                return this;
            }

            public String getVideoPaidProductPlacement() {
                return this.videoPaidProductPlacement;
            }

            public List setVideoPaidProductPlacement(String videoPaidProductPlacement) {
                this.videoPaidProductPlacement = videoPaidProductPlacement;
                return this;
            }

            public String getVideoSyndicated() {
                return this.videoSyndicated;
            }

            public List setVideoSyndicated(String videoSyndicated) {
                this.videoSyndicated = videoSyndicated;
                return this;
            }

            public String getVideoType() {
                return this.videoType;
            }

            public List setVideoType(String videoType) {
                this.videoType = videoType;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }
    }

    public class Playlists {
        public Delete delete(String id) throws IOException {
            Delete result = new Delete(id);
            YouTube.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Insert insert(java.util.List<String> part, Playlist content) throws IOException {
            Insert result = new Insert(part, content);
            YouTube.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list(java.util.List<String> part) throws IOException {
            List result = new List(part);
            YouTube.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Update update(java.util.List<String> part, Playlist content) throws IOException {
            Update result = new Update(part, content);
            YouTube.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class Update
        extends YouTubeRequest<Playlist> {
            private static final String REST_PATH = "youtube/v3/playlists";
            @Key
            private java.util.List<String> part;
            @Key
            private String onBehalfOfContentOwner;

            protected Update(java.util.List<String> part, Playlist content) {
                super(YouTube.this, "PUT", REST_PATH, (Object)content, Playlist.class);
                this.part = (java.util.List)Preconditions.checkNotNull(part, (Object)"Required parameter part must be specified.");
            }

            public Update set$Xgafv(String $Xgafv) {
                return (Update)super.set$Xgafv($Xgafv);
            }

            public Update setAccessToken(String accessToken) {
                return (Update)super.setAccessToken(accessToken);
            }

            public Update setAlt(String alt) {
                return (Update)super.setAlt(alt);
            }

            public Update setCallback(String callback) {
                return (Update)super.setCallback(callback);
            }

            public Update setFields(String fields) {
                return (Update)super.setFields(fields);
            }

            public Update setKey(String key) {
                return (Update)super.setKey(key);
            }

            public Update setOauthToken(String oauthToken) {
                return (Update)super.setOauthToken(oauthToken);
            }

            public Update setPrettyPrint(Boolean prettyPrint) {
                return (Update)super.setPrettyPrint(prettyPrint);
            }

            public Update setQuotaUser(String quotaUser) {
                return (Update)super.setQuotaUser(quotaUser);
            }

            public Update setUploadType(String uploadType) {
                return (Update)super.setUploadType(uploadType);
            }

            public Update setUploadProtocol(String uploadProtocol) {
                return (Update)super.setUploadProtocol(uploadProtocol);
            }

            public java.util.List<String> getPart() {
                return this.part;
            }

            public Update setPart(java.util.List<String> part) {
                this.part = part;
                return this;
            }

            public String getOnBehalfOfContentOwner() {
                return this.onBehalfOfContentOwner;
            }

            public Update setOnBehalfOfContentOwner(String onBehalfOfContentOwner) {
                this.onBehalfOfContentOwner = onBehalfOfContentOwner;
                return this;
            }

            @Override
            public Update set(String parameterName, Object value) {
                return (Update)super.set(parameterName, value);
            }
        }

        public class List
        extends YouTubeRequest<PlaylistListResponse> {
            private static final String REST_PATH = "youtube/v3/playlists";
            @Key
            private java.util.List<String> part;
            @Key
            private String channelId;
            @Key
            private String hl;
            @Key
            private java.util.List<String> id;
            @Key
            private Long maxResults;
            @Key
            private Boolean mine;
            @Key
            private String onBehalfOfContentOwner;
            @Key
            private String onBehalfOfContentOwnerChannel;
            @Key
            private String pageToken;

            protected List(java.util.List<String> part) {
                super(YouTube.this, "GET", REST_PATH, null, PlaylistListResponse.class);
                this.part = (java.util.List)Preconditions.checkNotNull(part, (Object)"Required parameter part must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String $Xgafv) {
                return (List)super.set$Xgafv($Xgafv);
            }

            public List setAccessToken(String accessToken) {
                return (List)super.setAccessToken(accessToken);
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setCallback(String callback) {
                return (List)super.setCallback(callback);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUploadType(String uploadType) {
                return (List)super.setUploadType(uploadType);
            }

            public List setUploadProtocol(String uploadProtocol) {
                return (List)super.setUploadProtocol(uploadProtocol);
            }

            public java.util.List<String> getPart() {
                return this.part;
            }

            public List setPart(java.util.List<String> part) {
                this.part = part;
                return this;
            }

            public String getChannelId() {
                return this.channelId;
            }

            public List setChannelId(String channelId) {
                this.channelId = channelId;
                return this;
            }

            public String getHl() {
                return this.hl;
            }

            public List setHl(String hl) {
                this.hl = hl;
                return this;
            }

            public java.util.List<String> getId() {
                return this.id;
            }

            public List setId(java.util.List<String> id) {
                this.id = id;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long maxResults) {
                this.maxResults = maxResults;
                return this;
            }

            public Boolean getMine() {
                return this.mine;
            }

            public List setMine(Boolean mine) {
                this.mine = mine;
                return this;
            }

            public String getOnBehalfOfContentOwner() {
                return this.onBehalfOfContentOwner;
            }

            public List setOnBehalfOfContentOwner(String onBehalfOfContentOwner) {
                this.onBehalfOfContentOwner = onBehalfOfContentOwner;
                return this;
            }

            public String getOnBehalfOfContentOwnerChannel() {
                return this.onBehalfOfContentOwnerChannel;
            }

            public List setOnBehalfOfContentOwnerChannel(String onBehalfOfContentOwnerChannel) {
                this.onBehalfOfContentOwnerChannel = onBehalfOfContentOwnerChannel;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class Insert
        extends YouTubeRequest<Playlist> {
            private static final String REST_PATH = "youtube/v3/playlists";
            @Key
            private java.util.List<String> part;
            @Key
            private String onBehalfOfContentOwner;
            @Key
            private String onBehalfOfContentOwnerChannel;

            protected Insert(java.util.List<String> part, Playlist content) {
                super(YouTube.this, "POST", REST_PATH, (Object)content, Playlist.class);
                this.part = (java.util.List)Preconditions.checkNotNull(part, (Object)"Required parameter part must be specified.");
            }

            public Insert set$Xgafv(String $Xgafv) {
                return (Insert)super.set$Xgafv($Xgafv);
            }

            public Insert setAccessToken(String accessToken) {
                return (Insert)super.setAccessToken(accessToken);
            }

            public Insert setAlt(String alt) {
                return (Insert)super.setAlt(alt);
            }

            public Insert setCallback(String callback) {
                return (Insert)super.setCallback(callback);
            }

            public Insert setFields(String fields) {
                return (Insert)super.setFields(fields);
            }

            public Insert setKey(String key) {
                return (Insert)super.setKey(key);
            }

            public Insert setOauthToken(String oauthToken) {
                return (Insert)super.setOauthToken(oauthToken);
            }

            public Insert setPrettyPrint(Boolean prettyPrint) {
                return (Insert)super.setPrettyPrint(prettyPrint);
            }

            public Insert setQuotaUser(String quotaUser) {
                return (Insert)super.setQuotaUser(quotaUser);
            }

            public Insert setUploadType(String uploadType) {
                return (Insert)super.setUploadType(uploadType);
            }

            public Insert setUploadProtocol(String uploadProtocol) {
                return (Insert)super.setUploadProtocol(uploadProtocol);
            }

            public java.util.List<String> getPart() {
                return this.part;
            }

            public Insert setPart(java.util.List<String> part) {
                this.part = part;
                return this;
            }

            public String getOnBehalfOfContentOwner() {
                return this.onBehalfOfContentOwner;
            }

            public Insert setOnBehalfOfContentOwner(String onBehalfOfContentOwner) {
                this.onBehalfOfContentOwner = onBehalfOfContentOwner;
                return this;
            }

            public String getOnBehalfOfContentOwnerChannel() {
                return this.onBehalfOfContentOwnerChannel;
            }

            public Insert setOnBehalfOfContentOwnerChannel(String onBehalfOfContentOwnerChannel) {
                this.onBehalfOfContentOwnerChannel = onBehalfOfContentOwnerChannel;
                return this;
            }

            @Override
            public Insert set(String parameterName, Object value) {
                return (Insert)super.set(parameterName, value);
            }
        }

        public class Delete
        extends YouTubeRequest<Void> {
            private static final String REST_PATH = "youtube/v3/playlists";
            @Key
            private String id;
            @Key
            private String onBehalfOfContentOwner;

            protected Delete(String id) {
                super(YouTube.this, "DELETE", REST_PATH, null, Void.class);
                this.id = (String)Preconditions.checkNotNull((Object)id, (Object)"Required parameter id must be specified.");
            }

            public Delete set$Xgafv(String $Xgafv) {
                return (Delete)super.set$Xgafv($Xgafv);
            }

            public Delete setAccessToken(String accessToken) {
                return (Delete)super.setAccessToken(accessToken);
            }

            public Delete setAlt(String alt) {
                return (Delete)super.setAlt(alt);
            }

            public Delete setCallback(String callback) {
                return (Delete)super.setCallback(callback);
            }

            public Delete setFields(String fields) {
                return (Delete)super.setFields(fields);
            }

            public Delete setKey(String key) {
                return (Delete)super.setKey(key);
            }

            public Delete setOauthToken(String oauthToken) {
                return (Delete)super.setOauthToken(oauthToken);
            }

            public Delete setPrettyPrint(Boolean prettyPrint) {
                return (Delete)super.setPrettyPrint(prettyPrint);
            }

            public Delete setQuotaUser(String quotaUser) {
                return (Delete)super.setQuotaUser(quotaUser);
            }

            public Delete setUploadType(String uploadType) {
                return (Delete)super.setUploadType(uploadType);
            }

            public Delete setUploadProtocol(String uploadProtocol) {
                return (Delete)super.setUploadProtocol(uploadProtocol);
            }

            public String getId() {
                return this.id;
            }

            public Delete setId(String id) {
                this.id = id;
                return this;
            }

            public String getOnBehalfOfContentOwner() {
                return this.onBehalfOfContentOwner;
            }

            public Delete setOnBehalfOfContentOwner(String onBehalfOfContentOwner) {
                this.onBehalfOfContentOwner = onBehalfOfContentOwner;
                return this;
            }

            @Override
            public Delete set(String parameterName, Object value) {
                return (Delete)super.set(parameterName, value);
            }
        }
    }

    public class PlaylistItems {
        public Delete delete(String id) throws IOException {
            Delete result = new Delete(id);
            YouTube.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Insert insert(java.util.List<String> part, PlaylistItem content) throws IOException {
            Insert result = new Insert(part, content);
            YouTube.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list(java.util.List<String> part) throws IOException {
            List result = new List(part);
            YouTube.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Update update(java.util.List<String> part, PlaylistItem content) throws IOException {
            Update result = new Update(part, content);
            YouTube.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class Update
        extends YouTubeRequest<PlaylistItem> {
            private static final String REST_PATH = "youtube/v3/playlistItems";
            @Key
            private java.util.List<String> part;
            @Key
            private String onBehalfOfContentOwner;

            protected Update(java.util.List<String> part, PlaylistItem content) {
                super(YouTube.this, "PUT", REST_PATH, (Object)content, PlaylistItem.class);
                this.part = (java.util.List)Preconditions.checkNotNull(part, (Object)"Required parameter part must be specified.");
            }

            public Update set$Xgafv(String $Xgafv) {
                return (Update)super.set$Xgafv($Xgafv);
            }

            public Update setAccessToken(String accessToken) {
                return (Update)super.setAccessToken(accessToken);
            }

            public Update setAlt(String alt) {
                return (Update)super.setAlt(alt);
            }

            public Update setCallback(String callback) {
                return (Update)super.setCallback(callback);
            }

            public Update setFields(String fields) {
                return (Update)super.setFields(fields);
            }

            public Update setKey(String key) {
                return (Update)super.setKey(key);
            }

            public Update setOauthToken(String oauthToken) {
                return (Update)super.setOauthToken(oauthToken);
            }

            public Update setPrettyPrint(Boolean prettyPrint) {
                return (Update)super.setPrettyPrint(prettyPrint);
            }

            public Update setQuotaUser(String quotaUser) {
                return (Update)super.setQuotaUser(quotaUser);
            }

            public Update setUploadType(String uploadType) {
                return (Update)super.setUploadType(uploadType);
            }

            public Update setUploadProtocol(String uploadProtocol) {
                return (Update)super.setUploadProtocol(uploadProtocol);
            }

            public java.util.List<String> getPart() {
                return this.part;
            }

            public Update setPart(java.util.List<String> part) {
                this.part = part;
                return this;
            }

            public String getOnBehalfOfContentOwner() {
                return this.onBehalfOfContentOwner;
            }

            public Update setOnBehalfOfContentOwner(String onBehalfOfContentOwner) {
                this.onBehalfOfContentOwner = onBehalfOfContentOwner;
                return this;
            }

            @Override
            public Update set(String parameterName, Object value) {
                return (Update)super.set(parameterName, value);
            }
        }

        public class List
        extends YouTubeRequest<PlaylistItemListResponse> {
            private static final String REST_PATH = "youtube/v3/playlistItems";
            @Key
            private java.util.List<String> part;
            @Key
            private java.util.List<String> id;
            @Key
            private Long maxResults;
            @Key
            private String onBehalfOfContentOwner;
            @Key
            private String pageToken;
            @Key
            private String playlistId;
            @Key
            private String videoId;

            protected List(java.util.List<String> part) {
                super(YouTube.this, "GET", REST_PATH, null, PlaylistItemListResponse.class);
                this.part = (java.util.List)Preconditions.checkNotNull(part, (Object)"Required parameter part must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String $Xgafv) {
                return (List)super.set$Xgafv($Xgafv);
            }

            public List setAccessToken(String accessToken) {
                return (List)super.setAccessToken(accessToken);
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setCallback(String callback) {
                return (List)super.setCallback(callback);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUploadType(String uploadType) {
                return (List)super.setUploadType(uploadType);
            }

            public List setUploadProtocol(String uploadProtocol) {
                return (List)super.setUploadProtocol(uploadProtocol);
            }

            public java.util.List<String> getPart() {
                return this.part;
            }

            public List setPart(java.util.List<String> part) {
                this.part = part;
                return this;
            }

            public java.util.List<String> getId() {
                return this.id;
            }

            public List setId(java.util.List<String> id) {
                this.id = id;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long maxResults) {
                this.maxResults = maxResults;
                return this;
            }

            public String getOnBehalfOfContentOwner() {
                return this.onBehalfOfContentOwner;
            }

            public List setOnBehalfOfContentOwner(String onBehalfOfContentOwner) {
                this.onBehalfOfContentOwner = onBehalfOfContentOwner;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            public String getPlaylistId() {
                return this.playlistId;
            }

            public List setPlaylistId(String playlistId) {
                this.playlistId = playlistId;
                return this;
            }

            public String getVideoId() {
                return this.videoId;
            }

            public List setVideoId(String videoId) {
                this.videoId = videoId;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class Insert
        extends YouTubeRequest<PlaylistItem> {
            private static final String REST_PATH = "youtube/v3/playlistItems";
            @Key
            private java.util.List<String> part;
            @Key
            private String onBehalfOfContentOwner;

            protected Insert(java.util.List<String> part, PlaylistItem content) {
                super(YouTube.this, "POST", REST_PATH, (Object)content, PlaylistItem.class);
                this.part = (java.util.List)Preconditions.checkNotNull(part, (Object)"Required parameter part must be specified.");
            }

            public Insert set$Xgafv(String $Xgafv) {
                return (Insert)super.set$Xgafv($Xgafv);
            }

            public Insert setAccessToken(String accessToken) {
                return (Insert)super.setAccessToken(accessToken);
            }

            public Insert setAlt(String alt) {
                return (Insert)super.setAlt(alt);
            }

            public Insert setCallback(String callback) {
                return (Insert)super.setCallback(callback);
            }

            public Insert setFields(String fields) {
                return (Insert)super.setFields(fields);
            }

            public Insert setKey(String key) {
                return (Insert)super.setKey(key);
            }

            public Insert setOauthToken(String oauthToken) {
                return (Insert)super.setOauthToken(oauthToken);
            }

            public Insert setPrettyPrint(Boolean prettyPrint) {
                return (Insert)super.setPrettyPrint(prettyPrint);
            }

            public Insert setQuotaUser(String quotaUser) {
                return (Insert)super.setQuotaUser(quotaUser);
            }

            public Insert setUploadType(String uploadType) {
                return (Insert)super.setUploadType(uploadType);
            }

            public Insert setUploadProtocol(String uploadProtocol) {
                return (Insert)super.setUploadProtocol(uploadProtocol);
            }

            public java.util.List<String> getPart() {
                return this.part;
            }

            public Insert setPart(java.util.List<String> part) {
                this.part = part;
                return this;
            }

            public String getOnBehalfOfContentOwner() {
                return this.onBehalfOfContentOwner;
            }

            public Insert setOnBehalfOfContentOwner(String onBehalfOfContentOwner) {
                this.onBehalfOfContentOwner = onBehalfOfContentOwner;
                return this;
            }

            @Override
            public Insert set(String parameterName, Object value) {
                return (Insert)super.set(parameterName, value);
            }
        }

        public class Delete
        extends YouTubeRequest<Void> {
            private static final String REST_PATH = "youtube/v3/playlistItems";
            @Key
            private String id;
            @Key
            private String onBehalfOfContentOwner;

            protected Delete(String id) {
                super(YouTube.this, "DELETE", REST_PATH, null, Void.class);
                this.id = (String)Preconditions.checkNotNull((Object)id, (Object)"Required parameter id must be specified.");
            }

            public Delete set$Xgafv(String $Xgafv) {
                return (Delete)super.set$Xgafv($Xgafv);
            }

            public Delete setAccessToken(String accessToken) {
                return (Delete)super.setAccessToken(accessToken);
            }

            public Delete setAlt(String alt) {
                return (Delete)super.setAlt(alt);
            }

            public Delete setCallback(String callback) {
                return (Delete)super.setCallback(callback);
            }

            public Delete setFields(String fields) {
                return (Delete)super.setFields(fields);
            }

            public Delete setKey(String key) {
                return (Delete)super.setKey(key);
            }

            public Delete setOauthToken(String oauthToken) {
                return (Delete)super.setOauthToken(oauthToken);
            }

            public Delete setPrettyPrint(Boolean prettyPrint) {
                return (Delete)super.setPrettyPrint(prettyPrint);
            }

            public Delete setQuotaUser(String quotaUser) {
                return (Delete)super.setQuotaUser(quotaUser);
            }

            public Delete setUploadType(String uploadType) {
                return (Delete)super.setUploadType(uploadType);
            }

            public Delete setUploadProtocol(String uploadProtocol) {
                return (Delete)super.setUploadProtocol(uploadProtocol);
            }

            public String getId() {
                return this.id;
            }

            public Delete setId(String id) {
                this.id = id;
                return this;
            }

            public String getOnBehalfOfContentOwner() {
                return this.onBehalfOfContentOwner;
            }

            public Delete setOnBehalfOfContentOwner(String onBehalfOfContentOwner) {
                this.onBehalfOfContentOwner = onBehalfOfContentOwner;
                return this;
            }

            @Override
            public Delete set(String parameterName, Object value) {
                return (Delete)super.set(parameterName, value);
            }
        }
    }

    public class PlaylistImages {
        public Delete delete() throws IOException {
            Delete result = new Delete();
            YouTube.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Insert insert(PlaylistImage content) throws IOException {
            Insert result = new Insert(content);
            YouTube.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Insert insert(PlaylistImage content, AbstractInputStreamContent mediaContent) throws IOException {
            Insert result = new Insert(content, mediaContent);
            YouTube.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list() throws IOException {
            List result = new List();
            YouTube.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Update update(PlaylistImage content) throws IOException {
            Update result = new Update(content);
            YouTube.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Update update(PlaylistImage content, AbstractInputStreamContent mediaContent) throws IOException {
            Update result = new Update(content, mediaContent);
            YouTube.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class Update
        extends YouTubeRequest<PlaylistImage> {
            private static final String REST_PATH = "youtube/v3/playlistImages";
            @Key
            private String onBehalfOfContentOwner;
            @Key
            private java.util.List<String> part;

            protected Update(PlaylistImage content) {
                super(YouTube.this, "PUT", REST_PATH, (Object)content, PlaylistImage.class);
            }

            protected Update(PlaylistImage content, AbstractInputStreamContent mediaContent) {
                super(YouTube.this, "PUT", "/upload/" + YouTube.this.getServicePath() + REST_PATH, (Object)content, PlaylistImage.class);
                Preconditions.checkNotNull((Object)mediaContent, (Object)"Required parameter mediaContent must be specified.");
                this.initializeMediaUpload(mediaContent);
            }

            public Update set$Xgafv(String $Xgafv) {
                return (Update)super.set$Xgafv($Xgafv);
            }

            public Update setAccessToken(String accessToken) {
                return (Update)super.setAccessToken(accessToken);
            }

            public Update setAlt(String alt) {
                return (Update)super.setAlt(alt);
            }

            public Update setCallback(String callback) {
                return (Update)super.setCallback(callback);
            }

            public Update setFields(String fields) {
                return (Update)super.setFields(fields);
            }

            public Update setKey(String key) {
                return (Update)super.setKey(key);
            }

            public Update setOauthToken(String oauthToken) {
                return (Update)super.setOauthToken(oauthToken);
            }

            public Update setPrettyPrint(Boolean prettyPrint) {
                return (Update)super.setPrettyPrint(prettyPrint);
            }

            public Update setQuotaUser(String quotaUser) {
                return (Update)super.setQuotaUser(quotaUser);
            }

            public Update setUploadType(String uploadType) {
                return (Update)super.setUploadType(uploadType);
            }

            public Update setUploadProtocol(String uploadProtocol) {
                return (Update)super.setUploadProtocol(uploadProtocol);
            }

            public String getOnBehalfOfContentOwner() {
                return this.onBehalfOfContentOwner;
            }

            public Update setOnBehalfOfContentOwner(String onBehalfOfContentOwner) {
                this.onBehalfOfContentOwner = onBehalfOfContentOwner;
                return this;
            }

            public java.util.List<String> getPart() {
                return this.part;
            }

            public Update setPart(java.util.List<String> part) {
                this.part = part;
                return this;
            }

            @Override
            public Update set(String parameterName, Object value) {
                return (Update)super.set(parameterName, value);
            }
        }

        public class List
        extends YouTubeRequest<PlaylistImageListResponse> {
            private static final String REST_PATH = "youtube/v3/playlistImages";
            @Key
            private Long maxResults;
            @Key
            private String onBehalfOfContentOwner;
            @Key
            private String onBehalfOfContentOwnerChannel;
            @Key
            private String pageToken;
            @Key
            private String parent;
            @Key
            private java.util.List<String> part;

            protected List() {
                super(YouTube.this, "GET", REST_PATH, null, PlaylistImageListResponse.class);
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String $Xgafv) {
                return (List)super.set$Xgafv($Xgafv);
            }

            public List setAccessToken(String accessToken) {
                return (List)super.setAccessToken(accessToken);
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setCallback(String callback) {
                return (List)super.setCallback(callback);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUploadType(String uploadType) {
                return (List)super.setUploadType(uploadType);
            }

            public List setUploadProtocol(String uploadProtocol) {
                return (List)super.setUploadProtocol(uploadProtocol);
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long maxResults) {
                this.maxResults = maxResults;
                return this;
            }

            public String getOnBehalfOfContentOwner() {
                return this.onBehalfOfContentOwner;
            }

            public List setOnBehalfOfContentOwner(String onBehalfOfContentOwner) {
                this.onBehalfOfContentOwner = onBehalfOfContentOwner;
                return this;
            }

            public String getOnBehalfOfContentOwnerChannel() {
                return this.onBehalfOfContentOwnerChannel;
            }

            public List setOnBehalfOfContentOwnerChannel(String onBehalfOfContentOwnerChannel) {
                this.onBehalfOfContentOwnerChannel = onBehalfOfContentOwnerChannel;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            public String getParent() {
                return this.parent;
            }

            public List setParent(String parent) {
                this.parent = parent;
                return this;
            }

            public java.util.List<String> getPart() {
                return this.part;
            }

            public List setPart(java.util.List<String> part) {
                this.part = part;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class Insert
        extends YouTubeRequest<PlaylistImage> {
            private static final String REST_PATH = "youtube/v3/playlistImages";
            @Key
            private String onBehalfOfContentOwner;
            @Key
            private String onBehalfOfContentOwnerChannel;
            @Key
            private java.util.List<String> part;

            protected Insert(PlaylistImage content) {
                super(YouTube.this, "POST", REST_PATH, (Object)content, PlaylistImage.class);
            }

            protected Insert(PlaylistImage content, AbstractInputStreamContent mediaContent) {
                super(YouTube.this, "POST", "/upload/" + YouTube.this.getServicePath() + REST_PATH, (Object)content, PlaylistImage.class);
                Preconditions.checkNotNull((Object)mediaContent, (Object)"Required parameter mediaContent must be specified.");
                this.initializeMediaUpload(mediaContent);
            }

            public Insert set$Xgafv(String $Xgafv) {
                return (Insert)super.set$Xgafv($Xgafv);
            }

            public Insert setAccessToken(String accessToken) {
                return (Insert)super.setAccessToken(accessToken);
            }

            public Insert setAlt(String alt) {
                return (Insert)super.setAlt(alt);
            }

            public Insert setCallback(String callback) {
                return (Insert)super.setCallback(callback);
            }

            public Insert setFields(String fields) {
                return (Insert)super.setFields(fields);
            }

            public Insert setKey(String key) {
                return (Insert)super.setKey(key);
            }

            public Insert setOauthToken(String oauthToken) {
                return (Insert)super.setOauthToken(oauthToken);
            }

            public Insert setPrettyPrint(Boolean prettyPrint) {
                return (Insert)super.setPrettyPrint(prettyPrint);
            }

            public Insert setQuotaUser(String quotaUser) {
                return (Insert)super.setQuotaUser(quotaUser);
            }

            public Insert setUploadType(String uploadType) {
                return (Insert)super.setUploadType(uploadType);
            }

            public Insert setUploadProtocol(String uploadProtocol) {
                return (Insert)super.setUploadProtocol(uploadProtocol);
            }

            public String getOnBehalfOfContentOwner() {
                return this.onBehalfOfContentOwner;
            }

            public Insert setOnBehalfOfContentOwner(String onBehalfOfContentOwner) {
                this.onBehalfOfContentOwner = onBehalfOfContentOwner;
                return this;
            }

            public String getOnBehalfOfContentOwnerChannel() {
                return this.onBehalfOfContentOwnerChannel;
            }

            public Insert setOnBehalfOfContentOwnerChannel(String onBehalfOfContentOwnerChannel) {
                this.onBehalfOfContentOwnerChannel = onBehalfOfContentOwnerChannel;
                return this;
            }

            public java.util.List<String> getPart() {
                return this.part;
            }

            public Insert setPart(java.util.List<String> part) {
                this.part = part;
                return this;
            }

            @Override
            public Insert set(String parameterName, Object value) {
                return (Insert)super.set(parameterName, value);
            }
        }

        public class Delete
        extends YouTubeRequest<Void> {
            private static final String REST_PATH = "youtube/v3/playlistImages";
            @Key
            private String id;
            @Key
            private String onBehalfOfContentOwner;

            protected Delete() {
                super(YouTube.this, "DELETE", REST_PATH, null, Void.class);
            }

            public Delete set$Xgafv(String $Xgafv) {
                return (Delete)super.set$Xgafv($Xgafv);
            }

            public Delete setAccessToken(String accessToken) {
                return (Delete)super.setAccessToken(accessToken);
            }

            public Delete setAlt(String alt) {
                return (Delete)super.setAlt(alt);
            }

            public Delete setCallback(String callback) {
                return (Delete)super.setCallback(callback);
            }

            public Delete setFields(String fields) {
                return (Delete)super.setFields(fields);
            }

            public Delete setKey(String key) {
                return (Delete)super.setKey(key);
            }

            public Delete setOauthToken(String oauthToken) {
                return (Delete)super.setOauthToken(oauthToken);
            }

            public Delete setPrettyPrint(Boolean prettyPrint) {
                return (Delete)super.setPrettyPrint(prettyPrint);
            }

            public Delete setQuotaUser(String quotaUser) {
                return (Delete)super.setQuotaUser(quotaUser);
            }

            public Delete setUploadType(String uploadType) {
                return (Delete)super.setUploadType(uploadType);
            }

            public Delete setUploadProtocol(String uploadProtocol) {
                return (Delete)super.setUploadProtocol(uploadProtocol);
            }

            public String getId() {
                return this.id;
            }

            public Delete setId(String id) {
                this.id = id;
                return this;
            }

            public String getOnBehalfOfContentOwner() {
                return this.onBehalfOfContentOwner;
            }

            public Delete setOnBehalfOfContentOwner(String onBehalfOfContentOwner) {
                this.onBehalfOfContentOwner = onBehalfOfContentOwner;
                return this;
            }

            @Override
            public Delete set(String parameterName, Object value) {
                return (Delete)super.set(parameterName, value);
            }
        }
    }

    public class MembershipsLevels {
        public List list(java.util.List<String> part) throws IOException {
            List result = new List(part);
            YouTube.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class List
        extends YouTubeRequest<MembershipsLevelListResponse> {
            private static final String REST_PATH = "youtube/v3/membershipsLevels";
            @Key
            private java.util.List<String> part;

            protected List(java.util.List<String> part) {
                super(YouTube.this, "GET", REST_PATH, null, MembershipsLevelListResponse.class);
                this.part = (java.util.List)Preconditions.checkNotNull(part, (Object)"Required parameter part must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String $Xgafv) {
                return (List)super.set$Xgafv($Xgafv);
            }

            public List setAccessToken(String accessToken) {
                return (List)super.setAccessToken(accessToken);
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setCallback(String callback) {
                return (List)super.setCallback(callback);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUploadType(String uploadType) {
                return (List)super.setUploadType(uploadType);
            }

            public List setUploadProtocol(String uploadProtocol) {
                return (List)super.setUploadProtocol(uploadProtocol);
            }

            public java.util.List<String> getPart() {
                return this.part;
            }

            public List setPart(java.util.List<String> part) {
                this.part = part;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }
    }

    public class Members {
        public List list(java.util.List<String> part) throws IOException {
            List result = new List(part);
            YouTube.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class List
        extends YouTubeRequest<MemberListResponse> {
            private static final String REST_PATH = "youtube/v3/members";
            @Key
            private java.util.List<String> part;
            @Key
            private String filterByMemberChannelId;
            @Key
            private String hasAccessToLevel;
            @Key
            private Long maxResults;
            @Key
            private String mode;
            @Key
            private String pageToken;

            protected List(java.util.List<String> part) {
                super(YouTube.this, "GET", REST_PATH, null, MemberListResponse.class);
                this.part = (java.util.List)Preconditions.checkNotNull(part, (Object)"Required parameter part must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String $Xgafv) {
                return (List)super.set$Xgafv($Xgafv);
            }

            public List setAccessToken(String accessToken) {
                return (List)super.setAccessToken(accessToken);
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setCallback(String callback) {
                return (List)super.setCallback(callback);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUploadType(String uploadType) {
                return (List)super.setUploadType(uploadType);
            }

            public List setUploadProtocol(String uploadProtocol) {
                return (List)super.setUploadProtocol(uploadProtocol);
            }

            public java.util.List<String> getPart() {
                return this.part;
            }

            public List setPart(java.util.List<String> part) {
                this.part = part;
                return this;
            }

            public String getFilterByMemberChannelId() {
                return this.filterByMemberChannelId;
            }

            public List setFilterByMemberChannelId(String filterByMemberChannelId) {
                this.filterByMemberChannelId = filterByMemberChannelId;
                return this;
            }

            public String getHasAccessToLevel() {
                return this.hasAccessToLevel;
            }

            public List setHasAccessToLevel(String hasAccessToLevel) {
                this.hasAccessToLevel = hasAccessToLevel;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long maxResults) {
                this.maxResults = maxResults;
                return this;
            }

            public String getMode() {
                return this.mode;
            }

            public List setMode(String mode) {
                this.mode = mode;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }
    }

    public class LiveStreams {
        public Delete delete(String id) throws IOException {
            Delete result = new Delete(id);
            YouTube.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Insert insert(java.util.List<String> part, LiveStream content) throws IOException {
            Insert result = new Insert(part, content);
            YouTube.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list(java.util.List<String> part) throws IOException {
            List result = new List(part);
            YouTube.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Update update(java.util.List<String> part, LiveStream content) throws IOException {
            Update result = new Update(part, content);
            YouTube.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class Update
        extends YouTubeRequest<LiveStream> {
            private static final String REST_PATH = "youtube/v3/liveStreams";
            @Key
            private java.util.List<String> part;
            @Key
            private String onBehalfOfContentOwner;
            @Key
            private String onBehalfOfContentOwnerChannel;

            protected Update(java.util.List<String> part, LiveStream content) {
                super(YouTube.this, "PUT", REST_PATH, (Object)content, LiveStream.class);
                this.part = (java.util.List)Preconditions.checkNotNull(part, (Object)"Required parameter part must be specified.");
                this.checkRequiredParameter((Object)content, "content");
                this.checkRequiredParameter(content.getId(), "LiveStream.getId()");
            }

            public Update set$Xgafv(String $Xgafv) {
                return (Update)super.set$Xgafv($Xgafv);
            }

            public Update setAccessToken(String accessToken) {
                return (Update)super.setAccessToken(accessToken);
            }

            public Update setAlt(String alt) {
                return (Update)super.setAlt(alt);
            }

            public Update setCallback(String callback) {
                return (Update)super.setCallback(callback);
            }

            public Update setFields(String fields) {
                return (Update)super.setFields(fields);
            }

            public Update setKey(String key) {
                return (Update)super.setKey(key);
            }

            public Update setOauthToken(String oauthToken) {
                return (Update)super.setOauthToken(oauthToken);
            }

            public Update setPrettyPrint(Boolean prettyPrint) {
                return (Update)super.setPrettyPrint(prettyPrint);
            }

            public Update setQuotaUser(String quotaUser) {
                return (Update)super.setQuotaUser(quotaUser);
            }

            public Update setUploadType(String uploadType) {
                return (Update)super.setUploadType(uploadType);
            }

            public Update setUploadProtocol(String uploadProtocol) {
                return (Update)super.setUploadProtocol(uploadProtocol);
            }

            public java.util.List<String> getPart() {
                return this.part;
            }

            public Update setPart(java.util.List<String> part) {
                this.part = part;
                return this;
            }

            public String getOnBehalfOfContentOwner() {
                return this.onBehalfOfContentOwner;
            }

            public Update setOnBehalfOfContentOwner(String onBehalfOfContentOwner) {
                this.onBehalfOfContentOwner = onBehalfOfContentOwner;
                return this;
            }

            public String getOnBehalfOfContentOwnerChannel() {
                return this.onBehalfOfContentOwnerChannel;
            }

            public Update setOnBehalfOfContentOwnerChannel(String onBehalfOfContentOwnerChannel) {
                this.onBehalfOfContentOwnerChannel = onBehalfOfContentOwnerChannel;
                return this;
            }

            @Override
            public Update set(String parameterName, Object value) {
                return (Update)super.set(parameterName, value);
            }
        }

        public class List
        extends YouTubeRequest<LiveStreamListResponse> {
            private static final String REST_PATH = "youtube/v3/liveStreams";
            @Key
            private java.util.List<String> part;
            @Key
            private java.util.List<String> id;
            @Key
            private Long maxResults;
            @Key
            private Boolean mine;
            @Key
            private String onBehalfOfContentOwner;
            @Key
            private String onBehalfOfContentOwnerChannel;
            @Key
            private String pageToken;

            protected List(java.util.List<String> part) {
                super(YouTube.this, "GET", REST_PATH, null, LiveStreamListResponse.class);
                this.part = (java.util.List)Preconditions.checkNotNull(part, (Object)"Required parameter part must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String $Xgafv) {
                return (List)super.set$Xgafv($Xgafv);
            }

            public List setAccessToken(String accessToken) {
                return (List)super.setAccessToken(accessToken);
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setCallback(String callback) {
                return (List)super.setCallback(callback);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUploadType(String uploadType) {
                return (List)super.setUploadType(uploadType);
            }

            public List setUploadProtocol(String uploadProtocol) {
                return (List)super.setUploadProtocol(uploadProtocol);
            }

            public java.util.List<String> getPart() {
                return this.part;
            }

            public List setPart(java.util.List<String> part) {
                this.part = part;
                return this;
            }

            public java.util.List<String> getId() {
                return this.id;
            }

            public List setId(java.util.List<String> id) {
                this.id = id;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long maxResults) {
                this.maxResults = maxResults;
                return this;
            }

            public Boolean getMine() {
                return this.mine;
            }

            public List setMine(Boolean mine) {
                this.mine = mine;
                return this;
            }

            public String getOnBehalfOfContentOwner() {
                return this.onBehalfOfContentOwner;
            }

            public List setOnBehalfOfContentOwner(String onBehalfOfContentOwner) {
                this.onBehalfOfContentOwner = onBehalfOfContentOwner;
                return this;
            }

            public String getOnBehalfOfContentOwnerChannel() {
                return this.onBehalfOfContentOwnerChannel;
            }

            public List setOnBehalfOfContentOwnerChannel(String onBehalfOfContentOwnerChannel) {
                this.onBehalfOfContentOwnerChannel = onBehalfOfContentOwnerChannel;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class Insert
        extends YouTubeRequest<LiveStream> {
            private static final String REST_PATH = "youtube/v3/liveStreams";
            @Key
            private java.util.List<String> part;
            @Key
            private String onBehalfOfContentOwner;
            @Key
            private String onBehalfOfContentOwnerChannel;

            protected Insert(java.util.List<String> part, LiveStream content) {
                super(YouTube.this, "POST", REST_PATH, (Object)content, LiveStream.class);
                this.part = (java.util.List)Preconditions.checkNotNull(part, (Object)"Required parameter part must be specified.");
            }

            public Insert set$Xgafv(String $Xgafv) {
                return (Insert)super.set$Xgafv($Xgafv);
            }

            public Insert setAccessToken(String accessToken) {
                return (Insert)super.setAccessToken(accessToken);
            }

            public Insert setAlt(String alt) {
                return (Insert)super.setAlt(alt);
            }

            public Insert setCallback(String callback) {
                return (Insert)super.setCallback(callback);
            }

            public Insert setFields(String fields) {
                return (Insert)super.setFields(fields);
            }

            public Insert setKey(String key) {
                return (Insert)super.setKey(key);
            }

            public Insert setOauthToken(String oauthToken) {
                return (Insert)super.setOauthToken(oauthToken);
            }

            public Insert setPrettyPrint(Boolean prettyPrint) {
                return (Insert)super.setPrettyPrint(prettyPrint);
            }

            public Insert setQuotaUser(String quotaUser) {
                return (Insert)super.setQuotaUser(quotaUser);
            }

            public Insert setUploadType(String uploadType) {
                return (Insert)super.setUploadType(uploadType);
            }

            public Insert setUploadProtocol(String uploadProtocol) {
                return (Insert)super.setUploadProtocol(uploadProtocol);
            }

            public java.util.List<String> getPart() {
                return this.part;
            }

            public Insert setPart(java.util.List<String> part) {
                this.part = part;
                return this;
            }

            public String getOnBehalfOfContentOwner() {
                return this.onBehalfOfContentOwner;
            }

            public Insert setOnBehalfOfContentOwner(String onBehalfOfContentOwner) {
                this.onBehalfOfContentOwner = onBehalfOfContentOwner;
                return this;
            }

            public String getOnBehalfOfContentOwnerChannel() {
                return this.onBehalfOfContentOwnerChannel;
            }

            public Insert setOnBehalfOfContentOwnerChannel(String onBehalfOfContentOwnerChannel) {
                this.onBehalfOfContentOwnerChannel = onBehalfOfContentOwnerChannel;
                return this;
            }

            @Override
            public Insert set(String parameterName, Object value) {
                return (Insert)super.set(parameterName, value);
            }
        }

        public class Delete
        extends YouTubeRequest<Void> {
            private static final String REST_PATH = "youtube/v3/liveStreams";
            @Key
            private String id;
            @Key
            private String onBehalfOfContentOwner;
            @Key
            private String onBehalfOfContentOwnerChannel;

            protected Delete(String id) {
                super(YouTube.this, "DELETE", REST_PATH, null, Void.class);
                this.id = (String)Preconditions.checkNotNull((Object)id, (Object)"Required parameter id must be specified.");
            }

            public Delete set$Xgafv(String $Xgafv) {
                return (Delete)super.set$Xgafv($Xgafv);
            }

            public Delete setAccessToken(String accessToken) {
                return (Delete)super.setAccessToken(accessToken);
            }

            public Delete setAlt(String alt) {
                return (Delete)super.setAlt(alt);
            }

            public Delete setCallback(String callback) {
                return (Delete)super.setCallback(callback);
            }

            public Delete setFields(String fields) {
                return (Delete)super.setFields(fields);
            }

            public Delete setKey(String key) {
                return (Delete)super.setKey(key);
            }

            public Delete setOauthToken(String oauthToken) {
                return (Delete)super.setOauthToken(oauthToken);
            }

            public Delete setPrettyPrint(Boolean prettyPrint) {
                return (Delete)super.setPrettyPrint(prettyPrint);
            }

            public Delete setQuotaUser(String quotaUser) {
                return (Delete)super.setQuotaUser(quotaUser);
            }

            public Delete setUploadType(String uploadType) {
                return (Delete)super.setUploadType(uploadType);
            }

            public Delete setUploadProtocol(String uploadProtocol) {
                return (Delete)super.setUploadProtocol(uploadProtocol);
            }

            public String getId() {
                return this.id;
            }

            public Delete setId(String id) {
                this.id = id;
                return this;
            }

            public String getOnBehalfOfContentOwner() {
                return this.onBehalfOfContentOwner;
            }

            public Delete setOnBehalfOfContentOwner(String onBehalfOfContentOwner) {
                this.onBehalfOfContentOwner = onBehalfOfContentOwner;
                return this;
            }

            public String getOnBehalfOfContentOwnerChannel() {
                return this.onBehalfOfContentOwnerChannel;
            }

            public Delete setOnBehalfOfContentOwnerChannel(String onBehalfOfContentOwnerChannel) {
                this.onBehalfOfContentOwnerChannel = onBehalfOfContentOwnerChannel;
                return this;
            }

            @Override
            public Delete set(String parameterName, Object value) {
                return (Delete)super.set(parameterName, value);
            }
        }
    }

    public class LiveChatModerators {
        public Delete delete(String id) throws IOException {
            Delete result = new Delete(id);
            YouTube.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Insert insert(java.util.List<String> part, LiveChatModerator content) throws IOException {
            Insert result = new Insert(part, content);
            YouTube.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list(String liveChatId, java.util.List<String> part) throws IOException {
            List result = new List(liveChatId, part);
            YouTube.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class List
        extends YouTubeRequest<LiveChatModeratorListResponse> {
            private static final String REST_PATH = "youtube/v3/liveChat/moderators";
            @Key
            private String liveChatId;
            @Key
            private java.util.List<String> part;
            @Key
            private Long maxResults;
            @Key
            private String pageToken;

            protected List(String liveChatId, java.util.List<String> part) {
                super(YouTube.this, "GET", REST_PATH, null, LiveChatModeratorListResponse.class);
                this.liveChatId = (String)Preconditions.checkNotNull((Object)liveChatId, (Object)"Required parameter liveChatId must be specified.");
                this.part = (java.util.List)Preconditions.checkNotNull(part, (Object)"Required parameter part must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String $Xgafv) {
                return (List)super.set$Xgafv($Xgafv);
            }

            public List setAccessToken(String accessToken) {
                return (List)super.setAccessToken(accessToken);
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setCallback(String callback) {
                return (List)super.setCallback(callback);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUploadType(String uploadType) {
                return (List)super.setUploadType(uploadType);
            }

            public List setUploadProtocol(String uploadProtocol) {
                return (List)super.setUploadProtocol(uploadProtocol);
            }

            public String getLiveChatId() {
                return this.liveChatId;
            }

            public List setLiveChatId(String liveChatId) {
                this.liveChatId = liveChatId;
                return this;
            }

            public java.util.List<String> getPart() {
                return this.part;
            }

            public List setPart(java.util.List<String> part) {
                this.part = part;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long maxResults) {
                this.maxResults = maxResults;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class Insert
        extends YouTubeRequest<LiveChatModerator> {
            private static final String REST_PATH = "youtube/v3/liveChat/moderators";
            @Key
            private java.util.List<String> part;

            protected Insert(java.util.List<String> part, LiveChatModerator content) {
                super(YouTube.this, "POST", REST_PATH, (Object)content, LiveChatModerator.class);
                this.part = (java.util.List)Preconditions.checkNotNull(part, (Object)"Required parameter part must be specified.");
            }

            public Insert set$Xgafv(String $Xgafv) {
                return (Insert)super.set$Xgafv($Xgafv);
            }

            public Insert setAccessToken(String accessToken) {
                return (Insert)super.setAccessToken(accessToken);
            }

            public Insert setAlt(String alt) {
                return (Insert)super.setAlt(alt);
            }

            public Insert setCallback(String callback) {
                return (Insert)super.setCallback(callback);
            }

            public Insert setFields(String fields) {
                return (Insert)super.setFields(fields);
            }

            public Insert setKey(String key) {
                return (Insert)super.setKey(key);
            }

            public Insert setOauthToken(String oauthToken) {
                return (Insert)super.setOauthToken(oauthToken);
            }

            public Insert setPrettyPrint(Boolean prettyPrint) {
                return (Insert)super.setPrettyPrint(prettyPrint);
            }

            public Insert setQuotaUser(String quotaUser) {
                return (Insert)super.setQuotaUser(quotaUser);
            }

            public Insert setUploadType(String uploadType) {
                return (Insert)super.setUploadType(uploadType);
            }

            public Insert setUploadProtocol(String uploadProtocol) {
                return (Insert)super.setUploadProtocol(uploadProtocol);
            }

            public java.util.List<String> getPart() {
                return this.part;
            }

            public Insert setPart(java.util.List<String> part) {
                this.part = part;
                return this;
            }

            @Override
            public Insert set(String parameterName, Object value) {
                return (Insert)super.set(parameterName, value);
            }
        }

        public class Delete
        extends YouTubeRequest<Void> {
            private static final String REST_PATH = "youtube/v3/liveChat/moderators";
            @Key
            private String id;

            protected Delete(String id) {
                super(YouTube.this, "DELETE", REST_PATH, null, Void.class);
                this.id = (String)Preconditions.checkNotNull((Object)id, (Object)"Required parameter id must be specified.");
            }

            public Delete set$Xgafv(String $Xgafv) {
                return (Delete)super.set$Xgafv($Xgafv);
            }

            public Delete setAccessToken(String accessToken) {
                return (Delete)super.setAccessToken(accessToken);
            }

            public Delete setAlt(String alt) {
                return (Delete)super.setAlt(alt);
            }

            public Delete setCallback(String callback) {
                return (Delete)super.setCallback(callback);
            }

            public Delete setFields(String fields) {
                return (Delete)super.setFields(fields);
            }

            public Delete setKey(String key) {
                return (Delete)super.setKey(key);
            }

            public Delete setOauthToken(String oauthToken) {
                return (Delete)super.setOauthToken(oauthToken);
            }

            public Delete setPrettyPrint(Boolean prettyPrint) {
                return (Delete)super.setPrettyPrint(prettyPrint);
            }

            public Delete setQuotaUser(String quotaUser) {
                return (Delete)super.setQuotaUser(quotaUser);
            }

            public Delete setUploadType(String uploadType) {
                return (Delete)super.setUploadType(uploadType);
            }

            public Delete setUploadProtocol(String uploadProtocol) {
                return (Delete)super.setUploadProtocol(uploadProtocol);
            }

            public String getId() {
                return this.id;
            }

            public Delete setId(String id) {
                this.id = id;
                return this;
            }

            @Override
            public Delete set(String parameterName, Object value) {
                return (Delete)super.set(parameterName, value);
            }
        }
    }

    public class LiveChatMessages {
        public Delete delete(String id) throws IOException {
            Delete result = new Delete(id);
            YouTube.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Insert insert(java.util.List<String> part, LiveChatMessage content) throws IOException {
            Insert result = new Insert(part, content);
            YouTube.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list(String liveChatId, java.util.List<String> part) throws IOException {
            List result = new List(liveChatId, part);
            YouTube.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Transition transition() throws IOException {
            Transition result = new Transition();
            YouTube.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class Transition
        extends YouTubeRequest<LiveChatMessage> {
            private static final String REST_PATH = "youtube/v3/liveChat/messages/transition";
            @Key
            private String id;
            @Key
            private String status;

            protected Transition() {
                super(YouTube.this, "POST", REST_PATH, null, LiveChatMessage.class);
            }

            public Transition set$Xgafv(String $Xgafv) {
                return (Transition)super.set$Xgafv($Xgafv);
            }

            public Transition setAccessToken(String accessToken) {
                return (Transition)super.setAccessToken(accessToken);
            }

            public Transition setAlt(String alt) {
                return (Transition)super.setAlt(alt);
            }

            public Transition setCallback(String callback) {
                return (Transition)super.setCallback(callback);
            }

            public Transition setFields(String fields) {
                return (Transition)super.setFields(fields);
            }

            public Transition setKey(String key) {
                return (Transition)super.setKey(key);
            }

            public Transition setOauthToken(String oauthToken) {
                return (Transition)super.setOauthToken(oauthToken);
            }

            public Transition setPrettyPrint(Boolean prettyPrint) {
                return (Transition)super.setPrettyPrint(prettyPrint);
            }

            public Transition setQuotaUser(String quotaUser) {
                return (Transition)super.setQuotaUser(quotaUser);
            }

            public Transition setUploadType(String uploadType) {
                return (Transition)super.setUploadType(uploadType);
            }

            public Transition setUploadProtocol(String uploadProtocol) {
                return (Transition)super.setUploadProtocol(uploadProtocol);
            }

            public String getId() {
                return this.id;
            }

            public Transition setId(String id) {
                this.id = id;
                return this;
            }

            public String getStatus() {
                return this.status;
            }

            public Transition setStatus(String status) {
                this.status = status;
                return this;
            }

            @Override
            public Transition set(String parameterName, Object value) {
                return (Transition)super.set(parameterName, value);
            }
        }

        public class List
        extends YouTubeRequest<LiveChatMessageListResponse> {
            private static final String REST_PATH = "youtube/v3/liveChat/messages";
            @Key
            private String liveChatId;
            @Key
            private java.util.List<String> part;
            @Key
            private String hl;
            @Key
            private Long maxResults;
            @Key
            private String pageToken;
            @Key
            private Long profileImageSize;

            protected List(String liveChatId, java.util.List<String> part) {
                super(YouTube.this, "GET", REST_PATH, null, LiveChatMessageListResponse.class);
                this.liveChatId = (String)Preconditions.checkNotNull((Object)liveChatId, (Object)"Required parameter liveChatId must be specified.");
                this.part = (java.util.List)Preconditions.checkNotNull(part, (Object)"Required parameter part must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String $Xgafv) {
                return (List)super.set$Xgafv($Xgafv);
            }

            public List setAccessToken(String accessToken) {
                return (List)super.setAccessToken(accessToken);
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setCallback(String callback) {
                return (List)super.setCallback(callback);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUploadType(String uploadType) {
                return (List)super.setUploadType(uploadType);
            }

            public List setUploadProtocol(String uploadProtocol) {
                return (List)super.setUploadProtocol(uploadProtocol);
            }

            public String getLiveChatId() {
                return this.liveChatId;
            }

            public List setLiveChatId(String liveChatId) {
                this.liveChatId = liveChatId;
                return this;
            }

            public java.util.List<String> getPart() {
                return this.part;
            }

            public List setPart(java.util.List<String> part) {
                this.part = part;
                return this;
            }

            public String getHl() {
                return this.hl;
            }

            public List setHl(String hl) {
                this.hl = hl;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long maxResults) {
                this.maxResults = maxResults;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            public Long getProfileImageSize() {
                return this.profileImageSize;
            }

            public List setProfileImageSize(Long profileImageSize) {
                this.profileImageSize = profileImageSize;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class Insert
        extends YouTubeRequest<LiveChatMessage> {
            private static final String REST_PATH = "youtube/v3/liveChat/messages";
            @Key
            private java.util.List<String> part;

            protected Insert(java.util.List<String> part, LiveChatMessage content) {
                super(YouTube.this, "POST", REST_PATH, (Object)content, LiveChatMessage.class);
                this.part = (java.util.List)Preconditions.checkNotNull(part, (Object)"Required parameter part must be specified.");
            }

            public Insert set$Xgafv(String $Xgafv) {
                return (Insert)super.set$Xgafv($Xgafv);
            }

            public Insert setAccessToken(String accessToken) {
                return (Insert)super.setAccessToken(accessToken);
            }

            public Insert setAlt(String alt) {
                return (Insert)super.setAlt(alt);
            }

            public Insert setCallback(String callback) {
                return (Insert)super.setCallback(callback);
            }

            public Insert setFields(String fields) {
                return (Insert)super.setFields(fields);
            }

            public Insert setKey(String key) {
                return (Insert)super.setKey(key);
            }

            public Insert setOauthToken(String oauthToken) {
                return (Insert)super.setOauthToken(oauthToken);
            }

            public Insert setPrettyPrint(Boolean prettyPrint) {
                return (Insert)super.setPrettyPrint(prettyPrint);
            }

            public Insert setQuotaUser(String quotaUser) {
                return (Insert)super.setQuotaUser(quotaUser);
            }

            public Insert setUploadType(String uploadType) {
                return (Insert)super.setUploadType(uploadType);
            }

            public Insert setUploadProtocol(String uploadProtocol) {
                return (Insert)super.setUploadProtocol(uploadProtocol);
            }

            public java.util.List<String> getPart() {
                return this.part;
            }

            public Insert setPart(java.util.List<String> part) {
                this.part = part;
                return this;
            }

            @Override
            public Insert set(String parameterName, Object value) {
                return (Insert)super.set(parameterName, value);
            }
        }

        public class Delete
        extends YouTubeRequest<Void> {
            private static final String REST_PATH = "youtube/v3/liveChat/messages";
            @Key
            private String id;

            protected Delete(String id) {
                super(YouTube.this, "DELETE", REST_PATH, null, Void.class);
                this.id = (String)Preconditions.checkNotNull((Object)id, (Object)"Required parameter id must be specified.");
            }

            public Delete set$Xgafv(String $Xgafv) {
                return (Delete)super.set$Xgafv($Xgafv);
            }

            public Delete setAccessToken(String accessToken) {
                return (Delete)super.setAccessToken(accessToken);
            }

            public Delete setAlt(String alt) {
                return (Delete)super.setAlt(alt);
            }

            public Delete setCallback(String callback) {
                return (Delete)super.setCallback(callback);
            }

            public Delete setFields(String fields) {
                return (Delete)super.setFields(fields);
            }

            public Delete setKey(String key) {
                return (Delete)super.setKey(key);
            }

            public Delete setOauthToken(String oauthToken) {
                return (Delete)super.setOauthToken(oauthToken);
            }

            public Delete setPrettyPrint(Boolean prettyPrint) {
                return (Delete)super.setPrettyPrint(prettyPrint);
            }

            public Delete setQuotaUser(String quotaUser) {
                return (Delete)super.setQuotaUser(quotaUser);
            }

            public Delete setUploadType(String uploadType) {
                return (Delete)super.setUploadType(uploadType);
            }

            public Delete setUploadProtocol(String uploadProtocol) {
                return (Delete)super.setUploadProtocol(uploadProtocol);
            }

            public String getId() {
                return this.id;
            }

            public Delete setId(String id) {
                this.id = id;
                return this;
            }

            @Override
            public Delete set(String parameterName, Object value) {
                return (Delete)super.set(parameterName, value);
            }
        }
    }

    public class LiveChatBans {
        public Delete delete(String id) throws IOException {
            Delete result = new Delete(id);
            YouTube.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Insert insert(List<String> part, LiveChatBan content) throws IOException {
            Insert result = new Insert(part, content);
            YouTube.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class Insert
        extends YouTubeRequest<LiveChatBan> {
            private static final String REST_PATH = "youtube/v3/liveChat/bans";
            @Key
            private List<String> part;

            protected Insert(List<String> part, LiveChatBan content) {
                super(YouTube.this, "POST", REST_PATH, (Object)content, LiveChatBan.class);
                this.part = (List)Preconditions.checkNotNull(part, (Object)"Required parameter part must be specified.");
            }

            public Insert set$Xgafv(String $Xgafv) {
                return (Insert)super.set$Xgafv($Xgafv);
            }

            public Insert setAccessToken(String accessToken) {
                return (Insert)super.setAccessToken(accessToken);
            }

            public Insert setAlt(String alt) {
                return (Insert)super.setAlt(alt);
            }

            public Insert setCallback(String callback) {
                return (Insert)super.setCallback(callback);
            }

            public Insert setFields(String fields) {
                return (Insert)super.setFields(fields);
            }

            public Insert setKey(String key) {
                return (Insert)super.setKey(key);
            }

            public Insert setOauthToken(String oauthToken) {
                return (Insert)super.setOauthToken(oauthToken);
            }

            public Insert setPrettyPrint(Boolean prettyPrint) {
                return (Insert)super.setPrettyPrint(prettyPrint);
            }

            public Insert setQuotaUser(String quotaUser) {
                return (Insert)super.setQuotaUser(quotaUser);
            }

            public Insert setUploadType(String uploadType) {
                return (Insert)super.setUploadType(uploadType);
            }

            public Insert setUploadProtocol(String uploadProtocol) {
                return (Insert)super.setUploadProtocol(uploadProtocol);
            }

            public List<String> getPart() {
                return this.part;
            }

            public Insert setPart(List<String> part) {
                this.part = part;
                return this;
            }

            @Override
            public Insert set(String parameterName, Object value) {
                return (Insert)super.set(parameterName, value);
            }
        }

        public class Delete
        extends YouTubeRequest<Void> {
            private static final String REST_PATH = "youtube/v3/liveChat/bans";
            @Key
            private String id;

            protected Delete(String id) {
                super(YouTube.this, "DELETE", REST_PATH, null, Void.class);
                this.id = (String)Preconditions.checkNotNull((Object)id, (Object)"Required parameter id must be specified.");
            }

            public Delete set$Xgafv(String $Xgafv) {
                return (Delete)super.set$Xgafv($Xgafv);
            }

            public Delete setAccessToken(String accessToken) {
                return (Delete)super.setAccessToken(accessToken);
            }

            public Delete setAlt(String alt) {
                return (Delete)super.setAlt(alt);
            }

            public Delete setCallback(String callback) {
                return (Delete)super.setCallback(callback);
            }

            public Delete setFields(String fields) {
                return (Delete)super.setFields(fields);
            }

            public Delete setKey(String key) {
                return (Delete)super.setKey(key);
            }

            public Delete setOauthToken(String oauthToken) {
                return (Delete)super.setOauthToken(oauthToken);
            }

            public Delete setPrettyPrint(Boolean prettyPrint) {
                return (Delete)super.setPrettyPrint(prettyPrint);
            }

            public Delete setQuotaUser(String quotaUser) {
                return (Delete)super.setQuotaUser(quotaUser);
            }

            public Delete setUploadType(String uploadType) {
                return (Delete)super.setUploadType(uploadType);
            }

            public Delete setUploadProtocol(String uploadProtocol) {
                return (Delete)super.setUploadProtocol(uploadProtocol);
            }

            public String getId() {
                return this.id;
            }

            public Delete setId(String id) {
                this.id = id;
                return this;
            }

            @Override
            public Delete set(String parameterName, Object value) {
                return (Delete)super.set(parameterName, value);
            }
        }
    }

    public class LiveBroadcasts {
        public Bind bind(String id, java.util.List<String> part) throws IOException {
            Bind result = new Bind(id, part);
            YouTube.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Delete delete(String id) throws IOException {
            Delete result = new Delete(id);
            YouTube.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Insert insert(java.util.List<String> part, LiveBroadcast content) throws IOException {
            Insert result = new Insert(part, content);
            YouTube.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public InsertCuepoint insertCuepoint(Cuepoint content) throws IOException {
            InsertCuepoint result = new InsertCuepoint(content);
            YouTube.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list(java.util.List<String> part) throws IOException {
            List result = new List(part);
            YouTube.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Transition transition(String broadcastStatus, String id, java.util.List<String> part) throws IOException {
            Transition result = new Transition(broadcastStatus, id, part);
            YouTube.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Update update(java.util.List<String> part, LiveBroadcast content) throws IOException {
            Update result = new Update(part, content);
            YouTube.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class Update
        extends YouTubeRequest<LiveBroadcast> {
            private static final String REST_PATH = "youtube/v3/liveBroadcasts";
            @Key
            private java.util.List<String> part;
            @Key
            private String onBehalfOfContentOwner;
            @Key
            private String onBehalfOfContentOwnerChannel;

            protected Update(java.util.List<String> part, LiveBroadcast content) {
                super(YouTube.this, "PUT", REST_PATH, (Object)content, LiveBroadcast.class);
                this.part = (java.util.List)Preconditions.checkNotNull(part, (Object)"Required parameter part must be specified.");
                this.checkRequiredParameter((Object)content, "content");
                this.checkRequiredParameter(content.getId(), "LiveBroadcast.getId()");
            }

            public Update set$Xgafv(String $Xgafv) {
                return (Update)super.set$Xgafv($Xgafv);
            }

            public Update setAccessToken(String accessToken) {
                return (Update)super.setAccessToken(accessToken);
            }

            public Update setAlt(String alt) {
                return (Update)super.setAlt(alt);
            }

            public Update setCallback(String callback) {
                return (Update)super.setCallback(callback);
            }

            public Update setFields(String fields) {
                return (Update)super.setFields(fields);
            }

            public Update setKey(String key) {
                return (Update)super.setKey(key);
            }

            public Update setOauthToken(String oauthToken) {
                return (Update)super.setOauthToken(oauthToken);
            }

            public Update setPrettyPrint(Boolean prettyPrint) {
                return (Update)super.setPrettyPrint(prettyPrint);
            }

            public Update setQuotaUser(String quotaUser) {
                return (Update)super.setQuotaUser(quotaUser);
            }

            public Update setUploadType(String uploadType) {
                return (Update)super.setUploadType(uploadType);
            }

            public Update setUploadProtocol(String uploadProtocol) {
                return (Update)super.setUploadProtocol(uploadProtocol);
            }

            public java.util.List<String> getPart() {
                return this.part;
            }

            public Update setPart(java.util.List<String> part) {
                this.part = part;
                return this;
            }

            public String getOnBehalfOfContentOwner() {
                return this.onBehalfOfContentOwner;
            }

            public Update setOnBehalfOfContentOwner(String onBehalfOfContentOwner) {
                this.onBehalfOfContentOwner = onBehalfOfContentOwner;
                return this;
            }

            public String getOnBehalfOfContentOwnerChannel() {
                return this.onBehalfOfContentOwnerChannel;
            }

            public Update setOnBehalfOfContentOwnerChannel(String onBehalfOfContentOwnerChannel) {
                this.onBehalfOfContentOwnerChannel = onBehalfOfContentOwnerChannel;
                return this;
            }

            @Override
            public Update set(String parameterName, Object value) {
                return (Update)super.set(parameterName, value);
            }
        }

        public class Transition
        extends YouTubeRequest<LiveBroadcast> {
            private static final String REST_PATH = "youtube/v3/liveBroadcasts/transition";
            @Key
            private String broadcastStatus;
            @Key
            private String id;
            @Key
            private java.util.List<String> part;
            @Key
            private String onBehalfOfContentOwner;
            @Key
            private String onBehalfOfContentOwnerChannel;

            protected Transition(String broadcastStatus, String id, java.util.List<String> part) {
                super(YouTube.this, "POST", REST_PATH, null, LiveBroadcast.class);
                this.broadcastStatus = (String)Preconditions.checkNotNull((Object)broadcastStatus, (Object)"Required parameter broadcastStatus must be specified.");
                this.id = (String)Preconditions.checkNotNull((Object)id, (Object)"Required parameter id must be specified.");
                this.part = (java.util.List)Preconditions.checkNotNull(part, (Object)"Required parameter part must be specified.");
            }

            public Transition set$Xgafv(String $Xgafv) {
                return (Transition)super.set$Xgafv($Xgafv);
            }

            public Transition setAccessToken(String accessToken) {
                return (Transition)super.setAccessToken(accessToken);
            }

            public Transition setAlt(String alt) {
                return (Transition)super.setAlt(alt);
            }

            public Transition setCallback(String callback) {
                return (Transition)super.setCallback(callback);
            }

            public Transition setFields(String fields) {
                return (Transition)super.setFields(fields);
            }

            public Transition setKey(String key) {
                return (Transition)super.setKey(key);
            }

            public Transition setOauthToken(String oauthToken) {
                return (Transition)super.setOauthToken(oauthToken);
            }

            public Transition setPrettyPrint(Boolean prettyPrint) {
                return (Transition)super.setPrettyPrint(prettyPrint);
            }

            public Transition setQuotaUser(String quotaUser) {
                return (Transition)super.setQuotaUser(quotaUser);
            }

            public Transition setUploadType(String uploadType) {
                return (Transition)super.setUploadType(uploadType);
            }

            public Transition setUploadProtocol(String uploadProtocol) {
                return (Transition)super.setUploadProtocol(uploadProtocol);
            }

            public String getBroadcastStatus() {
                return this.broadcastStatus;
            }

            public Transition setBroadcastStatus(String broadcastStatus) {
                this.broadcastStatus = broadcastStatus;
                return this;
            }

            public String getId() {
                return this.id;
            }

            public Transition setId(String id) {
                this.id = id;
                return this;
            }

            public java.util.List<String> getPart() {
                return this.part;
            }

            public Transition setPart(java.util.List<String> part) {
                this.part = part;
                return this;
            }

            public String getOnBehalfOfContentOwner() {
                return this.onBehalfOfContentOwner;
            }

            public Transition setOnBehalfOfContentOwner(String onBehalfOfContentOwner) {
                this.onBehalfOfContentOwner = onBehalfOfContentOwner;
                return this;
            }

            public String getOnBehalfOfContentOwnerChannel() {
                return this.onBehalfOfContentOwnerChannel;
            }

            public Transition setOnBehalfOfContentOwnerChannel(String onBehalfOfContentOwnerChannel) {
                this.onBehalfOfContentOwnerChannel = onBehalfOfContentOwnerChannel;
                return this;
            }

            @Override
            public Transition set(String parameterName, Object value) {
                return (Transition)super.set(parameterName, value);
            }
        }

        public class List
        extends YouTubeRequest<LiveBroadcastListResponse> {
            private static final String REST_PATH = "youtube/v3/liveBroadcasts";
            @Key
            private java.util.List<String> part;
            @Key
            private String broadcastStatus;
            @Key
            private String broadcastType;
            @Key
            private java.util.List<String> id;
            @Key
            private Long maxResults;
            @Key
            private Boolean mine;
            @Key
            private String onBehalfOfContentOwner;
            @Key
            private String onBehalfOfContentOwnerChannel;
            @Key
            private String pageToken;

            protected List(java.util.List<String> part) {
                super(YouTube.this, "GET", REST_PATH, null, LiveBroadcastListResponse.class);
                this.part = (java.util.List)Preconditions.checkNotNull(part, (Object)"Required parameter part must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String $Xgafv) {
                return (List)super.set$Xgafv($Xgafv);
            }

            public List setAccessToken(String accessToken) {
                return (List)super.setAccessToken(accessToken);
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setCallback(String callback) {
                return (List)super.setCallback(callback);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUploadType(String uploadType) {
                return (List)super.setUploadType(uploadType);
            }

            public List setUploadProtocol(String uploadProtocol) {
                return (List)super.setUploadProtocol(uploadProtocol);
            }

            public java.util.List<String> getPart() {
                return this.part;
            }

            public List setPart(java.util.List<String> part) {
                this.part = part;
                return this;
            }

            public String getBroadcastStatus() {
                return this.broadcastStatus;
            }

            public List setBroadcastStatus(String broadcastStatus) {
                this.broadcastStatus = broadcastStatus;
                return this;
            }

            public String getBroadcastType() {
                return this.broadcastType;
            }

            public List setBroadcastType(String broadcastType) {
                this.broadcastType = broadcastType;
                return this;
            }

            public java.util.List<String> getId() {
                return this.id;
            }

            public List setId(java.util.List<String> id) {
                this.id = id;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long maxResults) {
                this.maxResults = maxResults;
                return this;
            }

            public Boolean getMine() {
                return this.mine;
            }

            public List setMine(Boolean mine) {
                this.mine = mine;
                return this;
            }

            public String getOnBehalfOfContentOwner() {
                return this.onBehalfOfContentOwner;
            }

            public List setOnBehalfOfContentOwner(String onBehalfOfContentOwner) {
                this.onBehalfOfContentOwner = onBehalfOfContentOwner;
                return this;
            }

            public String getOnBehalfOfContentOwnerChannel() {
                return this.onBehalfOfContentOwnerChannel;
            }

            public List setOnBehalfOfContentOwnerChannel(String onBehalfOfContentOwnerChannel) {
                this.onBehalfOfContentOwnerChannel = onBehalfOfContentOwnerChannel;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class InsertCuepoint
        extends YouTubeRequest<Cuepoint> {
            private static final String REST_PATH = "youtube/v3/liveBroadcasts/cuepoint";
            @Key
            private String id;
            @Key
            private String onBehalfOfContentOwner;
            @Key
            private String onBehalfOfContentOwnerChannel;
            @Key
            private java.util.List<String> part;

            protected InsertCuepoint(Cuepoint content) {
                super(YouTube.this, "POST", REST_PATH, (Object)content, Cuepoint.class);
            }

            public InsertCuepoint set$Xgafv(String $Xgafv) {
                return (InsertCuepoint)super.set$Xgafv($Xgafv);
            }

            public InsertCuepoint setAccessToken(String accessToken) {
                return (InsertCuepoint)super.setAccessToken(accessToken);
            }

            public InsertCuepoint setAlt(String alt) {
                return (InsertCuepoint)super.setAlt(alt);
            }

            public InsertCuepoint setCallback(String callback) {
                return (InsertCuepoint)super.setCallback(callback);
            }

            public InsertCuepoint setFields(String fields) {
                return (InsertCuepoint)super.setFields(fields);
            }

            public InsertCuepoint setKey(String key) {
                return (InsertCuepoint)super.setKey(key);
            }

            public InsertCuepoint setOauthToken(String oauthToken) {
                return (InsertCuepoint)super.setOauthToken(oauthToken);
            }

            public InsertCuepoint setPrettyPrint(Boolean prettyPrint) {
                return (InsertCuepoint)super.setPrettyPrint(prettyPrint);
            }

            public InsertCuepoint setQuotaUser(String quotaUser) {
                return (InsertCuepoint)super.setQuotaUser(quotaUser);
            }

            public InsertCuepoint setUploadType(String uploadType) {
                return (InsertCuepoint)super.setUploadType(uploadType);
            }

            public InsertCuepoint setUploadProtocol(String uploadProtocol) {
                return (InsertCuepoint)super.setUploadProtocol(uploadProtocol);
            }

            public String getId() {
                return this.id;
            }

            public InsertCuepoint setId(String id) {
                this.id = id;
                return this;
            }

            public String getOnBehalfOfContentOwner() {
                return this.onBehalfOfContentOwner;
            }

            public InsertCuepoint setOnBehalfOfContentOwner(String onBehalfOfContentOwner) {
                this.onBehalfOfContentOwner = onBehalfOfContentOwner;
                return this;
            }

            public String getOnBehalfOfContentOwnerChannel() {
                return this.onBehalfOfContentOwnerChannel;
            }

            public InsertCuepoint setOnBehalfOfContentOwnerChannel(String onBehalfOfContentOwnerChannel) {
                this.onBehalfOfContentOwnerChannel = onBehalfOfContentOwnerChannel;
                return this;
            }

            public java.util.List<String> getPart() {
                return this.part;
            }

            public InsertCuepoint setPart(java.util.List<String> part) {
                this.part = part;
                return this;
            }

            @Override
            public InsertCuepoint set(String parameterName, Object value) {
                return (InsertCuepoint)super.set(parameterName, value);
            }
        }

        public class Insert
        extends YouTubeRequest<LiveBroadcast> {
            private static final String REST_PATH = "youtube/v3/liveBroadcasts";
            @Key
            private java.util.List<String> part;
            @Key
            private String onBehalfOfContentOwner;
            @Key
            private String onBehalfOfContentOwnerChannel;

            protected Insert(java.util.List<String> part, LiveBroadcast content) {
                super(YouTube.this, "POST", REST_PATH, (Object)content, LiveBroadcast.class);
                this.part = (java.util.List)Preconditions.checkNotNull(part, (Object)"Required parameter part must be specified.");
            }

            public Insert set$Xgafv(String $Xgafv) {
                return (Insert)super.set$Xgafv($Xgafv);
            }

            public Insert setAccessToken(String accessToken) {
                return (Insert)super.setAccessToken(accessToken);
            }

            public Insert setAlt(String alt) {
                return (Insert)super.setAlt(alt);
            }

            public Insert setCallback(String callback) {
                return (Insert)super.setCallback(callback);
            }

            public Insert setFields(String fields) {
                return (Insert)super.setFields(fields);
            }

            public Insert setKey(String key) {
                return (Insert)super.setKey(key);
            }

            public Insert setOauthToken(String oauthToken) {
                return (Insert)super.setOauthToken(oauthToken);
            }

            public Insert setPrettyPrint(Boolean prettyPrint) {
                return (Insert)super.setPrettyPrint(prettyPrint);
            }

            public Insert setQuotaUser(String quotaUser) {
                return (Insert)super.setQuotaUser(quotaUser);
            }

            public Insert setUploadType(String uploadType) {
                return (Insert)super.setUploadType(uploadType);
            }

            public Insert setUploadProtocol(String uploadProtocol) {
                return (Insert)super.setUploadProtocol(uploadProtocol);
            }

            public java.util.List<String> getPart() {
                return this.part;
            }

            public Insert setPart(java.util.List<String> part) {
                this.part = part;
                return this;
            }

            public String getOnBehalfOfContentOwner() {
                return this.onBehalfOfContentOwner;
            }

            public Insert setOnBehalfOfContentOwner(String onBehalfOfContentOwner) {
                this.onBehalfOfContentOwner = onBehalfOfContentOwner;
                return this;
            }

            public String getOnBehalfOfContentOwnerChannel() {
                return this.onBehalfOfContentOwnerChannel;
            }

            public Insert setOnBehalfOfContentOwnerChannel(String onBehalfOfContentOwnerChannel) {
                this.onBehalfOfContentOwnerChannel = onBehalfOfContentOwnerChannel;
                return this;
            }

            @Override
            public Insert set(String parameterName, Object value) {
                return (Insert)super.set(parameterName, value);
            }
        }

        public class Delete
        extends YouTubeRequest<Void> {
            private static final String REST_PATH = "youtube/v3/liveBroadcasts";
            @Key
            private String id;
            @Key
            private String onBehalfOfContentOwner;
            @Key
            private String onBehalfOfContentOwnerChannel;

            protected Delete(String id) {
                super(YouTube.this, "DELETE", REST_PATH, null, Void.class);
                this.id = (String)Preconditions.checkNotNull((Object)id, (Object)"Required parameter id must be specified.");
            }

            public Delete set$Xgafv(String $Xgafv) {
                return (Delete)super.set$Xgafv($Xgafv);
            }

            public Delete setAccessToken(String accessToken) {
                return (Delete)super.setAccessToken(accessToken);
            }

            public Delete setAlt(String alt) {
                return (Delete)super.setAlt(alt);
            }

            public Delete setCallback(String callback) {
                return (Delete)super.setCallback(callback);
            }

            public Delete setFields(String fields) {
                return (Delete)super.setFields(fields);
            }

            public Delete setKey(String key) {
                return (Delete)super.setKey(key);
            }

            public Delete setOauthToken(String oauthToken) {
                return (Delete)super.setOauthToken(oauthToken);
            }

            public Delete setPrettyPrint(Boolean prettyPrint) {
                return (Delete)super.setPrettyPrint(prettyPrint);
            }

            public Delete setQuotaUser(String quotaUser) {
                return (Delete)super.setQuotaUser(quotaUser);
            }

            public Delete setUploadType(String uploadType) {
                return (Delete)super.setUploadType(uploadType);
            }

            public Delete setUploadProtocol(String uploadProtocol) {
                return (Delete)super.setUploadProtocol(uploadProtocol);
            }

            public String getId() {
                return this.id;
            }

            public Delete setId(String id) {
                this.id = id;
                return this;
            }

            public String getOnBehalfOfContentOwner() {
                return this.onBehalfOfContentOwner;
            }

            public Delete setOnBehalfOfContentOwner(String onBehalfOfContentOwner) {
                this.onBehalfOfContentOwner = onBehalfOfContentOwner;
                return this;
            }

            public String getOnBehalfOfContentOwnerChannel() {
                return this.onBehalfOfContentOwnerChannel;
            }

            public Delete setOnBehalfOfContentOwnerChannel(String onBehalfOfContentOwnerChannel) {
                this.onBehalfOfContentOwnerChannel = onBehalfOfContentOwnerChannel;
                return this;
            }

            @Override
            public Delete set(String parameterName, Object value) {
                return (Delete)super.set(parameterName, value);
            }
        }

        public class Bind
        extends YouTubeRequest<LiveBroadcast> {
            private static final String REST_PATH = "youtube/v3/liveBroadcasts/bind";
            @Key
            private String id;
            @Key
            private java.util.List<String> part;
            @Key
            private String onBehalfOfContentOwner;
            @Key
            private String onBehalfOfContentOwnerChannel;
            @Key
            private String streamId;

            protected Bind(String id, java.util.List<String> part) {
                super(YouTube.this, "POST", REST_PATH, null, LiveBroadcast.class);
                this.id = (String)Preconditions.checkNotNull((Object)id, (Object)"Required parameter id must be specified.");
                this.part = (java.util.List)Preconditions.checkNotNull(part, (Object)"Required parameter part must be specified.");
            }

            public Bind set$Xgafv(String $Xgafv) {
                return (Bind)super.set$Xgafv($Xgafv);
            }

            public Bind setAccessToken(String accessToken) {
                return (Bind)super.setAccessToken(accessToken);
            }

            public Bind setAlt(String alt) {
                return (Bind)super.setAlt(alt);
            }

            public Bind setCallback(String callback) {
                return (Bind)super.setCallback(callback);
            }

            public Bind setFields(String fields) {
                return (Bind)super.setFields(fields);
            }

            public Bind setKey(String key) {
                return (Bind)super.setKey(key);
            }

            public Bind setOauthToken(String oauthToken) {
                return (Bind)super.setOauthToken(oauthToken);
            }

            public Bind setPrettyPrint(Boolean prettyPrint) {
                return (Bind)super.setPrettyPrint(prettyPrint);
            }

            public Bind setQuotaUser(String quotaUser) {
                return (Bind)super.setQuotaUser(quotaUser);
            }

            public Bind setUploadType(String uploadType) {
                return (Bind)super.setUploadType(uploadType);
            }

            public Bind setUploadProtocol(String uploadProtocol) {
                return (Bind)super.setUploadProtocol(uploadProtocol);
            }

            public String getId() {
                return this.id;
            }

            public Bind setId(String id) {
                this.id = id;
                return this;
            }

            public java.util.List<String> getPart() {
                return this.part;
            }

            public Bind setPart(java.util.List<String> part) {
                this.part = part;
                return this;
            }

            public String getOnBehalfOfContentOwner() {
                return this.onBehalfOfContentOwner;
            }

            public Bind setOnBehalfOfContentOwner(String onBehalfOfContentOwner) {
                this.onBehalfOfContentOwner = onBehalfOfContentOwner;
                return this;
            }

            public String getOnBehalfOfContentOwnerChannel() {
                return this.onBehalfOfContentOwnerChannel;
            }

            public Bind setOnBehalfOfContentOwnerChannel(String onBehalfOfContentOwnerChannel) {
                this.onBehalfOfContentOwnerChannel = onBehalfOfContentOwnerChannel;
                return this;
            }

            public String getStreamId() {
                return this.streamId;
            }

            public Bind setStreamId(String streamId) {
                this.streamId = streamId;
                return this;
            }

            @Override
            public Bind set(String parameterName, Object value) {
                return (Bind)super.set(parameterName, value);
            }
        }
    }

    public class I18nRegions {
        public List list(java.util.List<String> part) throws IOException {
            List result = new List(part);
            YouTube.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class List
        extends YouTubeRequest<I18nRegionListResponse> {
            private static final String REST_PATH = "youtube/v3/i18nRegions";
            @Key
            private java.util.List<String> part;
            @Key
            private String hl;

            protected List(java.util.List<String> part) {
                super(YouTube.this, "GET", REST_PATH, null, I18nRegionListResponse.class);
                this.part = (java.util.List)Preconditions.checkNotNull(part, (Object)"Required parameter part must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String $Xgafv) {
                return (List)super.set$Xgafv($Xgafv);
            }

            public List setAccessToken(String accessToken) {
                return (List)super.setAccessToken(accessToken);
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setCallback(String callback) {
                return (List)super.setCallback(callback);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUploadType(String uploadType) {
                return (List)super.setUploadType(uploadType);
            }

            public List setUploadProtocol(String uploadProtocol) {
                return (List)super.setUploadProtocol(uploadProtocol);
            }

            public java.util.List<String> getPart() {
                return this.part;
            }

            public List setPart(java.util.List<String> part) {
                this.part = part;
                return this;
            }

            public String getHl() {
                return this.hl;
            }

            public List setHl(String hl) {
                this.hl = hl;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }
    }

    public class I18nLanguages {
        public List list(java.util.List<String> part) throws IOException {
            List result = new List(part);
            YouTube.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class List
        extends YouTubeRequest<I18nLanguageListResponse> {
            private static final String REST_PATH = "youtube/v3/i18nLanguages";
            @Key
            private java.util.List<String> part;
            @Key
            private String hl;

            protected List(java.util.List<String> part) {
                super(YouTube.this, "GET", REST_PATH, null, I18nLanguageListResponse.class);
                this.part = (java.util.List)Preconditions.checkNotNull(part, (Object)"Required parameter part must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String $Xgafv) {
                return (List)super.set$Xgafv($Xgafv);
            }

            public List setAccessToken(String accessToken) {
                return (List)super.setAccessToken(accessToken);
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setCallback(String callback) {
                return (List)super.setCallback(callback);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUploadType(String uploadType) {
                return (List)super.setUploadType(uploadType);
            }

            public List setUploadProtocol(String uploadProtocol) {
                return (List)super.setUploadProtocol(uploadProtocol);
            }

            public java.util.List<String> getPart() {
                return this.part;
            }

            public List setPart(java.util.List<String> part) {
                this.part = part;
                return this;
            }

            public String getHl() {
                return this.hl;
            }

            public List setHl(String hl) {
                this.hl = hl;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }
    }

    public class Comments {
        public Delete delete(String id) throws IOException {
            Delete result = new Delete(id);
            YouTube.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Insert insert(java.util.List<String> part, Comment content) throws IOException {
            Insert result = new Insert(part, content);
            YouTube.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list(java.util.List<String> part) throws IOException {
            List result = new List(part);
            YouTube.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public MarkAsSpam markAsSpam(java.util.List<String> id) throws IOException {
            MarkAsSpam result = new MarkAsSpam(id);
            YouTube.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public SetModerationStatus setModerationStatus(java.util.List<String> id, String moderationStatus) throws IOException {
            SetModerationStatus result = new SetModerationStatus(id, moderationStatus);
            YouTube.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Update update(java.util.List<String> part, Comment content) throws IOException {
            Update result = new Update(part, content);
            YouTube.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class Update
        extends YouTubeRequest<Comment> {
            private static final String REST_PATH = "youtube/v3/comments";
            @Key
            private java.util.List<String> part;

            protected Update(java.util.List<String> part, Comment content) {
                super(YouTube.this, "PUT", REST_PATH, (Object)content, Comment.class);
                this.part = (java.util.List)Preconditions.checkNotNull(part, (Object)"Required parameter part must be specified.");
            }

            public Update set$Xgafv(String $Xgafv) {
                return (Update)super.set$Xgafv($Xgafv);
            }

            public Update setAccessToken(String accessToken) {
                return (Update)super.setAccessToken(accessToken);
            }

            public Update setAlt(String alt) {
                return (Update)super.setAlt(alt);
            }

            public Update setCallback(String callback) {
                return (Update)super.setCallback(callback);
            }

            public Update setFields(String fields) {
                return (Update)super.setFields(fields);
            }

            public Update setKey(String key) {
                return (Update)super.setKey(key);
            }

            public Update setOauthToken(String oauthToken) {
                return (Update)super.setOauthToken(oauthToken);
            }

            public Update setPrettyPrint(Boolean prettyPrint) {
                return (Update)super.setPrettyPrint(prettyPrint);
            }

            public Update setQuotaUser(String quotaUser) {
                return (Update)super.setQuotaUser(quotaUser);
            }

            public Update setUploadType(String uploadType) {
                return (Update)super.setUploadType(uploadType);
            }

            public Update setUploadProtocol(String uploadProtocol) {
                return (Update)super.setUploadProtocol(uploadProtocol);
            }

            public java.util.List<String> getPart() {
                return this.part;
            }

            public Update setPart(java.util.List<String> part) {
                this.part = part;
                return this;
            }

            @Override
            public Update set(String parameterName, Object value) {
                return (Update)super.set(parameterName, value);
            }
        }

        public class SetModerationStatus
        extends YouTubeRequest<Void> {
            private static final String REST_PATH = "youtube/v3/comments/setModerationStatus";
            @Key
            private java.util.List<String> id;
            @Key
            private String moderationStatus;
            @Key
            private Boolean banAuthor;

            protected SetModerationStatus(java.util.List<String> id, String moderationStatus) {
                super(YouTube.this, "POST", REST_PATH, null, Void.class);
                this.id = (java.util.List)Preconditions.checkNotNull(id, (Object)"Required parameter id must be specified.");
                this.moderationStatus = (String)Preconditions.checkNotNull((Object)moderationStatus, (Object)"Required parameter moderationStatus must be specified.");
            }

            public SetModerationStatus set$Xgafv(String $Xgafv) {
                return (SetModerationStatus)super.set$Xgafv($Xgafv);
            }

            public SetModerationStatus setAccessToken(String accessToken) {
                return (SetModerationStatus)super.setAccessToken(accessToken);
            }

            public SetModerationStatus setAlt(String alt) {
                return (SetModerationStatus)super.setAlt(alt);
            }

            public SetModerationStatus setCallback(String callback) {
                return (SetModerationStatus)super.setCallback(callback);
            }

            public SetModerationStatus setFields(String fields) {
                return (SetModerationStatus)super.setFields(fields);
            }

            public SetModerationStatus setKey(String key) {
                return (SetModerationStatus)super.setKey(key);
            }

            public SetModerationStatus setOauthToken(String oauthToken) {
                return (SetModerationStatus)super.setOauthToken(oauthToken);
            }

            public SetModerationStatus setPrettyPrint(Boolean prettyPrint) {
                return (SetModerationStatus)super.setPrettyPrint(prettyPrint);
            }

            public SetModerationStatus setQuotaUser(String quotaUser) {
                return (SetModerationStatus)super.setQuotaUser(quotaUser);
            }

            public SetModerationStatus setUploadType(String uploadType) {
                return (SetModerationStatus)super.setUploadType(uploadType);
            }

            public SetModerationStatus setUploadProtocol(String uploadProtocol) {
                return (SetModerationStatus)super.setUploadProtocol(uploadProtocol);
            }

            public java.util.List<String> getId() {
                return this.id;
            }

            public SetModerationStatus setId(java.util.List<String> id) {
                this.id = id;
                return this;
            }

            public String getModerationStatus() {
                return this.moderationStatus;
            }

            public SetModerationStatus setModerationStatus(String moderationStatus) {
                this.moderationStatus = moderationStatus;
                return this;
            }

            public Boolean getBanAuthor() {
                return this.banAuthor;
            }

            public SetModerationStatus setBanAuthor(Boolean banAuthor) {
                this.banAuthor = banAuthor;
                return this;
            }

            public boolean isBanAuthor() {
                if (this.banAuthor == null || this.banAuthor == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.banAuthor;
            }

            @Override
            public SetModerationStatus set(String parameterName, Object value) {
                return (SetModerationStatus)super.set(parameterName, value);
            }
        }

        public class MarkAsSpam
        extends YouTubeRequest<Void> {
            private static final String REST_PATH = "youtube/v3/comments/markAsSpam";
            @Key
            private java.util.List<String> id;

            protected MarkAsSpam(java.util.List<String> id) {
                super(YouTube.this, "POST", REST_PATH, null, Void.class);
                this.id = (java.util.List)Preconditions.checkNotNull(id, (Object)"Required parameter id must be specified.");
            }

            public MarkAsSpam set$Xgafv(String $Xgafv) {
                return (MarkAsSpam)super.set$Xgafv($Xgafv);
            }

            public MarkAsSpam setAccessToken(String accessToken) {
                return (MarkAsSpam)super.setAccessToken(accessToken);
            }

            public MarkAsSpam setAlt(String alt) {
                return (MarkAsSpam)super.setAlt(alt);
            }

            public MarkAsSpam setCallback(String callback) {
                return (MarkAsSpam)super.setCallback(callback);
            }

            public MarkAsSpam setFields(String fields) {
                return (MarkAsSpam)super.setFields(fields);
            }

            public MarkAsSpam setKey(String key) {
                return (MarkAsSpam)super.setKey(key);
            }

            public MarkAsSpam setOauthToken(String oauthToken) {
                return (MarkAsSpam)super.setOauthToken(oauthToken);
            }

            public MarkAsSpam setPrettyPrint(Boolean prettyPrint) {
                return (MarkAsSpam)super.setPrettyPrint(prettyPrint);
            }

            public MarkAsSpam setQuotaUser(String quotaUser) {
                return (MarkAsSpam)super.setQuotaUser(quotaUser);
            }

            public MarkAsSpam setUploadType(String uploadType) {
                return (MarkAsSpam)super.setUploadType(uploadType);
            }

            public MarkAsSpam setUploadProtocol(String uploadProtocol) {
                return (MarkAsSpam)super.setUploadProtocol(uploadProtocol);
            }

            public java.util.List<String> getId() {
                return this.id;
            }

            public MarkAsSpam setId(java.util.List<String> id) {
                this.id = id;
                return this;
            }

            @Override
            public MarkAsSpam set(String parameterName, Object value) {
                return (MarkAsSpam)super.set(parameterName, value);
            }
        }

        public class List
        extends YouTubeRequest<CommentListResponse> {
            private static final String REST_PATH = "youtube/v3/comments";
            @Key
            private java.util.List<String> part;
            @Key
            private java.util.List<String> id;
            @Key
            private Long maxResults;
            @Key
            private String pageToken;
            @Key
            private String parentId;
            @Key
            private String textFormat;

            protected List(java.util.List<String> part) {
                super(YouTube.this, "GET", REST_PATH, null, CommentListResponse.class);
                this.part = (java.util.List)Preconditions.checkNotNull(part, (Object)"Required parameter part must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String $Xgafv) {
                return (List)super.set$Xgafv($Xgafv);
            }

            public List setAccessToken(String accessToken) {
                return (List)super.setAccessToken(accessToken);
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setCallback(String callback) {
                return (List)super.setCallback(callback);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUploadType(String uploadType) {
                return (List)super.setUploadType(uploadType);
            }

            public List setUploadProtocol(String uploadProtocol) {
                return (List)super.setUploadProtocol(uploadProtocol);
            }

            public java.util.List<String> getPart() {
                return this.part;
            }

            public List setPart(java.util.List<String> part) {
                this.part = part;
                return this;
            }

            public java.util.List<String> getId() {
                return this.id;
            }

            public List setId(java.util.List<String> id) {
                this.id = id;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long maxResults) {
                this.maxResults = maxResults;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            public String getParentId() {
                return this.parentId;
            }

            public List setParentId(String parentId) {
                this.parentId = parentId;
                return this;
            }

            public String getTextFormat() {
                return this.textFormat;
            }

            public List setTextFormat(String textFormat) {
                this.textFormat = textFormat;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class Insert
        extends YouTubeRequest<Comment> {
            private static final String REST_PATH = "youtube/v3/comments";
            @Key
            private java.util.List<String> part;

            protected Insert(java.util.List<String> part, Comment content) {
                super(YouTube.this, "POST", REST_PATH, (Object)content, Comment.class);
                this.part = (java.util.List)Preconditions.checkNotNull(part, (Object)"Required parameter part must be specified.");
            }

            public Insert set$Xgafv(String $Xgafv) {
                return (Insert)super.set$Xgafv($Xgafv);
            }

            public Insert setAccessToken(String accessToken) {
                return (Insert)super.setAccessToken(accessToken);
            }

            public Insert setAlt(String alt) {
                return (Insert)super.setAlt(alt);
            }

            public Insert setCallback(String callback) {
                return (Insert)super.setCallback(callback);
            }

            public Insert setFields(String fields) {
                return (Insert)super.setFields(fields);
            }

            public Insert setKey(String key) {
                return (Insert)super.setKey(key);
            }

            public Insert setOauthToken(String oauthToken) {
                return (Insert)super.setOauthToken(oauthToken);
            }

            public Insert setPrettyPrint(Boolean prettyPrint) {
                return (Insert)super.setPrettyPrint(prettyPrint);
            }

            public Insert setQuotaUser(String quotaUser) {
                return (Insert)super.setQuotaUser(quotaUser);
            }

            public Insert setUploadType(String uploadType) {
                return (Insert)super.setUploadType(uploadType);
            }

            public Insert setUploadProtocol(String uploadProtocol) {
                return (Insert)super.setUploadProtocol(uploadProtocol);
            }

            public java.util.List<String> getPart() {
                return this.part;
            }

            public Insert setPart(java.util.List<String> part) {
                this.part = part;
                return this;
            }

            @Override
            public Insert set(String parameterName, Object value) {
                return (Insert)super.set(parameterName, value);
            }
        }

        public class Delete
        extends YouTubeRequest<Void> {
            private static final String REST_PATH = "youtube/v3/comments";
            @Key
            private String id;

            protected Delete(String id) {
                super(YouTube.this, "DELETE", REST_PATH, null, Void.class);
                this.id = (String)Preconditions.checkNotNull((Object)id, (Object)"Required parameter id must be specified.");
            }

            public Delete set$Xgafv(String $Xgafv) {
                return (Delete)super.set$Xgafv($Xgafv);
            }

            public Delete setAccessToken(String accessToken) {
                return (Delete)super.setAccessToken(accessToken);
            }

            public Delete setAlt(String alt) {
                return (Delete)super.setAlt(alt);
            }

            public Delete setCallback(String callback) {
                return (Delete)super.setCallback(callback);
            }

            public Delete setFields(String fields) {
                return (Delete)super.setFields(fields);
            }

            public Delete setKey(String key) {
                return (Delete)super.setKey(key);
            }

            public Delete setOauthToken(String oauthToken) {
                return (Delete)super.setOauthToken(oauthToken);
            }

            public Delete setPrettyPrint(Boolean prettyPrint) {
                return (Delete)super.setPrettyPrint(prettyPrint);
            }

            public Delete setQuotaUser(String quotaUser) {
                return (Delete)super.setQuotaUser(quotaUser);
            }

            public Delete setUploadType(String uploadType) {
                return (Delete)super.setUploadType(uploadType);
            }

            public Delete setUploadProtocol(String uploadProtocol) {
                return (Delete)super.setUploadProtocol(uploadProtocol);
            }

            public String getId() {
                return this.id;
            }

            public Delete setId(String id) {
                this.id = id;
                return this;
            }

            @Override
            public Delete set(String parameterName, Object value) {
                return (Delete)super.set(parameterName, value);
            }
        }
    }

    public class CommentThreads {
        public Insert insert(java.util.List<String> part, CommentThread content) throws IOException {
            Insert result = new Insert(part, content);
            YouTube.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list(java.util.List<String> part) throws IOException {
            List result = new List(part);
            YouTube.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class List
        extends YouTubeRequest<CommentThreadListResponse> {
            private static final String REST_PATH = "youtube/v3/commentThreads";
            @Key
            private java.util.List<String> part;
            @Key
            private String allThreadsRelatedToChannelId;
            @Key
            private String channelId;
            @Key
            private java.util.List<String> id;
            @Key
            private Long maxResults;
            @Key
            private String moderationStatus;
            @Key
            private String order;
            @Key
            private String pageToken;
            @Key
            private String searchTerms;
            @Key
            private String textFormat;
            @Key
            private String videoId;

            protected List(java.util.List<String> part) {
                super(YouTube.this, "GET", REST_PATH, null, CommentThreadListResponse.class);
                this.part = (java.util.List)Preconditions.checkNotNull(part, (Object)"Required parameter part must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String $Xgafv) {
                return (List)super.set$Xgafv($Xgafv);
            }

            public List setAccessToken(String accessToken) {
                return (List)super.setAccessToken(accessToken);
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setCallback(String callback) {
                return (List)super.setCallback(callback);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUploadType(String uploadType) {
                return (List)super.setUploadType(uploadType);
            }

            public List setUploadProtocol(String uploadProtocol) {
                return (List)super.setUploadProtocol(uploadProtocol);
            }

            public java.util.List<String> getPart() {
                return this.part;
            }

            public List setPart(java.util.List<String> part) {
                this.part = part;
                return this;
            }

            public String getAllThreadsRelatedToChannelId() {
                return this.allThreadsRelatedToChannelId;
            }

            public List setAllThreadsRelatedToChannelId(String allThreadsRelatedToChannelId) {
                this.allThreadsRelatedToChannelId = allThreadsRelatedToChannelId;
                return this;
            }

            public String getChannelId() {
                return this.channelId;
            }

            public List setChannelId(String channelId) {
                this.channelId = channelId;
                return this;
            }

            public java.util.List<String> getId() {
                return this.id;
            }

            public List setId(java.util.List<String> id) {
                this.id = id;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long maxResults) {
                this.maxResults = maxResults;
                return this;
            }

            public String getModerationStatus() {
                return this.moderationStatus;
            }

            public List setModerationStatus(String moderationStatus) {
                this.moderationStatus = moderationStatus;
                return this;
            }

            public String getOrder() {
                return this.order;
            }

            public List setOrder(String order) {
                this.order = order;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            public String getSearchTerms() {
                return this.searchTerms;
            }

            public List setSearchTerms(String searchTerms) {
                this.searchTerms = searchTerms;
                return this;
            }

            public String getTextFormat() {
                return this.textFormat;
            }

            public List setTextFormat(String textFormat) {
                this.textFormat = textFormat;
                return this;
            }

            public String getVideoId() {
                return this.videoId;
            }

            public List setVideoId(String videoId) {
                this.videoId = videoId;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class Insert
        extends YouTubeRequest<CommentThread> {
            private static final String REST_PATH = "youtube/v3/commentThreads";
            @Key
            private java.util.List<String> part;

            protected Insert(java.util.List<String> part, CommentThread content) {
                super(YouTube.this, "POST", REST_PATH, (Object)content, CommentThread.class);
                this.part = (java.util.List)Preconditions.checkNotNull(part, (Object)"Required parameter part must be specified.");
            }

            public Insert set$Xgafv(String $Xgafv) {
                return (Insert)super.set$Xgafv($Xgafv);
            }

            public Insert setAccessToken(String accessToken) {
                return (Insert)super.setAccessToken(accessToken);
            }

            public Insert setAlt(String alt) {
                return (Insert)super.setAlt(alt);
            }

            public Insert setCallback(String callback) {
                return (Insert)super.setCallback(callback);
            }

            public Insert setFields(String fields) {
                return (Insert)super.setFields(fields);
            }

            public Insert setKey(String key) {
                return (Insert)super.setKey(key);
            }

            public Insert setOauthToken(String oauthToken) {
                return (Insert)super.setOauthToken(oauthToken);
            }

            public Insert setPrettyPrint(Boolean prettyPrint) {
                return (Insert)super.setPrettyPrint(prettyPrint);
            }

            public Insert setQuotaUser(String quotaUser) {
                return (Insert)super.setQuotaUser(quotaUser);
            }

            public Insert setUploadType(String uploadType) {
                return (Insert)super.setUploadType(uploadType);
            }

            public Insert setUploadProtocol(String uploadProtocol) {
                return (Insert)super.setUploadProtocol(uploadProtocol);
            }

            public java.util.List<String> getPart() {
                return this.part;
            }

            public Insert setPart(java.util.List<String> part) {
                this.part = part;
                return this;
            }

            @Override
            public Insert set(String parameterName, Object value) {
                return (Insert)super.set(parameterName, value);
            }
        }
    }

    public class Channels {
        public List list(java.util.List<String> part) throws IOException {
            List result = new List(part);
            YouTube.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Update update(java.util.List<String> part, Channel content) throws IOException {
            Update result = new Update(part, content);
            YouTube.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class Update
        extends YouTubeRequest<Channel> {
            private static final String REST_PATH = "youtube/v3/channels";
            @Key
            private java.util.List<String> part;
            @Key
            private String onBehalfOfContentOwner;

            protected Update(java.util.List<String> part, Channel content) {
                super(YouTube.this, "PUT", REST_PATH, (Object)content, Channel.class);
                this.part = (java.util.List)Preconditions.checkNotNull(part, (Object)"Required parameter part must be specified.");
            }

            public Update set$Xgafv(String $Xgafv) {
                return (Update)super.set$Xgafv($Xgafv);
            }

            public Update setAccessToken(String accessToken) {
                return (Update)super.setAccessToken(accessToken);
            }

            public Update setAlt(String alt) {
                return (Update)super.setAlt(alt);
            }

            public Update setCallback(String callback) {
                return (Update)super.setCallback(callback);
            }

            public Update setFields(String fields) {
                return (Update)super.setFields(fields);
            }

            public Update setKey(String key) {
                return (Update)super.setKey(key);
            }

            public Update setOauthToken(String oauthToken) {
                return (Update)super.setOauthToken(oauthToken);
            }

            public Update setPrettyPrint(Boolean prettyPrint) {
                return (Update)super.setPrettyPrint(prettyPrint);
            }

            public Update setQuotaUser(String quotaUser) {
                return (Update)super.setQuotaUser(quotaUser);
            }

            public Update setUploadType(String uploadType) {
                return (Update)super.setUploadType(uploadType);
            }

            public Update setUploadProtocol(String uploadProtocol) {
                return (Update)super.setUploadProtocol(uploadProtocol);
            }

            public java.util.List<String> getPart() {
                return this.part;
            }

            public Update setPart(java.util.List<String> part) {
                this.part = part;
                return this;
            }

            public String getOnBehalfOfContentOwner() {
                return this.onBehalfOfContentOwner;
            }

            public Update setOnBehalfOfContentOwner(String onBehalfOfContentOwner) {
                this.onBehalfOfContentOwner = onBehalfOfContentOwner;
                return this;
            }

            @Override
            public Update set(String parameterName, Object value) {
                return (Update)super.set(parameterName, value);
            }
        }

        public class List
        extends YouTubeRequest<ChannelListResponse> {
            private static final String REST_PATH = "youtube/v3/channels";
            @Key
            private java.util.List<String> part;
            @Key
            private String categoryId;
            @Key
            private String forHandle;
            @Key
            private String forUsername;
            @Key
            private String hl;
            @Key
            private java.util.List<String> id;
            @Key
            private Boolean managedByMe;
            @Key
            private Long maxResults;
            @Key
            private Boolean mine;
            @Key
            private Boolean mySubscribers;
            @Key
            private String onBehalfOfContentOwner;
            @Key
            private String pageToken;

            protected List(java.util.List<String> part) {
                super(YouTube.this, "GET", REST_PATH, null, ChannelListResponse.class);
                this.part = (java.util.List)Preconditions.checkNotNull(part, (Object)"Required parameter part must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String $Xgafv) {
                return (List)super.set$Xgafv($Xgafv);
            }

            public List setAccessToken(String accessToken) {
                return (List)super.setAccessToken(accessToken);
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setCallback(String callback) {
                return (List)super.setCallback(callback);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUploadType(String uploadType) {
                return (List)super.setUploadType(uploadType);
            }

            public List setUploadProtocol(String uploadProtocol) {
                return (List)super.setUploadProtocol(uploadProtocol);
            }

            public java.util.List<String> getPart() {
                return this.part;
            }

            public List setPart(java.util.List<String> part) {
                this.part = part;
                return this;
            }

            public String getCategoryId() {
                return this.categoryId;
            }

            public List setCategoryId(String categoryId) {
                this.categoryId = categoryId;
                return this;
            }

            public String getForHandle() {
                return this.forHandle;
            }

            public List setForHandle(String forHandle) {
                this.forHandle = forHandle;
                return this;
            }

            public String getForUsername() {
                return this.forUsername;
            }

            public List setForUsername(String forUsername) {
                this.forUsername = forUsername;
                return this;
            }

            public String getHl() {
                return this.hl;
            }

            public List setHl(String hl) {
                this.hl = hl;
                return this;
            }

            public java.util.List<String> getId() {
                return this.id;
            }

            public List setId(java.util.List<String> id) {
                this.id = id;
                return this;
            }

            public Boolean getManagedByMe() {
                return this.managedByMe;
            }

            public List setManagedByMe(Boolean managedByMe) {
                this.managedByMe = managedByMe;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long maxResults) {
                this.maxResults = maxResults;
                return this;
            }

            public Boolean getMine() {
                return this.mine;
            }

            public List setMine(Boolean mine) {
                this.mine = mine;
                return this;
            }

            public Boolean getMySubscribers() {
                return this.mySubscribers;
            }

            public List setMySubscribers(Boolean mySubscribers) {
                this.mySubscribers = mySubscribers;
                return this;
            }

            public String getOnBehalfOfContentOwner() {
                return this.onBehalfOfContentOwner;
            }

            public List setOnBehalfOfContentOwner(String onBehalfOfContentOwner) {
                this.onBehalfOfContentOwner = onBehalfOfContentOwner;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }
    }

    public class ChannelSections {
        public Delete delete(String id) throws IOException {
            Delete result = new Delete(id);
            YouTube.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Insert insert(java.util.List<String> part, ChannelSection content) throws IOException {
            Insert result = new Insert(part, content);
            YouTube.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list(java.util.List<String> part) throws IOException {
            List result = new List(part);
            YouTube.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Update update(java.util.List<String> part, ChannelSection content) throws IOException {
            Update result = new Update(part, content);
            YouTube.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class Update
        extends YouTubeRequest<ChannelSection> {
            private static final String REST_PATH = "youtube/v3/channelSections";
            @Key
            private java.util.List<String> part;
            @Key
            private String onBehalfOfContentOwner;

            protected Update(java.util.List<String> part, ChannelSection content) {
                super(YouTube.this, "PUT", REST_PATH, (Object)content, ChannelSection.class);
                this.part = (java.util.List)Preconditions.checkNotNull(part, (Object)"Required parameter part must be specified.");
            }

            public Update set$Xgafv(String $Xgafv) {
                return (Update)super.set$Xgafv($Xgafv);
            }

            public Update setAccessToken(String accessToken) {
                return (Update)super.setAccessToken(accessToken);
            }

            public Update setAlt(String alt) {
                return (Update)super.setAlt(alt);
            }

            public Update setCallback(String callback) {
                return (Update)super.setCallback(callback);
            }

            public Update setFields(String fields) {
                return (Update)super.setFields(fields);
            }

            public Update setKey(String key) {
                return (Update)super.setKey(key);
            }

            public Update setOauthToken(String oauthToken) {
                return (Update)super.setOauthToken(oauthToken);
            }

            public Update setPrettyPrint(Boolean prettyPrint) {
                return (Update)super.setPrettyPrint(prettyPrint);
            }

            public Update setQuotaUser(String quotaUser) {
                return (Update)super.setQuotaUser(quotaUser);
            }

            public Update setUploadType(String uploadType) {
                return (Update)super.setUploadType(uploadType);
            }

            public Update setUploadProtocol(String uploadProtocol) {
                return (Update)super.setUploadProtocol(uploadProtocol);
            }

            public java.util.List<String> getPart() {
                return this.part;
            }

            public Update setPart(java.util.List<String> part) {
                this.part = part;
                return this;
            }

            public String getOnBehalfOfContentOwner() {
                return this.onBehalfOfContentOwner;
            }

            public Update setOnBehalfOfContentOwner(String onBehalfOfContentOwner) {
                this.onBehalfOfContentOwner = onBehalfOfContentOwner;
                return this;
            }

            @Override
            public Update set(String parameterName, Object value) {
                return (Update)super.set(parameterName, value);
            }
        }

        public class List
        extends YouTubeRequest<ChannelSectionListResponse> {
            private static final String REST_PATH = "youtube/v3/channelSections";
            @Key
            private java.util.List<String> part;
            @Key
            private String channelId;
            @Key
            private String hl;
            @Key
            private java.util.List<String> id;
            @Key
            private Boolean mine;
            @Key
            private String onBehalfOfContentOwner;

            protected List(java.util.List<String> part) {
                super(YouTube.this, "GET", REST_PATH, null, ChannelSectionListResponse.class);
                this.part = (java.util.List)Preconditions.checkNotNull(part, (Object)"Required parameter part must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String $Xgafv) {
                return (List)super.set$Xgafv($Xgafv);
            }

            public List setAccessToken(String accessToken) {
                return (List)super.setAccessToken(accessToken);
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setCallback(String callback) {
                return (List)super.setCallback(callback);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUploadType(String uploadType) {
                return (List)super.setUploadType(uploadType);
            }

            public List setUploadProtocol(String uploadProtocol) {
                return (List)super.setUploadProtocol(uploadProtocol);
            }

            public java.util.List<String> getPart() {
                return this.part;
            }

            public List setPart(java.util.List<String> part) {
                this.part = part;
                return this;
            }

            public String getChannelId() {
                return this.channelId;
            }

            public List setChannelId(String channelId) {
                this.channelId = channelId;
                return this;
            }

            public String getHl() {
                return this.hl;
            }

            public List setHl(String hl) {
                this.hl = hl;
                return this;
            }

            public java.util.List<String> getId() {
                return this.id;
            }

            public List setId(java.util.List<String> id) {
                this.id = id;
                return this;
            }

            public Boolean getMine() {
                return this.mine;
            }

            public List setMine(Boolean mine) {
                this.mine = mine;
                return this;
            }

            public String getOnBehalfOfContentOwner() {
                return this.onBehalfOfContentOwner;
            }

            public List setOnBehalfOfContentOwner(String onBehalfOfContentOwner) {
                this.onBehalfOfContentOwner = onBehalfOfContentOwner;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class Insert
        extends YouTubeRequest<ChannelSection> {
            private static final String REST_PATH = "youtube/v3/channelSections";
            @Key
            private java.util.List<String> part;
            @Key
            private String onBehalfOfContentOwner;
            @Key
            private String onBehalfOfContentOwnerChannel;

            protected Insert(java.util.List<String> part, ChannelSection content) {
                super(YouTube.this, "POST", REST_PATH, (Object)content, ChannelSection.class);
                this.part = (java.util.List)Preconditions.checkNotNull(part, (Object)"Required parameter part must be specified.");
            }

            public Insert set$Xgafv(String $Xgafv) {
                return (Insert)super.set$Xgafv($Xgafv);
            }

            public Insert setAccessToken(String accessToken) {
                return (Insert)super.setAccessToken(accessToken);
            }

            public Insert setAlt(String alt) {
                return (Insert)super.setAlt(alt);
            }

            public Insert setCallback(String callback) {
                return (Insert)super.setCallback(callback);
            }

            public Insert setFields(String fields) {
                return (Insert)super.setFields(fields);
            }

            public Insert setKey(String key) {
                return (Insert)super.setKey(key);
            }

            public Insert setOauthToken(String oauthToken) {
                return (Insert)super.setOauthToken(oauthToken);
            }

            public Insert setPrettyPrint(Boolean prettyPrint) {
                return (Insert)super.setPrettyPrint(prettyPrint);
            }

            public Insert setQuotaUser(String quotaUser) {
                return (Insert)super.setQuotaUser(quotaUser);
            }

            public Insert setUploadType(String uploadType) {
                return (Insert)super.setUploadType(uploadType);
            }

            public Insert setUploadProtocol(String uploadProtocol) {
                return (Insert)super.setUploadProtocol(uploadProtocol);
            }

            public java.util.List<String> getPart() {
                return this.part;
            }

            public Insert setPart(java.util.List<String> part) {
                this.part = part;
                return this;
            }

            public String getOnBehalfOfContentOwner() {
                return this.onBehalfOfContentOwner;
            }

            public Insert setOnBehalfOfContentOwner(String onBehalfOfContentOwner) {
                this.onBehalfOfContentOwner = onBehalfOfContentOwner;
                return this;
            }

            public String getOnBehalfOfContentOwnerChannel() {
                return this.onBehalfOfContentOwnerChannel;
            }

            public Insert setOnBehalfOfContentOwnerChannel(String onBehalfOfContentOwnerChannel) {
                this.onBehalfOfContentOwnerChannel = onBehalfOfContentOwnerChannel;
                return this;
            }

            @Override
            public Insert set(String parameterName, Object value) {
                return (Insert)super.set(parameterName, value);
            }
        }

        public class Delete
        extends YouTubeRequest<Void> {
            private static final String REST_PATH = "youtube/v3/channelSections";
            @Key
            private String id;
            @Key
            private String onBehalfOfContentOwner;

            protected Delete(String id) {
                super(YouTube.this, "DELETE", REST_PATH, null, Void.class);
                this.id = (String)Preconditions.checkNotNull((Object)id, (Object)"Required parameter id must be specified.");
            }

            public Delete set$Xgafv(String $Xgafv) {
                return (Delete)super.set$Xgafv($Xgafv);
            }

            public Delete setAccessToken(String accessToken) {
                return (Delete)super.setAccessToken(accessToken);
            }

            public Delete setAlt(String alt) {
                return (Delete)super.setAlt(alt);
            }

            public Delete setCallback(String callback) {
                return (Delete)super.setCallback(callback);
            }

            public Delete setFields(String fields) {
                return (Delete)super.setFields(fields);
            }

            public Delete setKey(String key) {
                return (Delete)super.setKey(key);
            }

            public Delete setOauthToken(String oauthToken) {
                return (Delete)super.setOauthToken(oauthToken);
            }

            public Delete setPrettyPrint(Boolean prettyPrint) {
                return (Delete)super.setPrettyPrint(prettyPrint);
            }

            public Delete setQuotaUser(String quotaUser) {
                return (Delete)super.setQuotaUser(quotaUser);
            }

            public Delete setUploadType(String uploadType) {
                return (Delete)super.setUploadType(uploadType);
            }

            public Delete setUploadProtocol(String uploadProtocol) {
                return (Delete)super.setUploadProtocol(uploadProtocol);
            }

            public String getId() {
                return this.id;
            }

            public Delete setId(String id) {
                this.id = id;
                return this;
            }

            public String getOnBehalfOfContentOwner() {
                return this.onBehalfOfContentOwner;
            }

            public Delete setOnBehalfOfContentOwner(String onBehalfOfContentOwner) {
                this.onBehalfOfContentOwner = onBehalfOfContentOwner;
                return this;
            }

            @Override
            public Delete set(String parameterName, Object value) {
                return (Delete)super.set(parameterName, value);
            }
        }
    }

    public class ChannelBanners {
        public Insert insert(ChannelBannerResource content) throws IOException {
            Insert result = new Insert(content);
            YouTube.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Insert insert(ChannelBannerResource content, AbstractInputStreamContent mediaContent) throws IOException {
            Insert result = new Insert(content, mediaContent);
            YouTube.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class Insert
        extends YouTubeRequest<ChannelBannerResource> {
            private static final String REST_PATH = "youtube/v3/channelBanners/insert";
            @Key
            private String channelId;
            @Key
            private String onBehalfOfContentOwner;
            @Key
            private String onBehalfOfContentOwnerChannel;

            protected Insert(ChannelBannerResource content) {
                super(YouTube.this, "POST", REST_PATH, (Object)content, ChannelBannerResource.class);
            }

            protected Insert(ChannelBannerResource content, AbstractInputStreamContent mediaContent) {
                super(YouTube.this, "POST", "/upload/" + YouTube.this.getServicePath() + REST_PATH, (Object)content, ChannelBannerResource.class);
                Preconditions.checkNotNull((Object)mediaContent, (Object)"Required parameter mediaContent must be specified.");
                this.initializeMediaUpload(mediaContent);
            }

            public Insert set$Xgafv(String $Xgafv) {
                return (Insert)super.set$Xgafv($Xgafv);
            }

            public Insert setAccessToken(String accessToken) {
                return (Insert)super.setAccessToken(accessToken);
            }

            public Insert setAlt(String alt) {
                return (Insert)super.setAlt(alt);
            }

            public Insert setCallback(String callback) {
                return (Insert)super.setCallback(callback);
            }

            public Insert setFields(String fields) {
                return (Insert)super.setFields(fields);
            }

            public Insert setKey(String key) {
                return (Insert)super.setKey(key);
            }

            public Insert setOauthToken(String oauthToken) {
                return (Insert)super.setOauthToken(oauthToken);
            }

            public Insert setPrettyPrint(Boolean prettyPrint) {
                return (Insert)super.setPrettyPrint(prettyPrint);
            }

            public Insert setQuotaUser(String quotaUser) {
                return (Insert)super.setQuotaUser(quotaUser);
            }

            public Insert setUploadType(String uploadType) {
                return (Insert)super.setUploadType(uploadType);
            }

            public Insert setUploadProtocol(String uploadProtocol) {
                return (Insert)super.setUploadProtocol(uploadProtocol);
            }

            public String getChannelId() {
                return this.channelId;
            }

            public Insert setChannelId(String channelId) {
                this.channelId = channelId;
                return this;
            }

            public String getOnBehalfOfContentOwner() {
                return this.onBehalfOfContentOwner;
            }

            public Insert setOnBehalfOfContentOwner(String onBehalfOfContentOwner) {
                this.onBehalfOfContentOwner = onBehalfOfContentOwner;
                return this;
            }

            public String getOnBehalfOfContentOwnerChannel() {
                return this.onBehalfOfContentOwnerChannel;
            }

            public Insert setOnBehalfOfContentOwnerChannel(String onBehalfOfContentOwnerChannel) {
                this.onBehalfOfContentOwnerChannel = onBehalfOfContentOwnerChannel;
                return this;
            }

            @Override
            public Insert set(String parameterName, Object value) {
                return (Insert)super.set(parameterName, value);
            }
        }
    }

    public class Captions {
        public Delete delete(String id) throws IOException {
            Delete result = new Delete(id);
            YouTube.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Download download(String id) throws IOException {
            Download result = new Download(id);
            YouTube.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Insert insert(java.util.List<String> part, Caption content) throws IOException {
            Insert result = new Insert(part, content);
            YouTube.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Insert insert(java.util.List<String> part, Caption content, AbstractInputStreamContent mediaContent) throws IOException {
            Insert result = new Insert(part, content, mediaContent);
            YouTube.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list(java.util.List<String> part, String videoId) throws IOException {
            List result = new List(part, videoId);
            YouTube.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Update update(java.util.List<String> part, Caption content) throws IOException {
            Update result = new Update(part, content);
            YouTube.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Update update(java.util.List<String> part, Caption content, AbstractInputStreamContent mediaContent) throws IOException {
            Update result = new Update(part, content, mediaContent);
            YouTube.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class Update
        extends YouTubeRequest<Caption> {
            private static final String REST_PATH = "youtube/v3/captions";
            @Key
            private java.util.List<String> part;
            @Key
            private String onBehalfOf;
            @Key
            private String onBehalfOfContentOwner;
            @Key
            private Boolean sync;

            protected Update(java.util.List<String> part, Caption content) {
                super(YouTube.this, "PUT", REST_PATH, (Object)content, Caption.class);
                this.part = (java.util.List)Preconditions.checkNotNull(part, (Object)"Required parameter part must be specified.");
                this.checkRequiredParameter((Object)content, "content");
                this.checkRequiredParameter(content.getId(), "Caption.getId()");
            }

            protected Update(java.util.List<String> part, Caption content, AbstractInputStreamContent mediaContent) {
                super(YouTube.this, "PUT", "/upload/" + YouTube.this.getServicePath() + REST_PATH, (Object)content, Caption.class);
                this.part = (java.util.List)Preconditions.checkNotNull(part, (Object)"Required parameter part must be specified.");
                Preconditions.checkNotNull((Object)mediaContent, (Object)"Required parameter mediaContent must be specified.");
                this.initializeMediaUpload(mediaContent);
            }

            public Update set$Xgafv(String $Xgafv) {
                return (Update)super.set$Xgafv($Xgafv);
            }

            public Update setAccessToken(String accessToken) {
                return (Update)super.setAccessToken(accessToken);
            }

            public Update setAlt(String alt) {
                return (Update)super.setAlt(alt);
            }

            public Update setCallback(String callback) {
                return (Update)super.setCallback(callback);
            }

            public Update setFields(String fields) {
                return (Update)super.setFields(fields);
            }

            public Update setKey(String key) {
                return (Update)super.setKey(key);
            }

            public Update setOauthToken(String oauthToken) {
                return (Update)super.setOauthToken(oauthToken);
            }

            public Update setPrettyPrint(Boolean prettyPrint) {
                return (Update)super.setPrettyPrint(prettyPrint);
            }

            public Update setQuotaUser(String quotaUser) {
                return (Update)super.setQuotaUser(quotaUser);
            }

            public Update setUploadType(String uploadType) {
                return (Update)super.setUploadType(uploadType);
            }

            public Update setUploadProtocol(String uploadProtocol) {
                return (Update)super.setUploadProtocol(uploadProtocol);
            }

            public java.util.List<String> getPart() {
                return this.part;
            }

            public Update setPart(java.util.List<String> part) {
                this.part = part;
                return this;
            }

            public String getOnBehalfOf() {
                return this.onBehalfOf;
            }

            public Update setOnBehalfOf(String onBehalfOf) {
                this.onBehalfOf = onBehalfOf;
                return this;
            }

            public String getOnBehalfOfContentOwner() {
                return this.onBehalfOfContentOwner;
            }

            public Update setOnBehalfOfContentOwner(String onBehalfOfContentOwner) {
                this.onBehalfOfContentOwner = onBehalfOfContentOwner;
                return this;
            }

            public Boolean getSync() {
                return this.sync;
            }

            public Update setSync(Boolean sync) {
                this.sync = sync;
                return this;
            }

            @Override
            public Update set(String parameterName, Object value) {
                return (Update)super.set(parameterName, value);
            }
        }

        public class List
        extends YouTubeRequest<CaptionListResponse> {
            private static final String REST_PATH = "youtube/v3/captions";
            @Key
            private java.util.List<String> part;
            @Key
            private String videoId;
            @Key
            private java.util.List<String> id;
            @Key
            private String onBehalfOf;
            @Key
            private String onBehalfOfContentOwner;

            protected List(java.util.List<String> part, String videoId) {
                super(YouTube.this, "GET", REST_PATH, null, CaptionListResponse.class);
                this.part = (java.util.List)Preconditions.checkNotNull(part, (Object)"Required parameter part must be specified.");
                this.videoId = (String)Preconditions.checkNotNull((Object)videoId, (Object)"Required parameter videoId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String $Xgafv) {
                return (List)super.set$Xgafv($Xgafv);
            }

            public List setAccessToken(String accessToken) {
                return (List)super.setAccessToken(accessToken);
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setCallback(String callback) {
                return (List)super.setCallback(callback);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUploadType(String uploadType) {
                return (List)super.setUploadType(uploadType);
            }

            public List setUploadProtocol(String uploadProtocol) {
                return (List)super.setUploadProtocol(uploadProtocol);
            }

            public java.util.List<String> getPart() {
                return this.part;
            }

            public List setPart(java.util.List<String> part) {
                this.part = part;
                return this;
            }

            public String getVideoId() {
                return this.videoId;
            }

            public List setVideoId(String videoId) {
                this.videoId = videoId;
                return this;
            }

            public java.util.List<String> getId() {
                return this.id;
            }

            public List setId(java.util.List<String> id) {
                this.id = id;
                return this;
            }

            public String getOnBehalfOf() {
                return this.onBehalfOf;
            }

            public List setOnBehalfOf(String onBehalfOf) {
                this.onBehalfOf = onBehalfOf;
                return this;
            }

            public String getOnBehalfOfContentOwner() {
                return this.onBehalfOfContentOwner;
            }

            public List setOnBehalfOfContentOwner(String onBehalfOfContentOwner) {
                this.onBehalfOfContentOwner = onBehalfOfContentOwner;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class Insert
        extends YouTubeRequest<Caption> {
            private static final String REST_PATH = "youtube/v3/captions";
            @Key
            private java.util.List<String> part;
            @Key
            private String onBehalfOf;
            @Key
            private String onBehalfOfContentOwner;
            @Key
            private Boolean sync;

            protected Insert(java.util.List<String> part, Caption content) {
                super(YouTube.this, "POST", REST_PATH, (Object)content, Caption.class);
                this.part = (java.util.List)Preconditions.checkNotNull(part, (Object)"Required parameter part must be specified.");
            }

            protected Insert(java.util.List<String> part, Caption content, AbstractInputStreamContent mediaContent) {
                super(YouTube.this, "POST", "/upload/" + YouTube.this.getServicePath() + REST_PATH, (Object)content, Caption.class);
                this.part = (java.util.List)Preconditions.checkNotNull(part, (Object)"Required parameter part must be specified.");
                Preconditions.checkNotNull((Object)mediaContent, (Object)"Required parameter mediaContent must be specified.");
                this.initializeMediaUpload(mediaContent);
            }

            public Insert set$Xgafv(String $Xgafv) {
                return (Insert)super.set$Xgafv($Xgafv);
            }

            public Insert setAccessToken(String accessToken) {
                return (Insert)super.setAccessToken(accessToken);
            }

            public Insert setAlt(String alt) {
                return (Insert)super.setAlt(alt);
            }

            public Insert setCallback(String callback) {
                return (Insert)super.setCallback(callback);
            }

            public Insert setFields(String fields) {
                return (Insert)super.setFields(fields);
            }

            public Insert setKey(String key) {
                return (Insert)super.setKey(key);
            }

            public Insert setOauthToken(String oauthToken) {
                return (Insert)super.setOauthToken(oauthToken);
            }

            public Insert setPrettyPrint(Boolean prettyPrint) {
                return (Insert)super.setPrettyPrint(prettyPrint);
            }

            public Insert setQuotaUser(String quotaUser) {
                return (Insert)super.setQuotaUser(quotaUser);
            }

            public Insert setUploadType(String uploadType) {
                return (Insert)super.setUploadType(uploadType);
            }

            public Insert setUploadProtocol(String uploadProtocol) {
                return (Insert)super.setUploadProtocol(uploadProtocol);
            }

            public java.util.List<String> getPart() {
                return this.part;
            }

            public Insert setPart(java.util.List<String> part) {
                this.part = part;
                return this;
            }

            public String getOnBehalfOf() {
                return this.onBehalfOf;
            }

            public Insert setOnBehalfOf(String onBehalfOf) {
                this.onBehalfOf = onBehalfOf;
                return this;
            }

            public String getOnBehalfOfContentOwner() {
                return this.onBehalfOfContentOwner;
            }

            public Insert setOnBehalfOfContentOwner(String onBehalfOfContentOwner) {
                this.onBehalfOfContentOwner = onBehalfOfContentOwner;
                return this;
            }

            public Boolean getSync() {
                return this.sync;
            }

            public Insert setSync(Boolean sync) {
                this.sync = sync;
                return this;
            }

            @Override
            public Insert set(String parameterName, Object value) {
                return (Insert)super.set(parameterName, value);
            }
        }

        public class Download
        extends YouTubeRequest<Void> {
            private static final String REST_PATH = "youtube/v3/captions/{id}";
            @Key
            private String id;
            @Key
            private String onBehalfOf;
            @Key
            private String onBehalfOfContentOwner;
            @Key
            private String tfmt;
            @Key
            private String tlang;

            protected Download(String id) {
                super(YouTube.this, "GET", REST_PATH, null, Void.class);
                this.id = (String)Preconditions.checkNotNull((Object)id, (Object)"Required parameter id must be specified.");
                this.initializeMediaDownload();
            }

            public void executeMediaAndDownloadTo(OutputStream outputStream) throws IOException {
                super.executeMediaAndDownloadTo(outputStream);
            }

            public InputStream executeMediaAsInputStream() throws IOException {
                return super.executeMediaAsInputStream();
            }

            public HttpResponse executeMedia() throws IOException {
                return super.executeMedia();
            }

            public GenericUrl buildHttpRequestUrl() {
                String baseUrl = "media".equals(this.get("alt")) && this.getMediaHttpUploader() == null ? YouTube.this.getRootUrl() + "download/" + YouTube.this.getServicePath() : YouTube.this.getBaseUrl();
                return new GenericUrl(UriTemplate.expand((String)baseUrl, (String)this.getUriTemplate(), (Object)((Object)this), (boolean)true));
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Download set$Xgafv(String $Xgafv) {
                return (Download)super.set$Xgafv($Xgafv);
            }

            public Download setAccessToken(String accessToken) {
                return (Download)super.setAccessToken(accessToken);
            }

            public Download setAlt(String alt) {
                return (Download)super.setAlt(alt);
            }

            public Download setCallback(String callback) {
                return (Download)super.setCallback(callback);
            }

            public Download setFields(String fields) {
                return (Download)super.setFields(fields);
            }

            public Download setKey(String key) {
                return (Download)super.setKey(key);
            }

            public Download setOauthToken(String oauthToken) {
                return (Download)super.setOauthToken(oauthToken);
            }

            public Download setPrettyPrint(Boolean prettyPrint) {
                return (Download)super.setPrettyPrint(prettyPrint);
            }

            public Download setQuotaUser(String quotaUser) {
                return (Download)super.setQuotaUser(quotaUser);
            }

            public Download setUploadType(String uploadType) {
                return (Download)super.setUploadType(uploadType);
            }

            public Download setUploadProtocol(String uploadProtocol) {
                return (Download)super.setUploadProtocol(uploadProtocol);
            }

            public String getId() {
                return this.id;
            }

            public Download setId(String id) {
                this.id = id;
                return this;
            }

            public String getOnBehalfOf() {
                return this.onBehalfOf;
            }

            public Download setOnBehalfOf(String onBehalfOf) {
                this.onBehalfOf = onBehalfOf;
                return this;
            }

            public String getOnBehalfOfContentOwner() {
                return this.onBehalfOfContentOwner;
            }

            public Download setOnBehalfOfContentOwner(String onBehalfOfContentOwner) {
                this.onBehalfOfContentOwner = onBehalfOfContentOwner;
                return this;
            }

            public String getTfmt() {
                return this.tfmt;
            }

            public Download setTfmt(String tfmt) {
                this.tfmt = tfmt;
                return this;
            }

            public String getTlang() {
                return this.tlang;
            }

            public Download setTlang(String tlang) {
                this.tlang = tlang;
                return this;
            }

            @Override
            public Download set(String parameterName, Object value) {
                return (Download)super.set(parameterName, value);
            }
        }

        public class Delete
        extends YouTubeRequest<Void> {
            private static final String REST_PATH = "youtube/v3/captions";
            @Key
            private String id;
            @Key
            private String onBehalfOf;
            @Key
            private String onBehalfOfContentOwner;

            protected Delete(String id) {
                super(YouTube.this, "DELETE", REST_PATH, null, Void.class);
                this.id = (String)Preconditions.checkNotNull((Object)id, (Object)"Required parameter id must be specified.");
            }

            public Delete set$Xgafv(String $Xgafv) {
                return (Delete)super.set$Xgafv($Xgafv);
            }

            public Delete setAccessToken(String accessToken) {
                return (Delete)super.setAccessToken(accessToken);
            }

            public Delete setAlt(String alt) {
                return (Delete)super.setAlt(alt);
            }

            public Delete setCallback(String callback) {
                return (Delete)super.setCallback(callback);
            }

            public Delete setFields(String fields) {
                return (Delete)super.setFields(fields);
            }

            public Delete setKey(String key) {
                return (Delete)super.setKey(key);
            }

            public Delete setOauthToken(String oauthToken) {
                return (Delete)super.setOauthToken(oauthToken);
            }

            public Delete setPrettyPrint(Boolean prettyPrint) {
                return (Delete)super.setPrettyPrint(prettyPrint);
            }

            public Delete setQuotaUser(String quotaUser) {
                return (Delete)super.setQuotaUser(quotaUser);
            }

            public Delete setUploadType(String uploadType) {
                return (Delete)super.setUploadType(uploadType);
            }

            public Delete setUploadProtocol(String uploadProtocol) {
                return (Delete)super.setUploadProtocol(uploadProtocol);
            }

            public String getId() {
                return this.id;
            }

            public Delete setId(String id) {
                this.id = id;
                return this;
            }

            public String getOnBehalfOf() {
                return this.onBehalfOf;
            }

            public Delete setOnBehalfOf(String onBehalfOf) {
                this.onBehalfOf = onBehalfOf;
                return this;
            }

            public String getOnBehalfOfContentOwner() {
                return this.onBehalfOfContentOwner;
            }

            public Delete setOnBehalfOfContentOwner(String onBehalfOfContentOwner) {
                this.onBehalfOfContentOwner = onBehalfOfContentOwner;
                return this;
            }

            @Override
            public Delete set(String parameterName, Object value) {
                return (Delete)super.set(parameterName, value);
            }
        }
    }

    public class Activities {
        public List list(java.util.List<String> part) throws IOException {
            List result = new List(part);
            YouTube.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class List
        extends YouTubeRequest<ActivityListResponse> {
            private static final String REST_PATH = "youtube/v3/activities";
            @Key
            private java.util.List<String> part;
            @Key
            private String channelId;
            @Key
            private Boolean home;
            @Key
            private Long maxResults;
            @Key
            private Boolean mine;
            @Key
            private String pageToken;
            @Key
            private String publishedAfter;
            @Key
            private String publishedBefore;
            @Key
            private String regionCode;

            protected List(java.util.List<String> part) {
                super(YouTube.this, "GET", REST_PATH, null, ActivityListResponse.class);
                this.part = (java.util.List)Preconditions.checkNotNull(part, (Object)"Required parameter part must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String $Xgafv) {
                return (List)super.set$Xgafv($Xgafv);
            }

            public List setAccessToken(String accessToken) {
                return (List)super.setAccessToken(accessToken);
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setCallback(String callback) {
                return (List)super.setCallback(callback);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUploadType(String uploadType) {
                return (List)super.setUploadType(uploadType);
            }

            public List setUploadProtocol(String uploadProtocol) {
                return (List)super.setUploadProtocol(uploadProtocol);
            }

            public java.util.List<String> getPart() {
                return this.part;
            }

            public List setPart(java.util.List<String> part) {
                this.part = part;
                return this;
            }

            public String getChannelId() {
                return this.channelId;
            }

            public List setChannelId(String channelId) {
                this.channelId = channelId;
                return this;
            }

            public Boolean getHome() {
                return this.home;
            }

            public List setHome(Boolean home) {
                this.home = home;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long maxResults) {
                this.maxResults = maxResults;
                return this;
            }

            public Boolean getMine() {
                return this.mine;
            }

            public List setMine(Boolean mine) {
                this.mine = mine;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            public String getPublishedAfter() {
                return this.publishedAfter;
            }

            public List setPublishedAfter(String publishedAfter) {
                this.publishedAfter = publishedAfter;
                return this;
            }

            public String getPublishedBefore() {
                return this.publishedBefore;
            }

            public List setPublishedBefore(String publishedBefore) {
                this.publishedBefore = publishedBefore;
                return this;
            }

            public String getRegionCode() {
                return this.regionCode;
            }

            public List setRegionCode(String regionCode) {
                this.regionCode = regionCode;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }
    }

    public class AbuseReports {
        public Insert insert(List<String> part, AbuseReport content) throws IOException {
            Insert result = new Insert(part, content);
            YouTube.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class Insert
        extends YouTubeRequest<AbuseReport> {
            private static final String REST_PATH = "youtube/v3/abuseReports";
            @Key
            private List<String> part;

            protected Insert(List<String> part, AbuseReport content) {
                super(YouTube.this, "POST", REST_PATH, (Object)content, AbuseReport.class);
                this.part = (List)Preconditions.checkNotNull(part, (Object)"Required parameter part must be specified.");
            }

            public Insert set$Xgafv(String $Xgafv) {
                return (Insert)super.set$Xgafv($Xgafv);
            }

            public Insert setAccessToken(String accessToken) {
                return (Insert)super.setAccessToken(accessToken);
            }

            public Insert setAlt(String alt) {
                return (Insert)super.setAlt(alt);
            }

            public Insert setCallback(String callback) {
                return (Insert)super.setCallback(callback);
            }

            public Insert setFields(String fields) {
                return (Insert)super.setFields(fields);
            }

            public Insert setKey(String key) {
                return (Insert)super.setKey(key);
            }

            public Insert setOauthToken(String oauthToken) {
                return (Insert)super.setOauthToken(oauthToken);
            }

            public Insert setPrettyPrint(Boolean prettyPrint) {
                return (Insert)super.setPrettyPrint(prettyPrint);
            }

            public Insert setQuotaUser(String quotaUser) {
                return (Insert)super.setQuotaUser(quotaUser);
            }

            public Insert setUploadType(String uploadType) {
                return (Insert)super.setUploadType(uploadType);
            }

            public Insert setUploadProtocol(String uploadProtocol) {
                return (Insert)super.setUploadProtocol(uploadProtocol);
            }

            public List<String> getPart() {
                return this.part;
            }

            public Insert setPart(List<String> part) {
                this.part = part;
                return this;
            }

            @Override
            public Insert set(String parameterName, Object value) {
                return (Insert)super.set(parameterName, value);
            }
        }
    }
}

