/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-10-08 17:45:39 UTC)
 * on 2020-02-27 at 14:52:03 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.youtube;

/**
 * Service definition for YouTube (v3).
 *
 * <p>
 * Supports core YouTube features, such as uploading videos, creating and managing playlists, searching for content, and much more.
 * </p>
 *
 * <p>
 * For more information about this service, see the
 * <a href="https://developers.google.com/youtube/v3" target="_blank">API Documentation</a>
 * </p>
 *
 * <p>
 * This service uses {@link YouTubeRequestInitializer} to initialize global parameters via its
 * {@link Builder}.
 * </p>
 *
 * @since 1.3
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public class YouTube extends com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient {

  // Note: Leave this static initializer at the top of the file.
  static {
    com.google.api.client.util.Preconditions.checkState(
        com.google.api.client.googleapis.GoogleUtils.MAJOR_VERSION == 1 &&
        com.google.api.client.googleapis.GoogleUtils.MINOR_VERSION >= 15,
        "You are currently running with version %s of google-api-client. " +
        "You need at least version 1.15 of google-api-client to run version " +
        "1.25.0 of the YouTube Data API library.", com.google.api.client.googleapis.GoogleUtils.VERSION);
  }

  /**
   * The default encoded root URL of the service. This is determined when the library is generated
   * and normally should not be changed.
   *
   * @since 1.7
   */
  public static final String DEFAULT_ROOT_URL = "https://www.googleapis.com/";

  /**
   * The default encoded service path of the service. This is determined when the library is
   * generated and normally should not be changed.
   *
   * @since 1.7
   */
  public static final String DEFAULT_SERVICE_PATH = "youtube/v3/";

  /**
   * The default encoded batch path of the service. This is determined when the library is
   * generated and normally should not be changed.
   *
   * @since 1.23
   */
  public static final String DEFAULT_BATCH_PATH = "batch/youtube/v3";

  /**
   * The default encoded base URL of the service. This is determined when the library is generated
   * and normally should not be changed.
   */
  public static final String DEFAULT_BASE_URL = DEFAULT_ROOT_URL + DEFAULT_SERVICE_PATH;

  /**
   * Constructor.
   *
   * <p>
   * Use {@link Builder} if you need to specify any of the optional parameters.
   * </p>
   *
   * @param transport HTTP transport, which should normally be:
   *        <ul>
   *        <li>Google App Engine:
   *        {@code com.google.api.client.extensions.appengine.http.UrlFetchTransport}</li>
   *        <li>Android: {@code newCompatibleTransport} from
   *        {@code com.google.api.client.extensions.android.http.AndroidHttp}</li>
   *        <li>Java: {@link com.google.api.client.googleapis.javanet.GoogleNetHttpTransport#newTrustedTransport()}
   *        </li>
   *        </ul>
   * @param jsonFactory JSON factory, which may be:
   *        <ul>
   *        <li>Jackson: {@code com.google.api.client.json.jackson2.JacksonFactory}</li>
   *        <li>Google GSON: {@code com.google.api.client.json.gson.GsonFactory}</li>
   *        <li>Android Honeycomb or higher:
   *        {@code com.google.api.client.extensions.android.json.AndroidJsonFactory}</li>
   *        </ul>
   * @param httpRequestInitializer HTTP request initializer or {@code null} for none
   * @since 1.7
   */
  public YouTube(com.google.api.client.http.HttpTransport transport, com.google.api.client.json.JsonFactory jsonFactory,
      com.google.api.client.http.HttpRequestInitializer httpRequestInitializer) {
    this(new Builder(transport, jsonFactory, httpRequestInitializer));
  }

  /**
   * @param builder builder
   */
  YouTube(Builder builder) {
    super(builder);
  }

  @Override
  protected void initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest<?> httpClientRequest) throws java.io.IOException {
    super.initialize(httpClientRequest);
  }

  /**
   * An accessor for creating requests from the Activities collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code YouTube youtube = new YouTube(...);}
   *   {@code YouTube.Activities.List request = youtube.activities().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Activities activities() {
    return new Activities();
  }

  /**
   * The "activities" collection of methods.
   */
  public class Activities {

    /**
     * Posts a bulletin for a specific channel. (The user submitting the request must be authorized to
     * act on the channel's behalf.)
     *
     * Note: Even though an activity resource can contain information about actions like a user rating a
     * video or marking a video as a favorite, you need to use other API methods to generate those
     * activity resources. For example, you would use the API's videos.rate() method to rate a video and
     * the playlistItems.insert() method to mark a video as a favorite.
     *
     * Create a request for the method "activities.insert".
     *
     * This request holds the parameters needed by the youtube server.  After setting any optional
     * parameters, call the {@link Insert#execute()} method to invoke the remote operation.
     *
     * @param part The part parameter serves two purposes in this operation. It identifies the properties that the
     *        write operation will set as well as the properties that the API response will include.
     * @param content the {@link com.google.api.services.youtube.model.Activity}
     * @return the request
     */
    public Insert insert(java.lang.String part, com.google.api.services.youtube.model.Activity content) throws java.io.IOException {
      Insert result = new Insert(part, content);
      initialize(result);
      return result;
    }

    public class Insert extends YouTubeRequest<com.google.api.services.youtube.model.Activity> {

      private static final String REST_PATH = "activities";

      /**
       * Posts a bulletin for a specific channel. (The user submitting the request must be authorized to
       * act on the channel's behalf.)
       *
       * Note: Even though an activity resource can contain information about actions like a user rating
       * a video or marking a video as a favorite, you need to use other API methods to generate those
       * activity resources. For example, you would use the API's videos.rate() method to rate a video
       * and the playlistItems.insert() method to mark a video as a favorite.
       *
       * Create a request for the method "activities.insert".
       *
       * This request holds the parameters needed by the the youtube server.  After setting any optional
       * parameters, call the {@link Insert#execute()} method to invoke the remote operation. <p> {@link
       * Insert#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param part The part parameter serves two purposes in this operation. It identifies the properties that the
     *        write operation will set as well as the properties that the API response will include.
       * @param content the {@link com.google.api.services.youtube.model.Activity}
       * @since 1.13
       */
      protected Insert(java.lang.String part, com.google.api.services.youtube.model.Activity content) {
        super(YouTube.this, "POST", REST_PATH, content, com.google.api.services.youtube.model.Activity.class);
        this.part = com.google.api.client.util.Preconditions.checkNotNull(part, "Required parameter part must be specified.");
      }

      @Override
      public Insert setAlt(java.lang.String alt) {
        return (Insert) super.setAlt(alt);
      }

      @Override
      public Insert setFields(java.lang.String fields) {
        return (Insert) super.setFields(fields);
      }

      @Override
      public Insert setKey(java.lang.String key) {
        return (Insert) super.setKey(key);
      }

      @Override
      public Insert setOauthToken(java.lang.String oauthToken) {
        return (Insert) super.setOauthToken(oauthToken);
      }

      @Override
      public Insert setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Insert) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Insert setQuotaUser(java.lang.String quotaUser) {
        return (Insert) super.setQuotaUser(quotaUser);
      }

      @Override
      public Insert setUserIp(java.lang.String userIp) {
        return (Insert) super.setUserIp(userIp);
      }

      /**
       * The part parameter serves two purposes in this operation. It identifies the properties that
       * the write operation will set as well as the properties that the API response will include.
       */
      @com.google.api.client.util.Key
      private java.lang.String part;

      /** The part parameter serves two purposes in this operation. It identifies the properties that the
     write operation will set as well as the properties that the API response will include.
       */
      public java.lang.String getPart() {
        return part;
      }

      /**
       * The part parameter serves two purposes in this operation. It identifies the properties that
       * the write operation will set as well as the properties that the API response will include.
       */
      public Insert setPart(java.lang.String part) {
        this.part = part;
        return this;
      }

      @Override
      public Insert set(String parameterName, Object value) {
        return (Insert) super.set(parameterName, value);
      }
    }
    /**
     * Returns a list of channel activity events that match the request criteria. For example, you can
     * retrieve events associated with a particular channel, events associated with the user's
     * subscriptions and Google+ friends, or the YouTube home page feed, which is customized for each
     * user.
     *
     * Create a request for the method "activities.list".
     *
     * This request holds the parameters needed by the youtube server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param part The part parameter specifies a comma-separated list of one or more activity resource properties that
     *        the API response will include.
    If the parameter identifies a property that contains child
     *        properties, the child properties will be included in the response. For example, in an
     *        activity resource, the snippet property contains other properties that identify the type
     *        of activity, a display title for the activity, and so forth. If you set part=snippet, the
     *        API response will also contain all of those nested properties.
     * @return the request
     */
    public List list(java.lang.String part) throws java.io.IOException {
      List result = new List(part);
      initialize(result);
      return result;
    }

    public class List extends YouTubeRequest<com.google.api.services.youtube.model.ActivityListResponse> {

      private static final String REST_PATH = "activities";

      /**
       * Returns a list of channel activity events that match the request criteria. For example, you can
       * retrieve events associated with a particular channel, events associated with the user's
       * subscriptions and Google+ friends, or the YouTube home page feed, which is customized for each
       * user.
       *
       * Create a request for the method "activities.list".
       *
       * This request holds the parameters needed by the the youtube server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param part The part parameter specifies a comma-separated list of one or more activity resource properties that
     *        the API response will include.
    If the parameter identifies a property that contains child
     *        properties, the child properties will be included in the response. For example, in an
     *        activity resource, the snippet property contains other properties that identify the type
     *        of activity, a display title for the activity, and so forth. If you set part=snippet, the
     *        API response will also contain all of those nested properties.
       * @since 1.13
       */
      protected List(java.lang.String part) {
        super(YouTube.this, "GET", REST_PATH, null, com.google.api.services.youtube.model.ActivityListResponse.class);
        this.part = com.google.api.client.util.Preconditions.checkNotNull(part, "Required parameter part must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUserIp(java.lang.String userIp) {
        return (List) super.setUserIp(userIp);
      }

      /**
       * The part parameter specifies a comma-separated list of one or more activity resource
       * properties that the API response will include.
       *
       * If the parameter identifies a property that contains child properties, the child properties
       * will be included in the response. For example, in an activity resource, the snippet
       * property contains other properties that identify the type of activity, a display title for
       * the activity, and so forth. If you set part=snippet, the API response will also contain all
       * of those nested properties.
       */
      @com.google.api.client.util.Key
      private java.lang.String part;

      /** The part parameter specifies a comma-separated list of one or more activity resource properties
     that the API response will include.

     If the parameter identifies a property that contains child properties, the child properties will be
     included in the response. For example, in an activity resource, the snippet property contains other
     properties that identify the type of activity, a display title for the activity, and so forth. If
     you set part=snippet, the API response will also contain all of those nested properties.
       */
      public java.lang.String getPart() {
        return part;
      }

      /**
       * The part parameter specifies a comma-separated list of one or more activity resource
       * properties that the API response will include.
       *
       * If the parameter identifies a property that contains child properties, the child properties
       * will be included in the response. For example, in an activity resource, the snippet
       * property contains other properties that identify the type of activity, a display title for
       * the activity, and so forth. If you set part=snippet, the API response will also contain all
       * of those nested properties.
       */
      public List setPart(java.lang.String part) {
        this.part = part;
        return this;
      }

      /**
       * The channelId parameter specifies a unique YouTube channel ID. The API will then return a
       * list of that channel's activities.
       */
      @com.google.api.client.util.Key
      private java.lang.String channelId;

      /** The channelId parameter specifies a unique YouTube channel ID. The API will then return a list of
     that channel's activities.
       */
      public java.lang.String getChannelId() {
        return channelId;
      }

      /**
       * The channelId parameter specifies a unique YouTube channel ID. The API will then return a
       * list of that channel's activities.
       */
      public List setChannelId(java.lang.String channelId) {
        this.channelId = channelId;
        return this;
      }

      /**
       * Set this parameter's value to true to retrieve the activity feed that displays on the
       * YouTube home page for the currently authenticated user.
       */
      @com.google.api.client.util.Key
      private java.lang.Boolean home;

      /** Set this parameter's value to true to retrieve the activity feed that displays on the YouTube home
     page for the currently authenticated user.
       */
      public java.lang.Boolean getHome() {
        return home;
      }

      /**
       * Set this parameter's value to true to retrieve the activity feed that displays on the
       * YouTube home page for the currently authenticated user.
       */
      public List setHome(java.lang.Boolean home) {
        this.home = home;
        return this;
      }

      /**
       * The maxResults parameter specifies the maximum number of items that should be returned in
       * the result set.
       */
      @com.google.api.client.util.Key
      private java.lang.Long maxResults;

      /** The maxResults parameter specifies the maximum number of items that should be returned in the
     result set. [default: 5] [minimum: 0] [maximum: 50]
       */
      public java.lang.Long getMaxResults() {
        return maxResults;
      }

      /**
       * The maxResults parameter specifies the maximum number of items that should be returned in
       * the result set.
       */
      public List setMaxResults(java.lang.Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      /**
       * Set this parameter's value to true to retrieve a feed of the authenticated user's
       * activities.
       */
      @com.google.api.client.util.Key
      private java.lang.Boolean mine;

      /** Set this parameter's value to true to retrieve a feed of the authenticated user's activities.
       */
      public java.lang.Boolean getMine() {
        return mine;
      }

      /**
       * Set this parameter's value to true to retrieve a feed of the authenticated user's
       * activities.
       */
      public List setMine(java.lang.Boolean mine) {
        this.mine = mine;
        return this;
      }

      /**
       * The pageToken parameter identifies a specific page in the result set that should be
       * returned. In an API response, the nextPageToken and prevPageToken properties identify other
       * pages that could be retrieved.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** The pageToken parameter identifies a specific page in the result set that should be returned. In an
     API response, the nextPageToken and prevPageToken properties identify other pages that could be
     retrieved.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * The pageToken parameter identifies a specific page in the result set that should be
       * returned. In an API response, the nextPageToken and prevPageToken properties identify other
       * pages that could be retrieved.
       */
      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      /**
       * The publishedAfter parameter specifies the earliest date and time that an activity could
       * have occurred for that activity to be included in the API response. If the parameter value
       * specifies a day, but not a time, then any activities that occurred that day will be
       * included in the result set. The value is specified in ISO 8601 (YYYY-MM-DDThh:mm:ss.sZ)
       * format.
       */
      @com.google.api.client.util.Key
      private com.google.api.client.util.DateTime publishedAfter;

      /** The publishedAfter parameter specifies the earliest date and time that an activity could have
     occurred for that activity to be included in the API response. If the parameter value specifies a
     day, but not a time, then any activities that occurred that day will be included in the result set.
     The value is specified in ISO 8601 (YYYY-MM-DDThh:mm:ss.sZ) format.
       */
      public com.google.api.client.util.DateTime getPublishedAfter() {
        return publishedAfter;
      }

      /**
       * The publishedAfter parameter specifies the earliest date and time that an activity could
       * have occurred for that activity to be included in the API response. If the parameter value
       * specifies a day, but not a time, then any activities that occurred that day will be
       * included in the result set. The value is specified in ISO 8601 (YYYY-MM-DDThh:mm:ss.sZ)
       * format.
       */
      public List setPublishedAfter(com.google.api.client.util.DateTime publishedAfter) {
        this.publishedAfter = publishedAfter;
        return this;
      }

      /**
       * The publishedBefore parameter specifies the date and time before which an activity must
       * have occurred for that activity to be included in the API response. If the parameter value
       * specifies a day, but not a time, then any activities that occurred that day will be
       * excluded from the result set. The value is specified in ISO 8601 (YYYY-MM-DDThh:mm:ss.sZ)
       * format.
       */
      @com.google.api.client.util.Key
      private com.google.api.client.util.DateTime publishedBefore;

      /** The publishedBefore parameter specifies the date and time before which an activity must have
     occurred for that activity to be included in the API response. If the parameter value specifies a
     day, but not a time, then any activities that occurred that day will be excluded from the result
     set. The value is specified in ISO 8601 (YYYY-MM-DDThh:mm:ss.sZ) format.
       */
      public com.google.api.client.util.DateTime getPublishedBefore() {
        return publishedBefore;
      }

      /**
       * The publishedBefore parameter specifies the date and time before which an activity must
       * have occurred for that activity to be included in the API response. If the parameter value
       * specifies a day, but not a time, then any activities that occurred that day will be
       * excluded from the result set. The value is specified in ISO 8601 (YYYY-MM-DDThh:mm:ss.sZ)
       * format.
       */
      public List setPublishedBefore(com.google.api.client.util.DateTime publishedBefore) {
        this.publishedBefore = publishedBefore;
        return this;
      }

      /**
       * The regionCode parameter instructs the API to return results for the specified country. The
       * parameter value is an ISO 3166-1 alpha-2 country code. YouTube uses this value when the
       * authorized user's previous activity on YouTube does not provide enough information to
       * generate the activity feed.
       */
      @com.google.api.client.util.Key
      private java.lang.String regionCode;

      /** The regionCode parameter instructs the API to return results for the specified country. The
     parameter value is an ISO 3166-1 alpha-2 country code. YouTube uses this value when the authorized
     user's previous activity on YouTube does not provide enough information to generate the activity
     feed.
       */
      public java.lang.String getRegionCode() {
        return regionCode;
      }

      /**
       * The regionCode parameter instructs the API to return results for the specified country. The
       * parameter value is an ISO 3166-1 alpha-2 country code. YouTube uses this value when the
       * authorized user's previous activity on YouTube does not provide enough information to
       * generate the activity feed.
       */
      public List setRegionCode(java.lang.String regionCode) {
        this.regionCode = regionCode;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the Captions collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code YouTube youtube = new YouTube(...);}
   *   {@code YouTube.Captions.List request = youtube.captions().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Captions captions() {
    return new Captions();
  }

  /**
   * The "captions" collection of methods.
   */
  public class Captions {

    /**
     * Deletes a specified caption track.
     *
     * Create a request for the method "captions.delete".
     *
     * This request holds the parameters needed by the youtube server.  After setting any optional
     * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
     *
     * @param id The id parameter identifies the caption track that is being deleted. The value is a caption track ID
     *        as identified by the id property in a caption resource.
     * @return the request
     */
    public Delete delete(java.lang.String id) throws java.io.IOException {
      Delete result = new Delete(id);
      initialize(result);
      return result;
    }

    public class Delete extends YouTubeRequest<Void> {

      private static final String REST_PATH = "captions";

      /**
       * Deletes a specified caption track.
       *
       * Create a request for the method "captions.delete".
       *
       * This request holds the parameters needed by the the youtube server.  After setting any optional
       * parameters, call the {@link Delete#execute()} method to invoke the remote operation. <p> {@link
       * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param id The id parameter identifies the caption track that is being deleted. The value is a caption track ID
     *        as identified by the id property in a caption resource.
       * @since 1.13
       */
      protected Delete(java.lang.String id) {
        super(YouTube.this, "DELETE", REST_PATH, null, Void.class);
        this.id = com.google.api.client.util.Preconditions.checkNotNull(id, "Required parameter id must be specified.");
      }

      @Override
      public Delete setAlt(java.lang.String alt) {
        return (Delete) super.setAlt(alt);
      }

      @Override
      public Delete setFields(java.lang.String fields) {
        return (Delete) super.setFields(fields);
      }

      @Override
      public Delete setKey(java.lang.String key) {
        return (Delete) super.setKey(key);
      }

      @Override
      public Delete setOauthToken(java.lang.String oauthToken) {
        return (Delete) super.setOauthToken(oauthToken);
      }

      @Override
      public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Delete) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Delete setQuotaUser(java.lang.String quotaUser) {
        return (Delete) super.setQuotaUser(quotaUser);
      }

      @Override
      public Delete setUserIp(java.lang.String userIp) {
        return (Delete) super.setUserIp(userIp);
      }

      /**
       * The id parameter identifies the caption track that is being deleted. The value is a caption
       * track ID as identified by the id property in a caption resource.
       */
      @com.google.api.client.util.Key
      private java.lang.String id;

      /** The id parameter identifies the caption track that is being deleted. The value is a caption track
     ID as identified by the id property in a caption resource.
       */
      public java.lang.String getId() {
        return id;
      }

      /**
       * The id parameter identifies the caption track that is being deleted. The value is a caption
       * track ID as identified by the id property in a caption resource.
       */
      public Delete setId(java.lang.String id) {
        this.id = id;
        return this;
      }

      /** ID of the Google+ Page for the channel that the request is be on behalf of */
      @com.google.api.client.util.Key
      private java.lang.String onBehalfOf;

      /** ID of the Google+ Page for the channel that the request is be on behalf of
       */
      public java.lang.String getOnBehalfOf() {
        return onBehalfOf;
      }

      /** ID of the Google+ Page for the channel that the request is be on behalf of */
      public Delete setOnBehalfOf(java.lang.String onBehalfOf) {
        this.onBehalfOf = onBehalfOf;
        return this;
      }

      /**
       * Note: This parameter is intended exclusively for YouTube content partners.
       *
       * The onBehalfOfContentOwner parameter indicates that the request's authorization credentials
       * identify a YouTube CMS user who is acting on behalf of the content owner specified in the
       * parameter value. This parameter is intended for YouTube content partners that own and
       * manage many different YouTube channels. It allows content owners to authenticate once and
       * get access to all their video and channel data, without having to provide authentication
       * credentials for each individual channel. The actual CMS account that the user authenticates
       * with must be linked to the specified YouTube content owner.
       */
      @com.google.api.client.util.Key
      private java.lang.String onBehalfOfContentOwner;

      /** Note: This parameter is intended exclusively for YouTube content partners.

     The onBehalfOfContentOwner parameter indicates that the request's authorization credentials
     identify a YouTube CMS user who is acting on behalf of the content owner specified in the parameter
     value. This parameter is intended for YouTube content partners that own and manage many different
     YouTube channels. It allows content owners to authenticate once and get access to all their video
     and channel data, without having to provide authentication credentials for each individual channel.
     The actual CMS account that the user authenticates with must be linked to the specified YouTube
     content owner.
       */
      public java.lang.String getOnBehalfOfContentOwner() {
        return onBehalfOfContentOwner;
      }

      /**
       * Note: This parameter is intended exclusively for YouTube content partners.
       *
       * The onBehalfOfContentOwner parameter indicates that the request's authorization credentials
       * identify a YouTube CMS user who is acting on behalf of the content owner specified in the
       * parameter value. This parameter is intended for YouTube content partners that own and
       * manage many different YouTube channels. It allows content owners to authenticate once and
       * get access to all their video and channel data, without having to provide authentication
       * credentials for each individual channel. The actual CMS account that the user authenticates
       * with must be linked to the specified YouTube content owner.
       */
      public Delete setOnBehalfOfContentOwner(java.lang.String onBehalfOfContentOwner) {
        this.onBehalfOfContentOwner = onBehalfOfContentOwner;
        return this;
      }

      @Override
      public Delete set(String parameterName, Object value) {
        return (Delete) super.set(parameterName, value);
      }
    }
    /**
     * Downloads a caption track. The caption track is returned in its original format unless the
     * request specifies a value for the tfmt parameter and in its original language unless the request
     * specifies a value for the tlang parameter.
     *
     * Create a request for the method "captions.download".
     *
     * This request holds the parameters needed by the youtube server.  After setting any optional
     * parameters, call the {@link Download#execute()} method to invoke the remote operation.
     *
     * @param id The id parameter identifies the caption track that is being retrieved. The value is a caption track
     *        ID as identified by the id property in a caption resource.
     * @return the request
     */
    public Download download(java.lang.String id) throws java.io.IOException {
      Download result = new Download(id);
      initialize(result);
      return result;
    }

    public class Download extends YouTubeRequest<Void> {

      private static final String REST_PATH = "captions/{id}";

      /**
       * Downloads a caption track. The caption track is returned in its original format unless the
       * request specifies a value for the tfmt parameter and in its original language unless the
       * request specifies a value for the tlang parameter.
       *
       * Create a request for the method "captions.download".
       *
       * This request holds the parameters needed by the the youtube server.  After setting any optional
       * parameters, call the {@link Download#execute()} method to invoke the remote operation. <p>
       * {@link
       * Download#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param id The id parameter identifies the caption track that is being retrieved. The value is a caption track
     *        ID as identified by the id property in a caption resource.
       * @since 1.13
       */
      protected Download(java.lang.String id) {
        super(YouTube.this, "GET", REST_PATH, null, Void.class);
        this.id = com.google.api.client.util.Preconditions.checkNotNull(id, "Required parameter id must be specified.");
        initializeMediaDownload();
      }

      @Override
      public void executeMediaAndDownloadTo(java.io.OutputStream outputStream) throws java.io.IOException {
        super.executeMediaAndDownloadTo(outputStream);
      }

      @Override
      public java.io.InputStream executeMediaAsInputStream() throws java.io.IOException {
        return super.executeMediaAsInputStream();
      }

      @Override
      public com.google.api.client.http.HttpResponse executeMedia() throws java.io.IOException {
        return super.executeMedia();
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Download setAlt(java.lang.String alt) {
        return (Download) super.setAlt(alt);
      }

      @Override
      public Download setFields(java.lang.String fields) {
        return (Download) super.setFields(fields);
      }

      @Override
      public Download setKey(java.lang.String key) {
        return (Download) super.setKey(key);
      }

      @Override
      public Download setOauthToken(java.lang.String oauthToken) {
        return (Download) super.setOauthToken(oauthToken);
      }

      @Override
      public Download setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Download) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Download setQuotaUser(java.lang.String quotaUser) {
        return (Download) super.setQuotaUser(quotaUser);
      }

      @Override
      public Download setUserIp(java.lang.String userIp) {
        return (Download) super.setUserIp(userIp);
      }

      /**
       * The id parameter identifies the caption track that is being retrieved. The value is a
       * caption track ID as identified by the id property in a caption resource.
       */
      @com.google.api.client.util.Key
      private java.lang.String id;

      /** The id parameter identifies the caption track that is being retrieved. The value is a caption track
     ID as identified by the id property in a caption resource.
       */
      public java.lang.String getId() {
        return id;
      }

      /**
       * The id parameter identifies the caption track that is being retrieved. The value is a
       * caption track ID as identified by the id property in a caption resource.
       */
      public Download setId(java.lang.String id) {
        this.id = id;
        return this;
      }

      /** ID of the Google+ Page for the channel that the request is be on behalf of */
      @com.google.api.client.util.Key
      private java.lang.String onBehalfOf;

      /** ID of the Google+ Page for the channel that the request is be on behalf of
       */
      public java.lang.String getOnBehalfOf() {
        return onBehalfOf;
      }

      /** ID of the Google+ Page for the channel that the request is be on behalf of */
      public Download setOnBehalfOf(java.lang.String onBehalfOf) {
        this.onBehalfOf = onBehalfOf;
        return this;
      }

      /**
       * Note: This parameter is intended exclusively for YouTube content partners.
       *
       * The onBehalfOfContentOwner parameter indicates that the request's authorization credentials
       * identify a YouTube CMS user who is acting on behalf of the content owner specified in the
       * parameter value. This parameter is intended for YouTube content partners that own and
       * manage many different YouTube channels. It allows content owners to authenticate once and
       * get access to all their video and channel data, without having to provide authentication
       * credentials for each individual channel. The actual CMS account that the user authenticates
       * with must be linked to the specified YouTube content owner.
       */
      @com.google.api.client.util.Key
      private java.lang.String onBehalfOfContentOwner;

      /** Note: This parameter is intended exclusively for YouTube content partners.

     The onBehalfOfContentOwner parameter indicates that the request's authorization credentials
     identify a YouTube CMS user who is acting on behalf of the content owner specified in the parameter
     value. This parameter is intended for YouTube content partners that own and manage many different
     YouTube channels. It allows content owners to authenticate once and get access to all their video
     and channel data, without having to provide authentication credentials for each individual channel.
     The actual CMS account that the user authenticates with must be linked to the specified YouTube
     content owner.
       */
      public java.lang.String getOnBehalfOfContentOwner() {
        return onBehalfOfContentOwner;
      }

      /**
       * Note: This parameter is intended exclusively for YouTube content partners.
       *
       * The onBehalfOfContentOwner parameter indicates that the request's authorization credentials
       * identify a YouTube CMS user who is acting on behalf of the content owner specified in the
       * parameter value. This parameter is intended for YouTube content partners that own and
       * manage many different YouTube channels. It allows content owners to authenticate once and
       * get access to all their video and channel data, without having to provide authentication
       * credentials for each individual channel. The actual CMS account that the user authenticates
       * with must be linked to the specified YouTube content owner.
       */
      public Download setOnBehalfOfContentOwner(java.lang.String onBehalfOfContentOwner) {
        this.onBehalfOfContentOwner = onBehalfOfContentOwner;
        return this;
      }

      /**
       * The tfmt parameter specifies that the caption track should be returned in a specific
       * format. If the parameter is not included in the request, the track is returned in its
       * original format.
       */
      @com.google.api.client.util.Key
      private java.lang.String tfmt;

      /** The tfmt parameter specifies that the caption track should be returned in a specific format. If the
     parameter is not included in the request, the track is returned in its original format.
       */
      public java.lang.String getTfmt() {
        return tfmt;
      }

      /**
       * The tfmt parameter specifies that the caption track should be returned in a specific
       * format. If the parameter is not included in the request, the track is returned in its
       * original format.
       */
      public Download setTfmt(java.lang.String tfmt) {
        this.tfmt = tfmt;
        return this;
      }

      /**
       * The tlang parameter specifies that the API response should return a translation of the
       * specified caption track. The parameter value is an ISO 639-1 two-letter language code that
       * identifies the desired caption language. The translation is generated by using machine
       * translation, such as Google Translate.
       */
      @com.google.api.client.util.Key
      private java.lang.String tlang;

      /** The tlang parameter specifies that the API response should return a translation of the specified
     caption track. The parameter value is an ISO 639-1 two-letter language code that identifies the
     desired caption language. The translation is generated by using machine translation, such as Google
     Translate.
       */
      public java.lang.String getTlang() {
        return tlang;
      }

      /**
       * The tlang parameter specifies that the API response should return a translation of the
       * specified caption track. The parameter value is an ISO 639-1 two-letter language code that
       * identifies the desired caption language. The translation is generated by using machine
       * translation, such as Google Translate.
       */
      public Download setTlang(java.lang.String tlang) {
        this.tlang = tlang;
        return this;
      }

      @Override
      public Download set(String parameterName, Object value) {
        return (Download) super.set(parameterName, value);
      }
    }
    /**
     * Uploads a caption track.
     *
     * Create a request for the method "captions.insert".
     *
     * This request holds the parameters needed by the youtube server.  After setting any optional
     * parameters, call the {@link Insert#execute()} method to invoke the remote operation.
     *
     * @param part The part parameter specifies the caption resource parts that the API response will include. Set the
     *        parameter value to snippet.
     * @param content the {@link com.google.api.services.youtube.model.Caption}
     * @return the request
     */
    public Insert insert(java.lang.String part, com.google.api.services.youtube.model.Caption content) throws java.io.IOException {
      Insert result = new Insert(part, content);
      initialize(result);
      return result;
    }

    /**
     * Uploads a caption track.
     *
     * Create a request for the method "captions.insert".
     *
     * This request holds the parameters needed by the the youtube server.  After setting any optional
     * parameters, call the {@link Insert#execute()} method to invoke the remote operation.
     *
     * <p>
     * This method should be used for uploading media content.
     * </p>
     *
     * @param part The part parameter specifies the caption resource parts that the API response will include. Set the
     *        parameter value to snippet.
     * @param content the {@link com.google.api.services.youtube.model.Caption} media metadata or {@code null} if none
     * @param mediaContent The media HTTP content or {@code null} if none.
     * @return the request
     * @throws java.io.IOException if the initialization of the request fails
     */
    public Insert insert(java.lang.String part, com.google.api.services.youtube.model.Caption content, com.google.api.client.http.AbstractInputStreamContent mediaContent) throws java.io.IOException {
      Insert result = new Insert(part, content, mediaContent);
      initialize(result);
      return result;
    }

    public class Insert extends YouTubeRequest<com.google.api.services.youtube.model.Caption> {

      private static final String REST_PATH = "captions";

      /**
       * Uploads a caption track.
       *
       * Create a request for the method "captions.insert".
       *
       * This request holds the parameters needed by the the youtube server.  After setting any optional
       * parameters, call the {@link Insert#execute()} method to invoke the remote operation. <p> {@link
       * Insert#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param part The part parameter specifies the caption resource parts that the API response will include. Set the
     *        parameter value to snippet.
       * @param content the {@link com.google.api.services.youtube.model.Caption}
       * @since 1.13
       */
      protected Insert(java.lang.String part, com.google.api.services.youtube.model.Caption content) {
        super(YouTube.this, "POST", REST_PATH, content, com.google.api.services.youtube.model.Caption.class);
        this.part = com.google.api.client.util.Preconditions.checkNotNull(part, "Required parameter part must be specified.");
      }

      /**
       * Uploads a caption track.
       *
       * Create a request for the method "captions.insert".
       *
       * This request holds the parameters needed by the the youtube server.  After setting any optional
       * parameters, call the {@link Insert#execute()} method to invoke the remote operation. <p> {@link
       * Insert#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * <p>
       * This constructor should be used for uploading media content.
       * </p>
       *
       * @param part The part parameter specifies the caption resource parts that the API response will include. Set the
     *        parameter value to snippet.
       * @param content the {@link com.google.api.services.youtube.model.Caption} media metadata or {@code null} if none
       * @param mediaContent The media HTTP content or {@code null} if none.
       * @since 1.13
       */
      protected Insert(java.lang.String part, com.google.api.services.youtube.model.Caption content, com.google.api.client.http.AbstractInputStreamContent mediaContent) {
        super(YouTube.this, "POST", "/upload/" + getServicePath() + REST_PATH, content, com.google.api.services.youtube.model.Caption.class);
        this.part = com.google.api.client.util.Preconditions.checkNotNull(part, "Required parameter part must be specified.");
        initializeMediaUpload(mediaContent);
      }

      @Override
      public Insert setAlt(java.lang.String alt) {
        return (Insert) super.setAlt(alt);
      }

      @Override
      public Insert setFields(java.lang.String fields) {
        return (Insert) super.setFields(fields);
      }

      @Override
      public Insert setKey(java.lang.String key) {
        return (Insert) super.setKey(key);
      }

      @Override
      public Insert setOauthToken(java.lang.String oauthToken) {
        return (Insert) super.setOauthToken(oauthToken);
      }

      @Override
      public Insert setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Insert) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Insert setQuotaUser(java.lang.String quotaUser) {
        return (Insert) super.setQuotaUser(quotaUser);
      }

      @Override
      public Insert setUserIp(java.lang.String userIp) {
        return (Insert) super.setUserIp(userIp);
      }

      /**
       * The part parameter specifies the caption resource parts that the API response will include.
       * Set the parameter value to snippet.
       */
      @com.google.api.client.util.Key
      private java.lang.String part;

      /** The part parameter specifies the caption resource parts that the API response will include. Set the
     parameter value to snippet.
       */
      public java.lang.String getPart() {
        return part;
      }

      /**
       * The part parameter specifies the caption resource parts that the API response will include.
       * Set the parameter value to snippet.
       */
      public Insert setPart(java.lang.String part) {
        this.part = part;
        return this;
      }

      /** ID of the Google+ Page for the channel that the request is be on behalf of */
      @com.google.api.client.util.Key
      private java.lang.String onBehalfOf;

      /** ID of the Google+ Page for the channel that the request is be on behalf of
       */
      public java.lang.String getOnBehalfOf() {
        return onBehalfOf;
      }

      /** ID of the Google+ Page for the channel that the request is be on behalf of */
      public Insert setOnBehalfOf(java.lang.String onBehalfOf) {
        this.onBehalfOf = onBehalfOf;
        return this;
      }

      /**
       * Note: This parameter is intended exclusively for YouTube content partners.
       *
       * The onBehalfOfContentOwner parameter indicates that the request's authorization credentials
       * identify a YouTube CMS user who is acting on behalf of the content owner specified in the
       * parameter value. This parameter is intended for YouTube content partners that own and
       * manage many different YouTube channels. It allows content owners to authenticate once and
       * get access to all their video and channel data, without having to provide authentication
       * credentials for each individual channel. The actual CMS account that the user authenticates
       * with must be linked to the specified YouTube content owner.
       */
      @com.google.api.client.util.Key
      private java.lang.String onBehalfOfContentOwner;

      /** Note: This parameter is intended exclusively for YouTube content partners.

     The onBehalfOfContentOwner parameter indicates that the request's authorization credentials
     identify a YouTube CMS user who is acting on behalf of the content owner specified in the parameter
     value. This parameter is intended for YouTube content partners that own and manage many different
     YouTube channels. It allows content owners to authenticate once and get access to all their video
     and channel data, without having to provide authentication credentials for each individual channel.
     The actual CMS account that the user authenticates with must be linked to the specified YouTube
     content owner.
       */
      public java.lang.String getOnBehalfOfContentOwner() {
        return onBehalfOfContentOwner;
      }

      /**
       * Note: This parameter is intended exclusively for YouTube content partners.
       *
       * The onBehalfOfContentOwner parameter indicates that the request's authorization credentials
       * identify a YouTube CMS user who is acting on behalf of the content owner specified in the
       * parameter value. This parameter is intended for YouTube content partners that own and
       * manage many different YouTube channels. It allows content owners to authenticate once and
       * get access to all their video and channel data, without having to provide authentication
       * credentials for each individual channel. The actual CMS account that the user authenticates
       * with must be linked to the specified YouTube content owner.
       */
      public Insert setOnBehalfOfContentOwner(java.lang.String onBehalfOfContentOwner) {
        this.onBehalfOfContentOwner = onBehalfOfContentOwner;
        return this;
      }

      /**
       * The sync parameter indicates whether YouTube should automatically synchronize the caption
       * file with the audio track of the video. If you set the value to true, YouTube will
       * disregard any time codes that are in the uploaded caption file and generate new time codes
       * for the captions.
       *
       * You should set the sync parameter to true if you are uploading a transcript, which has no
       * time codes, or if you suspect the time codes in your file are incorrect and want YouTube to
       * try to fix them.
       */
      @com.google.api.client.util.Key
      private java.lang.Boolean sync;

      /** The sync parameter indicates whether YouTube should automatically synchronize the caption file with
     the audio track of the video. If you set the value to true, YouTube will disregard any time codes
     that are in the uploaded caption file and generate new time codes for the captions.

     You should set the sync parameter to true if you are uploading a transcript, which has no time
     codes, or if you suspect the time codes in your file are incorrect and want YouTube to try to fix
     them.
       */
      public java.lang.Boolean getSync() {
        return sync;
      }

      /**
       * The sync parameter indicates whether YouTube should automatically synchronize the caption
       * file with the audio track of the video. If you set the value to true, YouTube will
       * disregard any time codes that are in the uploaded caption file and generate new time codes
       * for the captions.
       *
       * You should set the sync parameter to true if you are uploading a transcript, which has no
       * time codes, or if you suspect the time codes in your file are incorrect and want YouTube to
       * try to fix them.
       */
      public Insert setSync(java.lang.Boolean sync) {
        this.sync = sync;
        return this;
      }

      @Override
      public Insert set(String parameterName, Object value) {
        return (Insert) super.set(parameterName, value);
      }
    }
    /**
     * Returns a list of caption tracks that are associated with a specified video. Note that the API
     * response does not contain the actual captions and that the captions.download method provides the
     * ability to retrieve a caption track.
     *
     * Create a request for the method "captions.list".
     *
     * This request holds the parameters needed by the youtube server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param part The part parameter specifies a comma-separated list of one or more caption resource parts that the
     *        API response will include. The part names that you can include in the parameter value are
     *        id and snippet.
     * @param videoId The videoId parameter specifies the YouTube video ID of the video for which the API should return
     *        caption tracks.
     * @return the request
     */
    public List list(java.lang.String part, java.lang.String videoId) throws java.io.IOException {
      List result = new List(part, videoId);
      initialize(result);
      return result;
    }

    public class List extends YouTubeRequest<com.google.api.services.youtube.model.CaptionListResponse> {

      private static final String REST_PATH = "captions";

      /**
       * Returns a list of caption tracks that are associated with a specified video. Note that the API
       * response does not contain the actual captions and that the captions.download method provides
       * the ability to retrieve a caption track.
       *
       * Create a request for the method "captions.list".
       *
       * This request holds the parameters needed by the the youtube server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param part The part parameter specifies a comma-separated list of one or more caption resource parts that the
     *        API response will include. The part names that you can include in the parameter value are
     *        id and snippet.
       * @param videoId The videoId parameter specifies the YouTube video ID of the video for which the API should return
     *        caption tracks.
       * @since 1.13
       */
      protected List(java.lang.String part, java.lang.String videoId) {
        super(YouTube.this, "GET", REST_PATH, null, com.google.api.services.youtube.model.CaptionListResponse.class);
        this.part = com.google.api.client.util.Preconditions.checkNotNull(part, "Required parameter part must be specified.");
        this.videoId = com.google.api.client.util.Preconditions.checkNotNull(videoId, "Required parameter videoId must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUserIp(java.lang.String userIp) {
        return (List) super.setUserIp(userIp);
      }

      /**
       * The part parameter specifies a comma-separated list of one or more caption resource parts
       * that the API response will include. The part names that you can include in the parameter
       * value are id and snippet.
       */
      @com.google.api.client.util.Key
      private java.lang.String part;

      /** The part parameter specifies a comma-separated list of one or more caption resource parts that the
     API response will include. The part names that you can include in the parameter value are id and
     snippet.
       */
      public java.lang.String getPart() {
        return part;
      }

      /**
       * The part parameter specifies a comma-separated list of one or more caption resource parts
       * that the API response will include. The part names that you can include in the parameter
       * value are id and snippet.
       */
      public List setPart(java.lang.String part) {
        this.part = part;
        return this;
      }

      /**
       * The videoId parameter specifies the YouTube video ID of the video for which the API should
       * return caption tracks.
       */
      @com.google.api.client.util.Key
      private java.lang.String videoId;

      /** The videoId parameter specifies the YouTube video ID of the video for which the API should return
     caption tracks.
       */
      public java.lang.String getVideoId() {
        return videoId;
      }

      /**
       * The videoId parameter specifies the YouTube video ID of the video for which the API should
       * return caption tracks.
       */
      public List setVideoId(java.lang.String videoId) {
        this.videoId = videoId;
        return this;
      }

      /**
       * The id parameter specifies a comma-separated list of IDs that identify the caption
       * resources that should be retrieved. Each ID must identify a caption track associated with
       * the specified video.
       */
      @com.google.api.client.util.Key
      private java.lang.String id;

      /** The id parameter specifies a comma-separated list of IDs that identify the caption resources that
     should be retrieved. Each ID must identify a caption track associated with the specified video.
       */
      public java.lang.String getId() {
        return id;
      }

      /**
       * The id parameter specifies a comma-separated list of IDs that identify the caption
       * resources that should be retrieved. Each ID must identify a caption track associated with
       * the specified video.
       */
      public List setId(java.lang.String id) {
        this.id = id;
        return this;
      }

      /** ID of the Google+ Page for the channel that the request is on behalf of. */
      @com.google.api.client.util.Key
      private java.lang.String onBehalfOf;

      /** ID of the Google+ Page for the channel that the request is on behalf of.
       */
      public java.lang.String getOnBehalfOf() {
        return onBehalfOf;
      }

      /** ID of the Google+ Page for the channel that the request is on behalf of. */
      public List setOnBehalfOf(java.lang.String onBehalfOf) {
        this.onBehalfOf = onBehalfOf;
        return this;
      }

      /**
       * Note: This parameter is intended exclusively for YouTube content partners.
       *
       * The onBehalfOfContentOwner parameter indicates that the request's authorization credentials
       * identify a YouTube CMS user who is acting on behalf of the content owner specified in the
       * parameter value. This parameter is intended for YouTube content partners that own and
       * manage many different YouTube channels. It allows content owners to authenticate once and
       * get access to all their video and channel data, without having to provide authentication
       * credentials for each individual channel. The actual CMS account that the user authenticates
       * with must be linked to the specified YouTube content owner.
       */
      @com.google.api.client.util.Key
      private java.lang.String onBehalfOfContentOwner;

      /** Note: This parameter is intended exclusively for YouTube content partners.

     The onBehalfOfContentOwner parameter indicates that the request's authorization credentials
     identify a YouTube CMS user who is acting on behalf of the content owner specified in the parameter
     value. This parameter is intended for YouTube content partners that own and manage many different
     YouTube channels. It allows content owners to authenticate once and get access to all their video
     and channel data, without having to provide authentication credentials for each individual channel.
     The actual CMS account that the user authenticates with must be linked to the specified YouTube
     content owner.
       */
      public java.lang.String getOnBehalfOfContentOwner() {
        return onBehalfOfContentOwner;
      }

      /**
       * Note: This parameter is intended exclusively for YouTube content partners.
       *
       * The onBehalfOfContentOwner parameter indicates that the request's authorization credentials
       * identify a YouTube CMS user who is acting on behalf of the content owner specified in the
       * parameter value. This parameter is intended for YouTube content partners that own and
       * manage many different YouTube channels. It allows content owners to authenticate once and
       * get access to all their video and channel data, without having to provide authentication
       * credentials for each individual channel. The actual CMS account that the user authenticates
       * with must be linked to the specified YouTube content owner.
       */
      public List setOnBehalfOfContentOwner(java.lang.String onBehalfOfContentOwner) {
        this.onBehalfOfContentOwner = onBehalfOfContentOwner;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }
    /**
     * Updates a caption track. When updating a caption track, you can change the track's draft status,
     * upload a new caption file for the track, or both.
     *
     * Create a request for the method "captions.update".
     *
     * This request holds the parameters needed by the youtube server.  After setting any optional
     * parameters, call the {@link Update#execute()} method to invoke the remote operation.
     *
     * @param part The part parameter serves two purposes in this operation. It identifies the properties that the
     *        write operation will set as well as the properties that the API response will include. Set
     *        the property value to snippet if you are updating the track's draft status. Otherwise, set
     *        the property value to id.
     * @param content the {@link com.google.api.services.youtube.model.Caption}
     * @return the request
     */
    public Update update(java.lang.String part, com.google.api.services.youtube.model.Caption content) throws java.io.IOException {
      Update result = new Update(part, content);
      initialize(result);
      return result;
    }

    /**
     * Updates a caption track. When updating a caption track, you can change the track's draft status,
     * upload a new caption file for the track, or both.
     *
     * Create a request for the method "captions.update".
     *
     * This request holds the parameters needed by the the youtube server.  After setting any optional
     * parameters, call the {@link Update#execute()} method to invoke the remote operation.
     *
     * <p>
     * This method should be used for uploading media content.
     * </p>
     *
     * @param part The part parameter serves two purposes in this operation. It identifies the properties that the
     *        write operation will set as well as the properties that the API response will include. Set
     *        the property value to snippet if you are updating the track's draft status. Otherwise, set
     *        the property value to id.
     * @param content the {@link com.google.api.services.youtube.model.Caption} media metadata or {@code null} if none
     * @param mediaContent The media HTTP content or {@code null} if none.
     * @return the request
     * @throws java.io.IOException if the initialization of the request fails
     */
    public Update update(java.lang.String part, com.google.api.services.youtube.model.Caption content, com.google.api.client.http.AbstractInputStreamContent mediaContent) throws java.io.IOException {
      Update result = new Update(part, content, mediaContent);
      initialize(result);
      return result;
    }

    public class Update extends YouTubeRequest<com.google.api.services.youtube.model.Caption> {

      private static final String REST_PATH = "captions";

      /**
       * Updates a caption track. When updating a caption track, you can change the track's draft
       * status, upload a new caption file for the track, or both.
       *
       * Create a request for the method "captions.update".
       *
       * This request holds the parameters needed by the the youtube server.  After setting any optional
       * parameters, call the {@link Update#execute()} method to invoke the remote operation. <p> {@link
       * Update#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param part The part parameter serves two purposes in this operation. It identifies the properties that the
     *        write operation will set as well as the properties that the API response will include. Set
     *        the property value to snippet if you are updating the track's draft status. Otherwise, set
     *        the property value to id.
       * @param content the {@link com.google.api.services.youtube.model.Caption}
       * @since 1.13
       */
      protected Update(java.lang.String part, com.google.api.services.youtube.model.Caption content) {
        super(YouTube.this, "PUT", REST_PATH, content, com.google.api.services.youtube.model.Caption.class);
        this.part = com.google.api.client.util.Preconditions.checkNotNull(part, "Required parameter part must be specified.");
        checkRequiredParameter(content, "content");
        checkRequiredParameter(content.getId(), "Caption.getId()");
      }

      /**
       * Updates a caption track. When updating a caption track, you can change the track's draft
       * status, upload a new caption file for the track, or both.
       *
       * Create a request for the method "captions.update".
       *
       * This request holds the parameters needed by the the youtube server.  After setting any optional
       * parameters, call the {@link Update#execute()} method to invoke the remote operation. <p> {@link
       * Update#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * <p>
       * This constructor should be used for uploading media content.
       * </p>
       *
       * @param part The part parameter serves two purposes in this operation. It identifies the properties that the
     *        write operation will set as well as the properties that the API response will include. Set
     *        the property value to snippet if you are updating the track's draft status. Otherwise, set
     *        the property value to id.
       * @param content the {@link com.google.api.services.youtube.model.Caption} media metadata or {@code null} if none
       * @param mediaContent The media HTTP content or {@code null} if none.
       * @since 1.13
       */
      protected Update(java.lang.String part, com.google.api.services.youtube.model.Caption content, com.google.api.client.http.AbstractInputStreamContent mediaContent) {
        super(YouTube.this, "PUT", "/upload/" + getServicePath() + REST_PATH, content, com.google.api.services.youtube.model.Caption.class);
        this.part = com.google.api.client.util.Preconditions.checkNotNull(part, "Required parameter part must be specified.");
        initializeMediaUpload(mediaContent);
      }

      @Override
      public Update setAlt(java.lang.String alt) {
        return (Update) super.setAlt(alt);
      }

      @Override
      public Update setFields(java.lang.String fields) {
        return (Update) super.setFields(fields);
      }

      @Override
      public Update setKey(java.lang.String key) {
        return (Update) super.setKey(key);
      }

      @Override
      public Update setOauthToken(java.lang.String oauthToken) {
        return (Update) super.setOauthToken(oauthToken);
      }

      @Override
      public Update setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Update) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Update setQuotaUser(java.lang.String quotaUser) {
        return (Update) super.setQuotaUser(quotaUser);
      }

      @Override
      public Update setUserIp(java.lang.String userIp) {
        return (Update) super.setUserIp(userIp);
      }

      /**
       * The part parameter serves two purposes in this operation. It identifies the properties that
       * the write operation will set as well as the properties that the API response will include.
       * Set the property value to snippet if you are updating the track's draft status. Otherwise,
       * set the property value to id.
       */
      @com.google.api.client.util.Key
      private java.lang.String part;

      /** The part parameter serves two purposes in this operation. It identifies the properties that the
     write operation will set as well as the properties that the API response will include. Set the
     property value to snippet if you are updating the track's draft status. Otherwise, set the property
     value to id.
       */
      public java.lang.String getPart() {
        return part;
      }

      /**
       * The part parameter serves two purposes in this operation. It identifies the properties that
       * the write operation will set as well as the properties that the API response will include.
       * Set the property value to snippet if you are updating the track's draft status. Otherwise,
       * set the property value to id.
       */
      public Update setPart(java.lang.String part) {
        this.part = part;
        return this;
      }

      /** ID of the Google+ Page for the channel that the request is be on behalf of */
      @com.google.api.client.util.Key
      private java.lang.String onBehalfOf;

      /** ID of the Google+ Page for the channel that the request is be on behalf of
       */
      public java.lang.String getOnBehalfOf() {
        return onBehalfOf;
      }

      /** ID of the Google+ Page for the channel that the request is be on behalf of */
      public Update setOnBehalfOf(java.lang.String onBehalfOf) {
        this.onBehalfOf = onBehalfOf;
        return this;
      }

      /**
       * Note: This parameter is intended exclusively for YouTube content partners.
       *
       * The onBehalfOfContentOwner parameter indicates that the request's authorization credentials
       * identify a YouTube CMS user who is acting on behalf of the content owner specified in the
       * parameter value. This parameter is intended for YouTube content partners that own and
       * manage many different YouTube channels. It allows content owners to authenticate once and
       * get access to all their video and channel data, without having to provide authentication
       * credentials for each individual channel. The actual CMS account that the user authenticates
       * with must be linked to the specified YouTube content owner.
       */
      @com.google.api.client.util.Key
      private java.lang.String onBehalfOfContentOwner;

      /** Note: This parameter is intended exclusively for YouTube content partners.

     The onBehalfOfContentOwner parameter indicates that the request's authorization credentials
     identify a YouTube CMS user who is acting on behalf of the content owner specified in the parameter
     value. This parameter is intended for YouTube content partners that own and manage many different
     YouTube channels. It allows content owners to authenticate once and get access to all their video
     and channel data, without having to provide authentication credentials for each individual channel.
     The actual CMS account that the user authenticates with must be linked to the specified YouTube
     content owner.
       */
      public java.lang.String getOnBehalfOfContentOwner() {
        return onBehalfOfContentOwner;
      }

      /**
       * Note: This parameter is intended exclusively for YouTube content partners.
       *
       * The onBehalfOfContentOwner parameter indicates that the request's authorization credentials
       * identify a YouTube CMS user who is acting on behalf of the content owner specified in the
       * parameter value. This parameter is intended for YouTube content partners that own and
       * manage many different YouTube channels. It allows content owners to authenticate once and
       * get access to all their video and channel data, without having to provide authentication
       * credentials for each individual channel. The actual CMS account that the user authenticates
       * with must be linked to the specified YouTube content owner.
       */
      public Update setOnBehalfOfContentOwner(java.lang.String onBehalfOfContentOwner) {
        this.onBehalfOfContentOwner = onBehalfOfContentOwner;
        return this;
      }

      /**
       * Note: The API server only processes the parameter value if the request contains an updated
       * caption file.
       *
       * The sync parameter indicates whether YouTube should automatically synchronize the caption
       * file with the audio track of the video. If you set the value to true, YouTube will
       * automatically synchronize the caption track with the audio track.
       */
      @com.google.api.client.util.Key
      private java.lang.Boolean sync;

      /** Note: The API server only processes the parameter value if the request contains an updated caption
     file.

     The sync parameter indicates whether YouTube should automatically synchronize the caption file with
     the audio track of the video. If you set the value to true, YouTube will automatically synchronize
     the caption track with the audio track.
       */
      public java.lang.Boolean getSync() {
        return sync;
      }

      /**
       * Note: The API server only processes the parameter value if the request contains an updated
       * caption file.
       *
       * The sync parameter indicates whether YouTube should automatically synchronize the caption
       * file with the audio track of the video. If you set the value to true, YouTube will
       * automatically synchronize the caption track with the audio track.
       */
      public Update setSync(java.lang.Boolean sync) {
        this.sync = sync;
        return this;
      }

      @Override
      public Update set(String parameterName, Object value) {
        return (Update) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the ChannelBanners collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code YouTube youtube = new YouTube(...);}
   *   {@code YouTube.ChannelBanners.List request = youtube.channelBanners().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public ChannelBanners channelBanners() {
    return new ChannelBanners();
  }

  /**
   * The "channelBanners" collection of methods.
   */
  public class ChannelBanners {

    /**
     * Uploads a channel banner image to YouTube. This method represents the first two steps in a three-
     * step process to update the banner image for a channel:
     *
     * - Call the channelBanners.insert method to upload the binary image data to YouTube. The image
     * must have a 16:9 aspect ratio and be at least 2120x1192 pixels. - Extract the url property's
     * value from the response that the API returns for step 1. - Call the channels.update method to
     * update the channel's branding settings. Set the brandingSettings.image.bannerExternalUrl
     * property's value to the URL obtained in step 2.
     *
     * Create a request for the method "channelBanners.insert".
     *
     * This request holds the parameters needed by the youtube server.  After setting any optional
     * parameters, call the {@link Insert#execute()} method to invoke the remote operation.
     *
     * @param content the {@link com.google.api.services.youtube.model.ChannelBannerResource}
     * @return the request
     */
    public Insert insert(com.google.api.services.youtube.model.ChannelBannerResource content) throws java.io.IOException {
      Insert result = new Insert(content);
      initialize(result);
      return result;
    }

    /**
     * Uploads a channel banner image to YouTube. This method represents the first two steps in a three-
     * step process to update the banner image for a channel:
     *
     * - Call the channelBanners.insert method to upload the binary image data to YouTube. The image
     * must have a 16:9 aspect ratio and be at least 2120x1192 pixels. - Extract the url property's
     * value from the response that the API returns for step 1. - Call the channels.update method to
     * update the channel's branding settings. Set the brandingSettings.image.bannerExternalUrl
     * property's value to the URL obtained in step 2.
     *
     * Create a request for the method "channelBanners.insert".
     *
     * This request holds the parameters needed by the the youtube server.  After setting any optional
     * parameters, call the {@link Insert#execute()} method to invoke the remote operation.
     *
     * <p>
     * This method should be used for uploading media content.
     * </p>
     *
     *
     * @param content the {@link com.google.api.services.youtube.model.ChannelBannerResource} media metadata or {@code null} if none
     * @param mediaContent The media HTTP content or {@code null} if none.
     * @return the request
     * @throws java.io.IOException if the initialization of the request fails
     */
    public Insert insert(com.google.api.services.youtube.model.ChannelBannerResource content, com.google.api.client.http.AbstractInputStreamContent mediaContent) throws java.io.IOException {
      Insert result = new Insert(content, mediaContent);
      initialize(result);
      return result;
    }

    public class Insert extends YouTubeRequest<com.google.api.services.youtube.model.ChannelBannerResource> {

      private static final String REST_PATH = "channelBanners/insert";

      /**
       * Uploads a channel banner image to YouTube. This method represents the first two steps in a
       * three-step process to update the banner image for a channel:
       *
       * - Call the channelBanners.insert method to upload the binary image data to YouTube. The image
       * must have a 16:9 aspect ratio and be at least 2120x1192 pixels. - Extract the url property's
       * value from the response that the API returns for step 1. - Call the channels.update method to
       * update the channel's branding settings. Set the brandingSettings.image.bannerExternalUrl
       * property's value to the URL obtained in step 2.
       *
       * Create a request for the method "channelBanners.insert".
       *
       * This request holds the parameters needed by the the youtube server.  After setting any optional
       * parameters, call the {@link Insert#execute()} method to invoke the remote operation. <p> {@link
       * Insert#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param content the {@link com.google.api.services.youtube.model.ChannelBannerResource}
       * @since 1.13
       */
      protected Insert(com.google.api.services.youtube.model.ChannelBannerResource content) {
        super(YouTube.this, "POST", REST_PATH, content, com.google.api.services.youtube.model.ChannelBannerResource.class);
      }

      /**
       * Uploads a channel banner image to YouTube. This method represents the first two steps in a
       * three-step process to update the banner image for a channel:
       *
       * - Call the channelBanners.insert method to upload the binary image data to YouTube. The image
       * must have a 16:9 aspect ratio and be at least 2120x1192 pixels. - Extract the url property's
       * value from the response that the API returns for step 1. - Call the channels.update method to
       * update the channel's branding settings. Set the brandingSettings.image.bannerExternalUrl
       * property's value to the URL obtained in step 2.
       *
       * Create a request for the method "channelBanners.insert".
       *
       * This request holds the parameters needed by the the youtube server.  After setting any optional
       * parameters, call the {@link Insert#execute()} method to invoke the remote operation. <p> {@link
       * Insert#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * <p>
       * This constructor should be used for uploading media content.
       * </p>
       *
       *
       * @param content the {@link com.google.api.services.youtube.model.ChannelBannerResource} media metadata or {@code null} if none
       * @param mediaContent The media HTTP content or {@code null} if none.
       * @since 1.13
       */
      protected Insert(com.google.api.services.youtube.model.ChannelBannerResource content, com.google.api.client.http.AbstractInputStreamContent mediaContent) {
        super(YouTube.this, "POST", "/upload/" + getServicePath() + REST_PATH, content, com.google.api.services.youtube.model.ChannelBannerResource.class);
        initializeMediaUpload(mediaContent);
      }

      @Override
      public Insert setAlt(java.lang.String alt) {
        return (Insert) super.setAlt(alt);
      }

      @Override
      public Insert setFields(java.lang.String fields) {
        return (Insert) super.setFields(fields);
      }

      @Override
      public Insert setKey(java.lang.String key) {
        return (Insert) super.setKey(key);
      }

      @Override
      public Insert setOauthToken(java.lang.String oauthToken) {
        return (Insert) super.setOauthToken(oauthToken);
      }

      @Override
      public Insert setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Insert) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Insert setQuotaUser(java.lang.String quotaUser) {
        return (Insert) super.setQuotaUser(quotaUser);
      }

      @Override
      public Insert setUserIp(java.lang.String userIp) {
        return (Insert) super.setUserIp(userIp);
      }

      /**
       * The channelId parameter identifies the YouTube channel to which the banner is uploaded. The
       * channelId parameter was introduced as a required parameter in May 2017. As this was a
       * backward-incompatible change, channelBanners.insert requests that do not specify this
       * parameter will not return an error until six months have passed from the time that the
       * parameter was introduced. Please see the API Terms of Service for the official policy
       * regarding backward incompatible changes and the API revision history for the exact date
       * that the parameter was introduced.
       */
      @com.google.api.client.util.Key
      private java.lang.String channelId;

      /** The channelId parameter identifies the YouTube channel to which the banner is uploaded. The
     channelId parameter was introduced as a required parameter in May 2017. As this was a backward-
     incompatible change, channelBanners.insert requests that do not specify this parameter will not
     return an error until six months have passed from the time that the parameter was introduced.
     Please see the API Terms of Service for the official policy regarding backward incompatible changes
     and the API revision history for the exact date that the parameter was introduced.
       */
      public java.lang.String getChannelId() {
        return channelId;
      }

      /**
       * The channelId parameter identifies the YouTube channel to which the banner is uploaded. The
       * channelId parameter was introduced as a required parameter in May 2017. As this was a
       * backward-incompatible change, channelBanners.insert requests that do not specify this
       * parameter will not return an error until six months have passed from the time that the
       * parameter was introduced. Please see the API Terms of Service for the official policy
       * regarding backward incompatible changes and the API revision history for the exact date
       * that the parameter was introduced.
       */
      public Insert setChannelId(java.lang.String channelId) {
        this.channelId = channelId;
        return this;
      }

      /**
       * Note: This parameter is intended exclusively for YouTube content partners.
       *
       * The onBehalfOfContentOwner parameter indicates that the request's authorization credentials
       * identify a YouTube CMS user who is acting on behalf of the content owner specified in the
       * parameter value. This parameter is intended for YouTube content partners that own and
       * manage many different YouTube channels. It allows content owners to authenticate once and
       * get access to all their video and channel data, without having to provide authentication
       * credentials for each individual channel. The CMS account that the user authenticates with
       * must be linked to the specified YouTube content owner.
       */
      @com.google.api.client.util.Key
      private java.lang.String onBehalfOfContentOwner;

      /** Note: This parameter is intended exclusively for YouTube content partners.

     The onBehalfOfContentOwner parameter indicates that the request's authorization credentials
     identify a YouTube CMS user who is acting on behalf of the content owner specified in the parameter
     value. This parameter is intended for YouTube content partners that own and manage many different
     YouTube channels. It allows content owners to authenticate once and get access to all their video
     and channel data, without having to provide authentication credentials for each individual channel.
     The CMS account that the user authenticates with must be linked to the specified YouTube content
     owner.
       */
      public java.lang.String getOnBehalfOfContentOwner() {
        return onBehalfOfContentOwner;
      }

      /**
       * Note: This parameter is intended exclusively for YouTube content partners.
       *
       * The onBehalfOfContentOwner parameter indicates that the request's authorization credentials
       * identify a YouTube CMS user who is acting on behalf of the content owner specified in the
       * parameter value. This parameter is intended for YouTube content partners that own and
       * manage many different YouTube channels. It allows content owners to authenticate once and
       * get access to all their video and channel data, without having to provide authentication
       * credentials for each individual channel. The CMS account that the user authenticates with
       * must be linked to the specified YouTube content owner.
       */
      public Insert setOnBehalfOfContentOwner(java.lang.String onBehalfOfContentOwner) {
        this.onBehalfOfContentOwner = onBehalfOfContentOwner;
        return this;
      }

      @Override
      public Insert set(String parameterName, Object value) {
        return (Insert) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the ChannelSections collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code YouTube youtube = new YouTube(...);}
   *   {@code YouTube.ChannelSections.List request = youtube.channelSections().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public ChannelSections channelSections() {
    return new ChannelSections();
  }

  /**
   * The "channelSections" collection of methods.
   */
  public class ChannelSections {

    /**
     * Deletes a channelSection.
     *
     * Create a request for the method "channelSections.delete".
     *
     * This request holds the parameters needed by the youtube server.  After setting any optional
     * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
     *
     * @param id The id parameter specifies the YouTube channelSection ID for the resource that is being deleted. In
     *        a channelSection resource, the id property specifies the YouTube channelSection ID.
     * @return the request
     */
    public Delete delete(java.lang.String id) throws java.io.IOException {
      Delete result = new Delete(id);
      initialize(result);
      return result;
    }

    public class Delete extends YouTubeRequest<Void> {

      private static final String REST_PATH = "channelSections";

      /**
       * Deletes a channelSection.
       *
       * Create a request for the method "channelSections.delete".
       *
       * This request holds the parameters needed by the the youtube server.  After setting any optional
       * parameters, call the {@link Delete#execute()} method to invoke the remote operation. <p> {@link
       * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param id The id parameter specifies the YouTube channelSection ID for the resource that is being deleted. In
     *        a channelSection resource, the id property specifies the YouTube channelSection ID.
       * @since 1.13
       */
      protected Delete(java.lang.String id) {
        super(YouTube.this, "DELETE", REST_PATH, null, Void.class);
        this.id = com.google.api.client.util.Preconditions.checkNotNull(id, "Required parameter id must be specified.");
      }

      @Override
      public Delete setAlt(java.lang.String alt) {
        return (Delete) super.setAlt(alt);
      }

      @Override
      public Delete setFields(java.lang.String fields) {
        return (Delete) super.setFields(fields);
      }

      @Override
      public Delete setKey(java.lang.String key) {
        return (Delete) super.setKey(key);
      }

      @Override
      public Delete setOauthToken(java.lang.String oauthToken) {
        return (Delete) super.setOauthToken(oauthToken);
      }

      @Override
      public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Delete) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Delete setQuotaUser(java.lang.String quotaUser) {
        return (Delete) super.setQuotaUser(quotaUser);
      }

      @Override
      public Delete setUserIp(java.lang.String userIp) {
        return (Delete) super.setUserIp(userIp);
      }

      /**
       * The id parameter specifies the YouTube channelSection ID for the resource that is being
       * deleted. In a channelSection resource, the id property specifies the YouTube channelSection
       * ID.
       */
      @com.google.api.client.util.Key
      private java.lang.String id;

      /** The id parameter specifies the YouTube channelSection ID for the resource that is being deleted. In
     a channelSection resource, the id property specifies the YouTube channelSection ID.
       */
      public java.lang.String getId() {
        return id;
      }

      /**
       * The id parameter specifies the YouTube channelSection ID for the resource that is being
       * deleted. In a channelSection resource, the id property specifies the YouTube channelSection
       * ID.
       */
      public Delete setId(java.lang.String id) {
        this.id = id;
        return this;
      }

      /**
       * Note: This parameter is intended exclusively for YouTube content partners.
       *
       * The onBehalfOfContentOwner parameter indicates that the request's authorization credentials
       * identify a YouTube CMS user who is acting on behalf of the content owner specified in the
       * parameter value. This parameter is intended for YouTube content partners that own and
       * manage many different YouTube channels. It allows content owners to authenticate once and
       * get access to all their video and channel data, without having to provide authentication
       * credentials for each individual channel. The CMS account that the user authenticates with
       * must be linked to the specified YouTube content owner.
       */
      @com.google.api.client.util.Key
      private java.lang.String onBehalfOfContentOwner;

      /** Note: This parameter is intended exclusively for YouTube content partners.

     The onBehalfOfContentOwner parameter indicates that the request's authorization credentials
     identify a YouTube CMS user who is acting on behalf of the content owner specified in the parameter
     value. This parameter is intended for YouTube content partners that own and manage many different
     YouTube channels. It allows content owners to authenticate once and get access to all their video
     and channel data, without having to provide authentication credentials for each individual channel.
     The CMS account that the user authenticates with must be linked to the specified YouTube content
     owner.
       */
      public java.lang.String getOnBehalfOfContentOwner() {
        return onBehalfOfContentOwner;
      }

      /**
       * Note: This parameter is intended exclusively for YouTube content partners.
       *
       * The onBehalfOfContentOwner parameter indicates that the request's authorization credentials
       * identify a YouTube CMS user who is acting on behalf of the content owner specified in the
       * parameter value. This parameter is intended for YouTube content partners that own and
       * manage many different YouTube channels. It allows content owners to authenticate once and
       * get access to all their video and channel data, without having to provide authentication
       * credentials for each individual channel. The CMS account that the user authenticates with
       * must be linked to the specified YouTube content owner.
       */
      public Delete setOnBehalfOfContentOwner(java.lang.String onBehalfOfContentOwner) {
        this.onBehalfOfContentOwner = onBehalfOfContentOwner;
        return this;
      }

      @Override
      public Delete set(String parameterName, Object value) {
        return (Delete) super.set(parameterName, value);
      }
    }
    /**
     * Adds a channelSection for the authenticated user's channel.
     *
     * Create a request for the method "channelSections.insert".
     *
     * This request holds the parameters needed by the youtube server.  After setting any optional
     * parameters, call the {@link Insert#execute()} method to invoke the remote operation.
     *
     * @param part The part parameter serves two purposes in this operation. It identifies the properties that the
     *        write operation will set as well as the properties that the API response will include.
    The
     *        part names that you can include in the parameter value are snippet and contentDetails.
     * @param content the {@link com.google.api.services.youtube.model.ChannelSection}
     * @return the request
     */
    public Insert insert(java.lang.String part, com.google.api.services.youtube.model.ChannelSection content) throws java.io.IOException {
      Insert result = new Insert(part, content);
      initialize(result);
      return result;
    }

    public class Insert extends YouTubeRequest<com.google.api.services.youtube.model.ChannelSection> {

      private static final String REST_PATH = "channelSections";

      /**
       * Adds a channelSection for the authenticated user's channel.
       *
       * Create a request for the method "channelSections.insert".
       *
       * This request holds the parameters needed by the the youtube server.  After setting any optional
       * parameters, call the {@link Insert#execute()} method to invoke the remote operation. <p> {@link
       * Insert#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param part The part parameter serves two purposes in this operation. It identifies the properties that the
     *        write operation will set as well as the properties that the API response will include.
    The
     *        part names that you can include in the parameter value are snippet and contentDetails.
       * @param content the {@link com.google.api.services.youtube.model.ChannelSection}
       * @since 1.13
       */
      protected Insert(java.lang.String part, com.google.api.services.youtube.model.ChannelSection content) {
        super(YouTube.this, "POST", REST_PATH, content, com.google.api.services.youtube.model.ChannelSection.class);
        this.part = com.google.api.client.util.Preconditions.checkNotNull(part, "Required parameter part must be specified.");
      }

      @Override
      public Insert setAlt(java.lang.String alt) {
        return (Insert) super.setAlt(alt);
      }

      @Override
      public Insert setFields(java.lang.String fields) {
        return (Insert) super.setFields(fields);
      }

      @Override
      public Insert setKey(java.lang.String key) {
        return (Insert) super.setKey(key);
      }

      @Override
      public Insert setOauthToken(java.lang.String oauthToken) {
        return (Insert) super.setOauthToken(oauthToken);
      }

      @Override
      public Insert setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Insert) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Insert setQuotaUser(java.lang.String quotaUser) {
        return (Insert) super.setQuotaUser(quotaUser);
      }

      @Override
      public Insert setUserIp(java.lang.String userIp) {
        return (Insert) super.setUserIp(userIp);
      }

      /**
       * The part parameter serves two purposes in this operation. It identifies the properties that
       * the write operation will set as well as the properties that the API response will include.
       *
       * The part names that you can include in the parameter value are snippet and contentDetails.
       */
      @com.google.api.client.util.Key
      private java.lang.String part;

      /** The part parameter serves two purposes in this operation. It identifies the properties that the
     write operation will set as well as the properties that the API response will include.

     The part names that you can include in the parameter value are snippet and contentDetails.
       */
      public java.lang.String getPart() {
        return part;
      }

      /**
       * The part parameter serves two purposes in this operation. It identifies the properties that
       * the write operation will set as well as the properties that the API response will include.
       *
       * The part names that you can include in the parameter value are snippet and contentDetails.
       */
      public Insert setPart(java.lang.String part) {
        this.part = part;
        return this;
      }

      /**
       * Note: This parameter is intended exclusively for YouTube content partners.
       *
       * The onBehalfOfContentOwner parameter indicates that the request's authorization credentials
       * identify a YouTube CMS user who is acting on behalf of the content owner specified in the
       * parameter value. This parameter is intended for YouTube content partners that own and
       * manage many different YouTube channels. It allows content owners to authenticate once and
       * get access to all their video and channel data, without having to provide authentication
       * credentials for each individual channel. The CMS account that the user authenticates with
       * must be linked to the specified YouTube content owner.
       */
      @com.google.api.client.util.Key
      private java.lang.String onBehalfOfContentOwner;

      /** Note: This parameter is intended exclusively for YouTube content partners.

     The onBehalfOfContentOwner parameter indicates that the request's authorization credentials
     identify a YouTube CMS user who is acting on behalf of the content owner specified in the parameter
     value. This parameter is intended for YouTube content partners that own and manage many different
     YouTube channels. It allows content owners to authenticate once and get access to all their video
     and channel data, without having to provide authentication credentials for each individual channel.
     The CMS account that the user authenticates with must be linked to the specified YouTube content
     owner.
       */
      public java.lang.String getOnBehalfOfContentOwner() {
        return onBehalfOfContentOwner;
      }

      /**
       * Note: This parameter is intended exclusively for YouTube content partners.
       *
       * The onBehalfOfContentOwner parameter indicates that the request's authorization credentials
       * identify a YouTube CMS user who is acting on behalf of the content owner specified in the
       * parameter value. This parameter is intended for YouTube content partners that own and
       * manage many different YouTube channels. It allows content owners to authenticate once and
       * get access to all their video and channel data, without having to provide authentication
       * credentials for each individual channel. The CMS account that the user authenticates with
       * must be linked to the specified YouTube content owner.
       */
      public Insert setOnBehalfOfContentOwner(java.lang.String onBehalfOfContentOwner) {
        this.onBehalfOfContentOwner = onBehalfOfContentOwner;
        return this;
      }

      /**
       * This parameter can only be used in a properly authorized request. Note: This parameter is
       * intended exclusively for YouTube content partners.
       *
       * The onBehalfOfContentOwnerChannel parameter specifies the YouTube channel ID of the channel
       * to which a video is being added. This parameter is required when a request specifies a
       * value for the onBehalfOfContentOwner parameter, and it can only be used in conjunction with
       * that parameter. In addition, the request must be authorized using a CMS account that is
       * linked to the content owner that the onBehalfOfContentOwner parameter specifies. Finally,
       * the channel that the onBehalfOfContentOwnerChannel parameter value specifies must be linked
       * to the content owner that the onBehalfOfContentOwner parameter specifies.
       *
       * This parameter is intended for YouTube content partners that own and manage many different
       * YouTube channels. It allows content owners to authenticate once and perform actions on
       * behalf of the channel specified in the parameter value, without having to provide
       * authentication credentials for each separate channel.
       */
      @com.google.api.client.util.Key
      private java.lang.String onBehalfOfContentOwnerChannel;

      /** This parameter can only be used in a properly authorized request. Note: This parameter is intended
     exclusively for YouTube content partners.

     The onBehalfOfContentOwnerChannel parameter specifies the YouTube channel ID of the channel to
     which a video is being added. This parameter is required when a request specifies a value for the
     onBehalfOfContentOwner parameter, and it can only be used in conjunction with that parameter. In
     addition, the request must be authorized using a CMS account that is linked to the content owner
     that the onBehalfOfContentOwner parameter specifies. Finally, the channel that the
     onBehalfOfContentOwnerChannel parameter value specifies must be linked to the content owner that
     the onBehalfOfContentOwner parameter specifies.

     This parameter is intended for YouTube content partners that own and manage many different YouTube
     channels. It allows content owners to authenticate once and perform actions on behalf of the
     channel specified in the parameter value, without having to provide authentication credentials for
     each separate channel.
       */
      public java.lang.String getOnBehalfOfContentOwnerChannel() {
        return onBehalfOfContentOwnerChannel;
      }

      /**
       * This parameter can only be used in a properly authorized request. Note: This parameter is
       * intended exclusively for YouTube content partners.
       *
       * The onBehalfOfContentOwnerChannel parameter specifies the YouTube channel ID of the channel
       * to which a video is being added. This parameter is required when a request specifies a
       * value for the onBehalfOfContentOwner parameter, and it can only be used in conjunction with
       * that parameter. In addition, the request must be authorized using a CMS account that is
       * linked to the content owner that the onBehalfOfContentOwner parameter specifies. Finally,
       * the channel that the onBehalfOfContentOwnerChannel parameter value specifies must be linked
       * to the content owner that the onBehalfOfContentOwner parameter specifies.
       *
       * This parameter is intended for YouTube content partners that own and manage many different
       * YouTube channels. It allows content owners to authenticate once and perform actions on
       * behalf of the channel specified in the parameter value, without having to provide
       * authentication credentials for each separate channel.
       */
      public Insert setOnBehalfOfContentOwnerChannel(java.lang.String onBehalfOfContentOwnerChannel) {
        this.onBehalfOfContentOwnerChannel = onBehalfOfContentOwnerChannel;
        return this;
      }

      @Override
      public Insert set(String parameterName, Object value) {
        return (Insert) super.set(parameterName, value);
      }
    }
    /**
     * Returns channelSection resources that match the API request criteria.
     *
     * Create a request for the method "channelSections.list".
     *
     * This request holds the parameters needed by the youtube server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param part The part parameter specifies a comma-separated list of one or more channelSection resource
     *        properties that the API response will include. The part names that you can include in the
     *        parameter value are id, snippet, and contentDetails.
    If the parameter identifies a
     *        property that contains child properties, the child properties will be included in the
     *        response. For example, in a channelSection resource, the snippet property contains other
     *        properties, such as a display title for the channelSection. If you set part=snippet, the
     *        API response will also contain all of those nested properties.
     * @return the request
     */
    public List list(java.lang.String part) throws java.io.IOException {
      List result = new List(part);
      initialize(result);
      return result;
    }

    public class List extends YouTubeRequest<com.google.api.services.youtube.model.ChannelSectionListResponse> {

      private static final String REST_PATH = "channelSections";

      /**
       * Returns channelSection resources that match the API request criteria.
       *
       * Create a request for the method "channelSections.list".
       *
       * This request holds the parameters needed by the the youtube server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param part The part parameter specifies a comma-separated list of one or more channelSection resource
     *        properties that the API response will include. The part names that you can include in the
     *        parameter value are id, snippet, and contentDetails.
    If the parameter identifies a
     *        property that contains child properties, the child properties will be included in the
     *        response. For example, in a channelSection resource, the snippet property contains other
     *        properties, such as a display title for the channelSection. If you set part=snippet, the
     *        API response will also contain all of those nested properties.
       * @since 1.13
       */
      protected List(java.lang.String part) {
        super(YouTube.this, "GET", REST_PATH, null, com.google.api.services.youtube.model.ChannelSectionListResponse.class);
        this.part = com.google.api.client.util.Preconditions.checkNotNull(part, "Required parameter part must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUserIp(java.lang.String userIp) {
        return (List) super.setUserIp(userIp);
      }

      /**
       * The part parameter specifies a comma-separated list of one or more channelSection resource
       * properties that the API response will include. The part names that you can include in the
       * parameter value are id, snippet, and contentDetails.
       *
       * If the parameter identifies a property that contains child properties, the child properties
       * will be included in the response. For example, in a channelSection resource, the snippet
       * property contains other properties, such as a display title for the channelSection. If you
       * set part=snippet, the API response will also contain all of those nested properties.
       */
      @com.google.api.client.util.Key
      private java.lang.String part;

      /** The part parameter specifies a comma-separated list of one or more channelSection resource
     properties that the API response will include. The part names that you can include in the parameter
     value are id, snippet, and contentDetails.

     If the parameter identifies a property that contains child properties, the child properties will be
     included in the response. For example, in a channelSection resource, the snippet property contains
     other properties, such as a display title for the channelSection. If you set part=snippet, the API
     response will also contain all of those nested properties.
       */
      public java.lang.String getPart() {
        return part;
      }

      /**
       * The part parameter specifies a comma-separated list of one or more channelSection resource
       * properties that the API response will include. The part names that you can include in the
       * parameter value are id, snippet, and contentDetails.
       *
       * If the parameter identifies a property that contains child properties, the child properties
       * will be included in the response. For example, in a channelSection resource, the snippet
       * property contains other properties, such as a display title for the channelSection. If you
       * set part=snippet, the API response will also contain all of those nested properties.
       */
      public List setPart(java.lang.String part) {
        this.part = part;
        return this;
      }

      /**
       * The channelId parameter specifies a YouTube channel ID. The API will only return that
       * channel's channelSections.
       */
      @com.google.api.client.util.Key
      private java.lang.String channelId;

      /** The channelId parameter specifies a YouTube channel ID. The API will only return that channel's
     channelSections.
       */
      public java.lang.String getChannelId() {
        return channelId;
      }

      /**
       * The channelId parameter specifies a YouTube channel ID. The API will only return that
       * channel's channelSections.
       */
      public List setChannelId(java.lang.String channelId) {
        this.channelId = channelId;
        return this;
      }

      /**
       * The hl parameter indicates that the snippet.localized property values in the returned
       * channelSection resources should be in the specified language if localized values for that
       * language are available. For example, if the API request specifies hl=de, the
       * snippet.localized properties in the API response will contain German titles if German
       * titles are available. Channel owners can provide localized channel section titles using
       * either the channelSections.insert or channelSections.update method.
       */
      @com.google.api.client.util.Key
      private java.lang.String hl;

      /** The hl parameter indicates that the snippet.localized property values in the returned
     channelSection resources should be in the specified language if localized values for that language
     are available. For example, if the API request specifies hl=de, the snippet.localized properties in
     the API response will contain German titles if German titles are available. Channel owners can
     provide localized channel section titles using either the channelSections.insert or
     channelSections.update method.
       */
      public java.lang.String getHl() {
        return hl;
      }

      /**
       * The hl parameter indicates that the snippet.localized property values in the returned
       * channelSection resources should be in the specified language if localized values for that
       * language are available. For example, if the API request specifies hl=de, the
       * snippet.localized properties in the API response will contain German titles if German
       * titles are available. Channel owners can provide localized channel section titles using
       * either the channelSections.insert or channelSections.update method.
       */
      public List setHl(java.lang.String hl) {
        this.hl = hl;
        return this;
      }

      /**
       * The id parameter specifies a comma-separated list of the YouTube channelSection ID(s) for
       * the resource(s) that are being retrieved. In a channelSection resource, the id property
       * specifies the YouTube channelSection ID.
       */
      @com.google.api.client.util.Key
      private java.lang.String id;

      /** The id parameter specifies a comma-separated list of the YouTube channelSection ID(s) for the
     resource(s) that are being retrieved. In a channelSection resource, the id property specifies the
     YouTube channelSection ID.
       */
      public java.lang.String getId() {
        return id;
      }

      /**
       * The id parameter specifies a comma-separated list of the YouTube channelSection ID(s) for
       * the resource(s) that are being retrieved. In a channelSection resource, the id property
       * specifies the YouTube channelSection ID.
       */
      public List setId(java.lang.String id) {
        this.id = id;
        return this;
      }

      /**
       * Set this parameter's value to true to retrieve a feed of the authenticated user's
       * channelSections.
       */
      @com.google.api.client.util.Key
      private java.lang.Boolean mine;

      /** Set this parameter's value to true to retrieve a feed of the authenticated user's channelSections.
       */
      public java.lang.Boolean getMine() {
        return mine;
      }

      /**
       * Set this parameter's value to true to retrieve a feed of the authenticated user's
       * channelSections.
       */
      public List setMine(java.lang.Boolean mine) {
        this.mine = mine;
        return this;
      }

      /**
       * Note: This parameter is intended exclusively for YouTube content partners.
       *
       * The onBehalfOfContentOwner parameter indicates that the request's authorization credentials
       * identify a YouTube CMS user who is acting on behalf of the content owner specified in the
       * parameter value. This parameter is intended for YouTube content partners that own and
       * manage many different YouTube channels. It allows content owners to authenticate once and
       * get access to all their video and channel data, without having to provide authentication
       * credentials for each individual channel. The CMS account that the user authenticates with
       * must be linked to the specified YouTube content owner.
       */
      @com.google.api.client.util.Key
      private java.lang.String onBehalfOfContentOwner;

      /** Note: This parameter is intended exclusively for YouTube content partners.

     The onBehalfOfContentOwner parameter indicates that the request's authorization credentials
     identify a YouTube CMS user who is acting on behalf of the content owner specified in the parameter
     value. This parameter is intended for YouTube content partners that own and manage many different
     YouTube channels. It allows content owners to authenticate once and get access to all their video
     and channel data, without having to provide authentication credentials for each individual channel.
     The CMS account that the user authenticates with must be linked to the specified YouTube content
     owner.
       */
      public java.lang.String getOnBehalfOfContentOwner() {
        return onBehalfOfContentOwner;
      }

      /**
       * Note: This parameter is intended exclusively for YouTube content partners.
       *
       * The onBehalfOfContentOwner parameter indicates that the request's authorization credentials
       * identify a YouTube CMS user who is acting on behalf of the content owner specified in the
       * parameter value. This parameter is intended for YouTube content partners that own and
       * manage many different YouTube channels. It allows content owners to authenticate once and
       * get access to all their video and channel data, without having to provide authentication
       * credentials for each individual channel. The CMS account that the user authenticates with
       * must be linked to the specified YouTube content owner.
       */
      public List setOnBehalfOfContentOwner(java.lang.String onBehalfOfContentOwner) {
        this.onBehalfOfContentOwner = onBehalfOfContentOwner;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }
    /**
     * Update a channelSection.
     *
     * Create a request for the method "channelSections.update".
     *
     * This request holds the parameters needed by the youtube server.  After setting any optional
     * parameters, call the {@link Update#execute()} method to invoke the remote operation.
     *
     * @param part The part parameter serves two purposes in this operation. It identifies the properties that the
     *        write operation will set as well as the properties that the API response will include.
    The
     *        part names that you can include in the parameter value are snippet and contentDetails.
     * @param content the {@link com.google.api.services.youtube.model.ChannelSection}
     * @return the request
     */
    public Update update(java.lang.String part, com.google.api.services.youtube.model.ChannelSection content) throws java.io.IOException {
      Update result = new Update(part, content);
      initialize(result);
      return result;
    }

    public class Update extends YouTubeRequest<com.google.api.services.youtube.model.ChannelSection> {

      private static final String REST_PATH = "channelSections";

      /**
       * Update a channelSection.
       *
       * Create a request for the method "channelSections.update".
       *
       * This request holds the parameters needed by the the youtube server.  After setting any optional
       * parameters, call the {@link Update#execute()} method to invoke the remote operation. <p> {@link
       * Update#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param part The part parameter serves two purposes in this operation. It identifies the properties that the
     *        write operation will set as well as the properties that the API response will include.
    The
     *        part names that you can include in the parameter value are snippet and contentDetails.
       * @param content the {@link com.google.api.services.youtube.model.ChannelSection}
       * @since 1.13
       */
      protected Update(java.lang.String part, com.google.api.services.youtube.model.ChannelSection content) {
        super(YouTube.this, "PUT", REST_PATH, content, com.google.api.services.youtube.model.ChannelSection.class);
        this.part = com.google.api.client.util.Preconditions.checkNotNull(part, "Required parameter part must be specified.");
      }

      @Override
      public Update setAlt(java.lang.String alt) {
        return (Update) super.setAlt(alt);
      }

      @Override
      public Update setFields(java.lang.String fields) {
        return (Update) super.setFields(fields);
      }

      @Override
      public Update setKey(java.lang.String key) {
        return (Update) super.setKey(key);
      }

      @Override
      public Update setOauthToken(java.lang.String oauthToken) {
        return (Update) super.setOauthToken(oauthToken);
      }

      @Override
      public Update setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Update) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Update setQuotaUser(java.lang.String quotaUser) {
        return (Update) super.setQuotaUser(quotaUser);
      }

      @Override
      public Update setUserIp(java.lang.String userIp) {
        return (Update) super.setUserIp(userIp);
      }

      /**
       * The part parameter serves two purposes in this operation. It identifies the properties that
       * the write operation will set as well as the properties that the API response will include.
       *
       * The part names that you can include in the parameter value are snippet and contentDetails.
       */
      @com.google.api.client.util.Key
      private java.lang.String part;

      /** The part parameter serves two purposes in this operation. It identifies the properties that the
     write operation will set as well as the properties that the API response will include.

     The part names that you can include in the parameter value are snippet and contentDetails.
       */
      public java.lang.String getPart() {
        return part;
      }

      /**
       * The part parameter serves two purposes in this operation. It identifies the properties that
       * the write operation will set as well as the properties that the API response will include.
       *
       * The part names that you can include in the parameter value are snippet and contentDetails.
       */
      public Update setPart(java.lang.String part) {
        this.part = part;
        return this;
      }

      /**
       * Note: This parameter is intended exclusively for YouTube content partners.
       *
       * The onBehalfOfContentOwner parameter indicates that the request's authorization credentials
       * identify a YouTube CMS user who is acting on behalf of the content owner specified in the
       * parameter value. This parameter is intended for YouTube content partners that own and
       * manage many different YouTube channels. It allows content owners to authenticate once and
       * get access to all their video and channel data, without having to provide authentication
       * credentials for each individual channel. The CMS account that the user authenticates with
       * must be linked to the specified YouTube content owner.
       */
      @com.google.api.client.util.Key
      private java.lang.String onBehalfOfContentOwner;

      /** Note: This parameter is intended exclusively for YouTube content partners.

     The onBehalfOfContentOwner parameter indicates that the request's authorization credentials
     identify a YouTube CMS user who is acting on behalf of the content owner specified in the parameter
     value. This parameter is intended for YouTube content partners that own and manage many different
     YouTube channels. It allows content owners to authenticate once and get access to all their video
     and channel data, without having to provide authentication credentials for each individual channel.
     The CMS account that the user authenticates with must be linked to the specified YouTube content
     owner.
       */
      public java.lang.String getOnBehalfOfContentOwner() {
        return onBehalfOfContentOwner;
      }

      /**
       * Note: This parameter is intended exclusively for YouTube content partners.
       *
       * The onBehalfOfContentOwner parameter indicates that the request's authorization credentials
       * identify a YouTube CMS user who is acting on behalf of the content owner specified in the
       * parameter value. This parameter is intended for YouTube content partners that own and
       * manage many different YouTube channels. It allows content owners to authenticate once and
       * get access to all their video and channel data, without having to provide authentication
       * credentials for each individual channel. The CMS account that the user authenticates with
       * must be linked to the specified YouTube content owner.
       */
      public Update setOnBehalfOfContentOwner(java.lang.String onBehalfOfContentOwner) {
        this.onBehalfOfContentOwner = onBehalfOfContentOwner;
        return this;
      }

      @Override
      public Update set(String parameterName, Object value) {
        return (Update) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the Channels collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code YouTube youtube = new YouTube(...);}
   *   {@code YouTube.Channels.List request = youtube.channels().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Channels channels() {
    return new Channels();
  }

  /**
   * The "channels" collection of methods.
   */
  public class Channels {

    /**
     * Returns a collection of zero or more channel resources that match the request criteria.
     *
     * Create a request for the method "channels.list".
     *
     * This request holds the parameters needed by the youtube server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param part The part parameter specifies a comma-separated list of one or more channel resource properties that
     *        the API response will include.
    If the parameter identifies a property that contains child
     *        properties, the child properties will be included in the response. For example, in a
     *        channel resource, the contentDetails property contains other properties, such as the
     *        uploads properties. As such, if you set part=contentDetails, the API response will also
     *        contain all of those nested properties.
     * @return the request
     */
    public List list(java.lang.String part) throws java.io.IOException {
      List result = new List(part);
      initialize(result);
      return result;
    }

    public class List extends YouTubeRequest<com.google.api.services.youtube.model.ChannelListResponse> {

      private static final String REST_PATH = "channels";

      /**
       * Returns a collection of zero or more channel resources that match the request criteria.
       *
       * Create a request for the method "channels.list".
       *
       * This request holds the parameters needed by the the youtube server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param part The part parameter specifies a comma-separated list of one or more channel resource properties that
     *        the API response will include.
    If the parameter identifies a property that contains child
     *        properties, the child properties will be included in the response. For example, in a
     *        channel resource, the contentDetails property contains other properties, such as the
     *        uploads properties. As such, if you set part=contentDetails, the API response will also
     *        contain all of those nested properties.
       * @since 1.13
       */
      protected List(java.lang.String part) {
        super(YouTube.this, "GET", REST_PATH, null, com.google.api.services.youtube.model.ChannelListResponse.class);
        this.part = com.google.api.client.util.Preconditions.checkNotNull(part, "Required parameter part must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUserIp(java.lang.String userIp) {
        return (List) super.setUserIp(userIp);
      }

      /**
       * The part parameter specifies a comma-separated list of one or more channel resource
       * properties that the API response will include.
       *
       * If the parameter identifies a property that contains child properties, the child properties
       * will be included in the response. For example, in a channel resource, the contentDetails
       * property contains other properties, such as the uploads properties. As such, if you set
       * part=contentDetails, the API response will also contain all of those nested properties.
       */
      @com.google.api.client.util.Key
      private java.lang.String part;

      /** The part parameter specifies a comma-separated list of one or more channel resource properties that
     the API response will include.

     If the parameter identifies a property that contains child properties, the child properties will be
     included in the response. For example, in a channel resource, the contentDetails property contains
     other properties, such as the uploads properties. As such, if you set part=contentDetails, the API
     response will also contain all of those nested properties.
       */
      public java.lang.String getPart() {
        return part;
      }

      /**
       * The part parameter specifies a comma-separated list of one or more channel resource
       * properties that the API response will include.
       *
       * If the parameter identifies a property that contains child properties, the child properties
       * will be included in the response. For example, in a channel resource, the contentDetails
       * property contains other properties, such as the uploads properties. As such, if you set
       * part=contentDetails, the API response will also contain all of those nested properties.
       */
      public List setPart(java.lang.String part) {
        this.part = part;
        return this;
      }

      /**
       * The categoryId parameter specifies a YouTube guide category, thereby requesting YouTube
       * channels associated with that category.
       */
      @com.google.api.client.util.Key
      private java.lang.String categoryId;

      /** The categoryId parameter specifies a YouTube guide category, thereby requesting YouTube channels
     associated with that category.
       */
      public java.lang.String getCategoryId() {
        return categoryId;
      }

      /**
       * The categoryId parameter specifies a YouTube guide category, thereby requesting YouTube
       * channels associated with that category.
       */
      public List setCategoryId(java.lang.String categoryId) {
        this.categoryId = categoryId;
        return this;
      }

      /**
       * The forUsername parameter specifies a YouTube username, thereby requesting the channel
       * associated with that username.
       */
      @com.google.api.client.util.Key
      private java.lang.String forUsername;

      /** The forUsername parameter specifies a YouTube username, thereby requesting the channel associated
     with that username.
       */
      public java.lang.String getForUsername() {
        return forUsername;
      }

      /**
       * The forUsername parameter specifies a YouTube username, thereby requesting the channel
       * associated with that username.
       */
      public List setForUsername(java.lang.String forUsername) {
        this.forUsername = forUsername;
        return this;
      }

      /**
       * The hl parameter should be used for filter out the properties that are not in the given
       * language. Used for the brandingSettings part.
       */
      @com.google.api.client.util.Key
      private java.lang.String hl;

      /** The hl parameter should be used for filter out the properties that are not in the given language.
     Used for the brandingSettings part.
       */
      public java.lang.String getHl() {
        return hl;
      }

      /**
       * The hl parameter should be used for filter out the properties that are not in the given
       * language. Used for the brandingSettings part.
       */
      public List setHl(java.lang.String hl) {
        this.hl = hl;
        return this;
      }

      /**
       * The id parameter specifies a comma-separated list of the YouTube channel ID(s) for the
       * resource(s) that are being retrieved. In a channel resource, the id property specifies the
       * channel's YouTube channel ID.
       */
      @com.google.api.client.util.Key
      private java.lang.String id;

      /** The id parameter specifies a comma-separated list of the YouTube channel ID(s) for the resource(s)
     that are being retrieved. In a channel resource, the id property specifies the channel's YouTube
     channel ID.
       */
      public java.lang.String getId() {
        return id;
      }

      /**
       * The id parameter specifies a comma-separated list of the YouTube channel ID(s) for the
       * resource(s) that are being retrieved. In a channel resource, the id property specifies the
       * channel's YouTube channel ID.
       */
      public List setId(java.lang.String id) {
        this.id = id;
        return this;
      }

      /**
       * Note: This parameter is intended exclusively for YouTube content partners.
       *
       * Set this parameter's value to true to instruct the API to only return channels managed by
       * the content owner that the onBehalfOfContentOwner parameter specifies. The user must be
       * authenticated as a CMS account linked to the specified content owner and
       * onBehalfOfContentOwner must be provided.
       */
      @com.google.api.client.util.Key
      private java.lang.Boolean managedByMe;

      /** Note: This parameter is intended exclusively for YouTube content partners.

     Set this parameter's value to true to instruct the API to only return channels managed by the
     content owner that the onBehalfOfContentOwner parameter specifies. The user must be authenticated
     as a CMS account linked to the specified content owner and onBehalfOfContentOwner must be provided.
       */
      public java.lang.Boolean getManagedByMe() {
        return managedByMe;
      }

      /**
       * Note: This parameter is intended exclusively for YouTube content partners.
       *
       * Set this parameter's value to true to instruct the API to only return channels managed by
       * the content owner that the onBehalfOfContentOwner parameter specifies. The user must be
       * authenticated as a CMS account linked to the specified content owner and
       * onBehalfOfContentOwner must be provided.
       */
      public List setManagedByMe(java.lang.Boolean managedByMe) {
        this.managedByMe = managedByMe;
        return this;
      }

      /**
       * The maxResults parameter specifies the maximum number of items that should be returned in
       * the result set.
       */
      @com.google.api.client.util.Key
      private java.lang.Long maxResults;

      /** The maxResults parameter specifies the maximum number of items that should be returned in the
     result set. [default: 5] [minimum: 0] [maximum: 50]
       */
      public java.lang.Long getMaxResults() {
        return maxResults;
      }

      /**
       * The maxResults parameter specifies the maximum number of items that should be returned in
       * the result set.
       */
      public List setMaxResults(java.lang.Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      /**
       * Set this parameter's value to true to instruct the API to only return channels owned by the
       * authenticated user.
       */
      @com.google.api.client.util.Key
      private java.lang.Boolean mine;

      /** Set this parameter's value to true to instruct the API to only return channels owned by the
     authenticated user.
       */
      public java.lang.Boolean getMine() {
        return mine;
      }

      /**
       * Set this parameter's value to true to instruct the API to only return channels owned by the
       * authenticated user.
       */
      public List setMine(java.lang.Boolean mine) {
        this.mine = mine;
        return this;
      }

      /**
       * Use the subscriptions.list method and its mySubscribers parameter to retrieve a list of
       * subscribers to the authenticated user's channel.
       */
      @com.google.api.client.util.Key
      private java.lang.Boolean mySubscribers;

      /** Use the subscriptions.list method and its mySubscribers parameter to retrieve a list of subscribers
     to the authenticated user's channel.
       */
      public java.lang.Boolean getMySubscribers() {
        return mySubscribers;
      }

      /**
       * Use the subscriptions.list method and its mySubscribers parameter to retrieve a list of
       * subscribers to the authenticated user's channel.
       */
      public List setMySubscribers(java.lang.Boolean mySubscribers) {
        this.mySubscribers = mySubscribers;
        return this;
      }

      /**
       * Note: This parameter is intended exclusively for YouTube content partners.
       *
       * The onBehalfOfContentOwner parameter indicates that the request's authorization credentials
       * identify a YouTube CMS user who is acting on behalf of the content owner specified in the
       * parameter value. This parameter is intended for YouTube content partners that own and
       * manage many different YouTube channels. It allows content owners to authenticate once and
       * get access to all their video and channel data, without having to provide authentication
       * credentials for each individual channel. The CMS account that the user authenticates with
       * must be linked to the specified YouTube content owner.
       */
      @com.google.api.client.util.Key
      private java.lang.String onBehalfOfContentOwner;

      /** Note: This parameter is intended exclusively for YouTube content partners.

     The onBehalfOfContentOwner parameter indicates that the request's authorization credentials
     identify a YouTube CMS user who is acting on behalf of the content owner specified in the parameter
     value. This parameter is intended for YouTube content partners that own and manage many different
     YouTube channels. It allows content owners to authenticate once and get access to all their video
     and channel data, without having to provide authentication credentials for each individual channel.
     The CMS account that the user authenticates with must be linked to the specified YouTube content
     owner.
       */
      public java.lang.String getOnBehalfOfContentOwner() {
        return onBehalfOfContentOwner;
      }

      /**
       * Note: This parameter is intended exclusively for YouTube content partners.
       *
       * The onBehalfOfContentOwner parameter indicates that the request's authorization credentials
       * identify a YouTube CMS user who is acting on behalf of the content owner specified in the
       * parameter value. This parameter is intended for YouTube content partners that own and
       * manage many different YouTube channels. It allows content owners to authenticate once and
       * get access to all their video and channel data, without having to provide authentication
       * credentials for each individual channel. The CMS account that the user authenticates with
       * must be linked to the specified YouTube content owner.
       */
      public List setOnBehalfOfContentOwner(java.lang.String onBehalfOfContentOwner) {
        this.onBehalfOfContentOwner = onBehalfOfContentOwner;
        return this;
      }

      /**
       * The pageToken parameter identifies a specific page in the result set that should be
       * returned. In an API response, the nextPageToken and prevPageToken properties identify other
       * pages that could be retrieved.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** The pageToken parameter identifies a specific page in the result set that should be returned. In an
     API response, the nextPageToken and prevPageToken properties identify other pages that could be
     retrieved.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * The pageToken parameter identifies a specific page in the result set that should be
       * returned. In an API response, the nextPageToken and prevPageToken properties identify other
       * pages that could be retrieved.
       */
      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }
    /**
     * Updates a channel's metadata. Note that this method currently only supports updates to the
     * channel resource's brandingSettings and invideoPromotion objects and their child properties.
     *
     * Create a request for the method "channels.update".
     *
     * This request holds the parameters needed by the youtube server.  After setting any optional
     * parameters, call the {@link Update#execute()} method to invoke the remote operation.
     *
     * @param part The part parameter serves two purposes in this operation. It identifies the properties that the
     *        write operation will set as well as the properties that the API response will include.
    The
     *        API currently only allows the parameter value to be set to either brandingSettings or
     *        invideoPromotion. (You cannot update both of those parts with a single request.)
    Note that
     *        this method overrides the existing values for all of the mutable properties that are
     *        contained in any parts that the parameter value specifies.
     * @param content the {@link com.google.api.services.youtube.model.Channel}
     * @return the request
     */
    public Update update(java.lang.String part, com.google.api.services.youtube.model.Channel content) throws java.io.IOException {
      Update result = new Update(part, content);
      initialize(result);
      return result;
    }

    public class Update extends YouTubeRequest<com.google.api.services.youtube.model.Channel> {

      private static final String REST_PATH = "channels";

      /**
       * Updates a channel's metadata. Note that this method currently only supports updates to the
       * channel resource's brandingSettings and invideoPromotion objects and their child properties.
       *
       * Create a request for the method "channels.update".
       *
       * This request holds the parameters needed by the the youtube server.  After setting any optional
       * parameters, call the {@link Update#execute()} method to invoke the remote operation. <p> {@link
       * Update#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param part The part parameter serves two purposes in this operation. It identifies the properties that the
     *        write operation will set as well as the properties that the API response will include.
    The
     *        API currently only allows the parameter value to be set to either brandingSettings or
     *        invideoPromotion. (You cannot update both of those parts with a single request.)
    Note that
     *        this method overrides the existing values for all of the mutable properties that are
     *        contained in any parts that the parameter value specifies.
       * @param content the {@link com.google.api.services.youtube.model.Channel}
       * @since 1.13
       */
      protected Update(java.lang.String part, com.google.api.services.youtube.model.Channel content) {
        super(YouTube.this, "PUT", REST_PATH, content, com.google.api.services.youtube.model.Channel.class);
        this.part = com.google.api.client.util.Preconditions.checkNotNull(part, "Required parameter part must be specified.");
      }

      @Override
      public Update setAlt(java.lang.String alt) {
        return (Update) super.setAlt(alt);
      }

      @Override
      public Update setFields(java.lang.String fields) {
        return (Update) super.setFields(fields);
      }

      @Override
      public Update setKey(java.lang.String key) {
        return (Update) super.setKey(key);
      }

      @Override
      public Update setOauthToken(java.lang.String oauthToken) {
        return (Update) super.setOauthToken(oauthToken);
      }

      @Override
      public Update setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Update) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Update setQuotaUser(java.lang.String quotaUser) {
        return (Update) super.setQuotaUser(quotaUser);
      }

      @Override
      public Update setUserIp(java.lang.String userIp) {
        return (Update) super.setUserIp(userIp);
      }

      /**
       * The part parameter serves two purposes in this operation. It identifies the properties that
       * the write operation will set as well as the properties that the API response will include.
       *
       * The API currently only allows the parameter value to be set to either brandingSettings or
       * invideoPromotion. (You cannot update both of those parts with a single request.)
       *
       * Note that this method overrides the existing values for all of the mutable properties that
       * are contained in any parts that the parameter value specifies.
       */
      @com.google.api.client.util.Key
      private java.lang.String part;

      /** The part parameter serves two purposes in this operation. It identifies the properties that the
     write operation will set as well as the properties that the API response will include.

     The API currently only allows the parameter value to be set to either brandingSettings or
     invideoPromotion. (You cannot update both of those parts with a single request.)

     Note that this method overrides the existing values for all of the mutable properties that are
     contained in any parts that the parameter value specifies.
       */
      public java.lang.String getPart() {
        return part;
      }

      /**
       * The part parameter serves two purposes in this operation. It identifies the properties that
       * the write operation will set as well as the properties that the API response will include.
       *
       * The API currently only allows the parameter value to be set to either brandingSettings or
       * invideoPromotion. (You cannot update both of those parts with a single request.)
       *
       * Note that this method overrides the existing values for all of the mutable properties that
       * are contained in any parts that the parameter value specifies.
       */
      public Update setPart(java.lang.String part) {
        this.part = part;
        return this;
      }

      /**
       * The onBehalfOfContentOwner parameter indicates that the authenticated user is acting on
       * behalf of the content owner specified in the parameter value. This parameter is intended
       * for YouTube content partners that own and manage many different YouTube channels. It allows
       * content owners to authenticate once and get access to all their video and channel data,
       * without having to provide authentication credentials for each individual channel. The
       * actual CMS account that the user authenticates with needs to be linked to the specified
       * YouTube content owner.
       */
      @com.google.api.client.util.Key
      private java.lang.String onBehalfOfContentOwner;

      /** The onBehalfOfContentOwner parameter indicates that the authenticated user is acting on behalf of
     the content owner specified in the parameter value. This parameter is intended for YouTube content
     partners that own and manage many different YouTube channels. It allows content owners to
     authenticate once and get access to all their video and channel data, without having to provide
     authentication credentials for each individual channel. The actual CMS account that the user
     authenticates with needs to be linked to the specified YouTube content owner.
       */
      public java.lang.String getOnBehalfOfContentOwner() {
        return onBehalfOfContentOwner;
      }

      /**
       * The onBehalfOfContentOwner parameter indicates that the authenticated user is acting on
       * behalf of the content owner specified in the parameter value. This parameter is intended
       * for YouTube content partners that own and manage many different YouTube channels. It allows
       * content owners to authenticate once and get access to all their video and channel data,
       * without having to provide authentication credentials for each individual channel. The
       * actual CMS account that the user authenticates with needs to be linked to the specified
       * YouTube content owner.
       */
      public Update setOnBehalfOfContentOwner(java.lang.String onBehalfOfContentOwner) {
        this.onBehalfOfContentOwner = onBehalfOfContentOwner;
        return this;
      }

      @Override
      public Update set(String parameterName, Object value) {
        return (Update) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the CommentThreads collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code YouTube youtube = new YouTube(...);}
   *   {@code YouTube.CommentThreads.List request = youtube.commentThreads().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public CommentThreads commentThreads() {
    return new CommentThreads();
  }

  /**
   * The "commentThreads" collection of methods.
   */
  public class CommentThreads {

    /**
     * Creates a new top-level comment. To add a reply to an existing comment, use the comments.insert
     * method instead.
     *
     * Create a request for the method "commentThreads.insert".
     *
     * This request holds the parameters needed by the youtube server.  After setting any optional
     * parameters, call the {@link Insert#execute()} method to invoke the remote operation.
     *
     * @param part The part parameter identifies the properties that the API response will include. Set the parameter
     *        value to snippet. The snippet part has a quota cost of 2 units.
     * @param content the {@link com.google.api.services.youtube.model.CommentThread}
     * @return the request
     */
    public Insert insert(java.lang.String part, com.google.api.services.youtube.model.CommentThread content) throws java.io.IOException {
      Insert result = new Insert(part, content);
      initialize(result);
      return result;
    }

    public class Insert extends YouTubeRequest<com.google.api.services.youtube.model.CommentThread> {

      private static final String REST_PATH = "commentThreads";

      /**
       * Creates a new top-level comment. To add a reply to an existing comment, use the comments.insert
       * method instead.
       *
       * Create a request for the method "commentThreads.insert".
       *
       * This request holds the parameters needed by the the youtube server.  After setting any optional
       * parameters, call the {@link Insert#execute()} method to invoke the remote operation. <p> {@link
       * Insert#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param part The part parameter identifies the properties that the API response will include. Set the parameter
     *        value to snippet. The snippet part has a quota cost of 2 units.
       * @param content the {@link com.google.api.services.youtube.model.CommentThread}
       * @since 1.13
       */
      protected Insert(java.lang.String part, com.google.api.services.youtube.model.CommentThread content) {
        super(YouTube.this, "POST", REST_PATH, content, com.google.api.services.youtube.model.CommentThread.class);
        this.part = com.google.api.client.util.Preconditions.checkNotNull(part, "Required parameter part must be specified.");
      }

      @Override
      public Insert setAlt(java.lang.String alt) {
        return (Insert) super.setAlt(alt);
      }

      @Override
      public Insert setFields(java.lang.String fields) {
        return (Insert) super.setFields(fields);
      }

      @Override
      public Insert setKey(java.lang.String key) {
        return (Insert) super.setKey(key);
      }

      @Override
      public Insert setOauthToken(java.lang.String oauthToken) {
        return (Insert) super.setOauthToken(oauthToken);
      }

      @Override
      public Insert setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Insert) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Insert setQuotaUser(java.lang.String quotaUser) {
        return (Insert) super.setQuotaUser(quotaUser);
      }

      @Override
      public Insert setUserIp(java.lang.String userIp) {
        return (Insert) super.setUserIp(userIp);
      }

      /**
       * The part parameter identifies the properties that the API response will include. Set the
       * parameter value to snippet. The snippet part has a quota cost of 2 units.
       */
      @com.google.api.client.util.Key
      private java.lang.String part;

      /** The part parameter identifies the properties that the API response will include. Set the parameter
     value to snippet. The snippet part has a quota cost of 2 units.
       */
      public java.lang.String getPart() {
        return part;
      }

      /**
       * The part parameter identifies the properties that the API response will include. Set the
       * parameter value to snippet. The snippet part has a quota cost of 2 units.
       */
      public Insert setPart(java.lang.String part) {
        this.part = part;
        return this;
      }

      @Override
      public Insert set(String parameterName, Object value) {
        return (Insert) super.set(parameterName, value);
      }
    }
    /**
     * Returns a list of comment threads that match the API request parameters.
     *
     * Create a request for the method "commentThreads.list".
     *
     * This request holds the parameters needed by the youtube server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param part The part parameter specifies a comma-separated list of one or more commentThread resource properties
     *        that the API response will include.
     * @return the request
     */
    public List list(java.lang.String part) throws java.io.IOException {
      List result = new List(part);
      initialize(result);
      return result;
    }

    public class List extends YouTubeRequest<com.google.api.services.youtube.model.CommentThreadListResponse> {

      private static final String REST_PATH = "commentThreads";

      /**
       * Returns a list of comment threads that match the API request parameters.
       *
       * Create a request for the method "commentThreads.list".
       *
       * This request holds the parameters needed by the the youtube server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param part The part parameter specifies a comma-separated list of one or more commentThread resource properties
     *        that the API response will include.
       * @since 1.13
       */
      protected List(java.lang.String part) {
        super(YouTube.this, "GET", REST_PATH, null, com.google.api.services.youtube.model.CommentThreadListResponse.class);
        this.part = com.google.api.client.util.Preconditions.checkNotNull(part, "Required parameter part must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUserIp(java.lang.String userIp) {
        return (List) super.setUserIp(userIp);
      }

      /**
       * The part parameter specifies a comma-separated list of one or more commentThread resource
       * properties that the API response will include.
       */
      @com.google.api.client.util.Key
      private java.lang.String part;

      /** The part parameter specifies a comma-separated list of one or more commentThread resource
     properties that the API response will include.
       */
      public java.lang.String getPart() {
        return part;
      }

      /**
       * The part parameter specifies a comma-separated list of one or more commentThread resource
       * properties that the API response will include.
       */
      public List setPart(java.lang.String part) {
        this.part = part;
        return this;
      }

      /**
       * The allThreadsRelatedToChannelId parameter instructs the API to return all comment threads
       * associated with the specified channel. The response can include comments about the channel
       * or about the channel's videos.
       */
      @com.google.api.client.util.Key
      private java.lang.String allThreadsRelatedToChannelId;

      /** The allThreadsRelatedToChannelId parameter instructs the API to return all comment threads
     associated with the specified channel. The response can include comments about the channel or about
     the channel's videos.
       */
      public java.lang.String getAllThreadsRelatedToChannelId() {
        return allThreadsRelatedToChannelId;
      }

      /**
       * The allThreadsRelatedToChannelId parameter instructs the API to return all comment threads
       * associated with the specified channel. The response can include comments about the channel
       * or about the channel's videos.
       */
      public List setAllThreadsRelatedToChannelId(java.lang.String allThreadsRelatedToChannelId) {
        this.allThreadsRelatedToChannelId = allThreadsRelatedToChannelId;
        return this;
      }

      /**
       * The channelId parameter instructs the API to return comment threads containing comments
       * about the specified channel. (The response will not include comments left on videos that
       * the channel uploaded.)
       */
      @com.google.api.client.util.Key
      private java.lang.String channelId;

      /** The channelId parameter instructs the API to return comment threads containing comments about the
     specified channel. (The response will not include comments left on videos that the channel
     uploaded.)
       */
      public java.lang.String getChannelId() {
        return channelId;
      }

      /**
       * The channelId parameter instructs the API to return comment threads containing comments
       * about the specified channel. (The response will not include comments left on videos that
       * the channel uploaded.)
       */
      public List setChannelId(java.lang.String channelId) {
        this.channelId = channelId;
        return this;
      }

      /**
       * The id parameter specifies a comma-separated list of comment thread IDs for the resources
       * that should be retrieved.
       */
      @com.google.api.client.util.Key
      private java.lang.String id;

      /** The id parameter specifies a comma-separated list of comment thread IDs for the resources that
     should be retrieved.
       */
      public java.lang.String getId() {
        return id;
      }

      /**
       * The id parameter specifies a comma-separated list of comment thread IDs for the resources
       * that should be retrieved.
       */
      public List setId(java.lang.String id) {
        this.id = id;
        return this;
      }

      /**
       * The maxResults parameter specifies the maximum number of items that should be returned in
       * the result set.
       *
       * Note: This parameter is not supported for use in conjunction with the id parameter.
       */
      @com.google.api.client.util.Key
      private java.lang.Long maxResults;

      /** The maxResults parameter specifies the maximum number of items that should be returned in the
     result set.

     Note: This parameter is not supported for use in conjunction with the id parameter. [default: 20]
     [minimum: 1] [maximum: 100]
       */
      public java.lang.Long getMaxResults() {
        return maxResults;
      }

      /**
       * The maxResults parameter specifies the maximum number of items that should be returned in
       * the result set.
       *
       * Note: This parameter is not supported for use in conjunction with the id parameter.
       */
      public List setMaxResults(java.lang.Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      /**
       * Set this parameter to limit the returned comment threads to a particular moderation state.
       *
       * Note: This parameter is not supported for use in conjunction with the id parameter.
       */
      @com.google.api.client.util.Key
      private java.lang.String moderationStatus;

      /** Set this parameter to limit the returned comment threads to a particular moderation state.

     Note: This parameter is not supported for use in conjunction with the id parameter. [default:
     MODERATION_STATUS_PUBLISHED]
       */
      public java.lang.String getModerationStatus() {
        return moderationStatus;
      }

      /**
       * Set this parameter to limit the returned comment threads to a particular moderation state.
       *
       * Note: This parameter is not supported for use in conjunction with the id parameter.
       */
      public List setModerationStatus(java.lang.String moderationStatus) {
        this.moderationStatus = moderationStatus;
        return this;
      }

      /**
       * The order parameter specifies the order in which the API response should list comment
       * threads. Valid values are: - time - Comment threads are ordered by time. This is the
       * default behavior. - relevance - Comment threads are ordered by relevance.Note: This
       * parameter is not supported for use in conjunction with the id parameter.
       */
      @com.google.api.client.util.Key
      private java.lang.String order;

      /** The order parameter specifies the order in which the API response should list comment threads.
     Valid values are: - time - Comment threads are ordered by time. This is the default behavior. -
     relevance - Comment threads are ordered by relevance.Note: This parameter is not supported for use
     in conjunction with the id parameter. [default: true]
       */
      public java.lang.String getOrder() {
        return order;
      }

      /**
       * The order parameter specifies the order in which the API response should list comment
       * threads. Valid values are: - time - Comment threads are ordered by time. This is the
       * default behavior. - relevance - Comment threads are ordered by relevance.Note: This
       * parameter is not supported for use in conjunction with the id parameter.
       */
      public List setOrder(java.lang.String order) {
        this.order = order;
        return this;
      }

      /**
       * The pageToken parameter identifies a specific page in the result set that should be
       * returned. In an API response, the nextPageToken property identifies the next page of the
       * result that can be retrieved.
       *
       * Note: This parameter is not supported for use in conjunction with the id parameter.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** The pageToken parameter identifies a specific page in the result set that should be returned. In an
     API response, the nextPageToken property identifies the next page of the result that can be
     retrieved.

     Note: This parameter is not supported for use in conjunction with the id parameter.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * The pageToken parameter identifies a specific page in the result set that should be
       * returned. In an API response, the nextPageToken property identifies the next page of the
       * result that can be retrieved.
       *
       * Note: This parameter is not supported for use in conjunction with the id parameter.
       */
      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      /**
       * The searchTerms parameter instructs the API to limit the API response to only contain
       * comments that contain the specified search terms.
       *
       * Note: This parameter is not supported for use in conjunction with the id parameter.
       */
      @com.google.api.client.util.Key
      private java.lang.String searchTerms;

      /** The searchTerms parameter instructs the API to limit the API response to only contain comments that
     contain the specified search terms.

     Note: This parameter is not supported for use in conjunction with the id parameter.
       */
      public java.lang.String getSearchTerms() {
        return searchTerms;
      }

      /**
       * The searchTerms parameter instructs the API to limit the API response to only contain
       * comments that contain the specified search terms.
       *
       * Note: This parameter is not supported for use in conjunction with the id parameter.
       */
      public List setSearchTerms(java.lang.String searchTerms) {
        this.searchTerms = searchTerms;
        return this;
      }

      /**
       * Set this parameter's value to html or plainText to instruct the API to return the comments
       * left by users in html formatted or in plain text.
       */
      @com.google.api.client.util.Key
      private java.lang.String textFormat;

      /** Set this parameter's value to html or plainText to instruct the API to return the comments left by
     users in html formatted or in plain text. [default: FORMAT_HTML]
       */
      public java.lang.String getTextFormat() {
        return textFormat;
      }

      /**
       * Set this parameter's value to html or plainText to instruct the API to return the comments
       * left by users in html formatted or in plain text.
       */
      public List setTextFormat(java.lang.String textFormat) {
        this.textFormat = textFormat;
        return this;
      }

      /**
       * The videoId parameter instructs the API to return comment threads associated with the
       * specified video ID.
       */
      @com.google.api.client.util.Key
      private java.lang.String videoId;

      /** The videoId parameter instructs the API to return comment threads associated with the specified
     video ID.
       */
      public java.lang.String getVideoId() {
        return videoId;
      }

      /**
       * The videoId parameter instructs the API to return comment threads associated with the
       * specified video ID.
       */
      public List setVideoId(java.lang.String videoId) {
        this.videoId = videoId;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }
    /**
     * Modifies the top-level comment in a comment thread.
     *
     * Create a request for the method "commentThreads.update".
     *
     * This request holds the parameters needed by the youtube server.  After setting any optional
     * parameters, call the {@link Update#execute()} method to invoke the remote operation.
     *
     * @param part The part parameter specifies a comma-separated list of commentThread resource properties that the
     *        API response will include. You must at least include the snippet part in the parameter
     *        value since that part contains all of the properties that the API request can update.
     * @param content the {@link com.google.api.services.youtube.model.CommentThread}
     * @return the request
     */
    public Update update(java.lang.String part, com.google.api.services.youtube.model.CommentThread content) throws java.io.IOException {
      Update result = new Update(part, content);
      initialize(result);
      return result;
    }

    public class Update extends YouTubeRequest<com.google.api.services.youtube.model.CommentThread> {

      private static final String REST_PATH = "commentThreads";

      /**
       * Modifies the top-level comment in a comment thread.
       *
       * Create a request for the method "commentThreads.update".
       *
       * This request holds the parameters needed by the the youtube server.  After setting any optional
       * parameters, call the {@link Update#execute()} method to invoke the remote operation. <p> {@link
       * Update#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param part The part parameter specifies a comma-separated list of commentThread resource properties that the
     *        API response will include. You must at least include the snippet part in the parameter
     *        value since that part contains all of the properties that the API request can update.
       * @param content the {@link com.google.api.services.youtube.model.CommentThread}
       * @since 1.13
       */
      protected Update(java.lang.String part, com.google.api.services.youtube.model.CommentThread content) {
        super(YouTube.this, "PUT", REST_PATH, content, com.google.api.services.youtube.model.CommentThread.class);
        this.part = com.google.api.client.util.Preconditions.checkNotNull(part, "Required parameter part must be specified.");
      }

      @Override
      public Update setAlt(java.lang.String alt) {
        return (Update) super.setAlt(alt);
      }

      @Override
      public Update setFields(java.lang.String fields) {
        return (Update) super.setFields(fields);
      }

      @Override
      public Update setKey(java.lang.String key) {
        return (Update) super.setKey(key);
      }

      @Override
      public Update setOauthToken(java.lang.String oauthToken) {
        return (Update) super.setOauthToken(oauthToken);
      }

      @Override
      public Update setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Update) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Update setQuotaUser(java.lang.String quotaUser) {
        return (Update) super.setQuotaUser(quotaUser);
      }

      @Override
      public Update setUserIp(java.lang.String userIp) {
        return (Update) super.setUserIp(userIp);
      }

      /**
       * The part parameter specifies a comma-separated list of commentThread resource properties
       * that the API response will include. You must at least include the snippet part in the
       * parameter value since that part contains all of the properties that the API request can
       * update.
       */
      @com.google.api.client.util.Key
      private java.lang.String part;

      /** The part parameter specifies a comma-separated list of commentThread resource properties that the
     API response will include. You must at least include the snippet part in the parameter value since
     that part contains all of the properties that the API request can update.
       */
      public java.lang.String getPart() {
        return part;
      }

      /**
       * The part parameter specifies a comma-separated list of commentThread resource properties
       * that the API response will include. You must at least include the snippet part in the
       * parameter value since that part contains all of the properties that the API request can
       * update.
       */
      public Update setPart(java.lang.String part) {
        this.part = part;
        return this;
      }

      @Override
      public Update set(String parameterName, Object value) {
        return (Update) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the Comments collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code YouTube youtube = new YouTube(...);}
   *   {@code YouTube.Comments.List request = youtube.comments().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Comments comments() {
    return new Comments();
  }

  /**
   * The "comments" collection of methods.
   */
  public class Comments {

    /**
     * Deletes a comment.
     *
     * Create a request for the method "comments.delete".
     *
     * This request holds the parameters needed by the youtube server.  After setting any optional
     * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
     *
     * @param id The id parameter specifies the comment ID for the resource that is being deleted.
     * @return the request
     */
    public Delete delete(java.lang.String id) throws java.io.IOException {
      Delete result = new Delete(id);
      initialize(result);
      return result;
    }

    public class Delete extends YouTubeRequest<Void> {

      private static final String REST_PATH = "comments";

      /**
       * Deletes a comment.
       *
       * Create a request for the method "comments.delete".
       *
       * This request holds the parameters needed by the the youtube server.  After setting any optional
       * parameters, call the {@link Delete#execute()} method to invoke the remote operation. <p> {@link
       * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param id The id parameter specifies the comment ID for the resource that is being deleted.
       * @since 1.13
       */
      protected Delete(java.lang.String id) {
        super(YouTube.this, "DELETE", REST_PATH, null, Void.class);
        this.id = com.google.api.client.util.Preconditions.checkNotNull(id, "Required parameter id must be specified.");
      }

      @Override
      public Delete setAlt(java.lang.String alt) {
        return (Delete) super.setAlt(alt);
      }

      @Override
      public Delete setFields(java.lang.String fields) {
        return (Delete) super.setFields(fields);
      }

      @Override
      public Delete setKey(java.lang.String key) {
        return (Delete) super.setKey(key);
      }

      @Override
      public Delete setOauthToken(java.lang.String oauthToken) {
        return (Delete) super.setOauthToken(oauthToken);
      }

      @Override
      public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Delete) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Delete setQuotaUser(java.lang.String quotaUser) {
        return (Delete) super.setQuotaUser(quotaUser);
      }

      @Override
      public Delete setUserIp(java.lang.String userIp) {
        return (Delete) super.setUserIp(userIp);
      }

      /** The id parameter specifies the comment ID for the resource that is being deleted. */
      @com.google.api.client.util.Key
      private java.lang.String id;

      /** The id parameter specifies the comment ID for the resource that is being deleted.
       */
      public java.lang.String getId() {
        return id;
      }

      /** The id parameter specifies the comment ID for the resource that is being deleted. */
      public Delete setId(java.lang.String id) {
        this.id = id;
        return this;
      }

      @Override
      public Delete set(String parameterName, Object value) {
        return (Delete) super.set(parameterName, value);
      }
    }
    /**
     * Creates a reply to an existing comment. Note: To create a top-level comment, use the
     * commentThreads.insert method.
     *
     * Create a request for the method "comments.insert".
     *
     * This request holds the parameters needed by the youtube server.  After setting any optional
     * parameters, call the {@link Insert#execute()} method to invoke the remote operation.
     *
     * @param part The part parameter identifies the properties that the API response will include. Set the parameter
     *        value to snippet. The snippet part has a quota cost of 2 units.
     * @param content the {@link com.google.api.services.youtube.model.Comment}
     * @return the request
     */
    public Insert insert(java.lang.String part, com.google.api.services.youtube.model.Comment content) throws java.io.IOException {
      Insert result = new Insert(part, content);
      initialize(result);
      return result;
    }

    public class Insert extends YouTubeRequest<com.google.api.services.youtube.model.Comment> {

      private static final String REST_PATH = "comments";

      /**
       * Creates a reply to an existing comment. Note: To create a top-level comment, use the
       * commentThreads.insert method.
       *
       * Create a request for the method "comments.insert".
       *
       * This request holds the parameters needed by the the youtube server.  After setting any optional
       * parameters, call the {@link Insert#execute()} method to invoke the remote operation. <p> {@link
       * Insert#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param part The part parameter identifies the properties that the API response will include. Set the parameter
     *        value to snippet. The snippet part has a quota cost of 2 units.
       * @param content the {@link com.google.api.services.youtube.model.Comment}
       * @since 1.13
       */
      protected Insert(java.lang.String part, com.google.api.services.youtube.model.Comment content) {
        super(YouTube.this, "POST", REST_PATH, content, com.google.api.services.youtube.model.Comment.class);
        this.part = com.google.api.client.util.Preconditions.checkNotNull(part, "Required parameter part must be specified.");
      }

      @Override
      public Insert setAlt(java.lang.String alt) {
        return (Insert) super.setAlt(alt);
      }

      @Override
      public Insert setFields(java.lang.String fields) {
        return (Insert) super.setFields(fields);
      }

      @Override
      public Insert setKey(java.lang.String key) {
        return (Insert) super.setKey(key);
      }

      @Override
      public Insert setOauthToken(java.lang.String oauthToken) {
        return (Insert) super.setOauthToken(oauthToken);
      }

      @Override
      public Insert setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Insert) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Insert setQuotaUser(java.lang.String quotaUser) {
        return (Insert) super.setQuotaUser(quotaUser);
      }

      @Override
      public Insert setUserIp(java.lang.String userIp) {
        return (Insert) super.setUserIp(userIp);
      }

      /**
       * The part parameter identifies the properties that the API response will include. Set the
       * parameter value to snippet. The snippet part has a quota cost of 2 units.
       */
      @com.google.api.client.util.Key
      private java.lang.String part;

      /** The part parameter identifies the properties that the API response will include. Set the parameter
     value to snippet. The snippet part has a quota cost of 2 units.
       */
      public java.lang.String getPart() {
        return part;
      }

      /**
       * The part parameter identifies the properties that the API response will include. Set the
       * parameter value to snippet. The snippet part has a quota cost of 2 units.
       */
      public Insert setPart(java.lang.String part) {
        this.part = part;
        return this;
      }

      @Override
      public Insert set(String parameterName, Object value) {
        return (Insert) super.set(parameterName, value);
      }
    }
    /**
     * Returns a list of comments that match the API request parameters.
     *
     * Create a request for the method "comments.list".
     *
     * This request holds the parameters needed by the youtube server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param part The part parameter specifies a comma-separated list of one or more comment resource properties that
     *        the API response will include.
     * @return the request
     */
    public List list(java.lang.String part) throws java.io.IOException {
      List result = new List(part);
      initialize(result);
      return result;
    }

    public class List extends YouTubeRequest<com.google.api.services.youtube.model.CommentListResponse> {

      private static final String REST_PATH = "comments";

      /**
       * Returns a list of comments that match the API request parameters.
       *
       * Create a request for the method "comments.list".
       *
       * This request holds the parameters needed by the the youtube server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param part The part parameter specifies a comma-separated list of one or more comment resource properties that
     *        the API response will include.
       * @since 1.13
       */
      protected List(java.lang.String part) {
        super(YouTube.this, "GET", REST_PATH, null, com.google.api.services.youtube.model.CommentListResponse.class);
        this.part = com.google.api.client.util.Preconditions.checkNotNull(part, "Required parameter part must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUserIp(java.lang.String userIp) {
        return (List) super.setUserIp(userIp);
      }

      /**
       * The part parameter specifies a comma-separated list of one or more comment resource
       * properties that the API response will include.
       */
      @com.google.api.client.util.Key
      private java.lang.String part;

      /** The part parameter specifies a comma-separated list of one or more comment resource properties that
     the API response will include.
       */
      public java.lang.String getPart() {
        return part;
      }

      /**
       * The part parameter specifies a comma-separated list of one or more comment resource
       * properties that the API response will include.
       */
      public List setPart(java.lang.String part) {
        this.part = part;
        return this;
      }

      /**
       * The id parameter specifies a comma-separated list of comment IDs for the resources that are
       * being retrieved. In a comment resource, the id property specifies the comment's ID.
       */
      @com.google.api.client.util.Key
      private java.lang.String id;

      /** The id parameter specifies a comma-separated list of comment IDs for the resources that are being
     retrieved. In a comment resource, the id property specifies the comment's ID.
       */
      public java.lang.String getId() {
        return id;
      }

      /**
       * The id parameter specifies a comma-separated list of comment IDs for the resources that are
       * being retrieved. In a comment resource, the id property specifies the comment's ID.
       */
      public List setId(java.lang.String id) {
        this.id = id;
        return this;
      }

      /**
       * The maxResults parameter specifies the maximum number of items that should be returned in
       * the result set.
       *
       * Note: This parameter is not supported for use in conjunction with the id parameter.
       */
      @com.google.api.client.util.Key
      private java.lang.Long maxResults;

      /** The maxResults parameter specifies the maximum number of items that should be returned in the
     result set.

     Note: This parameter is not supported for use in conjunction with the id parameter. [default: 20]
     [minimum: 1] [maximum: 100]
       */
      public java.lang.Long getMaxResults() {
        return maxResults;
      }

      /**
       * The maxResults parameter specifies the maximum number of items that should be returned in
       * the result set.
       *
       * Note: This parameter is not supported for use in conjunction with the id parameter.
       */
      public List setMaxResults(java.lang.Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      /**
       * The pageToken parameter identifies a specific page in the result set that should be
       * returned. In an API response, the nextPageToken property identifies the next page of the
       * result that can be retrieved.
       *
       * Note: This parameter is not supported for use in conjunction with the id parameter.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** The pageToken parameter identifies a specific page in the result set that should be returned. In an
     API response, the nextPageToken property identifies the next page of the result that can be
     retrieved.

     Note: This parameter is not supported for use in conjunction with the id parameter.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * The pageToken parameter identifies a specific page in the result set that should be
       * returned. In an API response, the nextPageToken property identifies the next page of the
       * result that can be retrieved.
       *
       * Note: This parameter is not supported for use in conjunction with the id parameter.
       */
      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      /**
       * The parentId parameter specifies the ID of the comment for which replies should be
       * retrieved.
       *
       * Note: YouTube currently supports replies only for top-level comments. However, replies to
       * replies may be supported in the future.
       */
      @com.google.api.client.util.Key
      private java.lang.String parentId;

      /** The parentId parameter specifies the ID of the comment for which replies should be retrieved.

     Note: YouTube currently supports replies only for top-level comments. However, replies to replies
     may be supported in the future.
       */
      public java.lang.String getParentId() {
        return parentId;
      }

      /**
       * The parentId parameter specifies the ID of the comment for which replies should be
       * retrieved.
       *
       * Note: YouTube currently supports replies only for top-level comments. However, replies to
       * replies may be supported in the future.
       */
      public List setParentId(java.lang.String parentId) {
        this.parentId = parentId;
        return this;
      }

      /**
       * This parameter indicates whether the API should return comments formatted as HTML or as
       * plain text.
       */
      @com.google.api.client.util.Key
      private java.lang.String textFormat;

      /** This parameter indicates whether the API should return comments formatted as HTML or as plain text.
     [default: FORMAT_HTML]
       */
      public java.lang.String getTextFormat() {
        return textFormat;
      }

      /**
       * This parameter indicates whether the API should return comments formatted as HTML or as
       * plain text.
       */
      public List setTextFormat(java.lang.String textFormat) {
        this.textFormat = textFormat;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }
    /**
     * Expresses the caller's opinion that one or more comments should be flagged as spam.
     *
     * Create a request for the method "comments.markAsSpam".
     *
     * This request holds the parameters needed by the youtube server.  After setting any optional
     * parameters, call the {@link MarkAsSpam#execute()} method to invoke the remote operation.
     *
     * @param id The id parameter specifies a comma-separated list of IDs of comments that the caller believes should
     *        be classified as spam.
     * @return the request
     */
    public MarkAsSpam markAsSpam(java.lang.String id) throws java.io.IOException {
      MarkAsSpam result = new MarkAsSpam(id);
      initialize(result);
      return result;
    }

    public class MarkAsSpam extends YouTubeRequest<Void> {

      private static final String REST_PATH = "comments/markAsSpam";

      /**
       * Expresses the caller's opinion that one or more comments should be flagged as spam.
       *
       * Create a request for the method "comments.markAsSpam".
       *
       * This request holds the parameters needed by the the youtube server.  After setting any optional
       * parameters, call the {@link MarkAsSpam#execute()} method to invoke the remote operation. <p>
       * {@link
       * MarkAsSpam#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param id The id parameter specifies a comma-separated list of IDs of comments that the caller believes should
     *        be classified as spam.
       * @since 1.13
       */
      protected MarkAsSpam(java.lang.String id) {
        super(YouTube.this, "POST", REST_PATH, null, Void.class);
        this.id = com.google.api.client.util.Preconditions.checkNotNull(id, "Required parameter id must be specified.");
      }

      @Override
      public MarkAsSpam setAlt(java.lang.String alt) {
        return (MarkAsSpam) super.setAlt(alt);
      }

      @Override
      public MarkAsSpam setFields(java.lang.String fields) {
        return (MarkAsSpam) super.setFields(fields);
      }

      @Override
      public MarkAsSpam setKey(java.lang.String key) {
        return (MarkAsSpam) super.setKey(key);
      }

      @Override
      public MarkAsSpam setOauthToken(java.lang.String oauthToken) {
        return (MarkAsSpam) super.setOauthToken(oauthToken);
      }

      @Override
      public MarkAsSpam setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (MarkAsSpam) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public MarkAsSpam setQuotaUser(java.lang.String quotaUser) {
        return (MarkAsSpam) super.setQuotaUser(quotaUser);
      }

      @Override
      public MarkAsSpam setUserIp(java.lang.String userIp) {
        return (MarkAsSpam) super.setUserIp(userIp);
      }

      /**
       * The id parameter specifies a comma-separated list of IDs of comments that the caller
       * believes should be classified as spam.
       */
      @com.google.api.client.util.Key
      private java.lang.String id;

      /** The id parameter specifies a comma-separated list of IDs of comments that the caller believes
     should be classified as spam.
       */
      public java.lang.String getId() {
        return id;
      }

      /**
       * The id parameter specifies a comma-separated list of IDs of comments that the caller
       * believes should be classified as spam.
       */
      public MarkAsSpam setId(java.lang.String id) {
        this.id = id;
        return this;
      }

      @Override
      public MarkAsSpam set(String parameterName, Object value) {
        return (MarkAsSpam) super.set(parameterName, value);
      }
    }
    /**
     * Sets the moderation status of one or more comments. The API request must be authorized by the
     * owner of the channel or video associated with the comments.
     *
     * Create a request for the method "comments.setModerationStatus".
     *
     * This request holds the parameters needed by the youtube server.  After setting any optional
     * parameters, call the {@link SetModerationStatus#execute()} method to invoke the remote operation.
     *
     * @param id The id parameter specifies a comma-separated list of IDs that identify the comments for which you
     *        are updating the moderation status.
     * @param moderationStatus Identifies the new moderation status of the specified comments.
     * @return the request
     */
    public SetModerationStatus setModerationStatus(java.lang.String id, java.lang.String moderationStatus) throws java.io.IOException {
      SetModerationStatus result = new SetModerationStatus(id, moderationStatus);
      initialize(result);
      return result;
    }

    public class SetModerationStatus extends YouTubeRequest<Void> {

      private static final String REST_PATH = "comments/setModerationStatus";

      /**
       * Sets the moderation status of one or more comments. The API request must be authorized by the
       * owner of the channel or video associated with the comments.
       *
       * Create a request for the method "comments.setModerationStatus".
       *
       * This request holds the parameters needed by the the youtube server.  After setting any optional
       * parameters, call the {@link SetModerationStatus#execute()} method to invoke the remote
       * operation. <p> {@link SetModerationStatus#initialize(com.google.api.client.googleapis.services.
       * AbstractGoogleClientRequest)} must be called to initialize this instance immediately after
       * invoking the constructor. </p>
       *
       * @param id The id parameter specifies a comma-separated list of IDs that identify the comments for which you
     *        are updating the moderation status.
       * @param moderationStatus Identifies the new moderation status of the specified comments.
       * @since 1.13
       */
      protected SetModerationStatus(java.lang.String id, java.lang.String moderationStatus) {
        super(YouTube.this, "POST", REST_PATH, null, Void.class);
        this.id = com.google.api.client.util.Preconditions.checkNotNull(id, "Required parameter id must be specified.");
        this.moderationStatus = com.google.api.client.util.Preconditions.checkNotNull(moderationStatus, "Required parameter moderationStatus must be specified.");
      }

      @Override
      public SetModerationStatus setAlt(java.lang.String alt) {
        return (SetModerationStatus) super.setAlt(alt);
      }

      @Override
      public SetModerationStatus setFields(java.lang.String fields) {
        return (SetModerationStatus) super.setFields(fields);
      }

      @Override
      public SetModerationStatus setKey(java.lang.String key) {
        return (SetModerationStatus) super.setKey(key);
      }

      @Override
      public SetModerationStatus setOauthToken(java.lang.String oauthToken) {
        return (SetModerationStatus) super.setOauthToken(oauthToken);
      }

      @Override
      public SetModerationStatus setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (SetModerationStatus) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public SetModerationStatus setQuotaUser(java.lang.String quotaUser) {
        return (SetModerationStatus) super.setQuotaUser(quotaUser);
      }

      @Override
      public SetModerationStatus setUserIp(java.lang.String userIp) {
        return (SetModerationStatus) super.setUserIp(userIp);
      }

      /**
       * The id parameter specifies a comma-separated list of IDs that identify the comments for
       * which you are updating the moderation status.
       */
      @com.google.api.client.util.Key
      private java.lang.String id;

      /** The id parameter specifies a comma-separated list of IDs that identify the comments for which you
     are updating the moderation status.
       */
      public java.lang.String getId() {
        return id;
      }

      /**
       * The id parameter specifies a comma-separated list of IDs that identify the comments for
       * which you are updating the moderation status.
       */
      public SetModerationStatus setId(java.lang.String id) {
        this.id = id;
        return this;
      }

      /** Identifies the new moderation status of the specified comments. */
      @com.google.api.client.util.Key
      private java.lang.String moderationStatus;

      /** Identifies the new moderation status of the specified comments.
       */
      public java.lang.String getModerationStatus() {
        return moderationStatus;
      }

      /** Identifies the new moderation status of the specified comments. */
      public SetModerationStatus setModerationStatus(java.lang.String moderationStatus) {
        this.moderationStatus = moderationStatus;
        return this;
      }

      /**
       * The banAuthor parameter lets you indicate that you want to automatically reject any
       * additional comments written by the comment's author. Set the parameter value to true to ban
       * the author.
       *
       * Note: This parameter is only valid if the moderationStatus parameter is also set to
       * rejected.
       */
      @com.google.api.client.util.Key
      private java.lang.Boolean banAuthor;

      /** The banAuthor parameter lets you indicate that you want to automatically reject any additional
     comments written by the comment's author. Set the parameter value to true to ban the author.

     Note: This parameter is only valid if the moderationStatus parameter is also set to rejected.
     [default: false]
       */
      public java.lang.Boolean getBanAuthor() {
        return banAuthor;
      }

      /**
       * The banAuthor parameter lets you indicate that you want to automatically reject any
       * additional comments written by the comment's author. Set the parameter value to true to ban
       * the author.
       *
       * Note: This parameter is only valid if the moderationStatus parameter is also set to
       * rejected.
       */
      public SetModerationStatus setBanAuthor(java.lang.Boolean banAuthor) {
        this.banAuthor = banAuthor;
        return this;
      }

      /**
       * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
       *
       * <p>
       * Boolean properties can have four possible values:
       * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
       * or {@link Boolean#FALSE}.
       * </p>
       *
       * <p>
       * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
       * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
       * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * </p>
       *
       * <p>
       * The banAuthor parameter lets you indicate that you want to automatically reject any additional
     comments written by the comment's author. Set the parameter value to true to ban the author.
     Note: This parameter is only valid if the moderationStatus parameter is also set to rejected.
       * </p>
       */
      public boolean isBanAuthor() {
        if (banAuthor == null || banAuthor == com.google.api.client.util.Data.NULL_BOOLEAN) {
          return false;
        }
        return banAuthor;
      }

      @Override
      public SetModerationStatus set(String parameterName, Object value) {
        return (SetModerationStatus) super.set(parameterName, value);
      }
    }
    /**
     * Modifies a comment.
     *
     * Create a request for the method "comments.update".
     *
     * This request holds the parameters needed by the youtube server.  After setting any optional
     * parameters, call the {@link Update#execute()} method to invoke the remote operation.
     *
     * @param part The part parameter identifies the properties that the API response will include. You must at least
     *        include the snippet part in the parameter value since that part contains all of the
     *        properties that the API request can update.
     * @param content the {@link com.google.api.services.youtube.model.Comment}
     * @return the request
     */
    public Update update(java.lang.String part, com.google.api.services.youtube.model.Comment content) throws java.io.IOException {
      Update result = new Update(part, content);
      initialize(result);
      return result;
    }

    public class Update extends YouTubeRequest<com.google.api.services.youtube.model.Comment> {

      private static final String REST_PATH = "comments";

      /**
       * Modifies a comment.
       *
       * Create a request for the method "comments.update".
       *
       * This request holds the parameters needed by the the youtube server.  After setting any optional
       * parameters, call the {@link Update#execute()} method to invoke the remote operation. <p> {@link
       * Update#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param part The part parameter identifies the properties that the API response will include. You must at least
     *        include the snippet part in the parameter value since that part contains all of the
     *        properties that the API request can update.
       * @param content the {@link com.google.api.services.youtube.model.Comment}
       * @since 1.13
       */
      protected Update(java.lang.String part, com.google.api.services.youtube.model.Comment content) {
        super(YouTube.this, "PUT", REST_PATH, content, com.google.api.services.youtube.model.Comment.class);
        this.part = com.google.api.client.util.Preconditions.checkNotNull(part, "Required parameter part must be specified.");
      }

      @Override
      public Update setAlt(java.lang.String alt) {
        return (Update) super.setAlt(alt);
      }

      @Override
      public Update setFields(java.lang.String fields) {
        return (Update) super.setFields(fields);
      }

      @Override
      public Update setKey(java.lang.String key) {
        return (Update) super.setKey(key);
      }

      @Override
      public Update setOauthToken(java.lang.String oauthToken) {
        return (Update) super.setOauthToken(oauthToken);
      }

      @Override
      public Update setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Update) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Update setQuotaUser(java.lang.String quotaUser) {
        return (Update) super.setQuotaUser(quotaUser);
      }

      @Override
      public Update setUserIp(java.lang.String userIp) {
        return (Update) super.setUserIp(userIp);
      }

      /**
       * The part parameter identifies the properties that the API response will include. You must
       * at least include the snippet part in the parameter value since that part contains all of
       * the properties that the API request can update.
       */
      @com.google.api.client.util.Key
      private java.lang.String part;

      /** The part parameter identifies the properties that the API response will include. You must at least
     include the snippet part in the parameter value since that part contains all of the properties that
     the API request can update.
       */
      public java.lang.String getPart() {
        return part;
      }

      /**
       * The part parameter identifies the properties that the API response will include. You must
       * at least include the snippet part in the parameter value since that part contains all of
       * the properties that the API request can update.
       */
      public Update setPart(java.lang.String part) {
        this.part = part;
        return this;
      }

      @Override
      public Update set(String parameterName, Object value) {
        return (Update) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the GuideCategories collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code YouTube youtube = new YouTube(...);}
   *   {@code YouTube.GuideCategories.List request = youtube.guideCategories().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public GuideCategories guideCategories() {
    return new GuideCategories();
  }

  /**
   * The "guideCategories" collection of methods.
   */
  public class GuideCategories {

    /**
     * Returns a list of categories that can be associated with YouTube channels.
     *
     * Create a request for the method "guideCategories.list".
     *
     * This request holds the parameters needed by the youtube server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param part The part parameter specifies the guideCategory resource properties that the API response will
     *        include. Set the parameter value to snippet.
     * @return the request
     */
    public List list(java.lang.String part) throws java.io.IOException {
      List result = new List(part);
      initialize(result);
      return result;
    }

    public class List extends YouTubeRequest<com.google.api.services.youtube.model.GuideCategoryListResponse> {

      private static final String REST_PATH = "guideCategories";

      /**
       * Returns a list of categories that can be associated with YouTube channels.
       *
       * Create a request for the method "guideCategories.list".
       *
       * This request holds the parameters needed by the the youtube server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param part The part parameter specifies the guideCategory resource properties that the API response will
     *        include. Set the parameter value to snippet.
       * @since 1.13
       */
      protected List(java.lang.String part) {
        super(YouTube.this, "GET", REST_PATH, null, com.google.api.services.youtube.model.GuideCategoryListResponse.class);
        this.part = com.google.api.client.util.Preconditions.checkNotNull(part, "Required parameter part must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUserIp(java.lang.String userIp) {
        return (List) super.setUserIp(userIp);
      }

      /**
       * The part parameter specifies the guideCategory resource properties that the API response
       * will include. Set the parameter value to snippet.
       */
      @com.google.api.client.util.Key
      private java.lang.String part;

      /** The part parameter specifies the guideCategory resource properties that the API response will
     include. Set the parameter value to snippet.
       */
      public java.lang.String getPart() {
        return part;
      }

      /**
       * The part parameter specifies the guideCategory resource properties that the API response
       * will include. Set the parameter value to snippet.
       */
      public List setPart(java.lang.String part) {
        this.part = part;
        return this;
      }

      /**
       * The hl parameter specifies the language that will be used for text values in the API
       * response.
       */
      @com.google.api.client.util.Key
      private java.lang.String hl;

      /** The hl parameter specifies the language that will be used for text values in the API response.
     [default: en-US]
       */
      public java.lang.String getHl() {
        return hl;
      }

      /**
       * The hl parameter specifies the language that will be used for text values in the API
       * response.
       */
      public List setHl(java.lang.String hl) {
        this.hl = hl;
        return this;
      }

      /**
       * The id parameter specifies a comma-separated list of the YouTube channel category ID(s) for
       * the resource(s) that are being retrieved. In a guideCategory resource, the id property
       * specifies the YouTube channel category ID.
       */
      @com.google.api.client.util.Key
      private java.lang.String id;

      /** The id parameter specifies a comma-separated list of the YouTube channel category ID(s) for the
     resource(s) that are being retrieved. In a guideCategory resource, the id property specifies the
     YouTube channel category ID.
       */
      public java.lang.String getId() {
        return id;
      }

      /**
       * The id parameter specifies a comma-separated list of the YouTube channel category ID(s) for
       * the resource(s) that are being retrieved. In a guideCategory resource, the id property
       * specifies the YouTube channel category ID.
       */
      public List setId(java.lang.String id) {
        this.id = id;
        return this;
      }

      /**
       * The regionCode parameter instructs the API to return the list of guide categories available
       * in the specified country. The parameter value is an ISO 3166-1 alpha-2 country code.
       */
      @com.google.api.client.util.Key
      private java.lang.String regionCode;

      /** The regionCode parameter instructs the API to return the list of guide categories available in the
     specified country. The parameter value is an ISO 3166-1 alpha-2 country code.
       */
      public java.lang.String getRegionCode() {
        return regionCode;
      }

      /**
       * The regionCode parameter instructs the API to return the list of guide categories available
       * in the specified country. The parameter value is an ISO 3166-1 alpha-2 country code.
       */
      public List setRegionCode(java.lang.String regionCode) {
        this.regionCode = regionCode;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the I18nLanguages collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code YouTube youtube = new YouTube(...);}
   *   {@code YouTube.I18nLanguages.List request = youtube.i18nLanguages().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public I18nLanguages i18nLanguages() {
    return new I18nLanguages();
  }

  /**
   * The "i18nLanguages" collection of methods.
   */
  public class I18nLanguages {

    /**
     * Returns a list of application languages that the YouTube website supports.
     *
     * Create a request for the method "i18nLanguages.list".
     *
     * This request holds the parameters needed by the youtube server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param part The part parameter specifies the i18nLanguage resource properties that the API response will
     *        include. Set the parameter value to snippet.
     * @return the request
     */
    public List list(java.lang.String part) throws java.io.IOException {
      List result = new List(part);
      initialize(result);
      return result;
    }

    public class List extends YouTubeRequest<com.google.api.services.youtube.model.I18nLanguageListResponse> {

      private static final String REST_PATH = "i18nLanguages";

      /**
       * Returns a list of application languages that the YouTube website supports.
       *
       * Create a request for the method "i18nLanguages.list".
       *
       * This request holds the parameters needed by the the youtube server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param part The part parameter specifies the i18nLanguage resource properties that the API response will
     *        include. Set the parameter value to snippet.
       * @since 1.13
       */
      protected List(java.lang.String part) {
        super(YouTube.this, "GET", REST_PATH, null, com.google.api.services.youtube.model.I18nLanguageListResponse.class);
        this.part = com.google.api.client.util.Preconditions.checkNotNull(part, "Required parameter part must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUserIp(java.lang.String userIp) {
        return (List) super.setUserIp(userIp);
      }

      /**
       * The part parameter specifies the i18nLanguage resource properties that the API response
       * will include. Set the parameter value to snippet.
       */
      @com.google.api.client.util.Key
      private java.lang.String part;

      /** The part parameter specifies the i18nLanguage resource properties that the API response will
     include. Set the parameter value to snippet.
       */
      public java.lang.String getPart() {
        return part;
      }

      /**
       * The part parameter specifies the i18nLanguage resource properties that the API response
       * will include. Set the parameter value to snippet.
       */
      public List setPart(java.lang.String part) {
        this.part = part;
        return this;
      }

      /**
       * The hl parameter specifies the language that should be used for text values in the API
       * response.
       */
      @com.google.api.client.util.Key
      private java.lang.String hl;

      /** The hl parameter specifies the language that should be used for text values in the API response.
     [default: en_US]
       */
      public java.lang.String getHl() {
        return hl;
      }

      /**
       * The hl parameter specifies the language that should be used for text values in the API
       * response.
       */
      public List setHl(java.lang.String hl) {
        this.hl = hl;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the I18nRegions collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code YouTube youtube = new YouTube(...);}
   *   {@code YouTube.I18nRegions.List request = youtube.i18nRegions().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public I18nRegions i18nRegions() {
    return new I18nRegions();
  }

  /**
   * The "i18nRegions" collection of methods.
   */
  public class I18nRegions {

    /**
     * Returns a list of content regions that the YouTube website supports.
     *
     * Create a request for the method "i18nRegions.list".
     *
     * This request holds the parameters needed by the youtube server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param part The part parameter specifies the i18nRegion resource properties that the API response will include.
     *        Set the parameter value to snippet.
     * @return the request
     */
    public List list(java.lang.String part) throws java.io.IOException {
      List result = new List(part);
      initialize(result);
      return result;
    }

    public class List extends YouTubeRequest<com.google.api.services.youtube.model.I18nRegionListResponse> {

      private static final String REST_PATH = "i18nRegions";

      /**
       * Returns a list of content regions that the YouTube website supports.
       *
       * Create a request for the method "i18nRegions.list".
       *
       * This request holds the parameters needed by the the youtube server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param part The part parameter specifies the i18nRegion resource properties that the API response will include.
     *        Set the parameter value to snippet.
       * @since 1.13
       */
      protected List(java.lang.String part) {
        super(YouTube.this, "GET", REST_PATH, null, com.google.api.services.youtube.model.I18nRegionListResponse.class);
        this.part = com.google.api.client.util.Preconditions.checkNotNull(part, "Required parameter part must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUserIp(java.lang.String userIp) {
        return (List) super.setUserIp(userIp);
      }

      /**
       * The part parameter specifies the i18nRegion resource properties that the API response will
       * include. Set the parameter value to snippet.
       */
      @com.google.api.client.util.Key
      private java.lang.String part;

      /** The part parameter specifies the i18nRegion resource properties that the API response will include.
     Set the parameter value to snippet.
       */
      public java.lang.String getPart() {
        return part;
      }

      /**
       * The part parameter specifies the i18nRegion resource properties that the API response will
       * include. Set the parameter value to snippet.
       */
      public List setPart(java.lang.String part) {
        this.part = part;
        return this;
      }

      /**
       * The hl parameter specifies the language that should be used for text values in the API
       * response.
       */
      @com.google.api.client.util.Key
      private java.lang.String hl;

      /** The hl parameter specifies the language that should be used for text values in the API response.
     [default: en_US]
       */
      public java.lang.String getHl() {
        return hl;
      }

      /**
       * The hl parameter specifies the language that should be used for text values in the API
       * response.
       */
      public List setHl(java.lang.String hl) {
        this.hl = hl;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the LiveBroadcasts collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code YouTube youtube = new YouTube(...);}
   *   {@code YouTube.LiveBroadcasts.List request = youtube.liveBroadcasts().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public LiveBroadcasts liveBroadcasts() {
    return new LiveBroadcasts();
  }

  /**
   * The "liveBroadcasts" collection of methods.
   */
  public class LiveBroadcasts {

    /**
     * Binds a YouTube broadcast to a stream or removes an existing binding between a broadcast and a
     * stream. A broadcast can only be bound to one video stream, though a video stream may be bound to
     * more than one broadcast.
     *
     * Create a request for the method "liveBroadcasts.bind".
     *
     * This request holds the parameters needed by the youtube server.  After setting any optional
     * parameters, call the {@link Bind#execute()} method to invoke the remote operation.
     *
     * @param id The id parameter specifies the unique ID of the broadcast that is being bound to a video stream.
     * @param part The part parameter specifies a comma-separated list of one or more liveBroadcast resource properties
     *        that the API response will include. The part names that you can include in the parameter
     *        value are id, snippet, contentDetails, and status.
     * @return the request
     */
    public Bind bind(java.lang.String id, java.lang.String part) throws java.io.IOException {
      Bind result = new Bind(id, part);
      initialize(result);
      return result;
    }

    public class Bind extends YouTubeRequest<com.google.api.services.youtube.model.LiveBroadcast> {

      private static final String REST_PATH = "liveBroadcasts/bind";

      /**
       * Binds a YouTube broadcast to a stream or removes an existing binding between a broadcast and a
       * stream. A broadcast can only be bound to one video stream, though a video stream may be bound
       * to more than one broadcast.
       *
       * Create a request for the method "liveBroadcasts.bind".
       *
       * This request holds the parameters needed by the the youtube server.  After setting any optional
       * parameters, call the {@link Bind#execute()} method to invoke the remote operation. <p> {@link
       * Bind#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param id The id parameter specifies the unique ID of the broadcast that is being bound to a video stream.
       * @param part The part parameter specifies a comma-separated list of one or more liveBroadcast resource properties
     *        that the API response will include. The part names that you can include in the parameter
     *        value are id, snippet, contentDetails, and status.
       * @since 1.13
       */
      protected Bind(java.lang.String id, java.lang.String part) {
        super(YouTube.this, "POST", REST_PATH, null, com.google.api.services.youtube.model.LiveBroadcast.class);
        this.id = com.google.api.client.util.Preconditions.checkNotNull(id, "Required parameter id must be specified.");
        this.part = com.google.api.client.util.Preconditions.checkNotNull(part, "Required parameter part must be specified.");
      }

      @Override
      public Bind setAlt(java.lang.String alt) {
        return (Bind) super.setAlt(alt);
      }

      @Override
      public Bind setFields(java.lang.String fields) {
        return (Bind) super.setFields(fields);
      }

      @Override
      public Bind setKey(java.lang.String key) {
        return (Bind) super.setKey(key);
      }

      @Override
      public Bind setOauthToken(java.lang.String oauthToken) {
        return (Bind) super.setOauthToken(oauthToken);
      }

      @Override
      public Bind setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Bind) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Bind setQuotaUser(java.lang.String quotaUser) {
        return (Bind) super.setQuotaUser(quotaUser);
      }

      @Override
      public Bind setUserIp(java.lang.String userIp) {
        return (Bind) super.setUserIp(userIp);
      }

      /**
       * The id parameter specifies the unique ID of the broadcast that is being bound to a video
       * stream.
       */
      @com.google.api.client.util.Key
      private java.lang.String id;

      /** The id parameter specifies the unique ID of the broadcast that is being bound to a video stream.
       */
      public java.lang.String getId() {
        return id;
      }

      /**
       * The id parameter specifies the unique ID of the broadcast that is being bound to a video
       * stream.
       */
      public Bind setId(java.lang.String id) {
        this.id = id;
        return this;
      }

      /**
       * The part parameter specifies a comma-separated list of one or more liveBroadcast resource
       * properties that the API response will include. The part names that you can include in the
       * parameter value are id, snippet, contentDetails, and status.
       */
      @com.google.api.client.util.Key
      private java.lang.String part;

      /** The part parameter specifies a comma-separated list of one or more liveBroadcast resource
     properties that the API response will include. The part names that you can include in the parameter
     value are id, snippet, contentDetails, and status.
       */
      public java.lang.String getPart() {
        return part;
      }

      /**
       * The part parameter specifies a comma-separated list of one or more liveBroadcast resource
       * properties that the API response will include. The part names that you can include in the
       * parameter value are id, snippet, contentDetails, and status.
       */
      public Bind setPart(java.lang.String part) {
        this.part = part;
        return this;
      }

      /**
       * Note: This parameter is intended exclusively for YouTube content partners.
       *
       * The onBehalfOfContentOwner parameter indicates that the request's authorization credentials
       * identify a YouTube CMS user who is acting on behalf of the content owner specified in the
       * parameter value. This parameter is intended for YouTube content partners that own and
       * manage many different YouTube channels. It allows content owners to authenticate once and
       * get access to all their video and channel data, without having to provide authentication
       * credentials for each individual channel. The CMS account that the user authenticates with
       * must be linked to the specified YouTube content owner.
       */
      @com.google.api.client.util.Key
      private java.lang.String onBehalfOfContentOwner;

      /** Note: This parameter is intended exclusively for YouTube content partners.

     The onBehalfOfContentOwner parameter indicates that the request's authorization credentials
     identify a YouTube CMS user who is acting on behalf of the content owner specified in the parameter
     value. This parameter is intended for YouTube content partners that own and manage many different
     YouTube channels. It allows content owners to authenticate once and get access to all their video
     and channel data, without having to provide authentication credentials for each individual channel.
     The CMS account that the user authenticates with must be linked to the specified YouTube content
     owner.
       */
      public java.lang.String getOnBehalfOfContentOwner() {
        return onBehalfOfContentOwner;
      }

      /**
       * Note: This parameter is intended exclusively for YouTube content partners.
       *
       * The onBehalfOfContentOwner parameter indicates that the request's authorization credentials
       * identify a YouTube CMS user who is acting on behalf of the content owner specified in the
       * parameter value. This parameter is intended for YouTube content partners that own and
       * manage many different YouTube channels. It allows content owners to authenticate once and
       * get access to all their video and channel data, without having to provide authentication
       * credentials for each individual channel. The CMS account that the user authenticates with
       * must be linked to the specified YouTube content owner.
       */
      public Bind setOnBehalfOfContentOwner(java.lang.String onBehalfOfContentOwner) {
        this.onBehalfOfContentOwner = onBehalfOfContentOwner;
        return this;
      }

      /**
       * This parameter can only be used in a properly authorized request. Note: This parameter is
       * intended exclusively for YouTube content partners.
       *
       * The onBehalfOfContentOwnerChannel parameter specifies the YouTube channel ID of the channel
       * to which a video is being added. This parameter is required when a request specifies a
       * value for the onBehalfOfContentOwner parameter, and it can only be used in conjunction with
       * that parameter. In addition, the request must be authorized using a CMS account that is
       * linked to the content owner that the onBehalfOfContentOwner parameter specifies. Finally,
       * the channel that the onBehalfOfContentOwnerChannel parameter value specifies must be linked
       * to the content owner that the onBehalfOfContentOwner parameter specifies.
       *
       * This parameter is intended for YouTube content partners that own and manage many different
       * YouTube channels. It allows content owners to authenticate once and perform actions on
       * behalf of the channel specified in the parameter value, without having to provide
       * authentication credentials for each separate channel.
       */
      @com.google.api.client.util.Key
      private java.lang.String onBehalfOfContentOwnerChannel;

      /** This parameter can only be used in a properly authorized request. Note: This parameter is intended
     exclusively for YouTube content partners.

     The onBehalfOfContentOwnerChannel parameter specifies the YouTube channel ID of the channel to
     which a video is being added. This parameter is required when a request specifies a value for the
     onBehalfOfContentOwner parameter, and it can only be used in conjunction with that parameter. In
     addition, the request must be authorized using a CMS account that is linked to the content owner
     that the onBehalfOfContentOwner parameter specifies. Finally, the channel that the
     onBehalfOfContentOwnerChannel parameter value specifies must be linked to the content owner that
     the onBehalfOfContentOwner parameter specifies.

     This parameter is intended for YouTube content partners that own and manage many different YouTube
     channels. It allows content owners to authenticate once and perform actions on behalf of the
     channel specified in the parameter value, without having to provide authentication credentials for
     each separate channel.
       */
      public java.lang.String getOnBehalfOfContentOwnerChannel() {
        return onBehalfOfContentOwnerChannel;
      }

      /**
       * This parameter can only be used in a properly authorized request. Note: This parameter is
       * intended exclusively for YouTube content partners.
       *
       * The onBehalfOfContentOwnerChannel parameter specifies the YouTube channel ID of the channel
       * to which a video is being added. This parameter is required when a request specifies a
       * value for the onBehalfOfContentOwner parameter, and it can only be used in conjunction with
       * that parameter. In addition, the request must be authorized using a CMS account that is
       * linked to the content owner that the onBehalfOfContentOwner parameter specifies. Finally,
       * the channel that the onBehalfOfContentOwnerChannel parameter value specifies must be linked
       * to the content owner that the onBehalfOfContentOwner parameter specifies.
       *
       * This parameter is intended for YouTube content partners that own and manage many different
       * YouTube channels. It allows content owners to authenticate once and perform actions on
       * behalf of the channel specified in the parameter value, without having to provide
       * authentication credentials for each separate channel.
       */
      public Bind setOnBehalfOfContentOwnerChannel(java.lang.String onBehalfOfContentOwnerChannel) {
        this.onBehalfOfContentOwnerChannel = onBehalfOfContentOwnerChannel;
        return this;
      }

      /**
       * The streamId parameter specifies the unique ID of the video stream that is being bound to a
       * broadcast. If this parameter is omitted, the API will remove any existing binding between
       * the broadcast and a video stream.
       */
      @com.google.api.client.util.Key
      private java.lang.String streamId;

      /** The streamId parameter specifies the unique ID of the video stream that is being bound to a
     broadcast. If this parameter is omitted, the API will remove any existing binding between the
     broadcast and a video stream.
       */
      public java.lang.String getStreamId() {
        return streamId;
      }

      /**
       * The streamId parameter specifies the unique ID of the video stream that is being bound to a
       * broadcast. If this parameter is omitted, the API will remove any existing binding between
       * the broadcast and a video stream.
       */
      public Bind setStreamId(java.lang.String streamId) {
        this.streamId = streamId;
        return this;
      }

      @Override
      public Bind set(String parameterName, Object value) {
        return (Bind) super.set(parameterName, value);
      }
    }
    /**
     * Controls the settings for a slate that can be displayed in the broadcast stream.
     *
     * Create a request for the method "liveBroadcasts.control".
     *
     * This request holds the parameters needed by the youtube server.  After setting any optional
     * parameters, call the {@link Control#execute()} method to invoke the remote operation.
     *
     * @param id The id parameter specifies the YouTube live broadcast ID that uniquely identifies the broadcast in
     *        which the slate is being updated.
     * @param part The part parameter specifies a comma-separated list of one or more liveBroadcast resource properties
     *        that the API response will include. The part names that you can include in the parameter
     *        value are id, snippet, contentDetails, and status.
     * @return the request
     */
    public Control control(java.lang.String id, java.lang.String part) throws java.io.IOException {
      Control result = new Control(id, part);
      initialize(result);
      return result;
    }

    public class Control extends YouTubeRequest<com.google.api.services.youtube.model.LiveBroadcast> {

      private static final String REST_PATH = "liveBroadcasts/control";

      /**
       * Controls the settings for a slate that can be displayed in the broadcast stream.
       *
       * Create a request for the method "liveBroadcasts.control".
       *
       * This request holds the parameters needed by the the youtube server.  After setting any optional
       * parameters, call the {@link Control#execute()} method to invoke the remote operation. <p>
       * {@link
       * Control#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param id The id parameter specifies the YouTube live broadcast ID that uniquely identifies the broadcast in
     *        which the slate is being updated.
       * @param part The part parameter specifies a comma-separated list of one or more liveBroadcast resource properties
     *        that the API response will include. The part names that you can include in the parameter
     *        value are id, snippet, contentDetails, and status.
       * @since 1.13
       */
      protected Control(java.lang.String id, java.lang.String part) {
        super(YouTube.this, "POST", REST_PATH, null, com.google.api.services.youtube.model.LiveBroadcast.class);
        this.id = com.google.api.client.util.Preconditions.checkNotNull(id, "Required parameter id must be specified.");
        this.part = com.google.api.client.util.Preconditions.checkNotNull(part, "Required parameter part must be specified.");
      }

      @Override
      public Control setAlt(java.lang.String alt) {
        return (Control) super.setAlt(alt);
      }

      @Override
      public Control setFields(java.lang.String fields) {
        return (Control) super.setFields(fields);
      }

      @Override
      public Control setKey(java.lang.String key) {
        return (Control) super.setKey(key);
      }

      @Override
      public Control setOauthToken(java.lang.String oauthToken) {
        return (Control) super.setOauthToken(oauthToken);
      }

      @Override
      public Control setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Control) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Control setQuotaUser(java.lang.String quotaUser) {
        return (Control) super.setQuotaUser(quotaUser);
      }

      @Override
      public Control setUserIp(java.lang.String userIp) {
        return (Control) super.setUserIp(userIp);
      }

      /**
       * The id parameter specifies the YouTube live broadcast ID that uniquely identifies the
       * broadcast in which the slate is being updated.
       */
      @com.google.api.client.util.Key
      private java.lang.String id;

      /** The id parameter specifies the YouTube live broadcast ID that uniquely identifies the broadcast in
     which the slate is being updated.
       */
      public java.lang.String getId() {
        return id;
      }

      /**
       * The id parameter specifies the YouTube live broadcast ID that uniquely identifies the
       * broadcast in which the slate is being updated.
       */
      public Control setId(java.lang.String id) {
        this.id = id;
        return this;
      }

      /**
       * The part parameter specifies a comma-separated list of one or more liveBroadcast resource
       * properties that the API response will include. The part names that you can include in the
       * parameter value are id, snippet, contentDetails, and status.
       */
      @com.google.api.client.util.Key
      private java.lang.String part;

      /** The part parameter specifies a comma-separated list of one or more liveBroadcast resource
     properties that the API response will include. The part names that you can include in the parameter
     value are id, snippet, contentDetails, and status.
       */
      public java.lang.String getPart() {
        return part;
      }

      /**
       * The part parameter specifies a comma-separated list of one or more liveBroadcast resource
       * properties that the API response will include. The part names that you can include in the
       * parameter value are id, snippet, contentDetails, and status.
       */
      public Control setPart(java.lang.String part) {
        this.part = part;
        return this;
      }

      /** The displaySlate parameter specifies whether the slate is being enabled or disabled. */
      @com.google.api.client.util.Key
      private java.lang.Boolean displaySlate;

      /** The displaySlate parameter specifies whether the slate is being enabled or disabled.
       */
      public java.lang.Boolean getDisplaySlate() {
        return displaySlate;
      }

      /** The displaySlate parameter specifies whether the slate is being enabled or disabled. */
      public Control setDisplaySlate(java.lang.Boolean displaySlate) {
        this.displaySlate = displaySlate;
        return this;
      }

      /**
       * The offsetTimeMs parameter specifies a positive time offset when the specified slate change
       * will occur. The value is measured in milliseconds from the beginning of the broadcast's
       * monitor stream, which is the time that the testing phase for the broadcast began. Even
       * though it is specified in milliseconds, the value is actually an approximation, and YouTube
       * completes the requested action as closely as possible to that time.
       *
       * If you do not specify a value for this parameter, then YouTube performs the action as soon
       * as possible. See the Getting started guide for more details.
       *
       * Important: You should only specify a value for this parameter if your broadcast stream is
       * delayed.
       */
      @com.google.api.client.util.Key
      private java.math.BigInteger offsetTimeMs;

      /** The offsetTimeMs parameter specifies a positive time offset when the specified slate change will
     occur. The value is measured in milliseconds from the beginning of the broadcast's monitor stream,
     which is the time that the testing phase for the broadcast began. Even though it is specified in
     milliseconds, the value is actually an approximation, and YouTube completes the requested action as
     closely as possible to that time.

     If you do not specify a value for this parameter, then YouTube performs the action as soon as
     possible. See the Getting started guide for more details.

     Important: You should only specify a value for this parameter if your broadcast stream is delayed.
       */
      public java.math.BigInteger getOffsetTimeMs() {
        return offsetTimeMs;
      }

      /**
       * The offsetTimeMs parameter specifies a positive time offset when the specified slate change
       * will occur. The value is measured in milliseconds from the beginning of the broadcast's
       * monitor stream, which is the time that the testing phase for the broadcast began. Even
       * though it is specified in milliseconds, the value is actually an approximation, and YouTube
       * completes the requested action as closely as possible to that time.
       *
       * If you do not specify a value for this parameter, then YouTube performs the action as soon
       * as possible. See the Getting started guide for more details.
       *
       * Important: You should only specify a value for this parameter if your broadcast stream is
       * delayed.
       */
      public Control setOffsetTimeMs(java.math.BigInteger offsetTimeMs) {
        this.offsetTimeMs = offsetTimeMs;
        return this;
      }

      /**
       * Note: This parameter is intended exclusively for YouTube content partners.
       *
       * The onBehalfOfContentOwner parameter indicates that the request's authorization credentials
       * identify a YouTube CMS user who is acting on behalf of the content owner specified in the
       * parameter value. This parameter is intended for YouTube content partners that own and
       * manage many different YouTube channels. It allows content owners to authenticate once and
       * get access to all their video and channel data, without having to provide authentication
       * credentials for each individual channel. The CMS account that the user authenticates with
       * must be linked to the specified YouTube content owner.
       */
      @com.google.api.client.util.Key
      private java.lang.String onBehalfOfContentOwner;

      /** Note: This parameter is intended exclusively for YouTube content partners.

     The onBehalfOfContentOwner parameter indicates that the request's authorization credentials
     identify a YouTube CMS user who is acting on behalf of the content owner specified in the parameter
     value. This parameter is intended for YouTube content partners that own and manage many different
     YouTube channels. It allows content owners to authenticate once and get access to all their video
     and channel data, without having to provide authentication credentials for each individual channel.
     The CMS account that the user authenticates with must be linked to the specified YouTube content
     owner.
       */
      public java.lang.String getOnBehalfOfContentOwner() {
        return onBehalfOfContentOwner;
      }

      /**
       * Note: This parameter is intended exclusively for YouTube content partners.
       *
       * The onBehalfOfContentOwner parameter indicates that the request's authorization credentials
       * identify a YouTube CMS user who is acting on behalf of the content owner specified in the
       * parameter value. This parameter is intended for YouTube content partners that own and
       * manage many different YouTube channels. It allows content owners to authenticate once and
       * get access to all their video and channel data, without having to provide authentication
       * credentials for each individual channel. The CMS account that the user authenticates with
       * must be linked to the specified YouTube content owner.
       */
      public Control setOnBehalfOfContentOwner(java.lang.String onBehalfOfContentOwner) {
        this.onBehalfOfContentOwner = onBehalfOfContentOwner;
        return this;
      }

      /**
       * This parameter can only be used in a properly authorized request. Note: This parameter is
       * intended exclusively for YouTube content partners.
       *
       * The onBehalfOfContentOwnerChannel parameter specifies the YouTube channel ID of the channel
       * to which a video is being added. This parameter is required when a request specifies a
       * value for the onBehalfOfContentOwner parameter, and it can only be used in conjunction with
       * that parameter. In addition, the request must be authorized using a CMS account that is
       * linked to the content owner that the onBehalfOfContentOwner parameter specifies. Finally,
       * the channel that the onBehalfOfContentOwnerChannel parameter value specifies must be linked
       * to the content owner that the onBehalfOfContentOwner parameter specifies.
       *
       * This parameter is intended for YouTube content partners that own and manage many different
       * YouTube channels. It allows content owners to authenticate once and perform actions on
       * behalf of the channel specified in the parameter value, without having to provide
       * authentication credentials for each separate channel.
       */
      @com.google.api.client.util.Key
      private java.lang.String onBehalfOfContentOwnerChannel;

      /** This parameter can only be used in a properly authorized request. Note: This parameter is intended
     exclusively for YouTube content partners.

     The onBehalfOfContentOwnerChannel parameter specifies the YouTube channel ID of the channel to
     which a video is being added. This parameter is required when a request specifies a value for the
     onBehalfOfContentOwner parameter, and it can only be used in conjunction with that parameter. In
     addition, the request must be authorized using a CMS account that is linked to the content owner
     that the onBehalfOfContentOwner parameter specifies. Finally, the channel that the
     onBehalfOfContentOwnerChannel parameter value specifies must be linked to the content owner that
     the onBehalfOfContentOwner parameter specifies.

     This parameter is intended for YouTube content partners that own and manage many different YouTube
     channels. It allows content owners to authenticate once and perform actions on behalf of the
     channel specified in the parameter value, without having to provide authentication credentials for
     each separate channel.
       */
      public java.lang.String getOnBehalfOfContentOwnerChannel() {
        return onBehalfOfContentOwnerChannel;
      }

      /**
       * This parameter can only be used in a properly authorized request. Note: This parameter is
       * intended exclusively for YouTube content partners.
       *
       * The onBehalfOfContentOwnerChannel parameter specifies the YouTube channel ID of the channel
       * to which a video is being added. This parameter is required when a request specifies a
       * value for the onBehalfOfContentOwner parameter, and it can only be used in conjunction with
       * that parameter. In addition, the request must be authorized using a CMS account that is
       * linked to the content owner that the onBehalfOfContentOwner parameter specifies. Finally,
       * the channel that the onBehalfOfContentOwnerChannel parameter value specifies must be linked
       * to the content owner that the onBehalfOfContentOwner parameter specifies.
       *
       * This parameter is intended for YouTube content partners that own and manage many different
       * YouTube channels. It allows content owners to authenticate once and perform actions on
       * behalf of the channel specified in the parameter value, without having to provide
       * authentication credentials for each separate channel.
       */
      public Control setOnBehalfOfContentOwnerChannel(java.lang.String onBehalfOfContentOwnerChannel) {
        this.onBehalfOfContentOwnerChannel = onBehalfOfContentOwnerChannel;
        return this;
      }

      /**
       * The walltime parameter specifies the wall clock time at which the specified slate change
       * will occur. The value is specified in ISO 8601 (YYYY-MM-DDThh:mm:ss.sssZ) format.
       */
      @com.google.api.client.util.Key
      private com.google.api.client.util.DateTime walltime;

      /** The walltime parameter specifies the wall clock time at which the specified slate change will
     occur. The value is specified in ISO 8601 (YYYY-MM-DDThh:mm:ss.sssZ) format.
       */
      public com.google.api.client.util.DateTime getWalltime() {
        return walltime;
      }

      /**
       * The walltime parameter specifies the wall clock time at which the specified slate change
       * will occur. The value is specified in ISO 8601 (YYYY-MM-DDThh:mm:ss.sssZ) format.
       */
      public Control setWalltime(com.google.api.client.util.DateTime walltime) {
        this.walltime = walltime;
        return this;
      }

      @Override
      public Control set(String parameterName, Object value) {
        return (Control) super.set(parameterName, value);
      }
    }
    /**
     * Deletes a broadcast.
     *
     * Create a request for the method "liveBroadcasts.delete".
     *
     * This request holds the parameters needed by the youtube server.  After setting any optional
     * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
     *
     * @param id The id parameter specifies the YouTube live broadcast ID for the resource that is being deleted.
     * @return the request
     */
    public Delete delete(java.lang.String id) throws java.io.IOException {
      Delete result = new Delete(id);
      initialize(result);
      return result;
    }

    public class Delete extends YouTubeRequest<Void> {

      private static final String REST_PATH = "liveBroadcasts";

      /**
       * Deletes a broadcast.
       *
       * Create a request for the method "liveBroadcasts.delete".
       *
       * This request holds the parameters needed by the the youtube server.  After setting any optional
       * parameters, call the {@link Delete#execute()} method to invoke the remote operation. <p> {@link
       * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param id The id parameter specifies the YouTube live broadcast ID for the resource that is being deleted.
       * @since 1.13
       */
      protected Delete(java.lang.String id) {
        super(YouTube.this, "DELETE", REST_PATH, null, Void.class);
        this.id = com.google.api.client.util.Preconditions.checkNotNull(id, "Required parameter id must be specified.");
      }

      @Override
      public Delete setAlt(java.lang.String alt) {
        return (Delete) super.setAlt(alt);
      }

      @Override
      public Delete setFields(java.lang.String fields) {
        return (Delete) super.setFields(fields);
      }

      @Override
      public Delete setKey(java.lang.String key) {
        return (Delete) super.setKey(key);
      }

      @Override
      public Delete setOauthToken(java.lang.String oauthToken) {
        return (Delete) super.setOauthToken(oauthToken);
      }

      @Override
      public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Delete) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Delete setQuotaUser(java.lang.String quotaUser) {
        return (Delete) super.setQuotaUser(quotaUser);
      }

      @Override
      public Delete setUserIp(java.lang.String userIp) {
        return (Delete) super.setUserIp(userIp);
      }

      /**
       * The id parameter specifies the YouTube live broadcast ID for the resource that is being
       * deleted.
       */
      @com.google.api.client.util.Key
      private java.lang.String id;

      /** The id parameter specifies the YouTube live broadcast ID for the resource that is being deleted.
       */
      public java.lang.String getId() {
        return id;
      }

      /**
       * The id parameter specifies the YouTube live broadcast ID for the resource that is being
       * deleted.
       */
      public Delete setId(java.lang.String id) {
        this.id = id;
        return this;
      }

      /**
       * Note: This parameter is intended exclusively for YouTube content partners.
       *
       * The onBehalfOfContentOwner parameter indicates that the request's authorization credentials
       * identify a YouTube CMS user who is acting on behalf of the content owner specified in the
       * parameter value. This parameter is intended for YouTube content partners that own and
       * manage many different YouTube channels. It allows content owners to authenticate once and
       * get access to all their video and channel data, without having to provide authentication
       * credentials for each individual channel. The CMS account that the user authenticates with
       * must be linked to the specified YouTube content owner.
       */
      @com.google.api.client.util.Key
      private java.lang.String onBehalfOfContentOwner;

      /** Note: This parameter is intended exclusively for YouTube content partners.

     The onBehalfOfContentOwner parameter indicates that the request's authorization credentials
     identify a YouTube CMS user who is acting on behalf of the content owner specified in the parameter
     value. This parameter is intended for YouTube content partners that own and manage many different
     YouTube channels. It allows content owners to authenticate once and get access to all their video
     and channel data, without having to provide authentication credentials for each individual channel.
     The CMS account that the user authenticates with must be linked to the specified YouTube content
     owner.
       */
      public java.lang.String getOnBehalfOfContentOwner() {
        return onBehalfOfContentOwner;
      }

      /**
       * Note: This parameter is intended exclusively for YouTube content partners.
       *
       * The onBehalfOfContentOwner parameter indicates that the request's authorization credentials
       * identify a YouTube CMS user who is acting on behalf of the content owner specified in the
       * parameter value. This parameter is intended for YouTube content partners that own and
       * manage many different YouTube channels. It allows content owners to authenticate once and
       * get access to all their video and channel data, without having to provide authentication
       * credentials for each individual channel. The CMS account that the user authenticates with
       * must be linked to the specified YouTube content owner.
       */
      public Delete setOnBehalfOfContentOwner(java.lang.String onBehalfOfContentOwner) {
        this.onBehalfOfContentOwner = onBehalfOfContentOwner;
        return this;
      }

      /**
       * This parameter can only be used in a properly authorized request. Note: This parameter is
       * intended exclusively for YouTube content partners.
       *
       * The onBehalfOfContentOwnerChannel parameter specifies the YouTube channel ID of the channel
       * to which a video is being added. This parameter is required when a request specifies a
       * value for the onBehalfOfContentOwner parameter, and it can only be used in conjunction with
       * that parameter. In addition, the request must be authorized using a CMS account that is
       * linked to the content owner that the onBehalfOfContentOwner parameter specifies. Finally,
       * the channel that the onBehalfOfContentOwnerChannel parameter value specifies must be linked
       * to the content owner that the onBehalfOfContentOwner parameter specifies.
       *
       * This parameter is intended for YouTube content partners that own and manage many different
       * YouTube channels. It allows content owners to authenticate once and perform actions on
       * behalf of the channel specified in the parameter value, without having to provide
       * authentication credentials for each separate channel.
       */
      @com.google.api.client.util.Key
      private java.lang.String onBehalfOfContentOwnerChannel;

      /** This parameter can only be used in a properly authorized request. Note: This parameter is intended
     exclusively for YouTube content partners.

     The onBehalfOfContentOwnerChannel parameter specifies the YouTube channel ID of the channel to
     which a video is being added. This parameter is required when a request specifies a value for the
     onBehalfOfContentOwner parameter, and it can only be used in conjunction with that parameter. In
     addition, the request must be authorized using a CMS account that is linked to the content owner
     that the onBehalfOfContentOwner parameter specifies. Finally, the channel that the
     onBehalfOfContentOwnerChannel parameter value specifies must be linked to the content owner that
     the onBehalfOfContentOwner parameter specifies.

     This parameter is intended for YouTube content partners that own and manage many different YouTube
     channels. It allows content owners to authenticate once and perform actions on behalf of the
     channel specified in the parameter value, without having to provide authentication credentials for
     each separate channel.
       */
      public java.lang.String getOnBehalfOfContentOwnerChannel() {
        return onBehalfOfContentOwnerChannel;
      }

      /**
       * This parameter can only be used in a properly authorized request. Note: This parameter is
       * intended exclusively for YouTube content partners.
       *
       * The onBehalfOfContentOwnerChannel parameter specifies the YouTube channel ID of the channel
       * to which a video is being added. This parameter is required when a request specifies a
       * value for the onBehalfOfContentOwner parameter, and it can only be used in conjunction with
       * that parameter. In addition, the request must be authorized using a CMS account that is
       * linked to the content owner that the onBehalfOfContentOwner parameter specifies. Finally,
       * the channel that the onBehalfOfContentOwnerChannel parameter value specifies must be linked
       * to the content owner that the onBehalfOfContentOwner parameter specifies.
       *
       * This parameter is intended for YouTube content partners that own and manage many different
       * YouTube channels. It allows content owners to authenticate once and perform actions on
       * behalf of the channel specified in the parameter value, without having to provide
       * authentication credentials for each separate channel.
       */
      public Delete setOnBehalfOfContentOwnerChannel(java.lang.String onBehalfOfContentOwnerChannel) {
        this.onBehalfOfContentOwnerChannel = onBehalfOfContentOwnerChannel;
        return this;
      }

      @Override
      public Delete set(String parameterName, Object value) {
        return (Delete) super.set(parameterName, value);
      }
    }
    /**
     * Creates a broadcast.
     *
     * Create a request for the method "liveBroadcasts.insert".
     *
     * This request holds the parameters needed by the youtube server.  After setting any optional
     * parameters, call the {@link Insert#execute()} method to invoke the remote operation.
     *
     * @param part The part parameter serves two purposes in this operation. It identifies the properties that the
     *        write operation will set as well as the properties that the API response will include.
    The
     *        part properties that you can include in the parameter value are id, snippet,
     *        contentDetails, and status.
     * @param content the {@link com.google.api.services.youtube.model.LiveBroadcast}
     * @return the request
     */
    public Insert insert(java.lang.String part, com.google.api.services.youtube.model.LiveBroadcast content) throws java.io.IOException {
      Insert result = new Insert(part, content);
      initialize(result);
      return result;
    }

    public class Insert extends YouTubeRequest<com.google.api.services.youtube.model.LiveBroadcast> {

      private static final String REST_PATH = "liveBroadcasts";

      /**
       * Creates a broadcast.
       *
       * Create a request for the method "liveBroadcasts.insert".
       *
       * This request holds the parameters needed by the the youtube server.  After setting any optional
       * parameters, call the {@link Insert#execute()} method to invoke the remote operation. <p> {@link
       * Insert#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param part The part parameter serves two purposes in this operation. It identifies the properties that the
     *        write operation will set as well as the properties that the API response will include.
    The
     *        part properties that you can include in the parameter value are id, snippet,
     *        contentDetails, and status.
       * @param content the {@link com.google.api.services.youtube.model.LiveBroadcast}
       * @since 1.13
       */
      protected Insert(java.lang.String part, com.google.api.services.youtube.model.LiveBroadcast content) {
        super(YouTube.this, "POST", REST_PATH, content, com.google.api.services.youtube.model.LiveBroadcast.class);
        this.part = com.google.api.client.util.Preconditions.checkNotNull(part, "Required parameter part must be specified.");
      }

      @Override
      public Insert setAlt(java.lang.String alt) {
        return (Insert) super.setAlt(alt);
      }

      @Override
      public Insert setFields(java.lang.String fields) {
        return (Insert) super.setFields(fields);
      }

      @Override
      public Insert setKey(java.lang.String key) {
        return (Insert) super.setKey(key);
      }

      @Override
      public Insert setOauthToken(java.lang.String oauthToken) {
        return (Insert) super.setOauthToken(oauthToken);
      }

      @Override
      public Insert setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Insert) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Insert setQuotaUser(java.lang.String quotaUser) {
        return (Insert) super.setQuotaUser(quotaUser);
      }

      @Override
      public Insert setUserIp(java.lang.String userIp) {
        return (Insert) super.setUserIp(userIp);
      }

      /**
       * The part parameter serves two purposes in this operation. It identifies the properties that
       * the write operation will set as well as the properties that the API response will include.
       *
       * The part properties that you can include in the parameter value are id, snippet,
       * contentDetails, and status.
       */
      @com.google.api.client.util.Key
      private java.lang.String part;

      /** The part parameter serves two purposes in this operation. It identifies the properties that the
     write operation will set as well as the properties that the API response will include.

     The part properties that you can include in the parameter value are id, snippet, contentDetails,
     and status.
       */
      public java.lang.String getPart() {
        return part;
      }

      /**
       * The part parameter serves two purposes in this operation. It identifies the properties that
       * the write operation will set as well as the properties that the API response will include.
       *
       * The part properties that you can include in the parameter value are id, snippet,
       * contentDetails, and status.
       */
      public Insert setPart(java.lang.String part) {
        this.part = part;
        return this;
      }

      /**
       * Note: This parameter is intended exclusively for YouTube content partners.
       *
       * The onBehalfOfContentOwner parameter indicates that the request's authorization credentials
       * identify a YouTube CMS user who is acting on behalf of the content owner specified in the
       * parameter value. This parameter is intended for YouTube content partners that own and
       * manage many different YouTube channels. It allows content owners to authenticate once and
       * get access to all their video and channel data, without having to provide authentication
       * credentials for each individual channel. The CMS account that the user authenticates with
       * must be linked to the specified YouTube content owner.
       */
      @com.google.api.client.util.Key
      private java.lang.String onBehalfOfContentOwner;

      /** Note: This parameter is intended exclusively for YouTube content partners.

     The onBehalfOfContentOwner parameter indicates that the request's authorization credentials
     identify a YouTube CMS user who is acting on behalf of the content owner specified in the parameter
     value. This parameter is intended for YouTube content partners that own and manage many different
     YouTube channels. It allows content owners to authenticate once and get access to all their video
     and channel data, without having to provide authentication credentials for each individual channel.
     The CMS account that the user authenticates with must be linked to the specified YouTube content
     owner.
       */
      public java.lang.String getOnBehalfOfContentOwner() {
        return onBehalfOfContentOwner;
      }

      /**
       * Note: This parameter is intended exclusively for YouTube content partners.
       *
       * The onBehalfOfContentOwner parameter indicates that the request's authorization credentials
       * identify a YouTube CMS user who is acting on behalf of the content owner specified in the
       * parameter value. This parameter is intended for YouTube content partners that own and
       * manage many different YouTube channels. It allows content owners to authenticate once and
       * get access to all their video and channel data, without having to provide authentication
       * credentials for each individual channel. The CMS account that the user authenticates with
       * must be linked to the specified YouTube content owner.
       */
      public Insert setOnBehalfOfContentOwner(java.lang.String onBehalfOfContentOwner) {
        this.onBehalfOfContentOwner = onBehalfOfContentOwner;
        return this;
      }

      /**
       * This parameter can only be used in a properly authorized request. Note: This parameter is
       * intended exclusively for YouTube content partners.
       *
       * The onBehalfOfContentOwnerChannel parameter specifies the YouTube channel ID of the channel
       * to which a video is being added. This parameter is required when a request specifies a
       * value for the onBehalfOfContentOwner parameter, and it can only be used in conjunction with
       * that parameter. In addition, the request must be authorized using a CMS account that is
       * linked to the content owner that the onBehalfOfContentOwner parameter specifies. Finally,
       * the channel that the onBehalfOfContentOwnerChannel parameter value specifies must be linked
       * to the content owner that the onBehalfOfContentOwner parameter specifies.
       *
       * This parameter is intended for YouTube content partners that own and manage many different
       * YouTube channels. It allows content owners to authenticate once and perform actions on
       * behalf of the channel specified in the parameter value, without having to provide
       * authentication credentials for each separate channel.
       */
      @com.google.api.client.util.Key
      private java.lang.String onBehalfOfContentOwnerChannel;

      /** This parameter can only be used in a properly authorized request. Note: This parameter is intended
     exclusively for YouTube content partners.

     The onBehalfOfContentOwnerChannel parameter specifies the YouTube channel ID of the channel to
     which a video is being added. This parameter is required when a request specifies a value for the
     onBehalfOfContentOwner parameter, and it can only be used in conjunction with that parameter. In
     addition, the request must be authorized using a CMS account that is linked to the content owner
     that the onBehalfOfContentOwner parameter specifies. Finally, the channel that the
     onBehalfOfContentOwnerChannel parameter value specifies must be linked to the content owner that
     the onBehalfOfContentOwner parameter specifies.

     This parameter is intended for YouTube content partners that own and manage many different YouTube
     channels. It allows content owners to authenticate once and perform actions on behalf of the
     channel specified in the parameter value, without having to provide authentication credentials for
     each separate channel.
       */
      public java.lang.String getOnBehalfOfContentOwnerChannel() {
        return onBehalfOfContentOwnerChannel;
      }

      /**
       * This parameter can only be used in a properly authorized request. Note: This parameter is
       * intended exclusively for YouTube content partners.
       *
       * The onBehalfOfContentOwnerChannel parameter specifies the YouTube channel ID of the channel
       * to which a video is being added. This parameter is required when a request specifies a
       * value for the onBehalfOfContentOwner parameter, and it can only be used in conjunction with
       * that parameter. In addition, the request must be authorized using a CMS account that is
       * linked to the content owner that the onBehalfOfContentOwner parameter specifies. Finally,
       * the channel that the onBehalfOfContentOwnerChannel parameter value specifies must be linked
       * to the content owner that the onBehalfOfContentOwner parameter specifies.
       *
       * This parameter is intended for YouTube content partners that own and manage many different
       * YouTube channels. It allows content owners to authenticate once and perform actions on
       * behalf of the channel specified in the parameter value, without having to provide
       * authentication credentials for each separate channel.
       */
      public Insert setOnBehalfOfContentOwnerChannel(java.lang.String onBehalfOfContentOwnerChannel) {
        this.onBehalfOfContentOwnerChannel = onBehalfOfContentOwnerChannel;
        return this;
      }

      @Override
      public Insert set(String parameterName, Object value) {
        return (Insert) super.set(parameterName, value);
      }
    }
    /**
     * Returns a list of YouTube broadcasts that match the API request parameters.
     *
     * Create a request for the method "liveBroadcasts.list".
     *
     * This request holds the parameters needed by the youtube server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param part The part parameter specifies a comma-separated list of one or more liveBroadcast resource properties
     *        that the API response will include. The part names that you can include in the parameter
     *        value are id, snippet, contentDetails, and status.
     * @return the request
     */
    public List list(java.lang.String part) throws java.io.IOException {
      List result = new List(part);
      initialize(result);
      return result;
    }

    public class List extends YouTubeRequest<com.google.api.services.youtube.model.LiveBroadcastListResponse> {

      private static final String REST_PATH = "liveBroadcasts";

      /**
       * Returns a list of YouTube broadcasts that match the API request parameters.
       *
       * Create a request for the method "liveBroadcasts.list".
       *
       * This request holds the parameters needed by the the youtube server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param part The part parameter specifies a comma-separated list of one or more liveBroadcast resource properties
     *        that the API response will include. The part names that you can include in the parameter
     *        value are id, snippet, contentDetails, and status.
       * @since 1.13
       */
      protected List(java.lang.String part) {
        super(YouTube.this, "GET", REST_PATH, null, com.google.api.services.youtube.model.LiveBroadcastListResponse.class);
        this.part = com.google.api.client.util.Preconditions.checkNotNull(part, "Required parameter part must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUserIp(java.lang.String userIp) {
        return (List) super.setUserIp(userIp);
      }

      /**
       * The part parameter specifies a comma-separated list of one or more liveBroadcast resource
       * properties that the API response will include. The part names that you can include in the
       * parameter value are id, snippet, contentDetails, and status.
       */
      @com.google.api.client.util.Key
      private java.lang.String part;

      /** The part parameter specifies a comma-separated list of one or more liveBroadcast resource
     properties that the API response will include. The part names that you can include in the parameter
     value are id, snippet, contentDetails, and status.
       */
      public java.lang.String getPart() {
        return part;
      }

      /**
       * The part parameter specifies a comma-separated list of one or more liveBroadcast resource
       * properties that the API response will include. The part names that you can include in the
       * parameter value are id, snippet, contentDetails, and status.
       */
      public List setPart(java.lang.String part) {
        this.part = part;
        return this;
      }

      /**
       * The broadcastStatus parameter filters the API response to only include broadcasts with the
       * specified status.
       */
      @com.google.api.client.util.Key
      private java.lang.String broadcastStatus;

      /** The broadcastStatus parameter filters the API response to only include broadcasts with the
     specified status.
       */
      public java.lang.String getBroadcastStatus() {
        return broadcastStatus;
      }

      /**
       * The broadcastStatus parameter filters the API response to only include broadcasts with the
       * specified status.
       */
      public List setBroadcastStatus(java.lang.String broadcastStatus) {
        this.broadcastStatus = broadcastStatus;
        return this;
      }

      /**
       * The broadcastType parameter filters the API response to only include broadcasts with the
       * specified type. This is only compatible with the mine filter for now.
       */
      @com.google.api.client.util.Key
      private java.lang.String broadcastType;

      /** The broadcastType parameter filters the API response to only include broadcasts with the specified
     type. This is only compatible with the mine filter for now. [default: BROADCAST_TYPE_FILTER_EVENT]
       */
      public java.lang.String getBroadcastType() {
        return broadcastType;
      }

      /**
       * The broadcastType parameter filters the API response to only include broadcasts with the
       * specified type. This is only compatible with the mine filter for now.
       */
      public List setBroadcastType(java.lang.String broadcastType) {
        this.broadcastType = broadcastType;
        return this;
      }

      /**
       * The id parameter specifies a comma-separated list of YouTube broadcast IDs that identify
       * the broadcasts being retrieved. In a liveBroadcast resource, the id property specifies the
       * broadcast's ID.
       */
      @com.google.api.client.util.Key
      private java.lang.String id;

      /** The id parameter specifies a comma-separated list of YouTube broadcast IDs that identify the
     broadcasts being retrieved. In a liveBroadcast resource, the id property specifies the broadcast's
     ID.
       */
      public java.lang.String getId() {
        return id;
      }

      /**
       * The id parameter specifies a comma-separated list of YouTube broadcast IDs that identify
       * the broadcasts being retrieved. In a liveBroadcast resource, the id property specifies the
       * broadcast's ID.
       */
      public List setId(java.lang.String id) {
        this.id = id;
        return this;
      }

      /**
       * The maxResults parameter specifies the maximum number of items that should be returned in
       * the result set.
       */
      @com.google.api.client.util.Key
      private java.lang.Long maxResults;

      /** The maxResults parameter specifies the maximum number of items that should be returned in the
     result set. [default: 5] [minimum: 0] [maximum: 50]
       */
      public java.lang.Long getMaxResults() {
        return maxResults;
      }

      /**
       * The maxResults parameter specifies the maximum number of items that should be returned in
       * the result set.
       */
      public List setMaxResults(java.lang.Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      /**
       * The mine parameter can be used to instruct the API to only return broadcasts owned by the
       * authenticated user. Set the parameter value to true to only retrieve your own broadcasts.
       */
      @com.google.api.client.util.Key
      private java.lang.Boolean mine;

      /** The mine parameter can be used to instruct the API to only return broadcasts owned by the
     authenticated user. Set the parameter value to true to only retrieve your own broadcasts.
       */
      public java.lang.Boolean getMine() {
        return mine;
      }

      /**
       * The mine parameter can be used to instruct the API to only return broadcasts owned by the
       * authenticated user. Set the parameter value to true to only retrieve your own broadcasts.
       */
      public List setMine(java.lang.Boolean mine) {
        this.mine = mine;
        return this;
      }

      /**
       * Note: This parameter is intended exclusively for YouTube content partners.
       *
       * The onBehalfOfContentOwner parameter indicates that the request's authorization credentials
       * identify a YouTube CMS user who is acting on behalf of the content owner specified in the
       * parameter value. This parameter is intended for YouTube content partners that own and
       * manage many different YouTube channels. It allows content owners to authenticate once and
       * get access to all their video and channel data, without having to provide authentication
       * credentials for each individual channel. The CMS account that the user authenticates with
       * must be linked to the specified YouTube content owner.
       */
      @com.google.api.client.util.Key
      private java.lang.String onBehalfOfContentOwner;

      /** Note: This parameter is intended exclusively for YouTube content partners.

     The onBehalfOfContentOwner parameter indicates that the request's authorization credentials
     identify a YouTube CMS user who is acting on behalf of the content owner specified in the parameter
     value. This parameter is intended for YouTube content partners that own and manage many different
     YouTube channels. It allows content owners to authenticate once and get access to all their video
     and channel data, without having to provide authentication credentials for each individual channel.
     The CMS account that the user authenticates with must be linked to the specified YouTube content
     owner.
       */
      public java.lang.String getOnBehalfOfContentOwner() {
        return onBehalfOfContentOwner;
      }

      /**
       * Note: This parameter is intended exclusively for YouTube content partners.
       *
       * The onBehalfOfContentOwner parameter indicates that the request's authorization credentials
       * identify a YouTube CMS user who is acting on behalf of the content owner specified in the
       * parameter value. This parameter is intended for YouTube content partners that own and
       * manage many different YouTube channels. It allows content owners to authenticate once and
       * get access to all their video and channel data, without having to provide authentication
       * credentials for each individual channel. The CMS account that the user authenticates with
       * must be linked to the specified YouTube content owner.
       */
      public List setOnBehalfOfContentOwner(java.lang.String onBehalfOfContentOwner) {
        this.onBehalfOfContentOwner = onBehalfOfContentOwner;
        return this;
      }

      /**
       * This parameter can only be used in a properly authorized request. Note: This parameter is
       * intended exclusively for YouTube content partners.
       *
       * The onBehalfOfContentOwnerChannel parameter specifies the YouTube channel ID of the channel
       * to which a video is being added. This parameter is required when a request specifies a
       * value for the onBehalfOfContentOwner parameter, and it can only be used in conjunction with
       * that parameter. In addition, the request must be authorized using a CMS account that is
       * linked to the content owner that the onBehalfOfContentOwner parameter specifies. Finally,
       * the channel that the onBehalfOfContentOwnerChannel parameter value specifies must be linked
       * to the content owner that the onBehalfOfContentOwner parameter specifies.
       *
       * This parameter is intended for YouTube content partners that own and manage many different
       * YouTube channels. It allows content owners to authenticate once and perform actions on
       * behalf of the channel specified in the parameter value, without having to provide
       * authentication credentials for each separate channel.
       */
      @com.google.api.client.util.Key
      private java.lang.String onBehalfOfContentOwnerChannel;

      /** This parameter can only be used in a properly authorized request. Note: This parameter is intended
     exclusively for YouTube content partners.

     The onBehalfOfContentOwnerChannel parameter specifies the YouTube channel ID of the channel to
     which a video is being added. This parameter is required when a request specifies a value for the
     onBehalfOfContentOwner parameter, and it can only be used in conjunction with that parameter. In
     addition, the request must be authorized using a CMS account that is linked to the content owner
     that the onBehalfOfContentOwner parameter specifies. Finally, the channel that the
     onBehalfOfContentOwnerChannel parameter value specifies must be linked to the content owner that
     the onBehalfOfContentOwner parameter specifies.

     This parameter is intended for YouTube content partners that own and manage many different YouTube
     channels. It allows content owners to authenticate once and perform actions on behalf of the
     channel specified in the parameter value, without having to provide authentication credentials for
     each separate channel.
       */
      public java.lang.String getOnBehalfOfContentOwnerChannel() {
        return onBehalfOfContentOwnerChannel;
      }

      /**
       * This parameter can only be used in a properly authorized request. Note: This parameter is
       * intended exclusively for YouTube content partners.
       *
       * The onBehalfOfContentOwnerChannel parameter specifies the YouTube channel ID of the channel
       * to which a video is being added. This parameter is required when a request specifies a
       * value for the onBehalfOfContentOwner parameter, and it can only be used in conjunction with
       * that parameter. In addition, the request must be authorized using a CMS account that is
       * linked to the content owner that the onBehalfOfContentOwner parameter specifies. Finally,
       * the channel that the onBehalfOfContentOwnerChannel parameter value specifies must be linked
       * to the content owner that the onBehalfOfContentOwner parameter specifies.
       *
       * This parameter is intended for YouTube content partners that own and manage many different
       * YouTube channels. It allows content owners to authenticate once and perform actions on
       * behalf of the channel specified in the parameter value, without having to provide
       * authentication credentials for each separate channel.
       */
      public List setOnBehalfOfContentOwnerChannel(java.lang.String onBehalfOfContentOwnerChannel) {
        this.onBehalfOfContentOwnerChannel = onBehalfOfContentOwnerChannel;
        return this;
      }

      /**
       * The pageToken parameter identifies a specific page in the result set that should be
       * returned. In an API response, the nextPageToken and prevPageToken properties identify other
       * pages that could be retrieved.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** The pageToken parameter identifies a specific page in the result set that should be returned. In an
     API response, the nextPageToken and prevPageToken properties identify other pages that could be
     retrieved.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * The pageToken parameter identifies a specific page in the result set that should be
       * returned. In an API response, the nextPageToken and prevPageToken properties identify other
       * pages that could be retrieved.
       */
      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }
    /**
     * Changes the status of a YouTube live broadcast and initiates any processes associated with the
     * new status. For example, when you transition a broadcast's status to testing, YouTube starts to
     * transmit video to that broadcast's monitor stream. Before calling this method, you should confirm
     * that the value of the status.streamStatus property for the stream bound to your broadcast is
     * active.
     *
     * Create a request for the method "liveBroadcasts.transition".
     *
     * This request holds the parameters needed by the youtube server.  After setting any optional
     * parameters, call the {@link Transition#execute()} method to invoke the remote operation.
     *
     * @param broadcastStatus The broadcastStatus parameter identifies the state to which the broadcast is changing. Note that to
     *        transition a broadcast to either the testing or live state, the status.streamStatus must
     *        be active for the stream that the broadcast is bound to.
     * @param id The id parameter specifies the unique ID of the broadcast that is transitioning to another status.
     * @param part The part parameter specifies a comma-separated list of one or more liveBroadcast resource properties
     *        that the API response will include. The part names that you can include in the parameter
     *        value are id, snippet, contentDetails, and status.
     * @return the request
     */
    public Transition transition(java.lang.String broadcastStatus, java.lang.String id, java.lang.String part) throws java.io.IOException {
      Transition result = new Transition(broadcastStatus, id, part);
      initialize(result);
      return result;
    }

    public class Transition extends YouTubeRequest<com.google.api.services.youtube.model.LiveBroadcast> {

      private static final String REST_PATH = "liveBroadcasts/transition";

      /**
       * Changes the status of a YouTube live broadcast and initiates any processes associated with the
       * new status. For example, when you transition a broadcast's status to testing, YouTube starts to
       * transmit video to that broadcast's monitor stream. Before calling this method, you should
       * confirm that the value of the status.streamStatus property for the stream bound to your
       * broadcast is active.
       *
       * Create a request for the method "liveBroadcasts.transition".
       *
       * This request holds the parameters needed by the the youtube server.  After setting any optional
       * parameters, call the {@link Transition#execute()} method to invoke the remote operation. <p>
       * {@link
       * Transition#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param broadcastStatus The broadcastStatus parameter identifies the state to which the broadcast is changing. Note that to
     *        transition a broadcast to either the testing or live state, the status.streamStatus must
     *        be active for the stream that the broadcast is bound to.
       * @param id The id parameter specifies the unique ID of the broadcast that is transitioning to another status.
       * @param part The part parameter specifies a comma-separated list of one or more liveBroadcast resource properties
     *        that the API response will include. The part names that you can include in the parameter
     *        value are id, snippet, contentDetails, and status.
       * @since 1.13
       */
      protected Transition(java.lang.String broadcastStatus, java.lang.String id, java.lang.String part) {
        super(YouTube.this, "POST", REST_PATH, null, com.google.api.services.youtube.model.LiveBroadcast.class);
        this.broadcastStatus = com.google.api.client.util.Preconditions.checkNotNull(broadcastStatus, "Required parameter broadcastStatus must be specified.");
        this.id = com.google.api.client.util.Preconditions.checkNotNull(id, "Required parameter id must be specified.");
        this.part = com.google.api.client.util.Preconditions.checkNotNull(part, "Required parameter part must be specified.");
      }

      @Override
      public Transition setAlt(java.lang.String alt) {
        return (Transition) super.setAlt(alt);
      }

      @Override
      public Transition setFields(java.lang.String fields) {
        return (Transition) super.setFields(fields);
      }

      @Override
      public Transition setKey(java.lang.String key) {
        return (Transition) super.setKey(key);
      }

      @Override
      public Transition setOauthToken(java.lang.String oauthToken) {
        return (Transition) super.setOauthToken(oauthToken);
      }

      @Override
      public Transition setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Transition) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Transition setQuotaUser(java.lang.String quotaUser) {
        return (Transition) super.setQuotaUser(quotaUser);
      }

      @Override
      public Transition setUserIp(java.lang.String userIp) {
        return (Transition) super.setUserIp(userIp);
      }

      /**
       * The broadcastStatus parameter identifies the state to which the broadcast is changing. Note
       * that to transition a broadcast to either the testing or live state, the status.streamStatus
       * must be active for the stream that the broadcast is bound to.
       */
      @com.google.api.client.util.Key
      private java.lang.String broadcastStatus;

      /** The broadcastStatus parameter identifies the state to which the broadcast is changing. Note that to
     transition a broadcast to either the testing or live state, the status.streamStatus must be active
     for the stream that the broadcast is bound to.
       */
      public java.lang.String getBroadcastStatus() {
        return broadcastStatus;
      }

      /**
       * The broadcastStatus parameter identifies the state to which the broadcast is changing. Note
       * that to transition a broadcast to either the testing or live state, the status.streamStatus
       * must be active for the stream that the broadcast is bound to.
       */
      public Transition setBroadcastStatus(java.lang.String broadcastStatus) {
        this.broadcastStatus = broadcastStatus;
        return this;
      }

      /**
       * The id parameter specifies the unique ID of the broadcast that is transitioning to another
       * status.
       */
      @com.google.api.client.util.Key
      private java.lang.String id;

      /** The id parameter specifies the unique ID of the broadcast that is transitioning to another status.
       */
      public java.lang.String getId() {
        return id;
      }

      /**
       * The id parameter specifies the unique ID of the broadcast that is transitioning to another
       * status.
       */
      public Transition setId(java.lang.String id) {
        this.id = id;
        return this;
      }

      /**
       * The part parameter specifies a comma-separated list of one or more liveBroadcast resource
       * properties that the API response will include. The part names that you can include in the
       * parameter value are id, snippet, contentDetails, and status.
       */
      @com.google.api.client.util.Key
      private java.lang.String part;

      /** The part parameter specifies a comma-separated list of one or more liveBroadcast resource
     properties that the API response will include. The part names that you can include in the parameter
     value are id, snippet, contentDetails, and status.
       */
      public java.lang.String getPart() {
        return part;
      }

      /**
       * The part parameter specifies a comma-separated list of one or more liveBroadcast resource
       * properties that the API response will include. The part names that you can include in the
       * parameter value are id, snippet, contentDetails, and status.
       */
      public Transition setPart(java.lang.String part) {
        this.part = part;
        return this;
      }

      /**
       * Note: This parameter is intended exclusively for YouTube content partners.
       *
       * The onBehalfOfContentOwner parameter indicates that the request's authorization credentials
       * identify a YouTube CMS user who is acting on behalf of the content owner specified in the
       * parameter value. This parameter is intended for YouTube content partners that own and
       * manage many different YouTube channels. It allows content owners to authenticate once and
       * get access to all their video and channel data, without having to provide authentication
       * credentials for each individual channel. The CMS account that the user authenticates with
       * must be linked to the specified YouTube content owner.
       */
      @com.google.api.client.util.Key
      private java.lang.String onBehalfOfContentOwner;

      /** Note: This parameter is intended exclusively for YouTube content partners.

     The onBehalfOfContentOwner parameter indicates that the request's authorization credentials
     identify a YouTube CMS user who is acting on behalf of the content owner specified in the parameter
     value. This parameter is intended for YouTube content partners that own and manage many different
     YouTube channels. It allows content owners to authenticate once and get access to all their video
     and channel data, without having to provide authentication credentials for each individual channel.
     The CMS account that the user authenticates with must be linked to the specified YouTube content
     owner.
       */
      public java.lang.String getOnBehalfOfContentOwner() {
        return onBehalfOfContentOwner;
      }

      /**
       * Note: This parameter is intended exclusively for YouTube content partners.
       *
       * The onBehalfOfContentOwner parameter indicates that the request's authorization credentials
       * identify a YouTube CMS user who is acting on behalf of the content owner specified in the
       * parameter value. This parameter is intended for YouTube content partners that own and
       * manage many different YouTube channels. It allows content owners to authenticate once and
       * get access to all their video and channel data, without having to provide authentication
       * credentials for each individual channel. The CMS account that the user authenticates with
       * must be linked to the specified YouTube content owner.
       */
      public Transition setOnBehalfOfContentOwner(java.lang.String onBehalfOfContentOwner) {
        this.onBehalfOfContentOwner = onBehalfOfContentOwner;
        return this;
      }

      /**
       * This parameter can only be used in a properly authorized request. Note: This parameter is
       * intended exclusively for YouTube content partners.
       *
       * The onBehalfOfContentOwnerChannel parameter specifies the YouTube channel ID of the channel
       * to which a video is being added. This parameter is required when a request specifies a
       * value for the onBehalfOfContentOwner parameter, and it can only be used in conjunction with
       * that parameter. In addition, the request must be authorized using a CMS account that is
       * linked to the content owner that the onBehalfOfContentOwner parameter specifies. Finally,
       * the channel that the onBehalfOfContentOwnerChannel parameter value specifies must be linked
       * to the content owner that the onBehalfOfContentOwner parameter specifies.
       *
       * This parameter is intended for YouTube content partners that own and manage many different
       * YouTube channels. It allows content owners to authenticate once and perform actions on
       * behalf of the channel specified in the parameter value, without having to provide
       * authentication credentials for each separate channel.
       */
      @com.google.api.client.util.Key
      private java.lang.String onBehalfOfContentOwnerChannel;

      /** This parameter can only be used in a properly authorized request. Note: This parameter is intended
     exclusively for YouTube content partners.

     The onBehalfOfContentOwnerChannel parameter specifies the YouTube channel ID of the channel to
     which a video is being added. This parameter is required when a request specifies a value for the
     onBehalfOfContentOwner parameter, and it can only be used in conjunction with that parameter. In
     addition, the request must be authorized using a CMS account that is linked to the content owner
     that the onBehalfOfContentOwner parameter specifies. Finally, the channel that the
     onBehalfOfContentOwnerChannel parameter value specifies must be linked to the content owner that
     the onBehalfOfContentOwner parameter specifies.

     This parameter is intended for YouTube content partners that own and manage many different YouTube
     channels. It allows content owners to authenticate once and perform actions on behalf of the
     channel specified in the parameter value, without having to provide authentication credentials for
     each separate channel.
       */
      public java.lang.String getOnBehalfOfContentOwnerChannel() {
        return onBehalfOfContentOwnerChannel;
      }

      /**
       * This parameter can only be used in a properly authorized request. Note: This parameter is
       * intended exclusively for YouTube content partners.
       *
       * The onBehalfOfContentOwnerChannel parameter specifies the YouTube channel ID of the channel
       * to which a video is being added. This parameter is required when a request specifies a
       * value for the onBehalfOfContentOwner parameter, and it can only be used in conjunction with
       * that parameter. In addition, the request must be authorized using a CMS account that is
       * linked to the content owner that the onBehalfOfContentOwner parameter specifies. Finally,
       * the channel that the onBehalfOfContentOwnerChannel parameter value specifies must be linked
       * to the content owner that the onBehalfOfContentOwner parameter specifies.
       *
       * This parameter is intended for YouTube content partners that own and manage many different
       * YouTube channels. It allows content owners to authenticate once and perform actions on
       * behalf of the channel specified in the parameter value, without having to provide
       * authentication credentials for each separate channel.
       */
      public Transition setOnBehalfOfContentOwnerChannel(java.lang.String onBehalfOfContentOwnerChannel) {
        this.onBehalfOfContentOwnerChannel = onBehalfOfContentOwnerChannel;
        return this;
      }

      @Override
      public Transition set(String parameterName, Object value) {
        return (Transition) super.set(parameterName, value);
      }
    }
    /**
     * Updates a broadcast. For example, you could modify the broadcast settings defined in the
     * liveBroadcast resource's contentDetails object.
     *
     * Create a request for the method "liveBroadcasts.update".
     *
     * This request holds the parameters needed by the youtube server.  After setting any optional
     * parameters, call the {@link Update#execute()} method to invoke the remote operation.
     *
     * @param part The part parameter serves two purposes in this operation. It identifies the properties that the
     *        write operation will set as well as the properties that the API response will include.
    The
     *        part properties that you can include in the parameter value are id, snippet,
     *        contentDetails, and status.
    Note that this method will override the existing values for
     *        all of the mutable properties that are contained in any parts that the parameter value
     *        specifies. For example, a broadcast's privacy status is defined in the status part. As
     *        such, if your request is updating a private or unlisted broadcast, and the request's part
     *        parameter value includes the status part, the broadcast's privacy setting will be updated
     *        to whatever value the request body specifies. If the request body does not specify a
     *        value, the existing privacy setting will be removed and the broadcast will revert to the
     *        default privacy setting.
     * @param content the {@link com.google.api.services.youtube.model.LiveBroadcast}
     * @return the request
     */
    public Update update(java.lang.String part, com.google.api.services.youtube.model.LiveBroadcast content) throws java.io.IOException {
      Update result = new Update(part, content);
      initialize(result);
      return result;
    }

    public class Update extends YouTubeRequest<com.google.api.services.youtube.model.LiveBroadcast> {

      private static final String REST_PATH = "liveBroadcasts";

      /**
       * Updates a broadcast. For example, you could modify the broadcast settings defined in the
       * liveBroadcast resource's contentDetails object.
       *
       * Create a request for the method "liveBroadcasts.update".
       *
       * This request holds the parameters needed by the the youtube server.  After setting any optional
       * parameters, call the {@link Update#execute()} method to invoke the remote operation. <p> {@link
       * Update#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param part The part parameter serves two purposes in this operation. It identifies the properties that the
     *        write operation will set as well as the properties that the API response will include.
    The
     *        part properties that you can include in the parameter value are id, snippet,
     *        contentDetails, and status.
    Note that this method will override the existing values for
     *        all of the mutable properties that are contained in any parts that the parameter value
     *        specifies. For example, a broadcast's privacy status is defined in the status part. As
     *        such, if your request is updating a private or unlisted broadcast, and the request's part
     *        parameter value includes the status part, the broadcast's privacy setting will be updated
     *        to whatever value the request body specifies. If the request body does not specify a
     *        value, the existing privacy setting will be removed and the broadcast will revert to the
     *        default privacy setting.
       * @param content the {@link com.google.api.services.youtube.model.LiveBroadcast}
       * @since 1.13
       */
      protected Update(java.lang.String part, com.google.api.services.youtube.model.LiveBroadcast content) {
        super(YouTube.this, "PUT", REST_PATH, content, com.google.api.services.youtube.model.LiveBroadcast.class);
        this.part = com.google.api.client.util.Preconditions.checkNotNull(part, "Required parameter part must be specified.");
        checkRequiredParameter(content, "content");
        checkRequiredParameter(content.getId(), "LiveBroadcast.getId()");
      }

      @Override
      public Update setAlt(java.lang.String alt) {
        return (Update) super.setAlt(alt);
      }

      @Override
      public Update setFields(java.lang.String fields) {
        return (Update) super.setFields(fields);
      }

      @Override
      public Update setKey(java.lang.String key) {
        return (Update) super.setKey(key);
      }

      @Override
      public Update setOauthToken(java.lang.String oauthToken) {
        return (Update) super.setOauthToken(oauthToken);
      }

      @Override
      public Update setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Update) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Update setQuotaUser(java.lang.String quotaUser) {
        return (Update) super.setQuotaUser(quotaUser);
      }

      @Override
      public Update setUserIp(java.lang.String userIp) {
        return (Update) super.setUserIp(userIp);
      }

      /**
       * The part parameter serves two purposes in this operation. It identifies the properties that
       * the write operation will set as well as the properties that the API response will include.
       *
       * The part properties that you can include in the parameter value are id, snippet,
       * contentDetails, and status.
       *
       * Note that this method will override the existing values for all of the mutable properties
       * that are contained in any parts that the parameter value specifies. For example, a
       * broadcast's privacy status is defined in the status part. As such, if your request is
       * updating a private or unlisted broadcast, and the request's part parameter value includes
       * the status part, the broadcast's privacy setting will be updated to whatever value the
       * request body specifies. If the request body does not specify a value, the existing privacy
       * setting will be removed and the broadcast will revert to the default privacy setting.
       */
      @com.google.api.client.util.Key
      private java.lang.String part;

      /** The part parameter serves two purposes in this operation. It identifies the properties that the
     write operation will set as well as the properties that the API response will include.

     The part properties that you can include in the parameter value are id, snippet, contentDetails,
     and status.

     Note that this method will override the existing values for all of the mutable properties that are
     contained in any parts that the parameter value specifies. For example, a broadcast's privacy
     status is defined in the status part. As such, if your request is updating a private or unlisted
     broadcast, and the request's part parameter value includes the status part, the broadcast's privacy
     setting will be updated to whatever value the request body specifies. If the request body does not
     specify a value, the existing privacy setting will be removed and the broadcast will revert to the
     default privacy setting.
       */
      public java.lang.String getPart() {
        return part;
      }

      /**
       * The part parameter serves two purposes in this operation. It identifies the properties that
       * the write operation will set as well as the properties that the API response will include.
       *
       * The part properties that you can include in the parameter value are id, snippet,
       * contentDetails, and status.
       *
       * Note that this method will override the existing values for all of the mutable properties
       * that are contained in any parts that the parameter value specifies. For example, a
       * broadcast's privacy status is defined in the status part. As such, if your request is
       * updating a private or unlisted broadcast, and the request's part parameter value includes
       * the status part, the broadcast's privacy setting will be updated to whatever value the
       * request body specifies. If the request body does not specify a value, the existing privacy
       * setting will be removed and the broadcast will revert to the default privacy setting.
       */
      public Update setPart(java.lang.String part) {
        this.part = part;
        return this;
      }

      /**
       * Note: This parameter is intended exclusively for YouTube content partners.
       *
       * The onBehalfOfContentOwner parameter indicates that the request's authorization credentials
       * identify a YouTube CMS user who is acting on behalf of the content owner specified in the
       * parameter value. This parameter is intended for YouTube content partners that own and
       * manage many different YouTube channels. It allows content owners to authenticate once and
       * get access to all their video and channel data, without having to provide authentication
       * credentials for each individual channel. The CMS account that the user authenticates with
       * must be linked to the specified YouTube content owner.
       */
      @com.google.api.client.util.Key
      private java.lang.String onBehalfOfContentOwner;

      /** Note: This parameter is intended exclusively for YouTube content partners.

     The onBehalfOfContentOwner parameter indicates that the request's authorization credentials
     identify a YouTube CMS user who is acting on behalf of the content owner specified in the parameter
     value. This parameter is intended for YouTube content partners that own and manage many different
     YouTube channels. It allows content owners to authenticate once and get access to all their video
     and channel data, without having to provide authentication credentials for each individual channel.
     The CMS account that the user authenticates with must be linked to the specified YouTube content
     owner.
       */
      public java.lang.String getOnBehalfOfContentOwner() {
        return onBehalfOfContentOwner;
      }

      /**
       * Note: This parameter is intended exclusively for YouTube content partners.
       *
       * The onBehalfOfContentOwner parameter indicates that the request's authorization credentials
       * identify a YouTube CMS user who is acting on behalf of the content owner specified in the
       * parameter value. This parameter is intended for YouTube content partners that own and
       * manage many different YouTube channels. It allows content owners to authenticate once and
       * get access to all their video and channel data, without having to provide authentication
       * credentials for each individual channel. The CMS account that the user authenticates with
       * must be linked to the specified YouTube content owner.
       */
      public Update setOnBehalfOfContentOwner(java.lang.String onBehalfOfContentOwner) {
        this.onBehalfOfContentOwner = onBehalfOfContentOwner;
        return this;
      }

      /**
       * This parameter can only be used in a properly authorized request. Note: This parameter is
       * intended exclusively for YouTube content partners.
       *
       * The onBehalfOfContentOwnerChannel parameter specifies the YouTube channel ID of the channel
       * to which a video is being added. This parameter is required when a request specifies a
       * value for the onBehalfOfContentOwner parameter, and it can only be used in conjunction with
       * that parameter. In addition, the request must be authorized using a CMS account that is
       * linked to the content owner that the onBehalfOfContentOwner parameter specifies. Finally,
       * the channel that the onBehalfOfContentOwnerChannel parameter value specifies must be linked
       * to the content owner that the onBehalfOfContentOwner parameter specifies.
       *
       * This parameter is intended for YouTube content partners that own and manage many different
       * YouTube channels. It allows content owners to authenticate once and perform actions on
       * behalf of the channel specified in the parameter value, without having to provide
       * authentication credentials for each separate channel.
       */
      @com.google.api.client.util.Key
      private java.lang.String onBehalfOfContentOwnerChannel;

      /** This parameter can only be used in a properly authorized request. Note: This parameter is intended
     exclusively for YouTube content partners.

     The onBehalfOfContentOwnerChannel parameter specifies the YouTube channel ID of the channel to
     which a video is being added. This parameter is required when a request specifies a value for the
     onBehalfOfContentOwner parameter, and it can only be used in conjunction with that parameter. In
     addition, the request must be authorized using a CMS account that is linked to the content owner
     that the onBehalfOfContentOwner parameter specifies. Finally, the channel that the
     onBehalfOfContentOwnerChannel parameter value specifies must be linked to the content owner that
     the onBehalfOfContentOwner parameter specifies.

     This parameter is intended for YouTube content partners that own and manage many different YouTube
     channels. It allows content owners to authenticate once and perform actions on behalf of the
     channel specified in the parameter value, without having to provide authentication credentials for
     each separate channel.
       */
      public java.lang.String getOnBehalfOfContentOwnerChannel() {
        return onBehalfOfContentOwnerChannel;
      }

      /**
       * This parameter can only be used in a properly authorized request. Note: This parameter is
       * intended exclusively for YouTube content partners.
       *
       * The onBehalfOfContentOwnerChannel parameter specifies the YouTube channel ID of the channel
       * to which a video is being added. This parameter is required when a request specifies a
       * value for the onBehalfOfContentOwner parameter, and it can only be used in conjunction with
       * that parameter. In addition, the request must be authorized using a CMS account that is
       * linked to the content owner that the onBehalfOfContentOwner parameter specifies. Finally,
       * the channel that the onBehalfOfContentOwnerChannel parameter value specifies must be linked
       * to the content owner that the onBehalfOfContentOwner parameter specifies.
       *
       * This parameter is intended for YouTube content partners that own and manage many different
       * YouTube channels. It allows content owners to authenticate once and perform actions on
       * behalf of the channel specified in the parameter value, without having to provide
       * authentication credentials for each separate channel.
       */
      public Update setOnBehalfOfContentOwnerChannel(java.lang.String onBehalfOfContentOwnerChannel) {
        this.onBehalfOfContentOwnerChannel = onBehalfOfContentOwnerChannel;
        return this;
      }

      @Override
      public Update set(String parameterName, Object value) {
        return (Update) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the LiveChatBans collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code YouTube youtube = new YouTube(...);}
   *   {@code YouTube.LiveChatBans.List request = youtube.liveChatBans().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public LiveChatBans liveChatBans() {
    return new LiveChatBans();
  }

  /**
   * The "liveChatBans" collection of methods.
   */
  public class LiveChatBans {

    /**
     * Removes a chat ban.
     *
     * Create a request for the method "liveChatBans.delete".
     *
     * This request holds the parameters needed by the youtube server.  After setting any optional
     * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
     *
     * @param id The id parameter identifies the chat ban to remove. The value uniquely identifies both the ban and
     *        the chat.
     * @return the request
     */
    public Delete delete(java.lang.String id) throws java.io.IOException {
      Delete result = new Delete(id);
      initialize(result);
      return result;
    }

    public class Delete extends YouTubeRequest<Void> {

      private static final String REST_PATH = "liveChat/bans";

      /**
       * Removes a chat ban.
       *
       * Create a request for the method "liveChatBans.delete".
       *
       * This request holds the parameters needed by the the youtube server.  After setting any optional
       * parameters, call the {@link Delete#execute()} method to invoke the remote operation. <p> {@link
       * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param id The id parameter identifies the chat ban to remove. The value uniquely identifies both the ban and
     *        the chat.
       * @since 1.13
       */
      protected Delete(java.lang.String id) {
        super(YouTube.this, "DELETE", REST_PATH, null, Void.class);
        this.id = com.google.api.client.util.Preconditions.checkNotNull(id, "Required parameter id must be specified.");
      }

      @Override
      public Delete setAlt(java.lang.String alt) {
        return (Delete) super.setAlt(alt);
      }

      @Override
      public Delete setFields(java.lang.String fields) {
        return (Delete) super.setFields(fields);
      }

      @Override
      public Delete setKey(java.lang.String key) {
        return (Delete) super.setKey(key);
      }

      @Override
      public Delete setOauthToken(java.lang.String oauthToken) {
        return (Delete) super.setOauthToken(oauthToken);
      }

      @Override
      public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Delete) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Delete setQuotaUser(java.lang.String quotaUser) {
        return (Delete) super.setQuotaUser(quotaUser);
      }

      @Override
      public Delete setUserIp(java.lang.String userIp) {
        return (Delete) super.setUserIp(userIp);
      }

      /**
       * The id parameter identifies the chat ban to remove. The value uniquely identifies both the
       * ban and the chat.
       */
      @com.google.api.client.util.Key
      private java.lang.String id;

      /** The id parameter identifies the chat ban to remove. The value uniquely identifies both the ban and
     the chat.
       */
      public java.lang.String getId() {
        return id;
      }

      /**
       * The id parameter identifies the chat ban to remove. The value uniquely identifies both the
       * ban and the chat.
       */
      public Delete setId(java.lang.String id) {
        this.id = id;
        return this;
      }

      @Override
      public Delete set(String parameterName, Object value) {
        return (Delete) super.set(parameterName, value);
      }
    }
    /**
     * Adds a new ban to the chat.
     *
     * Create a request for the method "liveChatBans.insert".
     *
     * This request holds the parameters needed by the youtube server.  After setting any optional
     * parameters, call the {@link Insert#execute()} method to invoke the remote operation.
     *
     * @param part The part parameter serves two purposes in this operation. It identifies the properties that the
     *        write operation will set as well as the properties that the API response returns. Set the
     *        parameter value to snippet.
     * @param content the {@link com.google.api.services.youtube.model.LiveChatBan}
     * @return the request
     */
    public Insert insert(java.lang.String part, com.google.api.services.youtube.model.LiveChatBan content) throws java.io.IOException {
      Insert result = new Insert(part, content);
      initialize(result);
      return result;
    }

    public class Insert extends YouTubeRequest<com.google.api.services.youtube.model.LiveChatBan> {

      private static final String REST_PATH = "liveChat/bans";

      /**
       * Adds a new ban to the chat.
       *
       * Create a request for the method "liveChatBans.insert".
       *
       * This request holds the parameters needed by the the youtube server.  After setting any optional
       * parameters, call the {@link Insert#execute()} method to invoke the remote operation. <p> {@link
       * Insert#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param part The part parameter serves two purposes in this operation. It identifies the properties that the
     *        write operation will set as well as the properties that the API response returns. Set the
     *        parameter value to snippet.
       * @param content the {@link com.google.api.services.youtube.model.LiveChatBan}
       * @since 1.13
       */
      protected Insert(java.lang.String part, com.google.api.services.youtube.model.LiveChatBan content) {
        super(YouTube.this, "POST", REST_PATH, content, com.google.api.services.youtube.model.LiveChatBan.class);
        this.part = com.google.api.client.util.Preconditions.checkNotNull(part, "Required parameter part must be specified.");
      }

      @Override
      public Insert setAlt(java.lang.String alt) {
        return (Insert) super.setAlt(alt);
      }

      @Override
      public Insert setFields(java.lang.String fields) {
        return (Insert) super.setFields(fields);
      }

      @Override
      public Insert setKey(java.lang.String key) {
        return (Insert) super.setKey(key);
      }

      @Override
      public Insert setOauthToken(java.lang.String oauthToken) {
        return (Insert) super.setOauthToken(oauthToken);
      }

      @Override
      public Insert setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Insert) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Insert setQuotaUser(java.lang.String quotaUser) {
        return (Insert) super.setQuotaUser(quotaUser);
      }

      @Override
      public Insert setUserIp(java.lang.String userIp) {
        return (Insert) super.setUserIp(userIp);
      }

      /**
       * The part parameter serves two purposes in this operation. It identifies the properties that
       * the write operation will set as well as the properties that the API response returns. Set
       * the parameter value to snippet.
       */
      @com.google.api.client.util.Key
      private java.lang.String part;

      /** The part parameter serves two purposes in this operation. It identifies the properties that the
     write operation will set as well as the properties that the API response returns. Set the parameter
     value to snippet.
       */
      public java.lang.String getPart() {
        return part;
      }

      /**
       * The part parameter serves two purposes in this operation. It identifies the properties that
       * the write operation will set as well as the properties that the API response returns. Set
       * the parameter value to snippet.
       */
      public Insert setPart(java.lang.String part) {
        this.part = part;
        return this;
      }

      @Override
      public Insert set(String parameterName, Object value) {
        return (Insert) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the LiveChatMessages collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code YouTube youtube = new YouTube(...);}
   *   {@code YouTube.LiveChatMessages.List request = youtube.liveChatMessages().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public LiveChatMessages liveChatMessages() {
    return new LiveChatMessages();
  }

  /**
   * The "liveChatMessages" collection of methods.
   */
  public class LiveChatMessages {

    /**
     * Deletes a chat message.
     *
     * Create a request for the method "liveChatMessages.delete".
     *
     * This request holds the parameters needed by the youtube server.  After setting any optional
     * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
     *
     * @param id The id parameter specifies the YouTube chat message ID of the resource that is being deleted.
     * @return the request
     */
    public Delete delete(java.lang.String id) throws java.io.IOException {
      Delete result = new Delete(id);
      initialize(result);
      return result;
    }

    public class Delete extends YouTubeRequest<Void> {

      private static final String REST_PATH = "liveChat/messages";

      /**
       * Deletes a chat message.
       *
       * Create a request for the method "liveChatMessages.delete".
       *
       * This request holds the parameters needed by the the youtube server.  After setting any optional
       * parameters, call the {@link Delete#execute()} method to invoke the remote operation. <p> {@link
       * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param id The id parameter specifies the YouTube chat message ID of the resource that is being deleted.
       * @since 1.13
       */
      protected Delete(java.lang.String id) {
        super(YouTube.this, "DELETE", REST_PATH, null, Void.class);
        this.id = com.google.api.client.util.Preconditions.checkNotNull(id, "Required parameter id must be specified.");
      }

      @Override
      public Delete setAlt(java.lang.String alt) {
        return (Delete) super.setAlt(alt);
      }

      @Override
      public Delete setFields(java.lang.String fields) {
        return (Delete) super.setFields(fields);
      }

      @Override
      public Delete setKey(java.lang.String key) {
        return (Delete) super.setKey(key);
      }

      @Override
      public Delete setOauthToken(java.lang.String oauthToken) {
        return (Delete) super.setOauthToken(oauthToken);
      }

      @Override
      public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Delete) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Delete setQuotaUser(java.lang.String quotaUser) {
        return (Delete) super.setQuotaUser(quotaUser);
      }

      @Override
      public Delete setUserIp(java.lang.String userIp) {
        return (Delete) super.setUserIp(userIp);
      }

      /**
       * The id parameter specifies the YouTube chat message ID of the resource that is being
       * deleted.
       */
      @com.google.api.client.util.Key
      private java.lang.String id;

      /** The id parameter specifies the YouTube chat message ID of the resource that is being deleted.
       */
      public java.lang.String getId() {
        return id;
      }

      /**
       * The id parameter specifies the YouTube chat message ID of the resource that is being
       * deleted.
       */
      public Delete setId(java.lang.String id) {
        this.id = id;
        return this;
      }

      @Override
      public Delete set(String parameterName, Object value) {
        return (Delete) super.set(parameterName, value);
      }
    }
    /**
     * Adds a message to a live chat.
     *
     * Create a request for the method "liveChatMessages.insert".
     *
     * This request holds the parameters needed by the youtube server.  After setting any optional
     * parameters, call the {@link Insert#execute()} method to invoke the remote operation.
     *
     * @param part The part parameter serves two purposes. It identifies the properties that the write operation will
     *        set as well as the properties that the API response will include. Set the parameter value
     *        to snippet.
     * @param content the {@link com.google.api.services.youtube.model.LiveChatMessage}
     * @return the request
     */
    public Insert insert(java.lang.String part, com.google.api.services.youtube.model.LiveChatMessage content) throws java.io.IOException {
      Insert result = new Insert(part, content);
      initialize(result);
      return result;
    }

    public class Insert extends YouTubeRequest<com.google.api.services.youtube.model.LiveChatMessage> {

      private static final String REST_PATH = "liveChat/messages";

      /**
       * Adds a message to a live chat.
       *
       * Create a request for the method "liveChatMessages.insert".
       *
       * This request holds the parameters needed by the the youtube server.  After setting any optional
       * parameters, call the {@link Insert#execute()} method to invoke the remote operation. <p> {@link
       * Insert#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param part The part parameter serves two purposes. It identifies the properties that the write operation will
     *        set as well as the properties that the API response will include. Set the parameter value
     *        to snippet.
       * @param content the {@link com.google.api.services.youtube.model.LiveChatMessage}
       * @since 1.13
       */
      protected Insert(java.lang.String part, com.google.api.services.youtube.model.LiveChatMessage content) {
        super(YouTube.this, "POST", REST_PATH, content, com.google.api.services.youtube.model.LiveChatMessage.class);
        this.part = com.google.api.client.util.Preconditions.checkNotNull(part, "Required parameter part must be specified.");
      }

      @Override
      public Insert setAlt(java.lang.String alt) {
        return (Insert) super.setAlt(alt);
      }

      @Override
      public Insert setFields(java.lang.String fields) {
        return (Insert) super.setFields(fields);
      }

      @Override
      public Insert setKey(java.lang.String key) {
        return (Insert) super.setKey(key);
      }

      @Override
      public Insert setOauthToken(java.lang.String oauthToken) {
        return (Insert) super.setOauthToken(oauthToken);
      }

      @Override
      public Insert setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Insert) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Insert setQuotaUser(java.lang.String quotaUser) {
        return (Insert) super.setQuotaUser(quotaUser);
      }

      @Override
      public Insert setUserIp(java.lang.String userIp) {
        return (Insert) super.setUserIp(userIp);
      }

      /**
       * The part parameter serves two purposes. It identifies the properties that the write
       * operation will set as well as the properties that the API response will include. Set the
       * parameter value to snippet.
       */
      @com.google.api.client.util.Key
      private java.lang.String part;

      /** The part parameter serves two purposes. It identifies the properties that the write operation will
     set as well as the properties that the API response will include. Set the parameter value to
     snippet.
       */
      public java.lang.String getPart() {
        return part;
      }

      /**
       * The part parameter serves two purposes. It identifies the properties that the write
       * operation will set as well as the properties that the API response will include. Set the
       * parameter value to snippet.
       */
      public Insert setPart(java.lang.String part) {
        this.part = part;
        return this;
      }

      @Override
      public Insert set(String parameterName, Object value) {
        return (Insert) super.set(parameterName, value);
      }
    }
    /**
     * Lists live chat messages for a specific chat.
     *
     * Create a request for the method "liveChatMessages.list".
     *
     * This request holds the parameters needed by the youtube server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param liveChatId The liveChatId parameter specifies the ID of the chat whose messages will be returned.
     * @param part The part parameter specifies the liveChatComment resource parts that the API response will include.
     *        Supported values are id and snippet.
     * @return the request
     */
    public List list(java.lang.String liveChatId, java.lang.String part) throws java.io.IOException {
      List result = new List(liveChatId, part);
      initialize(result);
      return result;
    }

    public class List extends YouTubeRequest<com.google.api.services.youtube.model.LiveChatMessageListResponse> {

      private static final String REST_PATH = "liveChat/messages";

      /**
       * Lists live chat messages for a specific chat.
       *
       * Create a request for the method "liveChatMessages.list".
       *
       * This request holds the parameters needed by the the youtube server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param liveChatId The liveChatId parameter specifies the ID of the chat whose messages will be returned.
       * @param part The part parameter specifies the liveChatComment resource parts that the API response will include.
     *        Supported values are id and snippet.
       * @since 1.13
       */
      protected List(java.lang.String liveChatId, java.lang.String part) {
        super(YouTube.this, "GET", REST_PATH, null, com.google.api.services.youtube.model.LiveChatMessageListResponse.class);
        this.liveChatId = com.google.api.client.util.Preconditions.checkNotNull(liveChatId, "Required parameter liveChatId must be specified.");
        this.part = com.google.api.client.util.Preconditions.checkNotNull(part, "Required parameter part must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUserIp(java.lang.String userIp) {
        return (List) super.setUserIp(userIp);
      }

      /** The liveChatId parameter specifies the ID of the chat whose messages will be returned. */
      @com.google.api.client.util.Key
      private java.lang.String liveChatId;

      /** The liveChatId parameter specifies the ID of the chat whose messages will be returned.
       */
      public java.lang.String getLiveChatId() {
        return liveChatId;
      }

      /** The liveChatId parameter specifies the ID of the chat whose messages will be returned. */
      public List setLiveChatId(java.lang.String liveChatId) {
        this.liveChatId = liveChatId;
        return this;
      }

      /**
       * The part parameter specifies the liveChatComment resource parts that the API response will
       * include. Supported values are id and snippet.
       */
      @com.google.api.client.util.Key
      private java.lang.String part;

      /** The part parameter specifies the liveChatComment resource parts that the API response will include.
     Supported values are id and snippet.
       */
      public java.lang.String getPart() {
        return part;
      }

      /**
       * The part parameter specifies the liveChatComment resource parts that the API response will
       * include. Supported values are id and snippet.
       */
      public List setPart(java.lang.String part) {
        this.part = part;
        return this;
      }

      /**
       * The hl parameter instructs the API to retrieve localized resource metadata for a specific
       * application language that the YouTube website supports. The parameter value must be a
       * language code included in the list returned by the i18nLanguages.list method.
       *
       * If localized resource details are available in that language, the resource's
       * snippet.localized object will contain the localized values. However, if localized details
       * are not available, the snippet.localized object will contain resource details in the
       * resource's default language.
       */
      @com.google.api.client.util.Key
      private java.lang.String hl;

      /** The hl parameter instructs the API to retrieve localized resource metadata for a specific
     application language that the YouTube website supports. The parameter value must be a language code
     included in the list returned by the i18nLanguages.list method.

     If localized resource details are available in that language, the resource's snippet.localized
     object will contain the localized values. However, if localized details are not available, the
     snippet.localized object will contain resource details in the resource's default language.
       */
      public java.lang.String getHl() {
        return hl;
      }

      /**
       * The hl parameter instructs the API to retrieve localized resource metadata for a specific
       * application language that the YouTube website supports. The parameter value must be a
       * language code included in the list returned by the i18nLanguages.list method.
       *
       * If localized resource details are available in that language, the resource's
       * snippet.localized object will contain the localized values. However, if localized details
       * are not available, the snippet.localized object will contain resource details in the
       * resource's default language.
       */
      public List setHl(java.lang.String hl) {
        this.hl = hl;
        return this;
      }

      /**
       * The maxResults parameter specifies the maximum number of messages that should be returned
       * in the result set.
       */
      @com.google.api.client.util.Key
      private java.lang.Long maxResults;

      /** The maxResults parameter specifies the maximum number of messages that should be returned in the
     result set. [default: 500] [minimum: 200] [maximum: 2000]
       */
      public java.lang.Long getMaxResults() {
        return maxResults;
      }

      /**
       * The maxResults parameter specifies the maximum number of messages that should be returned
       * in the result set.
       */
      public List setMaxResults(java.lang.Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      /**
       * The pageToken parameter identifies a specific page in the result set that should be
       * returned. In an API response, the nextPageToken property identify other pages that could be
       * retrieved.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** The pageToken parameter identifies a specific page in the result set that should be returned. In an
     API response, the nextPageToken property identify other pages that could be retrieved.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * The pageToken parameter identifies a specific page in the result set that should be
       * returned. In an API response, the nextPageToken property identify other pages that could be
       * retrieved.
       */
      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      /**
       * The profileImageSize parameter specifies the size of the user profile pictures that should
       * be returned in the result set. Default: 88.
       */
      @com.google.api.client.util.Key
      private java.lang.Long profileImageSize;

      /** The profileImageSize parameter specifies the size of the user profile pictures that should be
     returned in the result set. Default: 88.

     [minimum: 16] [maximum: 720]
       */
      public java.lang.Long getProfileImageSize() {
        return profileImageSize;
      }

      /**
       * The profileImageSize parameter specifies the size of the user profile pictures that should
       * be returned in the result set. Default: 88.
       */
      public List setProfileImageSize(java.lang.Long profileImageSize) {
        this.profileImageSize = profileImageSize;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the LiveChatModerators collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code YouTube youtube = new YouTube(...);}
   *   {@code YouTube.LiveChatModerators.List request = youtube.liveChatModerators().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public LiveChatModerators liveChatModerators() {
    return new LiveChatModerators();
  }

  /**
   * The "liveChatModerators" collection of methods.
   */
  public class LiveChatModerators {

    /**
     * Removes a chat moderator.
     *
     * Create a request for the method "liveChatModerators.delete".
     *
     * This request holds the parameters needed by the youtube server.  After setting any optional
     * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
     *
     * @param id The id parameter identifies the chat moderator to remove. The value uniquely identifies both the
     *        moderator and the chat.
     * @return the request
     */
    public Delete delete(java.lang.String id) throws java.io.IOException {
      Delete result = new Delete(id);
      initialize(result);
      return result;
    }

    public class Delete extends YouTubeRequest<Void> {

      private static final String REST_PATH = "liveChat/moderators";

      /**
       * Removes a chat moderator.
       *
       * Create a request for the method "liveChatModerators.delete".
       *
       * This request holds the parameters needed by the the youtube server.  After setting any optional
       * parameters, call the {@link Delete#execute()} method to invoke the remote operation. <p> {@link
       * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param id The id parameter identifies the chat moderator to remove. The value uniquely identifies both the
     *        moderator and the chat.
       * @since 1.13
       */
      protected Delete(java.lang.String id) {
        super(YouTube.this, "DELETE", REST_PATH, null, Void.class);
        this.id = com.google.api.client.util.Preconditions.checkNotNull(id, "Required parameter id must be specified.");
      }

      @Override
      public Delete setAlt(java.lang.String alt) {
        return (Delete) super.setAlt(alt);
      }

      @Override
      public Delete setFields(java.lang.String fields) {
        return (Delete) super.setFields(fields);
      }

      @Override
      public Delete setKey(java.lang.String key) {
        return (Delete) super.setKey(key);
      }

      @Override
      public Delete setOauthToken(java.lang.String oauthToken) {
        return (Delete) super.setOauthToken(oauthToken);
      }

      @Override
      public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Delete) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Delete setQuotaUser(java.lang.String quotaUser) {
        return (Delete) super.setQuotaUser(quotaUser);
      }

      @Override
      public Delete setUserIp(java.lang.String userIp) {
        return (Delete) super.setUserIp(userIp);
      }

      /**
       * The id parameter identifies the chat moderator to remove. The value uniquely identifies
       * both the moderator and the chat.
       */
      @com.google.api.client.util.Key
      private java.lang.String id;

      /** The id parameter identifies the chat moderator to remove. The value uniquely identifies both the
     moderator and the chat.
       */
      public java.lang.String getId() {
        return id;
      }

      /**
       * The id parameter identifies the chat moderator to remove. The value uniquely identifies
       * both the moderator and the chat.
       */
      public Delete setId(java.lang.String id) {
        this.id = id;
        return this;
      }

      @Override
      public Delete set(String parameterName, Object value) {
        return (Delete) super.set(parameterName, value);
      }
    }
    /**
     * Adds a new moderator for the chat.
     *
     * Create a request for the method "liveChatModerators.insert".
     *
     * This request holds the parameters needed by the youtube server.  After setting any optional
     * parameters, call the {@link Insert#execute()} method to invoke the remote operation.
     *
     * @param part The part parameter serves two purposes in this operation. It identifies the properties that the
     *        write operation will set as well as the properties that the API response returns. Set the
     *        parameter value to snippet.
     * @param content the {@link com.google.api.services.youtube.model.LiveChatModerator}
     * @return the request
     */
    public Insert insert(java.lang.String part, com.google.api.services.youtube.model.LiveChatModerator content) throws java.io.IOException {
      Insert result = new Insert(part, content);
      initialize(result);
      return result;
    }

    public class Insert extends YouTubeRequest<com.google.api.services.youtube.model.LiveChatModerator> {

      private static final String REST_PATH = "liveChat/moderators";

      /**
       * Adds a new moderator for the chat.
       *
       * Create a request for the method "liveChatModerators.insert".
       *
       * This request holds the parameters needed by the the youtube server.  After setting any optional
       * parameters, call the {@link Insert#execute()} method to invoke the remote operation. <p> {@link
       * Insert#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param part The part parameter serves two purposes in this operation. It identifies the properties that the
     *        write operation will set as well as the properties that the API response returns. Set the
     *        parameter value to snippet.
       * @param content the {@link com.google.api.services.youtube.model.LiveChatModerator}
       * @since 1.13
       */
      protected Insert(java.lang.String part, com.google.api.services.youtube.model.LiveChatModerator content) {
        super(YouTube.this, "POST", REST_PATH, content, com.google.api.services.youtube.model.LiveChatModerator.class);
        this.part = com.google.api.client.util.Preconditions.checkNotNull(part, "Required parameter part must be specified.");
      }

      @Override
      public Insert setAlt(java.lang.String alt) {
        return (Insert) super.setAlt(alt);
      }

      @Override
      public Insert setFields(java.lang.String fields) {
        return (Insert) super.setFields(fields);
      }

      @Override
      public Insert setKey(java.lang.String key) {
        return (Insert) super.setKey(key);
      }

      @Override
      public Insert setOauthToken(java.lang.String oauthToken) {
        return (Insert) super.setOauthToken(oauthToken);
      }

      @Override
      public Insert setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Insert) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Insert setQuotaUser(java.lang.String quotaUser) {
        return (Insert) super.setQuotaUser(quotaUser);
      }

      @Override
      public Insert setUserIp(java.lang.String userIp) {
        return (Insert) super.setUserIp(userIp);
      }

      /**
       * The part parameter serves two purposes in this operation. It identifies the properties that
       * the write operation will set as well as the properties that the API response returns. Set
       * the parameter value to snippet.
       */
      @com.google.api.client.util.Key
      private java.lang.String part;

      /** The part parameter serves two purposes in this operation. It identifies the properties that the
     write operation will set as well as the properties that the API response returns. Set the parameter
     value to snippet.
       */
      public java.lang.String getPart() {
        return part;
      }

      /**
       * The part parameter serves two purposes in this operation. It identifies the properties that
       * the write operation will set as well as the properties that the API response returns. Set
       * the parameter value to snippet.
       */
      public Insert setPart(java.lang.String part) {
        this.part = part;
        return this;
      }

      @Override
      public Insert set(String parameterName, Object value) {
        return (Insert) super.set(parameterName, value);
      }
    }
    /**
     * Lists moderators for a live chat.
     *
     * Create a request for the method "liveChatModerators.list".
     *
     * This request holds the parameters needed by the youtube server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param liveChatId The liveChatId parameter specifies the YouTube live chat for which the API should return moderators.
     * @param part The part parameter specifies the liveChatModerator resource parts that the API response will
     *        include. Supported values are id and snippet.
     * @return the request
     */
    public List list(java.lang.String liveChatId, java.lang.String part) throws java.io.IOException {
      List result = new List(liveChatId, part);
      initialize(result);
      return result;
    }

    public class List extends YouTubeRequest<com.google.api.services.youtube.model.LiveChatModeratorListResponse> {

      private static final String REST_PATH = "liveChat/moderators";

      /**
       * Lists moderators for a live chat.
       *
       * Create a request for the method "liveChatModerators.list".
       *
       * This request holds the parameters needed by the the youtube server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param liveChatId The liveChatId parameter specifies the YouTube live chat for which the API should return moderators.
       * @param part The part parameter specifies the liveChatModerator resource parts that the API response will
     *        include. Supported values are id and snippet.
       * @since 1.13
       */
      protected List(java.lang.String liveChatId, java.lang.String part) {
        super(YouTube.this, "GET", REST_PATH, null, com.google.api.services.youtube.model.LiveChatModeratorListResponse.class);
        this.liveChatId = com.google.api.client.util.Preconditions.checkNotNull(liveChatId, "Required parameter liveChatId must be specified.");
        this.part = com.google.api.client.util.Preconditions.checkNotNull(part, "Required parameter part must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUserIp(java.lang.String userIp) {
        return (List) super.setUserIp(userIp);
      }

      /**
       * The liveChatId parameter specifies the YouTube live chat for which the API should return
       * moderators.
       */
      @com.google.api.client.util.Key
      private java.lang.String liveChatId;

      /** The liveChatId parameter specifies the YouTube live chat for which the API should return
     moderators.
       */
      public java.lang.String getLiveChatId() {
        return liveChatId;
      }

      /**
       * The liveChatId parameter specifies the YouTube live chat for which the API should return
       * moderators.
       */
      public List setLiveChatId(java.lang.String liveChatId) {
        this.liveChatId = liveChatId;
        return this;
      }

      /**
       * The part parameter specifies the liveChatModerator resource parts that the API response
       * will include. Supported values are id and snippet.
       */
      @com.google.api.client.util.Key
      private java.lang.String part;

      /** The part parameter specifies the liveChatModerator resource parts that the API response will
     include. Supported values are id and snippet.
       */
      public java.lang.String getPart() {
        return part;
      }

      /**
       * The part parameter specifies the liveChatModerator resource parts that the API response
       * will include. Supported values are id and snippet.
       */
      public List setPart(java.lang.String part) {
        this.part = part;
        return this;
      }

      /**
       * The maxResults parameter specifies the maximum number of items that should be returned in
       * the result set.
       */
      @com.google.api.client.util.Key
      private java.lang.Long maxResults;

      /** The maxResults parameter specifies the maximum number of items that should be returned in the
     result set. [default: 5] [minimum: 0] [maximum: 50]
       */
      public java.lang.Long getMaxResults() {
        return maxResults;
      }

      /**
       * The maxResults parameter specifies the maximum number of items that should be returned in
       * the result set.
       */
      public List setMaxResults(java.lang.Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      /**
       * The pageToken parameter identifies a specific page in the result set that should be
       * returned. In an API response, the nextPageToken and prevPageToken properties identify other
       * pages that could be retrieved.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** The pageToken parameter identifies a specific page in the result set that should be returned. In an
     API response, the nextPageToken and prevPageToken properties identify other pages that could be
     retrieved.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * The pageToken parameter identifies a specific page in the result set that should be
       * returned. In an API response, the nextPageToken and prevPageToken properties identify other
       * pages that could be retrieved.
       */
      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the LiveStreams collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code YouTube youtube = new YouTube(...);}
   *   {@code YouTube.LiveStreams.List request = youtube.liveStreams().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public LiveStreams liveStreams() {
    return new LiveStreams();
  }

  /**
   * The "liveStreams" collection of methods.
   */
  public class LiveStreams {

    /**
     * Deletes a video stream.
     *
     * Create a request for the method "liveStreams.delete".
     *
     * This request holds the parameters needed by the youtube server.  After setting any optional
     * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
     *
     * @param id The id parameter specifies the YouTube live stream ID for the resource that is being deleted.
     * @return the request
     */
    public Delete delete(java.lang.String id) throws java.io.IOException {
      Delete result = new Delete(id);
      initialize(result);
      return result;
    }

    public class Delete extends YouTubeRequest<Void> {

      private static final String REST_PATH = "liveStreams";

      /**
       * Deletes a video stream.
       *
       * Create a request for the method "liveStreams.delete".
       *
       * This request holds the parameters needed by the the youtube server.  After setting any optional
       * parameters, call the {@link Delete#execute()} method to invoke the remote operation. <p> {@link
       * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param id The id parameter specifies the YouTube live stream ID for the resource that is being deleted.
       * @since 1.13
       */
      protected Delete(java.lang.String id) {
        super(YouTube.this, "DELETE", REST_PATH, null, Void.class);
        this.id = com.google.api.client.util.Preconditions.checkNotNull(id, "Required parameter id must be specified.");
      }

      @Override
      public Delete setAlt(java.lang.String alt) {
        return (Delete) super.setAlt(alt);
      }

      @Override
      public Delete setFields(java.lang.String fields) {
        return (Delete) super.setFields(fields);
      }

      @Override
      public Delete setKey(java.lang.String key) {
        return (Delete) super.setKey(key);
      }

      @Override
      public Delete setOauthToken(java.lang.String oauthToken) {
        return (Delete) super.setOauthToken(oauthToken);
      }

      @Override
      public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Delete) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Delete setQuotaUser(java.lang.String quotaUser) {
        return (Delete) super.setQuotaUser(quotaUser);
      }

      @Override
      public Delete setUserIp(java.lang.String userIp) {
        return (Delete) super.setUserIp(userIp);
      }

      /**
       * The id parameter specifies the YouTube live stream ID for the resource that is being
       * deleted.
       */
      @com.google.api.client.util.Key
      private java.lang.String id;

      /** The id parameter specifies the YouTube live stream ID for the resource that is being deleted.
       */
      public java.lang.String getId() {
        return id;
      }

      /**
       * The id parameter specifies the YouTube live stream ID for the resource that is being
       * deleted.
       */
      public Delete setId(java.lang.String id) {
        this.id = id;
        return this;
      }

      /**
       * Note: This parameter is intended exclusively for YouTube content partners.
       *
       * The onBehalfOfContentOwner parameter indicates that the request's authorization credentials
       * identify a YouTube CMS user who is acting on behalf of the content owner specified in the
       * parameter value. This parameter is intended for YouTube content partners that own and
       * manage many different YouTube channels. It allows content owners to authenticate once and
       * get access to all their video and channel data, without having to provide authentication
       * credentials for each individual channel. The CMS account that the user authenticates with
       * must be linked to the specified YouTube content owner.
       */
      @com.google.api.client.util.Key
      private java.lang.String onBehalfOfContentOwner;

      /** Note: This parameter is intended exclusively for YouTube content partners.

     The onBehalfOfContentOwner parameter indicates that the request's authorization credentials
     identify a YouTube CMS user who is acting on behalf of the content owner specified in the parameter
     value. This parameter is intended for YouTube content partners that own and manage many different
     YouTube channels. It allows content owners to authenticate once and get access to all their video
     and channel data, without having to provide authentication credentials for each individual channel.
     The CMS account that the user authenticates with must be linked to the specified YouTube content
     owner.
       */
      public java.lang.String getOnBehalfOfContentOwner() {
        return onBehalfOfContentOwner;
      }

      /**
       * Note: This parameter is intended exclusively for YouTube content partners.
       *
       * The onBehalfOfContentOwner parameter indicates that the request's authorization credentials
       * identify a YouTube CMS user who is acting on behalf of the content owner specified in the
       * parameter value. This parameter is intended for YouTube content partners that own and
       * manage many different YouTube channels. It allows content owners to authenticate once and
       * get access to all their video and channel data, without having to provide authentication
       * credentials for each individual channel. The CMS account that the user authenticates with
       * must be linked to the specified YouTube content owner.
       */
      public Delete setOnBehalfOfContentOwner(java.lang.String onBehalfOfContentOwner) {
        this.onBehalfOfContentOwner = onBehalfOfContentOwner;
        return this;
      }

      /**
       * This parameter can only be used in a properly authorized request. Note: This parameter is
       * intended exclusively for YouTube content partners.
       *
       * The onBehalfOfContentOwnerChannel parameter specifies the YouTube channel ID of the channel
       * to which a video is being added. This parameter is required when a request specifies a
       * value for the onBehalfOfContentOwner parameter, and it can only be used in conjunction with
       * that parameter. In addition, the request must be authorized using a CMS account that is
       * linked to the content owner that the onBehalfOfContentOwner parameter specifies. Finally,
       * the channel that the onBehalfOfContentOwnerChannel parameter value specifies must be linked
       * to the content owner that the onBehalfOfContentOwner parameter specifies.
       *
       * This parameter is intended for YouTube content partners that own and manage many different
       * YouTube channels. It allows content owners to authenticate once and perform actions on
       * behalf of the channel specified in the parameter value, without having to provide
       * authentication credentials for each separate channel.
       */
      @com.google.api.client.util.Key
      private java.lang.String onBehalfOfContentOwnerChannel;

      /** This parameter can only be used in a properly authorized request. Note: This parameter is intended
     exclusively for YouTube content partners.

     The onBehalfOfContentOwnerChannel parameter specifies the YouTube channel ID of the channel to
     which a video is being added. This parameter is required when a request specifies a value for the
     onBehalfOfContentOwner parameter, and it can only be used in conjunction with that parameter. In
     addition, the request must be authorized using a CMS account that is linked to the content owner
     that the onBehalfOfContentOwner parameter specifies. Finally, the channel that the
     onBehalfOfContentOwnerChannel parameter value specifies must be linked to the content owner that
     the onBehalfOfContentOwner parameter specifies.

     This parameter is intended for YouTube content partners that own and manage many different YouTube
     channels. It allows content owners to authenticate once and perform actions on behalf of the
     channel specified in the parameter value, without having to provide authentication credentials for
     each separate channel.
       */
      public java.lang.String getOnBehalfOfContentOwnerChannel() {
        return onBehalfOfContentOwnerChannel;
      }

      /**
       * This parameter can only be used in a properly authorized request. Note: This parameter is
       * intended exclusively for YouTube content partners.
       *
       * The onBehalfOfContentOwnerChannel parameter specifies the YouTube channel ID of the channel
       * to which a video is being added. This parameter is required when a request specifies a
       * value for the onBehalfOfContentOwner parameter, and it can only be used in conjunction with
       * that parameter. In addition, the request must be authorized using a CMS account that is
       * linked to the content owner that the onBehalfOfContentOwner parameter specifies. Finally,
       * the channel that the onBehalfOfContentOwnerChannel parameter value specifies must be linked
       * to the content owner that the onBehalfOfContentOwner parameter specifies.
       *
       * This parameter is intended for YouTube content partners that own and manage many different
       * YouTube channels. It allows content owners to authenticate once and perform actions on
       * behalf of the channel specified in the parameter value, without having to provide
       * authentication credentials for each separate channel.
       */
      public Delete setOnBehalfOfContentOwnerChannel(java.lang.String onBehalfOfContentOwnerChannel) {
        this.onBehalfOfContentOwnerChannel = onBehalfOfContentOwnerChannel;
        return this;
      }

      @Override
      public Delete set(String parameterName, Object value) {
        return (Delete) super.set(parameterName, value);
      }
    }
    /**
     * Creates a video stream. The stream enables you to send your video to YouTube, which can then
     * broadcast the video to your audience.
     *
     * Create a request for the method "liveStreams.insert".
     *
     * This request holds the parameters needed by the youtube server.  After setting any optional
     * parameters, call the {@link Insert#execute()} method to invoke the remote operation.
     *
     * @param part The part parameter serves two purposes in this operation. It identifies the properties that the
     *        write operation will set as well as the properties that the API response will include.
    The
     *        part properties that you can include in the parameter value are id, snippet, cdn, and
     *        status.
     * @param content the {@link com.google.api.services.youtube.model.LiveStream}
     * @return the request
     */
    public Insert insert(java.lang.String part, com.google.api.services.youtube.model.LiveStream content) throws java.io.IOException {
      Insert result = new Insert(part, content);
      initialize(result);
      return result;
    }

    public class Insert extends YouTubeRequest<com.google.api.services.youtube.model.LiveStream> {

      private static final String REST_PATH = "liveStreams";

      /**
       * Creates a video stream. The stream enables you to send your video to YouTube, which can then
       * broadcast the video to your audience.
       *
       * Create a request for the method "liveStreams.insert".
       *
       * This request holds the parameters needed by the the youtube server.  After setting any optional
       * parameters, call the {@link Insert#execute()} method to invoke the remote operation. <p> {@link
       * Insert#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param part The part parameter serves two purposes in this operation. It identifies the properties that the
     *        write operation will set as well as the properties that the API response will include.
    The
     *        part properties that you can include in the parameter value are id, snippet, cdn, and
     *        status.
       * @param content the {@link com.google.api.services.youtube.model.LiveStream}
       * @since 1.13
       */
      protected Insert(java.lang.String part, com.google.api.services.youtube.model.LiveStream content) {
        super(YouTube.this, "POST", REST_PATH, content, com.google.api.services.youtube.model.LiveStream.class);
        this.part = com.google.api.client.util.Preconditions.checkNotNull(part, "Required parameter part must be specified.");
      }

      @Override
      public Insert setAlt(java.lang.String alt) {
        return (Insert) super.setAlt(alt);
      }

      @Override
      public Insert setFields(java.lang.String fields) {
        return (Insert) super.setFields(fields);
      }

      @Override
      public Insert setKey(java.lang.String key) {
        return (Insert) super.setKey(key);
      }

      @Override
      public Insert setOauthToken(java.lang.String oauthToken) {
        return (Insert) super.setOauthToken(oauthToken);
      }

      @Override
      public Insert setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Insert) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Insert setQuotaUser(java.lang.String quotaUser) {
        return (Insert) super.setQuotaUser(quotaUser);
      }

      @Override
      public Insert setUserIp(java.lang.String userIp) {
        return (Insert) super.setUserIp(userIp);
      }

      /**
       * The part parameter serves two purposes in this operation. It identifies the properties that
       * the write operation will set as well as the properties that the API response will include.
       *
       * The part properties that you can include in the parameter value are id, snippet, cdn, and
       * status.
       */
      @com.google.api.client.util.Key
      private java.lang.String part;

      /** The part parameter serves two purposes in this operation. It identifies the properties that the
     write operation will set as well as the properties that the API response will include.

     The part properties that you can include in the parameter value are id, snippet, cdn, and status.
       */
      public java.lang.String getPart() {
        return part;
      }

      /**
       * The part parameter serves two purposes in this operation. It identifies the properties that
       * the write operation will set as well as the properties that the API response will include.
       *
       * The part properties that you can include in the parameter value are id, snippet, cdn, and
       * status.
       */
      public Insert setPart(java.lang.String part) {
        this.part = part;
        return this;
      }

      /**
       * Note: This parameter is intended exclusively for YouTube content partners.
       *
       * The onBehalfOfContentOwner parameter indicates that the request's authorization credentials
       * identify a YouTube CMS user who is acting on behalf of the content owner specified in the
       * parameter value. This parameter is intended for YouTube content partners that own and
       * manage many different YouTube channels. It allows content owners to authenticate once and
       * get access to all their video and channel data, without having to provide authentication
       * credentials for each individual channel. The CMS account that the user authenticates with
       * must be linked to the specified YouTube content owner.
       */
      @com.google.api.client.util.Key
      private java.lang.String onBehalfOfContentOwner;

      /** Note: This parameter is intended exclusively for YouTube content partners.

     The onBehalfOfContentOwner parameter indicates that the request's authorization credentials
     identify a YouTube CMS user who is acting on behalf of the content owner specified in the parameter
     value. This parameter is intended for YouTube content partners that own and manage many different
     YouTube channels. It allows content owners to authenticate once and get access to all their video
     and channel data, without having to provide authentication credentials for each individual channel.
     The CMS account that the user authenticates with must be linked to the specified YouTube content
     owner.
       */
      public java.lang.String getOnBehalfOfContentOwner() {
        return onBehalfOfContentOwner;
      }

      /**
       * Note: This parameter is intended exclusively for YouTube content partners.
       *
       * The onBehalfOfContentOwner parameter indicates that the request's authorization credentials
       * identify a YouTube CMS user who is acting on behalf of the content owner specified in the
       * parameter value. This parameter is intended for YouTube content partners that own and
       * manage many different YouTube channels. It allows content owners to authenticate once and
       * get access to all their video and channel data, without having to provide authentication
       * credentials for each individual channel. The CMS account that the user authenticates with
       * must be linked to the specified YouTube content owner.
       */
      public Insert setOnBehalfOfContentOwner(java.lang.String onBehalfOfContentOwner) {
        this.onBehalfOfContentOwner = onBehalfOfContentOwner;
        return this;
      }

      /**
       * This parameter can only be used in a properly authorized request. Note: This parameter is
       * intended exclusively for YouTube content partners.
       *
       * The onBehalfOfContentOwnerChannel parameter specifies the YouTube channel ID of the channel
       * to which a video is being added. This parameter is required when a request specifies a
       * value for the onBehalfOfContentOwner parameter, and it can only be used in conjunction with
       * that parameter. In addition, the request must be authorized using a CMS account that is
       * linked to the content owner that the onBehalfOfContentOwner parameter specifies. Finally,
       * the channel that the onBehalfOfContentOwnerChannel parameter value specifies must be linked
       * to the content owner that the onBehalfOfContentOwner parameter specifies.
       *
       * This parameter is intended for YouTube content partners that own and manage many different
       * YouTube channels. It allows content owners to authenticate once and perform actions on
       * behalf of the channel specified in the parameter value, without having to provide
       * authentication credentials for each separate channel.
       */
      @com.google.api.client.util.Key
      private java.lang.String onBehalfOfContentOwnerChannel;

      /** This parameter can only be used in a properly authorized request. Note: This parameter is intended
     exclusively for YouTube content partners.

     The onBehalfOfContentOwnerChannel parameter specifies the YouTube channel ID of the channel to
     which a video is being added. This parameter is required when a request specifies a value for the
     onBehalfOfContentOwner parameter, and it can only be used in conjunction with that parameter. In
     addition, the request must be authorized using a CMS account that is linked to the content owner
     that the onBehalfOfContentOwner parameter specifies. Finally, the channel that the
     onBehalfOfContentOwnerChannel parameter value specifies must be linked to the content owner that
     the onBehalfOfContentOwner parameter specifies.

     This parameter is intended for YouTube content partners that own and manage many different YouTube
     channels. It allows content owners to authenticate once and perform actions on behalf of the
     channel specified in the parameter value, without having to provide authentication credentials for
     each separate channel.
       */
      public java.lang.String getOnBehalfOfContentOwnerChannel() {
        return onBehalfOfContentOwnerChannel;
      }

      /**
       * This parameter can only be used in a properly authorized request. Note: This parameter is
       * intended exclusively for YouTube content partners.
       *
       * The onBehalfOfContentOwnerChannel parameter specifies the YouTube channel ID of the channel
       * to which a video is being added. This parameter is required when a request specifies a
       * value for the onBehalfOfContentOwner parameter, and it can only be used in conjunction with
       * that parameter. In addition, the request must be authorized using a CMS account that is
       * linked to the content owner that the onBehalfOfContentOwner parameter specifies. Finally,
       * the channel that the onBehalfOfContentOwnerChannel parameter value specifies must be linked
       * to the content owner that the onBehalfOfContentOwner parameter specifies.
       *
       * This parameter is intended for YouTube content partners that own and manage many different
       * YouTube channels. It allows content owners to authenticate once and perform actions on
       * behalf of the channel specified in the parameter value, without having to provide
       * authentication credentials for each separate channel.
       */
      public Insert setOnBehalfOfContentOwnerChannel(java.lang.String onBehalfOfContentOwnerChannel) {
        this.onBehalfOfContentOwnerChannel = onBehalfOfContentOwnerChannel;
        return this;
      }

      @Override
      public Insert set(String parameterName, Object value) {
        return (Insert) super.set(parameterName, value);
      }
    }
    /**
     * Returns a list of video streams that match the API request parameters.
     *
     * Create a request for the method "liveStreams.list".
     *
     * This request holds the parameters needed by the youtube server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param part The part parameter specifies a comma-separated list of one or more liveStream resource properties
     *        that the API response will include. The part names that you can include in the parameter
     *        value are id, snippet, cdn, and status.
     * @return the request
     */
    public List list(java.lang.String part) throws java.io.IOException {
      List result = new List(part);
      initialize(result);
      return result;
    }

    public class List extends YouTubeRequest<com.google.api.services.youtube.model.LiveStreamListResponse> {

      private static final String REST_PATH = "liveStreams";

      /**
       * Returns a list of video streams that match the API request parameters.
       *
       * Create a request for the method "liveStreams.list".
       *
       * This request holds the parameters needed by the the youtube server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param part The part parameter specifies a comma-separated list of one or more liveStream resource properties
     *        that the API response will include. The part names that you can include in the parameter
     *        value are id, snippet, cdn, and status.
       * @since 1.13
       */
      protected List(java.lang.String part) {
        super(YouTube.this, "GET", REST_PATH, null, com.google.api.services.youtube.model.LiveStreamListResponse.class);
        this.part = com.google.api.client.util.Preconditions.checkNotNull(part, "Required parameter part must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUserIp(java.lang.String userIp) {
        return (List) super.setUserIp(userIp);
      }

      /**
       * The part parameter specifies a comma-separated list of one or more liveStream resource
       * properties that the API response will include. The part names that you can include in the
       * parameter value are id, snippet, cdn, and status.
       */
      @com.google.api.client.util.Key
      private java.lang.String part;

      /** The part parameter specifies a comma-separated list of one or more liveStream resource properties
     that the API response will include. The part names that you can include in the parameter value are
     id, snippet, cdn, and status.
       */
      public java.lang.String getPart() {
        return part;
      }

      /**
       * The part parameter specifies a comma-separated list of one or more liveStream resource
       * properties that the API response will include. The part names that you can include in the
       * parameter value are id, snippet, cdn, and status.
       */
      public List setPart(java.lang.String part) {
        this.part = part;
        return this;
      }

      /**
       * The id parameter specifies a comma-separated list of YouTube stream IDs that identify the
       * streams being retrieved. In a liveStream resource, the id property specifies the stream's
       * ID.
       */
      @com.google.api.client.util.Key
      private java.lang.String id;

      /** The id parameter specifies a comma-separated list of YouTube stream IDs that identify the streams
     being retrieved. In a liveStream resource, the id property specifies the stream's ID.
       */
      public java.lang.String getId() {
        return id;
      }

      /**
       * The id parameter specifies a comma-separated list of YouTube stream IDs that identify the
       * streams being retrieved. In a liveStream resource, the id property specifies the stream's
       * ID.
       */
      public List setId(java.lang.String id) {
        this.id = id;
        return this;
      }

      /**
       * The maxResults parameter specifies the maximum number of items that should be returned in
       * the result set.
       */
      @com.google.api.client.util.Key
      private java.lang.Long maxResults;

      /** The maxResults parameter specifies the maximum number of items that should be returned in the
     result set. [default: 5] [minimum: 0] [maximum: 50]
       */
      public java.lang.Long getMaxResults() {
        return maxResults;
      }

      /**
       * The maxResults parameter specifies the maximum number of items that should be returned in
       * the result set.
       */
      public List setMaxResults(java.lang.Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      /**
       * The mine parameter can be used to instruct the API to only return streams owned by the
       * authenticated user. Set the parameter value to true to only retrieve your own streams.
       */
      @com.google.api.client.util.Key
      private java.lang.Boolean mine;

      /** The mine parameter can be used to instruct the API to only return streams owned by the
     authenticated user. Set the parameter value to true to only retrieve your own streams.
       */
      public java.lang.Boolean getMine() {
        return mine;
      }

      /**
       * The mine parameter can be used to instruct the API to only return streams owned by the
       * authenticated user. Set the parameter value to true to only retrieve your own streams.
       */
      public List setMine(java.lang.Boolean mine) {
        this.mine = mine;
        return this;
      }

      /**
       * Note: This parameter is intended exclusively for YouTube content partners.
       *
       * The onBehalfOfContentOwner parameter indicates that the request's authorization credentials
       * identify a YouTube CMS user who is acting on behalf of the content owner specified in the
       * parameter value. This parameter is intended for YouTube content partners that own and
       * manage many different YouTube channels. It allows content owners to authenticate once and
       * get access to all their video and channel data, without having to provide authentication
       * credentials for each individual channel. The CMS account that the user authenticates with
       * must be linked to the specified YouTube content owner.
       */
      @com.google.api.client.util.Key
      private java.lang.String onBehalfOfContentOwner;

      /** Note: This parameter is intended exclusively for YouTube content partners.

     The onBehalfOfContentOwner parameter indicates that the request's authorization credentials
     identify a YouTube CMS user who is acting on behalf of the content owner specified in the parameter
     value. This parameter is intended for YouTube content partners that own and manage many different
     YouTube channels. It allows content owners to authenticate once and get access to all their video
     and channel data, without having to provide authentication credentials for each individual channel.
     The CMS account that the user authenticates with must be linked to the specified YouTube content
     owner.
       */
      public java.lang.String getOnBehalfOfContentOwner() {
        return onBehalfOfContentOwner;
      }

      /**
       * Note: This parameter is intended exclusively for YouTube content partners.
       *
       * The onBehalfOfContentOwner parameter indicates that the request's authorization credentials
       * identify a YouTube CMS user who is acting on behalf of the content owner specified in the
       * parameter value. This parameter is intended for YouTube content partners that own and
       * manage many different YouTube channels. It allows content owners to authenticate once and
       * get access to all their video and channel data, without having to provide authentication
       * credentials for each individual channel. The CMS account that the user authenticates with
       * must be linked to the specified YouTube content owner.
       */
      public List setOnBehalfOfContentOwner(java.lang.String onBehalfOfContentOwner) {
        this.onBehalfOfContentOwner = onBehalfOfContentOwner;
        return this;
      }

      /**
       * This parameter can only be used in a properly authorized request. Note: This parameter is
       * intended exclusively for YouTube content partners.
       *
       * The onBehalfOfContentOwnerChannel parameter specifies the YouTube channel ID of the channel
       * to which a video is being added. This parameter is required when a request specifies a
       * value for the onBehalfOfContentOwner parameter, and it can only be used in conjunction with
       * that parameter. In addition, the request must be authorized using a CMS account that is
       * linked to the content owner that the onBehalfOfContentOwner parameter specifies. Finally,
       * the channel that the onBehalfOfContentOwnerChannel parameter value specifies must be linked
       * to the content owner that the onBehalfOfContentOwner parameter specifies.
       *
       * This parameter is intended for YouTube content partners that own and manage many different
       * YouTube channels. It allows content owners to authenticate once and perform actions on
       * behalf of the channel specified in the parameter value, without having to provide
       * authentication credentials for each separate channel.
       */
      @com.google.api.client.util.Key
      private java.lang.String onBehalfOfContentOwnerChannel;

      /** This parameter can only be used in a properly authorized request. Note: This parameter is intended
     exclusively for YouTube content partners.

     The onBehalfOfContentOwnerChannel parameter specifies the YouTube channel ID of the channel to
     which a video is being added. This parameter is required when a request specifies a value for the
     onBehalfOfContentOwner parameter, and it can only be used in conjunction with that parameter. In
     addition, the request must be authorized using a CMS account that is linked to the content owner
     that the onBehalfOfContentOwner parameter specifies. Finally, the channel that the
     onBehalfOfContentOwnerChannel parameter value specifies must be linked to the content owner that
     the onBehalfOfContentOwner parameter specifies.

     This parameter is intended for YouTube content partners that own and manage many different YouTube
     channels. It allows content owners to authenticate once and perform actions on behalf of the
     channel specified in the parameter value, without having to provide authentication credentials for
     each separate channel.
       */
      public java.lang.String getOnBehalfOfContentOwnerChannel() {
        return onBehalfOfContentOwnerChannel;
      }

      /**
       * This parameter can only be used in a properly authorized request. Note: This parameter is
       * intended exclusively for YouTube content partners.
       *
       * The onBehalfOfContentOwnerChannel parameter specifies the YouTube channel ID of the channel
       * to which a video is being added. This parameter is required when a request specifies a
       * value for the onBehalfOfContentOwner parameter, and it can only be used in conjunction with
       * that parameter. In addition, the request must be authorized using a CMS account that is
       * linked to the content owner that the onBehalfOfContentOwner parameter specifies. Finally,
       * the channel that the onBehalfOfContentOwnerChannel parameter value specifies must be linked
       * to the content owner that the onBehalfOfContentOwner parameter specifies.
       *
       * This parameter is intended for YouTube content partners that own and manage many different
       * YouTube channels. It allows content owners to authenticate once and perform actions on
       * behalf of the channel specified in the parameter value, without having to provide
       * authentication credentials for each separate channel.
       */
      public List setOnBehalfOfContentOwnerChannel(java.lang.String onBehalfOfContentOwnerChannel) {
        this.onBehalfOfContentOwnerChannel = onBehalfOfContentOwnerChannel;
        return this;
      }

      /**
       * The pageToken parameter identifies a specific page in the result set that should be
       * returned. In an API response, the nextPageToken and prevPageToken properties identify other
       * pages that could be retrieved.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** The pageToken parameter identifies a specific page in the result set that should be returned. In an
     API response, the nextPageToken and prevPageToken properties identify other pages that could be
     retrieved.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * The pageToken parameter identifies a specific page in the result set that should be
       * returned. In an API response, the nextPageToken and prevPageToken properties identify other
       * pages that could be retrieved.
       */
      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }
    /**
     * Updates a video stream. If the properties that you want to change cannot be updated, then you
     * need to create a new stream with the proper settings.
     *
     * Create a request for the method "liveStreams.update".
     *
     * This request holds the parameters needed by the youtube server.  After setting any optional
     * parameters, call the {@link Update#execute()} method to invoke the remote operation.
     *
     * @param part The part parameter serves two purposes in this operation. It identifies the properties that the
     *        write operation will set as well as the properties that the API response will include.
    The
     *        part properties that you can include in the parameter value are id, snippet, cdn, and
     *        status.
    Note that this method will override the existing values for all of the mutable
     *        properties that are contained in any parts that the parameter value specifies. If the
     *        request body does not specify a value for a mutable property, the existing value for that
     *        property will be removed.
     * @param content the {@link com.google.api.services.youtube.model.LiveStream}
     * @return the request
     */
    public Update update(java.lang.String part, com.google.api.services.youtube.model.LiveStream content) throws java.io.IOException {
      Update result = new Update(part, content);
      initialize(result);
      return result;
    }

    public class Update extends YouTubeRequest<com.google.api.services.youtube.model.LiveStream> {

      private static final String REST_PATH = "liveStreams";

      /**
       * Updates a video stream. If the properties that you want to change cannot be updated, then you
       * need to create a new stream with the proper settings.
       *
       * Create a request for the method "liveStreams.update".
       *
       * This request holds the parameters needed by the the youtube server.  After setting any optional
       * parameters, call the {@link Update#execute()} method to invoke the remote operation. <p> {@link
       * Update#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param part The part parameter serves two purposes in this operation. It identifies the properties that the
     *        write operation will set as well as the properties that the API response will include.
    The
     *        part properties that you can include in the parameter value are id, snippet, cdn, and
     *        status.
    Note that this method will override the existing values for all of the mutable
     *        properties that are contained in any parts that the parameter value specifies. If the
     *        request body does not specify a value for a mutable property, the existing value for that
     *        property will be removed.
       * @param content the {@link com.google.api.services.youtube.model.LiveStream}
       * @since 1.13
       */
      protected Update(java.lang.String part, com.google.api.services.youtube.model.LiveStream content) {
        super(YouTube.this, "PUT", REST_PATH, content, com.google.api.services.youtube.model.LiveStream.class);
        this.part = com.google.api.client.util.Preconditions.checkNotNull(part, "Required parameter part must be specified.");
        checkRequiredParameter(content, "content");
        checkRequiredParameter(content.getId(), "LiveStream.getId()");
      }

      @Override
      public Update setAlt(java.lang.String alt) {
        return (Update) super.setAlt(alt);
      }

      @Override
      public Update setFields(java.lang.String fields) {
        return (Update) super.setFields(fields);
      }

      @Override
      public Update setKey(java.lang.String key) {
        return (Update) super.setKey(key);
      }

      @Override
      public Update setOauthToken(java.lang.String oauthToken) {
        return (Update) super.setOauthToken(oauthToken);
      }

      @Override
      public Update setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Update) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Update setQuotaUser(java.lang.String quotaUser) {
        return (Update) super.setQuotaUser(quotaUser);
      }

      @Override
      public Update setUserIp(java.lang.String userIp) {
        return (Update) super.setUserIp(userIp);
      }

      /**
       * The part parameter serves two purposes in this operation. It identifies the properties that
       * the write operation will set as well as the properties that the API response will include.
       *
       * The part properties that you can include in the parameter value are id, snippet, cdn, and
       * status.
       *
       * Note that this method will override the existing values for all of the mutable properties
       * that are contained in any parts that the parameter value specifies. If the request body
       * does not specify a value for a mutable property, the existing value for that property will
       * be removed.
       */
      @com.google.api.client.util.Key
      private java.lang.String part;

      /** The part parameter serves two purposes in this operation. It identifies the properties that the
     write operation will set as well as the properties that the API response will include.

     The part properties that you can include in the parameter value are id, snippet, cdn, and status.

     Note that this method will override the existing values for all of the mutable properties that are
     contained in any parts that the parameter value specifies. If the request body does not specify a
     value for a mutable property, the existing value for that property will be removed.
       */
      public java.lang.String getPart() {
        return part;
      }

      /**
       * The part parameter serves two purposes in this operation. It identifies the properties that
       * the write operation will set as well as the properties that the API response will include.
       *
       * The part properties that you can include in the parameter value are id, snippet, cdn, and
       * status.
       *
       * Note that this method will override the existing values for all of the mutable properties
       * that are contained in any parts that the parameter value specifies. If the request body
       * does not specify a value for a mutable property, the existing value for that property will
       * be removed.
       */
      public Update setPart(java.lang.String part) {
        this.part = part;
        return this;
      }

      /**
       * Note: This parameter is intended exclusively for YouTube content partners.
       *
       * The onBehalfOfContentOwner parameter indicates that the request's authorization credentials
       * identify a YouTube CMS user who is acting on behalf of the content owner specified in the
       * parameter value. This parameter is intended for YouTube content partners that own and
       * manage many different YouTube channels. It allows content owners to authenticate once and
       * get access to all their video and channel data, without having to provide authentication
       * credentials for each individual channel. The CMS account that the user authenticates with
       * must be linked to the specified YouTube content owner.
       */
      @com.google.api.client.util.Key
      private java.lang.String onBehalfOfContentOwner;

      /** Note: This parameter is intended exclusively for YouTube content partners.

     The onBehalfOfContentOwner parameter indicates that the request's authorization credentials
     identify a YouTube CMS user who is acting on behalf of the content owner specified in the parameter
     value. This parameter is intended for YouTube content partners that own and manage many different
     YouTube channels. It allows content owners to authenticate once and get access to all their video
     and channel data, without having to provide authentication credentials for each individual channel.
     The CMS account that the user authenticates with must be linked to the specified YouTube content
     owner.
       */
      public java.lang.String getOnBehalfOfContentOwner() {
        return onBehalfOfContentOwner;
      }

      /**
       * Note: This parameter is intended exclusively for YouTube content partners.
       *
       * The onBehalfOfContentOwner parameter indicates that the request's authorization credentials
       * identify a YouTube CMS user who is acting on behalf of the content owner specified in the
       * parameter value. This parameter is intended for YouTube content partners that own and
       * manage many different YouTube channels. It allows content owners to authenticate once and
       * get access to all their video and channel data, without having to provide authentication
       * credentials for each individual channel. The CMS account that the user authenticates with
       * must be linked to the specified YouTube content owner.
       */
      public Update setOnBehalfOfContentOwner(java.lang.String onBehalfOfContentOwner) {
        this.onBehalfOfContentOwner = onBehalfOfContentOwner;
        return this;
      }

      /**
       * This parameter can only be used in a properly authorized request. Note: This parameter is
       * intended exclusively for YouTube content partners.
       *
       * The onBehalfOfContentOwnerChannel parameter specifies the YouTube channel ID of the channel
       * to which a video is being added. This parameter is required when a request specifies a
       * value for the onBehalfOfContentOwner parameter, and it can only be used in conjunction with
       * that parameter. In addition, the request must be authorized using a CMS account that is
       * linked to the content owner that the onBehalfOfContentOwner parameter specifies. Finally,
       * the channel that the onBehalfOfContentOwnerChannel parameter value specifies must be linked
       * to the content owner that the onBehalfOfContentOwner parameter specifies.
       *
       * This parameter is intended for YouTube content partners that own and manage many different
       * YouTube channels. It allows content owners to authenticate once and perform actions on
       * behalf of the channel specified in the parameter value, without having to provide
       * authentication credentials for each separate channel.
       */
      @com.google.api.client.util.Key
      private java.lang.String onBehalfOfContentOwnerChannel;

      /** This parameter can only be used in a properly authorized request. Note: This parameter is intended
     exclusively for YouTube content partners.

     The onBehalfOfContentOwnerChannel parameter specifies the YouTube channel ID of the channel to
     which a video is being added. This parameter is required when a request specifies a value for the
     onBehalfOfContentOwner parameter, and it can only be used in conjunction with that parameter. In
     addition, the request must be authorized using a CMS account that is linked to the content owner
     that the onBehalfOfContentOwner parameter specifies. Finally, the channel that the
     onBehalfOfContentOwnerChannel parameter value specifies must be linked to the content owner that
     the onBehalfOfContentOwner parameter specifies.

     This parameter is intended for YouTube content partners that own and manage many different YouTube
     channels. It allows content owners to authenticate once and perform actions on behalf of the
     channel specified in the parameter value, without having to provide authentication credentials for
     each separate channel.
       */
      public java.lang.String getOnBehalfOfContentOwnerChannel() {
        return onBehalfOfContentOwnerChannel;
      }

      /**
       * This parameter can only be used in a properly authorized request. Note: This parameter is
       * intended exclusively for YouTube content partners.
       *
       * The onBehalfOfContentOwnerChannel parameter specifies the YouTube channel ID of the channel
       * to which a video is being added. This parameter is required when a request specifies a
       * value for the onBehalfOfContentOwner parameter, and it can only be used in conjunction with
       * that parameter. In addition, the request must be authorized using a CMS account that is
       * linked to the content owner that the onBehalfOfContentOwner parameter specifies. Finally,
       * the channel that the onBehalfOfContentOwnerChannel parameter value specifies must be linked
       * to the content owner that the onBehalfOfContentOwner parameter specifies.
       *
       * This parameter is intended for YouTube content partners that own and manage many different
       * YouTube channels. It allows content owners to authenticate once and perform actions on
       * behalf of the channel specified in the parameter value, without having to provide
       * authentication credentials for each separate channel.
       */
      public Update setOnBehalfOfContentOwnerChannel(java.lang.String onBehalfOfContentOwnerChannel) {
        this.onBehalfOfContentOwnerChannel = onBehalfOfContentOwnerChannel;
        return this;
      }

      @Override
      public Update set(String parameterName, Object value) {
        return (Update) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the Members collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code YouTube youtube = new YouTube(...);}
   *   {@code YouTube.Members.List request = youtube.members().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Members members() {
    return new Members();
  }

  /**
   * The "members" collection of methods.
   */
  public class Members {

    /**
     * Lists members for a channel.
     *
     * Create a request for the method "members.list".
     *
     * This request holds the parameters needed by the youtube server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param part The part parameter specifies the member resource parts that the API response will include. Set the
     *        parameter value to snippet.
     * @return the request
     */
    public List list(java.lang.String part) throws java.io.IOException {
      List result = new List(part);
      initialize(result);
      return result;
    }

    public class List extends YouTubeRequest<com.google.api.services.youtube.model.MemberListResponse> {

      private static final String REST_PATH = "members";

      /**
       * Lists members for a channel.
       *
       * Create a request for the method "members.list".
       *
       * This request holds the parameters needed by the the youtube server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param part The part parameter specifies the member resource parts that the API response will include. Set the
     *        parameter value to snippet.
       * @since 1.13
       */
      protected List(java.lang.String part) {
        super(YouTube.this, "GET", REST_PATH, null, com.google.api.services.youtube.model.MemberListResponse.class);
        this.part = com.google.api.client.util.Preconditions.checkNotNull(part, "Required parameter part must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUserIp(java.lang.String userIp) {
        return (List) super.setUserIp(userIp);
      }

      /**
       * The part parameter specifies the member resource parts that the API response will include.
       * Set the parameter value to snippet.
       */
      @com.google.api.client.util.Key
      private java.lang.String part;

      /** The part parameter specifies the member resource parts that the API response will include. Set the
     parameter value to snippet.
       */
      public java.lang.String getPart() {
        return part;
      }

      /**
       * The part parameter specifies the member resource parts that the API response will include.
       * Set the parameter value to snippet.
       */
      public List setPart(java.lang.String part) {
        this.part = part;
        return this;
      }

      /**
       * The filterByMemberChannelId parameter represents a comma separated list of channel IDs.
       * Only data about members that are part of this list will be included in the response. It can
       * be used to efficiently check whether specific users are entitled to perks offered via third
       * parties.
       */
      @com.google.api.client.util.Key
      private java.lang.String filterByMemberChannelId;

      /** The filterByMemberChannelId parameter represents a comma separated list of channel IDs. Only data
     about members that are part of this list will be included in the response. It can be used to
     efficiently check whether specific users are entitled to perks offered via third parties.
       */
      public java.lang.String getFilterByMemberChannelId() {
        return filterByMemberChannelId;
      }

      /**
       * The filterByMemberChannelId parameter represents a comma separated list of channel IDs.
       * Only data about members that are part of this list will be included in the response. It can
       * be used to efficiently check whether specific users are entitled to perks offered via third
       * parties.
       */
      public List setFilterByMemberChannelId(java.lang.String filterByMemberChannelId) {
        this.filterByMemberChannelId = filterByMemberChannelId;
        return this;
      }

      /**
       * The hasAccessToLevel parameter specifies, when set, the ID of a pricing level that members
       * from the results set should have access to. When not set, all members will be considered,
       * regardless of their active pricing level.
       */
      @com.google.api.client.util.Key
      private java.lang.String hasAccessToLevel;

      /** The hasAccessToLevel parameter specifies, when set, the ID of a pricing level that members from the
     results set should have access to. When not set, all members will be considered, regardless of
     their active pricing level.
       */
      public java.lang.String getHasAccessToLevel() {
        return hasAccessToLevel;
      }

      /**
       * The hasAccessToLevel parameter specifies, when set, the ID of a pricing level that members
       * from the results set should have access to. When not set, all members will be considered,
       * regardless of their active pricing level.
       */
      public List setHasAccessToLevel(java.lang.String hasAccessToLevel) {
        this.hasAccessToLevel = hasAccessToLevel;
        return this;
      }

      /**
       * The maxResults parameter specifies the maximum number of items that should be returned in
       * the result set.
       */
      @com.google.api.client.util.Key
      private java.lang.Long maxResults;

      /** The maxResults parameter specifies the maximum number of items that should be returned in the
     result set. [default: 5] [minimum: 0] [maximum: 50000]
       */
      public java.lang.Long getMaxResults() {
        return maxResults;
      }

      /**
       * The maxResults parameter specifies the maximum number of items that should be returned in
       * the result set.
       */
      public List setMaxResults(java.lang.Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      /** The mode parameter specifies which channel members to return. */
      @com.google.api.client.util.Key
      private java.lang.String mode;

      /** The mode parameter specifies which channel members to return. [default:
     LIST_MEMBERS_MODE_ALL_CURRENT]
       */
      public java.lang.String getMode() {
        return mode;
      }

      /** The mode parameter specifies which channel members to return. */
      public List setMode(java.lang.String mode) {
        this.mode = mode;
        return this;
      }

      /**
       * The pageToken parameter identifies a specific page in the result set that should be
       * returned. In an API response, the nextPageToken and prevPageToken properties identify other
       * pages that could be retrieved.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** The pageToken parameter identifies a specific page in the result set that should be returned. In an
     API response, the nextPageToken and prevPageToken properties identify other pages that could be
     retrieved.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * The pageToken parameter identifies a specific page in the result set that should be
       * returned. In an API response, the nextPageToken and prevPageToken properties identify other
       * pages that could be retrieved.
       */
      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the MembershipsLevels collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code YouTube youtube = new YouTube(...);}
   *   {@code YouTube.MembershipsLevels.List request = youtube.membershipsLevels().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public MembershipsLevels membershipsLevels() {
    return new MembershipsLevels();
  }

  /**
   * The "membershipsLevels" collection of methods.
   */
  public class MembershipsLevels {

    /**
     * Lists pricing levels for a channel.
     *
     * Create a request for the method "membershipsLevels.list".
     *
     * This request holds the parameters needed by the youtube server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param part The part parameter specifies the membershipsLevel resource parts that the API response will include.
     *        Supported values are id and snippet.
     * @return the request
     */
    public List list(java.lang.String part) throws java.io.IOException {
      List result = new List(part);
      initialize(result);
      return result;
    }

    public class List extends YouTubeRequest<com.google.api.services.youtube.model.MembershipsLevelListResponse> {

      private static final String REST_PATH = "membershipsLevels";

      /**
       * Lists pricing levels for a channel.
       *
       * Create a request for the method "membershipsLevels.list".
       *
       * This request holds the parameters needed by the the youtube server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param part The part parameter specifies the membershipsLevel resource parts that the API response will include.
     *        Supported values are id and snippet.
       * @since 1.13
       */
      protected List(java.lang.String part) {
        super(YouTube.this, "GET", REST_PATH, null, com.google.api.services.youtube.model.MembershipsLevelListResponse.class);
        this.part = com.google.api.client.util.Preconditions.checkNotNull(part, "Required parameter part must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUserIp(java.lang.String userIp) {
        return (List) super.setUserIp(userIp);
      }

      /**
       * The part parameter specifies the membershipsLevel resource parts that the API response will
       * include. Supported values are id and snippet.
       */
      @com.google.api.client.util.Key
      private java.lang.String part;

      /** The part parameter specifies the membershipsLevel resource parts that the API response will
     include. Supported values are id and snippet.
       */
      public java.lang.String getPart() {
        return part;
      }

      /**
       * The part parameter specifies the membershipsLevel resource parts that the API response will
       * include. Supported values are id and snippet.
       */
      public List setPart(java.lang.String part) {
        this.part = part;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the PlaylistItems collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code YouTube youtube = new YouTube(...);}
   *   {@code YouTube.PlaylistItems.List request = youtube.playlistItems().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public PlaylistItems playlistItems() {
    return new PlaylistItems();
  }

  /**
   * The "playlistItems" collection of methods.
   */
  public class PlaylistItems {

    /**
     * Deletes a playlist item.
     *
     * Create a request for the method "playlistItems.delete".
     *
     * This request holds the parameters needed by the youtube server.  After setting any optional
     * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
     *
     * @param id The id parameter specifies the YouTube playlist item ID for the playlist item that is being deleted.
     *        In a playlistItem resource, the id property specifies the playlist item's ID.
     * @return the request
     */
    public Delete delete(java.lang.String id) throws java.io.IOException {
      Delete result = new Delete(id);
      initialize(result);
      return result;
    }

    public class Delete extends YouTubeRequest<Void> {

      private static final String REST_PATH = "playlistItems";

      /**
       * Deletes a playlist item.
       *
       * Create a request for the method "playlistItems.delete".
       *
       * This request holds the parameters needed by the the youtube server.  After setting any optional
       * parameters, call the {@link Delete#execute()} method to invoke the remote operation. <p> {@link
       * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param id The id parameter specifies the YouTube playlist item ID for the playlist item that is being deleted.
     *        In a playlistItem resource, the id property specifies the playlist item's ID.
       * @since 1.13
       */
      protected Delete(java.lang.String id) {
        super(YouTube.this, "DELETE", REST_PATH, null, Void.class);
        this.id = com.google.api.client.util.Preconditions.checkNotNull(id, "Required parameter id must be specified.");
      }

      @Override
      public Delete setAlt(java.lang.String alt) {
        return (Delete) super.setAlt(alt);
      }

      @Override
      public Delete setFields(java.lang.String fields) {
        return (Delete) super.setFields(fields);
      }

      @Override
      public Delete setKey(java.lang.String key) {
        return (Delete) super.setKey(key);
      }

      @Override
      public Delete setOauthToken(java.lang.String oauthToken) {
        return (Delete) super.setOauthToken(oauthToken);
      }

      @Override
      public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Delete) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Delete setQuotaUser(java.lang.String quotaUser) {
        return (Delete) super.setQuotaUser(quotaUser);
      }

      @Override
      public Delete setUserIp(java.lang.String userIp) {
        return (Delete) super.setUserIp(userIp);
      }

      /**
       * The id parameter specifies the YouTube playlist item ID for the playlist item that is being
       * deleted. In a playlistItem resource, the id property specifies the playlist item's ID.
       */
      @com.google.api.client.util.Key
      private java.lang.String id;

      /** The id parameter specifies the YouTube playlist item ID for the playlist item that is being
     deleted. In a playlistItem resource, the id property specifies the playlist item's ID.
       */
      public java.lang.String getId() {
        return id;
      }

      /**
       * The id parameter specifies the YouTube playlist item ID for the playlist item that is being
       * deleted. In a playlistItem resource, the id property specifies the playlist item's ID.
       */
      public Delete setId(java.lang.String id) {
        this.id = id;
        return this;
      }

      /**
       * Note: This parameter is intended exclusively for YouTube content partners.
       *
       * The onBehalfOfContentOwner parameter indicates that the request's authorization credentials
       * identify a YouTube CMS user who is acting on behalf of the content owner specified in the
       * parameter value. This parameter is intended for YouTube content partners that own and
       * manage many different YouTube channels. It allows content owners to authenticate once and
       * get access to all their video and channel data, without having to provide authentication
       * credentials for each individual channel. The CMS account that the user authenticates with
       * must be linked to the specified YouTube content owner.
       */
      @com.google.api.client.util.Key
      private java.lang.String onBehalfOfContentOwner;

      /** Note: This parameter is intended exclusively for YouTube content partners.

     The onBehalfOfContentOwner parameter indicates that the request's authorization credentials
     identify a YouTube CMS user who is acting on behalf of the content owner specified in the parameter
     value. This parameter is intended for YouTube content partners that own and manage many different
     YouTube channels. It allows content owners to authenticate once and get access to all their video
     and channel data, without having to provide authentication credentials for each individual channel.
     The CMS account that the user authenticates with must be linked to the specified YouTube content
     owner.
       */
      public java.lang.String getOnBehalfOfContentOwner() {
        return onBehalfOfContentOwner;
      }

      /**
       * Note: This parameter is intended exclusively for YouTube content partners.
       *
       * The onBehalfOfContentOwner parameter indicates that the request's authorization credentials
       * identify a YouTube CMS user who is acting on behalf of the content owner specified in the
       * parameter value. This parameter is intended for YouTube content partners that own and
       * manage many different YouTube channels. It allows content owners to authenticate once and
       * get access to all their video and channel data, without having to provide authentication
       * credentials for each individual channel. The CMS account that the user authenticates with
       * must be linked to the specified YouTube content owner.
       */
      public Delete setOnBehalfOfContentOwner(java.lang.String onBehalfOfContentOwner) {
        this.onBehalfOfContentOwner = onBehalfOfContentOwner;
        return this;
      }

      @Override
      public Delete set(String parameterName, Object value) {
        return (Delete) super.set(parameterName, value);
      }
    }
    /**
     * Adds a resource to a playlist.
     *
     * Create a request for the method "playlistItems.insert".
     *
     * This request holds the parameters needed by the youtube server.  After setting any optional
     * parameters, call the {@link Insert#execute()} method to invoke the remote operation.
     *
     * @param part The part parameter serves two purposes in this operation. It identifies the properties that the
     *        write operation will set as well as the properties that the API response will include.
     * @param content the {@link com.google.api.services.youtube.model.PlaylistItem}
     * @return the request
     */
    public Insert insert(java.lang.String part, com.google.api.services.youtube.model.PlaylistItem content) throws java.io.IOException {
      Insert result = new Insert(part, content);
      initialize(result);
      return result;
    }

    public class Insert extends YouTubeRequest<com.google.api.services.youtube.model.PlaylistItem> {

      private static final String REST_PATH = "playlistItems";

      /**
       * Adds a resource to a playlist.
       *
       * Create a request for the method "playlistItems.insert".
       *
       * This request holds the parameters needed by the the youtube server.  After setting any optional
       * parameters, call the {@link Insert#execute()} method to invoke the remote operation. <p> {@link
       * Insert#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param part The part parameter serves two purposes in this operation. It identifies the properties that the
     *        write operation will set as well as the properties that the API response will include.
       * @param content the {@link com.google.api.services.youtube.model.PlaylistItem}
       * @since 1.13
       */
      protected Insert(java.lang.String part, com.google.api.services.youtube.model.PlaylistItem content) {
        super(YouTube.this, "POST", REST_PATH, content, com.google.api.services.youtube.model.PlaylistItem.class);
        this.part = com.google.api.client.util.Preconditions.checkNotNull(part, "Required parameter part must be specified.");
      }

      @Override
      public Insert setAlt(java.lang.String alt) {
        return (Insert) super.setAlt(alt);
      }

      @Override
      public Insert setFields(java.lang.String fields) {
        return (Insert) super.setFields(fields);
      }

      @Override
      public Insert setKey(java.lang.String key) {
        return (Insert) super.setKey(key);
      }

      @Override
      public Insert setOauthToken(java.lang.String oauthToken) {
        return (Insert) super.setOauthToken(oauthToken);
      }

      @Override
      public Insert setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Insert) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Insert setQuotaUser(java.lang.String quotaUser) {
        return (Insert) super.setQuotaUser(quotaUser);
      }

      @Override
      public Insert setUserIp(java.lang.String userIp) {
        return (Insert) super.setUserIp(userIp);
      }

      /**
       * The part parameter serves two purposes in this operation. It identifies the properties that
       * the write operation will set as well as the properties that the API response will include.
       */
      @com.google.api.client.util.Key
      private java.lang.String part;

      /** The part parameter serves two purposes in this operation. It identifies the properties that the
     write operation will set as well as the properties that the API response will include.
       */
      public java.lang.String getPart() {
        return part;
      }

      /**
       * The part parameter serves two purposes in this operation. It identifies the properties that
       * the write operation will set as well as the properties that the API response will include.
       */
      public Insert setPart(java.lang.String part) {
        this.part = part;
        return this;
      }

      /**
       * Note: This parameter is intended exclusively for YouTube content partners.
       *
       * The onBehalfOfContentOwner parameter indicates that the request's authorization credentials
       * identify a YouTube CMS user who is acting on behalf of the content owner specified in the
       * parameter value. This parameter is intended for YouTube content partners that own and
       * manage many different YouTube channels. It allows content owners to authenticate once and
       * get access to all their video and channel data, without having to provide authentication
       * credentials for each individual channel. The CMS account that the user authenticates with
       * must be linked to the specified YouTube content owner.
       */
      @com.google.api.client.util.Key
      private java.lang.String onBehalfOfContentOwner;

      /** Note: This parameter is intended exclusively for YouTube content partners.

     The onBehalfOfContentOwner parameter indicates that the request's authorization credentials
     identify a YouTube CMS user who is acting on behalf of the content owner specified in the parameter
     value. This parameter is intended for YouTube content partners that own and manage many different
     YouTube channels. It allows content owners to authenticate once and get access to all their video
     and channel data, without having to provide authentication credentials for each individual channel.
     The CMS account that the user authenticates with must be linked to the specified YouTube content
     owner.
       */
      public java.lang.String getOnBehalfOfContentOwner() {
        return onBehalfOfContentOwner;
      }

      /**
       * Note: This parameter is intended exclusively for YouTube content partners.
       *
       * The onBehalfOfContentOwner parameter indicates that the request's authorization credentials
       * identify a YouTube CMS user who is acting on behalf of the content owner specified in the
       * parameter value. This parameter is intended for YouTube content partners that own and
       * manage many different YouTube channels. It allows content owners to authenticate once and
       * get access to all their video and channel data, without having to provide authentication
       * credentials for each individual channel. The CMS account that the user authenticates with
       * must be linked to the specified YouTube content owner.
       */
      public Insert setOnBehalfOfContentOwner(java.lang.String onBehalfOfContentOwner) {
        this.onBehalfOfContentOwner = onBehalfOfContentOwner;
        return this;
      }

      @Override
      public Insert set(String parameterName, Object value) {
        return (Insert) super.set(parameterName, value);
      }
    }
    /**
     * Returns a collection of playlist items that match the API request parameters. You can retrieve
     * all of the playlist items in a specified playlist or retrieve one or more playlist items by their
     * unique IDs.
     *
     * Create a request for the method "playlistItems.list".
     *
     * This request holds the parameters needed by the youtube server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param part The part parameter specifies a comma-separated list of one or more playlistItem resource properties
     *        that the API response will include.
    If the parameter identifies a property that contains
     *        child properties, the child properties will be included in the response. For example, in a
     *        playlistItem resource, the snippet property contains numerous fields, including the title,
     *        description, position, and resourceId properties. As such, if you set part=snippet, the
     *        API response will contain all of those properties.
     * @return the request
     */
    public List list(java.lang.String part) throws java.io.IOException {
      List result = new List(part);
      initialize(result);
      return result;
    }

    public class List extends YouTubeRequest<com.google.api.services.youtube.model.PlaylistItemListResponse> {

      private static final String REST_PATH = "playlistItems";

      /**
       * Returns a collection of playlist items that match the API request parameters. You can retrieve
       * all of the playlist items in a specified playlist or retrieve one or more playlist items by
       * their unique IDs.
       *
       * Create a request for the method "playlistItems.list".
       *
       * This request holds the parameters needed by the the youtube server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param part The part parameter specifies a comma-separated list of one or more playlistItem resource properties
     *        that the API response will include.
    If the parameter identifies a property that contains
     *        child properties, the child properties will be included in the response. For example, in a
     *        playlistItem resource, the snippet property contains numerous fields, including the title,
     *        description, position, and resourceId properties. As such, if you set part=snippet, the
     *        API response will contain all of those properties.
       * @since 1.13
       */
      protected List(java.lang.String part) {
        super(YouTube.this, "GET", REST_PATH, null, com.google.api.services.youtube.model.PlaylistItemListResponse.class);
        this.part = com.google.api.client.util.Preconditions.checkNotNull(part, "Required parameter part must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUserIp(java.lang.String userIp) {
        return (List) super.setUserIp(userIp);
      }

      /**
       * The part parameter specifies a comma-separated list of one or more playlistItem resource
       * properties that the API response will include.
       *
       * If the parameter identifies a property that contains child properties, the child properties
       * will be included in the response. For example, in a playlistItem resource, the snippet
       * property contains numerous fields, including the title, description, position, and
       * resourceId properties. As such, if you set part=snippet, the API response will contain all
       * of those properties.
       */
      @com.google.api.client.util.Key
      private java.lang.String part;

      /** The part parameter specifies a comma-separated list of one or more playlistItem resource properties
     that the API response will include.

     If the parameter identifies a property that contains child properties, the child properties will be
     included in the response. For example, in a playlistItem resource, the snippet property contains
     numerous fields, including the title, description, position, and resourceId properties. As such, if
     you set part=snippet, the API response will contain all of those properties.
       */
      public java.lang.String getPart() {
        return part;
      }

      /**
       * The part parameter specifies a comma-separated list of one or more playlistItem resource
       * properties that the API response will include.
       *
       * If the parameter identifies a property that contains child properties, the child properties
       * will be included in the response. For example, in a playlistItem resource, the snippet
       * property contains numerous fields, including the title, description, position, and
       * resourceId properties. As such, if you set part=snippet, the API response will contain all
       * of those properties.
       */
      public List setPart(java.lang.String part) {
        this.part = part;
        return this;
      }

      /**
       * The id parameter specifies a comma-separated list of one or more unique playlist item IDs.
       */
      @com.google.api.client.util.Key
      private java.lang.String id;

      /** The id parameter specifies a comma-separated list of one or more unique playlist item IDs.
       */
      public java.lang.String getId() {
        return id;
      }

      /**
       * The id parameter specifies a comma-separated list of one or more unique playlist item IDs.
       */
      public List setId(java.lang.String id) {
        this.id = id;
        return this;
      }

      /**
       * The maxResults parameter specifies the maximum number of items that should be returned in
       * the result set.
       */
      @com.google.api.client.util.Key
      private java.lang.Long maxResults;

      /** The maxResults parameter specifies the maximum number of items that should be returned in the
     result set. [default: 5] [minimum: 0] [maximum: 50]
       */
      public java.lang.Long getMaxResults() {
        return maxResults;
      }

      /**
       * The maxResults parameter specifies the maximum number of items that should be returned in
       * the result set.
       */
      public List setMaxResults(java.lang.Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      /**
       * Note: This parameter is intended exclusively for YouTube content partners.
       *
       * The onBehalfOfContentOwner parameter indicates that the request's authorization credentials
       * identify a YouTube CMS user who is acting on behalf of the content owner specified in the
       * parameter value. This parameter is intended for YouTube content partners that own and
       * manage many different YouTube channels. It allows content owners to authenticate once and
       * get access to all their video and channel data, without having to provide authentication
       * credentials for each individual channel. The CMS account that the user authenticates with
       * must be linked to the specified YouTube content owner.
       */
      @com.google.api.client.util.Key
      private java.lang.String onBehalfOfContentOwner;

      /** Note: This parameter is intended exclusively for YouTube content partners.

     The onBehalfOfContentOwner parameter indicates that the request's authorization credentials
     identify a YouTube CMS user who is acting on behalf of the content owner specified in the parameter
     value. This parameter is intended for YouTube content partners that own and manage many different
     YouTube channels. It allows content owners to authenticate once and get access to all their video
     and channel data, without having to provide authentication credentials for each individual channel.
     The CMS account that the user authenticates with must be linked to the specified YouTube content
     owner.
       */
      public java.lang.String getOnBehalfOfContentOwner() {
        return onBehalfOfContentOwner;
      }

      /**
       * Note: This parameter is intended exclusively for YouTube content partners.
       *
       * The onBehalfOfContentOwner parameter indicates that the request's authorization credentials
       * identify a YouTube CMS user who is acting on behalf of the content owner specified in the
       * parameter value. This parameter is intended for YouTube content partners that own and
       * manage many different YouTube channels. It allows content owners to authenticate once and
       * get access to all their video and channel data, without having to provide authentication
       * credentials for each individual channel. The CMS account that the user authenticates with
       * must be linked to the specified YouTube content owner.
       */
      public List setOnBehalfOfContentOwner(java.lang.String onBehalfOfContentOwner) {
        this.onBehalfOfContentOwner = onBehalfOfContentOwner;
        return this;
      }

      /**
       * The pageToken parameter identifies a specific page in the result set that should be
       * returned. In an API response, the nextPageToken and prevPageToken properties identify other
       * pages that could be retrieved.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** The pageToken parameter identifies a specific page in the result set that should be returned. In an
     API response, the nextPageToken and prevPageToken properties identify other pages that could be
     retrieved.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * The pageToken parameter identifies a specific page in the result set that should be
       * returned. In an API response, the nextPageToken and prevPageToken properties identify other
       * pages that could be retrieved.
       */
      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      /**
       * The playlistId parameter specifies the unique ID of the playlist for which you want to
       * retrieve playlist items. Note that even though this is an optional parameter, every request
       * to retrieve playlist items must specify a value for either the id parameter or the
       * playlistId parameter.
       */
      @com.google.api.client.util.Key
      private java.lang.String playlistId;

      /** The playlistId parameter specifies the unique ID of the playlist for which you want to retrieve
     playlist items. Note that even though this is an optional parameter, every request to retrieve
     playlist items must specify a value for either the id parameter or the playlistId parameter.
       */
      public java.lang.String getPlaylistId() {
        return playlistId;
      }

      /**
       * The playlistId parameter specifies the unique ID of the playlist for which you want to
       * retrieve playlist items. Note that even though this is an optional parameter, every request
       * to retrieve playlist items must specify a value for either the id parameter or the
       * playlistId parameter.
       */
      public List setPlaylistId(java.lang.String playlistId) {
        this.playlistId = playlistId;
        return this;
      }

      /**
       * The videoId parameter specifies that the request should return only the playlist items that
       * contain the specified video.
       */
      @com.google.api.client.util.Key
      private java.lang.String videoId;

      /** The videoId parameter specifies that the request should return only the playlist items that contain
     the specified video.
       */
      public java.lang.String getVideoId() {
        return videoId;
      }

      /**
       * The videoId parameter specifies that the request should return only the playlist items that
       * contain the specified video.
       */
      public List setVideoId(java.lang.String videoId) {
        this.videoId = videoId;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }
    /**
     * Modifies a playlist item. For example, you could update the item's position in the playlist.
     *
     * Create a request for the method "playlistItems.update".
     *
     * This request holds the parameters needed by the youtube server.  After setting any optional
     * parameters, call the {@link Update#execute()} method to invoke the remote operation.
     *
     * @param part The part parameter serves two purposes in this operation. It identifies the properties that the
     *        write operation will set as well as the properties that the API response will include.
     *        Note that this method will override the existing values for all of the mutable properties
     *        that are contained in any parts that the parameter value specifies. For example, a
     *        playlist item can specify a start time and end time, which identify the times portion of
     *        the video that should play when users watch the video in the playlist. If your request is
     *        updating a playlist item that sets these values, and the request's part parameter value
     *        includes the contentDetails part, the playlist item's start and end times will be updated
     *        to whatever value the request body specifies. If the request body does not specify values,
     *        the existing start and end times will be removed and replaced with the default settings.
     * @param content the {@link com.google.api.services.youtube.model.PlaylistItem}
     * @return the request
     */
    public Update update(java.lang.String part, com.google.api.services.youtube.model.PlaylistItem content) throws java.io.IOException {
      Update result = new Update(part, content);
      initialize(result);
      return result;
    }

    public class Update extends YouTubeRequest<com.google.api.services.youtube.model.PlaylistItem> {

      private static final String REST_PATH = "playlistItems";

      /**
       * Modifies a playlist item. For example, you could update the item's position in the playlist.
       *
       * Create a request for the method "playlistItems.update".
       *
       * This request holds the parameters needed by the the youtube server.  After setting any optional
       * parameters, call the {@link Update#execute()} method to invoke the remote operation. <p> {@link
       * Update#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param part The part parameter serves two purposes in this operation. It identifies the properties that the
     *        write operation will set as well as the properties that the API response will include.
     *        Note that this method will override the existing values for all of the mutable properties
     *        that are contained in any parts that the parameter value specifies. For example, a
     *        playlist item can specify a start time and end time, which identify the times portion of
     *        the video that should play when users watch the video in the playlist. If your request is
     *        updating a playlist item that sets these values, and the request's part parameter value
     *        includes the contentDetails part, the playlist item's start and end times will be updated
     *        to whatever value the request body specifies. If the request body does not specify values,
     *        the existing start and end times will be removed and replaced with the default settings.
       * @param content the {@link com.google.api.services.youtube.model.PlaylistItem}
       * @since 1.13
       */
      protected Update(java.lang.String part, com.google.api.services.youtube.model.PlaylistItem content) {
        super(YouTube.this, "PUT", REST_PATH, content, com.google.api.services.youtube.model.PlaylistItem.class);
        this.part = com.google.api.client.util.Preconditions.checkNotNull(part, "Required parameter part must be specified.");
      }

      @Override
      public Update setAlt(java.lang.String alt) {
        return (Update) super.setAlt(alt);
      }

      @Override
      public Update setFields(java.lang.String fields) {
        return (Update) super.setFields(fields);
      }

      @Override
      public Update setKey(java.lang.String key) {
        return (Update) super.setKey(key);
      }

      @Override
      public Update setOauthToken(java.lang.String oauthToken) {
        return (Update) super.setOauthToken(oauthToken);
      }

      @Override
      public Update setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Update) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Update setQuotaUser(java.lang.String quotaUser) {
        return (Update) super.setQuotaUser(quotaUser);
      }

      @Override
      public Update setUserIp(java.lang.String userIp) {
        return (Update) super.setUserIp(userIp);
      }

      /**
       * The part parameter serves two purposes in this operation. It identifies the properties that
       * the write operation will set as well as the properties that the API response will include.
       *
       * Note that this method will override the existing values for all of the mutable properties
       * that are contained in any parts that the parameter value specifies. For example, a playlist
       * item can specify a start time and end time, which identify the times portion of the video
       * that should play when users watch the video in the playlist. If your request is updating a
       * playlist item that sets these values, and the request's part parameter value includes the
       * contentDetails part, the playlist item's start and end times will be updated to whatever
       * value the request body specifies. If the request body does not specify values, the existing
       * start and end times will be removed and replaced with the default settings.
       */
      @com.google.api.client.util.Key
      private java.lang.String part;

      /** The part parameter serves two purposes in this operation. It identifies the properties that the
     write operation will set as well as the properties that the API response will include.

     Note that this method will override the existing values for all of the mutable properties that are
     contained in any parts that the parameter value specifies. For example, a playlist item can specify
     a start time and end time, which identify the times portion of the video that should play when
     users watch the video in the playlist. If your request is updating a playlist item that sets these
     values, and the request's part parameter value includes the contentDetails part, the playlist
     item's start and end times will be updated to whatever value the request body specifies. If the
     request body does not specify values, the existing start and end times will be removed and replaced
     with the default settings.
       */
      public java.lang.String getPart() {
        return part;
      }

      /**
       * The part parameter serves two purposes in this operation. It identifies the properties that
       * the write operation will set as well as the properties that the API response will include.
       *
       * Note that this method will override the existing values for all of the mutable properties
       * that are contained in any parts that the parameter value specifies. For example, a playlist
       * item can specify a start time and end time, which identify the times portion of the video
       * that should play when users watch the video in the playlist. If your request is updating a
       * playlist item that sets these values, and the request's part parameter value includes the
       * contentDetails part, the playlist item's start and end times will be updated to whatever
       * value the request body specifies. If the request body does not specify values, the existing
       * start and end times will be removed and replaced with the default settings.
       */
      public Update setPart(java.lang.String part) {
        this.part = part;
        return this;
      }

      /**
       * Note: This parameter is intended exclusively for YouTube content partners.
       *
       * The onBehalfOfContentOwner parameter indicates that the request's authorization credentials
       * identify a YouTube CMS user who is acting on behalf of the content owner specified in the
       * parameter value. This parameter is intended for YouTube content partners that own and
       * manage many different YouTube channels. It allows content owners to authenticate once and
       * get access to all their video and channel data, without having to provide authentication
       * credentials for each individual channel. The CMS account that the user authenticates with
       * must be linked to the specified YouTube content owner.
       */
      @com.google.api.client.util.Key
      private java.lang.String onBehalfOfContentOwner;

      /** Note: This parameter is intended exclusively for YouTube content partners.

     The onBehalfOfContentOwner parameter indicates that the request's authorization credentials
     identify a YouTube CMS user who is acting on behalf of the content owner specified in the parameter
     value. This parameter is intended for YouTube content partners that own and manage many different
     YouTube channels. It allows content owners to authenticate once and get access to all their video
     and channel data, without having to provide authentication credentials for each individual channel.
     The CMS account that the user authenticates with must be linked to the specified YouTube content
     owner.
       */
      public java.lang.String getOnBehalfOfContentOwner() {
        return onBehalfOfContentOwner;
      }

      /**
       * Note: This parameter is intended exclusively for YouTube content partners.
       *
       * The onBehalfOfContentOwner parameter indicates that the request's authorization credentials
       * identify a YouTube CMS user who is acting on behalf of the content owner specified in the
       * parameter value. This parameter is intended for YouTube content partners that own and
       * manage many different YouTube channels. It allows content owners to authenticate once and
       * get access to all their video and channel data, without having to provide authentication
       * credentials for each individual channel. The CMS account that the user authenticates with
       * must be linked to the specified YouTube content owner.
       */
      public Update setOnBehalfOfContentOwner(java.lang.String onBehalfOfContentOwner) {
        this.onBehalfOfContentOwner = onBehalfOfContentOwner;
        return this;
      }

      @Override
      public Update set(String parameterName, Object value) {
        return (Update) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the Playlists collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code YouTube youtube = new YouTube(...);}
   *   {@code YouTube.Playlists.List request = youtube.playlists().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Playlists playlists() {
    return new Playlists();
  }

  /**
   * The "playlists" collection of methods.
   */
  public class Playlists {

    /**
     * Deletes a playlist.
     *
     * Create a request for the method "playlists.delete".
     *
     * This request holds the parameters needed by the youtube server.  After setting any optional
     * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
     *
     * @param id The id parameter specifies the YouTube playlist ID for the playlist that is being deleted. In a
     *        playlist resource, the id property specifies the playlist's ID.
     * @return the request
     */
    public Delete delete(java.lang.String id) throws java.io.IOException {
      Delete result = new Delete(id);
      initialize(result);
      return result;
    }

    public class Delete extends YouTubeRequest<Void> {

      private static final String REST_PATH = "playlists";

      /**
       * Deletes a playlist.
       *
       * Create a request for the method "playlists.delete".
       *
       * This request holds the parameters needed by the the youtube server.  After setting any optional
       * parameters, call the {@link Delete#execute()} method to invoke the remote operation. <p> {@link
       * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param id The id parameter specifies the YouTube playlist ID for the playlist that is being deleted. In a
     *        playlist resource, the id property specifies the playlist's ID.
       * @since 1.13
       */
      protected Delete(java.lang.String id) {
        super(YouTube.this, "DELETE", REST_PATH, null, Void.class);
        this.id = com.google.api.client.util.Preconditions.checkNotNull(id, "Required parameter id must be specified.");
      }

      @Override
      public Delete setAlt(java.lang.String alt) {
        return (Delete) super.setAlt(alt);
      }

      @Override
      public Delete setFields(java.lang.String fields) {
        return (Delete) super.setFields(fields);
      }

      @Override
      public Delete setKey(java.lang.String key) {
        return (Delete) super.setKey(key);
      }

      @Override
      public Delete setOauthToken(java.lang.String oauthToken) {
        return (Delete) super.setOauthToken(oauthToken);
      }

      @Override
      public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Delete) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Delete setQuotaUser(java.lang.String quotaUser) {
        return (Delete) super.setQuotaUser(quotaUser);
      }

      @Override
      public Delete setUserIp(java.lang.String userIp) {
        return (Delete) super.setUserIp(userIp);
      }

      /**
       * The id parameter specifies the YouTube playlist ID for the playlist that is being deleted.
       * In a playlist resource, the id property specifies the playlist's ID.
       */
      @com.google.api.client.util.Key
      private java.lang.String id;

      /** The id parameter specifies the YouTube playlist ID for the playlist that is being deleted. In a
     playlist resource, the id property specifies the playlist's ID.
       */
      public java.lang.String getId() {
        return id;
      }

      /**
       * The id parameter specifies the YouTube playlist ID for the playlist that is being deleted.
       * In a playlist resource, the id property specifies the playlist's ID.
       */
      public Delete setId(java.lang.String id) {
        this.id = id;
        return this;
      }

      /**
       * Note: This parameter is intended exclusively for YouTube content partners.
       *
       * The onBehalfOfContentOwner parameter indicates that the request's authorization credentials
       * identify a YouTube CMS user who is acting on behalf of the content owner specified in the
       * parameter value. This parameter is intended for YouTube content partners that own and
       * manage many different YouTube channels. It allows content owners to authenticate once and
       * get access to all their video and channel data, without having to provide authentication
       * credentials for each individual channel. The CMS account that the user authenticates with
       * must be linked to the specified YouTube content owner.
       */
      @com.google.api.client.util.Key
      private java.lang.String onBehalfOfContentOwner;

      /** Note: This parameter is intended exclusively for YouTube content partners.

     The onBehalfOfContentOwner parameter indicates that the request's authorization credentials
     identify a YouTube CMS user who is acting on behalf of the content owner specified in the parameter
     value. This parameter is intended for YouTube content partners that own and manage many different
     YouTube channels. It allows content owners to authenticate once and get access to all their video
     and channel data, without having to provide authentication credentials for each individual channel.
     The CMS account that the user authenticates with must be linked to the specified YouTube content
     owner.
       */
      public java.lang.String getOnBehalfOfContentOwner() {
        return onBehalfOfContentOwner;
      }

      /**
       * Note: This parameter is intended exclusively for YouTube content partners.
       *
       * The onBehalfOfContentOwner parameter indicates that the request's authorization credentials
       * identify a YouTube CMS user who is acting on behalf of the content owner specified in the
       * parameter value. This parameter is intended for YouTube content partners that own and
       * manage many different YouTube channels. It allows content owners to authenticate once and
       * get access to all their video and channel data, without having to provide authentication
       * credentials for each individual channel. The CMS account that the user authenticates with
       * must be linked to the specified YouTube content owner.
       */
      public Delete setOnBehalfOfContentOwner(java.lang.String onBehalfOfContentOwner) {
        this.onBehalfOfContentOwner = onBehalfOfContentOwner;
        return this;
      }

      @Override
      public Delete set(String parameterName, Object value) {
        return (Delete) super.set(parameterName, value);
      }
    }
    /**
     * Creates a playlist.
     *
     * Create a request for the method "playlists.insert".
     *
     * This request holds the parameters needed by the youtube server.  After setting any optional
     * parameters, call the {@link Insert#execute()} method to invoke the remote operation.
     *
     * @param part The part parameter serves two purposes in this operation. It identifies the properties that the
     *        write operation will set as well as the properties that the API response will include.
     * @param content the {@link com.google.api.services.youtube.model.Playlist}
     * @return the request
     */
    public Insert insert(java.lang.String part, com.google.api.services.youtube.model.Playlist content) throws java.io.IOException {
      Insert result = new Insert(part, content);
      initialize(result);
      return result;
    }

    public class Insert extends YouTubeRequest<com.google.api.services.youtube.model.Playlist> {

      private static final String REST_PATH = "playlists";

      /**
       * Creates a playlist.
       *
       * Create a request for the method "playlists.insert".
       *
       * This request holds the parameters needed by the the youtube server.  After setting any optional
       * parameters, call the {@link Insert#execute()} method to invoke the remote operation. <p> {@link
       * Insert#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param part The part parameter serves two purposes in this operation. It identifies the properties that the
     *        write operation will set as well as the properties that the API response will include.
       * @param content the {@link com.google.api.services.youtube.model.Playlist}
       * @since 1.13
       */
      protected Insert(java.lang.String part, com.google.api.services.youtube.model.Playlist content) {
        super(YouTube.this, "POST", REST_PATH, content, com.google.api.services.youtube.model.Playlist.class);
        this.part = com.google.api.client.util.Preconditions.checkNotNull(part, "Required parameter part must be specified.");
      }

      @Override
      public Insert setAlt(java.lang.String alt) {
        return (Insert) super.setAlt(alt);
      }

      @Override
      public Insert setFields(java.lang.String fields) {
        return (Insert) super.setFields(fields);
      }

      @Override
      public Insert setKey(java.lang.String key) {
        return (Insert) super.setKey(key);
      }

      @Override
      public Insert setOauthToken(java.lang.String oauthToken) {
        return (Insert) super.setOauthToken(oauthToken);
      }

      @Override
      public Insert setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Insert) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Insert setQuotaUser(java.lang.String quotaUser) {
        return (Insert) super.setQuotaUser(quotaUser);
      }

      @Override
      public Insert setUserIp(java.lang.String userIp) {
        return (Insert) super.setUserIp(userIp);
      }

      /**
       * The part parameter serves two purposes in this operation. It identifies the properties that
       * the write operation will set as well as the properties that the API response will include.
       */
      @com.google.api.client.util.Key
      private java.lang.String part;

      /** The part parameter serves two purposes in this operation. It identifies the properties that the
     write operation will set as well as the properties that the API response will include.
       */
      public java.lang.String getPart() {
        return part;
      }

      /**
       * The part parameter serves two purposes in this operation. It identifies the properties that
       * the write operation will set as well as the properties that the API response will include.
       */
      public Insert setPart(java.lang.String part) {
        this.part = part;
        return this;
      }

      /**
       * Note: This parameter is intended exclusively for YouTube content partners.
       *
       * The onBehalfOfContentOwner parameter indicates that the request's authorization credentials
       * identify a YouTube CMS user who is acting on behalf of the content owner specified in the
       * parameter value. This parameter is intended for YouTube content partners that own and
       * manage many different YouTube channels. It allows content owners to authenticate once and
       * get access to all their video and channel data, without having to provide authentication
       * credentials for each individual channel. The CMS account that the user authenticates with
       * must be linked to the specified YouTube content owner.
       */
      @com.google.api.client.util.Key
      private java.lang.String onBehalfOfContentOwner;

      /** Note: This parameter is intended exclusively for YouTube content partners.

     The onBehalfOfContentOwner parameter indicates that the request's authorization credentials
     identify a YouTube CMS user who is acting on behalf of the content owner specified in the parameter
     value. This parameter is intended for YouTube content partners that own and manage many different
     YouTube channels. It allows content owners to authenticate once and get access to all their video
     and channel data, without having to provide authentication credentials for each individual channel.
     The CMS account that the user authenticates with must be linked to the specified YouTube content
     owner.
       */
      public java.lang.String getOnBehalfOfContentOwner() {
        return onBehalfOfContentOwner;
      }

      /**
       * Note: This parameter is intended exclusively for YouTube content partners.
       *
       * The onBehalfOfContentOwner parameter indicates that the request's authorization credentials
       * identify a YouTube CMS user who is acting on behalf of the content owner specified in the
       * parameter value. This parameter is intended for YouTube content partners that own and
       * manage many different YouTube channels. It allows content owners to authenticate once and
       * get access to all their video and channel data, without having to provide authentication
       * credentials for each individual channel. The CMS account that the user authenticates with
       * must be linked to the specified YouTube content owner.
       */
      public Insert setOnBehalfOfContentOwner(java.lang.String onBehalfOfContentOwner) {
        this.onBehalfOfContentOwner = onBehalfOfContentOwner;
        return this;
      }

      /**
       * This parameter can only be used in a properly authorized request. Note: This parameter is
       * intended exclusively for YouTube content partners.
       *
       * The onBehalfOfContentOwnerChannel parameter specifies the YouTube channel ID of the channel
       * to which a video is being added. This parameter is required when a request specifies a
       * value for the onBehalfOfContentOwner parameter, and it can only be used in conjunction with
       * that parameter. In addition, the request must be authorized using a CMS account that is
       * linked to the content owner that the onBehalfOfContentOwner parameter specifies. Finally,
       * the channel that the onBehalfOfContentOwnerChannel parameter value specifies must be linked
       * to the content owner that the onBehalfOfContentOwner parameter specifies.
       *
       * This parameter is intended for YouTube content partners that own and manage many different
       * YouTube channels. It allows content owners to authenticate once and perform actions on
       * behalf of the channel specified in the parameter value, without having to provide
       * authentication credentials for each separate channel.
       */
      @com.google.api.client.util.Key
      private java.lang.String onBehalfOfContentOwnerChannel;

      /** This parameter can only be used in a properly authorized request. Note: This parameter is intended
     exclusively for YouTube content partners.

     The onBehalfOfContentOwnerChannel parameter specifies the YouTube channel ID of the channel to
     which a video is being added. This parameter is required when a request specifies a value for the
     onBehalfOfContentOwner parameter, and it can only be used in conjunction with that parameter. In
     addition, the request must be authorized using a CMS account that is linked to the content owner
     that the onBehalfOfContentOwner parameter specifies. Finally, the channel that the
     onBehalfOfContentOwnerChannel parameter value specifies must be linked to the content owner that
     the onBehalfOfContentOwner parameter specifies.

     This parameter is intended for YouTube content partners that own and manage many different YouTube
     channels. It allows content owners to authenticate once and perform actions on behalf of the
     channel specified in the parameter value, without having to provide authentication credentials for
     each separate channel.
       */
      public java.lang.String getOnBehalfOfContentOwnerChannel() {
        return onBehalfOfContentOwnerChannel;
      }

      /**
       * This parameter can only be used in a properly authorized request. Note: This parameter is
       * intended exclusively for YouTube content partners.
       *
       * The onBehalfOfContentOwnerChannel parameter specifies the YouTube channel ID of the channel
       * to which a video is being added. This parameter is required when a request specifies a
       * value for the onBehalfOfContentOwner parameter, and it can only be used in conjunction with
       * that parameter. In addition, the request must be authorized using a CMS account that is
       * linked to the content owner that the onBehalfOfContentOwner parameter specifies. Finally,
       * the channel that the onBehalfOfContentOwnerChannel parameter value specifies must be linked
       * to the content owner that the onBehalfOfContentOwner parameter specifies.
       *
       * This parameter is intended for YouTube content partners that own and manage many different
       * YouTube channels. It allows content owners to authenticate once and perform actions on
       * behalf of the channel specified in the parameter value, without having to provide
       * authentication credentials for each separate channel.
       */
      public Insert setOnBehalfOfContentOwnerChannel(java.lang.String onBehalfOfContentOwnerChannel) {
        this.onBehalfOfContentOwnerChannel = onBehalfOfContentOwnerChannel;
        return this;
      }

      @Override
      public Insert set(String parameterName, Object value) {
        return (Insert) super.set(parameterName, value);
      }
    }
    /**
     * Returns a collection of playlists that match the API request parameters. For example, you can
     * retrieve all playlists that the authenticated user owns, or you can retrieve one or more
     * playlists by their unique IDs.
     *
     * Create a request for the method "playlists.list".
     *
     * This request holds the parameters needed by the youtube server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param part The part parameter specifies a comma-separated list of one or more playlist resource properties that
     *        the API response will include.
    If the parameter identifies a property that contains child
     *        properties, the child properties will be included in the response. For example, in a
     *        playlist resource, the snippet property contains properties like author, title,
     *        description, tags, and timeCreated. As such, if you set part=snippet, the API response
     *        will contain all of those properties.
     * @return the request
     */
    public List list(java.lang.String part) throws java.io.IOException {
      List result = new List(part);
      initialize(result);
      return result;
    }

    public class List extends YouTubeRequest<com.google.api.services.youtube.model.PlaylistListResponse> {

      private static final String REST_PATH = "playlists";

      /**
       * Returns a collection of playlists that match the API request parameters. For example, you can
       * retrieve all playlists that the authenticated user owns, or you can retrieve one or more
       * playlists by their unique IDs.
       *
       * Create a request for the method "playlists.list".
       *
       * This request holds the parameters needed by the the youtube server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param part The part parameter specifies a comma-separated list of one or more playlist resource properties that
     *        the API response will include.
    If the parameter identifies a property that contains child
     *        properties, the child properties will be included in the response. For example, in a
     *        playlist resource, the snippet property contains properties like author, title,
     *        description, tags, and timeCreated. As such, if you set part=snippet, the API response
     *        will contain all of those properties.
       * @since 1.13
       */
      protected List(java.lang.String part) {
        super(YouTube.this, "GET", REST_PATH, null, com.google.api.services.youtube.model.PlaylistListResponse.class);
        this.part = com.google.api.client.util.Preconditions.checkNotNull(part, "Required parameter part must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUserIp(java.lang.String userIp) {
        return (List) super.setUserIp(userIp);
      }

      /**
       * The part parameter specifies a comma-separated list of one or more playlist resource
       * properties that the API response will include.
       *
       * If the parameter identifies a property that contains child properties, the child properties
       * will be included in the response. For example, in a playlist resource, the snippet property
       * contains properties like author, title, description, tags, and timeCreated. As such, if you
       * set part=snippet, the API response will contain all of those properties.
       */
      @com.google.api.client.util.Key
      private java.lang.String part;

      /** The part parameter specifies a comma-separated list of one or more playlist resource properties
     that the API response will include.

     If the parameter identifies a property that contains child properties, the child properties will be
     included in the response. For example, in a playlist resource, the snippet property contains
     properties like author, title, description, tags, and timeCreated. As such, if you set
     part=snippet, the API response will contain all of those properties.
       */
      public java.lang.String getPart() {
        return part;
      }

      /**
       * The part parameter specifies a comma-separated list of one or more playlist resource
       * properties that the API response will include.
       *
       * If the parameter identifies a property that contains child properties, the child properties
       * will be included in the response. For example, in a playlist resource, the snippet property
       * contains properties like author, title, description, tags, and timeCreated. As such, if you
       * set part=snippet, the API response will contain all of those properties.
       */
      public List setPart(java.lang.String part) {
        this.part = part;
        return this;
      }

      /**
       * This value indicates that the API should only return the specified channel's playlists.
       */
      @com.google.api.client.util.Key
      private java.lang.String channelId;

      /** This value indicates that the API should only return the specified channel's playlists.
       */
      public java.lang.String getChannelId() {
        return channelId;
      }

      /**
       * This value indicates that the API should only return the specified channel's playlists.
       */
      public List setChannelId(java.lang.String channelId) {
        this.channelId = channelId;
        return this;
      }

      /**
       * The hl parameter should be used for filter out the properties that are not in the given
       * language. Used for the snippet part.
       */
      @com.google.api.client.util.Key
      private java.lang.String hl;

      /** The hl parameter should be used for filter out the properties that are not in the given language.
     Used for the snippet part.
       */
      public java.lang.String getHl() {
        return hl;
      }

      /**
       * The hl parameter should be used for filter out the properties that are not in the given
       * language. Used for the snippet part.
       */
      public List setHl(java.lang.String hl) {
        this.hl = hl;
        return this;
      }

      /**
       * The id parameter specifies a comma-separated list of the YouTube playlist ID(s) for the
       * resource(s) that are being retrieved. In a playlist resource, the id property specifies the
       * playlist's YouTube playlist ID.
       */
      @com.google.api.client.util.Key
      private java.lang.String id;

      /** The id parameter specifies a comma-separated list of the YouTube playlist ID(s) for the resource(s)
     that are being retrieved. In a playlist resource, the id property specifies the playlist's YouTube
     playlist ID.
       */
      public java.lang.String getId() {
        return id;
      }

      /**
       * The id parameter specifies a comma-separated list of the YouTube playlist ID(s) for the
       * resource(s) that are being retrieved. In a playlist resource, the id property specifies the
       * playlist's YouTube playlist ID.
       */
      public List setId(java.lang.String id) {
        this.id = id;
        return this;
      }

      /**
       * The maxResults parameter specifies the maximum number of items that should be returned in
       * the result set.
       */
      @com.google.api.client.util.Key
      private java.lang.Long maxResults;

      /** The maxResults parameter specifies the maximum number of items that should be returned in the
     result set. [default: 5] [minimum: 0] [maximum: 50]
       */
      public java.lang.Long getMaxResults() {
        return maxResults;
      }

      /**
       * The maxResults parameter specifies the maximum number of items that should be returned in
       * the result set.
       */
      public List setMaxResults(java.lang.Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      /**
       * Set this parameter's value to true to instruct the API to only return playlists owned by
       * the authenticated user.
       */
      @com.google.api.client.util.Key
      private java.lang.Boolean mine;

      /** Set this parameter's value to true to instruct the API to only return playlists owned by the
     authenticated user.
       */
      public java.lang.Boolean getMine() {
        return mine;
      }

      /**
       * Set this parameter's value to true to instruct the API to only return playlists owned by
       * the authenticated user.
       */
      public List setMine(java.lang.Boolean mine) {
        this.mine = mine;
        return this;
      }

      /**
       * Note: This parameter is intended exclusively for YouTube content partners.
       *
       * The onBehalfOfContentOwner parameter indicates that the request's authorization credentials
       * identify a YouTube CMS user who is acting on behalf of the content owner specified in the
       * parameter value. This parameter is intended for YouTube content partners that own and
       * manage many different YouTube channels. It allows content owners to authenticate once and
       * get access to all their video and channel data, without having to provide authentication
       * credentials for each individual channel. The CMS account that the user authenticates with
       * must be linked to the specified YouTube content owner.
       */
      @com.google.api.client.util.Key
      private java.lang.String onBehalfOfContentOwner;

      /** Note: This parameter is intended exclusively for YouTube content partners.

     The onBehalfOfContentOwner parameter indicates that the request's authorization credentials
     identify a YouTube CMS user who is acting on behalf of the content owner specified in the parameter
     value. This parameter is intended for YouTube content partners that own and manage many different
     YouTube channels. It allows content owners to authenticate once and get access to all their video
     and channel data, without having to provide authentication credentials for each individual channel.
     The CMS account that the user authenticates with must be linked to the specified YouTube content
     owner.
       */
      public java.lang.String getOnBehalfOfContentOwner() {
        return onBehalfOfContentOwner;
      }

      /**
       * Note: This parameter is intended exclusively for YouTube content partners.
       *
       * The onBehalfOfContentOwner parameter indicates that the request's authorization credentials
       * identify a YouTube CMS user who is acting on behalf of the content owner specified in the
       * parameter value. This parameter is intended for YouTube content partners that own and
       * manage many different YouTube channels. It allows content owners to authenticate once and
       * get access to all their video and channel data, without having to provide authentication
       * credentials for each individual channel. The CMS account that the user authenticates with
       * must be linked to the specified YouTube content owner.
       */
      public List setOnBehalfOfContentOwner(java.lang.String onBehalfOfContentOwner) {
        this.onBehalfOfContentOwner = onBehalfOfContentOwner;
        return this;
      }

      /**
       * This parameter can only be used in a properly authorized request. Note: This parameter is
       * intended exclusively for YouTube content partners.
       *
       * The onBehalfOfContentOwnerChannel parameter specifies the YouTube channel ID of the channel
       * to which a video is being added. This parameter is required when a request specifies a
       * value for the onBehalfOfContentOwner parameter, and it can only be used in conjunction with
       * that parameter. In addition, the request must be authorized using a CMS account that is
       * linked to the content owner that the onBehalfOfContentOwner parameter specifies. Finally,
       * the channel that the onBehalfOfContentOwnerChannel parameter value specifies must be linked
       * to the content owner that the onBehalfOfContentOwner parameter specifies.
       *
       * This parameter is intended for YouTube content partners that own and manage many different
       * YouTube channels. It allows content owners to authenticate once and perform actions on
       * behalf of the channel specified in the parameter value, without having to provide
       * authentication credentials for each separate channel.
       */
      @com.google.api.client.util.Key
      private java.lang.String onBehalfOfContentOwnerChannel;

      /** This parameter can only be used in a properly authorized request. Note: This parameter is intended
     exclusively for YouTube content partners.

     The onBehalfOfContentOwnerChannel parameter specifies the YouTube channel ID of the channel to
     which a video is being added. This parameter is required when a request specifies a value for the
     onBehalfOfContentOwner parameter, and it can only be used in conjunction with that parameter. In
     addition, the request must be authorized using a CMS account that is linked to the content owner
     that the onBehalfOfContentOwner parameter specifies. Finally, the channel that the
     onBehalfOfContentOwnerChannel parameter value specifies must be linked to the content owner that
     the onBehalfOfContentOwner parameter specifies.

     This parameter is intended for YouTube content partners that own and manage many different YouTube
     channels. It allows content owners to authenticate once and perform actions on behalf of the
     channel specified in the parameter value, without having to provide authentication credentials for
     each separate channel.
       */
      public java.lang.String getOnBehalfOfContentOwnerChannel() {
        return onBehalfOfContentOwnerChannel;
      }

      /**
       * This parameter can only be used in a properly authorized request. Note: This parameter is
       * intended exclusively for YouTube content partners.
       *
       * The onBehalfOfContentOwnerChannel parameter specifies the YouTube channel ID of the channel
       * to which a video is being added. This parameter is required when a request specifies a
       * value for the onBehalfOfContentOwner parameter, and it can only be used in conjunction with
       * that parameter. In addition, the request must be authorized using a CMS account that is
       * linked to the content owner that the onBehalfOfContentOwner parameter specifies. Finally,
       * the channel that the onBehalfOfContentOwnerChannel parameter value specifies must be linked
       * to the content owner that the onBehalfOfContentOwner parameter specifies.
       *
       * This parameter is intended for YouTube content partners that own and manage many different
       * YouTube channels. It allows content owners to authenticate once and perform actions on
       * behalf of the channel specified in the parameter value, without having to provide
       * authentication credentials for each separate channel.
       */
      public List setOnBehalfOfContentOwnerChannel(java.lang.String onBehalfOfContentOwnerChannel) {
        this.onBehalfOfContentOwnerChannel = onBehalfOfContentOwnerChannel;
        return this;
      }

      /**
       * The pageToken parameter identifies a specific page in the result set that should be
       * returned. In an API response, the nextPageToken and prevPageToken properties identify other
       * pages that could be retrieved.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** The pageToken parameter identifies a specific page in the result set that should be returned. In an
     API response, the nextPageToken and prevPageToken properties identify other pages that could be
     retrieved.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * The pageToken parameter identifies a specific page in the result set that should be
       * returned. In an API response, the nextPageToken and prevPageToken properties identify other
       * pages that could be retrieved.
       */
      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }
    /**
     * Modifies a playlist. For example, you could change a playlist's title, description, or privacy
     * status.
     *
     * Create a request for the method "playlists.update".
     *
     * This request holds the parameters needed by the youtube server.  After setting any optional
     * parameters, call the {@link Update#execute()} method to invoke the remote operation.
     *
     * @param part The part parameter serves two purposes in this operation. It identifies the properties that the
     *        write operation will set as well as the properties that the API response will include.
     *        Note that this method will override the existing values for mutable properties that are
     *        contained in any parts that the request body specifies. For example, a playlist's
     *        description is contained in the snippet part, which must be included in the request body.
     *        If the request does not specify a value for the snippet.description property, the
     *        playlist's existing description will be deleted.
     * @param content the {@link com.google.api.services.youtube.model.Playlist}
     * @return the request
     */
    public Update update(java.lang.String part, com.google.api.services.youtube.model.Playlist content) throws java.io.IOException {
      Update result = new Update(part, content);
      initialize(result);
      return result;
    }

    public class Update extends YouTubeRequest<com.google.api.services.youtube.model.Playlist> {

      private static final String REST_PATH = "playlists";

      /**
       * Modifies a playlist. For example, you could change a playlist's title, description, or privacy
       * status.
       *
       * Create a request for the method "playlists.update".
       *
       * This request holds the parameters needed by the the youtube server.  After setting any optional
       * parameters, call the {@link Update#execute()} method to invoke the remote operation. <p> {@link
       * Update#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param part The part parameter serves two purposes in this operation. It identifies the properties that the
     *        write operation will set as well as the properties that the API response will include.
     *        Note that this method will override the existing values for mutable properties that are
     *        contained in any parts that the request body specifies. For example, a playlist's
     *        description is contained in the snippet part, which must be included in the request body.
     *        If the request does not specify a value for the snippet.description property, the
     *        playlist's existing description will be deleted.
       * @param content the {@link com.google.api.services.youtube.model.Playlist}
       * @since 1.13
       */
      protected Update(java.lang.String part, com.google.api.services.youtube.model.Playlist content) {
        super(YouTube.this, "PUT", REST_PATH, content, com.google.api.services.youtube.model.Playlist.class);
        this.part = com.google.api.client.util.Preconditions.checkNotNull(part, "Required parameter part must be specified.");
      }

      @Override
      public Update setAlt(java.lang.String alt) {
        return (Update) super.setAlt(alt);
      }

      @Override
      public Update setFields(java.lang.String fields) {
        return (Update) super.setFields(fields);
      }

      @Override
      public Update setKey(java.lang.String key) {
        return (Update) super.setKey(key);
      }

      @Override
      public Update setOauthToken(java.lang.String oauthToken) {
        return (Update) super.setOauthToken(oauthToken);
      }

      @Override
      public Update setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Update) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Update setQuotaUser(java.lang.String quotaUser) {
        return (Update) super.setQuotaUser(quotaUser);
      }

      @Override
      public Update setUserIp(java.lang.String userIp) {
        return (Update) super.setUserIp(userIp);
      }

      /**
       * The part parameter serves two purposes in this operation. It identifies the properties that
       * the write operation will set as well as the properties that the API response will include.
       *
       * Note that this method will override the existing values for mutable properties that are
       * contained in any parts that the request body specifies. For example, a playlist's
       * description is contained in the snippet part, which must be included in the request body.
       * If the request does not specify a value for the snippet.description property, the
       * playlist's existing description will be deleted.
       */
      @com.google.api.client.util.Key
      private java.lang.String part;

      /** The part parameter serves two purposes in this operation. It identifies the properties that the
     write operation will set as well as the properties that the API response will include.

     Note that this method will override the existing values for mutable properties that are contained
     in any parts that the request body specifies. For example, a playlist's description is contained in
     the snippet part, which must be included in the request body. If the request does not specify a
     value for the snippet.description property, the playlist's existing description will be deleted.
       */
      public java.lang.String getPart() {
        return part;
      }

      /**
       * The part parameter serves two purposes in this operation. It identifies the properties that
       * the write operation will set as well as the properties that the API response will include.
       *
       * Note that this method will override the existing values for mutable properties that are
       * contained in any parts that the request body specifies. For example, a playlist's
       * description is contained in the snippet part, which must be included in the request body.
       * If the request does not specify a value for the snippet.description property, the
       * playlist's existing description will be deleted.
       */
      public Update setPart(java.lang.String part) {
        this.part = part;
        return this;
      }

      /**
       * Note: This parameter is intended exclusively for YouTube content partners.
       *
       * The onBehalfOfContentOwner parameter indicates that the request's authorization credentials
       * identify a YouTube CMS user who is acting on behalf of the content owner specified in the
       * parameter value. This parameter is intended for YouTube content partners that own and
       * manage many different YouTube channels. It allows content owners to authenticate once and
       * get access to all their video and channel data, without having to provide authentication
       * credentials for each individual channel. The CMS account that the user authenticates with
       * must be linked to the specified YouTube content owner.
       */
      @com.google.api.client.util.Key
      private java.lang.String onBehalfOfContentOwner;

      /** Note: This parameter is intended exclusively for YouTube content partners.

     The onBehalfOfContentOwner parameter indicates that the request's authorization credentials
     identify a YouTube CMS user who is acting on behalf of the content owner specified in the parameter
     value. This parameter is intended for YouTube content partners that own and manage many different
     YouTube channels. It allows content owners to authenticate once and get access to all their video
     and channel data, without having to provide authentication credentials for each individual channel.
     The CMS account that the user authenticates with must be linked to the specified YouTube content
     owner.
       */
      public java.lang.String getOnBehalfOfContentOwner() {
        return onBehalfOfContentOwner;
      }

      /**
       * Note: This parameter is intended exclusively for YouTube content partners.
       *
       * The onBehalfOfContentOwner parameter indicates that the request's authorization credentials
       * identify a YouTube CMS user who is acting on behalf of the content owner specified in the
       * parameter value. This parameter is intended for YouTube content partners that own and
       * manage many different YouTube channels. It allows content owners to authenticate once and
       * get access to all their video and channel data, without having to provide authentication
       * credentials for each individual channel. The CMS account that the user authenticates with
       * must be linked to the specified YouTube content owner.
       */
      public Update setOnBehalfOfContentOwner(java.lang.String onBehalfOfContentOwner) {
        this.onBehalfOfContentOwner = onBehalfOfContentOwner;
        return this;
      }

      @Override
      public Update set(String parameterName, Object value) {
        return (Update) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the Search collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code YouTube youtube = new YouTube(...);}
   *   {@code YouTube.Search.List request = youtube.search().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Search search() {
    return new Search();
  }

  /**
   * The "search" collection of methods.
   */
  public class Search {

    /**
     * Returns a collection of search results that match the query parameters specified in the API
     * request. By default, a search result set identifies matching video, channel, and playlist
     * resources, but you can also configure queries to only retrieve a specific type of resource.
     *
     * Create a request for the method "search.list".
     *
     * This request holds the parameters needed by the youtube server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param part The part parameter specifies a comma-separated list of one or more search resource properties that
     *        the API response will include. Set the parameter value to snippet.
     * @return the request
     */
    public List list(java.lang.String part) throws java.io.IOException {
      List result = new List(part);
      initialize(result);
      return result;
    }

    public class List extends YouTubeRequest<com.google.api.services.youtube.model.SearchListResponse> {

      private static final String REST_PATH = "search";

      /**
       * Returns a collection of search results that match the query parameters specified in the API
       * request. By default, a search result set identifies matching video, channel, and playlist
       * resources, but you can also configure queries to only retrieve a specific type of resource.
       *
       * Create a request for the method "search.list".
       *
       * This request holds the parameters needed by the the youtube server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param part The part parameter specifies a comma-separated list of one or more search resource properties that
     *        the API response will include. Set the parameter value to snippet.
       * @since 1.13
       */
      protected List(java.lang.String part) {
        super(YouTube.this, "GET", REST_PATH, null, com.google.api.services.youtube.model.SearchListResponse.class);
        this.part = com.google.api.client.util.Preconditions.checkNotNull(part, "Required parameter part must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUserIp(java.lang.String userIp) {
        return (List) super.setUserIp(userIp);
      }

      /**
       * The part parameter specifies a comma-separated list of one or more search resource
       * properties that the API response will include. Set the parameter value to snippet.
       */
      @com.google.api.client.util.Key
      private java.lang.String part;

      /** The part parameter specifies a comma-separated list of one or more search resource properties that
     the API response will include. Set the parameter value to snippet.
       */
      public java.lang.String getPart() {
        return part;
      }

      /**
       * The part parameter specifies a comma-separated list of one or more search resource
       * properties that the API response will include. Set the parameter value to snippet.
       */
      public List setPart(java.lang.String part) {
        this.part = part;
        return this;
      }

      /**
       * The channelId parameter indicates that the API response should only contain resources
       * created by the channel
       */
      @com.google.api.client.util.Key
      private java.lang.String channelId;

      /** The channelId parameter indicates that the API response should only contain resources created by
     the channel
       */
      public java.lang.String getChannelId() {
        return channelId;
      }

      /**
       * The channelId parameter indicates that the API response should only contain resources
       * created by the channel
       */
      public List setChannelId(java.lang.String channelId) {
        this.channelId = channelId;
        return this;
      }

      /** The channelType parameter lets you restrict a search to a particular type of channel. */
      @com.google.api.client.util.Key
      private java.lang.String channelType;

      /** The channelType parameter lets you restrict a search to a particular type of channel.
       */
      public java.lang.String getChannelType() {
        return channelType;
      }

      /** The channelType parameter lets you restrict a search to a particular type of channel. */
      public List setChannelType(java.lang.String channelType) {
        this.channelType = channelType;
        return this;
      }

      /**
       * The eventType parameter restricts a search to broadcast events. If you specify a value for
       * this parameter, you must also set the type parameter's value to video.
       */
      @com.google.api.client.util.Key
      private java.lang.String eventType;

      /** The eventType parameter restricts a search to broadcast events. If you specify a value for this
     parameter, you must also set the type parameter's value to video.
       */
      public java.lang.String getEventType() {
        return eventType;
      }

      /**
       * The eventType parameter restricts a search to broadcast events. If you specify a value for
       * this parameter, you must also set the type parameter's value to video.
       */
      public List setEventType(java.lang.String eventType) {
        this.eventType = eventType;
        return this;
      }

      /**
       * Note: This parameter is intended exclusively for YouTube content partners.
       *
       * The forContentOwner parameter restricts the search to only retrieve resources owned by the
       * content owner specified by the onBehalfOfContentOwner parameter. The user must be
       * authenticated using a CMS account linked to the specified content owner and
       * onBehalfOfContentOwner must be provided.
       */
      @com.google.api.client.util.Key
      private java.lang.Boolean forContentOwner;

      /** Note: This parameter is intended exclusively for YouTube content partners.

     The forContentOwner parameter restricts the search to only retrieve resources owned by the content
     owner specified by the onBehalfOfContentOwner parameter. The user must be authenticated using a CMS
     account linked to the specified content owner and onBehalfOfContentOwner must be provided.
       */
      public java.lang.Boolean getForContentOwner() {
        return forContentOwner;
      }

      /**
       * Note: This parameter is intended exclusively for YouTube content partners.
       *
       * The forContentOwner parameter restricts the search to only retrieve resources owned by the
       * content owner specified by the onBehalfOfContentOwner parameter. The user must be
       * authenticated using a CMS account linked to the specified content owner and
       * onBehalfOfContentOwner must be provided.
       */
      public List setForContentOwner(java.lang.Boolean forContentOwner) {
        this.forContentOwner = forContentOwner;
        return this;
      }

      /**
       * The forDeveloper parameter restricts the search to only retrieve videos uploaded via the
       * developer's application or website. The API server uses the request's authorization
       * credentials to identify the developer. Therefore, a developer can restrict results to
       * videos uploaded through the developer's own app or website but not to videos uploaded
       * through other apps or sites.
       */
      @com.google.api.client.util.Key
      private java.lang.Boolean forDeveloper;

      /** The forDeveloper parameter restricts the search to only retrieve videos uploaded via the
     developer's application or website. The API server uses the request's authorization credentials to
     identify the developer. Therefore, a developer can restrict results to videos uploaded through the
     developer's own app or website but not to videos uploaded through other apps or sites.
       */
      public java.lang.Boolean getForDeveloper() {
        return forDeveloper;
      }

      /**
       * The forDeveloper parameter restricts the search to only retrieve videos uploaded via the
       * developer's application or website. The API server uses the request's authorization
       * credentials to identify the developer. Therefore, a developer can restrict results to
       * videos uploaded through the developer's own app or website but not to videos uploaded
       * through other apps or sites.
       */
      public List setForDeveloper(java.lang.Boolean forDeveloper) {
        this.forDeveloper = forDeveloper;
        return this;
      }

      /**
       * The forMine parameter restricts the search to only retrieve videos owned by the
       * authenticated user. If you set this parameter to true, then the type parameter's value must
       * also be set to video.
       */
      @com.google.api.client.util.Key
      private java.lang.Boolean forMine;

      /** The forMine parameter restricts the search to only retrieve videos owned by the authenticated user.
     If you set this parameter to true, then the type parameter's value must also be set to video.
       */
      public java.lang.Boolean getForMine() {
        return forMine;
      }

      /**
       * The forMine parameter restricts the search to only retrieve videos owned by the
       * authenticated user. If you set this parameter to true, then the type parameter's value must
       * also be set to video.
       */
      public List setForMine(java.lang.Boolean forMine) {
        this.forMine = forMine;
        return this;
      }

      /**
       * The location parameter, in conjunction with the locationRadius parameter, defines a
       * circular geographic area and also restricts a search to videos that specify, in their
       * metadata, a geographic location that falls within that area. The parameter value is a
       * string that specifies latitude/longitude coordinates e.g. (37.42307,-122.08427).
       *
       * - The location parameter value identifies the point at the center of the area. - The
       * locationRadius parameter specifies the maximum distance that the location associated with a
       * video can be from that point for the video to still be included in the search results.The
       * API returns an error if your request specifies a value for the location parameter but does
       * not also specify a value for the locationRadius parameter.
       */
      @com.google.api.client.util.Key
      private java.lang.String location;

      /** The location parameter, in conjunction with the locationRadius parameter, defines a circular
     geographic area and also restricts a search to videos that specify, in their metadata, a geographic
     location that falls within that area. The parameter value is a string that specifies
     latitude/longitude coordinates e.g. (37.42307,-122.08427).

     - The location parameter value identifies the point at the center of the area. - The locationRadius
     parameter specifies the maximum distance that the location associated with a video can be from that
     point for the video to still be included in the search results.The API returns an error if your
     request specifies a value for the location parameter but does not also specify a value for the
     locationRadius parameter.
       */
      public java.lang.String getLocation() {
        return location;
      }

      /**
       * The location parameter, in conjunction with the locationRadius parameter, defines a
       * circular geographic area and also restricts a search to videos that specify, in their
       * metadata, a geographic location that falls within that area. The parameter value is a
       * string that specifies latitude/longitude coordinates e.g. (37.42307,-122.08427).
       *
       * - The location parameter value identifies the point at the center of the area. - The
       * locationRadius parameter specifies the maximum distance that the location associated with a
       * video can be from that point for the video to still be included in the search results.The
       * API returns an error if your request specifies a value for the location parameter but does
       * not also specify a value for the locationRadius parameter.
       */
      public List setLocation(java.lang.String location) {
        this.location = location;
        return this;
      }

      /**
       * The locationRadius parameter, in conjunction with the location parameter, defines a
       * circular geographic area.
       *
       * The parameter value must be a floating point number followed by a measurement unit. Valid
       * measurement units are m, km, ft, and mi. For example, valid parameter values include 1500m,
       * 5km, 10000ft, and 0.75mi. The API does not support locationRadius parameter values larger
       * than 1000 kilometers.
       *
       * Note: See the definition of the location parameter for more information.
       */
      @com.google.api.client.util.Key
      private java.lang.String locationRadius;

      /** The locationRadius parameter, in conjunction with the location parameter, defines a circular
     geographic area.

     The parameter value must be a floating point number followed by a measurement unit. Valid
     measurement units are m, km, ft, and mi. For example, valid parameter values include 1500m, 5km,
     10000ft, and 0.75mi. The API does not support locationRadius parameter values larger than 1000
     kilometers.

     Note: See the definition of the location parameter for more information.
       */
      public java.lang.String getLocationRadius() {
        return locationRadius;
      }

      /**
       * The locationRadius parameter, in conjunction with the location parameter, defines a
       * circular geographic area.
       *
       * The parameter value must be a floating point number followed by a measurement unit. Valid
       * measurement units are m, km, ft, and mi. For example, valid parameter values include 1500m,
       * 5km, 10000ft, and 0.75mi. The API does not support locationRadius parameter values larger
       * than 1000 kilometers.
       *
       * Note: See the definition of the location parameter for more information.
       */
      public List setLocationRadius(java.lang.String locationRadius) {
        this.locationRadius = locationRadius;
        return this;
      }

      /**
       * The maxResults parameter specifies the maximum number of items that should be returned in
       * the result set.
       */
      @com.google.api.client.util.Key
      private java.lang.Long maxResults;

      /** The maxResults parameter specifies the maximum number of items that should be returned in the
     result set. [default: 5] [minimum: 0] [maximum: 50]
       */
      public java.lang.Long getMaxResults() {
        return maxResults;
      }

      /**
       * The maxResults parameter specifies the maximum number of items that should be returned in
       * the result set.
       */
      public List setMaxResults(java.lang.Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      /**
       * Note: This parameter is intended exclusively for YouTube content partners.
       *
       * The onBehalfOfContentOwner parameter indicates that the request's authorization credentials
       * identify a YouTube CMS user who is acting on behalf of the content owner specified in the
       * parameter value. This parameter is intended for YouTube content partners that own and
       * manage many different YouTube channels. It allows content owners to authenticate once and
       * get access to all their video and channel data, without having to provide authentication
       * credentials for each individual channel. The CMS account that the user authenticates with
       * must be linked to the specified YouTube content owner.
       */
      @com.google.api.client.util.Key
      private java.lang.String onBehalfOfContentOwner;

      /** Note: This parameter is intended exclusively for YouTube content partners.

     The onBehalfOfContentOwner parameter indicates that the request's authorization credentials
     identify a YouTube CMS user who is acting on behalf of the content owner specified in the parameter
     value. This parameter is intended for YouTube content partners that own and manage many different
     YouTube channels. It allows content owners to authenticate once and get access to all their video
     and channel data, without having to provide authentication credentials for each individual channel.
     The CMS account that the user authenticates with must be linked to the specified YouTube content
     owner.
       */
      public java.lang.String getOnBehalfOfContentOwner() {
        return onBehalfOfContentOwner;
      }

      /**
       * Note: This parameter is intended exclusively for YouTube content partners.
       *
       * The onBehalfOfContentOwner parameter indicates that the request's authorization credentials
       * identify a YouTube CMS user who is acting on behalf of the content owner specified in the
       * parameter value. This parameter is intended for YouTube content partners that own and
       * manage many different YouTube channels. It allows content owners to authenticate once and
       * get access to all their video and channel data, without having to provide authentication
       * credentials for each individual channel. The CMS account that the user authenticates with
       * must be linked to the specified YouTube content owner.
       */
      public List setOnBehalfOfContentOwner(java.lang.String onBehalfOfContentOwner) {
        this.onBehalfOfContentOwner = onBehalfOfContentOwner;
        return this;
      }

      /**
       * The order parameter specifies the method that will be used to order resources in the API
       * response.
       */
      @com.google.api.client.util.Key
      private java.lang.String order;

      /** The order parameter specifies the method that will be used to order resources in the API response.
     [default: SEARCH_SORT_RELEVANCE]
       */
      public java.lang.String getOrder() {
        return order;
      }

      /**
       * The order parameter specifies the method that will be used to order resources in the API
       * response.
       */
      public List setOrder(java.lang.String order) {
        this.order = order;
        return this;
      }

      /**
       * The pageToken parameter identifies a specific page in the result set that should be
       * returned. In an API response, the nextPageToken and prevPageToken properties identify other
       * pages that could be retrieved.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** The pageToken parameter identifies a specific page in the result set that should be returned. In an
     API response, the nextPageToken and prevPageToken properties identify other pages that could be
     retrieved.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * The pageToken parameter identifies a specific page in the result set that should be
       * returned. In an API response, the nextPageToken and prevPageToken properties identify other
       * pages that could be retrieved.
       */
      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      /**
       * The publishedAfter parameter indicates that the API response should only contain resources
       * created after the specified time. The value is an RFC 3339 formatted date-time value
       * (1970-01-01T00:00:00Z).
       */
      @com.google.api.client.util.Key
      private com.google.api.client.util.DateTime publishedAfter;

      /** The publishedAfter parameter indicates that the API response should only contain resources created
     after the specified time. The value is an RFC 3339 formatted date-time value
     (1970-01-01T00:00:00Z).
       */
      public com.google.api.client.util.DateTime getPublishedAfter() {
        return publishedAfter;
      }

      /**
       * The publishedAfter parameter indicates that the API response should only contain resources
       * created after the specified time. The value is an RFC 3339 formatted date-time value
       * (1970-01-01T00:00:00Z).
       */
      public List setPublishedAfter(com.google.api.client.util.DateTime publishedAfter) {
        this.publishedAfter = publishedAfter;
        return this;
      }

      /**
       * The publishedBefore parameter indicates that the API response should only contain resources
       * created before the specified time. The value is an RFC 3339 formatted date-time value
       * (1970-01-01T00:00:00Z).
       */
      @com.google.api.client.util.Key
      private com.google.api.client.util.DateTime publishedBefore;

      /** The publishedBefore parameter indicates that the API response should only contain resources created
     before the specified time. The value is an RFC 3339 formatted date-time value
     (1970-01-01T00:00:00Z).
       */
      public com.google.api.client.util.DateTime getPublishedBefore() {
        return publishedBefore;
      }

      /**
       * The publishedBefore parameter indicates that the API response should only contain resources
       * created before the specified time. The value is an RFC 3339 formatted date-time value
       * (1970-01-01T00:00:00Z).
       */
      public List setPublishedBefore(com.google.api.client.util.DateTime publishedBefore) {
        this.publishedBefore = publishedBefore;
        return this;
      }

      /**
       * The q parameter specifies the query term to search for.
       *
       * Your request can also use the Boolean NOT (-) and OR (|) operators to exclude videos or to
       * find videos that are associated with one of several search terms. For example, to search
       * for videos matching either "boating" or "sailing", set the q parameter value to
       * boating|sailing. Similarly, to search for videos matching either "boating" or "sailing" but
       * not "fishing", set the q parameter value to boating|sailing -fishing. Note that the pipe
       * character must be URL-escaped when it is sent in your API request. The URL-escaped value
       * for the pipe character is %7C.
       */
      @com.google.api.client.util.Key
      private java.lang.String q;

      /** The q parameter specifies the query term to search for.

     Your request can also use the Boolean NOT (-) and OR (|) operators to exclude videos or to find
     videos that are associated with one of several search terms. For example, to search for videos
     matching either "boating" or "sailing", set the q parameter value to boating|sailing. Similarly, to
     search for videos matching either "boating" or "sailing" but not "fishing", set the q parameter
     value to boating|sailing -fishing. Note that the pipe character must be URL-escaped when it is sent
     in your API request. The URL-escaped value for the pipe character is %7C.
       */
      public java.lang.String getQ() {
        return q;
      }

      /**
       * The q parameter specifies the query term to search for.
       *
       * Your request can also use the Boolean NOT (-) and OR (|) operators to exclude videos or to
       * find videos that are associated with one of several search terms. For example, to search
       * for videos matching either "boating" or "sailing", set the q parameter value to
       * boating|sailing. Similarly, to search for videos matching either "boating" or "sailing" but
       * not "fishing", set the q parameter value to boating|sailing -fishing. Note that the pipe
       * character must be URL-escaped when it is sent in your API request. The URL-escaped value
       * for the pipe character is %7C.
       */
      public List setQ(java.lang.String q) {
        this.q = q;
        return this;
      }

      /**
       * The regionCode parameter instructs the API to return search results for the specified
       * country. The parameter value is an ISO 3166-1 alpha-2 country code.
       */
      @com.google.api.client.util.Key
      private java.lang.String regionCode;

      /** The regionCode parameter instructs the API to return search results for the specified country. The
     parameter value is an ISO 3166-1 alpha-2 country code.
       */
      public java.lang.String getRegionCode() {
        return regionCode;
      }

      /**
       * The regionCode parameter instructs the API to return search results for the specified
       * country. The parameter value is an ISO 3166-1 alpha-2 country code.
       */
      public List setRegionCode(java.lang.String regionCode) {
        this.regionCode = regionCode;
        return this;
      }

      /**
       * The relatedToVideoId parameter retrieves a list of videos that are related to the video
       * that the parameter value identifies. The parameter value must be set to a YouTube video ID
       * and, if you are using this parameter, the type parameter must be set to video.
       */
      @com.google.api.client.util.Key
      private java.lang.String relatedToVideoId;

      /** The relatedToVideoId parameter retrieves a list of videos that are related to the video that the
     parameter value identifies. The parameter value must be set to a YouTube video ID and, if you are
     using this parameter, the type parameter must be set to video.
       */
      public java.lang.String getRelatedToVideoId() {
        return relatedToVideoId;
      }

      /**
       * The relatedToVideoId parameter retrieves a list of videos that are related to the video
       * that the parameter value identifies. The parameter value must be set to a YouTube video ID
       * and, if you are using this parameter, the type parameter must be set to video.
       */
      public List setRelatedToVideoId(java.lang.String relatedToVideoId) {
        this.relatedToVideoId = relatedToVideoId;
        return this;
      }

      /**
       * The relevanceLanguage parameter instructs the API to return search results that are most
       * relevant to the specified language. The parameter value is typically an ISO 639-1 two-
       * letter language code. However, you should use the values zh-Hans for simplified Chinese and
       * zh-Hant for traditional Chinese. Please note that results in other languages will still be
       * returned if they are highly relevant to the search query term.
       */
      @com.google.api.client.util.Key
      private java.lang.String relevanceLanguage;

      /** The relevanceLanguage parameter instructs the API to return search results that are most relevant
     to the specified language. The parameter value is typically an ISO 639-1 two-letter language code.
     However, you should use the values zh-Hans for simplified Chinese and zh-Hant for traditional
     Chinese. Please note that results in other languages will still be returned if they are highly
     relevant to the search query term.
       */
      public java.lang.String getRelevanceLanguage() {
        return relevanceLanguage;
      }

      /**
       * The relevanceLanguage parameter instructs the API to return search results that are most
       * relevant to the specified language. The parameter value is typically an ISO 639-1 two-
       * letter language code. However, you should use the values zh-Hans for simplified Chinese and
       * zh-Hant for traditional Chinese. Please note that results in other languages will still be
       * returned if they are highly relevant to the search query term.
       */
      public List setRelevanceLanguage(java.lang.String relevanceLanguage) {
        this.relevanceLanguage = relevanceLanguage;
        return this;
      }

      /**
       * The safeSearch parameter indicates whether the search results should include restricted
       * content as well as standard content.
       */
      @com.google.api.client.util.Key
      private java.lang.String safeSearch;

      /** The safeSearch parameter indicates whether the search results should include restricted content as
     well as standard content.
       */
      public java.lang.String getSafeSearch() {
        return safeSearch;
      }

      /**
       * The safeSearch parameter indicates whether the search results should include restricted
       * content as well as standard content.
       */
      public List setSafeSearch(java.lang.String safeSearch) {
        this.safeSearch = safeSearch;
        return this;
      }

      /**
       * The topicId parameter indicates that the API response should only contain resources
       * associated with the specified topic. The value identifies a Freebase topic ID.
       */
      @com.google.api.client.util.Key
      private java.lang.String topicId;

      /** The topicId parameter indicates that the API response should only contain resources associated with
     the specified topic. The value identifies a Freebase topic ID.
       */
      public java.lang.String getTopicId() {
        return topicId;
      }

      /**
       * The topicId parameter indicates that the API response should only contain resources
       * associated with the specified topic. The value identifies a Freebase topic ID.
       */
      public List setTopicId(java.lang.String topicId) {
        this.topicId = topicId;
        return this;
      }

      /**
       * The type parameter restricts a search query to only retrieve a particular type of resource.
       * The value is a comma-separated list of resource types.
       */
      @com.google.api.client.util.Key
      private java.lang.String type;

      /** The type parameter restricts a search query to only retrieve a particular type of resource. The
     value is a comma-separated list of resource types. [default: video,channel,playlist]
       */
      public java.lang.String getType() {
        return type;
      }

      /**
       * The type parameter restricts a search query to only retrieve a particular type of resource.
       * The value is a comma-separated list of resource types.
       */
      public List setType(java.lang.String type) {
        this.type = type;
        return this;
      }

      /**
       * The videoCaption parameter indicates whether the API should filter video search results
       * based on whether they have captions. If you specify a value for this parameter, you must
       * also set the type parameter's value to video.
       */
      @com.google.api.client.util.Key
      private java.lang.String videoCaption;

      /** The videoCaption parameter indicates whether the API should filter video search results based on
     whether they have captions. If you specify a value for this parameter, you must also set the type
     parameter's value to video.
       */
      public java.lang.String getVideoCaption() {
        return videoCaption;
      }

      /**
       * The videoCaption parameter indicates whether the API should filter video search results
       * based on whether they have captions. If you specify a value for this parameter, you must
       * also set the type parameter's value to video.
       */
      public List setVideoCaption(java.lang.String videoCaption) {
        this.videoCaption = videoCaption;
        return this;
      }

      /**
       * The videoCategoryId parameter filters video search results based on their category. If you
       * specify a value for this parameter, you must also set the type parameter's value to video.
       */
      @com.google.api.client.util.Key
      private java.lang.String videoCategoryId;

      /** The videoCategoryId parameter filters video search results based on their category. If you specify
     a value for this parameter, you must also set the type parameter's value to video.
       */
      public java.lang.String getVideoCategoryId() {
        return videoCategoryId;
      }

      /**
       * The videoCategoryId parameter filters video search results based on their category. If you
       * specify a value for this parameter, you must also set the type parameter's value to video.
       */
      public List setVideoCategoryId(java.lang.String videoCategoryId) {
        this.videoCategoryId = videoCategoryId;
        return this;
      }

      /**
       * The videoDefinition parameter lets you restrict a search to only include either high
       * definition (HD) or standard definition (SD) videos. HD videos are available for playback in
       * at least 720p, though higher resolutions, like 1080p, might also be available. If you
       * specify a value for this parameter, you must also set the type parameter's value to video.
       */
      @com.google.api.client.util.Key
      private java.lang.String videoDefinition;

      /** The videoDefinition parameter lets you restrict a search to only include either high definition
     (HD) or standard definition (SD) videos. HD videos are available for playback in at least 720p,
     though higher resolutions, like 1080p, might also be available. If you specify a value for this
     parameter, you must also set the type parameter's value to video.
       */
      public java.lang.String getVideoDefinition() {
        return videoDefinition;
      }

      /**
       * The videoDefinition parameter lets you restrict a search to only include either high
       * definition (HD) or standard definition (SD) videos. HD videos are available for playback in
       * at least 720p, though higher resolutions, like 1080p, might also be available. If you
       * specify a value for this parameter, you must also set the type parameter's value to video.
       */
      public List setVideoDefinition(java.lang.String videoDefinition) {
        this.videoDefinition = videoDefinition;
        return this;
      }

      /**
       * The videoDimension parameter lets you restrict a search to only retrieve 2D or 3D videos.
       * If you specify a value for this parameter, you must also set the type parameter's value to
       * video.
       */
      @com.google.api.client.util.Key
      private java.lang.String videoDimension;

      /** The videoDimension parameter lets you restrict a search to only retrieve 2D or 3D videos. If you
     specify a value for this parameter, you must also set the type parameter's value to video.
       */
      public java.lang.String getVideoDimension() {
        return videoDimension;
      }

      /**
       * The videoDimension parameter lets you restrict a search to only retrieve 2D or 3D videos.
       * If you specify a value for this parameter, you must also set the type parameter's value to
       * video.
       */
      public List setVideoDimension(java.lang.String videoDimension) {
        this.videoDimension = videoDimension;
        return this;
      }

      /**
       * The videoDuration parameter filters video search results based on their duration. If you
       * specify a value for this parameter, you must also set the type parameter's value to video.
       */
      @com.google.api.client.util.Key
      private java.lang.String videoDuration;

      /** The videoDuration parameter filters video search results based on their duration. If you specify a
     value for this parameter, you must also set the type parameter's value to video.
       */
      public java.lang.String getVideoDuration() {
        return videoDuration;
      }

      /**
       * The videoDuration parameter filters video search results based on their duration. If you
       * specify a value for this parameter, you must also set the type parameter's value to video.
       */
      public List setVideoDuration(java.lang.String videoDuration) {
        this.videoDuration = videoDuration;
        return this;
      }

      /**
       * The videoEmbeddable parameter lets you to restrict a search to only videos that can be
       * embedded into a webpage. If you specify a value for this parameter, you must also set the
       * type parameter's value to video.
       */
      @com.google.api.client.util.Key
      private java.lang.String videoEmbeddable;

      /** The videoEmbeddable parameter lets you to restrict a search to only videos that can be embedded
     into a webpage. If you specify a value for this parameter, you must also set the type parameter's
     value to video.
       */
      public java.lang.String getVideoEmbeddable() {
        return videoEmbeddable;
      }

      /**
       * The videoEmbeddable parameter lets you to restrict a search to only videos that can be
       * embedded into a webpage. If you specify a value for this parameter, you must also set the
       * type parameter's value to video.
       */
      public List setVideoEmbeddable(java.lang.String videoEmbeddable) {
        this.videoEmbeddable = videoEmbeddable;
        return this;
      }

      /**
       * The videoLicense parameter filters search results to only include videos with a particular
       * license. YouTube lets video uploaders choose to attach either the Creative Commons license
       * or the standard YouTube license to each of their videos. If you specify a value for this
       * parameter, you must also set the type parameter's value to video.
       */
      @com.google.api.client.util.Key
      private java.lang.String videoLicense;

      /** The videoLicense parameter filters search results to only include videos with a particular license.
     YouTube lets video uploaders choose to attach either the Creative Commons license or the standard
     YouTube license to each of their videos. If you specify a value for this parameter, you must also
     set the type parameter's value to video.
       */
      public java.lang.String getVideoLicense() {
        return videoLicense;
      }

      /**
       * The videoLicense parameter filters search results to only include videos with a particular
       * license. YouTube lets video uploaders choose to attach either the Creative Commons license
       * or the standard YouTube license to each of their videos. If you specify a value for this
       * parameter, you must also set the type parameter's value to video.
       */
      public List setVideoLicense(java.lang.String videoLicense) {
        this.videoLicense = videoLicense;
        return this;
      }

      /**
       * The videoSyndicated parameter lets you to restrict a search to only videos that can be
       * played outside youtube.com. If you specify a value for this parameter, you must also set
       * the type parameter's value to video.
       */
      @com.google.api.client.util.Key
      private java.lang.String videoSyndicated;

      /** The videoSyndicated parameter lets you to restrict a search to only videos that can be played
     outside youtube.com. If you specify a value for this parameter, you must also set the type
     parameter's value to video.
       */
      public java.lang.String getVideoSyndicated() {
        return videoSyndicated;
      }

      /**
       * The videoSyndicated parameter lets you to restrict a search to only videos that can be
       * played outside youtube.com. If you specify a value for this parameter, you must also set
       * the type parameter's value to video.
       */
      public List setVideoSyndicated(java.lang.String videoSyndicated) {
        this.videoSyndicated = videoSyndicated;
        return this;
      }

      /**
       * The videoType parameter lets you restrict a search to a particular type of videos. If you
       * specify a value for this parameter, you must also set the type parameter's value to video.
       */
      @com.google.api.client.util.Key
      private java.lang.String videoType;

      /** The videoType parameter lets you restrict a search to a particular type of videos. If you specify a
     value for this parameter, you must also set the type parameter's value to video.
       */
      public java.lang.String getVideoType() {
        return videoType;
      }

      /**
       * The videoType parameter lets you restrict a search to a particular type of videos. If you
       * specify a value for this parameter, you must also set the type parameter's value to video.
       */
      public List setVideoType(java.lang.String videoType) {
        this.videoType = videoType;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the Sponsors collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code YouTube youtube = new YouTube(...);}
   *   {@code YouTube.Sponsors.List request = youtube.sponsors().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Sponsors sponsors() {
    return new Sponsors();
  }

  /**
   * The "sponsors" collection of methods.
   */
  public class Sponsors {

    /**
     * Lists sponsors for a channel.
     *
     * Create a request for the method "sponsors.list".
     *
     * This request holds the parameters needed by the youtube server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param part The part parameter specifies the sponsor resource parts that the API response will include.
     *        Supported values are id and snippet.
     * @return the request
     */
    public List list(java.lang.String part) throws java.io.IOException {
      List result = new List(part);
      initialize(result);
      return result;
    }

    public class List extends YouTubeRequest<com.google.api.services.youtube.model.SponsorListResponse> {

      private static final String REST_PATH = "sponsors";

      /**
       * Lists sponsors for a channel.
       *
       * Create a request for the method "sponsors.list".
       *
       * This request holds the parameters needed by the the youtube server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param part The part parameter specifies the sponsor resource parts that the API response will include.
     *        Supported values are id and snippet.
       * @since 1.13
       */
      protected List(java.lang.String part) {
        super(YouTube.this, "GET", REST_PATH, null, com.google.api.services.youtube.model.SponsorListResponse.class);
        this.part = com.google.api.client.util.Preconditions.checkNotNull(part, "Required parameter part must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUserIp(java.lang.String userIp) {
        return (List) super.setUserIp(userIp);
      }

      /**
       * The part parameter specifies the sponsor resource parts that the API response will include.
       * Supported values are id and snippet.
       */
      @com.google.api.client.util.Key
      private java.lang.String part;

      /** The part parameter specifies the sponsor resource parts that the API response will include.
     Supported values are id and snippet.
       */
      public java.lang.String getPart() {
        return part;
      }

      /**
       * The part parameter specifies the sponsor resource parts that the API response will include.
       * Supported values are id and snippet.
       */
      public List setPart(java.lang.String part) {
        this.part = part;
        return this;
      }

      /** The filter parameter specifies which channel sponsors to return. */
      @com.google.api.client.util.Key
      private java.lang.String filter;

      /** The filter parameter specifies which channel sponsors to return. [default: POLL_NEWEST]
       */
      public java.lang.String getFilter() {
        return filter;
      }

      /** The filter parameter specifies which channel sponsors to return. */
      public List setFilter(java.lang.String filter) {
        this.filter = filter;
        return this;
      }

      /**
       * The maxResults parameter specifies the maximum number of items that should be returned in
       * the result set.
       */
      @com.google.api.client.util.Key
      private java.lang.Long maxResults;

      /** The maxResults parameter specifies the maximum number of items that should be returned in the
     result set. [default: 5] [minimum: 0] [maximum: 50]
       */
      public java.lang.Long getMaxResults() {
        return maxResults;
      }

      /**
       * The maxResults parameter specifies the maximum number of items that should be returned in
       * the result set.
       */
      public List setMaxResults(java.lang.Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      /**
       * The pageToken parameter identifies a specific page in the result set that should be
       * returned. In an API response, the nextPageToken and prevPageToken properties identify other
       * pages that could be retrieved.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** The pageToken parameter identifies a specific page in the result set that should be returned. In an
     API response, the nextPageToken and prevPageToken properties identify other pages that could be
     retrieved.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * The pageToken parameter identifies a specific page in the result set that should be
       * returned. In an API response, the nextPageToken and prevPageToken properties identify other
       * pages that could be retrieved.
       */
      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the Subscriptions collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code YouTube youtube = new YouTube(...);}
   *   {@code YouTube.Subscriptions.List request = youtube.subscriptions().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Subscriptions subscriptions() {
    return new Subscriptions();
  }

  /**
   * The "subscriptions" collection of methods.
   */
  public class Subscriptions {

    /**
     * Deletes a subscription.
     *
     * Create a request for the method "subscriptions.delete".
     *
     * This request holds the parameters needed by the youtube server.  After setting any optional
     * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
     *
     * @param id The id parameter specifies the YouTube subscription ID for the resource that is being deleted. In a
     *        subscription resource, the id property specifies the YouTube subscription ID.
     * @return the request
     */
    public Delete delete(java.lang.String id) throws java.io.IOException {
      Delete result = new Delete(id);
      initialize(result);
      return result;
    }

    public class Delete extends YouTubeRequest<Void> {

      private static final String REST_PATH = "subscriptions";

      /**
       * Deletes a subscription.
       *
       * Create a request for the method "subscriptions.delete".
       *
       * This request holds the parameters needed by the the youtube server.  After setting any optional
       * parameters, call the {@link Delete#execute()} method to invoke the remote operation. <p> {@link
       * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param id The id parameter specifies the YouTube subscription ID for the resource that is being deleted. In a
     *        subscription resource, the id property specifies the YouTube subscription ID.
       * @since 1.13
       */
      protected Delete(java.lang.String id) {
        super(YouTube.this, "DELETE", REST_PATH, null, Void.class);
        this.id = com.google.api.client.util.Preconditions.checkNotNull(id, "Required parameter id must be specified.");
      }

      @Override
      public Delete setAlt(java.lang.String alt) {
        return (Delete) super.setAlt(alt);
      }

      @Override
      public Delete setFields(java.lang.String fields) {
        return (Delete) super.setFields(fields);
      }

      @Override
      public Delete setKey(java.lang.String key) {
        return (Delete) super.setKey(key);
      }

      @Override
      public Delete setOauthToken(java.lang.String oauthToken) {
        return (Delete) super.setOauthToken(oauthToken);
      }

      @Override
      public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Delete) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Delete setQuotaUser(java.lang.String quotaUser) {
        return (Delete) super.setQuotaUser(quotaUser);
      }

      @Override
      public Delete setUserIp(java.lang.String userIp) {
        return (Delete) super.setUserIp(userIp);
      }

      /**
       * The id parameter specifies the YouTube subscription ID for the resource that is being
       * deleted. In a subscription resource, the id property specifies the YouTube subscription ID.
       */
      @com.google.api.client.util.Key
      private java.lang.String id;

      /** The id parameter specifies the YouTube subscription ID for the resource that is being deleted. In a
     subscription resource, the id property specifies the YouTube subscription ID.
       */
      public java.lang.String getId() {
        return id;
      }

      /**
       * The id parameter specifies the YouTube subscription ID for the resource that is being
       * deleted. In a subscription resource, the id property specifies the YouTube subscription ID.
       */
      public Delete setId(java.lang.String id) {
        this.id = id;
        return this;
      }

      @Override
      public Delete set(String parameterName, Object value) {
        return (Delete) super.set(parameterName, value);
      }
    }
    /**
     * Adds a subscription for the authenticated user's channel.
     *
     * Create a request for the method "subscriptions.insert".
     *
     * This request holds the parameters needed by the youtube server.  After setting any optional
     * parameters, call the {@link Insert#execute()} method to invoke the remote operation.
     *
     * @param part The part parameter serves two purposes in this operation. It identifies the properties that the
     *        write operation will set as well as the properties that the API response will include.
     * @param content the {@link com.google.api.services.youtube.model.Subscription}
     * @return the request
     */
    public Insert insert(java.lang.String part, com.google.api.services.youtube.model.Subscription content) throws java.io.IOException {
      Insert result = new Insert(part, content);
      initialize(result);
      return result;
    }

    public class Insert extends YouTubeRequest<com.google.api.services.youtube.model.Subscription> {

      private static final String REST_PATH = "subscriptions";

      /**
       * Adds a subscription for the authenticated user's channel.
       *
       * Create a request for the method "subscriptions.insert".
       *
       * This request holds the parameters needed by the the youtube server.  After setting any optional
       * parameters, call the {@link Insert#execute()} method to invoke the remote operation. <p> {@link
       * Insert#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param part The part parameter serves two purposes in this operation. It identifies the properties that the
     *        write operation will set as well as the properties that the API response will include.
       * @param content the {@link com.google.api.services.youtube.model.Subscription}
       * @since 1.13
       */
      protected Insert(java.lang.String part, com.google.api.services.youtube.model.Subscription content) {
        super(YouTube.this, "POST", REST_PATH, content, com.google.api.services.youtube.model.Subscription.class);
        this.part = com.google.api.client.util.Preconditions.checkNotNull(part, "Required parameter part must be specified.");
      }

      @Override
      public Insert setAlt(java.lang.String alt) {
        return (Insert) super.setAlt(alt);
      }

      @Override
      public Insert setFields(java.lang.String fields) {
        return (Insert) super.setFields(fields);
      }

      @Override
      public Insert setKey(java.lang.String key) {
        return (Insert) super.setKey(key);
      }

      @Override
      public Insert setOauthToken(java.lang.String oauthToken) {
        return (Insert) super.setOauthToken(oauthToken);
      }

      @Override
      public Insert setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Insert) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Insert setQuotaUser(java.lang.String quotaUser) {
        return (Insert) super.setQuotaUser(quotaUser);
      }

      @Override
      public Insert setUserIp(java.lang.String userIp) {
        return (Insert) super.setUserIp(userIp);
      }

      /**
       * The part parameter serves two purposes in this operation. It identifies the properties that
       * the write operation will set as well as the properties that the API response will include.
       */
      @com.google.api.client.util.Key
      private java.lang.String part;

      /** The part parameter serves two purposes in this operation. It identifies the properties that the
     write operation will set as well as the properties that the API response will include.
       */
      public java.lang.String getPart() {
        return part;
      }

      /**
       * The part parameter serves two purposes in this operation. It identifies the properties that
       * the write operation will set as well as the properties that the API response will include.
       */
      public Insert setPart(java.lang.String part) {
        this.part = part;
        return this;
      }

      @Override
      public Insert set(String parameterName, Object value) {
        return (Insert) super.set(parameterName, value);
      }
    }
    /**
     * Returns subscription resources that match the API request criteria.
     *
     * Create a request for the method "subscriptions.list".
     *
     * This request holds the parameters needed by the youtube server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param part The part parameter specifies a comma-separated list of one or more subscription resource properties
     *        that the API response will include.
    If the parameter identifies a property that contains
     *        child properties, the child properties will be included in the response. For example, in a
     *        subscription resource, the snippet property contains other properties, such as a display
     *        title for the subscription. If you set part=snippet, the API response will also contain
     *        all of those nested properties.
     * @return the request
     */
    public List list(java.lang.String part) throws java.io.IOException {
      List result = new List(part);
      initialize(result);
      return result;
    }

    public class List extends YouTubeRequest<com.google.api.services.youtube.model.SubscriptionListResponse> {

      private static final String REST_PATH = "subscriptions";

      /**
       * Returns subscription resources that match the API request criteria.
       *
       * Create a request for the method "subscriptions.list".
       *
       * This request holds the parameters needed by the the youtube server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param part The part parameter specifies a comma-separated list of one or more subscription resource properties
     *        that the API response will include.
    If the parameter identifies a property that contains
     *        child properties, the child properties will be included in the response. For example, in a
     *        subscription resource, the snippet property contains other properties, such as a display
     *        title for the subscription. If you set part=snippet, the API response will also contain
     *        all of those nested properties.
       * @since 1.13
       */
      protected List(java.lang.String part) {
        super(YouTube.this, "GET", REST_PATH, null, com.google.api.services.youtube.model.SubscriptionListResponse.class);
        this.part = com.google.api.client.util.Preconditions.checkNotNull(part, "Required parameter part must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUserIp(java.lang.String userIp) {
        return (List) super.setUserIp(userIp);
      }

      /**
       * The part parameter specifies a comma-separated list of one or more subscription resource
       * properties that the API response will include.
       *
       * If the parameter identifies a property that contains child properties, the child properties
       * will be included in the response. For example, in a subscription resource, the snippet
       * property contains other properties, such as a display title for the subscription. If you
       * set part=snippet, the API response will also contain all of those nested properties.
       */
      @com.google.api.client.util.Key
      private java.lang.String part;

      /** The part parameter specifies a comma-separated list of one or more subscription resource properties
     that the API response will include.

     If the parameter identifies a property that contains child properties, the child properties will be
     included in the response. For example, in a subscription resource, the snippet property contains
     other properties, such as a display title for the subscription. If you set part=snippet, the API
     response will also contain all of those nested properties.
       */
      public java.lang.String getPart() {
        return part;
      }

      /**
       * The part parameter specifies a comma-separated list of one or more subscription resource
       * properties that the API response will include.
       *
       * If the parameter identifies a property that contains child properties, the child properties
       * will be included in the response. For example, in a subscription resource, the snippet
       * property contains other properties, such as a display title for the subscription. If you
       * set part=snippet, the API response will also contain all of those nested properties.
       */
      public List setPart(java.lang.String part) {
        this.part = part;
        return this;
      }

      /**
       * The channelId parameter specifies a YouTube channel ID. The API will only return that
       * channel's subscriptions.
       */
      @com.google.api.client.util.Key
      private java.lang.String channelId;

      /** The channelId parameter specifies a YouTube channel ID. The API will only return that channel's
     subscriptions.
       */
      public java.lang.String getChannelId() {
        return channelId;
      }

      /**
       * The channelId parameter specifies a YouTube channel ID. The API will only return that
       * channel's subscriptions.
       */
      public List setChannelId(java.lang.String channelId) {
        this.channelId = channelId;
        return this;
      }

      /**
       * The forChannelId parameter specifies a comma-separated list of channel IDs. The API
       * response will then only contain subscriptions matching those channels.
       */
      @com.google.api.client.util.Key
      private java.lang.String forChannelId;

      /** The forChannelId parameter specifies a comma-separated list of channel IDs. The API response will
     then only contain subscriptions matching those channels.
       */
      public java.lang.String getForChannelId() {
        return forChannelId;
      }

      /**
       * The forChannelId parameter specifies a comma-separated list of channel IDs. The API
       * response will then only contain subscriptions matching those channels.
       */
      public List setForChannelId(java.lang.String forChannelId) {
        this.forChannelId = forChannelId;
        return this;
      }

      /**
       * The id parameter specifies a comma-separated list of the YouTube subscription ID(s) for the
       * resource(s) that are being retrieved. In a subscription resource, the id property specifies
       * the YouTube subscription ID.
       */
      @com.google.api.client.util.Key
      private java.lang.String id;

      /** The id parameter specifies a comma-separated list of the YouTube subscription ID(s) for the
     resource(s) that are being retrieved. In a subscription resource, the id property specifies the
     YouTube subscription ID.
       */
      public java.lang.String getId() {
        return id;
      }

      /**
       * The id parameter specifies a comma-separated list of the YouTube subscription ID(s) for the
       * resource(s) that are being retrieved. In a subscription resource, the id property specifies
       * the YouTube subscription ID.
       */
      public List setId(java.lang.String id) {
        this.id = id;
        return this;
      }

      /**
       * The maxResults parameter specifies the maximum number of items that should be returned in
       * the result set.
       */
      @com.google.api.client.util.Key
      private java.lang.Long maxResults;

      /** The maxResults parameter specifies the maximum number of items that should be returned in the
     result set. [default: 5] [minimum: 0] [maximum: 50]
       */
      public java.lang.Long getMaxResults() {
        return maxResults;
      }

      /**
       * The maxResults parameter specifies the maximum number of items that should be returned in
       * the result set.
       */
      public List setMaxResults(java.lang.Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      /**
       * Set this parameter's value to true to retrieve a feed of the authenticated user's
       * subscriptions.
       */
      @com.google.api.client.util.Key
      private java.lang.Boolean mine;

      /** Set this parameter's value to true to retrieve a feed of the authenticated user's subscriptions.
       */
      public java.lang.Boolean getMine() {
        return mine;
      }

      /**
       * Set this parameter's value to true to retrieve a feed of the authenticated user's
       * subscriptions.
       */
      public List setMine(java.lang.Boolean mine) {
        this.mine = mine;
        return this;
      }

      /**
       * Set this parameter's value to true to retrieve a feed of the subscribers of the
       * authenticated user in reverse chronological order (newest first).
       */
      @com.google.api.client.util.Key
      private java.lang.Boolean myRecentSubscribers;

      /** Set this parameter's value to true to retrieve a feed of the subscribers of the authenticated user
     in reverse chronological order (newest first).
       */
      public java.lang.Boolean getMyRecentSubscribers() {
        return myRecentSubscribers;
      }

      /**
       * Set this parameter's value to true to retrieve a feed of the subscribers of the
       * authenticated user in reverse chronological order (newest first).
       */
      public List setMyRecentSubscribers(java.lang.Boolean myRecentSubscribers) {
        this.myRecentSubscribers = myRecentSubscribers;
        return this;
      }

      /**
       * Set this parameter's value to true to retrieve a feed of the subscribers of the
       * authenticated user in no particular order.
       */
      @com.google.api.client.util.Key
      private java.lang.Boolean mySubscribers;

      /** Set this parameter's value to true to retrieve a feed of the subscribers of the authenticated user
     in no particular order.
       */
      public java.lang.Boolean getMySubscribers() {
        return mySubscribers;
      }

      /**
       * Set this parameter's value to true to retrieve a feed of the subscribers of the
       * authenticated user in no particular order.
       */
      public List setMySubscribers(java.lang.Boolean mySubscribers) {
        this.mySubscribers = mySubscribers;
        return this;
      }

      /**
       * Note: This parameter is intended exclusively for YouTube content partners.
       *
       * The onBehalfOfContentOwner parameter indicates that the request's authorization credentials
       * identify a YouTube CMS user who is acting on behalf of the content owner specified in the
       * parameter value. This parameter is intended for YouTube content partners that own and
       * manage many different YouTube channels. It allows content owners to authenticate once and
       * get access to all their video and channel data, without having to provide authentication
       * credentials for each individual channel. The CMS account that the user authenticates with
       * must be linked to the specified YouTube content owner.
       */
      @com.google.api.client.util.Key
      private java.lang.String onBehalfOfContentOwner;

      /** Note: This parameter is intended exclusively for YouTube content partners.

     The onBehalfOfContentOwner parameter indicates that the request's authorization credentials
     identify a YouTube CMS user who is acting on behalf of the content owner specified in the parameter
     value. This parameter is intended for YouTube content partners that own and manage many different
     YouTube channels. It allows content owners to authenticate once and get access to all their video
     and channel data, without having to provide authentication credentials for each individual channel.
     The CMS account that the user authenticates with must be linked to the specified YouTube content
     owner.
       */
      public java.lang.String getOnBehalfOfContentOwner() {
        return onBehalfOfContentOwner;
      }

      /**
       * Note: This parameter is intended exclusively for YouTube content partners.
       *
       * The onBehalfOfContentOwner parameter indicates that the request's authorization credentials
       * identify a YouTube CMS user who is acting on behalf of the content owner specified in the
       * parameter value. This parameter is intended for YouTube content partners that own and
       * manage many different YouTube channels. It allows content owners to authenticate once and
       * get access to all their video and channel data, without having to provide authentication
       * credentials for each individual channel. The CMS account that the user authenticates with
       * must be linked to the specified YouTube content owner.
       */
      public List setOnBehalfOfContentOwner(java.lang.String onBehalfOfContentOwner) {
        this.onBehalfOfContentOwner = onBehalfOfContentOwner;
        return this;
      }

      /**
       * This parameter can only be used in a properly authorized request. Note: This parameter is
       * intended exclusively for YouTube content partners.
       *
       * The onBehalfOfContentOwnerChannel parameter specifies the YouTube channel ID of the channel
       * to which a video is being added. This parameter is required when a request specifies a
       * value for the onBehalfOfContentOwner parameter, and it can only be used in conjunction with
       * that parameter. In addition, the request must be authorized using a CMS account that is
       * linked to the content owner that the onBehalfOfContentOwner parameter specifies. Finally,
       * the channel that the onBehalfOfContentOwnerChannel parameter value specifies must be linked
       * to the content owner that the onBehalfOfContentOwner parameter specifies.
       *
       * This parameter is intended for YouTube content partners that own and manage many different
       * YouTube channels. It allows content owners to authenticate once and perform actions on
       * behalf of the channel specified in the parameter value, without having to provide
       * authentication credentials for each separate channel.
       */
      @com.google.api.client.util.Key
      private java.lang.String onBehalfOfContentOwnerChannel;

      /** This parameter can only be used in a properly authorized request. Note: This parameter is intended
     exclusively for YouTube content partners.

     The onBehalfOfContentOwnerChannel parameter specifies the YouTube channel ID of the channel to
     which a video is being added. This parameter is required when a request specifies a value for the
     onBehalfOfContentOwner parameter, and it can only be used in conjunction with that parameter. In
     addition, the request must be authorized using a CMS account that is linked to the content owner
     that the onBehalfOfContentOwner parameter specifies. Finally, the channel that the
     onBehalfOfContentOwnerChannel parameter value specifies must be linked to the content owner that
     the onBehalfOfContentOwner parameter specifies.

     This parameter is intended for YouTube content partners that own and manage many different YouTube
     channels. It allows content owners to authenticate once and perform actions on behalf of the
     channel specified in the parameter value, without having to provide authentication credentials for
     each separate channel.
       */
      public java.lang.String getOnBehalfOfContentOwnerChannel() {
        return onBehalfOfContentOwnerChannel;
      }

      /**
       * This parameter can only be used in a properly authorized request. Note: This parameter is
       * intended exclusively for YouTube content partners.
       *
       * The onBehalfOfContentOwnerChannel parameter specifies the YouTube channel ID of the channel
       * to which a video is being added. This parameter is required when a request specifies a
       * value for the onBehalfOfContentOwner parameter, and it can only be used in conjunction with
       * that parameter. In addition, the request must be authorized using a CMS account that is
       * linked to the content owner that the onBehalfOfContentOwner parameter specifies. Finally,
       * the channel that the onBehalfOfContentOwnerChannel parameter value specifies must be linked
       * to the content owner that the onBehalfOfContentOwner parameter specifies.
       *
       * This parameter is intended for YouTube content partners that own and manage many different
       * YouTube channels. It allows content owners to authenticate once and perform actions on
       * behalf of the channel specified in the parameter value, without having to provide
       * authentication credentials for each separate channel.
       */
      public List setOnBehalfOfContentOwnerChannel(java.lang.String onBehalfOfContentOwnerChannel) {
        this.onBehalfOfContentOwnerChannel = onBehalfOfContentOwnerChannel;
        return this;
      }

      /**
       * The order parameter specifies the method that will be used to sort resources in the API
       * response.
       */
      @com.google.api.client.util.Key
      private java.lang.String order;

      /** The order parameter specifies the method that will be used to sort resources in the API response.
     [default: SUBSCRIPTION_ORDER_RELEVANCE]
       */
      public java.lang.String getOrder() {
        return order;
      }

      /**
       * The order parameter specifies the method that will be used to sort resources in the API
       * response.
       */
      public List setOrder(java.lang.String order) {
        this.order = order;
        return this;
      }

      /**
       * The pageToken parameter identifies a specific page in the result set that should be
       * returned. In an API response, the nextPageToken and prevPageToken properties identify other
       * pages that could be retrieved.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** The pageToken parameter identifies a specific page in the result set that should be returned. In an
     API response, the nextPageToken and prevPageToken properties identify other pages that could be
     retrieved.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * The pageToken parameter identifies a specific page in the result set that should be
       * returned. In an API response, the nextPageToken and prevPageToken properties identify other
       * pages that could be retrieved.
       */
      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the SuperChatEvents collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code YouTube youtube = new YouTube(...);}
   *   {@code YouTube.SuperChatEvents.List request = youtube.superChatEvents().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public SuperChatEvents superChatEvents() {
    return new SuperChatEvents();
  }

  /**
   * The "superChatEvents" collection of methods.
   */
  public class SuperChatEvents {

    /**
     * Lists Super Chat events for a channel.
     *
     * Create a request for the method "superChatEvents.list".
     *
     * This request holds the parameters needed by the youtube server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param part The part parameter specifies the superChatEvent resource parts that the API response will include.
     *        Supported values are id and snippet.
     * @return the request
     */
    public List list(java.lang.String part) throws java.io.IOException {
      List result = new List(part);
      initialize(result);
      return result;
    }

    public class List extends YouTubeRequest<com.google.api.services.youtube.model.SuperChatEventListResponse> {

      private static final String REST_PATH = "superChatEvents";

      /**
       * Lists Super Chat events for a channel.
       *
       * Create a request for the method "superChatEvents.list".
       *
       * This request holds the parameters needed by the the youtube server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param part The part parameter specifies the superChatEvent resource parts that the API response will include.
     *        Supported values are id and snippet.
       * @since 1.13
       */
      protected List(java.lang.String part) {
        super(YouTube.this, "GET", REST_PATH, null, com.google.api.services.youtube.model.SuperChatEventListResponse.class);
        this.part = com.google.api.client.util.Preconditions.checkNotNull(part, "Required parameter part must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUserIp(java.lang.String userIp) {
        return (List) super.setUserIp(userIp);
      }

      /**
       * The part parameter specifies the superChatEvent resource parts that the API response will
       * include. Supported values are id and snippet.
       */
      @com.google.api.client.util.Key
      private java.lang.String part;

      /** The part parameter specifies the superChatEvent resource parts that the API response will include.
     Supported values are id and snippet.
       */
      public java.lang.String getPart() {
        return part;
      }

      /**
       * The part parameter specifies the superChatEvent resource parts that the API response will
       * include. Supported values are id and snippet.
       */
      public List setPart(java.lang.String part) {
        this.part = part;
        return this;
      }

      /**
       * The hl parameter instructs the API to retrieve localized resource metadata for a specific
       * application language that the YouTube website supports. The parameter value must be a
       * language code included in the list returned by the i18nLanguages.list method.
       *
       * If localized resource details are available in that language, the resource's
       * snippet.localized object will contain the localized values. However, if localized details
       * are not available, the snippet.localized object will contain resource details in the
       * resource's default language.
       */
      @com.google.api.client.util.Key
      private java.lang.String hl;

      /** The hl parameter instructs the API to retrieve localized resource metadata for a specific
     application language that the YouTube website supports. The parameter value must be a language code
     included in the list returned by the i18nLanguages.list method.

     If localized resource details are available in that language, the resource's snippet.localized
     object will contain the localized values. However, if localized details are not available, the
     snippet.localized object will contain resource details in the resource's default language.
       */
      public java.lang.String getHl() {
        return hl;
      }

      /**
       * The hl parameter instructs the API to retrieve localized resource metadata for a specific
       * application language that the YouTube website supports. The parameter value must be a
       * language code included in the list returned by the i18nLanguages.list method.
       *
       * If localized resource details are available in that language, the resource's
       * snippet.localized object will contain the localized values. However, if localized details
       * are not available, the snippet.localized object will contain resource details in the
       * resource's default language.
       */
      public List setHl(java.lang.String hl) {
        this.hl = hl;
        return this;
      }

      /**
       * The maxResults parameter specifies the maximum number of items that should be returned in
       * the result set.
       */
      @com.google.api.client.util.Key
      private java.lang.Long maxResults;

      /** The maxResults parameter specifies the maximum number of items that should be returned in the
     result set. [default: 5] [minimum: 1] [maximum: 50]
       */
      public java.lang.Long getMaxResults() {
        return maxResults;
      }

      /**
       * The maxResults parameter specifies the maximum number of items that should be returned in
       * the result set.
       */
      public List setMaxResults(java.lang.Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      /**
       * The pageToken parameter identifies a specific page in the result set that should be
       * returned. In an API response, the nextPageToken and prevPageToken properties identify other
       * pages that could be retrieved.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** The pageToken parameter identifies a specific page in the result set that should be returned. In an
     API response, the nextPageToken and prevPageToken properties identify other pages that could be
     retrieved.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * The pageToken parameter identifies a specific page in the result set that should be
       * returned. In an API response, the nextPageToken and prevPageToken properties identify other
       * pages that could be retrieved.
       */
      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the Thumbnails collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code YouTube youtube = new YouTube(...);}
   *   {@code YouTube.Thumbnails.List request = youtube.thumbnails().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Thumbnails thumbnails() {
    return new Thumbnails();
  }

  /**
   * The "thumbnails" collection of methods.
   */
  public class Thumbnails {

    /**
     * Uploads a custom video thumbnail to YouTube and sets it for a video.
     *
     * Create a request for the method "thumbnails.set".
     *
     * This request holds the parameters needed by the youtube server.  After setting any optional
     * parameters, call the {@link Set#execute()} method to invoke the remote operation.
     *
     * @param videoId The videoId parameter specifies a YouTube video ID for which the custom video thumbnail is being
     *        provided.
     * @return the request
     */
    public Set set(java.lang.String videoId) throws java.io.IOException {
      Set result = new Set(videoId);
      initialize(result);
      return result;
    }

    /**
     * Uploads a custom video thumbnail to YouTube and sets it for a video.
     *
     * Create a request for the method "thumbnails.set".
     *
     * This request holds the parameters needed by the the youtube server.  After setting any optional
     * parameters, call the {@link Set#execute()} method to invoke the remote operation.
     *
     * <p>
     * This method should be used for uploading media content.
     * </p>
     *
     * @param videoId The videoId parameter specifies a YouTube video ID for which the custom video thumbnail is being
     *        provided.
     * @param mediaContent The media HTTP content or {@code null} if none.
     * @return the request
     * @throws java.io.IOException if the initialization of the request fails
     */
    public Set set(java.lang.String videoId, com.google.api.client.http.AbstractInputStreamContent mediaContent) throws java.io.IOException {
      Set result = new Set(videoId, mediaContent);
      initialize(result);
      return result;
    }

    public class Set extends YouTubeRequest<com.google.api.services.youtube.model.ThumbnailSetResponse> {

      private static final String REST_PATH = "thumbnails/set";

      /**
       * Uploads a custom video thumbnail to YouTube and sets it for a video.
       *
       * Create a request for the method "thumbnails.set".
       *
       * This request holds the parameters needed by the the youtube server.  After setting any optional
       * parameters, call the {@link Set#execute()} method to invoke the remote operation. <p> {@link
       * Set#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param videoId The videoId parameter specifies a YouTube video ID for which the custom video thumbnail is being
     *        provided.
       * @since 1.13
       */
      protected Set(java.lang.String videoId) {
        super(YouTube.this, "POST", REST_PATH, null, com.google.api.services.youtube.model.ThumbnailSetResponse.class);
        this.videoId = com.google.api.client.util.Preconditions.checkNotNull(videoId, "Required parameter videoId must be specified.");
      }

      /**
       * Uploads a custom video thumbnail to YouTube and sets it for a video.
       *
       * Create a request for the method "thumbnails.set".
       *
       * This request holds the parameters needed by the the youtube server.  After setting any optional
       * parameters, call the {@link Set#execute()} method to invoke the remote operation. <p> {@link
       * Set#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * <p>
       * This constructor should be used for uploading media content.
       * </p>
       *
       * @param videoId The videoId parameter specifies a YouTube video ID for which the custom video thumbnail is being
     *        provided.
       * @param mediaContent The media HTTP content or {@code null} if none.
       * @since 1.13
       */
      protected Set(java.lang.String videoId, com.google.api.client.http.AbstractInputStreamContent mediaContent) {
        super(YouTube.this, "POST", "/upload/" + getServicePath() + REST_PATH, null, com.google.api.services.youtube.model.ThumbnailSetResponse.class);
        this.videoId = com.google.api.client.util.Preconditions.checkNotNull(videoId, "Required parameter videoId must be specified.");
        initializeMediaUpload(mediaContent);
      }

      @Override
      public Set setAlt(java.lang.String alt) {
        return (Set) super.setAlt(alt);
      }

      @Override
      public Set setFields(java.lang.String fields) {
        return (Set) super.setFields(fields);
      }

      @Override
      public Set setKey(java.lang.String key) {
        return (Set) super.setKey(key);
      }

      @Override
      public Set setOauthToken(java.lang.String oauthToken) {
        return (Set) super.setOauthToken(oauthToken);
      }

      @Override
      public Set setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Set) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Set setQuotaUser(java.lang.String quotaUser) {
        return (Set) super.setQuotaUser(quotaUser);
      }

      @Override
      public Set setUserIp(java.lang.String userIp) {
        return (Set) super.setUserIp(userIp);
      }

      /**
       * The videoId parameter specifies a YouTube video ID for which the custom video thumbnail is
       * being provided.
       */
      @com.google.api.client.util.Key
      private java.lang.String videoId;

      /** The videoId parameter specifies a YouTube video ID for which the custom video thumbnail is being
     provided.
       */
      public java.lang.String getVideoId() {
        return videoId;
      }

      /**
       * The videoId parameter specifies a YouTube video ID for which the custom video thumbnail is
       * being provided.
       */
      public Set setVideoId(java.lang.String videoId) {
        this.videoId = videoId;
        return this;
      }

      /**
       * Note: This parameter is intended exclusively for YouTube content partners.
       *
       * The onBehalfOfContentOwner parameter indicates that the request's authorization credentials
       * identify a YouTube CMS user who is acting on behalf of the content owner specified in the
       * parameter value. This parameter is intended for YouTube content partners that own and
       * manage many different YouTube channels. It allows content owners to authenticate once and
       * get access to all their video and channel data, without having to provide authentication
       * credentials for each individual channel. The actual CMS account that the user authenticates
       * with must be linked to the specified YouTube content owner.
       */
      @com.google.api.client.util.Key
      private java.lang.String onBehalfOfContentOwner;

      /** Note: This parameter is intended exclusively for YouTube content partners.

     The onBehalfOfContentOwner parameter indicates that the request's authorization credentials
     identify a YouTube CMS user who is acting on behalf of the content owner specified in the parameter
     value. This parameter is intended for YouTube content partners that own and manage many different
     YouTube channels. It allows content owners to authenticate once and get access to all their video
     and channel data, without having to provide authentication credentials for each individual channel.
     The actual CMS account that the user authenticates with must be linked to the specified YouTube
     content owner.
       */
      public java.lang.String getOnBehalfOfContentOwner() {
        return onBehalfOfContentOwner;
      }

      /**
       * Note: This parameter is intended exclusively for YouTube content partners.
       *
       * The onBehalfOfContentOwner parameter indicates that the request's authorization credentials
       * identify a YouTube CMS user who is acting on behalf of the content owner specified in the
       * parameter value. This parameter is intended for YouTube content partners that own and
       * manage many different YouTube channels. It allows content owners to authenticate once and
       * get access to all their video and channel data, without having to provide authentication
       * credentials for each individual channel. The actual CMS account that the user authenticates
       * with must be linked to the specified YouTube content owner.
       */
      public Set setOnBehalfOfContentOwner(java.lang.String onBehalfOfContentOwner) {
        this.onBehalfOfContentOwner = onBehalfOfContentOwner;
        return this;
      }

      @Override
      public Set set(String parameterName, Object value) {
        return (Set) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the VideoAbuseReportReasons collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code YouTube youtube = new YouTube(...);}
   *   {@code YouTube.VideoAbuseReportReasons.List request = youtube.videoAbuseReportReasons().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public VideoAbuseReportReasons videoAbuseReportReasons() {
    return new VideoAbuseReportReasons();
  }

  /**
   * The "videoAbuseReportReasons" collection of methods.
   */
  public class VideoAbuseReportReasons {

    /**
     * Returns a list of abuse reasons that can be used for reporting abusive videos.
     *
     * Create a request for the method "videoAbuseReportReasons.list".
     *
     * This request holds the parameters needed by the youtube server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param part The part parameter specifies the videoCategory resource parts that the API response will include.
     *        Supported values are id and snippet.
     * @return the request
     */
    public List list(java.lang.String part) throws java.io.IOException {
      List result = new List(part);
      initialize(result);
      return result;
    }

    public class List extends YouTubeRequest<com.google.api.services.youtube.model.VideoAbuseReportReasonListResponse> {

      private static final String REST_PATH = "videoAbuseReportReasons";

      /**
       * Returns a list of abuse reasons that can be used for reporting abusive videos.
       *
       * Create a request for the method "videoAbuseReportReasons.list".
       *
       * This request holds the parameters needed by the the youtube server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param part The part parameter specifies the videoCategory resource parts that the API response will include.
     *        Supported values are id and snippet.
       * @since 1.13
       */
      protected List(java.lang.String part) {
        super(YouTube.this, "GET", REST_PATH, null, com.google.api.services.youtube.model.VideoAbuseReportReasonListResponse.class);
        this.part = com.google.api.client.util.Preconditions.checkNotNull(part, "Required parameter part must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUserIp(java.lang.String userIp) {
        return (List) super.setUserIp(userIp);
      }

      /**
       * The part parameter specifies the videoCategory resource parts that the API response will
       * include. Supported values are id and snippet.
       */
      @com.google.api.client.util.Key
      private java.lang.String part;

      /** The part parameter specifies the videoCategory resource parts that the API response will include.
     Supported values are id and snippet.
       */
      public java.lang.String getPart() {
        return part;
      }

      /**
       * The part parameter specifies the videoCategory resource parts that the API response will
       * include. Supported values are id and snippet.
       */
      public List setPart(java.lang.String part) {
        this.part = part;
        return this;
      }

      /**
       * The hl parameter specifies the language that should be used for text values in the API
       * response.
       */
      @com.google.api.client.util.Key
      private java.lang.String hl;

      /** The hl parameter specifies the language that should be used for text values in the API response.
     [default: en_US]
       */
      public java.lang.String getHl() {
        return hl;
      }

      /**
       * The hl parameter specifies the language that should be used for text values in the API
       * response.
       */
      public List setHl(java.lang.String hl) {
        this.hl = hl;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the VideoCategories collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code YouTube youtube = new YouTube(...);}
   *   {@code YouTube.VideoCategories.List request = youtube.videoCategories().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public VideoCategories videoCategories() {
    return new VideoCategories();
  }

  /**
   * The "videoCategories" collection of methods.
   */
  public class VideoCategories {

    /**
     * Returns a list of categories that can be associated with YouTube videos.
     *
     * Create a request for the method "videoCategories.list".
     *
     * This request holds the parameters needed by the youtube server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param part The part parameter specifies the videoCategory resource properties that the API response will
     *        include. Set the parameter value to snippet.
     * @return the request
     */
    public List list(java.lang.String part) throws java.io.IOException {
      List result = new List(part);
      initialize(result);
      return result;
    }

    public class List extends YouTubeRequest<com.google.api.services.youtube.model.VideoCategoryListResponse> {

      private static final String REST_PATH = "videoCategories";

      /**
       * Returns a list of categories that can be associated with YouTube videos.
       *
       * Create a request for the method "videoCategories.list".
       *
       * This request holds the parameters needed by the the youtube server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param part The part parameter specifies the videoCategory resource properties that the API response will
     *        include. Set the parameter value to snippet.
       * @since 1.13
       */
      protected List(java.lang.String part) {
        super(YouTube.this, "GET", REST_PATH, null, com.google.api.services.youtube.model.VideoCategoryListResponse.class);
        this.part = com.google.api.client.util.Preconditions.checkNotNull(part, "Required parameter part must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUserIp(java.lang.String userIp) {
        return (List) super.setUserIp(userIp);
      }

      /**
       * The part parameter specifies the videoCategory resource properties that the API response
       * will include. Set the parameter value to snippet.
       */
      @com.google.api.client.util.Key
      private java.lang.String part;

      /** The part parameter specifies the videoCategory resource properties that the API response will
     include. Set the parameter value to snippet.
       */
      public java.lang.String getPart() {
        return part;
      }

      /**
       * The part parameter specifies the videoCategory resource properties that the API response
       * will include. Set the parameter value to snippet.
       */
      public List setPart(java.lang.String part) {
        this.part = part;
        return this;
      }

      /**
       * The hl parameter specifies the language that should be used for text values in the API
       * response.
       */
      @com.google.api.client.util.Key
      private java.lang.String hl;

      /** The hl parameter specifies the language that should be used for text values in the API response.
     [default: en_US]
       */
      public java.lang.String getHl() {
        return hl;
      }

      /**
       * The hl parameter specifies the language that should be used for text values in the API
       * response.
       */
      public List setHl(java.lang.String hl) {
        this.hl = hl;
        return this;
      }

      /**
       * The id parameter specifies a comma-separated list of video category IDs for the resources
       * that you are retrieving.
       */
      @com.google.api.client.util.Key
      private java.lang.String id;

      /** The id parameter specifies a comma-separated list of video category IDs for the resources that you
     are retrieving.
       */
      public java.lang.String getId() {
        return id;
      }

      /**
       * The id parameter specifies a comma-separated list of video category IDs for the resources
       * that you are retrieving.
       */
      public List setId(java.lang.String id) {
        this.id = id;
        return this;
      }

      /**
       * The regionCode parameter instructs the API to return the list of video categories available
       * in the specified country. The parameter value is an ISO 3166-1 alpha-2 country code.
       */
      @com.google.api.client.util.Key
      private java.lang.String regionCode;

      /** The regionCode parameter instructs the API to return the list of video categories available in the
     specified country. The parameter value is an ISO 3166-1 alpha-2 country code.
       */
      public java.lang.String getRegionCode() {
        return regionCode;
      }

      /**
       * The regionCode parameter instructs the API to return the list of video categories available
       * in the specified country. The parameter value is an ISO 3166-1 alpha-2 country code.
       */
      public List setRegionCode(java.lang.String regionCode) {
        this.regionCode = regionCode;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the Videos collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code YouTube youtube = new YouTube(...);}
   *   {@code YouTube.Videos.List request = youtube.videos().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Videos videos() {
    return new Videos();
  }

  /**
   * The "videos" collection of methods.
   */
  public class Videos {

    /**
     * Deletes a YouTube video.
     *
     * Create a request for the method "videos.delete".
     *
     * This request holds the parameters needed by the youtube server.  After setting any optional
     * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
     *
     * @param id The id parameter specifies the YouTube video ID for the resource that is being deleted. In a video
     *        resource, the id property specifies the video's ID.
     * @return the request
     */
    public Delete delete(java.lang.String id) throws java.io.IOException {
      Delete result = new Delete(id);
      initialize(result);
      return result;
    }

    public class Delete extends YouTubeRequest<Void> {

      private static final String REST_PATH = "videos";

      /**
       * Deletes a YouTube video.
       *
       * Create a request for the method "videos.delete".
       *
       * This request holds the parameters needed by the the youtube server.  After setting any optional
       * parameters, call the {@link Delete#execute()} method to invoke the remote operation. <p> {@link
       * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param id The id parameter specifies the YouTube video ID for the resource that is being deleted. In a video
     *        resource, the id property specifies the video's ID.
       * @since 1.13
       */
      protected Delete(java.lang.String id) {
        super(YouTube.this, "DELETE", REST_PATH, null, Void.class);
        this.id = com.google.api.client.util.Preconditions.checkNotNull(id, "Required parameter id must be specified.");
      }

      @Override
      public Delete setAlt(java.lang.String alt) {
        return (Delete) super.setAlt(alt);
      }

      @Override
      public Delete setFields(java.lang.String fields) {
        return (Delete) super.setFields(fields);
      }

      @Override
      public Delete setKey(java.lang.String key) {
        return (Delete) super.setKey(key);
      }

      @Override
      public Delete setOauthToken(java.lang.String oauthToken) {
        return (Delete) super.setOauthToken(oauthToken);
      }

      @Override
      public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Delete) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Delete setQuotaUser(java.lang.String quotaUser) {
        return (Delete) super.setQuotaUser(quotaUser);
      }

      @Override
      public Delete setUserIp(java.lang.String userIp) {
        return (Delete) super.setUserIp(userIp);
      }

      /**
       * The id parameter specifies the YouTube video ID for the resource that is being deleted. In
       * a video resource, the id property specifies the video's ID.
       */
      @com.google.api.client.util.Key
      private java.lang.String id;

      /** The id parameter specifies the YouTube video ID for the resource that is being deleted. In a video
     resource, the id property specifies the video's ID.
       */
      public java.lang.String getId() {
        return id;
      }

      /**
       * The id parameter specifies the YouTube video ID for the resource that is being deleted. In
       * a video resource, the id property specifies the video's ID.
       */
      public Delete setId(java.lang.String id) {
        this.id = id;
        return this;
      }

      /**
       * Note: This parameter is intended exclusively for YouTube content partners.
       *
       * The onBehalfOfContentOwner parameter indicates that the request's authorization credentials
       * identify a YouTube CMS user who is acting on behalf of the content owner specified in the
       * parameter value. This parameter is intended for YouTube content partners that own and
       * manage many different YouTube channels. It allows content owners to authenticate once and
       * get access to all their video and channel data, without having to provide authentication
       * credentials for each individual channel. The actual CMS account that the user authenticates
       * with must be linked to the specified YouTube content owner.
       */
      @com.google.api.client.util.Key
      private java.lang.String onBehalfOfContentOwner;

      /** Note: This parameter is intended exclusively for YouTube content partners.

     The onBehalfOfContentOwner parameter indicates that the request's authorization credentials
     identify a YouTube CMS user who is acting on behalf of the content owner specified in the parameter
     value. This parameter is intended for YouTube content partners that own and manage many different
     YouTube channels. It allows content owners to authenticate once and get access to all their video
     and channel data, without having to provide authentication credentials for each individual channel.
     The actual CMS account that the user authenticates with must be linked to the specified YouTube
     content owner.
       */
      public java.lang.String getOnBehalfOfContentOwner() {
        return onBehalfOfContentOwner;
      }

      /**
       * Note: This parameter is intended exclusively for YouTube content partners.
       *
       * The onBehalfOfContentOwner parameter indicates that the request's authorization credentials
       * identify a YouTube CMS user who is acting on behalf of the content owner specified in the
       * parameter value. This parameter is intended for YouTube content partners that own and
       * manage many different YouTube channels. It allows content owners to authenticate once and
       * get access to all their video and channel data, without having to provide authentication
       * credentials for each individual channel. The actual CMS account that the user authenticates
       * with must be linked to the specified YouTube content owner.
       */
      public Delete setOnBehalfOfContentOwner(java.lang.String onBehalfOfContentOwner) {
        this.onBehalfOfContentOwner = onBehalfOfContentOwner;
        return this;
      }

      @Override
      public Delete set(String parameterName, Object value) {
        return (Delete) super.set(parameterName, value);
      }
    }
    /**
     * Retrieves the ratings that the authorized user gave to a list of specified videos.
     *
     * Create a request for the method "videos.getRating".
     *
     * This request holds the parameters needed by the youtube server.  After setting any optional
     * parameters, call the {@link GetRating#execute()} method to invoke the remote operation.
     *
     * @param id The id parameter specifies a comma-separated list of the YouTube video ID(s) for the resource(s) for
     *        which you are retrieving rating data. In a video resource, the id property specifies the
     *        video's ID.
     * @return the request
     */
    public GetRating getRating(java.lang.String id) throws java.io.IOException {
      GetRating result = new GetRating(id);
      initialize(result);
      return result;
    }

    public class GetRating extends YouTubeRequest<com.google.api.services.youtube.model.VideoGetRatingResponse> {

      private static final String REST_PATH = "videos/getRating";

      /**
       * Retrieves the ratings that the authorized user gave to a list of specified videos.
       *
       * Create a request for the method "videos.getRating".
       *
       * This request holds the parameters needed by the the youtube server.  After setting any optional
       * parameters, call the {@link GetRating#execute()} method to invoke the remote operation. <p>
       * {@link
       * GetRating#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param id The id parameter specifies a comma-separated list of the YouTube video ID(s) for the resource(s) for
     *        which you are retrieving rating data. In a video resource, the id property specifies the
     *        video's ID.
       * @since 1.13
       */
      protected GetRating(java.lang.String id) {
        super(YouTube.this, "GET", REST_PATH, null, com.google.api.services.youtube.model.VideoGetRatingResponse.class);
        this.id = com.google.api.client.util.Preconditions.checkNotNull(id, "Required parameter id must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public GetRating setAlt(java.lang.String alt) {
        return (GetRating) super.setAlt(alt);
      }

      @Override
      public GetRating setFields(java.lang.String fields) {
        return (GetRating) super.setFields(fields);
      }

      @Override
      public GetRating setKey(java.lang.String key) {
        return (GetRating) super.setKey(key);
      }

      @Override
      public GetRating setOauthToken(java.lang.String oauthToken) {
        return (GetRating) super.setOauthToken(oauthToken);
      }

      @Override
      public GetRating setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (GetRating) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public GetRating setQuotaUser(java.lang.String quotaUser) {
        return (GetRating) super.setQuotaUser(quotaUser);
      }

      @Override
      public GetRating setUserIp(java.lang.String userIp) {
        return (GetRating) super.setUserIp(userIp);
      }

      /**
       * The id parameter specifies a comma-separated list of the YouTube video ID(s) for the
       * resource(s) for which you are retrieving rating data. In a video resource, the id property
       * specifies the video's ID.
       */
      @com.google.api.client.util.Key
      private java.lang.String id;

      /** The id parameter specifies a comma-separated list of the YouTube video ID(s) for the resource(s)
     for which you are retrieving rating data. In a video resource, the id property specifies the
     video's ID.
       */
      public java.lang.String getId() {
        return id;
      }

      /**
       * The id parameter specifies a comma-separated list of the YouTube video ID(s) for the
       * resource(s) for which you are retrieving rating data. In a video resource, the id property
       * specifies the video's ID.
       */
      public GetRating setId(java.lang.String id) {
        this.id = id;
        return this;
      }

      /**
       * Note: This parameter is intended exclusively for YouTube content partners.
       *
       * The onBehalfOfContentOwner parameter indicates that the request's authorization credentials
       * identify a YouTube CMS user who is acting on behalf of the content owner specified in the
       * parameter value. This parameter is intended for YouTube content partners that own and
       * manage many different YouTube channels. It allows content owners to authenticate once and
       * get access to all their video and channel data, without having to provide authentication
       * credentials for each individual channel. The CMS account that the user authenticates with
       * must be linked to the specified YouTube content owner.
       */
      @com.google.api.client.util.Key
      private java.lang.String onBehalfOfContentOwner;

      /** Note: This parameter is intended exclusively for YouTube content partners.

     The onBehalfOfContentOwner parameter indicates that the request's authorization credentials
     identify a YouTube CMS user who is acting on behalf of the content owner specified in the parameter
     value. This parameter is intended for YouTube content partners that own and manage many different
     YouTube channels. It allows content owners to authenticate once and get access to all their video
     and channel data, without having to provide authentication credentials for each individual channel.
     The CMS account that the user authenticates with must be linked to the specified YouTube content
     owner.
       */
      public java.lang.String getOnBehalfOfContentOwner() {
        return onBehalfOfContentOwner;
      }

      /**
       * Note: This parameter is intended exclusively for YouTube content partners.
       *
       * The onBehalfOfContentOwner parameter indicates that the request's authorization credentials
       * identify a YouTube CMS user who is acting on behalf of the content owner specified in the
       * parameter value. This parameter is intended for YouTube content partners that own and
       * manage many different YouTube channels. It allows content owners to authenticate once and
       * get access to all their video and channel data, without having to provide authentication
       * credentials for each individual channel. The CMS account that the user authenticates with
       * must be linked to the specified YouTube content owner.
       */
      public GetRating setOnBehalfOfContentOwner(java.lang.String onBehalfOfContentOwner) {
        this.onBehalfOfContentOwner = onBehalfOfContentOwner;
        return this;
      }

      @Override
      public GetRating set(String parameterName, Object value) {
        return (GetRating) super.set(parameterName, value);
      }
    }
    /**
     * Uploads a video to YouTube and optionally sets the video's metadata.
     *
     * Create a request for the method "videos.insert".
     *
     * This request holds the parameters needed by the youtube server.  After setting any optional
     * parameters, call the {@link Insert#execute()} method to invoke the remote operation.
     *
     * @param part The part parameter serves two purposes in this operation. It identifies the properties that the
     *        write operation will set as well as the properties that the API response will include.
     *        Note that not all parts contain properties that can be set when inserting or updating a
     *        video. For example, the statistics object encapsulates statistics that YouTube calculates
     *        for a video and does not contain values that you can set or modify. If the parameter value
     *        specifies a part that does not contain mutable values, that part will still be included in
     *        the API response.
     * @param content the {@link com.google.api.services.youtube.model.Video}
     * @return the request
     */
    public Insert insert(java.lang.String part, com.google.api.services.youtube.model.Video content) throws java.io.IOException {
      Insert result = new Insert(part, content);
      initialize(result);
      return result;
    }

    /**
     * Uploads a video to YouTube and optionally sets the video's metadata.
     *
     * Create a request for the method "videos.insert".
     *
     * This request holds the parameters needed by the the youtube server.  After setting any optional
     * parameters, call the {@link Insert#execute()} method to invoke the remote operation.
     *
     * <p>
     * This method should be used for uploading media content.
     * </p>
     *
     * @param part The part parameter serves two purposes in this operation. It identifies the properties that the
     *        write operation will set as well as the properties that the API response will include.
     *        Note that not all parts contain properties that can be set when inserting or updating a
     *        video. For example, the statistics object encapsulates statistics that YouTube calculates
     *        for a video and does not contain values that you can set or modify. If the parameter value
     *        specifies a part that does not contain mutable values, that part will still be included in
     *        the API response.
     * @param content the {@link com.google.api.services.youtube.model.Video} media metadata or {@code null} if none
     * @param mediaContent The media HTTP content or {@code null} if none.
     * @return the request
     * @throws java.io.IOException if the initialization of the request fails
     */
    public Insert insert(java.lang.String part, com.google.api.services.youtube.model.Video content, com.google.api.client.http.AbstractInputStreamContent mediaContent) throws java.io.IOException {
      Insert result = new Insert(part, content, mediaContent);
      initialize(result);
      return result;
    }

    public class Insert extends YouTubeRequest<com.google.api.services.youtube.model.Video> {

      private static final String REST_PATH = "videos";

      /**
       * Uploads a video to YouTube and optionally sets the video's metadata.
       *
       * Create a request for the method "videos.insert".
       *
       * This request holds the parameters needed by the the youtube server.  After setting any optional
       * parameters, call the {@link Insert#execute()} method to invoke the remote operation. <p> {@link
       * Insert#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param part The part parameter serves two purposes in this operation. It identifies the properties that the
     *        write operation will set as well as the properties that the API response will include.
     *        Note that not all parts contain properties that can be set when inserting or updating a
     *        video. For example, the statistics object encapsulates statistics that YouTube calculates
     *        for a video and does not contain values that you can set or modify. If the parameter value
     *        specifies a part that does not contain mutable values, that part will still be included in
     *        the API response.
       * @param content the {@link com.google.api.services.youtube.model.Video}
       * @since 1.13
       */
      protected Insert(java.lang.String part, com.google.api.services.youtube.model.Video content) {
        super(YouTube.this, "POST", REST_PATH, content, com.google.api.services.youtube.model.Video.class);
        this.part = com.google.api.client.util.Preconditions.checkNotNull(part, "Required parameter part must be specified.");
      }

      /**
       * Uploads a video to YouTube and optionally sets the video's metadata.
       *
       * Create a request for the method "videos.insert".
       *
       * This request holds the parameters needed by the the youtube server.  After setting any optional
       * parameters, call the {@link Insert#execute()} method to invoke the remote operation. <p> {@link
       * Insert#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * <p>
       * This constructor should be used for uploading media content.
       * </p>
       *
       * @param part The part parameter serves two purposes in this operation. It identifies the properties that the
     *        write operation will set as well as the properties that the API response will include.
     *        Note that not all parts contain properties that can be set when inserting or updating a
     *        video. For example, the statistics object encapsulates statistics that YouTube calculates
     *        for a video and does not contain values that you can set or modify. If the parameter value
     *        specifies a part that does not contain mutable values, that part will still be included in
     *        the API response.
       * @param content the {@link com.google.api.services.youtube.model.Video} media metadata or {@code null} if none
       * @param mediaContent The media HTTP content or {@code null} if none.
       * @since 1.13
       */
      protected Insert(java.lang.String part, com.google.api.services.youtube.model.Video content, com.google.api.client.http.AbstractInputStreamContent mediaContent) {
        super(YouTube.this, "POST", "/upload/" + getServicePath() + REST_PATH, content, com.google.api.services.youtube.model.Video.class);
        this.part = com.google.api.client.util.Preconditions.checkNotNull(part, "Required parameter part must be specified.");
        initializeMediaUpload(mediaContent);
      }

      @Override
      public Insert setAlt(java.lang.String alt) {
        return (Insert) super.setAlt(alt);
      }

      @Override
      public Insert setFields(java.lang.String fields) {
        return (Insert) super.setFields(fields);
      }

      @Override
      public Insert setKey(java.lang.String key) {
        return (Insert) super.setKey(key);
      }

      @Override
      public Insert setOauthToken(java.lang.String oauthToken) {
        return (Insert) super.setOauthToken(oauthToken);
      }

      @Override
      public Insert setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Insert) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Insert setQuotaUser(java.lang.String quotaUser) {
        return (Insert) super.setQuotaUser(quotaUser);
      }

      @Override
      public Insert setUserIp(java.lang.String userIp) {
        return (Insert) super.setUserIp(userIp);
      }

      /**
       * The part parameter serves two purposes in this operation. It identifies the properties that
       * the write operation will set as well as the properties that the API response will include.
       *
       * Note that not all parts contain properties that can be set when inserting or updating a
       * video. For example, the statistics object encapsulates statistics that YouTube calculates
       * for a video and does not contain values that you can set or modify. If the parameter value
       * specifies a part that does not contain mutable values, that part will still be included in
       * the API response.
       */
      @com.google.api.client.util.Key
      private java.lang.String part;

      /** The part parameter serves two purposes in this operation. It identifies the properties that the
     write operation will set as well as the properties that the API response will include.

     Note that not all parts contain properties that can be set when inserting or updating a video. For
     example, the statistics object encapsulates statistics that YouTube calculates for a video and does
     not contain values that you can set or modify. If the parameter value specifies a part that does
     not contain mutable values, that part will still be included in the API response.
       */
      public java.lang.String getPart() {
        return part;
      }

      /**
       * The part parameter serves two purposes in this operation. It identifies the properties that
       * the write operation will set as well as the properties that the API response will include.
       *
       * Note that not all parts contain properties that can be set when inserting or updating a
       * video. For example, the statistics object encapsulates statistics that YouTube calculates
       * for a video and does not contain values that you can set or modify. If the parameter value
       * specifies a part that does not contain mutable values, that part will still be included in
       * the API response.
       */
      public Insert setPart(java.lang.String part) {
        this.part = part;
        return this;
      }

      /**
       * The autoLevels parameter indicates whether YouTube should automatically enhance the video's
       * lighting and color.
       */
      @com.google.api.client.util.Key
      private java.lang.Boolean autoLevels;

      /** The autoLevels parameter indicates whether YouTube should automatically enhance the video's
     lighting and color.
       */
      public java.lang.Boolean getAutoLevels() {
        return autoLevels;
      }

      /**
       * The autoLevels parameter indicates whether YouTube should automatically enhance the video's
       * lighting and color.
       */
      public Insert setAutoLevels(java.lang.Boolean autoLevels) {
        this.autoLevels = autoLevels;
        return this;
      }

      /**
       * The notifySubscribers parameter indicates whether YouTube should send a notification about
       * the new video to users who subscribe to the video's channel. A parameter value of True
       * indicates that subscribers will be notified of newly uploaded videos. However, a channel
       * owner who is uploading many videos might prefer to set the value to False to avoid sending
       * a notification about each new video to the channel's subscribers.
       */
      @com.google.api.client.util.Key
      private java.lang.Boolean notifySubscribers;

      /** The notifySubscribers parameter indicates whether YouTube should send a notification about the new
     video to users who subscribe to the video's channel. A parameter value of True indicates that
     subscribers will be notified of newly uploaded videos. However, a channel owner who is uploading
     many videos might prefer to set the value to False to avoid sending a notification about each new
     video to the channel's subscribers. [default: true]
       */
      public java.lang.Boolean getNotifySubscribers() {
        return notifySubscribers;
      }

      /**
       * The notifySubscribers parameter indicates whether YouTube should send a notification about
       * the new video to users who subscribe to the video's channel. A parameter value of True
       * indicates that subscribers will be notified of newly uploaded videos. However, a channel
       * owner who is uploading many videos might prefer to set the value to False to avoid sending
       * a notification about each new video to the channel's subscribers.
       */
      public Insert setNotifySubscribers(java.lang.Boolean notifySubscribers) {
        this.notifySubscribers = notifySubscribers;
        return this;
      }

      /**
       * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
       *
       * <p>
       * Boolean properties can have four possible values:
       * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
       * or {@link Boolean#FALSE}.
       * </p>
       *
       * <p>
       * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
       * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
       * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * </p>
       *
       * <p>
       * The notifySubscribers parameter indicates whether YouTube should send a notification about the new
     video to users who subscribe to the video's channel. A parameter value of True indicates that
     subscribers will be notified of newly uploaded videos. However, a channel owner who is uploading
     many videos might prefer to set the value to False to avoid sending a notification about each new
     video to the channel's subscribers.
       * </p>
       */
      public boolean isNotifySubscribers() {
        if (notifySubscribers == null || notifySubscribers == com.google.api.client.util.Data.NULL_BOOLEAN) {
          return true;
        }
        return notifySubscribers;
      }

      /**
       * Note: This parameter is intended exclusively for YouTube content partners.
       *
       * The onBehalfOfContentOwner parameter indicates that the request's authorization credentials
       * identify a YouTube CMS user who is acting on behalf of the content owner specified in the
       * parameter value. This parameter is intended for YouTube content partners that own and
       * manage many different YouTube channels. It allows content owners to authenticate once and
       * get access to all their video and channel data, without having to provide authentication
       * credentials for each individual channel. The CMS account that the user authenticates with
       * must be linked to the specified YouTube content owner.
       */
      @com.google.api.client.util.Key
      private java.lang.String onBehalfOfContentOwner;

      /** Note: This parameter is intended exclusively for YouTube content partners.

     The onBehalfOfContentOwner parameter indicates that the request's authorization credentials
     identify a YouTube CMS user who is acting on behalf of the content owner specified in the parameter
     value. This parameter is intended for YouTube content partners that own and manage many different
     YouTube channels. It allows content owners to authenticate once and get access to all their video
     and channel data, without having to provide authentication credentials for each individual channel.
     The CMS account that the user authenticates with must be linked to the specified YouTube content
     owner.
       */
      public java.lang.String getOnBehalfOfContentOwner() {
        return onBehalfOfContentOwner;
      }

      /**
       * Note: This parameter is intended exclusively for YouTube content partners.
       *
       * The onBehalfOfContentOwner parameter indicates that the request's authorization credentials
       * identify a YouTube CMS user who is acting on behalf of the content owner specified in the
       * parameter value. This parameter is intended for YouTube content partners that own and
       * manage many different YouTube channels. It allows content owners to authenticate once and
       * get access to all their video and channel data, without having to provide authentication
       * credentials for each individual channel. The CMS account that the user authenticates with
       * must be linked to the specified YouTube content owner.
       */
      public Insert setOnBehalfOfContentOwner(java.lang.String onBehalfOfContentOwner) {
        this.onBehalfOfContentOwner = onBehalfOfContentOwner;
        return this;
      }

      /**
       * This parameter can only be used in a properly authorized request. Note: This parameter is
       * intended exclusively for YouTube content partners.
       *
       * The onBehalfOfContentOwnerChannel parameter specifies the YouTube channel ID of the channel
       * to which a video is being added. This parameter is required when a request specifies a
       * value for the onBehalfOfContentOwner parameter, and it can only be used in conjunction with
       * that parameter. In addition, the request must be authorized using a CMS account that is
       * linked to the content owner that the onBehalfOfContentOwner parameter specifies. Finally,
       * the channel that the onBehalfOfContentOwnerChannel parameter value specifies must be linked
       * to the content owner that the onBehalfOfContentOwner parameter specifies.
       *
       * This parameter is intended for YouTube content partners that own and manage many different
       * YouTube channels. It allows content owners to authenticate once and perform actions on
       * behalf of the channel specified in the parameter value, without having to provide
       * authentication credentials for each separate channel.
       */
      @com.google.api.client.util.Key
      private java.lang.String onBehalfOfContentOwnerChannel;

      /** This parameter can only be used in a properly authorized request. Note: This parameter is intended
     exclusively for YouTube content partners.

     The onBehalfOfContentOwnerChannel parameter specifies the YouTube channel ID of the channel to
     which a video is being added. This parameter is required when a request specifies a value for the
     onBehalfOfContentOwner parameter, and it can only be used in conjunction with that parameter. In
     addition, the request must be authorized using a CMS account that is linked to the content owner
     that the onBehalfOfContentOwner parameter specifies. Finally, the channel that the
     onBehalfOfContentOwnerChannel parameter value specifies must be linked to the content owner that
     the onBehalfOfContentOwner parameter specifies.

     This parameter is intended for YouTube content partners that own and manage many different YouTube
     channels. It allows content owners to authenticate once and perform actions on behalf of the
     channel specified in the parameter value, without having to provide authentication credentials for
     each separate channel.
       */
      public java.lang.String getOnBehalfOfContentOwnerChannel() {
        return onBehalfOfContentOwnerChannel;
      }

      /**
       * This parameter can only be used in a properly authorized request. Note: This parameter is
       * intended exclusively for YouTube content partners.
       *
       * The onBehalfOfContentOwnerChannel parameter specifies the YouTube channel ID of the channel
       * to which a video is being added. This parameter is required when a request specifies a
       * value for the onBehalfOfContentOwner parameter, and it can only be used in conjunction with
       * that parameter. In addition, the request must be authorized using a CMS account that is
       * linked to the content owner that the onBehalfOfContentOwner parameter specifies. Finally,
       * the channel that the onBehalfOfContentOwnerChannel parameter value specifies must be linked
       * to the content owner that the onBehalfOfContentOwner parameter specifies.
       *
       * This parameter is intended for YouTube content partners that own and manage many different
       * YouTube channels. It allows content owners to authenticate once and perform actions on
       * behalf of the channel specified in the parameter value, without having to provide
       * authentication credentials for each separate channel.
       */
      public Insert setOnBehalfOfContentOwnerChannel(java.lang.String onBehalfOfContentOwnerChannel) {
        this.onBehalfOfContentOwnerChannel = onBehalfOfContentOwnerChannel;
        return this;
      }

      /**
       * The stabilize parameter indicates whether YouTube should adjust the video to remove shaky
       * camera motions.
       */
      @com.google.api.client.util.Key
      private java.lang.Boolean stabilize;

      /** The stabilize parameter indicates whether YouTube should adjust the video to remove shaky camera
     motions.
       */
      public java.lang.Boolean getStabilize() {
        return stabilize;
      }

      /**
       * The stabilize parameter indicates whether YouTube should adjust the video to remove shaky
       * camera motions.
       */
      public Insert setStabilize(java.lang.Boolean stabilize) {
        this.stabilize = stabilize;
        return this;
      }

      @Override
      public Insert set(String parameterName, Object value) {
        return (Insert) super.set(parameterName, value);
      }
    }
    /**
     * Returns a list of videos that match the API request parameters.
     *
     * Create a request for the method "videos.list".
     *
     * This request holds the parameters needed by the youtube server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param part The part parameter specifies a comma-separated list of one or more video resource properties that
     *        the API response will include.
    If the parameter identifies a property that contains child
     *        properties, the child properties will be included in the response. For example, in a video
     *        resource, the snippet property contains the channelId, title, description, tags, and
     *        categoryId properties. As such, if you set part=snippet, the API response will contain all
     *        of those properties.
     * @return the request
     */
    public List list(java.lang.String part) throws java.io.IOException {
      List result = new List(part);
      initialize(result);
      return result;
    }

    public class List extends YouTubeRequest<com.google.api.services.youtube.model.VideoListResponse> {

      private static final String REST_PATH = "videos";

      /**
       * Returns a list of videos that match the API request parameters.
       *
       * Create a request for the method "videos.list".
       *
       * This request holds the parameters needed by the the youtube server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param part The part parameter specifies a comma-separated list of one or more video resource properties that
     *        the API response will include.
    If the parameter identifies a property that contains child
     *        properties, the child properties will be included in the response. For example, in a video
     *        resource, the snippet property contains the channelId, title, description, tags, and
     *        categoryId properties. As such, if you set part=snippet, the API response will contain all
     *        of those properties.
       * @since 1.13
       */
      protected List(java.lang.String part) {
        super(YouTube.this, "GET", REST_PATH, null, com.google.api.services.youtube.model.VideoListResponse.class);
        this.part = com.google.api.client.util.Preconditions.checkNotNull(part, "Required parameter part must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUserIp(java.lang.String userIp) {
        return (List) super.setUserIp(userIp);
      }

      /**
       * The part parameter specifies a comma-separated list of one or more video resource
       * properties that the API response will include.
       *
       * If the parameter identifies a property that contains child properties, the child properties
       * will be included in the response. For example, in a video resource, the snippet property
       * contains the channelId, title, description, tags, and categoryId properties. As such, if
       * you set part=snippet, the API response will contain all of those properties.
       */
      @com.google.api.client.util.Key
      private java.lang.String part;

      /** The part parameter specifies a comma-separated list of one or more video resource properties that
     the API response will include.

     If the parameter identifies a property that contains child properties, the child properties will be
     included in the response. For example, in a video resource, the snippet property contains the
     channelId, title, description, tags, and categoryId properties. As such, if you set part=snippet,
     the API response will contain all of those properties.
       */
      public java.lang.String getPart() {
        return part;
      }

      /**
       * The part parameter specifies a comma-separated list of one or more video resource
       * properties that the API response will include.
       *
       * If the parameter identifies a property that contains child properties, the child properties
       * will be included in the response. For example, in a video resource, the snippet property
       * contains the channelId, title, description, tags, and categoryId properties. As such, if
       * you set part=snippet, the API response will contain all of those properties.
       */
      public List setPart(java.lang.String part) {
        this.part = part;
        return this;
      }

      /** The chart parameter identifies the chart that you want to retrieve. */
      @com.google.api.client.util.Key
      private java.lang.String chart;

      /** The chart parameter identifies the chart that you want to retrieve.
       */
      public java.lang.String getChart() {
        return chart;
      }

      /** The chart parameter identifies the chart that you want to retrieve. */
      public List setChart(java.lang.String chart) {
        this.chart = chart;
        return this;
      }

      /**
       * The hl parameter instructs the API to retrieve localized resource metadata for a specific
       * application language that the YouTube website supports. The parameter value must be a
       * language code included in the list returned by the i18nLanguages.list method.
       *
       * If localized resource details are available in that language, the resource's
       * snippet.localized object will contain the localized values. However, if localized details
       * are not available, the snippet.localized object will contain resource details in the
       * resource's default language.
       */
      @com.google.api.client.util.Key
      private java.lang.String hl;

      /** The hl parameter instructs the API to retrieve localized resource metadata for a specific
     application language that the YouTube website supports. The parameter value must be a language code
     included in the list returned by the i18nLanguages.list method.

     If localized resource details are available in that language, the resource's snippet.localized
     object will contain the localized values. However, if localized details are not available, the
     snippet.localized object will contain resource details in the resource's default language.
       */
      public java.lang.String getHl() {
        return hl;
      }

      /**
       * The hl parameter instructs the API to retrieve localized resource metadata for a specific
       * application language that the YouTube website supports. The parameter value must be a
       * language code included in the list returned by the i18nLanguages.list method.
       *
       * If localized resource details are available in that language, the resource's
       * snippet.localized object will contain the localized values. However, if localized details
       * are not available, the snippet.localized object will contain resource details in the
       * resource's default language.
       */
      public List setHl(java.lang.String hl) {
        this.hl = hl;
        return this;
      }

      /**
       * The id parameter specifies a comma-separated list of the YouTube video ID(s) for the
       * resource(s) that are being retrieved. In a video resource, the id property specifies the
       * video's ID.
       */
      @com.google.api.client.util.Key
      private java.lang.String id;

      /** The id parameter specifies a comma-separated list of the YouTube video ID(s) for the resource(s)
     that are being retrieved. In a video resource, the id property specifies the video's ID.
       */
      public java.lang.String getId() {
        return id;
      }

      /**
       * The id parameter specifies a comma-separated list of the YouTube video ID(s) for the
       * resource(s) that are being retrieved. In a video resource, the id property specifies the
       * video's ID.
       */
      public List setId(java.lang.String id) {
        this.id = id;
        return this;
      }

      /** DEPRECATED */
      @com.google.api.client.util.Key
      private java.lang.String locale;

      /** DEPRECATED
       */
      public java.lang.String getLocale() {
        return locale;
      }

      /** DEPRECATED */
      public List setLocale(java.lang.String locale) {
        this.locale = locale;
        return this;
      }

      /**
       * The maxHeight parameter specifies a maximum height of the embedded player. If maxWidth is
       * provided, maxHeight may not be reached in order to not violate the width request.
       */
      @com.google.api.client.util.Key
      private java.lang.Long maxHeight;

      /** The maxHeight parameter specifies a maximum height of the embedded player. If maxWidth is provided,
     maxHeight may not be reached in order to not violate the width request.

     [minimum: 72] [maximum: 8192]
       */
      public java.lang.Long getMaxHeight() {
        return maxHeight;
      }

      /**
       * The maxHeight parameter specifies a maximum height of the embedded player. If maxWidth is
       * provided, maxHeight may not be reached in order to not violate the width request.
       */
      public List setMaxHeight(java.lang.Long maxHeight) {
        this.maxHeight = maxHeight;
        return this;
      }

      /**
       * The maxResults parameter specifies the maximum number of items that should be returned in
       * the result set.
       *
       * Note: This parameter is supported for use in conjunction with the myRating and chart
       * parameters, but it is not supported for use in conjunction with the id parameter.
       */
      @com.google.api.client.util.Key
      private java.lang.Long maxResults;

      /** The maxResults parameter specifies the maximum number of items that should be returned in the
     result set.

     Note: This parameter is supported for use in conjunction with the myRating and chart parameters,
     but it is not supported for use in conjunction with the id parameter. [default: 5] [minimum: 1]
     [maximum: 50]
       */
      public java.lang.Long getMaxResults() {
        return maxResults;
      }

      /**
       * The maxResults parameter specifies the maximum number of items that should be returned in
       * the result set.
       *
       * Note: This parameter is supported for use in conjunction with the myRating and chart
       * parameters, but it is not supported for use in conjunction with the id parameter.
       */
      public List setMaxResults(java.lang.Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      /**
       * The maxWidth parameter specifies a maximum width of the embedded player. If maxHeight is
       * provided, maxWidth may not be reached in order to not violate the height request.
       */
      @com.google.api.client.util.Key
      private java.lang.Long maxWidth;

      /** The maxWidth parameter specifies a maximum width of the embedded player. If maxHeight is provided,
     maxWidth may not be reached in order to not violate the height request.

     [minimum: 72] [maximum: 8192]
       */
      public java.lang.Long getMaxWidth() {
        return maxWidth;
      }

      /**
       * The maxWidth parameter specifies a maximum width of the embedded player. If maxHeight is
       * provided, maxWidth may not be reached in order to not violate the height request.
       */
      public List setMaxWidth(java.lang.Long maxWidth) {
        this.maxWidth = maxWidth;
        return this;
      }

      /**
       * Set this parameter's value to like or dislike to instruct the API to only return videos
       * liked or disliked by the authenticated user.
       */
      @com.google.api.client.util.Key
      private java.lang.String myRating;

      /** Set this parameter's value to like or dislike to instruct the API to only return videos liked or
     disliked by the authenticated user.
       */
      public java.lang.String getMyRating() {
        return myRating;
      }

      /**
       * Set this parameter's value to like or dislike to instruct the API to only return videos
       * liked or disliked by the authenticated user.
       */
      public List setMyRating(java.lang.String myRating) {
        this.myRating = myRating;
        return this;
      }

      /**
       * Note: This parameter is intended exclusively for YouTube content partners.
       *
       * The onBehalfOfContentOwner parameter indicates that the request's authorization credentials
       * identify a YouTube CMS user who is acting on behalf of the content owner specified in the
       * parameter value. This parameter is intended for YouTube content partners that own and
       * manage many different YouTube channels. It allows content owners to authenticate once and
       * get access to all their video and channel data, without having to provide authentication
       * credentials for each individual channel. The CMS account that the user authenticates with
       * must be linked to the specified YouTube content owner.
       */
      @com.google.api.client.util.Key
      private java.lang.String onBehalfOfContentOwner;

      /** Note: This parameter is intended exclusively for YouTube content partners.

     The onBehalfOfContentOwner parameter indicates that the request's authorization credentials
     identify a YouTube CMS user who is acting on behalf of the content owner specified in the parameter
     value. This parameter is intended for YouTube content partners that own and manage many different
     YouTube channels. It allows content owners to authenticate once and get access to all their video
     and channel data, without having to provide authentication credentials for each individual channel.
     The CMS account that the user authenticates with must be linked to the specified YouTube content
     owner.
       */
      public java.lang.String getOnBehalfOfContentOwner() {
        return onBehalfOfContentOwner;
      }

      /**
       * Note: This parameter is intended exclusively for YouTube content partners.
       *
       * The onBehalfOfContentOwner parameter indicates that the request's authorization credentials
       * identify a YouTube CMS user who is acting on behalf of the content owner specified in the
       * parameter value. This parameter is intended for YouTube content partners that own and
       * manage many different YouTube channels. It allows content owners to authenticate once and
       * get access to all their video and channel data, without having to provide authentication
       * credentials for each individual channel. The CMS account that the user authenticates with
       * must be linked to the specified YouTube content owner.
       */
      public List setOnBehalfOfContentOwner(java.lang.String onBehalfOfContentOwner) {
        this.onBehalfOfContentOwner = onBehalfOfContentOwner;
        return this;
      }

      /**
       * The pageToken parameter identifies a specific page in the result set that should be
       * returned. In an API response, the nextPageToken and prevPageToken properties identify other
       * pages that could be retrieved.
       *
       * Note: This parameter is supported for use in conjunction with the myRating and chart
       * parameters, but it is not supported for use in conjunction with the id parameter.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** The pageToken parameter identifies a specific page in the result set that should be returned. In an
     API response, the nextPageToken and prevPageToken properties identify other pages that could be
     retrieved.

     Note: This parameter is supported for use in conjunction with the myRating and chart parameters,
     but it is not supported for use in conjunction with the id parameter.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * The pageToken parameter identifies a specific page in the result set that should be
       * returned. In an API response, the nextPageToken and prevPageToken properties identify other
       * pages that could be retrieved.
       *
       * Note: This parameter is supported for use in conjunction with the myRating and chart
       * parameters, but it is not supported for use in conjunction with the id parameter.
       */
      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      /**
       * The regionCode parameter instructs the API to select a video chart available in the
       * specified region. This parameter can only be used in conjunction with the chart parameter.
       * The parameter value is an ISO 3166-1 alpha-2 country code.
       */
      @com.google.api.client.util.Key
      private java.lang.String regionCode;

      /** The regionCode parameter instructs the API to select a video chart available in the specified
     region. This parameter can only be used in conjunction with the chart parameter. The parameter
     value is an ISO 3166-1 alpha-2 country code.
       */
      public java.lang.String getRegionCode() {
        return regionCode;
      }

      /**
       * The regionCode parameter instructs the API to select a video chart available in the
       * specified region. This parameter can only be used in conjunction with the chart parameter.
       * The parameter value is an ISO 3166-1 alpha-2 country code.
       */
      public List setRegionCode(java.lang.String regionCode) {
        this.regionCode = regionCode;
        return this;
      }

      /**
       * The videoCategoryId parameter identifies the video category for which the chart should be
       * retrieved. This parameter can only be used in conjunction with the chart parameter. By
       * default, charts are not restricted to a particular category.
       */
      @com.google.api.client.util.Key
      private java.lang.String videoCategoryId;

      /** The videoCategoryId parameter identifies the video category for which the chart should be
     retrieved. This parameter can only be used in conjunction with the chart parameter. By default,
     charts are not restricted to a particular category. [default: 0]
       */
      public java.lang.String getVideoCategoryId() {
        return videoCategoryId;
      }

      /**
       * The videoCategoryId parameter identifies the video category for which the chart should be
       * retrieved. This parameter can only be used in conjunction with the chart parameter. By
       * default, charts are not restricted to a particular category.
       */
      public List setVideoCategoryId(java.lang.String videoCategoryId) {
        this.videoCategoryId = videoCategoryId;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }
    /**
     * Add a like or dislike rating to a video or remove a rating from a video.
     *
     * Create a request for the method "videos.rate".
     *
     * This request holds the parameters needed by the youtube server.  After setting any optional
     * parameters, call the {@link Rate#execute()} method to invoke the remote operation.
     *
     * @param id The id parameter specifies the YouTube video ID of the video that is being rated or having its
     *        rating removed.
     * @param rating Specifies the rating to record.
     * @return the request
     */
    public Rate rate(java.lang.String id, java.lang.String rating) throws java.io.IOException {
      Rate result = new Rate(id, rating);
      initialize(result);
      return result;
    }

    public class Rate extends YouTubeRequest<Void> {

      private static final String REST_PATH = "videos/rate";

      /**
       * Add a like or dislike rating to a video or remove a rating from a video.
       *
       * Create a request for the method "videos.rate".
       *
       * This request holds the parameters needed by the the youtube server.  After setting any optional
       * parameters, call the {@link Rate#execute()} method to invoke the remote operation. <p> {@link
       * Rate#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param id The id parameter specifies the YouTube video ID of the video that is being rated or having its
     *        rating removed.
       * @param rating Specifies the rating to record.
       * @since 1.13
       */
      protected Rate(java.lang.String id, java.lang.String rating) {
        super(YouTube.this, "POST", REST_PATH, null, Void.class);
        this.id = com.google.api.client.util.Preconditions.checkNotNull(id, "Required parameter id must be specified.");
        this.rating = com.google.api.client.util.Preconditions.checkNotNull(rating, "Required parameter rating must be specified.");
      }

      @Override
      public Rate setAlt(java.lang.String alt) {
        return (Rate) super.setAlt(alt);
      }

      @Override
      public Rate setFields(java.lang.String fields) {
        return (Rate) super.setFields(fields);
      }

      @Override
      public Rate setKey(java.lang.String key) {
        return (Rate) super.setKey(key);
      }

      @Override
      public Rate setOauthToken(java.lang.String oauthToken) {
        return (Rate) super.setOauthToken(oauthToken);
      }

      @Override
      public Rate setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Rate) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Rate setQuotaUser(java.lang.String quotaUser) {
        return (Rate) super.setQuotaUser(quotaUser);
      }

      @Override
      public Rate setUserIp(java.lang.String userIp) {
        return (Rate) super.setUserIp(userIp);
      }

      /**
       * The id parameter specifies the YouTube video ID of the video that is being rated or having
       * its rating removed.
       */
      @com.google.api.client.util.Key
      private java.lang.String id;

      /** The id parameter specifies the YouTube video ID of the video that is being rated or having its
     rating removed.
       */
      public java.lang.String getId() {
        return id;
      }

      /**
       * The id parameter specifies the YouTube video ID of the video that is being rated or having
       * its rating removed.
       */
      public Rate setId(java.lang.String id) {
        this.id = id;
        return this;
      }

      /** Specifies the rating to record. */
      @com.google.api.client.util.Key
      private java.lang.String rating;

      /** Specifies the rating to record.
       */
      public java.lang.String getRating() {
        return rating;
      }

      /** Specifies the rating to record. */
      public Rate setRating(java.lang.String rating) {
        this.rating = rating;
        return this;
      }

      @Override
      public Rate set(String parameterName, Object value) {
        return (Rate) super.set(parameterName, value);
      }
    }
    /**
     * Report abuse for a video.
     *
     * Create a request for the method "videos.reportAbuse".
     *
     * This request holds the parameters needed by the youtube server.  After setting any optional
     * parameters, call the {@link ReportAbuse#execute()} method to invoke the remote operation.
     *
     * @param content the {@link com.google.api.services.youtube.model.VideoAbuseReport}
     * @return the request
     */
    public ReportAbuse reportAbuse(com.google.api.services.youtube.model.VideoAbuseReport content) throws java.io.IOException {
      ReportAbuse result = new ReportAbuse(content);
      initialize(result);
      return result;
    }

    public class ReportAbuse extends YouTubeRequest<Void> {

      private static final String REST_PATH = "videos/reportAbuse";

      /**
       * Report abuse for a video.
       *
       * Create a request for the method "videos.reportAbuse".
       *
       * This request holds the parameters needed by the the youtube server.  After setting any optional
       * parameters, call the {@link ReportAbuse#execute()} method to invoke the remote operation. <p>
       * {@link
       * ReportAbuse#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param content the {@link com.google.api.services.youtube.model.VideoAbuseReport}
       * @since 1.13
       */
      protected ReportAbuse(com.google.api.services.youtube.model.VideoAbuseReport content) {
        super(YouTube.this, "POST", REST_PATH, content, Void.class);
      }

      @Override
      public ReportAbuse setAlt(java.lang.String alt) {
        return (ReportAbuse) super.setAlt(alt);
      }

      @Override
      public ReportAbuse setFields(java.lang.String fields) {
        return (ReportAbuse) super.setFields(fields);
      }

      @Override
      public ReportAbuse setKey(java.lang.String key) {
        return (ReportAbuse) super.setKey(key);
      }

      @Override
      public ReportAbuse setOauthToken(java.lang.String oauthToken) {
        return (ReportAbuse) super.setOauthToken(oauthToken);
      }

      @Override
      public ReportAbuse setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (ReportAbuse) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public ReportAbuse setQuotaUser(java.lang.String quotaUser) {
        return (ReportAbuse) super.setQuotaUser(quotaUser);
      }

      @Override
      public ReportAbuse setUserIp(java.lang.String userIp) {
        return (ReportAbuse) super.setUserIp(userIp);
      }

      /**
       * Note: This parameter is intended exclusively for YouTube content partners.
       *
       * The onBehalfOfContentOwner parameter indicates that the request's authorization credentials
       * identify a YouTube CMS user who is acting on behalf of the content owner specified in the
       * parameter value. This parameter is intended for YouTube content partners that own and
       * manage many different YouTube channels. It allows content owners to authenticate once and
       * get access to all their video and channel data, without having to provide authentication
       * credentials for each individual channel. The CMS account that the user authenticates with
       * must be linked to the specified YouTube content owner.
       */
      @com.google.api.client.util.Key
      private java.lang.String onBehalfOfContentOwner;

      /** Note: This parameter is intended exclusively for YouTube content partners.

     The onBehalfOfContentOwner parameter indicates that the request's authorization credentials
     identify a YouTube CMS user who is acting on behalf of the content owner specified in the parameter
     value. This parameter is intended for YouTube content partners that own and manage many different
     YouTube channels. It allows content owners to authenticate once and get access to all their video
     and channel data, without having to provide authentication credentials for each individual channel.
     The CMS account that the user authenticates with must be linked to the specified YouTube content
     owner.
       */
      public java.lang.String getOnBehalfOfContentOwner() {
        return onBehalfOfContentOwner;
      }

      /**
       * Note: This parameter is intended exclusively for YouTube content partners.
       *
       * The onBehalfOfContentOwner parameter indicates that the request's authorization credentials
       * identify a YouTube CMS user who is acting on behalf of the content owner specified in the
       * parameter value. This parameter is intended for YouTube content partners that own and
       * manage many different YouTube channels. It allows content owners to authenticate once and
       * get access to all their video and channel data, without having to provide authentication
       * credentials for each individual channel. The CMS account that the user authenticates with
       * must be linked to the specified YouTube content owner.
       */
      public ReportAbuse setOnBehalfOfContentOwner(java.lang.String onBehalfOfContentOwner) {
        this.onBehalfOfContentOwner = onBehalfOfContentOwner;
        return this;
      }

      @Override
      public ReportAbuse set(String parameterName, Object value) {
        return (ReportAbuse) super.set(parameterName, value);
      }
    }
    /**
     * Updates a video's metadata.
     *
     * Create a request for the method "videos.update".
     *
     * This request holds the parameters needed by the youtube server.  After setting any optional
     * parameters, call the {@link Update#execute()} method to invoke the remote operation.
     *
     * @param part The part parameter serves two purposes in this operation. It identifies the properties that the
     *        write operation will set as well as the properties that the API response will include.
     *        Note that this method will override the existing values for all of the mutable properties
     *        that are contained in any parts that the parameter value specifies. For example, a video's
     *        privacy setting is contained in the status part. As such, if your request is updating a
     *        private video, and the request's part parameter value includes the status part, the
     *        video's privacy setting will be updated to whatever value the request body specifies. If
     *        the request body does not specify a value, the existing privacy setting will be removed
     *        and the video will revert to the default privacy setting.
    In addition, not all parts
     *        contain properties that can be set when inserting or updating a video. For example, the
     *        statistics object encapsulates statistics that YouTube calculates for a video and does not
     *        contain values that you can set or modify. If the parameter value specifies a part that
     *        does not contain mutable values, that part will still be included in the API response.
     * @param content the {@link com.google.api.services.youtube.model.Video}
     * @return the request
     */
    public Update update(java.lang.String part, com.google.api.services.youtube.model.Video content) throws java.io.IOException {
      Update result = new Update(part, content);
      initialize(result);
      return result;
    }

    public class Update extends YouTubeRequest<com.google.api.services.youtube.model.Video> {

      private static final String REST_PATH = "videos";

      /**
       * Updates a video's metadata.
       *
       * Create a request for the method "videos.update".
       *
       * This request holds the parameters needed by the the youtube server.  After setting any optional
       * parameters, call the {@link Update#execute()} method to invoke the remote operation. <p> {@link
       * Update#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param part The part parameter serves two purposes in this operation. It identifies the properties that the
     *        write operation will set as well as the properties that the API response will include.
     *        Note that this method will override the existing values for all of the mutable properties
     *        that are contained in any parts that the parameter value specifies. For example, a video's
     *        privacy setting is contained in the status part. As such, if your request is updating a
     *        private video, and the request's part parameter value includes the status part, the
     *        video's privacy setting will be updated to whatever value the request body specifies. If
     *        the request body does not specify a value, the existing privacy setting will be removed
     *        and the video will revert to the default privacy setting.
    In addition, not all parts
     *        contain properties that can be set when inserting or updating a video. For example, the
     *        statistics object encapsulates statistics that YouTube calculates for a video and does not
     *        contain values that you can set or modify. If the parameter value specifies a part that
     *        does not contain mutable values, that part will still be included in the API response.
       * @param content the {@link com.google.api.services.youtube.model.Video}
       * @since 1.13
       */
      protected Update(java.lang.String part, com.google.api.services.youtube.model.Video content) {
        super(YouTube.this, "PUT", REST_PATH, content, com.google.api.services.youtube.model.Video.class);
        this.part = com.google.api.client.util.Preconditions.checkNotNull(part, "Required parameter part must be specified.");
        checkRequiredParameter(content, "content");
        checkRequiredParameter(content.getId(), "Video.getId()");
      }

      @Override
      public Update setAlt(java.lang.String alt) {
        return (Update) super.setAlt(alt);
      }

      @Override
      public Update setFields(java.lang.String fields) {
        return (Update) super.setFields(fields);
      }

      @Override
      public Update setKey(java.lang.String key) {
        return (Update) super.setKey(key);
      }

      @Override
      public Update setOauthToken(java.lang.String oauthToken) {
        return (Update) super.setOauthToken(oauthToken);
      }

      @Override
      public Update setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Update) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Update setQuotaUser(java.lang.String quotaUser) {
        return (Update) super.setQuotaUser(quotaUser);
      }

      @Override
      public Update setUserIp(java.lang.String userIp) {
        return (Update) super.setUserIp(userIp);
      }

      /**
       * The part parameter serves two purposes in this operation. It identifies the properties that
       * the write operation will set as well as the properties that the API response will include.
       *
       * Note that this method will override the existing values for all of the mutable properties
       * that are contained in any parts that the parameter value specifies. For example, a video's
       * privacy setting is contained in the status part. As such, if your request is updating a
       * private video, and the request's part parameter value includes the status part, the video's
       * privacy setting will be updated to whatever value the request body specifies. If the
       * request body does not specify a value, the existing privacy setting will be removed and the
       * video will revert to the default privacy setting.
       *
       * In addition, not all parts contain properties that can be set when inserting or updating a
       * video. For example, the statistics object encapsulates statistics that YouTube calculates
       * for a video and does not contain values that you can set or modify. If the parameter value
       * specifies a part that does not contain mutable values, that part will still be included in
       * the API response.
       */
      @com.google.api.client.util.Key
      private java.lang.String part;

      /** The part parameter serves two purposes in this operation. It identifies the properties that the
     write operation will set as well as the properties that the API response will include.

     Note that this method will override the existing values for all of the mutable properties that are
     contained in any parts that the parameter value specifies. For example, a video's privacy setting
     is contained in the status part. As such, if your request is updating a private video, and the
     request's part parameter value includes the status part, the video's privacy setting will be
     updated to whatever value the request body specifies. If the request body does not specify a value,
     the existing privacy setting will be removed and the video will revert to the default privacy
     setting.

     In addition, not all parts contain properties that can be set when inserting or updating a video.
     For example, the statistics object encapsulates statistics that YouTube calculates for a video and
     does not contain values that you can set or modify. If the parameter value specifies a part that
     does not contain mutable values, that part will still be included in the API response.
       */
      public java.lang.String getPart() {
        return part;
      }

      /**
       * The part parameter serves two purposes in this operation. It identifies the properties that
       * the write operation will set as well as the properties that the API response will include.
       *
       * Note that this method will override the existing values for all of the mutable properties
       * that are contained in any parts that the parameter value specifies. For example, a video's
       * privacy setting is contained in the status part. As such, if your request is updating a
       * private video, and the request's part parameter value includes the status part, the video's
       * privacy setting will be updated to whatever value the request body specifies. If the
       * request body does not specify a value, the existing privacy setting will be removed and the
       * video will revert to the default privacy setting.
       *
       * In addition, not all parts contain properties that can be set when inserting or updating a
       * video. For example, the statistics object encapsulates statistics that YouTube calculates
       * for a video and does not contain values that you can set or modify. If the parameter value
       * specifies a part that does not contain mutable values, that part will still be included in
       * the API response.
       */
      public Update setPart(java.lang.String part) {
        this.part = part;
        return this;
      }

      /**
       * Note: This parameter is intended exclusively for YouTube content partners.
       *
       * The onBehalfOfContentOwner parameter indicates that the request's authorization credentials
       * identify a YouTube CMS user who is acting on behalf of the content owner specified in the
       * parameter value. This parameter is intended for YouTube content partners that own and
       * manage many different YouTube channels. It allows content owners to authenticate once and
       * get access to all their video and channel data, without having to provide authentication
       * credentials for each individual channel. The actual CMS account that the user authenticates
       * with must be linked to the specified YouTube content owner.
       */
      @com.google.api.client.util.Key
      private java.lang.String onBehalfOfContentOwner;

      /** Note: This parameter is intended exclusively for YouTube content partners.

     The onBehalfOfContentOwner parameter indicates that the request's authorization credentials
     identify a YouTube CMS user who is acting on behalf of the content owner specified in the parameter
     value. This parameter is intended for YouTube content partners that own and manage many different
     YouTube channels. It allows content owners to authenticate once and get access to all their video
     and channel data, without having to provide authentication credentials for each individual channel.
     The actual CMS account that the user authenticates with must be linked to the specified YouTube
     content owner.
       */
      public java.lang.String getOnBehalfOfContentOwner() {
        return onBehalfOfContentOwner;
      }

      /**
       * Note: This parameter is intended exclusively for YouTube content partners.
       *
       * The onBehalfOfContentOwner parameter indicates that the request's authorization credentials
       * identify a YouTube CMS user who is acting on behalf of the content owner specified in the
       * parameter value. This parameter is intended for YouTube content partners that own and
       * manage many different YouTube channels. It allows content owners to authenticate once and
       * get access to all their video and channel data, without having to provide authentication
       * credentials for each individual channel. The actual CMS account that the user authenticates
       * with must be linked to the specified YouTube content owner.
       */
      public Update setOnBehalfOfContentOwner(java.lang.String onBehalfOfContentOwner) {
        this.onBehalfOfContentOwner = onBehalfOfContentOwner;
        return this;
      }

      @Override
      public Update set(String parameterName, Object value) {
        return (Update) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the Watermarks collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code YouTube youtube = new YouTube(...);}
   *   {@code YouTube.Watermarks.List request = youtube.watermarks().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Watermarks watermarks() {
    return new Watermarks();
  }

  /**
   * The "watermarks" collection of methods.
   */
  public class Watermarks {

    /**
     * Uploads a watermark image to YouTube and sets it for a channel.
     *
     * Create a request for the method "watermarks.set".
     *
     * This request holds the parameters needed by the youtube server.  After setting any optional
     * parameters, call the {@link Set#execute()} method to invoke the remote operation.
     *
     * @param channelId The channelId parameter specifies the YouTube channel ID for which the watermark is being provided.
     * @param content the {@link com.google.api.services.youtube.model.InvideoBranding}
     * @return the request
     */
    public Set set(java.lang.String channelId, com.google.api.services.youtube.model.InvideoBranding content) throws java.io.IOException {
      Set result = new Set(channelId, content);
      initialize(result);
      return result;
    }

    /**
     * Uploads a watermark image to YouTube and sets it for a channel.
     *
     * Create a request for the method "watermarks.set".
     *
     * This request holds the parameters needed by the the youtube server.  After setting any optional
     * parameters, call the {@link Set#execute()} method to invoke the remote operation.
     *
     * <p>
     * This method should be used for uploading media content.
     * </p>
     *
     * @param channelId The channelId parameter specifies the YouTube channel ID for which the watermark is being provided.
     * @param content the {@link com.google.api.services.youtube.model.InvideoBranding} media metadata or {@code null} if none
     * @param mediaContent The media HTTP content or {@code null} if none.
     * @return the request
     * @throws java.io.IOException if the initialization of the request fails
     */
    public Set set(java.lang.String channelId, com.google.api.services.youtube.model.InvideoBranding content, com.google.api.client.http.AbstractInputStreamContent mediaContent) throws java.io.IOException {
      Set result = new Set(channelId, content, mediaContent);
      initialize(result);
      return result;
    }

    public class Set extends YouTubeRequest<Void> {

      private static final String REST_PATH = "watermarks/set";

      /**
       * Uploads a watermark image to YouTube and sets it for a channel.
       *
       * Create a request for the method "watermarks.set".
       *
       * This request holds the parameters needed by the the youtube server.  After setting any optional
       * parameters, call the {@link Set#execute()} method to invoke the remote operation. <p> {@link
       * Set#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param channelId The channelId parameter specifies the YouTube channel ID for which the watermark is being provided.
       * @param content the {@link com.google.api.services.youtube.model.InvideoBranding}
       * @since 1.13
       */
      protected Set(java.lang.String channelId, com.google.api.services.youtube.model.InvideoBranding content) {
        super(YouTube.this, "POST", REST_PATH, content, Void.class);
        this.channelId = com.google.api.client.util.Preconditions.checkNotNull(channelId, "Required parameter channelId must be specified.");
      }

      /**
       * Uploads a watermark image to YouTube and sets it for a channel.
       *
       * Create a request for the method "watermarks.set".
       *
       * This request holds the parameters needed by the the youtube server.  After setting any optional
       * parameters, call the {@link Set#execute()} method to invoke the remote operation. <p> {@link
       * Set#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * <p>
       * This constructor should be used for uploading media content.
       * </p>
       *
       * @param channelId The channelId parameter specifies the YouTube channel ID for which the watermark is being provided.
       * @param content the {@link com.google.api.services.youtube.model.InvideoBranding} media metadata or {@code null} if none
       * @param mediaContent The media HTTP content or {@code null} if none.
       * @since 1.13
       */
      protected Set(java.lang.String channelId, com.google.api.services.youtube.model.InvideoBranding content, com.google.api.client.http.AbstractInputStreamContent mediaContent) {
        super(YouTube.this, "POST", "/upload/" + getServicePath() + REST_PATH, content, Void.class);
        this.channelId = com.google.api.client.util.Preconditions.checkNotNull(channelId, "Required parameter channelId must be specified.");
        initializeMediaUpload(mediaContent);
      }

      @Override
      public Set setAlt(java.lang.String alt) {
        return (Set) super.setAlt(alt);
      }

      @Override
      public Set setFields(java.lang.String fields) {
        return (Set) super.setFields(fields);
      }

      @Override
      public Set setKey(java.lang.String key) {
        return (Set) super.setKey(key);
      }

      @Override
      public Set setOauthToken(java.lang.String oauthToken) {
        return (Set) super.setOauthToken(oauthToken);
      }

      @Override
      public Set setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Set) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Set setQuotaUser(java.lang.String quotaUser) {
        return (Set) super.setQuotaUser(quotaUser);
      }

      @Override
      public Set setUserIp(java.lang.String userIp) {
        return (Set) super.setUserIp(userIp);
      }

      /**
       * The channelId parameter specifies the YouTube channel ID for which the watermark is being
       * provided.
       */
      @com.google.api.client.util.Key
      private java.lang.String channelId;

      /** The channelId parameter specifies the YouTube channel ID for which the watermark is being provided.
       */
      public java.lang.String getChannelId() {
        return channelId;
      }

      /**
       * The channelId parameter specifies the YouTube channel ID for which the watermark is being
       * provided.
       */
      public Set setChannelId(java.lang.String channelId) {
        this.channelId = channelId;
        return this;
      }

      /**
       * Note: This parameter is intended exclusively for YouTube content partners.
       *
       * The onBehalfOfContentOwner parameter indicates that the request's authorization credentials
       * identify a YouTube CMS user who is acting on behalf of the content owner specified in the
       * parameter value. This parameter is intended for YouTube content partners that own and
       * manage many different YouTube channels. It allows content owners to authenticate once and
       * get access to all their video and channel data, without having to provide authentication
       * credentials for each individual channel. The CMS account that the user authenticates with
       * must be linked to the specified YouTube content owner.
       */
      @com.google.api.client.util.Key
      private java.lang.String onBehalfOfContentOwner;

      /** Note: This parameter is intended exclusively for YouTube content partners.

     The onBehalfOfContentOwner parameter indicates that the request's authorization credentials
     identify a YouTube CMS user who is acting on behalf of the content owner specified in the parameter
     value. This parameter is intended for YouTube content partners that own and manage many different
     YouTube channels. It allows content owners to authenticate once and get access to all their video
     and channel data, without having to provide authentication credentials for each individual channel.
     The CMS account that the user authenticates with must be linked to the specified YouTube content
     owner.
       */
      public java.lang.String getOnBehalfOfContentOwner() {
        return onBehalfOfContentOwner;
      }

      /**
       * Note: This parameter is intended exclusively for YouTube content partners.
       *
       * The onBehalfOfContentOwner parameter indicates that the request's authorization credentials
       * identify a YouTube CMS user who is acting on behalf of the content owner specified in the
       * parameter value. This parameter is intended for YouTube content partners that own and
       * manage many different YouTube channels. It allows content owners to authenticate once and
       * get access to all their video and channel data, without having to provide authentication
       * credentials for each individual channel. The CMS account that the user authenticates with
       * must be linked to the specified YouTube content owner.
       */
      public Set setOnBehalfOfContentOwner(java.lang.String onBehalfOfContentOwner) {
        this.onBehalfOfContentOwner = onBehalfOfContentOwner;
        return this;
      }

      @Override
      public Set set(String parameterName, Object value) {
        return (Set) super.set(parameterName, value);
      }
    }
    /**
     * Deletes a channel's watermark image.
     *
     * Create a request for the method "watermarks.unset".
     *
     * This request holds the parameters needed by the youtube server.  After setting any optional
     * parameters, call the {@link Unset#execute()} method to invoke the remote operation.
     *
     * @param channelId The channelId parameter specifies the YouTube channel ID for which the watermark is being unset.
     * @return the request
     */
    public Unset unset(java.lang.String channelId) throws java.io.IOException {
      Unset result = new Unset(channelId);
      initialize(result);
      return result;
    }

    public class Unset extends YouTubeRequest<Void> {

      private static final String REST_PATH = "watermarks/unset";

      /**
       * Deletes a channel's watermark image.
       *
       * Create a request for the method "watermarks.unset".
       *
       * This request holds the parameters needed by the the youtube server.  After setting any optional
       * parameters, call the {@link Unset#execute()} method to invoke the remote operation. <p> {@link
       * Unset#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param channelId The channelId parameter specifies the YouTube channel ID for which the watermark is being unset.
       * @since 1.13
       */
      protected Unset(java.lang.String channelId) {
        super(YouTube.this, "POST", REST_PATH, null, Void.class);
        this.channelId = com.google.api.client.util.Preconditions.checkNotNull(channelId, "Required parameter channelId must be specified.");
      }

      @Override
      public Unset setAlt(java.lang.String alt) {
        return (Unset) super.setAlt(alt);
      }

      @Override
      public Unset setFields(java.lang.String fields) {
        return (Unset) super.setFields(fields);
      }

      @Override
      public Unset setKey(java.lang.String key) {
        return (Unset) super.setKey(key);
      }

      @Override
      public Unset setOauthToken(java.lang.String oauthToken) {
        return (Unset) super.setOauthToken(oauthToken);
      }

      @Override
      public Unset setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Unset) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Unset setQuotaUser(java.lang.String quotaUser) {
        return (Unset) super.setQuotaUser(quotaUser);
      }

      @Override
      public Unset setUserIp(java.lang.String userIp) {
        return (Unset) super.setUserIp(userIp);
      }

      /**
       * The channelId parameter specifies the YouTube channel ID for which the watermark is being
       * unset.
       */
      @com.google.api.client.util.Key
      private java.lang.String channelId;

      /** The channelId parameter specifies the YouTube channel ID for which the watermark is being unset.
       */
      public java.lang.String getChannelId() {
        return channelId;
      }

      /**
       * The channelId parameter specifies the YouTube channel ID for which the watermark is being
       * unset.
       */
      public Unset setChannelId(java.lang.String channelId) {
        this.channelId = channelId;
        return this;
      }

      /**
       * Note: This parameter is intended exclusively for YouTube content partners.
       *
       * The onBehalfOfContentOwner parameter indicates that the request's authorization credentials
       * identify a YouTube CMS user who is acting on behalf of the content owner specified in the
       * parameter value. This parameter is intended for YouTube content partners that own and
       * manage many different YouTube channels. It allows content owners to authenticate once and
       * get access to all their video and channel data, without having to provide authentication
       * credentials for each individual channel. The CMS account that the user authenticates with
       * must be linked to the specified YouTube content owner.
       */
      @com.google.api.client.util.Key
      private java.lang.String onBehalfOfContentOwner;

      /** Note: This parameter is intended exclusively for YouTube content partners.

     The onBehalfOfContentOwner parameter indicates that the request's authorization credentials
     identify a YouTube CMS user who is acting on behalf of the content owner specified in the parameter
     value. This parameter is intended for YouTube content partners that own and manage many different
     YouTube channels. It allows content owners to authenticate once and get access to all their video
     and channel data, without having to provide authentication credentials for each individual channel.
     The CMS account that the user authenticates with must be linked to the specified YouTube content
     owner.
       */
      public java.lang.String getOnBehalfOfContentOwner() {
        return onBehalfOfContentOwner;
      }

      /**
       * Note: This parameter is intended exclusively for YouTube content partners.
       *
       * The onBehalfOfContentOwner parameter indicates that the request's authorization credentials
       * identify a YouTube CMS user who is acting on behalf of the content owner specified in the
       * parameter value. This parameter is intended for YouTube content partners that own and
       * manage many different YouTube channels. It allows content owners to authenticate once and
       * get access to all their video and channel data, without having to provide authentication
       * credentials for each individual channel. The CMS account that the user authenticates with
       * must be linked to the specified YouTube content owner.
       */
      public Unset setOnBehalfOfContentOwner(java.lang.String onBehalfOfContentOwner) {
        this.onBehalfOfContentOwner = onBehalfOfContentOwner;
        return this;
      }

      @Override
      public Unset set(String parameterName, Object value) {
        return (Unset) super.set(parameterName, value);
      }
    }

  }

  /**
   * Builder for {@link YouTube}.
   *
   * <p>
   * Implementation is not thread-safe.
   * </p>
   *
   * @since 1.3.0
   */
  public static final class Builder extends com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient.Builder {

    /**
     * Returns an instance of a new builder.
     *
     * @param transport HTTP transport, which should normally be:
     *        <ul>
     *        <li>Google App Engine:
     *        {@code com.google.api.client.extensions.appengine.http.UrlFetchTransport}</li>
     *        <li>Android: {@code newCompatibleTransport} from
     *        {@code com.google.api.client.extensions.android.http.AndroidHttp}</li>
     *        <li>Java: {@link com.google.api.client.googleapis.javanet.GoogleNetHttpTransport#newTrustedTransport()}
     *        </li>
     *        </ul>
     * @param jsonFactory JSON factory, which may be:
     *        <ul>
     *        <li>Jackson: {@code com.google.api.client.json.jackson2.JacksonFactory}</li>
     *        <li>Google GSON: {@code com.google.api.client.json.gson.GsonFactory}</li>
     *        <li>Android Honeycomb or higher:
     *        {@code com.google.api.client.extensions.android.json.AndroidJsonFactory}</li>
     *        </ul>
     * @param httpRequestInitializer HTTP request initializer or {@code null} for none
     * @since 1.7
     */
    public Builder(com.google.api.client.http.HttpTransport transport, com.google.api.client.json.JsonFactory jsonFactory,
        com.google.api.client.http.HttpRequestInitializer httpRequestInitializer) {
      super(
          transport,
          jsonFactory,
          DEFAULT_ROOT_URL,
          DEFAULT_SERVICE_PATH,
          httpRequestInitializer,
          false);
      setBatchPath(DEFAULT_BATCH_PATH);
    }

    /** Builds a new instance of {@link YouTube}. */
    @Override
    public YouTube build() {
      return new YouTube(this);
    }

    @Override
    public Builder setRootUrl(String rootUrl) {
      return (Builder) super.setRootUrl(rootUrl);
    }

    @Override
    public Builder setServicePath(String servicePath) {
      return (Builder) super.setServicePath(servicePath);
    }

    @Override
    public Builder setBatchPath(String batchPath) {
      return (Builder) super.setBatchPath(batchPath);
    }

    @Override
    public Builder setHttpRequestInitializer(com.google.api.client.http.HttpRequestInitializer httpRequestInitializer) {
      return (Builder) super.setHttpRequestInitializer(httpRequestInitializer);
    }

    @Override
    public Builder setApplicationName(String applicationName) {
      return (Builder) super.setApplicationName(applicationName);
    }

    @Override
    public Builder setSuppressPatternChecks(boolean suppressPatternChecks) {
      return (Builder) super.setSuppressPatternChecks(suppressPatternChecks);
    }

    @Override
    public Builder setSuppressRequiredParameterChecks(boolean suppressRequiredParameterChecks) {
      return (Builder) super.setSuppressRequiredParameterChecks(suppressRequiredParameterChecks);
    }

    @Override
    public Builder setSuppressAllChecks(boolean suppressAllChecks) {
      return (Builder) super.setSuppressAllChecks(suppressAllChecks);
    }

    /**
     * Set the {@link YouTubeRequestInitializer}.
     *
     * @since 1.12
     */
    public Builder setYouTubeRequestInitializer(
        YouTubeRequestInitializer youtubeRequestInitializer) {
      return (Builder) super.setGoogleClientRequestInitializer(youtubeRequestInitializer);
    }

    @Override
    public Builder setGoogleClientRequestInitializer(
        com.google.api.client.googleapis.services.GoogleClientRequestInitializer googleClientRequestInitializer) {
      return (Builder) super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
    }
  }
}
