/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-10-08 17:45:39 UTC)
 * on 2020-02-27 at 14:52:03 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.youtube.model;

/**
 * Statistics about a channel: number of subscribers, number of videos in the channel, etc.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the YouTube Data API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ChannelStatistics extends com.google.api.client.json.GenericJson {

  /**
   * The number of comments for the channel.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.math.BigInteger commentCount;

  /**
   * Whether or not the number of subscribers is shown for this user.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean hiddenSubscriberCount;

  /**
   * The number of subscribers that the channel has.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.math.BigInteger subscriberCount;

  /**
   * The number of videos uploaded to the channel.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.math.BigInteger videoCount;

  /**
   * The number of times the channel has been viewed.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.math.BigInteger viewCount;

  /**
   * The number of comments for the channel.
   * @return value or {@code null} for none
   */
  public java.math.BigInteger getCommentCount() {
    return commentCount;
  }

  /**
   * The number of comments for the channel.
   * @param commentCount commentCount or {@code null} for none
   */
  public ChannelStatistics setCommentCount(java.math.BigInteger commentCount) {
    this.commentCount = commentCount;
    return this;
  }

  /**
   * Whether or not the number of subscribers is shown for this user.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getHiddenSubscriberCount() {
    return hiddenSubscriberCount;
  }

  /**
   * Whether or not the number of subscribers is shown for this user.
   * @param hiddenSubscriberCount hiddenSubscriberCount or {@code null} for none
   */
  public ChannelStatistics setHiddenSubscriberCount(java.lang.Boolean hiddenSubscriberCount) {
    this.hiddenSubscriberCount = hiddenSubscriberCount;
    return this;
  }

  /**
   * The number of subscribers that the channel has.
   * @return value or {@code null} for none
   */
  public java.math.BigInteger getSubscriberCount() {
    return subscriberCount;
  }

  /**
   * The number of subscribers that the channel has.
   * @param subscriberCount subscriberCount or {@code null} for none
   */
  public ChannelStatistics setSubscriberCount(java.math.BigInteger subscriberCount) {
    this.subscriberCount = subscriberCount;
    return this;
  }

  /**
   * The number of videos uploaded to the channel.
   * @return value or {@code null} for none
   */
  public java.math.BigInteger getVideoCount() {
    return videoCount;
  }

  /**
   * The number of videos uploaded to the channel.
   * @param videoCount videoCount or {@code null} for none
   */
  public ChannelStatistics setVideoCount(java.math.BigInteger videoCount) {
    this.videoCount = videoCount;
    return this;
  }

  /**
   * The number of times the channel has been viewed.
   * @return value or {@code null} for none
   */
  public java.math.BigInteger getViewCount() {
    return viewCount;
  }

  /**
   * The number of times the channel has been viewed.
   * @param viewCount viewCount or {@code null} for none
   */
  public ChannelStatistics setViewCount(java.math.BigInteger viewCount) {
    this.viewCount = viewCount;
    return this;
  }

  @Override
  public ChannelStatistics set(String fieldName, Object value) {
    return (ChannelStatistics) super.set(fieldName, value);
  }

  @Override
  public ChannelStatistics clone() {
    return (ChannelStatistics) super.clone();
  }

}
