/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-10-08 17:45:39 UTC)
 * on 2020-02-27 at 14:52:03 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.youtube.model;

/**
 * A member resource represents a member for a YouTube channel. A member provides recurring monetary
 * support to a creator and receives special benefits.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the YouTube Data API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Member extends com.google.api.client.json.GenericJson {

  /**
   * Etag of this resource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String etag;

  /**
   * Identifies what kind of resource this is. Value: the fixed string "youtube#member".
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * The snippet object contains basic details about the member.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private MemberSnippet snippet;

  /**
   * Etag of this resource.
   * @return value or {@code null} for none
   */
  public java.lang.String getEtag() {
    return etag;
  }

  /**
   * Etag of this resource.
   * @param etag etag or {@code null} for none
   */
  public Member setEtag(java.lang.String etag) {
    this.etag = etag;
    return this;
  }

  /**
   * Identifies what kind of resource this is. Value: the fixed string "youtube#member".
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * Identifies what kind of resource this is. Value: the fixed string "youtube#member".
   * @param kind kind or {@code null} for none
   */
  public Member setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * The snippet object contains basic details about the member.
   * @return value or {@code null} for none
   */
  public MemberSnippet getSnippet() {
    return snippet;
  }

  /**
   * The snippet object contains basic details about the member.
   * @param snippet snippet or {@code null} for none
   */
  public Member setSnippet(MemberSnippet snippet) {
    this.snippet = snippet;
    return this;
  }

  @Override
  public Member set(String fieldName, Object value) {
    return (Member) super.set(fieldName, value);
  }

  @Override
  public Member clone() {
    return (Member) super.clone();
  }

}
