/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-10-08 17:45:39 UTC)
 * on 2020-02-27 at 14:52:03 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.youtube.model;

/**
 * A playlistItem resource identifies another resource, such as a video, that is included in a
 * playlist. In addition, the playlistItem  resource contains details about the included resource
 * that pertain specifically to how that resource is used in that playlist.
 *
 * YouTube uses playlists to identify special collections of videos for a channel, such as:   -
 * uploaded videos  - favorite videos  - positively rated (liked) videos  - watch history  - watch
 * later  To be more specific, these lists are associated with a channel, which is a collection of a
 * person, group, or company's videos, playlists, and other YouTube information.
 *
 * You can retrieve the playlist IDs for each of these lists from the  channel resource  for a given
 * channel. You can then use the   playlistItems.list method to retrieve any of those lists. You can
 * also add or remove items from those lists by calling the   playlistItems.insert and
 * playlistItems.delete methods. For example, if a user gives a positive rating to a video, you
 * would insert that video into the liked videos playlist for that user's channel.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the YouTube Data API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class PlaylistItem extends com.google.api.client.json.GenericJson {

  /**
   * The contentDetails object is included in the resource if the included item is a YouTube video.
   * The object contains additional information about the video.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private PlaylistItemContentDetails contentDetails;

  /**
   * Etag of this resource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String etag;

  /**
   * The ID that YouTube uses to uniquely identify the playlist item.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String id;

  /**
   * Identifies what kind of resource this is. Value: the fixed string "youtube#playlistItem".
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * The snippet object contains basic details about the playlist item, such as its title and
   * position in the playlist.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private PlaylistItemSnippet snippet;

  /**
   * The status object contains information about the playlist item's privacy status.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private PlaylistItemStatus status;

  /**
   * The contentDetails object is included in the resource if the included item is a YouTube video.
   * The object contains additional information about the video.
   * @return value or {@code null} for none
   */
  public PlaylistItemContentDetails getContentDetails() {
    return contentDetails;
  }

  /**
   * The contentDetails object is included in the resource if the included item is a YouTube video.
   * The object contains additional information about the video.
   * @param contentDetails contentDetails or {@code null} for none
   */
  public PlaylistItem setContentDetails(PlaylistItemContentDetails contentDetails) {
    this.contentDetails = contentDetails;
    return this;
  }

  /**
   * Etag of this resource.
   * @return value or {@code null} for none
   */
  public java.lang.String getEtag() {
    return etag;
  }

  /**
   * Etag of this resource.
   * @param etag etag or {@code null} for none
   */
  public PlaylistItem setEtag(java.lang.String etag) {
    this.etag = etag;
    return this;
  }

  /**
   * The ID that YouTube uses to uniquely identify the playlist item.
   * @return value or {@code null} for none
   */
  public java.lang.String getId() {
    return id;
  }

  /**
   * The ID that YouTube uses to uniquely identify the playlist item.
   * @param id id or {@code null} for none
   */
  public PlaylistItem setId(java.lang.String id) {
    this.id = id;
    return this;
  }

  /**
   * Identifies what kind of resource this is. Value: the fixed string "youtube#playlistItem".
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * Identifies what kind of resource this is. Value: the fixed string "youtube#playlistItem".
   * @param kind kind or {@code null} for none
   */
  public PlaylistItem setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * The snippet object contains basic details about the playlist item, such as its title and
   * position in the playlist.
   * @return value or {@code null} for none
   */
  public PlaylistItemSnippet getSnippet() {
    return snippet;
  }

  /**
   * The snippet object contains basic details about the playlist item, such as its title and
   * position in the playlist.
   * @param snippet snippet or {@code null} for none
   */
  public PlaylistItem setSnippet(PlaylistItemSnippet snippet) {
    this.snippet = snippet;
    return this;
  }

  /**
   * The status object contains information about the playlist item's privacy status.
   * @return value or {@code null} for none
   */
  public PlaylistItemStatus getStatus() {
    return status;
  }

  /**
   * The status object contains information about the playlist item's privacy status.
   * @param status status or {@code null} for none
   */
  public PlaylistItem setStatus(PlaylistItemStatus status) {
    this.status = status;
    return this;
  }

  @Override
  public PlaylistItem set(String fieldName, Object value) {
    return (PlaylistItem) super.set(fieldName, value);
  }

  @Override
  public PlaylistItem clone() {
    return (PlaylistItem) super.clone();
  }

}
