/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-10-08 17:45:39 UTC)
 * on 2020-02-27 at 14:52:03 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.youtube.model;

/**
 * Describes a single promoted item id. It is a union of various possible types.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the YouTube Data API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class PromotedItemId extends com.google.api.client.json.GenericJson {

  /**
   * If type is recentUpload, this field identifies the channel from which to take the recent
   * upload. If missing, the channel is assumed to be the same channel for which the
   * invideoPromotion is set.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String recentlyUploadedBy;

  /**
   * Describes the type of the promoted item.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String type;

  /**
   * If the promoted item represents a video, this field represents the unique YouTube ID
   * identifying it. This field will be present only if type has the value video.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String videoId;

  /**
   * If the promoted item represents a website, this field represents the url pointing to the
   * website. This field will be present only if type has the value website.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String websiteUrl;

  /**
   * If type is recentUpload, this field identifies the channel from which to take the recent
   * upload. If missing, the channel is assumed to be the same channel for which the
   * invideoPromotion is set.
   * @return value or {@code null} for none
   */
  public java.lang.String getRecentlyUploadedBy() {
    return recentlyUploadedBy;
  }

  /**
   * If type is recentUpload, this field identifies the channel from which to take the recent
   * upload. If missing, the channel is assumed to be the same channel for which the
   * invideoPromotion is set.
   * @param recentlyUploadedBy recentlyUploadedBy or {@code null} for none
   */
  public PromotedItemId setRecentlyUploadedBy(java.lang.String recentlyUploadedBy) {
    this.recentlyUploadedBy = recentlyUploadedBy;
    return this;
  }

  /**
   * Describes the type of the promoted item.
   * @return value or {@code null} for none
   */
  public java.lang.String getType() {
    return type;
  }

  /**
   * Describes the type of the promoted item.
   * @param type type or {@code null} for none
   */
  public PromotedItemId setType(java.lang.String type) {
    this.type = type;
    return this;
  }

  /**
   * If the promoted item represents a video, this field represents the unique YouTube ID
   * identifying it. This field will be present only if type has the value video.
   * @return value or {@code null} for none
   */
  public java.lang.String getVideoId() {
    return videoId;
  }

  /**
   * If the promoted item represents a video, this field represents the unique YouTube ID
   * identifying it. This field will be present only if type has the value video.
   * @param videoId videoId or {@code null} for none
   */
  public PromotedItemId setVideoId(java.lang.String videoId) {
    this.videoId = videoId;
    return this;
  }

  /**
   * If the promoted item represents a website, this field represents the url pointing to the
   * website. This field will be present only if type has the value website.
   * @return value or {@code null} for none
   */
  public java.lang.String getWebsiteUrl() {
    return websiteUrl;
  }

  /**
   * If the promoted item represents a website, this field represents the url pointing to the
   * website. This field will be present only if type has the value website.
   * @param websiteUrl websiteUrl or {@code null} for none
   */
  public PromotedItemId setWebsiteUrl(java.lang.String websiteUrl) {
    this.websiteUrl = websiteUrl;
    return this;
  }

  @Override
  public PromotedItemId set(String fieldName, Object value) {
    return (PromotedItemId) super.set(fieldName, value);
  }

  @Override
  public PromotedItemId clone() {
    return (PromotedItemId) super.clone();
  }

}
