/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-10-08 17:45:39 UTC)
 * on 2020-02-27 at 14:52:03 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.youtube.model;

/**
 * A search result contains information about a YouTube video, channel, or playlist that matches the
 * search parameters specified in an API request. While a search result points to a uniquely
 * identifiable resource, like a video, it does not have its own persistent data.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the YouTube Data API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class SearchResult extends com.google.api.client.json.GenericJson {

  /**
   * Etag of this resource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String etag;

  /**
   * The id object contains information that can be used to uniquely identify the resource that
   * matches the search request.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ResourceId id;

  /**
   * Identifies what kind of resource this is. Value: the fixed string "youtube#searchResult".
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * The snippet object contains basic details about a search result, such as its title or
   * description. For example, if the search result is a video, then the title will be the video's
   * title and the description will be the video's description.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private SearchResultSnippet snippet;

  /**
   * Etag of this resource.
   * @return value or {@code null} for none
   */
  public java.lang.String getEtag() {
    return etag;
  }

  /**
   * Etag of this resource.
   * @param etag etag or {@code null} for none
   */
  public SearchResult setEtag(java.lang.String etag) {
    this.etag = etag;
    return this;
  }

  /**
   * The id object contains information that can be used to uniquely identify the resource that
   * matches the search request.
   * @return value or {@code null} for none
   */
  public ResourceId getId() {
    return id;
  }

  /**
   * The id object contains information that can be used to uniquely identify the resource that
   * matches the search request.
   * @param id id or {@code null} for none
   */
  public SearchResult setId(ResourceId id) {
    this.id = id;
    return this;
  }

  /**
   * Identifies what kind of resource this is. Value: the fixed string "youtube#searchResult".
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * Identifies what kind of resource this is. Value: the fixed string "youtube#searchResult".
   * @param kind kind or {@code null} for none
   */
  public SearchResult setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * The snippet object contains basic details about a search result, such as its title or
   * description. For example, if the search result is a video, then the title will be the video's
   * title and the description will be the video's description.
   * @return value or {@code null} for none
   */
  public SearchResultSnippet getSnippet() {
    return snippet;
  }

  /**
   * The snippet object contains basic details about a search result, such as its title or
   * description. For example, if the search result is a video, then the title will be the video's
   * title and the description will be the video's description.
   * @param snippet snippet or {@code null} for none
   */
  public SearchResult setSnippet(SearchResultSnippet snippet) {
    this.snippet = snippet;
    return this;
  }

  @Override
  public SearchResult set(String fieldName, Object value) {
    return (SearchResult) super.set(fieldName, value);
  }

  @Override
  public SearchResult clone() {
    return (SearchResult) super.clone();
  }

}
