/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-10-08 17:45:39 UTC)
 * on 2020-02-27 at 14:52:03 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.youtube.model;

/**
 * Describes processing status and progress and availability of some other Video resource parts.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the YouTube Data API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class VideoProcessingDetails extends com.google.api.client.json.GenericJson {

  /**
   * This value indicates whether video editing suggestions, which might improve video quality or
   * the playback experience, are available for the video. You can retrieve these suggestions by
   * requesting the suggestions part in your videos.list() request.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String editorSuggestionsAvailability;

  /**
   * This value indicates whether file details are available for the uploaded video. You can
   * retrieve a video's file details by requesting the fileDetails part in your videos.list()
   * request.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String fileDetailsAvailability;

  /**
   * The reason that YouTube failed to process the video. This property will only have a value if
   * the processingStatus property's value is failed.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String processingFailureReason;

  /**
   * This value indicates whether the video processing engine has generated suggestions that might
   * improve YouTube's ability to process the the video, warnings that explain video processing
   * problems, or errors that cause video processing problems. You can retrieve these suggestions by
   * requesting the suggestions part in your videos.list() request.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String processingIssuesAvailability;

  /**
   * The processingProgress object contains information about the progress YouTube has made in
   * processing the video. The values are really only relevant if the video's processing status is
   * processing.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private VideoProcessingDetailsProcessingProgress processingProgress;

  /**
   * The video's processing status. This value indicates whether YouTube was able to process the
   * video or if the video is still being processed.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String processingStatus;

  /**
   * This value indicates whether keyword (tag) suggestions are available for the video. Tags can be
   * added to a video's metadata to make it easier for other users to find the video. You can
   * retrieve these suggestions by requesting the suggestions part in your videos.list() request.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String tagSuggestionsAvailability;

  /**
   * This value indicates whether thumbnail images have been generated for the video.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String thumbnailsAvailability;

  /**
   * This value indicates whether video editing suggestions, which might improve video quality or
   * the playback experience, are available for the video. You can retrieve these suggestions by
   * requesting the suggestions part in your videos.list() request.
   * @return value or {@code null} for none
   */
  public java.lang.String getEditorSuggestionsAvailability() {
    return editorSuggestionsAvailability;
  }

  /**
   * This value indicates whether video editing suggestions, which might improve video quality or
   * the playback experience, are available for the video. You can retrieve these suggestions by
   * requesting the suggestions part in your videos.list() request.
   * @param editorSuggestionsAvailability editorSuggestionsAvailability or {@code null} for none
   */
  public VideoProcessingDetails setEditorSuggestionsAvailability(java.lang.String editorSuggestionsAvailability) {
    this.editorSuggestionsAvailability = editorSuggestionsAvailability;
    return this;
  }

  /**
   * This value indicates whether file details are available for the uploaded video. You can
   * retrieve a video's file details by requesting the fileDetails part in your videos.list()
   * request.
   * @return value or {@code null} for none
   */
  public java.lang.String getFileDetailsAvailability() {
    return fileDetailsAvailability;
  }

  /**
   * This value indicates whether file details are available for the uploaded video. You can
   * retrieve a video's file details by requesting the fileDetails part in your videos.list()
   * request.
   * @param fileDetailsAvailability fileDetailsAvailability or {@code null} for none
   */
  public VideoProcessingDetails setFileDetailsAvailability(java.lang.String fileDetailsAvailability) {
    this.fileDetailsAvailability = fileDetailsAvailability;
    return this;
  }

  /**
   * The reason that YouTube failed to process the video. This property will only have a value if
   * the processingStatus property's value is failed.
   * @return value or {@code null} for none
   */
  public java.lang.String getProcessingFailureReason() {
    return processingFailureReason;
  }

  /**
   * The reason that YouTube failed to process the video. This property will only have a value if
   * the processingStatus property's value is failed.
   * @param processingFailureReason processingFailureReason or {@code null} for none
   */
  public VideoProcessingDetails setProcessingFailureReason(java.lang.String processingFailureReason) {
    this.processingFailureReason = processingFailureReason;
    return this;
  }

  /**
   * This value indicates whether the video processing engine has generated suggestions that might
   * improve YouTube's ability to process the the video, warnings that explain video processing
   * problems, or errors that cause video processing problems. You can retrieve these suggestions by
   * requesting the suggestions part in your videos.list() request.
   * @return value or {@code null} for none
   */
  public java.lang.String getProcessingIssuesAvailability() {
    return processingIssuesAvailability;
  }

  /**
   * This value indicates whether the video processing engine has generated suggestions that might
   * improve YouTube's ability to process the the video, warnings that explain video processing
   * problems, or errors that cause video processing problems. You can retrieve these suggestions by
   * requesting the suggestions part in your videos.list() request.
   * @param processingIssuesAvailability processingIssuesAvailability or {@code null} for none
   */
  public VideoProcessingDetails setProcessingIssuesAvailability(java.lang.String processingIssuesAvailability) {
    this.processingIssuesAvailability = processingIssuesAvailability;
    return this;
  }

  /**
   * The processingProgress object contains information about the progress YouTube has made in
   * processing the video. The values are really only relevant if the video's processing status is
   * processing.
   * @return value or {@code null} for none
   */
  public VideoProcessingDetailsProcessingProgress getProcessingProgress() {
    return processingProgress;
  }

  /**
   * The processingProgress object contains information about the progress YouTube has made in
   * processing the video. The values are really only relevant if the video's processing status is
   * processing.
   * @param processingProgress processingProgress or {@code null} for none
   */
  public VideoProcessingDetails setProcessingProgress(VideoProcessingDetailsProcessingProgress processingProgress) {
    this.processingProgress = processingProgress;
    return this;
  }

  /**
   * The video's processing status. This value indicates whether YouTube was able to process the
   * video or if the video is still being processed.
   * @return value or {@code null} for none
   */
  public java.lang.String getProcessingStatus() {
    return processingStatus;
  }

  /**
   * The video's processing status. This value indicates whether YouTube was able to process the
   * video or if the video is still being processed.
   * @param processingStatus processingStatus or {@code null} for none
   */
  public VideoProcessingDetails setProcessingStatus(java.lang.String processingStatus) {
    this.processingStatus = processingStatus;
    return this;
  }

  /**
   * This value indicates whether keyword (tag) suggestions are available for the video. Tags can be
   * added to a video's metadata to make it easier for other users to find the video. You can
   * retrieve these suggestions by requesting the suggestions part in your videos.list() request.
   * @return value or {@code null} for none
   */
  public java.lang.String getTagSuggestionsAvailability() {
    return tagSuggestionsAvailability;
  }

  /**
   * This value indicates whether keyword (tag) suggestions are available for the video. Tags can be
   * added to a video's metadata to make it easier for other users to find the video. You can
   * retrieve these suggestions by requesting the suggestions part in your videos.list() request.
   * @param tagSuggestionsAvailability tagSuggestionsAvailability or {@code null} for none
   */
  public VideoProcessingDetails setTagSuggestionsAvailability(java.lang.String tagSuggestionsAvailability) {
    this.tagSuggestionsAvailability = tagSuggestionsAvailability;
    return this;
  }

  /**
   * This value indicates whether thumbnail images have been generated for the video.
   * @return value or {@code null} for none
   */
  public java.lang.String getThumbnailsAvailability() {
    return thumbnailsAvailability;
  }

  /**
   * This value indicates whether thumbnail images have been generated for the video.
   * @param thumbnailsAvailability thumbnailsAvailability or {@code null} for none
   */
  public VideoProcessingDetails setThumbnailsAvailability(java.lang.String thumbnailsAvailability) {
    this.thumbnailsAvailability = thumbnailsAvailability;
    return this;
  }

  @Override
  public VideoProcessingDetails set(String fieldName, Object value) {
    return (VideoProcessingDetails) super.set(fieldName, value);
  }

  @Override
  public VideoProcessingDetails clone() {
    return (VideoProcessingDetails) super.clone();
  }

}
