/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.youtubeAnalytics.v2.model;

/**
 * A group's content details.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the YouTube Analytics API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class GroupContentDetails extends com.google.api.client.json.GenericJson {

  /**
   * The number of items in the group.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.math.BigInteger itemCount;

  /**
   * The type of resources that the group contains. Valid values for this property are: *
   * `youtube#channel` * `youtube#playlist` * `youtube#video` * `youtubePartner#asset`
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String itemType;

  /**
   * The number of items in the group.
   * @return value or {@code null} for none
   */
  public java.math.BigInteger getItemCount() {
    return itemCount;
  }

  /**
   * The number of items in the group.
   * @param itemCount itemCount or {@code null} for none
   */
  public GroupContentDetails setItemCount(java.math.BigInteger itemCount) {
    this.itemCount = itemCount;
    return this;
  }

  /**
   * The type of resources that the group contains. Valid values for this property are: *
   * `youtube#channel` * `youtube#playlist` * `youtube#video` * `youtubePartner#asset`
   * @return value or {@code null} for none
   */
  public java.lang.String getItemType() {
    return itemType;
  }

  /**
   * The type of resources that the group contains. Valid values for this property are: *
   * `youtube#channel` * `youtube#playlist` * `youtube#video` * `youtubePartner#asset`
   * @param itemType itemType or {@code null} for none
   */
  public GroupContentDetails setItemType(java.lang.String itemType) {
    this.itemType = itemType;
    return this;
  }

  @Override
  public GroupContentDetails set(String fieldName, Object value) {
    return (GroupContentDetails) super.set(fieldName, value);
  }

  @Override
  public GroupContentDetails clone() {
    return (GroupContentDetails) super.clone();
  }

}
