/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.youtubeAnalytics.v2.model;

/**
 * The description of a column of the result table.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the YouTube Analytics API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ResultTableColumnHeader extends com.google.api.client.json.GenericJson {

  /**
   * The type of the column (`DIMENSION` or `METRIC`).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String columnType;

  /**
   * The type of the data in the column (`STRING`, `INTEGER`, `FLOAT`, etc.).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String dataType;

  /**
   * The name of the dimension or metric.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * The type of the column (`DIMENSION` or `METRIC`).
   * @return value or {@code null} for none
   */
  public java.lang.String getColumnType() {
    return columnType;
  }

  /**
   * The type of the column (`DIMENSION` or `METRIC`).
   * @param columnType columnType or {@code null} for none
   */
  public ResultTableColumnHeader setColumnType(java.lang.String columnType) {
    this.columnType = columnType;
    return this;
  }

  /**
   * The type of the data in the column (`STRING`, `INTEGER`, `FLOAT`, etc.).
   * @return value or {@code null} for none
   */
  public java.lang.String getDataType() {
    return dataType;
  }

  /**
   * The type of the data in the column (`STRING`, `INTEGER`, `FLOAT`, etc.).
   * @param dataType dataType or {@code null} for none
   */
  public ResultTableColumnHeader setDataType(java.lang.String dataType) {
    this.dataType = dataType;
    return this;
  }

  /**
   * The name of the dimension or metric.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * The name of the dimension or metric.
   * @param name name or {@code null} for none
   */
  public ResultTableColumnHeader setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  @Override
  public ResultTableColumnHeader set(String fieldName, Object value) {
    return (ResultTableColumnHeader) super.set(fieldName, value);
  }

  @Override
  public ResultTableColumnHeader clone() {
    return (ResultTableColumnHeader) super.clone();
  }

}
