/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.services.youtubeAnalytics.v2;

import com.google.api.client.googleapis.GoogleUtils;
import com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.google.api.client.googleapis.services.GoogleClientRequestInitializer;
import com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.util.Key;
import com.google.api.client.util.Preconditions;
import com.google.api.services.youtubeAnalytics.v2.YouTubeAnalyticsRequest;
import com.google.api.services.youtubeAnalytics.v2.YouTubeAnalyticsRequestInitializer;
import com.google.api.services.youtubeAnalytics.v2.model.EmptyResponse;
import com.google.api.services.youtubeAnalytics.v2.model.Group;
import com.google.api.services.youtubeAnalytics.v2.model.GroupItem;
import com.google.api.services.youtubeAnalytics.v2.model.ListGroupItemsResponse;
import com.google.api.services.youtubeAnalytics.v2.model.ListGroupsResponse;
import com.google.api.services.youtubeAnalytics.v2.model.QueryResponse;
import java.io.IOException;

public class YouTubeAnalytics
extends AbstractGoogleJsonClient {
    public static final String DEFAULT_ROOT_URL = "https://youtubeanalytics.googleapis.com/";
    public static final String DEFAULT_MTLS_ROOT_URL = "https://youtubeanalytics.mtls.googleapis.com/";
    public static final String DEFAULT_SERVICE_PATH = "";
    public static final String DEFAULT_BATCH_PATH = "batch";
    public static final String DEFAULT_BASE_URL = "https://youtubeanalytics.googleapis.com/";

    public YouTubeAnalytics(HttpTransport transport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
        this(new Builder(transport, jsonFactory, httpRequestInitializer));
    }

    YouTubeAnalytics(Builder builder) {
        super((AbstractGoogleJsonClient.Builder)builder);
    }

    protected void initialize(AbstractGoogleClientRequest<?> httpClientRequest) throws IOException {
        super.initialize(httpClientRequest);
    }

    public GroupItems groupItems() {
        return new GroupItems();
    }

    public Groups groups() {
        return new Groups();
    }

    public Reports reports() {
        return new Reports();
    }

    static {
        Preconditions.checkState((GoogleUtils.MAJOR_VERSION == 1 && (GoogleUtils.MINOR_VERSION >= 32 || GoogleUtils.MINOR_VERSION == 31 && GoogleUtils.BUGFIX_VERSION >= 1) || GoogleUtils.MAJOR_VERSION >= 2 ? 1 : 0) != 0, (String)"You are currently running with version %s of google-api-client. You need at least version 1.31.1 of google-api-client to run version 2.0.0 of the YouTube Analytics API library.", (Object[])new Object[]{GoogleUtils.VERSION});
    }

    public static final class Builder
    extends AbstractGoogleJsonClient.Builder {
        private static String chooseEndpoint(HttpTransport transport) {
            String useMtlsEndpoint = System.getenv("GOOGLE_API_USE_MTLS_ENDPOINT");
            String string = useMtlsEndpoint = useMtlsEndpoint == null ? "auto" : useMtlsEndpoint;
            if ("always".equals(useMtlsEndpoint) || "auto".equals(useMtlsEndpoint) && transport != null && transport.isMtls()) {
                return YouTubeAnalytics.DEFAULT_MTLS_ROOT_URL;
            }
            return "https://youtubeanalytics.googleapis.com/";
        }

        public Builder(HttpTransport transport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
            super(transport, jsonFactory, Builder.chooseEndpoint(transport), YouTubeAnalytics.DEFAULT_SERVICE_PATH, httpRequestInitializer, false);
            this.setBatchPath(YouTubeAnalytics.DEFAULT_BATCH_PATH);
        }

        public YouTubeAnalytics build() {
            return new YouTubeAnalytics(this);
        }

        public Builder setRootUrl(String rootUrl) {
            return (Builder)super.setRootUrl(rootUrl);
        }

        public Builder setServicePath(String servicePath) {
            return (Builder)super.setServicePath(servicePath);
        }

        public Builder setBatchPath(String batchPath) {
            return (Builder)super.setBatchPath(batchPath);
        }

        public Builder setHttpRequestInitializer(HttpRequestInitializer httpRequestInitializer) {
            return (Builder)super.setHttpRequestInitializer(httpRequestInitializer);
        }

        public Builder setApplicationName(String applicationName) {
            return (Builder)super.setApplicationName(applicationName);
        }

        public Builder setSuppressPatternChecks(boolean suppressPatternChecks) {
            return (Builder)super.setSuppressPatternChecks(suppressPatternChecks);
        }

        public Builder setSuppressRequiredParameterChecks(boolean suppressRequiredParameterChecks) {
            return (Builder)super.setSuppressRequiredParameterChecks(suppressRequiredParameterChecks);
        }

        public Builder setSuppressAllChecks(boolean suppressAllChecks) {
            return (Builder)super.setSuppressAllChecks(suppressAllChecks);
        }

        public Builder setYouTubeAnalyticsRequestInitializer(YouTubeAnalyticsRequestInitializer youtubeanalyticsRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer((GoogleClientRequestInitializer)youtubeanalyticsRequestInitializer);
        }

        public Builder setGoogleClientRequestInitializer(GoogleClientRequestInitializer googleClientRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
        }
    }

    public class Reports {
        public Query query() throws IOException {
            Query result = new Query();
            YouTubeAnalytics.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class Query
        extends YouTubeAnalyticsRequest<QueryResponse> {
            private static final String REST_PATH = "v2/reports";
            @Key
            private String currency;
            @Key
            private String dimensions;
            @Key
            private String endDate;
            @Key
            private String filters;
            @Key
            private String ids;
            @Key
            private Boolean includeHistoricalChannelData;
            @Key
            private Integer maxResults;
            @Key
            private String metrics;
            @Key
            private String sort;
            @Key
            private String startDate;
            @Key
            private Integer startIndex;

            protected Query() {
                super(YouTubeAnalytics.this, "GET", REST_PATH, null, QueryResponse.class);
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Query set$Xgafv(String $Xgafv) {
                return (Query)super.set$Xgafv($Xgafv);
            }

            public Query setAccessToken(String accessToken) {
                return (Query)super.setAccessToken(accessToken);
            }

            public Query setAlt(String alt) {
                return (Query)super.setAlt(alt);
            }

            public Query setCallback(String callback) {
                return (Query)super.setCallback(callback);
            }

            public Query setFields(String fields) {
                return (Query)super.setFields(fields);
            }

            public Query setKey(String key) {
                return (Query)super.setKey(key);
            }

            public Query setOauthToken(String oauthToken) {
                return (Query)super.setOauthToken(oauthToken);
            }

            public Query setPrettyPrint(Boolean prettyPrint) {
                return (Query)super.setPrettyPrint(prettyPrint);
            }

            public Query setQuotaUser(String quotaUser) {
                return (Query)super.setQuotaUser(quotaUser);
            }

            public Query setUploadType(String uploadType) {
                return (Query)super.setUploadType(uploadType);
            }

            public Query setUploadProtocol(String uploadProtocol) {
                return (Query)super.setUploadProtocol(uploadProtocol);
            }

            public String getCurrency() {
                return this.currency;
            }

            public Query setCurrency(String currency) {
                this.currency = currency;
                return this;
            }

            public String getDimensions() {
                return this.dimensions;
            }

            public Query setDimensions(String dimensions) {
                this.dimensions = dimensions;
                return this;
            }

            public String getEndDate() {
                return this.endDate;
            }

            public Query setEndDate(String endDate) {
                this.endDate = endDate;
                return this;
            }

            public String getFilters() {
                return this.filters;
            }

            public Query setFilters(String filters) {
                this.filters = filters;
                return this;
            }

            public String getIds() {
                return this.ids;
            }

            public Query setIds(String ids) {
                this.ids = ids;
                return this;
            }

            public Boolean getIncludeHistoricalChannelData() {
                return this.includeHistoricalChannelData;
            }

            public Query setIncludeHistoricalChannelData(Boolean includeHistoricalChannelData) {
                this.includeHistoricalChannelData = includeHistoricalChannelData;
                return this;
            }

            public Integer getMaxResults() {
                return this.maxResults;
            }

            public Query setMaxResults(Integer maxResults) {
                this.maxResults = maxResults;
                return this;
            }

            public String getMetrics() {
                return this.metrics;
            }

            public Query setMetrics(String metrics) {
                this.metrics = metrics;
                return this;
            }

            public String getSort() {
                return this.sort;
            }

            public Query setSort(String sort) {
                this.sort = sort;
                return this;
            }

            public String getStartDate() {
                return this.startDate;
            }

            public Query setStartDate(String startDate) {
                this.startDate = startDate;
                return this;
            }

            public Integer getStartIndex() {
                return this.startIndex;
            }

            public Query setStartIndex(Integer startIndex) {
                this.startIndex = startIndex;
                return this;
            }

            @Override
            public Query set(String parameterName, Object value) {
                return (Query)super.set(parameterName, value);
            }
        }
    }

    public class Groups {
        public Delete delete() throws IOException {
            Delete result = new Delete();
            YouTubeAnalytics.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Insert insert(Group content) throws IOException {
            Insert result = new Insert(content);
            YouTubeAnalytics.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list() throws IOException {
            List result = new List();
            YouTubeAnalytics.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Update update(Group content) throws IOException {
            Update result = new Update(content);
            YouTubeAnalytics.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class Update
        extends YouTubeAnalyticsRequest<Group> {
            private static final String REST_PATH = "v2/groups";
            @Key
            private String onBehalfOfContentOwner;

            protected Update(Group content) {
                super(YouTubeAnalytics.this, "PUT", REST_PATH, (Object)content, Group.class);
            }

            public Update set$Xgafv(String $Xgafv) {
                return (Update)super.set$Xgafv($Xgafv);
            }

            public Update setAccessToken(String accessToken) {
                return (Update)super.setAccessToken(accessToken);
            }

            public Update setAlt(String alt) {
                return (Update)super.setAlt(alt);
            }

            public Update setCallback(String callback) {
                return (Update)super.setCallback(callback);
            }

            public Update setFields(String fields) {
                return (Update)super.setFields(fields);
            }

            public Update setKey(String key) {
                return (Update)super.setKey(key);
            }

            public Update setOauthToken(String oauthToken) {
                return (Update)super.setOauthToken(oauthToken);
            }

            public Update setPrettyPrint(Boolean prettyPrint) {
                return (Update)super.setPrettyPrint(prettyPrint);
            }

            public Update setQuotaUser(String quotaUser) {
                return (Update)super.setQuotaUser(quotaUser);
            }

            public Update setUploadType(String uploadType) {
                return (Update)super.setUploadType(uploadType);
            }

            public Update setUploadProtocol(String uploadProtocol) {
                return (Update)super.setUploadProtocol(uploadProtocol);
            }

            public String getOnBehalfOfContentOwner() {
                return this.onBehalfOfContentOwner;
            }

            public Update setOnBehalfOfContentOwner(String onBehalfOfContentOwner) {
                this.onBehalfOfContentOwner = onBehalfOfContentOwner;
                return this;
            }

            @Override
            public Update set(String parameterName, Object value) {
                return (Update)super.set(parameterName, value);
            }
        }

        public class List
        extends YouTubeAnalyticsRequest<ListGroupsResponse> {
            private static final String REST_PATH = "v2/groups";
            @Key
            private String id;
            @Key
            private Boolean mine;
            @Key
            private String onBehalfOfContentOwner;
            @Key
            private String pageToken;

            protected List() {
                super(YouTubeAnalytics.this, "GET", REST_PATH, null, ListGroupsResponse.class);
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String $Xgafv) {
                return (List)super.set$Xgafv($Xgafv);
            }

            public List setAccessToken(String accessToken) {
                return (List)super.setAccessToken(accessToken);
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setCallback(String callback) {
                return (List)super.setCallback(callback);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUploadType(String uploadType) {
                return (List)super.setUploadType(uploadType);
            }

            public List setUploadProtocol(String uploadProtocol) {
                return (List)super.setUploadProtocol(uploadProtocol);
            }

            public String getId() {
                return this.id;
            }

            public List setId(String id) {
                this.id = id;
                return this;
            }

            public Boolean getMine() {
                return this.mine;
            }

            public List setMine(Boolean mine) {
                this.mine = mine;
                return this;
            }

            public String getOnBehalfOfContentOwner() {
                return this.onBehalfOfContentOwner;
            }

            public List setOnBehalfOfContentOwner(String onBehalfOfContentOwner) {
                this.onBehalfOfContentOwner = onBehalfOfContentOwner;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class Insert
        extends YouTubeAnalyticsRequest<Group> {
            private static final String REST_PATH = "v2/groups";
            @Key
            private String onBehalfOfContentOwner;

            protected Insert(Group content) {
                super(YouTubeAnalytics.this, "POST", REST_PATH, (Object)content, Group.class);
            }

            public Insert set$Xgafv(String $Xgafv) {
                return (Insert)super.set$Xgafv($Xgafv);
            }

            public Insert setAccessToken(String accessToken) {
                return (Insert)super.setAccessToken(accessToken);
            }

            public Insert setAlt(String alt) {
                return (Insert)super.setAlt(alt);
            }

            public Insert setCallback(String callback) {
                return (Insert)super.setCallback(callback);
            }

            public Insert setFields(String fields) {
                return (Insert)super.setFields(fields);
            }

            public Insert setKey(String key) {
                return (Insert)super.setKey(key);
            }

            public Insert setOauthToken(String oauthToken) {
                return (Insert)super.setOauthToken(oauthToken);
            }

            public Insert setPrettyPrint(Boolean prettyPrint) {
                return (Insert)super.setPrettyPrint(prettyPrint);
            }

            public Insert setQuotaUser(String quotaUser) {
                return (Insert)super.setQuotaUser(quotaUser);
            }

            public Insert setUploadType(String uploadType) {
                return (Insert)super.setUploadType(uploadType);
            }

            public Insert setUploadProtocol(String uploadProtocol) {
                return (Insert)super.setUploadProtocol(uploadProtocol);
            }

            public String getOnBehalfOfContentOwner() {
                return this.onBehalfOfContentOwner;
            }

            public Insert setOnBehalfOfContentOwner(String onBehalfOfContentOwner) {
                this.onBehalfOfContentOwner = onBehalfOfContentOwner;
                return this;
            }

            @Override
            public Insert set(String parameterName, Object value) {
                return (Insert)super.set(parameterName, value);
            }
        }

        public class Delete
        extends YouTubeAnalyticsRequest<EmptyResponse> {
            private static final String REST_PATH = "v2/groups";
            @Key
            private String id;
            @Key
            private String onBehalfOfContentOwner;

            protected Delete() {
                super(YouTubeAnalytics.this, "DELETE", REST_PATH, null, EmptyResponse.class);
            }

            public Delete set$Xgafv(String $Xgafv) {
                return (Delete)super.set$Xgafv($Xgafv);
            }

            public Delete setAccessToken(String accessToken) {
                return (Delete)super.setAccessToken(accessToken);
            }

            public Delete setAlt(String alt) {
                return (Delete)super.setAlt(alt);
            }

            public Delete setCallback(String callback) {
                return (Delete)super.setCallback(callback);
            }

            public Delete setFields(String fields) {
                return (Delete)super.setFields(fields);
            }

            public Delete setKey(String key) {
                return (Delete)super.setKey(key);
            }

            public Delete setOauthToken(String oauthToken) {
                return (Delete)super.setOauthToken(oauthToken);
            }

            public Delete setPrettyPrint(Boolean prettyPrint) {
                return (Delete)super.setPrettyPrint(prettyPrint);
            }

            public Delete setQuotaUser(String quotaUser) {
                return (Delete)super.setQuotaUser(quotaUser);
            }

            public Delete setUploadType(String uploadType) {
                return (Delete)super.setUploadType(uploadType);
            }

            public Delete setUploadProtocol(String uploadProtocol) {
                return (Delete)super.setUploadProtocol(uploadProtocol);
            }

            public String getId() {
                return this.id;
            }

            public Delete setId(String id) {
                this.id = id;
                return this;
            }

            public String getOnBehalfOfContentOwner() {
                return this.onBehalfOfContentOwner;
            }

            public Delete setOnBehalfOfContentOwner(String onBehalfOfContentOwner) {
                this.onBehalfOfContentOwner = onBehalfOfContentOwner;
                return this;
            }

            @Override
            public Delete set(String parameterName, Object value) {
                return (Delete)super.set(parameterName, value);
            }
        }
    }

    public class GroupItems {
        public Delete delete() throws IOException {
            Delete result = new Delete();
            YouTubeAnalytics.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Insert insert(GroupItem content) throws IOException {
            Insert result = new Insert(content);
            YouTubeAnalytics.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list() throws IOException {
            List result = new List();
            YouTubeAnalytics.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class List
        extends YouTubeAnalyticsRequest<ListGroupItemsResponse> {
            private static final String REST_PATH = "v2/groupItems";
            @Key
            private String groupId;
            @Key
            private String onBehalfOfContentOwner;

            protected List() {
                super(YouTubeAnalytics.this, "GET", REST_PATH, null, ListGroupItemsResponse.class);
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String $Xgafv) {
                return (List)super.set$Xgafv($Xgafv);
            }

            public List setAccessToken(String accessToken) {
                return (List)super.setAccessToken(accessToken);
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setCallback(String callback) {
                return (List)super.setCallback(callback);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUploadType(String uploadType) {
                return (List)super.setUploadType(uploadType);
            }

            public List setUploadProtocol(String uploadProtocol) {
                return (List)super.setUploadProtocol(uploadProtocol);
            }

            public String getGroupId() {
                return this.groupId;
            }

            public List setGroupId(String groupId) {
                this.groupId = groupId;
                return this;
            }

            public String getOnBehalfOfContentOwner() {
                return this.onBehalfOfContentOwner;
            }

            public List setOnBehalfOfContentOwner(String onBehalfOfContentOwner) {
                this.onBehalfOfContentOwner = onBehalfOfContentOwner;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class Insert
        extends YouTubeAnalyticsRequest<GroupItem> {
            private static final String REST_PATH = "v2/groupItems";
            @Key
            private String onBehalfOfContentOwner;

            protected Insert(GroupItem content) {
                super(YouTubeAnalytics.this, "POST", REST_PATH, (Object)content, GroupItem.class);
            }

            public Insert set$Xgafv(String $Xgafv) {
                return (Insert)super.set$Xgafv($Xgafv);
            }

            public Insert setAccessToken(String accessToken) {
                return (Insert)super.setAccessToken(accessToken);
            }

            public Insert setAlt(String alt) {
                return (Insert)super.setAlt(alt);
            }

            public Insert setCallback(String callback) {
                return (Insert)super.setCallback(callback);
            }

            public Insert setFields(String fields) {
                return (Insert)super.setFields(fields);
            }

            public Insert setKey(String key) {
                return (Insert)super.setKey(key);
            }

            public Insert setOauthToken(String oauthToken) {
                return (Insert)super.setOauthToken(oauthToken);
            }

            public Insert setPrettyPrint(Boolean prettyPrint) {
                return (Insert)super.setPrettyPrint(prettyPrint);
            }

            public Insert setQuotaUser(String quotaUser) {
                return (Insert)super.setQuotaUser(quotaUser);
            }

            public Insert setUploadType(String uploadType) {
                return (Insert)super.setUploadType(uploadType);
            }

            public Insert setUploadProtocol(String uploadProtocol) {
                return (Insert)super.setUploadProtocol(uploadProtocol);
            }

            public String getOnBehalfOfContentOwner() {
                return this.onBehalfOfContentOwner;
            }

            public Insert setOnBehalfOfContentOwner(String onBehalfOfContentOwner) {
                this.onBehalfOfContentOwner = onBehalfOfContentOwner;
                return this;
            }

            @Override
            public Insert set(String parameterName, Object value) {
                return (Insert)super.set(parameterName, value);
            }
        }

        public class Delete
        extends YouTubeAnalyticsRequest<EmptyResponse> {
            private static final String REST_PATH = "v2/groupItems";
            @Key
            private String id;
            @Key
            private String onBehalfOfContentOwner;

            protected Delete() {
                super(YouTubeAnalytics.this, "DELETE", REST_PATH, null, EmptyResponse.class);
            }

            public Delete set$Xgafv(String $Xgafv) {
                return (Delete)super.set$Xgafv($Xgafv);
            }

            public Delete setAccessToken(String accessToken) {
                return (Delete)super.setAccessToken(accessToken);
            }

            public Delete setAlt(String alt) {
                return (Delete)super.setAlt(alt);
            }

            public Delete setCallback(String callback) {
                return (Delete)super.setCallback(callback);
            }

            public Delete setFields(String fields) {
                return (Delete)super.setFields(fields);
            }

            public Delete setKey(String key) {
                return (Delete)super.setKey(key);
            }

            public Delete setOauthToken(String oauthToken) {
                return (Delete)super.setOauthToken(oauthToken);
            }

            public Delete setPrettyPrint(Boolean prettyPrint) {
                return (Delete)super.setPrettyPrint(prettyPrint);
            }

            public Delete setQuotaUser(String quotaUser) {
                return (Delete)super.setQuotaUser(quotaUser);
            }

            public Delete setUploadType(String uploadType) {
                return (Delete)super.setUploadType(uploadType);
            }

            public Delete setUploadProtocol(String uploadProtocol) {
                return (Delete)super.setUploadProtocol(uploadProtocol);
            }

            public String getId() {
                return this.id;
            }

            public Delete setId(String id) {
                this.id = id;
                return this;
            }

            public String getOnBehalfOfContentOwner() {
                return this.onBehalfOfContentOwner;
            }

            public Delete setOnBehalfOfContentOwner(String onBehalfOfContentOwner) {
                this.onBehalfOfContentOwner = onBehalfOfContentOwner;
                return this;
            }

            @Override
            public Delete set(String parameterName, Object value) {
                return (Delete)super.set(parameterName, value);
            }
        }
    }
}

