/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.urlfetch;

import com.google.appengine.api.urlfetch.HTTPHeader;
import com.google.appengine.api.urlfetch.HTTPRequest;
import com.google.appengine.api.urlfetch.HTTPResponse;
import com.google.appengine.api.urlfetch.ResponseTooLargeException;
import com.google.appengine.api.urlfetch.URLFetchService;
import com.google.appengine.api.urlfetch.URLFetchServicePb;
import com.google.apphosting.api.ApiProxy;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;

class URLFetchServiceImpl
implements URLFetchService {
    static final String PACKAGE = "urlfetch";

    URLFetchServiceImpl() {
    }

    public HTTPResponse fetch(URL url) throws IOException {
        return this.fetch(new HTTPRequest(url));
    }

    public HTTPResponse fetch(HTTPRequest request) throws IOException {
        byte[] responseBytes;
        URLFetchServicePb.URLFetchRequest requestProto = this.convertToPb(request);
        try {
            responseBytes = ApiProxy.makeSyncCall(PACKAGE, "Fetch", requestProto.toByteArray());
        }
        catch (ApiProxy.ApplicationException ex) {
            this.handleApplicationException(requestProto, ex);
            throw new IOException("unreachable statement reached");
        }
        URLFetchServicePb.URLFetchResponse responseProto = new URLFetchServicePb.URLFetchResponse();
        responseProto.mergeFrom(responseBytes);
        if (!request.getFetchOptions().getAllowTruncate() && responseProto.isContentWasTruncated()) {
            throw new ResponseTooLargeException(request.getURL().toString());
        }
        return this.convertFromPb(responseProto);
    }

    private void handleApplicationException(URLFetchServicePb.URLFetchRequest request, ApiProxy.ApplicationException ex) throws IOException {
        URLFetchServicePb.URLFetchServiceError.ErrorCode errorCode = URLFetchServicePb.URLFetchServiceError.ErrorCode.valueOf(ex.getApplicationError());
        switch (errorCode) {
            case INVALID_URL: {
                throw new MalformedURLException(ex.getErrorDetail());
            }
            case RESPONSE_TOO_LARGE: {
                throw new ResponseTooLargeException(request.getUrl());
            }
        }
        throw new IOException(ex.getErrorDetail());
    }

    private URLFetchServicePb.URLFetchRequest convertToPb(HTTPRequest request) {
        URLFetchServicePb.URLFetchRequest requestProto = new URLFetchServicePb.URLFetchRequest();
        requestProto.setUrl(request.getURL().toExternalForm());
        byte[] payload = request.getPayload();
        if (payload != null) {
            requestProto.setPayloadAsBytes(payload);
        }
        switch (request.getMethod()) {
            case GET: {
                requestProto.setMethod(URLFetchServicePb.URLFetchRequest.RequestMethod.GET);
                break;
            }
            case POST: {
                requestProto.setMethod(URLFetchServicePb.URLFetchRequest.RequestMethod.POST);
                break;
            }
            case HEAD: {
                requestProto.setMethod(URLFetchServicePb.URLFetchRequest.RequestMethod.HEAD);
                break;
            }
            case PUT: {
                requestProto.setMethod(URLFetchServicePb.URLFetchRequest.RequestMethod.PUT);
                break;
            }
            case DELETE: {
                requestProto.setMethod(URLFetchServicePb.URLFetchRequest.RequestMethod.DELETE);
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown method: " + (Object)((Object)request.getMethod()));
            }
        }
        for (HTTPHeader header : request.getHeaders()) {
            URLFetchServicePb.URLFetchRequest.Header headerProto = requestProto.addHeader();
            headerProto.setKey(header.getName());
            headerProto.setValue(header.getValue());
        }
        requestProto.setFollowRedirects(request.getFetchOptions().getFollowRedirects());
        return requestProto;
    }

    private HTTPResponse convertFromPb(URLFetchServicePb.URLFetchResponse responseProto) {
        HTTPResponse response = new HTTPResponse(responseProto.getStatusCode());
        if (responseProto.hasContent()) {
            response.setContent(responseProto.getContentAsBytes());
        }
        for (URLFetchServicePb.URLFetchResponse.Header header : responseProto.headers()) {
            response.addHeader(header.getKey(), header.getValue());
        }
        return response;
    }
}

