/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.datastore;

import com.google.appengine.api.datastore.Transaction;
import com.google.appengine.api.datastore.TransactionStack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.Future;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TransactionStackImpl
implements TransactionStack {
    private final ThreadLocalTransactionStack stack;

    public TransactionStackImpl() {
        this(new ThreadLocalTransactionStack.StaticMember());
    }

    TransactionStackImpl(ThreadLocalTransactionStack stack) {
        this.stack = stack;
    }

    @Override
    public void push(Transaction txn) {
        if (txn == null) {
            throw new NullPointerException("txn cannot be null");
        }
        this.getStack().txns.addFirst(txn);
        this.getStack().txnIdToFutures.put(txn.getId(), new LinkedHashSet());
    }

    Transaction pop() {
        try {
            Transaction txn = this.getStack().txns.removeFirst();
            this.getStack().txnIdToFutures.remove(txn.getId());
            return txn;
        }
        catch (NoSuchElementException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void remove(Transaction txn) {
        if (!this.getStack().txns.remove(txn)) {
            throw new IllegalStateException("Attempted to deregister a transaction that is not currently registered.");
        }
        this.getStack().txnIdToFutures.remove(txn.getId());
    }

    @Override
    public Transaction peek() {
        try {
            return this.getStack().txns.getFirst();
        }
        catch (NoSuchElementException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public Transaction peek(Transaction returnedIfNoTxn) {
        LinkedList<Transaction> txns = this.getStack().txns;
        Transaction txn = txns.isEmpty() ? null : txns.peek();
        return txn == null ? returnedIfNoTxn : txn;
    }

    @Override
    public Collection<Transaction> getAll() {
        return new ArrayList<Transaction>(this.getStack().txns);
    }

    TransactionData getStack() {
        return this.stack.get();
    }

    @Override
    public void clearAll() {
        this.getStack().clear();
    }

    @Override
    public void addFuture(Transaction txn, Future<?> future) {
        TransactionData td = this.getStack();
        LinkedHashSet<Future<?>> futures = td.txnIdToFutures.get(txn.getId());
        if (futures == null) {
            throw new IllegalStateException("Attempted to associate a future with a transaction that is not currently registered.");
        }
        futures.add(future);
    }

    @Override
    public LinkedHashSet<Future<?>> getFutures(Transaction txn) {
        LinkedHashSet<Future<?>> futures = this.getStack().txnIdToFutures.get(txn.getId());
        if (futures == null) {
            throw new IllegalStateException("Attempted to get futures for a transaction that is not currently registered.");
        }
        return futures;
    }

    static final class TransactionData {
        final LinkedList<Transaction> txns = new LinkedList();
        final Map<String, LinkedHashSet<Future<?>>> txnIdToFutures = new HashMap();

        TransactionData() {
        }

        void clear() {
            this.txns.clear();
            this.txnIdToFutures.clear();
        }
    }

    static interface ThreadLocalTransactionStack {
        public TransactionData get();

        public static class StaticMember
        implements ThreadLocalTransactionStack {
            private static final ThreadLocal<TransactionData> STACK = new ThreadLocal<TransactionData>(){

                @Override
                protected TransactionData initialValue() {
                    return new TransactionData();
                }
            };

            public TransactionData get() {
                return STACK.get();
            }
        }
    }
}

