/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.datastore;

import com.google.appengine.api.datastore.Key;
import com.google.appengine.api.datastore.KeyFactory;
import java.io.Serializable;
import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class KeyRange
implements Iterable<Key>,
Serializable {
    static final long serialVersionUID = 962890261927141064L;
    private final Key parent;
    private final String kind;
    private final Key start;
    private final Key end;

    public KeyRange(Key parent, String kind, long start, long end) {
        if (parent != null && !parent.isComplete()) {
            throw new IllegalArgumentException("Invalid parent: not a complete key");
        }
        if (kind == null || kind.equals("")) {
            throw new IllegalArgumentException("Invalid kind: cannot be null or empty");
        }
        if (start < 1L) {
            throw new IllegalArgumentException("Illegal start " + start + ": less than 1");
        }
        if (end < start) {
            throw new IllegalArgumentException("Illegal end " + end + ": less than start " + start);
        }
        this.parent = parent;
        this.kind = kind;
        this.start = KeyFactory.createKey(parent, kind, start);
        this.end = KeyFactory.createKey(parent, kind, end);
    }

    private KeyRange() {
        this.parent = null;
        this.kind = null;
        this.start = null;
        this.end = null;
    }

    Key getParent() {
        return this.parent;
    }

    String getKind() {
        return this.kind;
    }

    public Key getStart() {
        return this.start;
    }

    public Key getEnd() {
        return this.end;
    }

    public long getSize() {
        return this.end.getId() - this.start.getId() + 1L;
    }

    @Override
    public Iterator<Key> iterator() {
        return new IdRangeIterator();
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof KeyRange)) {
            return false;
        }
        KeyRange that = (KeyRange)obj;
        return this.start.equals(that.start) && this.end.equals(that.end);
    }

    public int hashCode() {
        return 31 * this.start.hashCode() + this.end.hashCode();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class IdRangeIterator
    implements Iterator<Key> {
        private long next;

        private IdRangeIterator() {
            this.next = KeyRange.this.start.getId();
        }

        @Override
        public boolean hasNext() {
            return this.next <= KeyRange.this.end.getId();
        }

        @Override
        public Key next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return KeyFactory.createKey(KeyRange.this.parent, KeyRange.this.kind, this.next++);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

