/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.conversion;

import com.google.appengine.api.conversion.Conversion;
import com.google.appengine.api.conversion.ConversionErrorCode;
import com.google.appengine.api.conversion.ConversionHelper;
import com.google.appengine.api.conversion.ConversionResult;
import com.google.appengine.api.conversion.ConversionService;
import com.google.appengine.api.conversion.ConversionServiceException;
import com.google.appengine.api.conversion.ConversionServicePb;
import com.google.appengine.api.utils.FutureWrapper;
import com.google.appengine.repackaged.com.google.common.collect.Lists;
import com.google.apphosting.api.ApiProxy;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

class ConversionServiceImpl
implements ConversionService {
    static final String CONVERSION_SERVICE = "conversion";
    static final String CONVERT_METHOD = "Convert";
    private final Double deadline;

    ConversionServiceImpl() {
        this.deadline = null;
    }

    ConversionServiceImpl(double deadline) {
        this.deadline = deadline;
    }

    @Override
    public ConversionResult convert(Conversion conversion) {
        List<ConversionResult> results = this.convert(Arrays.asList(conversion));
        return results.get(0);
    }

    @Override
    public List<ConversionResult> convert(List<Conversion> conversions) {
        try {
            return this.convertAsync(conversions).get();
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof ConversionServiceException) {
                throw (ConversionServiceException)e.getCause();
            }
            throw new ConversionServiceException(ConversionErrorCode.INTERNAL_ERROR, e.getMessage());
        }
        catch (InterruptedException e) {
            throw new ConversionServiceException(ConversionErrorCode.INTERNAL_ERROR, e.getMessage());
        }
    }

    @Override
    public Future<ConversionResult> convertAsync(Conversion conversion) {
        ConversionServicePb.ConversionRequest request = ConversionHelper.toConversionRequestProto(Arrays.asList(conversion));
        Future<byte[]> responseBytes = ApiProxy.makeAsyncCall(CONVERSION_SERVICE, CONVERT_METHOD, request.toByteArray(), this.createApiConfig(this.deadline));
        return new ConversionFutureWrapper<byte[], ConversionResult>(responseBytes){

            @Override
            protected ConversionResult wrap(byte[] responseBytes) throws IOException {
                ConversionServicePb.ConversionResponse.Builder response = (ConversionServicePb.ConversionResponse.Builder)ConversionServicePb.ConversionResponse.newBuilder().mergeFrom(responseBytes);
                return ConversionHelper.fromConversionOutputProto(response.getResultList().get(0));
            }
        };
    }

    @Override
    public Future<List<ConversionResult>> convertAsync(List<Conversion> conversions) {
        ConversionServicePb.ConversionRequest request = ConversionHelper.toConversionRequestProto(conversions);
        Future<byte[]> responseBytes = ApiProxy.makeAsyncCall(CONVERSION_SERVICE, CONVERT_METHOD, request.toByteArray(), this.createApiConfig(this.deadline));
        return new ConversionFutureWrapper<byte[], List<ConversionResult>>(responseBytes){

            @Override
            protected List<ConversionResult> wrap(byte[] responseBytes) throws IOException {
                ConversionServicePb.ConversionResponse.Builder response = (ConversionServicePb.ConversionResponse.Builder)ConversionServicePb.ConversionResponse.newBuilder().mergeFrom(responseBytes);
                ArrayList<ConversionResult> results = Lists.newArrayList();
                for (ConversionServicePb.ConversionOutput result : response.getResultList()) {
                    results.add(ConversionHelper.fromConversionOutputProto(result));
                }
                return results;
            }
        };
    }

    private ApiProxy.ApiConfig createApiConfig(Double deadline) {
        ApiProxy.ApiConfig apiConfig = new ApiProxy.ApiConfig();
        apiConfig.setDeadlineInSeconds(deadline);
        return apiConfig;
    }

    private static abstract class ConversionFutureWrapper<K, V>
    extends FutureWrapper<K, V> {
        ConversionFutureWrapper(Future<K> parent) {
            super(parent);
        }

        @Override
        protected Throwable convertException(Throwable cause) {
            if (cause instanceof ApiProxy.ApplicationException) {
                ApiProxy.ApplicationException e = (ApiProxy.ApplicationException)cause;
                return new ConversionServiceException(ConversionErrorCode.intToEnum(e.getApplicationError()), e.getErrorDetail());
            }
            if (cause instanceof ApiProxy.ApiDeadlineExceededException) {
                return new ConversionServiceException(ConversionErrorCode.TIMEOUT, cause.getMessage());
            }
            return cause;
        }
    }
}

