/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.datastore;

import com.google.appengine.api.datastore.AbstractIterator;
import com.google.appengine.api.datastore.BasePreparedQuery;
import com.google.appengine.api.datastore.DatastoreServiceConfig;
import com.google.appengine.api.datastore.Entity;
import com.google.appengine.api.datastore.EntityFilter;
import com.google.appengine.api.datastore.EntityProtoComparators;
import com.google.appengine.api.datastore.FetchOptions;
import com.google.appengine.api.datastore.Key;
import com.google.appengine.api.datastore.MultiQueryBuilder;
import com.google.appengine.api.datastore.PreparedQuery;
import com.google.appengine.api.datastore.PreparedQueryImpl;
import com.google.appengine.api.datastore.Query;
import com.google.appengine.api.datastore.QueryTranslator;
import com.google.appengine.api.datastore.SlicingIterator;
import com.google.appengine.api.datastore.Transaction;
import com.google.apphosting.api.ApiProxy;
import com.google.apphosting.api.DatastorePb;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.PriorityQueue;
import java.util.Set;

class PreparedMultiQuery
extends BasePreparedQuery.UncompilablePreparedQuery {
    private final ApiProxy.ApiConfig apiConfig;
    private final DatastoreServiceConfig datastoreServiceConfig;
    private final MultiQueryBuilder queryBuilder;
    private final EntityComparator entityComparator;
    private final Transaction txn;

    PreparedMultiQuery(ApiProxy.ApiConfig apiConfig, DatastoreServiceConfig datastoreServiceConfig, MultiQueryBuilder queryBuilder, Transaction txn) {
        this.apiConfig = apiConfig;
        this.datastoreServiceConfig = datastoreServiceConfig;
        this.txn = txn;
        this.queryBuilder = queryBuilder;
        if (queryBuilder.hasParallelQueries()) {
            if (queryBuilder.isKeysOnly()) {
                for (Query.SortPredicate sp : queryBuilder.getSortPredicates()) {
                    if (sp.getPropertyName().equals("__key__")) continue;
                    throw new IllegalArgumentException("The provided keys-only multi-query needs to perform some sorting in memory.  As a result, this query can only be sorted by the key property as this is the only property that is available in memory.");
                }
            }
            this.entityComparator = new EntityComparator(queryBuilder.getSortPredicates());
        } else {
            this.entityComparator = null;
        }
    }

    protected List<PreparedQuery> prepareQueries(List<Query> queries) {
        ArrayList<PreparedQuery> preparedQueries = new ArrayList<PreparedQuery>(queries.size());
        for (Query q : queries) {
            preparedQueries.add(new PreparedQueryImpl(this.apiConfig, this.datastoreServiceConfig, q, this.txn));
        }
        return preparedQueries;
    }

    Iterator<Entity> makeHeapIterator(List<PreparedQuery> preparedQueries, FetchOptions fetchOptions) {
        PriorityQueue<EntitySource> heap = new PriorityQueue<EntitySource>();
        for (PreparedQuery pq : preparedQueries) {
            Iterator<Entity> iter = pq.asIterator(fetchOptions);
            if (!iter.hasNext()) continue;
            heap.add(new EntitySource(this.entityComparator, iter));
        }
        return new HeapIterator(heap);
    }

    static Entity nextResult(PriorityQueue<EntitySource> availableEntitySources) {
        EntitySource current = availableEntitySources.poll();
        if (current == null) {
            return null;
        }
        Entity result = current.currentEntity;
        current.advance();
        if (current.currentEntity != null) {
            availableEntitySources.add(current);
        }
        return result;
    }

    @Override
    public Entity asSingleEntity() throws PreparedQuery.TooManyResultsException {
        List<Entity> result = this.asList(FetchOptions.Builder.withLimit(2));
        if (result.size() == 1) {
            return result.get(0);
        }
        if (result.size() > 1) {
            throw new PreparedQuery.TooManyResultsException();
        }
        return null;
    }

    @Override
    public int countEntities(FetchOptions fetchOptions) {
        FetchOptions overrideOptions = new FetchOptions(fetchOptions);
        if (fetchOptions.getOffset() != null) {
            overrideOptions.clearOffset();
            if (fetchOptions.getLimit() != null) {
                int adjustedLimit = fetchOptions.getOffset() + fetchOptions.getLimit();
                if (adjustedLimit < 0) {
                    overrideOptions.clearLimit();
                } else {
                    overrideOptions.limit(adjustedLimit);
                }
            }
        }
        Integer adjustedLimit = overrideOptions.getLimit();
        int result = 0;
        block0: for (List<Query> queries : this.queryBuilder) {
            List<PreparedQuery> preparedQueries = this.prepareQueries(queries);
            for (PreparedQuery query : preparedQueries) {
                result += query.countEntities(overrideOptions);
                if (adjustedLimit == null) continue;
                if (result >= adjustedLimit) {
                    result = adjustedLimit;
                    continue block0;
                }
                overrideOptions.limit(adjustedLimit - result);
            }
        }
        return fetchOptions.getOffset() == null ? result : Math.max(0, result - fetchOptions.getOffset());
    }

    @Override
    public Iterator<Entity> asIterator(FetchOptions fetchOptions) {
        if (fetchOptions.getOffset() != null || fetchOptions.getLimit() != null) {
            FetchOptions override = new FetchOptions(fetchOptions);
            if (fetchOptions.getOffset() != null) {
                override.clearOffset();
                if (fetchOptions.getLimit() != null) {
                    override.limit(fetchOptions.getOffset() + fetchOptions.getLimit());
                }
            }
            return new SlicingIterator<Entity>(new FilteredMultiQueryIterator(override), fetchOptions.getOffset(), fetchOptions.getLimit());
        }
        return new FilteredMultiQueryIterator(fetchOptions);
    }

    @Override
    public List<Entity> asList(FetchOptions fetchOptions) {
        FetchOptions override = new FetchOptions(fetchOptions);
        if (override.getPrefetchSize() == null) {
            override.prefetchSize(Integer.MAX_VALUE);
        }
        if (override.getChunkSize() == null) {
            override.chunkSize(Integer.MAX_VALUE);
        }
        ArrayList<Entity> results = new ArrayList<Entity>();
        for (Entity e : this.asIterable(override)) {
            results.add(e);
        }
        return results;
    }

    static final class EntityComparator
    implements Comparator<Entity> {
        private final EntityProtoComparators.EntityProtoComparator delegate;

        EntityComparator(List<Query.SortPredicate> sortPreds) {
            this.delegate = new EntityProtoComparators.EntityProtoComparator(EntityComparator.sortPredicatesToOrders(sortPreds));
        }

        private static List<DatastorePb.Query.Order> sortPredicatesToOrders(List<Query.SortPredicate> sortPreds) {
            ArrayList<DatastorePb.Query.Order> orders = new ArrayList<DatastorePb.Query.Order>();
            for (Query.SortPredicate sp : sortPreds) {
                orders.add(QueryTranslator.convertSortPredicateToPb(sp));
            }
            return orders;
        }

        @Override
        public int compare(Entity e1, Entity e2) {
            return this.delegate.compare(e1.getEntityProto(), e2.getEntityProto());
        }
    }

    static final class EntitySource
    implements Comparable<EntitySource> {
        private final EntityComparator entityComparator;
        private final Iterator<Entity> source;
        private Entity currentEntity;

        EntitySource(EntityComparator entityComparator, Iterator<Entity> source) {
            this.entityComparator = entityComparator;
            this.source = source;
            if (!source.hasNext()) {
                throw new IllegalArgumentException("Source iterator has no data.");
            }
            this.currentEntity = source.next();
        }

        private void advance() {
            this.currentEntity = this.source.hasNext() ? this.source.next() : null;
        }

        @Override
        public int compareTo(EntitySource entitySource) {
            return this.entityComparator.compare(this.currentEntity, entitySource.currentEntity);
        }
    }

    static final class HeapIterator
    extends AbstractIterator<Entity> {
        private final PriorityQueue<EntitySource> heap;

        HeapIterator(PriorityQueue<EntitySource> heap) {
            this.heap = heap;
        }

        @Override
        protected Entity computeNext() {
            Entity result = PreparedMultiQuery.nextResult(this.heap);
            if (result == null) {
                this.endOfData();
            }
            return result;
        }
    }

    private class FilteredMultiQueryIterator
    extends AbstractIterator<Entity> {
        private final Iterator<List<Query>> multiQueryIterator;
        private final FetchOptions baseFetchOptions;
        private final Set<Key> returnedKeys = new HashSet<Key>();
        private final Set<EntityFilter> entityFilters;
        private Iterator<Entity> currentIterator = new Iterator<Entity>(){

            @Override
            public boolean hasNext() {
                return false;
            }

            @Override
            public Entity next() {
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new NoSuchElementException();
            }
        };

        public FilteredMultiQueryIterator(FetchOptions fetchOptions) {
            this.multiQueryIterator = PreparedMultiQuery.this.queryBuilder.iterator();
            this.baseFetchOptions = fetchOptions;
            this.entityFilters = new HashSet<EntityFilter>(PreparedMultiQuery.this.queryBuilder.getEntityFilters());
            this.entityFilters.add(new EntityFilter(){

                @Override
                public boolean apply(Entity entity) {
                    return FilteredMultiQueryIterator.this.returnedKeys.add(entity.getKey());
                }
            });
        }

        private FetchOptions getFetchOptions() {
            if (this.baseFetchOptions.getLimit() != null) {
                int limit = this.baseFetchOptions.getLimit() - this.returnedKeys.size();
                if (limit > 0) {
                    return new FetchOptions(this.baseFetchOptions).clearLimit().limit(limit);
                }
                return null;
            }
            return this.baseFetchOptions;
        }

        Iterator<Entity> getNextIterator() {
            FetchOptions fetchOptions = this.getFetchOptions();
            if (fetchOptions == null) {
                return null;
            }
            while (this.multiQueryIterator.hasNext()) {
                List<PreparedQuery> queries = PreparedMultiQuery.this.prepareQueries(this.multiQueryIterator.next());
                Iterator<Entity> result = queries.size() == 1 ? queries.get(0).asIterator(fetchOptions) : PreparedMultiQuery.this.makeHeapIterator(queries, fetchOptions);
                if (!result.hasNext()) continue;
                return result;
            }
            return null;
        }

        @Override
        protected Entity computeNext() {
            Entity result = null;
            do {
                if (this.currentIterator.hasNext()) continue;
                this.currentIterator = this.getNextIterator();
                if (this.currentIterator != null) continue;
                this.endOfData();
                return null;
            } while (!this.passesFilters(result = this.currentIterator.next()));
            return result;
        }

        private boolean passesFilters(Entity result) {
            for (EntityFilter filter : this.entityFilters) {
                if (filter.apply(result)) continue;
                return false;
            }
            return true;
        }
    }
}

