/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.rdbms;

import com.google.appengine.repackaged.com.google.protobuf.InvalidProtocolBufferException;
import com.google.appengine.repackaged.com.google.protobuf.Message;
import com.google.appengine.repackaged.com.google.protobuf.MessageLite;
import com.google.apphosting.api.ApiProxy;
import com.google.cloud.sql.jdbc.internal.Exceptions;
import com.google.cloud.sql.jdbc.internal.SqlProtoClient;
import com.google.cloud.sql.jdbc.internal.SqlRpc;
import com.google.cloud.sql.jdbc.internal.SqlRpcOptions;
import com.google.cloud.sql.jdbc.internal.SqlState;
import com.google.protos.cloud.sql.CloseConnectionRequest;
import com.google.protos.cloud.sql.CloseConnectionResponse;
import com.google.protos.cloud.sql.ExecOpRequest;
import com.google.protos.cloud.sql.ExecOpResponse;
import com.google.protos.cloud.sql.ExecRequest;
import com.google.protos.cloud.sql.ExecResponse;
import com.google.protos.cloud.sql.MetadataRequest;
import com.google.protos.cloud.sql.MetadataResponse;
import com.google.protos.cloud.sql.OpenConnectionRequest;
import com.google.protos.cloud.sql.OpenConnectionResponse;
import java.sql.SQLException;

class RdbmsApiProxyClient
extends SqlProtoClient {
    static final String PACKAGE = "rdbms";

    RdbmsApiProxyClient(ApiProxy.ApiConfig apiConfig, String rdbmsInstance) {
        super(rdbmsInstance, new ApiProxyBlockingInterface(apiConfig));
    }

    static final class ApiProxyBlockingInterface
    implements SqlRpc {
        private final ApiProxy.ApiConfig apiConfig;

        ApiProxyBlockingInterface(ApiProxy.ApiConfig apiConfig) {
            this.apiConfig = apiConfig;
        }

        @Override
        public ExecResponse exec(SqlRpcOptions options, ExecRequest request) throws SQLException {
            return this.makeSyncCall("Exec", request, ExecResponse.newBuilder()).build();
        }

        @Override
        public ExecOpResponse execOp(SqlRpcOptions options, ExecOpRequest request) throws SQLException {
            return this.makeSyncCall("ExecOp", request, ExecOpResponse.newBuilder()).build();
        }

        @Override
        public MetadataResponse getMetadata(SqlRpcOptions options, MetadataRequest request) throws SQLException {
            return this.makeSyncCall("GetMetadata", request, MetadataResponse.newBuilder()).build();
        }

        @Override
        public OpenConnectionResponse openConnection(SqlRpcOptions options, OpenConnectionRequest request) throws SQLException {
            return this.makeSyncCall("OpenConnection", request, OpenConnectionResponse.newBuilder()).build();
        }

        @Override
        public CloseConnectionResponse closeConnection(SqlRpcOptions options, CloseConnectionRequest request) throws SQLException {
            return this.makeSyncCall("CloseConnection", request, CloseConnectionResponse.newBuilder()).build();
        }

        <T extends Message.Builder> T makeSyncCall(String method, MessageLite request, T responseBuilder) throws SQLException {
            block5: {
                try {
                    byte[] responseBytes = ApiProxy.makeSyncCall(RdbmsApiProxyClient.PACKAGE, method, request.toByteArray(), this.apiConfig);
                    if (responseBytes == null) break block5;
                    try {
                        responseBuilder.mergeFrom(responseBytes);
                    }
                    catch (InvalidProtocolBufferException e) {
                        throw new SQLException(e.getMessage(), e);
                    }
                }
                catch (ApiProxy.ApiDeadlineExceededException exception) {
                    throw Exceptions.newTimeoutException();
                }
                catch (ApiProxy.ApplicationException exception) {
                    String sqlstate = method.equals("OpenConnection") ? SqlState.forOpenConnectionError(exception.getApplicationError()) : SqlState.forError(exception.getApplicationError());
                    throw new SQLException(exception.getErrorDetail(), sqlstate, exception.getApplicationError());
                }
            }
            return responseBuilder;
        }
    }
}

