/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.search;

import com.google.appengine.api.search.DocumentChecker;
import com.google.appengine.api.search.Field;
import com.google.appengine.api.search.FieldChecker;
import com.google.appengine.api.search.Preconditions;
import com.google.appengine.api.search.Util;
import com.google.apphosting.api.search.DocumentPb;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public final class Document
implements Serializable {
    private static final int MAX_FIELDS_TO_STRING = 10;
    private static final long serialVersionUID = 309382038422977263L;
    private static final long MILLIS_UP_TO_1ST_JAN_2011 = 1293840000000L;
    private final String documentId;
    private final Map<String, List<Field>> fieldMap;
    private final List<Field> fields;
    private final int orderId;
    private final Locale locale;

    private Document(Builder builder) {
        this.documentId = builder.documentId;
        this.fieldMap = new HashMap<String, List<Field>>(builder.fieldMap);
        this.fields = Collections.unmodifiableList(builder.fields);
        this.locale = builder.locale;
        this.orderId = Util.defaultIfNull(builder.orderId, Document.getNumberOfSecondsSince());
        this.checkValid();
    }

    public Iterable<Field> getFields() {
        return this.fields;
    }

    public Set<String> getFieldNames() {
        return Collections.unmodifiableSet(this.fieldMap.keySet());
    }

    public Iterable<Field> getField(String name) {
        List<Field> fieldsForName = this.fieldMap.get(name);
        if (fieldsForName == null) {
            return null;
        }
        return Collections.unmodifiableList(fieldsForName);
    }

    public Field getOnlyField(String name) {
        List<Field> fieldsForName = this.fieldMap.get(name);
        Preconditions.checkArgument(fieldsForName != null && fieldsForName.size() == 1, "There is not exactly one field for name %s", name);
        return fieldsForName.get(0);
    }

    public String getId() {
        return this.documentId;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public int getOrderId() {
        return this.orderId;
    }

    public int hashCode() {
        return this.documentId.hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Document)) {
            return false;
        }
        Document doc = (Document)object;
        return this.documentId.equals(doc.getId());
    }

    private Document checkValid() {
        if (this.documentId != null) {
            DocumentChecker.checkDocumentId(this.documentId);
        }
        Preconditions.checkArgument(this.fieldMap != null, "Null map of fields in document for indexing");
        Preconditions.checkArgument(this.fields != null, "Null list of fields in document for indexing");
        return this;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    static Builder newBuilder(DocumentPb.Document.Builder builder) {
        return Document.newBuilder(builder.build());
    }

    static Builder newBuilder(DocumentPb.Document document) {
        Builder docBuilder = Document.newBuilder().setId(document.getId());
        if (document.hasLanguage()) {
            docBuilder.setLocale(FieldChecker.parseLocale(document.getLanguage()));
        }
        for (DocumentPb.Field field : document.getFieldList()) {
            docBuilder.addField(Field.newBuilder(field));
        }
        if (document.hasOrderId()) {
            docBuilder.setOrderId(document.getOrderId());
        }
        return docBuilder;
    }

    private static int getNumberOfSecondsSince() {
        long millisSince = Math.max(0L, (System.currentTimeMillis() - 1293840000000L) / 1000L);
        Preconditions.checkArgument(millisSince <= Integer.MAX_VALUE, "API failure due to date conversion overflow");
        return (int)millisSince;
    }

    DocumentPb.Document copyToProtocolBuffer() {
        DocumentPb.Document.Builder docBuilder = DocumentPb.Document.newBuilder();
        if (this.documentId != null) {
            docBuilder.setId(this.documentId);
        }
        if (this.locale != null) {
            docBuilder.setLanguage(this.locale.toString());
        }
        for (Field field : this.fields) {
            docBuilder.addField(field.copyToProtocolBuffer());
        }
        docBuilder.setOrderId(this.orderId);
        return DocumentChecker.checkValid(docBuilder.build());
    }

    public String toString() {
        return String.format("Document(documentId=%s, fields=%s%s, orderId=%d)", this.documentId, Util.iterableToString(this.fields, 10), Util.fieldToString("locale", this.locale), this.orderId);
    }

    public static final class Builder {
        private final Map<String, List<Field>> fieldMap = new HashMap<String, List<Field>>();
        private final List<Field> fields = new ArrayList<Field>();
        private String documentId;
        private Locale locale;
        private Integer orderId;

        private Builder() {
        }

        public Builder setId(String documentId) {
            if (documentId != null) {
                this.documentId = DocumentChecker.checkDocumentId(documentId);
            }
            return this;
        }

        public Builder addField(Field.Builder builder) {
            Preconditions.checkNotNull(builder, "field builder cannot be null");
            return this.addField(builder.build());
        }

        public Builder addField(Field field) {
            Preconditions.checkNotNull(field, "field cannot be null");
            this.fields.add(field);
            List<Field> fieldsForName = this.fieldMap.get(field.getName());
            if (fieldsForName == null) {
                fieldsForName = new ArrayList<Field>();
                this.fieldMap.put(field.getName(), fieldsForName);
            }
            fieldsForName.add(field);
            return this;
        }

        public Builder setLocale(Locale locale) {
            this.locale = locale;
            return this;
        }

        public Builder setOrderId(int orderId) {
            this.orderId = orderId;
            return this;
        }

        public Document build() {
            return new Document(this);
        }
    }
}

