/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.search;

import com.google.appengine.api.search.FieldChecker;
import com.google.appengine.api.search.SearchServicePb;

public class FieldExpression {
    private final String name;
    private final String expression;

    private FieldExpression(Builder builder) {
        this.name = FieldChecker.checkFieldName(builder.name);
        this.expression = builder.expression;
    }

    public String getName() {
        return this.name;
    }

    public String getExpression() {
        return this.expression;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    SearchServicePb.FieldSpec.Expression.Builder copyToProtocolBuffer() {
        SearchServicePb.FieldSpec.Expression.Builder builder = SearchServicePb.FieldSpec.Expression.newBuilder();
        builder.setName(this.getName());
        builder.setExpression(this.getExpression());
        return builder;
    }

    public String toString() {
        return String.format("FieldExpression(name=%s, expression=%s)", this.name, this.expression);
    }

    public static final class Builder {
        private String name;
        private String expression;

        public Builder setName(String name) {
            this.name = FieldChecker.checkFieldName(name);
            return this;
        }

        public Builder setExpression(String expression) {
            this.expression = FieldChecker.checkExpression(expression);
            return this;
        }

        public FieldExpression build() {
            return new FieldExpression(this);
        }
    }
}

