/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.search;

import com.google.appengine.api.search.Field;
import com.google.appengine.api.search.SearchServicePb;
import com.google.apphosting.api.search.DocumentPb;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class Schema {
    private final Map<String, List<Field.FieldType>> fieldMap;

    Schema(Map<String, List<Field.FieldType>> fieldMap) {
        this.fieldMap = Collections.unmodifiableMap(fieldMap);
    }

    public Set<String> getFieldNames() {
        return this.fieldMap.keySet();
    }

    public List<Field.FieldType> getFieldTypes(String fieldName) {
        return Collections.unmodifiableList(this.fieldMap.get(fieldName));
    }

    public String toString() {
        return String.format("Schema(fieldMap=%s)", this.fieldMap);
    }

    static Schema createSchema(SearchServicePb.IndexMetadata metadata) {
        if (metadata.getFieldCount() == 0) {
            return null;
        }
        HashMap<String, List<Field.FieldType>> fieldMap = new HashMap<String, List<Field.FieldType>>();
        for (DocumentPb.FieldTypes fieldTypes : metadata.getFieldList()) {
            List<Field.FieldType> types;
            String fieldName = fieldTypes.getName();
            if (fieldMap.containsKey(fieldName)) {
                types = (List)fieldMap.get(fieldName);
            } else {
                types = new ArrayList();
                fieldMap.put(fieldName, types);
            }
            block8: for (DocumentPb.FieldValue.ContentType type : fieldTypes.getTypeList()) {
                switch (type) {
                    case TEXT: {
                        types.add(Field.FieldType.TEXT);
                        continue block8;
                    }
                    case HTML: {
                        types.add(Field.FieldType.HTML);
                        continue block8;
                    }
                    case ATOM: {
                        types.add(Field.FieldType.ATOM);
                        continue block8;
                    }
                    case DATE: {
                        types.add(Field.FieldType.DATE);
                        continue block8;
                    }
                    case NUMBER: {
                        types.add(Field.FieldType.NUMBER);
                        continue block8;
                    }
                }
                throw new IllegalArgumentException("Unsupported field type " + type);
            }
        }
        return new Schema(fieldMap);
    }

    public int hashCode() {
        return ((Object)this.fieldMap).hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return ((Object)this.fieldMap).equals(((Schema)obj).fieldMap);
    }
}

